/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.charniak;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.parser.charniak.CharniakScoredParsesReaderWriter;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.IterableIterator;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class CharniakParser {
    private static final Logger logger = Logger.getLogger(CharniakParser.class.getName());
    private static final String CHARNIAK_DIR = "/u/nlp/packages/bllip-parser/";
    private static final String CHARNIAK_BIN = "/u/nlp/packages/bllip-parser/reranking-parser.sh";
    private static final String CHARNIAK_PARSING_MODEL = "/u/nlp/packages/bllip-parser-models/selftrained/parser/";
    private final CharniakScoredParsesReaderWriter scoredParsesReaderWriter = new CharniakScoredParsesReaderWriter();
    private String parserExecutable = "/u/nlp/packages/bllip-parser/reranking-parser.sh";
    private String parserModel = "/u/nlp/packages/bllip-parser-models/selftrained/parser/";
    private int maxSentenceLength = 400;
    private int beamSize = 0;

    public CharniakParser() {
    }

    public CharniakParser(String parserExecutable, String parserModel) {
        this.parserExecutable = parserExecutable;
        this.parserModel = parserModel;
    }

    public int getBeamSize() {
        return this.beamSize;
    }

    public void setBeamSize(int beamSize) {
        this.beamSize = beamSize;
    }

    public int getMaxSentenceLength() {
        return this.maxSentenceLength;
    }

    public void setMaxSentenceLength(int maxSentenceLength) {
        this.maxSentenceLength = maxSentenceLength;
    }

    public Tree getBestParse(List<? extends HasWord> sentence) {
        ScoredObject<Tree> scoredParse = this.getBestScoredParse(sentence);
        return scoredParse != null ? scoredParse.object() : null;
    }

    public ScoredObject<Tree> getBestScoredParse(List<? extends HasWord> sentence) {
        List<ScoredObject<Tree>> kBestParses = this.getKBestParses(sentence, 1);
        if (kBestParses != null) {
            return kBestParses.get(0);
        }
        return null;
    }

    public List<ScoredObject<Tree>> getKBestParses(List<? extends HasWord> sentence, int k) {
        return this.getKBestParses(sentence, k, true);
    }

    public List<ScoredObject<Tree>> getKBestParses(List<? extends HasWord> sentence, int k, boolean deleteTempFiles) {
        try {
            File inFile = File.createTempFile("charniak.", ".in");
            if (deleteTempFiles) {
                inFile.deleteOnExit();
            }
            File outFile = File.createTempFile("charniak.", ".out");
            if (deleteTempFiles) {
                outFile.deleteOnExit();
            }
            File errFile = File.createTempFile("charniak.", ".err");
            if (deleteTempFiles) {
                errFile.deleteOnExit();
            }
            this.printSentence(sentence, inFile.getAbsolutePath());
            this.runCharniak(k, inFile.getAbsolutePath(), outFile.getAbsolutePath(), errFile.getAbsolutePath());
            Iterable<List<ScoredObject<Tree>>> iter = this.scoredParsesReaderWriter.readScoredTrees(outFile.getAbsolutePath());
            if (deleteTempFiles) {
                inFile.delete();
                outFile.delete();
                errFile.delete();
            }
            return iter.iterator().next();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Iterable<List<ScoredObject<Tree>>> getKBestParses(Iterable<List<? extends HasWord>> sentences, int k) {
        return this.getKBestParses(sentences, k, true);
    }

    public Iterable<List<ScoredObject<Tree>>> getKBestParses(Iterable<List<? extends HasWord>> sentences, int k, boolean deleteTempFiles) {
        try {
            File inFile = File.createTempFile("charniak.", ".in");
            if (deleteTempFiles) {
                inFile.deleteOnExit();
            }
            File outFile = File.createTempFile("charniak.", ".out");
            if (deleteTempFiles) {
                outFile.deleteOnExit();
            }
            File errFile = File.createTempFile("charniak.", ".err");
            if (deleteTempFiles) {
                errFile.deleteOnExit();
            }
            this.printSentences(sentences, inFile.getAbsolutePath());
            this.runCharniak(k, inFile.getAbsolutePath(), outFile.getAbsolutePath(), errFile.getAbsolutePath());
            Iterable<List<ScoredObject<Tree>>> iter = this.scoredParsesReaderWriter.readScoredTrees(outFile.getAbsolutePath());
            if (deleteTempFiles) {
                inFile.delete();
                outFile.delete();
                errFile.delete();
            }
            return new IterableIterator<List<ScoredObject<Tree>>>(iter.iterator());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void printSentence(List<? extends HasWord> sentence, String filename) {
        ArrayList<List<? extends HasWord>> sentences = new ArrayList<List<? extends HasWord>>();
        sentences.add(sentence);
        this.printSentences(sentences, filename);
    }

    public void printSentences(Iterable<List<? extends HasWord>> sentences, String filename) {
        try {
            PrintWriter pw = IOUtils.getPrintWriter(filename);
            for (List<? extends HasWord> sentence : sentences) {
                pw.print("<s> ");
                String sentString = Sentence.listToString(sentence);
                if (sentence.size() > this.maxSentenceLength) {
                    logger.warning("Sentence length=" + sentence.size() + " is longer than maximum set length " + this.maxSentenceLength);
                    logger.warning("Long Sentence: " + sentString);
                }
                pw.print(sentString);
                pw.println(" </s>");
            }
            pw.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void runCharniak(int n, String infile, String outfile, String errfile) {
        try {
            if (n == 1) {
                ++n;
            }
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.parserExecutable);
            args.add("-l" + this.maxSentenceLength);
            args.add("-K");
            args.add("-N" + n);
            if (this.beamSize > 0) {
                args.add("-T" + this.beamSize);
            }
            args.add(this.parserModel);
            args.add(infile);
            ProcessBuilder process = new ProcessBuilder(args);
            PrintWriter out2 = IOUtils.getPrintWriter(outfile);
            PrintWriter err2 = IOUtils.getPrintWriter(errfile);
            SystemUtils.run(process, out2, err2);
            out2.close();
            err2.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

