/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CoreMapSequenceMatcher<T extends CoreMap>
extends SequenceMatcher<T> {
    protected static final Function<List<? extends CoreMap>, String> COREMAP_LIST_TO_STRING_CONVERTER = new Function<List<? extends CoreMap>, String>(){

        @Override
        public String apply(List<? extends CoreMap> in) {
            return in != null ? ChunkAnnotationUtils.getTokenText(in, CoreAnnotations.TextAnnotation.class) : null;
        }
    };

    public CoreMapSequenceMatcher(SequencePattern<T> pattern, List<? extends T> tokens) {
        super(pattern, tokens);
    }

    public void annotateGroup(Map<String, String> attributes) {
        this.annotateGroup(0, attributes);
    }

    public void annotateGroup(int group, Map<String, String> attributes) {
        int groupStart = this.start(group);
        if (groupStart >= 0) {
            int groupEnd = this.end(group);
            ChunkAnnotationUtils.annotateChunks(this.elements, groupStart, groupEnd, attributes);
        }
    }

    public List<CoreMap> getMergedList() {
        return this.getMergedList(0);
    }

    public List<CoreMap> getMergedList(int ... groups) {
        ArrayList<CoreMap> res = new ArrayList<CoreMap>();
        int last = 0;
        List<Integer> orderedGroups = CollectionUtils.asList(groups);
        Collections.sort(orderedGroups);
        for (int group : orderedGroups) {
            int groupStart = this.start(group);
            if (groupStart < last) continue;
            res.addAll(this.elements.subList(last, groupStart));
            int groupEnd = this.end(group);
            if (groupEnd - groupStart < 1) continue;
            CoreMap merged = this.createMergedChunk(groupStart, groupEnd);
            res.add(merged);
            last = groupEnd;
        }
        res.addAll(this.elements.subList(last, this.elements.size()));
        return res;
    }

    public CoreMap mergeGroup() {
        return this.mergeGroup(0);
    }

    private CoreMap createMergedChunk(int groupStart, int groupEnd) {
        CoreMap merged = null;
        if (merged == null) {
            merged = ChunkAnnotationUtils.getMergedChunk((List<? extends CoreMap>)this.elements, groupStart, groupEnd, CoreMapAttributeAggregator.getDefaultAggregators());
        }
        return merged;
    }

    public CoreMap mergeGroup(int group) {
        int groupEnd;
        int groupStart = this.start(group);
        if (groupStart >= 0 && (groupEnd = this.end(group)) - groupStart >= 1) {
            return this.createMergedChunk(groupStart, groupEnd);
        }
        return null;
    }

    public static class BasicCoreMapSequenceMatcher
    extends CoreMapSequenceMatcher<CoreMap> {
        CoreMap annotation;

        public BasicCoreMapSequenceMatcher(SequencePattern<CoreMap> pattern, CoreMap annotation) {
            super(pattern, (List)annotation.get(CoreAnnotations.TokensAnnotation.class));
            this.annotation = annotation;
            this.nodesToStringConverter = COREMAP_LIST_TO_STRING_CONVERTER;
        }
    }
}

