# Generated by Django 3.0.14 on 2021-11-03 10:46

from django.db import migrations
from core.models import RoleRight, Role


def forwards_func(apps, schema_editor):
    # Add enrollment officer right to read location data

    # Enrollment officer is predefined system role with id 1
    eo_role = Role.objects.filter(is_system=1, validity_to__isnull=True).get()
    # Required Role ID is gql_query_location_perm (121901)
    right_id = 121901
    RoleRight(
        role_id=eo_role.id,
        right_id=right_id,
        audit_user_id=None,
    ).save()


def reverse_func(apps, schema_editor):
    # Same data as in forward function
    eo_role = Role.objects.filter(is_system=1, validity_to__isnull=True).get()
    right_id = 121901
    RoleRight.objects.filter(role_id=eo_role.id, right_id=right_id, validity_to__isnull=True).delete()


class Migration(migrations.Migration):

    dependencies = [
        ("location", "0007_auto_20211103_1046"),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
    ]
