"""
This is for (string) constants used in the objective module.
"""


MODE_FUN = 'mode_fun'  # mode for function values
MODE_RES = 'mode_res'  # mode for residuals
FVAL = 'fval'  # function value
GRAD = 'grad'  # gradient
HESS = 'hess'  # Hessian
HESSP = 'hessp'  # Hessian vector product
RES = 'res'  # residual
SRES = 'sres'  # residual sensitivities
RDATAS = 'rdatas'  # returned simulated data sets

TIME = 'time'  # time
N_FVAL = 'n_fval'  # number of function evaluations
N_GRAD = 'n_grad'  # number of gradient evaluations
N_HESS = 'n_hess'  # number of Hessian evaluations
N_RES = 'n_res'  # number of residual evaluations
N_SRES = 'n_sres'  # number of residual sensitivity evaluations
CHI2 = 'chi2'  # chi2 value
SCHI2 = 'schi2'  # chi2 value gradient
X = 'x'
X0 = 'x0'
