# coding: utf-8

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from nodeum_sdk.configuration import Configuration


class TapeStat(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'log_time': 'str',
        'barcode': 'str',
        'mounts': 'int',
        'datasets_written': 'int',
        'datasets_read': 'int',
        'recovered_write_data_errors': 'int',
        'unrecovered_write_data_errors': 'int',
        'write_servo_errors': 'int',
        'unrecovered_write_servo_errors': 'int',
        'recovered_read_errors': 'int',
        'unrecovered_read_errors': 'int',
        'last_mount_unrecovered_write_errors': 'int',
        'last_mount_unrecovered_read_errors': 'int',
        'last_mount_mbytes_written': 'int',
        'last_mount_mbytes_read': 'int',
        'lifetime_mbytes_written': 'int',
        'lifetime_mbytes_read': 'int',
        'last_load_write_compression_ratio': 'int',
        'last_load_read_compression_ratio': 'int',
        'medium_mount_time': 'int',
        'medium_ready_time': 'int',
        'total_native_capacity': 'int',
        'total_used_native_capacity': 'int',
        'write_protect': 'int',
        'worm': 'int',
        'beginning_of_medium_passes': 'int',
        'middle_of_tape_passes': 'int',
        'read_compression_ratio': 'int',
        'write_compression_ratio': 'int',
        'mbytes_transferred_to_app_client': 'int',
        'bytes_transferred_to_app_client': 'int',
        'mbytes_read_from_medium': 'int',
        'bytes_read_from_medium': 'int',
        'mbytes_transferred_from_app_client': 'int',
        'bytes_transferred_from_app_client': 'int',
        'mbytes_written_to_medium': 'int',
        'bytes_written_to_medium': 'int',
        'data_compression_enabled': 'int',
        'write_retries': 'int',
        'write_perms': 'int',
        'suspended_writes': 'int',
        'fatal_suspended_writes': 'int',
        'read_retries': 'int',
        'read_perms': 'int',
        'suspended_reads': 'int',
        'fatal_suspended_reads': 'int',
        'partition_0_remaining_capacity': 'int',
        'partition_1_remaining_capacity': 'int',
        'partition_0_maximum_capacity': 'int',
        'partition_1_maximum_capacity': 'int'
    }

    attribute_map = {
        'log_time': 'log_time',
        'barcode': 'barcode',
        'mounts': 'mounts',
        'datasets_written': 'datasets_written',
        'datasets_read': 'datasets_read',
        'recovered_write_data_errors': 'recovered_write_data_errors',
        'unrecovered_write_data_errors': 'unrecovered_write_data_errors',
        'write_servo_errors': 'write_servo_errors',
        'unrecovered_write_servo_errors': 'unrecovered_write_servo_errors',
        'recovered_read_errors': 'recovered_read_errors',
        'unrecovered_read_errors': 'unrecovered_read_errors',
        'last_mount_unrecovered_write_errors': 'last_mount_unrecovered_write_errors',
        'last_mount_unrecovered_read_errors': 'last_mount_unrecovered_read_errors',
        'last_mount_mbytes_written': 'last_mount_mbytes_written',
        'last_mount_mbytes_read': 'last_mount_mbytes_read',
        'lifetime_mbytes_written': 'lifetime_mbytes_written',
        'lifetime_mbytes_read': 'lifetime_mbytes_read',
        'last_load_write_compression_ratio': 'last_load_write_compression_ratio',
        'last_load_read_compression_ratio': 'last_load_read_compression_ratio',
        'medium_mount_time': 'medium_mount_time',
        'medium_ready_time': 'medium_ready_time',
        'total_native_capacity': 'total_native_capacity',
        'total_used_native_capacity': 'total_used_native_capacity',
        'write_protect': 'write_protect',
        'worm': 'worm',
        'beginning_of_medium_passes': 'beginning_of_medium_passes',
        'middle_of_tape_passes': 'middle_of_tape_passes',
        'read_compression_ratio': 'read_compression_ratio',
        'write_compression_ratio': 'write_compression_ratio',
        'mbytes_transferred_to_app_client': 'mbytes_transferred_to_app_client',
        'bytes_transferred_to_app_client': 'bytes_transferred_to_app_client',
        'mbytes_read_from_medium': 'mbytes_read_from_medium',
        'bytes_read_from_medium': 'bytes_read_from_medium',
        'mbytes_transferred_from_app_client': 'mbytes_transferred_from_app_client',
        'bytes_transferred_from_app_client': 'bytes_transferred_from_app_client',
        'mbytes_written_to_medium': 'mbytes_written_to_medium',
        'bytes_written_to_medium': 'bytes_written_to_medium',
        'data_compression_enabled': 'data_compression_enabled',
        'write_retries': 'write_retries',
        'write_perms': 'write_perms',
        'suspended_writes': 'suspended_writes',
        'fatal_suspended_writes': 'fatal_suspended_writes',
        'read_retries': 'read_retries',
        'read_perms': 'read_perms',
        'suspended_reads': 'suspended_reads',
        'fatal_suspended_reads': 'fatal_suspended_reads',
        'partition_0_remaining_capacity': 'partition_0_remaining_capacity',
        'partition_1_remaining_capacity': 'partition_1_remaining_capacity',
        'partition_0_maximum_capacity': 'partition_0_maximum_capacity',
        'partition_1_maximum_capacity': 'partition_1_maximum_capacity'
    }

    def __init__(self, log_time=None, barcode=None, mounts=None, datasets_written=None, datasets_read=None, recovered_write_data_errors=None, unrecovered_write_data_errors=None, write_servo_errors=None, unrecovered_write_servo_errors=None, recovered_read_errors=None, unrecovered_read_errors=None, last_mount_unrecovered_write_errors=None, last_mount_unrecovered_read_errors=None, last_mount_mbytes_written=None, last_mount_mbytes_read=None, lifetime_mbytes_written=None, lifetime_mbytes_read=None, last_load_write_compression_ratio=None, last_load_read_compression_ratio=None, medium_mount_time=None, medium_ready_time=None, total_native_capacity=None, total_used_native_capacity=None, write_protect=None, worm=None, beginning_of_medium_passes=None, middle_of_tape_passes=None, read_compression_ratio=None, write_compression_ratio=None, mbytes_transferred_to_app_client=None, bytes_transferred_to_app_client=None, mbytes_read_from_medium=None, bytes_read_from_medium=None, mbytes_transferred_from_app_client=None, bytes_transferred_from_app_client=None, mbytes_written_to_medium=None, bytes_written_to_medium=None, data_compression_enabled=None, write_retries=None, write_perms=None, suspended_writes=None, fatal_suspended_writes=None, read_retries=None, read_perms=None, suspended_reads=None, fatal_suspended_reads=None, partition_0_remaining_capacity=None, partition_1_remaining_capacity=None, partition_0_maximum_capacity=None, partition_1_maximum_capacity=None, local_vars_configuration=None):  # noqa: E501
        """TapeStat - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._log_time = None
        self._barcode = None
        self._mounts = None
        self._datasets_written = None
        self._datasets_read = None
        self._recovered_write_data_errors = None
        self._unrecovered_write_data_errors = None
        self._write_servo_errors = None
        self._unrecovered_write_servo_errors = None
        self._recovered_read_errors = None
        self._unrecovered_read_errors = None
        self._last_mount_unrecovered_write_errors = None
        self._last_mount_unrecovered_read_errors = None
        self._last_mount_mbytes_written = None
        self._last_mount_mbytes_read = None
        self._lifetime_mbytes_written = None
        self._lifetime_mbytes_read = None
        self._last_load_write_compression_ratio = None
        self._last_load_read_compression_ratio = None
        self._medium_mount_time = None
        self._medium_ready_time = None
        self._total_native_capacity = None
        self._total_used_native_capacity = None
        self._write_protect = None
        self._worm = None
        self._beginning_of_medium_passes = None
        self._middle_of_tape_passes = None
        self._read_compression_ratio = None
        self._write_compression_ratio = None
        self._mbytes_transferred_to_app_client = None
        self._bytes_transferred_to_app_client = None
        self._mbytes_read_from_medium = None
        self._bytes_read_from_medium = None
        self._mbytes_transferred_from_app_client = None
        self._bytes_transferred_from_app_client = None
        self._mbytes_written_to_medium = None
        self._bytes_written_to_medium = None
        self._data_compression_enabled = None
        self._write_retries = None
        self._write_perms = None
        self._suspended_writes = None
        self._fatal_suspended_writes = None
        self._read_retries = None
        self._read_perms = None
        self._suspended_reads = None
        self._fatal_suspended_reads = None
        self._partition_0_remaining_capacity = None
        self._partition_1_remaining_capacity = None
        self._partition_0_maximum_capacity = None
        self._partition_1_maximum_capacity = None
        self.discriminator = None

        if log_time is not None:
            self.log_time = log_time
        if barcode is not None:
            self.barcode = barcode
        if mounts is not None:
            self.mounts = mounts
        if datasets_written is not None:
            self.datasets_written = datasets_written
        if datasets_read is not None:
            self.datasets_read = datasets_read
        if recovered_write_data_errors is not None:
            self.recovered_write_data_errors = recovered_write_data_errors
        if unrecovered_write_data_errors is not None:
            self.unrecovered_write_data_errors = unrecovered_write_data_errors
        if write_servo_errors is not None:
            self.write_servo_errors = write_servo_errors
        if unrecovered_write_servo_errors is not None:
            self.unrecovered_write_servo_errors = unrecovered_write_servo_errors
        if recovered_read_errors is not None:
            self.recovered_read_errors = recovered_read_errors
        if unrecovered_read_errors is not None:
            self.unrecovered_read_errors = unrecovered_read_errors
        if last_mount_unrecovered_write_errors is not None:
            self.last_mount_unrecovered_write_errors = last_mount_unrecovered_write_errors
        if last_mount_unrecovered_read_errors is not None:
            self.last_mount_unrecovered_read_errors = last_mount_unrecovered_read_errors
        if last_mount_mbytes_written is not None:
            self.last_mount_mbytes_written = last_mount_mbytes_written
        if last_mount_mbytes_read is not None:
            self.last_mount_mbytes_read = last_mount_mbytes_read
        if lifetime_mbytes_written is not None:
            self.lifetime_mbytes_written = lifetime_mbytes_written
        if lifetime_mbytes_read is not None:
            self.lifetime_mbytes_read = lifetime_mbytes_read
        if last_load_write_compression_ratio is not None:
            self.last_load_write_compression_ratio = last_load_write_compression_ratio
        if last_load_read_compression_ratio is not None:
            self.last_load_read_compression_ratio = last_load_read_compression_ratio
        if medium_mount_time is not None:
            self.medium_mount_time = medium_mount_time
        if medium_ready_time is not None:
            self.medium_ready_time = medium_ready_time
        if total_native_capacity is not None:
            self.total_native_capacity = total_native_capacity
        if total_used_native_capacity is not None:
            self.total_used_native_capacity = total_used_native_capacity
        if write_protect is not None:
            self.write_protect = write_protect
        if worm is not None:
            self.worm = worm
        if beginning_of_medium_passes is not None:
            self.beginning_of_medium_passes = beginning_of_medium_passes
        if middle_of_tape_passes is not None:
            self.middle_of_tape_passes = middle_of_tape_passes
        if read_compression_ratio is not None:
            self.read_compression_ratio = read_compression_ratio
        if write_compression_ratio is not None:
            self.write_compression_ratio = write_compression_ratio
        if mbytes_transferred_to_app_client is not None:
            self.mbytes_transferred_to_app_client = mbytes_transferred_to_app_client
        if bytes_transferred_to_app_client is not None:
            self.bytes_transferred_to_app_client = bytes_transferred_to_app_client
        if mbytes_read_from_medium is not None:
            self.mbytes_read_from_medium = mbytes_read_from_medium
        if bytes_read_from_medium is not None:
            self.bytes_read_from_medium = bytes_read_from_medium
        if mbytes_transferred_from_app_client is not None:
            self.mbytes_transferred_from_app_client = mbytes_transferred_from_app_client
        if bytes_transferred_from_app_client is not None:
            self.bytes_transferred_from_app_client = bytes_transferred_from_app_client
        if mbytes_written_to_medium is not None:
            self.mbytes_written_to_medium = mbytes_written_to_medium
        if bytes_written_to_medium is not None:
            self.bytes_written_to_medium = bytes_written_to_medium
        if data_compression_enabled is not None:
            self.data_compression_enabled = data_compression_enabled
        if write_retries is not None:
            self.write_retries = write_retries
        if write_perms is not None:
            self.write_perms = write_perms
        if suspended_writes is not None:
            self.suspended_writes = suspended_writes
        if fatal_suspended_writes is not None:
            self.fatal_suspended_writes = fatal_suspended_writes
        if read_retries is not None:
            self.read_retries = read_retries
        if read_perms is not None:
            self.read_perms = read_perms
        if suspended_reads is not None:
            self.suspended_reads = suspended_reads
        if fatal_suspended_reads is not None:
            self.fatal_suspended_reads = fatal_suspended_reads
        if partition_0_remaining_capacity is not None:
            self.partition_0_remaining_capacity = partition_0_remaining_capacity
        if partition_1_remaining_capacity is not None:
            self.partition_1_remaining_capacity = partition_1_remaining_capacity
        if partition_0_maximum_capacity is not None:
            self.partition_0_maximum_capacity = partition_0_maximum_capacity
        if partition_1_maximum_capacity is not None:
            self.partition_1_maximum_capacity = partition_1_maximum_capacity

    @property
    def log_time(self):
        """Gets the log_time of this TapeStat.  # noqa: E501


        :return: The log_time of this TapeStat.  # noqa: E501
        :rtype: str
        """
        return self._log_time

    @log_time.setter
    def log_time(self, log_time):
        """Sets the log_time of this TapeStat.


        :param log_time: The log_time of this TapeStat.  # noqa: E501
        :type: str
        """

        self._log_time = log_time

    @property
    def barcode(self):
        """Gets the barcode of this TapeStat.  # noqa: E501


        :return: The barcode of this TapeStat.  # noqa: E501
        :rtype: str
        """
        return self._barcode

    @barcode.setter
    def barcode(self, barcode):
        """Sets the barcode of this TapeStat.


        :param barcode: The barcode of this TapeStat.  # noqa: E501
        :type: str
        """

        self._barcode = barcode

    @property
    def mounts(self):
        """Gets the mounts of this TapeStat.  # noqa: E501


        :return: The mounts of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._mounts

    @mounts.setter
    def mounts(self, mounts):
        """Sets the mounts of this TapeStat.


        :param mounts: The mounts of this TapeStat.  # noqa: E501
        :type: int
        """

        self._mounts = mounts

    @property
    def datasets_written(self):
        """Gets the datasets_written of this TapeStat.  # noqa: E501


        :return: The datasets_written of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._datasets_written

    @datasets_written.setter
    def datasets_written(self, datasets_written):
        """Sets the datasets_written of this TapeStat.


        :param datasets_written: The datasets_written of this TapeStat.  # noqa: E501
        :type: int
        """

        self._datasets_written = datasets_written

    @property
    def datasets_read(self):
        """Gets the datasets_read of this TapeStat.  # noqa: E501


        :return: The datasets_read of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._datasets_read

    @datasets_read.setter
    def datasets_read(self, datasets_read):
        """Sets the datasets_read of this TapeStat.


        :param datasets_read: The datasets_read of this TapeStat.  # noqa: E501
        :type: int
        """

        self._datasets_read = datasets_read

    @property
    def recovered_write_data_errors(self):
        """Gets the recovered_write_data_errors of this TapeStat.  # noqa: E501


        :return: The recovered_write_data_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._recovered_write_data_errors

    @recovered_write_data_errors.setter
    def recovered_write_data_errors(self, recovered_write_data_errors):
        """Sets the recovered_write_data_errors of this TapeStat.


        :param recovered_write_data_errors: The recovered_write_data_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._recovered_write_data_errors = recovered_write_data_errors

    @property
    def unrecovered_write_data_errors(self):
        """Gets the unrecovered_write_data_errors of this TapeStat.  # noqa: E501


        :return: The unrecovered_write_data_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._unrecovered_write_data_errors

    @unrecovered_write_data_errors.setter
    def unrecovered_write_data_errors(self, unrecovered_write_data_errors):
        """Sets the unrecovered_write_data_errors of this TapeStat.


        :param unrecovered_write_data_errors: The unrecovered_write_data_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._unrecovered_write_data_errors = unrecovered_write_data_errors

    @property
    def write_servo_errors(self):
        """Gets the write_servo_errors of this TapeStat.  # noqa: E501


        :return: The write_servo_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._write_servo_errors

    @write_servo_errors.setter
    def write_servo_errors(self, write_servo_errors):
        """Sets the write_servo_errors of this TapeStat.


        :param write_servo_errors: The write_servo_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._write_servo_errors = write_servo_errors

    @property
    def unrecovered_write_servo_errors(self):
        """Gets the unrecovered_write_servo_errors of this TapeStat.  # noqa: E501


        :return: The unrecovered_write_servo_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._unrecovered_write_servo_errors

    @unrecovered_write_servo_errors.setter
    def unrecovered_write_servo_errors(self, unrecovered_write_servo_errors):
        """Sets the unrecovered_write_servo_errors of this TapeStat.


        :param unrecovered_write_servo_errors: The unrecovered_write_servo_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._unrecovered_write_servo_errors = unrecovered_write_servo_errors

    @property
    def recovered_read_errors(self):
        """Gets the recovered_read_errors of this TapeStat.  # noqa: E501


        :return: The recovered_read_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._recovered_read_errors

    @recovered_read_errors.setter
    def recovered_read_errors(self, recovered_read_errors):
        """Sets the recovered_read_errors of this TapeStat.


        :param recovered_read_errors: The recovered_read_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._recovered_read_errors = recovered_read_errors

    @property
    def unrecovered_read_errors(self):
        """Gets the unrecovered_read_errors of this TapeStat.  # noqa: E501


        :return: The unrecovered_read_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._unrecovered_read_errors

    @unrecovered_read_errors.setter
    def unrecovered_read_errors(self, unrecovered_read_errors):
        """Sets the unrecovered_read_errors of this TapeStat.


        :param unrecovered_read_errors: The unrecovered_read_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._unrecovered_read_errors = unrecovered_read_errors

    @property
    def last_mount_unrecovered_write_errors(self):
        """Gets the last_mount_unrecovered_write_errors of this TapeStat.  # noqa: E501


        :return: The last_mount_unrecovered_write_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._last_mount_unrecovered_write_errors

    @last_mount_unrecovered_write_errors.setter
    def last_mount_unrecovered_write_errors(self, last_mount_unrecovered_write_errors):
        """Sets the last_mount_unrecovered_write_errors of this TapeStat.


        :param last_mount_unrecovered_write_errors: The last_mount_unrecovered_write_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._last_mount_unrecovered_write_errors = last_mount_unrecovered_write_errors

    @property
    def last_mount_unrecovered_read_errors(self):
        """Gets the last_mount_unrecovered_read_errors of this TapeStat.  # noqa: E501


        :return: The last_mount_unrecovered_read_errors of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._last_mount_unrecovered_read_errors

    @last_mount_unrecovered_read_errors.setter
    def last_mount_unrecovered_read_errors(self, last_mount_unrecovered_read_errors):
        """Sets the last_mount_unrecovered_read_errors of this TapeStat.


        :param last_mount_unrecovered_read_errors: The last_mount_unrecovered_read_errors of this TapeStat.  # noqa: E501
        :type: int
        """

        self._last_mount_unrecovered_read_errors = last_mount_unrecovered_read_errors

    @property
    def last_mount_mbytes_written(self):
        """Gets the last_mount_mbytes_written of this TapeStat.  # noqa: E501


        :return: The last_mount_mbytes_written of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._last_mount_mbytes_written

    @last_mount_mbytes_written.setter
    def last_mount_mbytes_written(self, last_mount_mbytes_written):
        """Sets the last_mount_mbytes_written of this TapeStat.


        :param last_mount_mbytes_written: The last_mount_mbytes_written of this TapeStat.  # noqa: E501
        :type: int
        """

        self._last_mount_mbytes_written = last_mount_mbytes_written

    @property
    def last_mount_mbytes_read(self):
        """Gets the last_mount_mbytes_read of this TapeStat.  # noqa: E501


        :return: The last_mount_mbytes_read of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._last_mount_mbytes_read

    @last_mount_mbytes_read.setter
    def last_mount_mbytes_read(self, last_mount_mbytes_read):
        """Sets the last_mount_mbytes_read of this TapeStat.


        :param last_mount_mbytes_read: The last_mount_mbytes_read of this TapeStat.  # noqa: E501
        :type: int
        """

        self._last_mount_mbytes_read = last_mount_mbytes_read

    @property
    def lifetime_mbytes_written(self):
        """Gets the lifetime_mbytes_written of this TapeStat.  # noqa: E501


        :return: The lifetime_mbytes_written of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._lifetime_mbytes_written

    @lifetime_mbytes_written.setter
    def lifetime_mbytes_written(self, lifetime_mbytes_written):
        """Sets the lifetime_mbytes_written of this TapeStat.


        :param lifetime_mbytes_written: The lifetime_mbytes_written of this TapeStat.  # noqa: E501
        :type: int
        """

        self._lifetime_mbytes_written = lifetime_mbytes_written

    @property
    def lifetime_mbytes_read(self):
        """Gets the lifetime_mbytes_read of this TapeStat.  # noqa: E501


        :return: The lifetime_mbytes_read of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._lifetime_mbytes_read

    @lifetime_mbytes_read.setter
    def lifetime_mbytes_read(self, lifetime_mbytes_read):
        """Sets the lifetime_mbytes_read of this TapeStat.


        :param lifetime_mbytes_read: The lifetime_mbytes_read of this TapeStat.  # noqa: E501
        :type: int
        """

        self._lifetime_mbytes_read = lifetime_mbytes_read

    @property
    def last_load_write_compression_ratio(self):
        """Gets the last_load_write_compression_ratio of this TapeStat.  # noqa: E501


        :return: The last_load_write_compression_ratio of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._last_load_write_compression_ratio

    @last_load_write_compression_ratio.setter
    def last_load_write_compression_ratio(self, last_load_write_compression_ratio):
        """Sets the last_load_write_compression_ratio of this TapeStat.


        :param last_load_write_compression_ratio: The last_load_write_compression_ratio of this TapeStat.  # noqa: E501
        :type: int
        """

        self._last_load_write_compression_ratio = last_load_write_compression_ratio

    @property
    def last_load_read_compression_ratio(self):
        """Gets the last_load_read_compression_ratio of this TapeStat.  # noqa: E501


        :return: The last_load_read_compression_ratio of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._last_load_read_compression_ratio

    @last_load_read_compression_ratio.setter
    def last_load_read_compression_ratio(self, last_load_read_compression_ratio):
        """Sets the last_load_read_compression_ratio of this TapeStat.


        :param last_load_read_compression_ratio: The last_load_read_compression_ratio of this TapeStat.  # noqa: E501
        :type: int
        """

        self._last_load_read_compression_ratio = last_load_read_compression_ratio

    @property
    def medium_mount_time(self):
        """Gets the medium_mount_time of this TapeStat.  # noqa: E501


        :return: The medium_mount_time of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._medium_mount_time

    @medium_mount_time.setter
    def medium_mount_time(self, medium_mount_time):
        """Sets the medium_mount_time of this TapeStat.


        :param medium_mount_time: The medium_mount_time of this TapeStat.  # noqa: E501
        :type: int
        """

        self._medium_mount_time = medium_mount_time

    @property
    def medium_ready_time(self):
        """Gets the medium_ready_time of this TapeStat.  # noqa: E501


        :return: The medium_ready_time of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._medium_ready_time

    @medium_ready_time.setter
    def medium_ready_time(self, medium_ready_time):
        """Sets the medium_ready_time of this TapeStat.


        :param medium_ready_time: The medium_ready_time of this TapeStat.  # noqa: E501
        :type: int
        """

        self._medium_ready_time = medium_ready_time

    @property
    def total_native_capacity(self):
        """Gets the total_native_capacity of this TapeStat.  # noqa: E501


        :return: The total_native_capacity of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._total_native_capacity

    @total_native_capacity.setter
    def total_native_capacity(self, total_native_capacity):
        """Sets the total_native_capacity of this TapeStat.


        :param total_native_capacity: The total_native_capacity of this TapeStat.  # noqa: E501
        :type: int
        """

        self._total_native_capacity = total_native_capacity

    @property
    def total_used_native_capacity(self):
        """Gets the total_used_native_capacity of this TapeStat.  # noqa: E501


        :return: The total_used_native_capacity of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._total_used_native_capacity

    @total_used_native_capacity.setter
    def total_used_native_capacity(self, total_used_native_capacity):
        """Sets the total_used_native_capacity of this TapeStat.


        :param total_used_native_capacity: The total_used_native_capacity of this TapeStat.  # noqa: E501
        :type: int
        """

        self._total_used_native_capacity = total_used_native_capacity

    @property
    def write_protect(self):
        """Gets the write_protect of this TapeStat.  # noqa: E501


        :return: The write_protect of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._write_protect

    @write_protect.setter
    def write_protect(self, write_protect):
        """Sets the write_protect of this TapeStat.


        :param write_protect: The write_protect of this TapeStat.  # noqa: E501
        :type: int
        """

        self._write_protect = write_protect

    @property
    def worm(self):
        """Gets the worm of this TapeStat.  # noqa: E501


        :return: The worm of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._worm

    @worm.setter
    def worm(self, worm):
        """Sets the worm of this TapeStat.


        :param worm: The worm of this TapeStat.  # noqa: E501
        :type: int
        """

        self._worm = worm

    @property
    def beginning_of_medium_passes(self):
        """Gets the beginning_of_medium_passes of this TapeStat.  # noqa: E501


        :return: The beginning_of_medium_passes of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._beginning_of_medium_passes

    @beginning_of_medium_passes.setter
    def beginning_of_medium_passes(self, beginning_of_medium_passes):
        """Sets the beginning_of_medium_passes of this TapeStat.


        :param beginning_of_medium_passes: The beginning_of_medium_passes of this TapeStat.  # noqa: E501
        :type: int
        """

        self._beginning_of_medium_passes = beginning_of_medium_passes

    @property
    def middle_of_tape_passes(self):
        """Gets the middle_of_tape_passes of this TapeStat.  # noqa: E501


        :return: The middle_of_tape_passes of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._middle_of_tape_passes

    @middle_of_tape_passes.setter
    def middle_of_tape_passes(self, middle_of_tape_passes):
        """Sets the middle_of_tape_passes of this TapeStat.


        :param middle_of_tape_passes: The middle_of_tape_passes of this TapeStat.  # noqa: E501
        :type: int
        """

        self._middle_of_tape_passes = middle_of_tape_passes

    @property
    def read_compression_ratio(self):
        """Gets the read_compression_ratio of this TapeStat.  # noqa: E501


        :return: The read_compression_ratio of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._read_compression_ratio

    @read_compression_ratio.setter
    def read_compression_ratio(self, read_compression_ratio):
        """Sets the read_compression_ratio of this TapeStat.


        :param read_compression_ratio: The read_compression_ratio of this TapeStat.  # noqa: E501
        :type: int
        """

        self._read_compression_ratio = read_compression_ratio

    @property
    def write_compression_ratio(self):
        """Gets the write_compression_ratio of this TapeStat.  # noqa: E501


        :return: The write_compression_ratio of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._write_compression_ratio

    @write_compression_ratio.setter
    def write_compression_ratio(self, write_compression_ratio):
        """Sets the write_compression_ratio of this TapeStat.


        :param write_compression_ratio: The write_compression_ratio of this TapeStat.  # noqa: E501
        :type: int
        """

        self._write_compression_ratio = write_compression_ratio

    @property
    def mbytes_transferred_to_app_client(self):
        """Gets the mbytes_transferred_to_app_client of this TapeStat.  # noqa: E501


        :return: The mbytes_transferred_to_app_client of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._mbytes_transferred_to_app_client

    @mbytes_transferred_to_app_client.setter
    def mbytes_transferred_to_app_client(self, mbytes_transferred_to_app_client):
        """Sets the mbytes_transferred_to_app_client of this TapeStat.


        :param mbytes_transferred_to_app_client: The mbytes_transferred_to_app_client of this TapeStat.  # noqa: E501
        :type: int
        """

        self._mbytes_transferred_to_app_client = mbytes_transferred_to_app_client

    @property
    def bytes_transferred_to_app_client(self):
        """Gets the bytes_transferred_to_app_client of this TapeStat.  # noqa: E501


        :return: The bytes_transferred_to_app_client of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._bytes_transferred_to_app_client

    @bytes_transferred_to_app_client.setter
    def bytes_transferred_to_app_client(self, bytes_transferred_to_app_client):
        """Sets the bytes_transferred_to_app_client of this TapeStat.


        :param bytes_transferred_to_app_client: The bytes_transferred_to_app_client of this TapeStat.  # noqa: E501
        :type: int
        """

        self._bytes_transferred_to_app_client = bytes_transferred_to_app_client

    @property
    def mbytes_read_from_medium(self):
        """Gets the mbytes_read_from_medium of this TapeStat.  # noqa: E501


        :return: The mbytes_read_from_medium of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._mbytes_read_from_medium

    @mbytes_read_from_medium.setter
    def mbytes_read_from_medium(self, mbytes_read_from_medium):
        """Sets the mbytes_read_from_medium of this TapeStat.


        :param mbytes_read_from_medium: The mbytes_read_from_medium of this TapeStat.  # noqa: E501
        :type: int
        """

        self._mbytes_read_from_medium = mbytes_read_from_medium

    @property
    def bytes_read_from_medium(self):
        """Gets the bytes_read_from_medium of this TapeStat.  # noqa: E501


        :return: The bytes_read_from_medium of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._bytes_read_from_medium

    @bytes_read_from_medium.setter
    def bytes_read_from_medium(self, bytes_read_from_medium):
        """Sets the bytes_read_from_medium of this TapeStat.


        :param bytes_read_from_medium: The bytes_read_from_medium of this TapeStat.  # noqa: E501
        :type: int
        """

        self._bytes_read_from_medium = bytes_read_from_medium

    @property
    def mbytes_transferred_from_app_client(self):
        """Gets the mbytes_transferred_from_app_client of this TapeStat.  # noqa: E501


        :return: The mbytes_transferred_from_app_client of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._mbytes_transferred_from_app_client

    @mbytes_transferred_from_app_client.setter
    def mbytes_transferred_from_app_client(self, mbytes_transferred_from_app_client):
        """Sets the mbytes_transferred_from_app_client of this TapeStat.


        :param mbytes_transferred_from_app_client: The mbytes_transferred_from_app_client of this TapeStat.  # noqa: E501
        :type: int
        """

        self._mbytes_transferred_from_app_client = mbytes_transferred_from_app_client

    @property
    def bytes_transferred_from_app_client(self):
        """Gets the bytes_transferred_from_app_client of this TapeStat.  # noqa: E501


        :return: The bytes_transferred_from_app_client of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._bytes_transferred_from_app_client

    @bytes_transferred_from_app_client.setter
    def bytes_transferred_from_app_client(self, bytes_transferred_from_app_client):
        """Sets the bytes_transferred_from_app_client of this TapeStat.


        :param bytes_transferred_from_app_client: The bytes_transferred_from_app_client of this TapeStat.  # noqa: E501
        :type: int
        """

        self._bytes_transferred_from_app_client = bytes_transferred_from_app_client

    @property
    def mbytes_written_to_medium(self):
        """Gets the mbytes_written_to_medium of this TapeStat.  # noqa: E501


        :return: The mbytes_written_to_medium of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._mbytes_written_to_medium

    @mbytes_written_to_medium.setter
    def mbytes_written_to_medium(self, mbytes_written_to_medium):
        """Sets the mbytes_written_to_medium of this TapeStat.


        :param mbytes_written_to_medium: The mbytes_written_to_medium of this TapeStat.  # noqa: E501
        :type: int
        """

        self._mbytes_written_to_medium = mbytes_written_to_medium

    @property
    def bytes_written_to_medium(self):
        """Gets the bytes_written_to_medium of this TapeStat.  # noqa: E501


        :return: The bytes_written_to_medium of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._bytes_written_to_medium

    @bytes_written_to_medium.setter
    def bytes_written_to_medium(self, bytes_written_to_medium):
        """Sets the bytes_written_to_medium of this TapeStat.


        :param bytes_written_to_medium: The bytes_written_to_medium of this TapeStat.  # noqa: E501
        :type: int
        """

        self._bytes_written_to_medium = bytes_written_to_medium

    @property
    def data_compression_enabled(self):
        """Gets the data_compression_enabled of this TapeStat.  # noqa: E501


        :return: The data_compression_enabled of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._data_compression_enabled

    @data_compression_enabled.setter
    def data_compression_enabled(self, data_compression_enabled):
        """Sets the data_compression_enabled of this TapeStat.


        :param data_compression_enabled: The data_compression_enabled of this TapeStat.  # noqa: E501
        :type: int
        """

        self._data_compression_enabled = data_compression_enabled

    @property
    def write_retries(self):
        """Gets the write_retries of this TapeStat.  # noqa: E501


        :return: The write_retries of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._write_retries

    @write_retries.setter
    def write_retries(self, write_retries):
        """Sets the write_retries of this TapeStat.


        :param write_retries: The write_retries of this TapeStat.  # noqa: E501
        :type: int
        """

        self._write_retries = write_retries

    @property
    def write_perms(self):
        """Gets the write_perms of this TapeStat.  # noqa: E501


        :return: The write_perms of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._write_perms

    @write_perms.setter
    def write_perms(self, write_perms):
        """Sets the write_perms of this TapeStat.


        :param write_perms: The write_perms of this TapeStat.  # noqa: E501
        :type: int
        """

        self._write_perms = write_perms

    @property
    def suspended_writes(self):
        """Gets the suspended_writes of this TapeStat.  # noqa: E501


        :return: The suspended_writes of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._suspended_writes

    @suspended_writes.setter
    def suspended_writes(self, suspended_writes):
        """Sets the suspended_writes of this TapeStat.


        :param suspended_writes: The suspended_writes of this TapeStat.  # noqa: E501
        :type: int
        """

        self._suspended_writes = suspended_writes

    @property
    def fatal_suspended_writes(self):
        """Gets the fatal_suspended_writes of this TapeStat.  # noqa: E501


        :return: The fatal_suspended_writes of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._fatal_suspended_writes

    @fatal_suspended_writes.setter
    def fatal_suspended_writes(self, fatal_suspended_writes):
        """Sets the fatal_suspended_writes of this TapeStat.


        :param fatal_suspended_writes: The fatal_suspended_writes of this TapeStat.  # noqa: E501
        :type: int
        """

        self._fatal_suspended_writes = fatal_suspended_writes

    @property
    def read_retries(self):
        """Gets the read_retries of this TapeStat.  # noqa: E501


        :return: The read_retries of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._read_retries

    @read_retries.setter
    def read_retries(self, read_retries):
        """Sets the read_retries of this TapeStat.


        :param read_retries: The read_retries of this TapeStat.  # noqa: E501
        :type: int
        """

        self._read_retries = read_retries

    @property
    def read_perms(self):
        """Gets the read_perms of this TapeStat.  # noqa: E501


        :return: The read_perms of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._read_perms

    @read_perms.setter
    def read_perms(self, read_perms):
        """Sets the read_perms of this TapeStat.


        :param read_perms: The read_perms of this TapeStat.  # noqa: E501
        :type: int
        """

        self._read_perms = read_perms

    @property
    def suspended_reads(self):
        """Gets the suspended_reads of this TapeStat.  # noqa: E501


        :return: The suspended_reads of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._suspended_reads

    @suspended_reads.setter
    def suspended_reads(self, suspended_reads):
        """Sets the suspended_reads of this TapeStat.


        :param suspended_reads: The suspended_reads of this TapeStat.  # noqa: E501
        :type: int
        """

        self._suspended_reads = suspended_reads

    @property
    def fatal_suspended_reads(self):
        """Gets the fatal_suspended_reads of this TapeStat.  # noqa: E501


        :return: The fatal_suspended_reads of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._fatal_suspended_reads

    @fatal_suspended_reads.setter
    def fatal_suspended_reads(self, fatal_suspended_reads):
        """Sets the fatal_suspended_reads of this TapeStat.


        :param fatal_suspended_reads: The fatal_suspended_reads of this TapeStat.  # noqa: E501
        :type: int
        """

        self._fatal_suspended_reads = fatal_suspended_reads

    @property
    def partition_0_remaining_capacity(self):
        """Gets the partition_0_remaining_capacity of this TapeStat.  # noqa: E501


        :return: The partition_0_remaining_capacity of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._partition_0_remaining_capacity

    @partition_0_remaining_capacity.setter
    def partition_0_remaining_capacity(self, partition_0_remaining_capacity):
        """Sets the partition_0_remaining_capacity of this TapeStat.


        :param partition_0_remaining_capacity: The partition_0_remaining_capacity of this TapeStat.  # noqa: E501
        :type: int
        """

        self._partition_0_remaining_capacity = partition_0_remaining_capacity

    @property
    def partition_1_remaining_capacity(self):
        """Gets the partition_1_remaining_capacity of this TapeStat.  # noqa: E501


        :return: The partition_1_remaining_capacity of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._partition_1_remaining_capacity

    @partition_1_remaining_capacity.setter
    def partition_1_remaining_capacity(self, partition_1_remaining_capacity):
        """Sets the partition_1_remaining_capacity of this TapeStat.


        :param partition_1_remaining_capacity: The partition_1_remaining_capacity of this TapeStat.  # noqa: E501
        :type: int
        """

        self._partition_1_remaining_capacity = partition_1_remaining_capacity

    @property
    def partition_0_maximum_capacity(self):
        """Gets the partition_0_maximum_capacity of this TapeStat.  # noqa: E501


        :return: The partition_0_maximum_capacity of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._partition_0_maximum_capacity

    @partition_0_maximum_capacity.setter
    def partition_0_maximum_capacity(self, partition_0_maximum_capacity):
        """Sets the partition_0_maximum_capacity of this TapeStat.


        :param partition_0_maximum_capacity: The partition_0_maximum_capacity of this TapeStat.  # noqa: E501
        :type: int
        """

        self._partition_0_maximum_capacity = partition_0_maximum_capacity

    @property
    def partition_1_maximum_capacity(self):
        """Gets the partition_1_maximum_capacity of this TapeStat.  # noqa: E501


        :return: The partition_1_maximum_capacity of this TapeStat.  # noqa: E501
        :rtype: int
        """
        return self._partition_1_maximum_capacity

    @partition_1_maximum_capacity.setter
    def partition_1_maximum_capacity(self, partition_1_maximum_capacity):
        """Sets the partition_1_maximum_capacity of this TapeStat.


        :param partition_1_maximum_capacity: The partition_1_maximum_capacity of this TapeStat.  # noqa: E501
        :type: int
        """

        self._partition_1_maximum_capacity = partition_1_maximum_capacity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TapeStat):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TapeStat):
            return True

        return self.to_dict() != other.to_dict()
