# coding: utf-8

# flake8: noqa

"""
    Nodeum API

    The Nodeum API makes it easy to tap into the digital data mesh that runs across your organisation. Make requests to our API endpoints and we’ll give you everything you need to interconnect your business workflows with your storage.  All production API requests are made to:  http://nodeumhostname/api/  The current production version of the API is v1.   **REST** The Nodeum API is a RESTful API. This means that the API is designed to allow you to get, create, update, & delete objects with the HTTP verbs GET, POST, PUT, PATCH, & DELETE.  **JSON** The Nodeum API speaks exclusively in JSON. This means that you should always set the Content-Type header to application/json to ensure that your requests are properly accepted and processed by the API.  **Authentication** All API calls require user-password authentication.   **Cross-Origin Resource Sharing** The Nodeum API supports CORS for communicating from Javascript for these endpoints. You will need to specify an Origin URI when creating your application to allow for CORS to be whitelisted for your domain.   **Pagination** Some endpoints such as File Listing return a potentially lengthy array of objects. In order to keep the response sizes manageable the API will take advantage of pagination. Pagination is a mechanism for returning a subset of the results for a request and allowing for subsequent requests to “page” through the rest of the results until the end is reached. Paginated endpoints follow a standard interface that accepts two query parameters, limit and offset, and return a payload that follows a standard form. These parameters names and their behavior are borrowed from SQL LIMIT and OFFSET keywords.  **Versioning** The Nodeum API is constantly being worked on to add features, make improvements, and fix bugs. This means that you should expect changes to be introduced and documented.   However, there are some changes or additions that are considered backwards-compatible and your applications should be flexible enough to handle them. These include:  - Adding new endpoints to the API - Adding new attributes to the response of an existing endpoint - Changing the order of attributes of responses (JSON by definition is an object of unordered key/value pairs)  **Filter parameters** When browsing a list of items, multiple filter parameters may be applied. Some operators can be added to the value as a prefix:  - `=` value is equal. Default operator, may be omitted  - `!=` value is different  - `>` greater than  - `>=` greater than or equal  - `<` lower than  - `>=` lower than or equal  - `><` included in list, items should be separated by `|`  - `!><` not included in list, items should be separated by `|`  - `~` pattern matching, may include `%` (any characters) and `_` (one character)  - `!~` pattern not matching, may include `%` (any characters) and `_` (one character)    # noqa: E501

    The version of the OpenAPI document: 2.1.0
    Contact: info@nodeum.io
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

__version__ = "1.85.0"

# import apis into sdk package
from nodeum_sdk.api.cloud_buckets_api import CloudBucketsApi
from nodeum_sdk.api.cloud_connectors_api import CloudConnectorsApi
from nodeum_sdk.api.containers_api import ContainersApi
from nodeum_sdk.api.files_api import FilesApi
from nodeum_sdk.api.mounts_api import MountsApi
from nodeum_sdk.api.nas_api import NasApi
from nodeum_sdk.api.nas_shares_api import NasSharesApi
from nodeum_sdk.api.pools_api import PoolsApi
from nodeum_sdk.api.statistics_api import StatisticsApi
from nodeum_sdk.api.systems_api import SystemsApi
from nodeum_sdk.api.tape_drives_api import TapeDrivesApi
from nodeum_sdk.api.tape_libraries_api import TapeLibrariesApi
from nodeum_sdk.api.tapes_api import TapesApi
from nodeum_sdk.api.task_callbacks_api import TaskCallbacksApi
from nodeum_sdk.api.task_destinations_api import TaskDestinationsApi
from nodeum_sdk.api.task_executions_api import TaskExecutionsApi
from nodeum_sdk.api.task_metadata_api import TaskMetadataApi
from nodeum_sdk.api.task_options_api import TaskOptionsApi
from nodeum_sdk.api.task_schedules_api import TaskSchedulesApi
from nodeum_sdk.api.task_sources_api import TaskSourcesApi
from nodeum_sdk.api.tasks_api import TasksApi
from nodeum_sdk.api.users_api import UsersApi

# import ApiClient
from nodeum_sdk.api_client import ApiClient
from nodeum_sdk.configuration import Configuration
from nodeum_sdk.exceptions import OpenApiException
from nodeum_sdk.exceptions import ApiTypeError
from nodeum_sdk.exceptions import ApiValueError
from nodeum_sdk.exceptions import ApiKeyError
from nodeum_sdk.exceptions import ApiException
# import models into sdk package
from nodeum_sdk.models.active_job_status import ActiveJobStatus
from nodeum_sdk.models.api_key import ApiKey
from nodeum_sdk.models.api_key_collection import ApiKeyCollection
from nodeum_sdk.models.api_key_full import ApiKeyFull
from nodeum_sdk.models.api_key_full_all_of import ApiKeyFullAllOf
from nodeum_sdk.models.api_key_scope import ApiKeyScope
from nodeum_sdk.models.attribute_error import AttributeError
from nodeum_sdk.models.blank import Blank
from nodeum_sdk.models.by_date_facet import ByDateFacet
from nodeum_sdk.models.by_date_facet_bucket import ByDateFacetBucket
from nodeum_sdk.models.by_date_facet_bucket_all_of import ByDateFacetBucketAllOf
from nodeum_sdk.models.by_date_facet_buckets import ByDateFacetBuckets
from nodeum_sdk.models.by_file_extension_facet import ByFileExtensionFacet
from nodeum_sdk.models.by_file_extension_facet_all_of import ByFileExtensionFacetAllOf
from nodeum_sdk.models.by_group_owner_facet import ByGroupOwnerFacet
from nodeum_sdk.models.by_group_owner_facet_all_of import ByGroupOwnerFacetAllOf
from nodeum_sdk.models.by_primary_facet import ByPrimaryFacet
from nodeum_sdk.models.by_primary_facet_all_of import ByPrimaryFacetAllOf
from nodeum_sdk.models.by_secondary_bucket import BySecondaryBucket
from nodeum_sdk.models.by_secondary_bucket_all_of import BySecondaryBucketAllOf
from nodeum_sdk.models.by_secondary_buckets import BySecondaryBuckets
from nodeum_sdk.models.by_secondary_facet import BySecondaryFacet
from nodeum_sdk.models.by_secondary_type_facet import BySecondaryTypeFacet
from nodeum_sdk.models.by_secondary_type_facet_all_of import BySecondaryTypeFacetAllOf
from nodeum_sdk.models.by_size_facet import BySizeFacet
from nodeum_sdk.models.by_user_owner_facet import ByUserOwnerFacet
from nodeum_sdk.models.by_user_owner_facet_all_of import ByUserOwnerFacetAllOf
from nodeum_sdk.models.cloud_bucket import CloudBucket
from nodeum_sdk.models.cloud_bucket_collection import CloudBucketCollection
from nodeum_sdk.models.cloud_bucket_simple_collection import CloudBucketSimpleCollection
from nodeum_sdk.models.cloud_connector import CloudConnector
from nodeum_sdk.models.cloud_connector_collection import CloudConnectorCollection
from nodeum_sdk.models.container import Container
from nodeum_sdk.models.container_collection import ContainerCollection
from nodeum_sdk.models.container_privilege import ContainerPrivilege
from nodeum_sdk.models.container_privilege_collection import ContainerPrivilegeCollection
from nodeum_sdk.models.date_to_file_facets import DateToFileFacets
from nodeum_sdk.models.error import Error
from nodeum_sdk.models.file_facet import FileFacet
from nodeum_sdk.models.frozen import Frozen
from nodeum_sdk.models.greater_than import GreaterThan
from nodeum_sdk.models.greater_than_all_of import GreaterThanAllOf
from nodeum_sdk.models.greater_than_or_equal_to import GreaterThanOrEqualTo
from nodeum_sdk.models.import_file import ImportFile
from nodeum_sdk.models.import_file_collection import ImportFileCollection
from nodeum_sdk.models.import_file_with_path import ImportFileWithPath
from nodeum_sdk.models.invalid import Invalid
from nodeum_sdk.models.less_than import LessThan
from nodeum_sdk.models.less_than_all_of import LessThanAllOf
from nodeum_sdk.models.less_than_or_equal_to import LessThanOrEqualTo
from nodeum_sdk.models.mount_collection import MountCollection
from nodeum_sdk.models.mount_info import MountInfo
from nodeum_sdk.models.mount_notification import MountNotification
from nodeum_sdk.models.mount_status import MountStatus
from nodeum_sdk.models.nas import Nas
from nodeum_sdk.models.nas_collection import NasCollection
from nodeum_sdk.models.nas_share import NasShare
from nodeum_sdk.models.nas_share_collection import NasShareCollection
from nodeum_sdk.models.nodeum_file import NodeumFile
from nodeum_sdk.models.nodeum_file_collection import NodeumFileCollection
from nodeum_sdk.models.nodeum_file_with_path import NodeumFileWithPath
from nodeum_sdk.models.nodeum_file_with_path_all_of import NodeumFileWithPathAllOf
from nodeum_sdk.models.occurrence_less_than import OccurrenceLessThan
from nodeum_sdk.models.occurrence_less_than_all_of import OccurrenceLessThanAllOf
from nodeum_sdk.models.occurrence_less_than_or_equal_to import OccurrenceLessThanOrEqualTo
from nodeum_sdk.models.on_tapes_file import OnTapesFile
from nodeum_sdk.models.on_tapes_file_collection import OnTapesFileCollection
from nodeum_sdk.models.pool import Pool
from nodeum_sdk.models.pool_collection import PoolCollection
from nodeum_sdk.models.pool_up import PoolUp
from nodeum_sdk.models.pool_up_all_of import PoolUpAllOf
from nodeum_sdk.models.primary_scan import PrimaryScan
from nodeum_sdk.models.quota_on_cache import QuotaOnCache
from nodeum_sdk.models.reset import Reset
from nodeum_sdk.models.reset_sections import ResetSections
from nodeum_sdk.models.size_to_date_facets import SizeToDateFacets
from nodeum_sdk.models.system_group import SystemGroup
from nodeum_sdk.models.system_group_collection import SystemGroupCollection
from nodeum_sdk.models.system_user import SystemUser
from nodeum_sdk.models.system_user_collection import SystemUserCollection
from nodeum_sdk.models.taken import Taken
from nodeum_sdk.models.taken_all_of import TakenAllOf
from nodeum_sdk.models.tape import Tape
from nodeum_sdk.models.tape_collection import TapeCollection
from nodeum_sdk.models.tape_drive import TapeDrive
from nodeum_sdk.models.tape_drive_all_of import TapeDriveAllOf
from nodeum_sdk.models.tape_drive_collection import TapeDriveCollection
from nodeum_sdk.models.tape_drive_device import TapeDriveDevice
from nodeum_sdk.models.tape_drive_device_collection import TapeDriveDeviceCollection
from nodeum_sdk.models.tape_library import TapeLibrary
from nodeum_sdk.models.tape_library_all_of import TapeLibraryAllOf
from nodeum_sdk.models.tape_library_collection import TapeLibraryCollection
from nodeum_sdk.models.tape_library_device import TapeLibraryDevice
from nodeum_sdk.models.tape_library_device_collection import TapeLibraryDeviceCollection
from nodeum_sdk.models.tape_stat import TapeStat
from nodeum_sdk.models.tape_stat_collection import TapeStatCollection
from nodeum_sdk.models.task import Task
from nodeum_sdk.models.task_callback import TaskCallback
from nodeum_sdk.models.task_callback_collection import TaskCallbackCollection
from nodeum_sdk.models.task_collection import TaskCollection
from nodeum_sdk.models.task_destination_collection import TaskDestinationCollection
from nodeum_sdk.models.task_destination_down import TaskDestinationDown
from nodeum_sdk.models.task_destination_up import TaskDestinationUp
from nodeum_sdk.models.task_execution import TaskExecution
from nodeum_sdk.models.task_execution_collection import TaskExecutionCollection
from nodeum_sdk.models.task_metadatum import TaskMetadatum
from nodeum_sdk.models.task_metadatum_collection import TaskMetadatumCollection
from nodeum_sdk.models.task_option import TaskOption
from nodeum_sdk.models.task_option_collection import TaskOptionCollection
from nodeum_sdk.models.task_schedule import TaskSchedule
from nodeum_sdk.models.task_schedule_collection import TaskScheduleCollection
from nodeum_sdk.models.task_source_collection import TaskSourceCollection
from nodeum_sdk.models.task_source_down import TaskSourceDown
from nodeum_sdk.models.task_source_up import TaskSourceUp
from nodeum_sdk.models.too_long import TooLong
from nodeum_sdk.models.too_long_all_of import TooLongAllOf
from nodeum_sdk.models.too_short import TooShort
from nodeum_sdk.models.too_short_all_of import TooShortAllOf
from nodeum_sdk.models.type_to_secondary_facets import TypeToSecondaryFacets

