/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.property;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import java.util.function.Consumer;

public interface PropertyManager<T> {
    public void addConfigChangedListener(Consumer<T> var1);

    public T getConfig();

    public void updateConfig(T var1);

    @JsonDeserialize(builder=Builder.class)
    public static final class SiteConfig {
        @JsonProperty
        private final String siteTag;

        public SiteConfig copy() {
            return new SiteConfig(this.siteTag);
        }

        SiteConfig(String siteTag) {
            this.siteTag = siteTag;
        }

        public static Builder builder() {
            return new Builder();
        }

        public Builder toBuilder() {
            return new Builder().siteTag(this.siteTag);
        }

        public String siteTag() {
            return this.siteTag;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SiteConfig)) {
                return false;
            }
            SiteConfig other = (SiteConfig)o;
            String this$siteTag = this.siteTag();
            String other$siteTag = other.siteTag();
            return !(this$siteTag == null ? other$siteTag != null : !this$siteTag.equals(other$siteTag));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $siteTag = this.siteTag();
            result = result * 59 + ($siteTag == null ? 43 : $siteTag.hashCode());
            return result;
        }

        public String toString() {
            return "PropertyManager.SiteConfig(siteTag=" + this.siteTag() + ")";
        }

        public static class Builder {
            private String siteTag;

            Builder() {
            }

            @JsonProperty
            public Builder siteTag(String siteTag) {
                this.siteTag = siteTag;
                return this;
            }

            public SiteConfig build() {
                return new SiteConfig(this.siteTag);
            }

            public String toString() {
                return "PropertyManager.SiteConfig.Builder(siteTag=" + this.siteTag + ")";
            }
        }
    }

    public static class RoomConfig {
        @JsonProperty(value="roomTag")
        private final String roomTag;
        @JsonProperty(value="pushClientTag")
        private final String pushClientTag;
        @JsonProperty(value="metricsAgentTag")
        private final String metricsAgentTag;

        public RoomConfig(@JsonProperty(value="roomTag") String roomTag, @JsonProperty(value="pushClientTag") String pushClientTag, @JsonProperty(value="metricsAgentTag") String metricsAgentTag) {
            this.roomTag = roomTag;
            this.pushClientTag = pushClientTag;
            this.metricsAgentTag = metricsAgentTag;
        }

        public RoomConfig copy() {
            return new RoomConfig(this.roomTag, this.pushClientTag, this.metricsAgentTag);
        }

        public String roomTag() {
            return this.roomTag;
        }

        public String pushClientTag() {
            return this.pushClientTag;
        }

        public String metricsAgentTag() {
            return this.metricsAgentTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RoomConfig that = (RoomConfig)o;
            return this.roomTag.equals(that.roomTag) && this.pushClientTag.equals(that.pushClientTag);
        }

        public int hashCode() {
            return Objects.hash(this.roomTag, this.pushClientTag);
        }

        public String toString() {
            return "RoomConfig{roomTag='" + this.roomTag + "'}";
        }

        public static RoomConfigBuilder builder() {
            return new RoomConfigBuilder();
        }

        public RoomConfigBuilder toBuilder() {
            return new RoomConfigBuilder().roomTag(this.roomTag).pushClientTag(this.pushClientTag).metricsAgentTag(this.metricsAgentTag);
        }

        public static class RoomConfigBuilder {
            private String roomTag;
            private String pushClientTag;
            private String metricsAgentTag;

            RoomConfigBuilder() {
            }

            @JsonProperty(value="roomTag")
            public RoomConfigBuilder roomTag(String roomTag) {
                this.roomTag = roomTag;
                return this;
            }

            @JsonProperty(value="pushClientTag")
            public RoomConfigBuilder pushClientTag(String pushClientTag) {
                this.pushClientTag = pushClientTag;
                return this;
            }

            @JsonProperty(value="metricsAgentTag")
            public RoomConfigBuilder metricsAgentTag(String metricsAgentTag) {
                this.metricsAgentTag = metricsAgentTag;
                return this;
            }

            public RoomConfig build() {
                return new RoomConfig(this.roomTag, this.pushClientTag, this.metricsAgentTag);
            }

            public String toString() {
                return "PropertyManager.RoomConfig.RoomConfigBuilder(roomTag=" + this.roomTag + ", pushClientTag=" + this.pushClientTag + ", metricsAgentTag=" + this.metricsAgentTag + ")";
            }
        }
    }

    public static class WorkerConfig {
        @JsonProperty(value="backendTag")
        private final String backendTag;
        @JsonProperty(value="copyJupyterKernelTag")
        private final String copyJupyterKernelTag;
        @JsonProperty(value="userTag")
        private final String userTag;

        @JsonCreator
        public WorkerConfig(@JsonProperty(value="backendTag") String backendTag, @JsonProperty(value="copyJupyterKernelTag") String copyJupyterKernelTag, @JsonProperty(value="userTag") String userTag) {
            this.backendTag = backendTag;
            this.copyJupyterKernelTag = copyJupyterKernelTag;
            this.userTag = userTag;
        }

        public String backendTag() {
            return this.backendTag;
        }

        public String copyJupyterKernelTag() {
            return this.copyJupyterKernelTag;
        }

        public String userTag() {
            return this.userTag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkerConfig that = (WorkerConfig)o;
            return this.backendTag.equals(that.backendTag) && this.copyJupyterKernelTag.equals(that.copyJupyterKernelTag) && this.userTag.equals(that.userTag);
        }

        public int hashCode() {
            return Objects.hash(this.backendTag, this.copyJupyterKernelTag, this.userTag);
        }

        public String toString() {
            return "WorkerConfig{backendTag='" + this.backendTag + "', copyJupyterKernelTag='" + this.copyJupyterKernelTag + "', userTag='" + this.userTag + "'}";
        }
    }
}

