/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.stereotype.Service;
import ru.yandex.cloud.ml.platform.model.util.lock.BaseLockManager;
import ru.yandex.cloud.ml.platform.model.util.lock.LockManager;

@Service(value="LocalLockManager")
public class LocalLockManager
extends BaseLockManager {
    private final String prefix;
    private final ConcurrentHashMap<String, ReadWriteLock> prefixReadWriteLock = new ConcurrentHashMap();

    public LocalLockManager() {
        super(new ConcurrentHashMap<String, Lock>());
        this.prefix = "LocalLockManager";
    }

    private LocalLockManager(String prefix, ConcurrentHashMap<String, Lock> locks) {
        super(locks);
        this.prefix = prefix;
    }

    @Override
    public LockManager withPrefix(String prefix) {
        return new LocalLockManager(this.prefix + "-" + prefix, this.locks);
    }

    @Override
    public ReadWriteLock readWriteLock() {
        return this.prefixReadWriteLock.computeIfAbsent(this.prefix, __ -> new ReentrantReadWriteLock());
    }

    @Override
    protected Lock createLock(String path) {
        return new ReentrantLock();
    }

    @Override
    protected String prefix() {
        return this.prefix;
    }
}

