/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.Nonnull;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import ru.yandex.cloud.ml.platform.model.util.lock.BaseLockManager;
import ru.yandex.cloud.ml.platform.model.util.lock.LockManager;

@Lazy
@Service(value="DistributedLockManager")
public class DistributedLockManager
extends BaseLockManager {
    private final CuratorFramework zookeeperClient;
    private final String prefix;
    private final int lockTimeoutSec;

    @Autowired
    public DistributedLockManager(CuratorFramework zookeeperClient, int lockTimeoutSec) {
        super(new ConcurrentHashMap<String, Lock>());
        this.zookeeperClient = zookeeperClient;
        this.prefix = "/DistributedLockManager";
        this.lockTimeoutSec = lockTimeoutSec;
    }

    private DistributedLockManager(CuratorFramework zookeeperClient, ConcurrentHashMap<String, Lock> locks, String prefix, int lockTimeoutSec) {
        super(locks);
        this.zookeeperClient = zookeeperClient;
        this.prefix = prefix;
        this.lockTimeoutSec = lockTimeoutSec;
    }

    @Override
    public LockManager withPrefix(String prefix) {
        return new DistributedLockManager(this.zookeeperClient, this.locks, this.prefix + "-" + prefix, this.lockTimeoutSec);
    }

    @Override
    public ReadWriteLock readWriteLock() {
        InterProcessReadWriteLock interProcessReadWriteLock = new InterProcessReadWriteLock(this.zookeeperClient, this.prefix);
        final DistributedLock readLock = new DistributedLock(interProcessReadWriteLock.readLock(), this.lockTimeoutSec);
        final DistributedLock writeLock = new DistributedLock(interProcessReadWriteLock.writeLock(), this.lockTimeoutSec);
        return new ReadWriteLock(){

            @Override
            public Lock readLock() {
                return readLock;
            }

            @Override
            public Lock writeLock() {
                return writeLock;
            }
        };
    }

    @Override
    protected Lock createLock(String path) {
        return new DistributedLock(new InterProcessMutex(this.zookeeperClient, path), this.lockTimeoutSec);
    }

    @Override
    protected String prefix() {
        return this.prefix;
    }

    private static class DistributedLock
    implements Lock {
        private final InterProcessMutex mutex;
        private final int lockTimeoutSec;

        private DistributedLock(InterProcessMutex mutex, int lockTimeoutSec) {
            this.mutex = mutex;
            this.lockTimeoutSec = lockTimeoutSec;
        }

        @Override
        public void lock() {
            try {
                this.mutex.acquire();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void lockInterruptibly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            if (this.mutex.isAcquiredInThisProcess()) {
                return false;
            }
            return this.tryLock(this.lockTimeoutSec, TimeUnit.SECONDS);
        }

        @Override
        public boolean tryLock(long time, @Nonnull TimeUnit unit) {
            try {
                return this.mutex.acquire(time, unit);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void unlock() {
            try {
                this.mutex.release();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        @Nonnull
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

