/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.lock;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import ru.yandex.cloud.ml.platform.model.util.lock.LockManager;

public abstract class BaseLockManager
implements LockManager {
    protected final ConcurrentHashMap<String, Lock> locks;

    protected abstract Lock createLock(String var1);

    protected abstract String prefix();

    protected BaseLockManager(ConcurrentHashMap<String, Lock> locks) {
        this.locks = locks;
    }

    @Override
    public Lock getOrCreate(String key) {
        return this.locks.computeIfAbsent(this.prefix() + "-" + key, this::createLock);
    }

    @Override
    public void remove(String key) {
        Lock remove = this.locks.remove(this.prefix() + "-" + key);
        if (remove != null && !remove.tryLock()) {
            remove.unlock();
        }
    }
}

