/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.latch;

import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.shared.SharedCount;
import org.apache.curator.framework.recipes.shared.SharedValue;
import ru.yandex.cloud.ml.platform.model.util.latch.Latch;

public class DistributedLatch
implements Latch {
    private final SharedCount count;
    private final SharedValue createdAt;

    DistributedLatch(CuratorFramework zookeeperClient, int count, String name) {
        this.count = new SharedCount(zookeeperClient, name + "-count", count);
        this.createdAt = new SharedValue(zookeeperClient, name + "-createdAt", this.longToBytes(Instant.now().toEpochMilli()));
        try {
            this.createdAt.start();
            this.count.start();
            if (this.count.getCount() < 0) {
                this.count.setCount(count);
            }
            if (this.createdAt.getValue().length == 0) {
                this.createdAt.setValue(this.longToBytes(Instant.now().toEpochMilli()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void countDown() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean await(int timeout, TimeUnit unit) throws InterruptedException {
        long timeoutSecs = unit.toSeconds(timeout);
        while (this.count.getCount() != 0) {
            if (timeoutSecs <= 0L) {
                return false;
            }
            Thread.sleep(1000L);
            --timeoutSecs;
        }
        return true;
    }

    public long createdAt() {
        return this.bytesToLong(this.createdAt.getValue());
    }

    public int count() {
        return this.count.getCount();
    }

    void close() {
        try {
            this.count.setCount(-1);
            this.count.close();
            this.createdAt.setValue(new byte[0]);
            this.createdAt.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] longToBytes(long x) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(x);
        return buffer.array();
    }

    private long bytesToLong(byte[] bytes) {
        if (bytes.length == 0) {
            return 0L;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }
}

