/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.integer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.cloud.ml.platform.model.util.integer.LocalSharedInteger;
import ru.yandex.cloud.ml.platform.model.util.integer.SharedInteger;
import ru.yandex.cloud.ml.platform.model.util.integer.SharedIntegerManager;

@Service(value="LocalSharedIntegerManager")
public class LocalSharedIntegerManager
implements SharedIntegerManager {
    private final Map<String, SharedInteger> integers;
    private final String prefix;

    private LocalSharedIntegerManager(Map<String, SharedInteger> integers, String prefix) {
        this.integers = integers;
        this.prefix = prefix;
    }

    @Autowired
    public LocalSharedIntegerManager() {
        this.integers = new ConcurrentHashMap<String, SharedInteger>();
        this.prefix = "LocalSharedIntegerManager-";
    }

    @Override
    public SharedIntegerManager withPrefix(String prefix) {
        return new LocalSharedIntegerManager(this.integers, this.prefix + "-" + prefix);
    }

    @Override
    public SharedInteger get(String key, int defaultValue) {
        return this.integers.computeIfAbsent(this.prefix + "-" + key, k -> new LocalSharedInteger(defaultValue));
    }
}

