/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.model.util.integer;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.curator.framework.CuratorFramework;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import ru.yandex.cloud.ml.platform.model.util.integer.DistributedSharedInteger;
import ru.yandex.cloud.ml.platform.model.util.integer.SharedInteger;
import ru.yandex.cloud.ml.platform.model.util.integer.SharedIntegerManager;

@Lazy
@Service(value="DistributedSharedIntegerManager")
public class DistributedSharedIntegerManager
implements SharedIntegerManager {
    private final CuratorFramework zookeeperClient;
    private final ConcurrentHashMap<String, DistributedSharedInteger> integers;
    private final String prefix;

    @Autowired
    public DistributedSharedIntegerManager(CuratorFramework zookeeperClient) {
        this.zookeeperClient = zookeeperClient;
        this.integers = new ConcurrentHashMap();
        this.prefix = "/DistributedSharedIntegerManager-";
    }

    private DistributedSharedIntegerManager(CuratorFramework zookeeperClient, ConcurrentHashMap<String, DistributedSharedInteger> integers, String prefix) {
        this.zookeeperClient = zookeeperClient;
        this.integers = integers;
        this.prefix = prefix;
    }

    @Override
    public SharedIntegerManager withPrefix(String prefix) {
        return new DistributedSharedIntegerManager(this.zookeeperClient, this.integers, this.prefix + "-" + prefix);
    }

    @Override
    public SharedInteger get(String key, int defaultValue) {
        return this.integers.computeIfAbsent(this.prefix + "-" + key, k -> new DistributedSharedInteger(this.zookeeperClient, this.prefix + "-" + key, defaultValue));
    }
}

