/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.slots;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.model.gRPCConverter;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.FileContents;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyOutputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LocalFileContents;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LzySlotBase;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;

public class OutFileSlot
extends LzySlotBase
implements LzyFileSlot,
LzyOutputSlot {
    private static final Logger LOG = LogManager.getLogger(OutFileSlot.class);
    private final Path storage;
    private final String tid;
    private boolean ready;
    private final List<Runnable> closeActions = new ArrayList<Runnable>();

    protected OutFileSlot(String tid, Slot definition, Path storage) {
        super(definition);
        this.tid = tid;
        this.storage = storage;
        this.ready = true;
    }

    public OutFileSlot(String tid, Slot definition) throws IOException {
        super(definition);
        this.tid = tid;
        this.storage = Files.createTempFile("lzy", "file-slot", new FileAttribute[0]);
        this.ready = false;
    }

    @Override
    public Path location() {
        return Path.of(this.name(), new String[0]);
    }

    @Override
    public long size() {
        try {
            return Files.size(this.storage);
        }
        catch (IOException e) {
            LOG.warn("Unable to get a storage file size", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long ctime() {
        try {
            return ((FileTime)Files.getAttribute(this.storage, "unix:creationTime", new LinkOption[0])).toMillis();
        }
        catch (IOException e) {
            LOG.warn("Unable to get file creation time", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long mtime() {
        try {
            return ((FileTime)Files.getAttribute(this.storage, "unix:lastModifiedTime", new LinkOption[0])).toMillis();
        }
        catch (IOException e) {
            LOG.warn("Unable to get file creation time", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public long atime() {
        try {
            return ((FileTime)Files.getAttribute(this.storage, "unix:lastAccessTime", new LinkOption[0])).toMillis();
        }
        catch (IOException e) {
            LOG.warn("Unable to get file creation time", (Throwable)e);
            return 0L;
        }
    }

    @Override
    public int mtype() {
        return 32768;
    }

    @Override
    public void remove() throws IOException {
        Files.delete(this.storage);
    }

    @Override
    public FileContents open(FuseFileInfo fi) throws IOException {
        LocalFileContents localFileContents = new LocalFileContents(this.storage, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ);
        localFileContents.onClose(written -> {
            if (written.booleanValue()) {
                OutFileSlot outFileSlot = this;
                synchronized (outFileSlot) {
                    LOG.info("Content to slot " + this + " was written; READY=true");
                    this.ready = true;
                    this.state(Operations.SlotStatus.State.OPEN);
                    this.notifyAll();
                }
            }
        });
        return localFileContents;
    }

    public void flush() {
        try {
            Files.writeString(this.storage, (CharSequence)"empty", StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Operations.SlotStatus status() {
        Operations.SlotStatus.Builder builder = Operations.SlotStatus.newBuilder().setState(this.state()).setDeclaration(gRPCConverter.to(this.definition()));
        if (this.tid != null) {
            builder.setTaskId(this.tid);
        }
        return builder.build();
    }

    @Override
    public synchronized Stream<ByteString> readFromPosition(long offset) throws IOException {
        LOG.info("OutFileSlot.readFromPosition for slot " + this.definition().name());
        while (!this.ready) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        LOG.info("Slot {} is ready", (Object)this.name());
        final FileChannel channel = FileChannel.open(this.storage, new OpenOption[0]);
        channel.position(offset);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<ByteString>(){
            private final ByteBuffer bb = ByteBuffer.allocate(4096);

            @Override
            public boolean hasNext() {
                if (OutFileSlot.this.state() != Operations.SlotStatus.State.OPEN) {
                    LOG.info("Slot {} hasNext is not open", (Object)OutFileSlot.this.name());
                    return false;
                }
                try {
                    this.bb.clear();
                    int read = channel.read(this.bb);
                    LOG.info("Slot {} hasNext read {}", (Object)OutFileSlot.this.name(), (Object)read);
                    return read >= 0;
                }
                catch (IOException e) {
                    LOG.warn("Unable to read line from reader", (Throwable)e);
                    return false;
                }
            }

            @Override
            public ByteString next() {
                this.bb.flip();
                LOG.info("Send from slot {} data {}", (Object)OutFileSlot.this.name(), (Object)this.bb.toString());
                return ByteString.copyFrom(this.bb);
            }
        }, 1041), false);
    }

    @Override
    public void destroy() {
        super.destroy();
        ForkJoinPool.commonPool().execute(() -> {
            Thread.yield();
            this.closeActions.forEach(Runnable::run);
        });
    }

    public String toString() {
        return "OutFileSlot:" + this.definition().name() + "->" + this.storage.toString();
    }
}

