/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.slots;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzySlot;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;

public class LzySlotBase
implements LzySlot {
    private static final Logger LOG = LogManager.getLogger(LzySlotBase.class);
    private final Slot definition;
    private Operations.SlotStatus.State state = Operations.SlotStatus.State.UNBOUND;
    private final Map<Operations.SlotStatus.State, List<Runnable>> actions = Collections.synchronizedMap(new HashMap());

    protected LzySlotBase(Slot definition) {
        this.definition = definition;
        this.onState(Operations.SlotStatus.State.OPEN, () -> LOG.info("LzySlot::OPEN " + this));
        this.onState(Operations.SlotStatus.State.DESTROYED, () -> LOG.info("LzySlot::DESTROYED " + this));
        this.onState(Operations.SlotStatus.State.SUSPENDED, () -> LOG.info("LzySlot::SUSPENDED " + this));
    }

    @Override
    public String name() {
        return this.definition.name();
    }

    @Override
    public Slot definition() {
        return this.definition;
    }

    @Override
    public Operations.SlotStatus.State state() {
        return this.state;
    }

    public synchronized void state(Operations.SlotStatus.State newState) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        this.notifyAll();
        ForkJoinPool.commonPool().execute(() -> this.actions.getOrDefault(newState, List.of()).forEach(Runnable::run));
    }

    @Override
    public void onState(Operations.SlotStatus.State state, Runnable action) {
        this.actions.computeIfAbsent(state, s -> new ArrayList()).add(action);
    }

    @Override
    public void destroy() {
        this.state(Operations.SlotStatus.State.DESTROYED);
    }

    @Override
    public void suspend() {
        this.state(Operations.SlotStatus.State.SUSPENDED);
    }

    @Override
    public Operations.SlotStatus status() {
        return Operations.SlotStatus.newBuilder().build();
    }

    protected synchronized void waitForState(Operations.SlotStatus.State state) {
        while (state != this.state && this.state != Operations.SlotStatus.State.DESTROYED) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

