/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.slots;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import jnr.ffi.Pointer;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.FileContents;

public class LocalFileContents
implements FileContents {
    private final byte[] buffer = new byte[4096];
    private final FileChannel channel;
    private final AtomicBoolean written = new AtomicBoolean(false);
    private final List<Consumer<Boolean>> triggers = new ArrayList<Consumer<Boolean>>();

    public LocalFileContents(Path file, OpenOption ... oo) throws IOException {
        this.channel = FileChannel.open(file, oo);
    }

    @Override
    public int read(Pointer buf, long offset, long size) throws IOException {
        MappedByteBuffer map = this.channel.map(FileChannel.MapMode.READ_ONLY, offset, size);
        buf.transferFrom(0L, Pointer.wrap(buf.getRuntime(), map), 0L, size);
        return (int)size;
    }

    @Override
    public int write(Pointer buf, long offset, long size) throws IOException {
        int off = 0;
        while ((long)off < size) {
            int chunkSize = (int)Math.min((long)this.buffer.length, size - (long)off);
            buf.get((long)off, this.buffer, 0, chunkSize);
            ByteBuffer wrap = ByteBuffer.wrap(this.buffer);
            wrap.limit(chunkSize);
            while (wrap.remaining() > 0) {
                int ww = this.channel.write(wrap);
                if (ww >= 0) continue;
                throw new EOFException();
            }
            off += chunkSize;
        }
        this.written.set(true);
        return off;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        this.triggers.forEach(booleanConsumer -> booleanConsumer.accept(this.written.get()));
    }

    public void onClose(Consumer<Boolean> trigger) {
        this.triggers.add(trigger);
    }
}

