/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.channels.ClosedChannelException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jnr.ffi.Pointer;
import jnr.ffi.types.mode_t;
import jnr.ffi.types.off_t;
import jnr.ffi.types.size_t;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.serce.jnrfuse.ErrorCodes;
import ru.serce.jnrfuse.FuseFillDir;
import ru.serce.jnrfuse.FuseStubFS;
import ru.serce.jnrfuse.struct.FileStat;
import ru.serce.jnrfuse.struct.FuseFileInfo;
import ru.serce.jnrfuse.struct.Statvfs;
import ru.serce.jnrfuse.struct.Timespec;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.FileContents;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyScript;

public class LzyFS
extends FuseStubFS {
    private static final Logger LOG = LogManager.getLogger(LzyFS.class);
    private static final int BLOCK_SIZE = 4096;
    private Map<Path, Set<String>> children = Collections.synchronizedMap(new HashMap());
    private Set<String> roots = Collections.synchronizedSet(new HashSet());
    private Map<Path, LzyScript> executables = Collections.synchronizedMap(new HashMap());
    private Map<Path, LzyFileSlot> slots = Collections.synchronizedMap(new HashMap());
    private Map<Long, FileContents> openFiles = Collections.synchronizedMap(new HashMap());
    private Map<Path, Set<Long>> filesOpen = Collections.synchronizedMap(new HashMap());
    private AtomicLong lastFh = new AtomicLong(1000L);
    private static long userId;
    private static long groupId;
    private static long startTime;

    public LzyFS() {
        this.children.put(Path.of("/", new String[0]), this.roots);
        this.roots.addAll(LzyFS.roots());
        for (String root : this.roots) {
            this.children.put(Paths.get("/", root), new HashSet());
        }
    }

    public static Set<String> roots() {
        return Set.of("sbin", "bin", "dev");
    }

    public void addScript(LzyScript exec, boolean isSystem) {
        Path execPath = Paths.get(isSystem ? "/sbin" : "/bin", new String[0]).resolve(exec.location());
        if (this.executables.put(execPath, exec) == null) {
            this.addPath(execPath);
        }
    }

    public void addSlot(LzyFileSlot slot) {
        this.addPath(slot.location());
        this.slots.put(slot.location(), slot);
    }

    public void removeSlot(String name) {
        Set children;
        Path parent;
        Path path = Paths.get(name, new String[0]);
        if (this.slots.remove(path) == null) {
            return;
        }
        name = path.getFileName().toString();
        if (!((Set)this.children.getOrDefault(parent, new HashSet())).remove(name)) {
            return;
        }
        for (parent = path.getParent(); parent != null && (children = this.children.computeIfAbsent(parent, p -> new HashSet())).remove(name) && children.isEmpty(); parent = parent.getParent()) {
            this.children.remove(parent);
            if (parent.getFileName() == null) break;
            name = parent.getFileName().toString();
        }
    }

    private boolean addPath(Path path) {
        Set children;
        String name = path.getFileName().toString();
        Path parent = path.getParent();
        if (this.children.getOrDefault(parent, Set.of()).contains(name)) {
            return false;
        }
        while (parent != null && !(children = this.children.computeIfAbsent(parent, p -> new HashSet())).contains(name)) {
            children.add(name);
            if (parent.getFileName() == null) break;
            name = parent.getFileName().toString();
            parent = parent.getParent();
        }
        return true;
    }

    @Override
    public int create(String path, @mode_t long mode, FuseFileInfo fi) {
        return -ErrorCodes.EACCES();
    }

    @Override
    public int mkdir(String pathStr, @mode_t long mode) {
        Path path = Paths.get(pathStr, new String[0]);
        if (!this.children.containsKey(path.getParent())) {
            return -ErrorCodes.ENOENT();
        }
        return this.addPath(path) ? 0 : -ErrorCodes.EALREADY();
    }

    @Override
    public int open(String pathStr, FuseFileInfo fi) {
        Path path = Path.of(pathStr, new String[0]);
        long fh = this.lastFh.addAndGet(1L);
        if (this.executables.containsKey(path)) {
            FileContents.Text open = new FileContents.Text(path, this.executables.get(path).scriptText());
            this.openFiles.put(fh, open);
            this.filesOpen.computeIfAbsent(path, p -> new HashSet()).add(fh);
            fi.fh.set(fh);
            return 0;
        }
        if (this.slots.containsKey(path)) {
            return LzyFS.executeUnsafe(() -> {
                FileContents open = this.slots.get(path).open(fi);
                this.openFiles.put(fh, open);
                this.filesOpen.computeIfAbsent(path, p -> new HashSet()).add(fh);
                fi.fh.set(fh);
            });
        }
        return -ErrorCodes.ENOENT();
    }

    @Override
    public int release(String pathStr, FuseFileInfo fi) {
        FileContents contents = this.openFiles.remove(fi.fh.longValue());
        try {
            if (contents == null) {
                return -ErrorCodes.EBADFD();
            }
            contents.close();
            Path path = Paths.get(pathStr, new String[0]);
            Set<Long> fhs = this.filesOpen.get(path);
            fhs.remove(fi.fh.longValue());
            if (fhs.isEmpty()) {
                this.filesOpen.remove(path);
            }
            return 0;
        }
        catch (IOException ioe) {
            return -ErrorCodes.EBADF();
        }
    }

    @Override
    public int read(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        FileContents contents = this.openFiles.get(fi.fh.longValue());
        if (contents == null) {
            return -ErrorCodes.EBADFD();
        }
        return LzyFS.executeUnsafeInt(() -> contents.read(buf, offset, size));
    }

    @Override
    public int write(String path, Pointer buf, @size_t long size, @off_t long offset, FuseFileInfo fi) {
        FileContents contents = this.openFiles.get(fi.fh.longValue());
        if (contents == null) {
            return -ErrorCodes.EBADFD();
        }
        return LzyFS.executeUnsafeInt(() -> contents.write(buf, offset, size));
    }

    @Override
    public int getattr(String pathStr, FileStat stat) {
        Path path = Path.of(pathStr, new String[0]).toAbsolutePath();
        long time = startTime;
        if (this.children.containsKey(path) || path.equals(Path.of("/", new String[0]))) {
            stat.st_mode.set(16872);
            long size = this.children.getOrDefault(path, Set.of()).stream().mapToLong(String::length).sum() + 64L;
            stat.st_size.set(size);
        } else if (this.executables.containsKey(path)) {
            LzyScript executable = this.executables.get(path);
            stat.st_mode.set(33256);
            stat.st_size.set(executable.scriptText().length());
        } else if (this.slots.containsKey(path)) {
            LzyFileSlot slot = this.slots.get(path);
            time = -1L;
            long mtime = slot.mtime();
            stat.st_mtim.tv_sec.set(TimeUnit.MILLISECONDS.toSeconds(mtime));
            stat.st_mtim.tv_nsec.set(TimeUnit.MILLISECONDS.toNanos(mtime));
            long atime = slot.atime();
            stat.st_atim.tv_sec.set(TimeUnit.MILLISECONDS.toSeconds(atime));
            stat.st_atim.tv_nsec.set(TimeUnit.MILLISECONDS.toNanos(atime));
            long ctime = slot.ctime();
            stat.st_ctim.tv_sec.set(TimeUnit.MILLISECONDS.toSeconds(ctime));
            stat.st_ctim.tv_nsec.set(TimeUnit.MILLISECONDS.toNanos(ctime));
            stat.st_mode.set(0x1A0 | slot.mtype());
            stat.st_size.set(slot.size());
        } else {
            return -ErrorCodes.ENOENT();
        }
        stat.st_uid.set(userId);
        stat.st_gid.set(groupId);
        stat.st_blksize.set(4096L);
        stat.st_blocks.set((long)Math.ceil((double)stat.st_size.longValue() / 4096.0));
        if (time > 0L) {
            stat.st_mtim.tv_sec.set(TimeUnit.MILLISECONDS.toSeconds(time));
            stat.st_mtim.tv_nsec.set(TimeUnit.MILLISECONDS.toNanos(time));
            stat.st_atim.tv_sec.set(TimeUnit.MILLISECONDS.toSeconds(time));
            stat.st_atim.tv_nsec.set(TimeUnit.MILLISECONDS.toNanos(time));
        }
        return 0;
    }

    @Override
    public int readdir(String pathStr, Pointer buf, FuseFillDir filter, @off_t long offset, FuseFileInfo fi) {
        Path path = Paths.get(pathStr, new String[0]);
        Set children = this.children.getOrDefault(path, Set.of());
        if (children == null) {
            return this.executables.containsKey(path) || this.slots.containsKey(path) ? -ErrorCodes.ENOTDIR() : -ErrorCodes.ENOENT();
        }
        children.stream().sorted().forEach(child -> {
            FileStat lstat = new FileStat(buf.getRuntime());
            if (this.getattr(path.resolve((String)child).toString(), lstat) == 0) {
                filter.apply(buf, (String)child, lstat, 0L);
            }
        });
        return 0;
    }

    @Override
    public int chmod(String path, long mode) {
        return -ErrorCodes.EACCES();
    }

    @Override
    public int chown(String path, long uid, long gid) {
        return -ErrorCodes.EACCES();
    }

    @Override
    public int utimens(String path, Timespec[] timespec) {
        return -ErrorCodes.EACCES();
    }

    @Override
    public int statfs(String path, Statvfs stbuf) {
        stbuf.f_bsize.set(4096);
        stbuf.f_frsize.set(0x400000);
        stbuf.f_blocks.set(Integer.MAX_VALUE);
        stbuf.f_bfree.set(Integer.MAX_VALUE);
        stbuf.f_bavail.set(Integer.MAX_VALUE);
        stbuf.f_flag.set(3204);
        return 0;
    }

    @Override
    public int rename(String path, String newName) {
        return -ErrorCodes.EACCES();
    }

    @Override
    public int rmdir(String path) {
        return -ErrorCodes.EACCES();
    }

    @Override
    public int truncate(String pathStr, long offset) {
        Path path = Paths.get(pathStr, new String[0]);
        if (this.slots.containsKey(path)) {
            return 0;
        }
        return -ErrorCodes.EACCES();
    }

    @Override
    public int unlink(String pathStr) {
        Path path = Paths.get(pathStr, new String[0]);
        if (this.filesOpen.containsKey(path)) {
            return -ErrorCodes.EBUSY();
        }
        if (this.children.containsKey(path)) {
            if (this.children.get(path).isEmpty()) {
                this.children.remove(path);
                Path parent = path.getParent();
                if (parent != null) {
                    this.children.get(parent).remove(path.getFileName().toString());
                } else {
                    this.roots.remove(path.getFileName().toString());
                }
            }
        } else {
            if (this.executables.containsKey(path)) {
                return -ErrorCodes.EACCES();
            }
            if (this.slots.containsKey(path)) {
                LzyFileSlot slot = this.slots.remove(path);
                return LzyFS.executeUnsafe(slot::remove);
            }
        }
        return -ErrorCodes.ENOENT();
    }

    public static int executeUnsafe(UnsafeIOOperation op) {
        return LzyFS.executeUnsafeInt(() -> {
            op.execute();
            return 0;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executeUnsafeInt(UnsafeIntIOOperation op) {
        try {
            try {
                return op.execute();
            }
            catch (IOException ioe) {
                try {
                    LOG.info("IOE", (Throwable)ioe);
                    throw ioe;
                }
                catch (IOException e) {
                    LOG.warn("Unexpected exception during I/O operation", (Throwable)e);
                    return -ErrorCodes.EIO();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            if (fnfe.getMessage().contains("Is a directory")) {
                return -ErrorCodes.EISDIR();
            }
            return -ErrorCodes.ENOENT();
        }
        catch (NoSuchFileException nsfe) {
            return -ErrorCodes.ENOENT();
        }
        catch (FileAlreadyExistsException faee) {
            return -ErrorCodes.EEXIST();
        }
        catch (DirectoryNotEmptyException dnee) {
            return -ErrorCodes.ENOTEMPTY();
        }
        catch (AccessDeniedException ade) {
            return -ErrorCodes.EACCES();
        }
        catch (ClosedChannelException ce) {
            return -ErrorCodes.EBADF();
        }
    }

    public static String lineCmd(String cmd) throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec(cmd);
        p.waitFor();
        try (LineNumberReader rd = new LineNumberReader(new InputStreamReader(p.getInputStream()));){
            String string = rd.readLine();
            return string;
        }
    }

    static {
        try {
            startTime = System.currentTimeMillis();
            userId = Long.parseLong(LzyFS.lineCmd("id -u"));
            groupId = Long.parseLong(LzyFS.lineCmd("id -g"));
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("Unable to get group and user id on startup");
        }
    }

    public static interface UnsafeIntIOOperation {
        public int execute() throws IOException;
    }

    public static interface UnsafeIOOperation {
        public void execute() throws IOException;
    }
}

