/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.fs;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import jnr.ffi.Pointer;

public interface FileContents
extends Closeable {
    public int read(Pointer var1, long var2, long var4) throws IOException;

    public int write(Pointer var1, long var2, long var4) throws IOException;

    public static class Text
    implements FileContents {
        private final Path to;
        private final byte[] bytes;

        public Text(Path to, CharSequence seq) {
            this.to = to;
            this.bytes = seq.toString().getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public int read(Pointer buf, long offset, long size) {
            int bytesToRead = (int)Math.min((long)this.bytes.length - offset, size);
            buf.put(0L, this.bytes, (int)offset, bytesToRead);
            return bytesToRead;
        }

        @Override
        public int write(Pointer buf, long offset, long size) throws IOException {
            throw new AccessDeniedException(this.to.toAbsolutePath().toString());
        }

        @Override
        public void close() {
        }
    }
}

