/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.env;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Scanner;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.graph.PythonEnv;
import ru.yandex.cloud.ml.platform.lzy.servant.env.Connector;

public class CondaEnvConnector
implements Connector {
    private static final Logger LOG = LogManager.getLogger(CondaEnvConnector.class);
    private final PythonEnv env;
    private final AtomicBoolean envInstalled = new AtomicBoolean(false);

    public CondaEnvConnector(PythonEnv env) {
        this.env = env;
    }

    private void logStream(InputStream stream, boolean warn) {
        Scanner scanner = new Scanner(stream);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (warn) {
                LOG.warn(line);
                continue;
            }
            LOG.info(line);
        }
    }

    private int execAndLog(String command) throws IOException, InterruptedException {
        Process run = this.exec(command);
        int res = run.waitFor();
        this.logStream(run.getInputStream(), false);
        this.logStream(run.getErrorStream(), true);
        return res;
    }

    private void installPyenv() throws IOException, InterruptedException {
        File yaml = File.createTempFile("conda", "req.yaml");
        try (FileWriter file = new FileWriter(yaml.getAbsolutePath());){
            file.write(this.env.yaml());
        }
        int rc = this.execAndLog("conda env update --file " + yaml.getAbsolutePath());
        if (rc > 0) {
            throw new IOException("Failed to update conda env");
        }
    }

    @Override
    public Process exec(String command) throws IOException, InterruptedException {
        if (this.envInstalled.compareAndSet(false, true)) {
            this.installPyenv();
        }
        LOG.info("Executing command " + command);
        return Runtime.getRuntime().exec(new String[]{"bash", "-c", "eval \"$(conda shell.bash hook)\" && conda activate " + this.env.name() + " && " + command});
    }
}

