/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.commands;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.model.Zygote;
import ru.yandex.cloud.ml.platform.lzy.model.gRPCConverter;
import ru.yandex.cloud.ml.platform.lzy.servant.commands.LzyCommand;
import yandex.cloud.priv.datasphere.v2.lzy.Channels;
import yandex.cloud.priv.datasphere.v2.lzy.IAM;
import yandex.cloud.priv.datasphere.v2.lzy.LzyKharonGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.LzyServantGrpc;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;
import yandex.cloud.priv.datasphere.v2.lzy.Tasks;

public class Run
implements LzyCommand {
    private static final Logger LOG = LogManager.getLogger(Run.class);
    private static final int BUFFER_SIZE = 4096;
    private static final Options options = new Options();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private LzyKharonGrpc.LzyKharonBlockingStub kharon;
    private IAM.Auth auth;
    private Map<String, Map<String, String>> pipesConfig;
    private LzyServantGrpc.LzyServantBlockingStub servant;
    private long pid;
    private String lzyRoot;
    private String stdinChannel;
    private final CountDownLatch communicationLatch = new CountDownLatch(3);

    @Override
    public int execute(CommandLine command) throws Exception {
        CommandLine localCmd;
        HelpFormatter cliHelp = new HelpFormatter();
        try {
            localCmd = new DefaultParser().parse(options, command.getArgs(), false);
        }
        catch (ParseException e2) {
            cliHelp.printHelp("channel", options);
            return -1;
        }
        HashMap bindings = new HashMap();
        if (localCmd.hasOption('m')) {
            String mappingFile = localCmd.getOptionValue('m');
            LOG.info("Read mappings from file " + mappingFile);
            bindings.putAll(this.objectMapper.readValue(new File(mappingFile), Map.class));
            LOG.info("Bindings: " + bindings.entrySet().stream().map(e -> (String)e.getKey() + " -> " + (String)e.getValue()).collect(Collectors.joining(";\n")));
        }
        this.lzyRoot = command.getOptionValue('m');
        this.pid = ProcessHandle.current().pid();
        this.pipesConfig = this.pipesConfig();
        URI serverAddr = URI.create(command.getOptionValue('z'));
        this.auth = IAM.Auth.parseFrom(Base64.getDecoder().decode(command.getOptionValue('a')));
        ManagedChannel serverCh = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(serverAddr.getHost(), serverAddr.getPort()).usePlaintext()).build();
        this.kharon = LzyKharonGrpc.newBlockingStub(serverCh);
        ManagedChannel servant = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress("localhost", Integer.parseInt(command.getOptionValue('p'))).usePlaintext()).build();
        this.servant = LzyServantGrpc.newBlockingStub(servant);
        Operations.Zygote.Builder builder = Operations.Zygote.newBuilder();
        JsonFormat.parser().merge(System.getenv("ZYGOTE"), (Message.Builder)builder);
        Operations.Zygote grpcZygote = builder.build();
        Zygote zygote = gRPCConverter.from(grpcZygote);
        Tasks.TaskSpec.Builder taskSpec = Tasks.TaskSpec.newBuilder();
        taskSpec.setAuth(this.auth);
        taskSpec.setZygote(grpcZygote);
        zygote.slots().forEach(slot -> {
            LOG.info("Resolving slot " + slot.name());
            Object binding = slot.media() == Slot.Media.ARG ? String.join((CharSequence)" ", command.getArgList().subList(1, command.getArgList().size())) : (bindings.containsKey(slot.name()) ? "channel:" + (String)bindings.get(slot.name()) : "channel:" + this.resolveChannel((Slot)slot));
            taskSpec.addAssignmentsBuilder().setSlot(gRPCConverter.to(slot)).setBinding((String)binding).build();
        });
        Iterator<Servant.ExecutionProgress> executionProgress = this.kharon.start(taskSpec.build());
        executionProgress.forEachRemaining(progress -> {
            try {
                LOG.info(JsonFormat.printer().print((MessageOrBuilder)progress));
                if (progress.hasDetach() && "/dev/stdin".equals(progress.getDetach().getSlot().getName())) {
                    LOG.info("Closing stdin");
                    System.in.close();
                }
            }
            catch (InvalidProtocolBufferException e) {
                LOG.warn("Unable to parse execution progress", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error("Failed to close stdin", (Throwable)e);
            }
        });
        LOG.info("Run:: Task finished");
        this.communicationLatch.await();
        this.destroyChannel(this.stdinChannel);
        return 0;
    }

    private Map<String, Map<String, String>> pipesConfig() throws IOException {
        Process p = Runtime.getRuntime().exec("lsof -p " + this.pid + " -a -d0,1,2 -F ftidn");
        InputStreamReader inputStreamReader = new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8);
        String[] fdNames = new String[]{"stdin", "stdout", "stderr"};
        HashMap<String, Map<String, String>> pipeMappings = new HashMap<String, Map<String, String>>();
        try (LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);){
            Object line;
            String name = null;
            Map<Character, String> namesMappings = Map.of(Character.valueOf('t'), "type", Character.valueOf('d'), "device", Character.valueOf('i'), "node", Character.valueOf('n'), "name");
            block10: while ((line = lineNumberReader.readLine()) != null) {
                if (((String)line).isEmpty()) continue;
                switch (((String)line).charAt(0)) {
                    case 'p': {
                        continue block10;
                    }
                    case 'f': {
                        if (!Character.isDigit(((String)line).charAt(((String)line).length() - 1))) {
                            line = ((String)line).substring(0, ((String)line).length() - 1);
                        }
                        name = fdNames[Integer.parseInt(((String)line).substring(1))];
                        continue block10;
                    }
                    case 'n': {
                        if (!((String)line).substring(1).startsWith("->")) break;
                        line = "n" + ((String)line).substring(3);
                    }
                }
                pipeMappings.computeIfAbsent(name, n -> new HashMap()).put(namesMappings.getOrDefault(Character.valueOf(((String)line).charAt(0)), "unknown"), ((String)line).substring(1));
            }
        }
        return pipeMappings;
    }

    private String resolveChannel(Slot slot) {
        LOG.info("Creating custom slot " + slot.name());
        String prefix = (this.auth.hasTask() ? this.auth.getTask().getTaskId() : this.auth.getUser().getUserId()) + ":" + this.pid;
        if (slot.name().startsWith("/dev/")) {
            String devSlot = slot.name().substring("/dev/".length());
            Map<String, String> pipeConfig = this.pipesConfig.get(devSlot);
            switch (devSlot) {
                case "stdin": {
                    boolean pipe = false;
                    if (!pipeConfig.getOrDefault("node", "").isEmpty()) {
                        this.stdinChannel = prefix + ":" + devSlot + ":" + pipeConfig.get("node");
                        pipe = true;
                    } else if (!pipeConfig.getOrDefault("name", "").isEmpty()) {
                        this.stdinChannel = prefix + ":" + devSlot + ":" + pipeConfig.get("name");
                        pipe = true;
                    } else {
                        this.stdinChannel = UUID.randomUUID().toString();
                    }
                    String slotName = String.join((CharSequence)"/", "/tasks", prefix, devSlot);
                    this.createChannel(slot, this.stdinChannel);
                    this.createSlotByProto(prefix + ":" + devSlot, pipe, "channel:" + this.stdinChannel, slotName, Slot.STDOUT);
                    Path inputSlotFile = Path.of(this.lzyRoot, slotName);
                    ForkJoinPool.commonPool().execute(() -> {
                        byte[] buffer = new byte[4096];
                        try (OutputStream is = Files.newOutputStream(inputSlotFile, StandardOpenOption.WRITE);){
                            int read;
                            while (System.in.available() > 0 && (read = System.in.read(buffer)) >= 0) {
                                is.write(buffer, 0, read);
                            }
                        }
                        catch (IOException e) {
                            LOG.warn("Unable to read from input stream", (Throwable)e);
                        }
                        LOG.info("Slot {} has been processed, counting down latch", (Object)devSlot);
                        this.communicationLatch.countDown();
                    });
                    return this.stdinChannel;
                }
                case "stdout": 
                case "stderr": {
                    Object channelName;
                    boolean pipe = false;
                    if (!pipeConfig.getOrDefault("node", "").isEmpty()) {
                        channelName = prefix + ":" + devSlot + ":" + pipeConfig.get("node");
                        pipe = true;
                    } else if (pipeConfig.getOrDefault("device", "").startsWith("0x")) {
                        channelName = prefix + ":" + devSlot + ":" + pipeConfig.get("name");
                        pipe = true;
                    } else {
                        channelName = UUID.randomUUID().toString();
                    }
                    String slotName = String.join((CharSequence)"/", "/tasks", prefix, devSlot);
                    String channelId = this.createChannel(slot, (String)channelName);
                    this.createSlotByProto(prefix + ":" + devSlot, pipe, channelId, slotName, Slot.STDIN);
                    Path outputSlotFile = Path.of(this.lzyRoot, slotName);
                    ForkJoinPool.commonPool().execute(() -> this.lambda$resolveChannel$5(outputSlotFile, devSlot, (String)channelName));
                    return channelId;
                }
            }
            throw new IllegalArgumentException(MessageFormat.format("Illegal slot found: {0}", slot.name()));
        }
        throw new IllegalArgumentException(MessageFormat.format("Slot {0} assignment is not specified", slot.name()));
    }

    private void createSlotByProto(String name, boolean pipe, String channelId, String slotName, Slot slotProto) {
        try {
            Operations.Slot slotDeclaration = Operations.Slot.newBuilder(gRPCConverter.to(slotProto)).setName(slotName).build();
            this.servant.configureSlot(Servant.SlotCommand.newBuilder().setSlot(name).setCreate(Servant.CreateSlotCommand.newBuilder().setSlot(slotDeclaration).setIsPipe(pipe).setChannelId(channelId).build()).build());
        }
        catch (Exception e) {
            LOG.warn("Unable to create slot: " + slotName, (Throwable)e);
        }
    }

    private void destroyChannel(String channelName) {
        this.kharon.channel(Channels.ChannelCommand.newBuilder().setAuth(this.auth).setChannelName(channelName).setDestroy(Channels.ChannelDestroy.newBuilder().build()).build());
    }

    private String createChannel(Slot slot, String channelName) {
        Channels.ChannelStatus channel = this.kharon.channel(Channels.ChannelCommand.newBuilder().setAuth(this.auth).setChannelName(channelName).setCreate(Channels.ChannelCreate.newBuilder().setContentType(gRPCConverter.to(slot.contentType())).build()).build());
        return channel.getChannel().getChannelId();
    }

    private /* synthetic */ void lambda$resolveChannel$5(Path outputSlotFile, String devSlot, String channelName) {
        byte[] buffer = new byte[4096];
        try (InputStream is = Files.newInputStream(outputSlotFile, StandardOpenOption.READ);){
            int read;
            while ((read = is.read(buffer)) >= 0) {
                ("stderr".equals(devSlot) ? System.err : System.out).write(buffer, 0, read);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to read from " + devSlot, (Throwable)e);
        }
        this.destroyChannel(channelName);
        LOG.info("Slot {} has been processed, counting down latch", (Object)devSlot);
        this.communicationLatch.countDown();
    }

    static {
        options.addOption(new Option("m", "mapping", true, "Slot-channel mapping"));
    }
}

