/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.servant.agents;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.model.Zygote;
import ru.yandex.cloud.ml.platform.lzy.model.gRPCConverter;
import ru.yandex.cloud.ml.platform.lzy.model.graph.AtomicZygote;
import ru.yandex.cloud.ml.platform.lzy.model.graph.PythonEnv;
import ru.yandex.cloud.ml.platform.lzy.model.slots.TextLinesInSlot;
import ru.yandex.cloud.ml.platform.lzy.model.slots.TextLinesOutSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.env.CondaEnvConnector;
import ru.yandex.cloud.ml.platform.lzy.servant.env.Connector;
import ru.yandex.cloud.ml.platform.lzy.servant.env.SimpleBashConnector;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzyInputSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.fs.LzySlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.InFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LineReaderSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LocalOutFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.LzySlotBase;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.OutFileSlot;
import ru.yandex.cloud.ml.platform.lzy.servant.slots.WriterSlot;
import ru.yandex.cloud.ml.platform.model.util.lock.LocalLockManager;
import ru.yandex.cloud.ml.platform.model.util.lock.LockManager;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;
import yandex.cloud.priv.datasphere.v2.lzy.Servant;

public class LzyExecution {
    private static final Logger LOG = LogManager.getLogger(LzyExecution.class);
    private final String taskId;
    private final AtomicZygote zygote;
    private final LineReaderSlot stdoutSlot;
    private final LineReaderSlot stderrSlot;
    private final URI servantUri;
    private final WriterSlot stdinSlot;
    private Process exec;
    private String arguments = "";
    private final Map<String, LzySlot> slots = new ConcurrentHashMap<String, LzySlot>();
    private final List<Consumer<Servant.ExecutionProgress>> listeners = new ArrayList<Consumer<Servant.ExecutionProgress>>();
    private final LockManager lockManager = new LocalLockManager();

    public LzyExecution(String taskId, AtomicZygote zygote, URI servantUri) {
        this.taskId = taskId;
        this.zygote = zygote;
        this.stdinSlot = new WriterSlot(taskId, new TextLinesInSlot("/dev/stdin"));
        this.stdoutSlot = new LineReaderSlot(taskId, new TextLinesOutSlot("/dev/stdout"));
        this.stderrSlot = new LineReaderSlot(taskId, new TextLinesOutSlot("/dev/stderr"));
        this.servantUri = servantUri;
    }

    public LzySlot configureSlot(Slot spec, String binding) {
        LOG.info("LzyExecution::configureSlot " + spec.name() + " binding: " + binding);
        Lock lock = this.lockManager.getOrCreate(spec.name());
        lock.lock();
        try {
            if (this.slots.containsKey(spec.name())) {
                LzySlot lzySlot = this.slots.get(spec.name());
                return lzySlot;
            }
            LzySlot slot = this.createSlot(spec, binding);
            if (slot.state() != Operations.SlotStatus.State.DESTROYED) {
                LOG.info("LzyExecution::Slots.put(\n" + spec.name() + ",\n" + slot + "\n)");
                if (spec.name().startsWith("local://")) {
                    this.slots.put(spec.name().substring("local://".length()), slot);
                } else {
                    this.slots.put(spec.name(), slot);
                }
            }
            slot.onState(Operations.SlotStatus.State.SUSPENDED, () -> {
                if (this.zygote != null || spec.direction() == Slot.Direction.INPUT) {
                    this.progress(Servant.ExecutionProgress.newBuilder().setDetach(Servant.SlotDetach.newBuilder().setSlot(gRPCConverter.to(spec)).setUri(this.servantUri.toString() + spec.name()).build()).build());
                }
            });
            slot.onState(Operations.SlotStatus.State.DESTROYED, () -> {
                Map<String, LzySlot> map = this.slots;
                synchronized (map) {
                    LOG.info("LzyExecution::Slots.remove(\n" + slot.name() + "\n)");
                    this.slots.remove(slot.name());
                    this.slots.notifyAll();
                }
            });
            if (binding == null) {
                binding = "";
            } else if (binding.startsWith("channel:")) {
                binding = binding.substring("channel:".length());
            }
            String slotPath = URI.create(spec.name()).getPath();
            this.progress(Servant.ExecutionProgress.newBuilder().setAttach(Servant.SlotAttach.newBuilder().setChannel(binding).setSlot(gRPCConverter.to(spec)).setUri(this.servantUri.toString() + slotPath).build()).build());
            LOG.info("Configured slot " + spec.name() + " " + slot);
            LzySlot lzySlot = slot;
            return lzySlot;
        }
        finally {
            lock.unlock();
        }
    }

    public LzySlot createSlot(Slot spec, String binding) throws IOException {
        Lock lock = this.lockManager.getOrCreate(spec.name());
        lock.lock();
        try {
            if (spec.equals(Slot.STDIN)) {
                WriterSlot writerSlot = this.stdinSlot;
                return writerSlot;
            }
            if (spec.equals(Slot.STDOUT)) {
                LineReaderSlot lineReaderSlot = this.stdoutSlot;
                return lineReaderSlot;
            }
            if (spec.equals(Slot.STDERR)) {
                LineReaderSlot lineReaderSlot = this.stderrSlot;
                return lineReaderSlot;
            }
            switch (spec.media()) {
                case PIPE: 
                case FILE: {
                    switch (spec.direction()) {
                        case INPUT: {
                            InFileSlot inFileSlot = new InFileSlot(this.taskId, spec);
                            return inFileSlot;
                        }
                        case OUTPUT: {
                            if (spec.name().startsWith("local://")) {
                                LocalOutFileSlot localOutFileSlot = new LocalOutFileSlot(this.taskId, spec, URI.create(spec.name()));
                                return localOutFileSlot;
                            }
                            OutFileSlot outFileSlot = new OutFileSlot(this.taskId, spec);
                            return outFileSlot;
                        }
                    }
                    break;
                }
                case ARG: {
                    this.arguments = binding;
                    LzySlotBase lzySlotBase = new LzySlotBase(spec){};
                    return lzySlotBase;
                }
            }
            throw new UnsupportedOperationException("Not implemented yet");
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.zygote == null) {
            throw new IllegalStateException("Unable to start execution while in terminal mode");
        }
        if (this.exec != null) {
            throw new IllegalStateException("LzyExecution has been already started");
        }
        try {
            Connector session;
            this.progress(Servant.ExecutionProgress.newBuilder().setStarted(Servant.ExecutionStarted.newBuilder().build()).build());
            if (this.zygote.env() instanceof PythonEnv) {
                session = new CondaEnvConnector((PythonEnv)this.zygote.env());
                LOG.info("Conda environment is provided, using CondaEnvConnector");
            } else {
                session = new SimpleBashConnector();
                LOG.info("No environment provided, using SimpleBashConnector");
            }
            String command = this.zygote.fuze() + " " + this.arguments;
            LOG.info("Going to exec command " + command);
            this.exec = session.exec(command);
            this.stdinSlot.setStream(new OutputStreamWriter(this.exec.getOutputStream(), StandardCharsets.UTF_8));
            this.stdoutSlot.setStream(new LineNumberReader(new InputStreamReader(this.exec.getInputStream(), StandardCharsets.UTF_8)));
            this.stderrSlot.setStream(new LineNumberReader(new InputStreamReader(this.exec.getErrorStream(), StandardCharsets.UTF_8)));
            int rc = this.exec.waitFor();
            Set.copyOf(this.slots.values()).stream().filter(s -> s instanceof LzyInputSlot).forEach(LzySlot::suspend);
            if (rc != 0) {
                Set.copyOf(this.slots.values()).stream().filter(s -> s instanceof OutFileSlot).map(s -> (OutFileSlot)s).forEach(OutFileSlot::flush);
            }
            Map<String, LzySlot> map = this.slots;
            synchronized (map) {
                LOG.info("Slots: " + Arrays.toString(this.slots().map(LzySlot::name).toArray()));
                while (!this.slots.isEmpty()) {
                    this.slots.wait();
                }
            }
            this.progress(Servant.ExecutionProgress.newBuilder().setExit(Servant.ExecutionConcluded.newBuilder().setRc(rc).build()).build());
        }
        catch (IOException | InterruptedException e) {
            LOG.warn("Exception during task execution", (Throwable)e);
            this.progress(Servant.ExecutionProgress.newBuilder().setExit(Servant.ExecutionConcluded.newBuilder().setRc(-1).build()).build());
        }
    }

    public Stream<LzySlot> slots() {
        return this.slots.values().stream();
    }

    public synchronized void progress(Servant.ExecutionProgress progress) {
        this.listeners.forEach(l -> l.accept(progress));
    }

    public synchronized void onProgress(Consumer<Servant.ExecutionProgress> listener) {
        this.listeners.add(listener);
    }

    public LzySlot slot(String name) {
        return this.slots.get(name);
    }

    public void signal(int sigValue) {
        try {
            Runtime.getRuntime().exec("kill -" + sigValue + " " + this.exec.pid());
        }
        catch (IOException e) {
            LOG.warn("Unable to send signal to process", (Throwable)e);
        }
    }

    public Zygote zygote() {
        return this.zygote;
    }
}

