/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.cloud.ml.platform.lzy.model;

import java.net.URI;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import ru.yandex.cloud.ml.platform.lzy.model.Channel;
import ru.yandex.cloud.ml.platform.lzy.model.Slot;
import ru.yandex.cloud.ml.platform.lzy.model.SlotStatus;
import ru.yandex.cloud.ml.platform.lzy.model.Zygote;
import ru.yandex.cloud.ml.platform.lzy.model.data.DataSchema;
import ru.yandex.cloud.ml.platform.lzy.model.graph.AtomicZygote;
import ru.yandex.cloud.ml.platform.lzy.model.graph.Env;
import ru.yandex.cloud.ml.platform.lzy.model.graph.Provisioning;
import ru.yandex.cloud.ml.platform.lzy.model.graph.PythonEnv;
import yandex.cloud.priv.datasphere.v2.lzy.Channels;
import yandex.cloud.priv.datasphere.v2.lzy.Operations;

public abstract class gRPCConverter {
    public static Zygote from(Operations.Zygote grpcOperation) {
        return new AtomicZygoteAdapter(grpcOperation);
    }

    public static Operations.Zygote to(Zygote zygote) {
        Operations.Zygote.Builder builder = Operations.Zygote.newBuilder();
        if (zygote instanceof AtomicZygote) {
            AtomicZygote atomicZygote = (AtomicZygote)zygote;
            builder.setEnv(gRPCConverter.to(atomicZygote.env()));
            builder.setProvisioning(gRPCConverter.to(atomicZygote.provisioning()));
            builder.setFuze(atomicZygote.fuze());
            Stream.concat(Stream.of(atomicZygote.input()), Stream.of(atomicZygote.output())).forEach(slot -> builder.addSlots(gRPCConverter.to(slot)));
        }
        return builder.build();
    }

    public static Operations.Env to(Env env) {
        Operations.Env.Builder builder = Operations.Env.newBuilder();
        if (env instanceof PythonEnv) {
            builder.setPyenv(gRPCConverter.to((PythonEnv)env));
        }
        return builder.build();
    }

    public static Operations.PythonEnv to(PythonEnv env) {
        return Operations.PythonEnv.newBuilder().setName(env.name()).setYaml(env.yaml()).build();
    }

    public static Operations.Slot to(Slot slot) {
        return Operations.Slot.newBuilder().setName(slot.name()).setMedia(Operations.Slot.Media.valueOf(slot.media().name())).setDirection(Operations.Slot.Direction.valueOf(slot.direction().name())).setContentType(gRPCConverter.to(slot.contentType())).build();
    }

    public static Slot from(Operations.Slot grpcSlot) {
        return new SlotAdapter(grpcSlot);
    }

    public static SlotStatus from(Operations.SlotStatus slotStatus) {
        return new SlotStatusAdapter(slotStatus);
    }

    public static String to(DataSchema contentType) {
        return "not implemented yet";
    }

    public static DataSchema contentTypeFrom(String contentTypeJson) {
        return null;
    }

    private static String to(Provisioning provisioning) {
        return "not implemented yet";
    }

    private static Provisioning provisioningFrom(String contentType) {
        return null;
    }

    private static Env envFrom(Operations.Env env) {
        if (env.hasPyenv()) {
            return gRPCConverter.envFrom(env.getPyenv());
        }
        return null;
    }

    private static PythonEnv envFrom(Operations.PythonEnv env) {
        return new PythonEnvAdapter(env);
    }

    public static Channels.Channel to(Channel channel) {
        Channels.Channel.Builder builder = Channels.Channel.newBuilder();
        builder.setChannelId(channel.name().toString());
        builder.setContentType(gRPCConverter.to(channel.contentType()));
        return builder.build();
    }

    private static class PythonEnvAdapter
    implements PythonEnv {
        private final Operations.PythonEnv env;

        public PythonEnvAdapter(Operations.PythonEnv env) {
            this.env = env;
        }

        @Override
        public String name() {
            return this.env.getName();
        }

        @Override
        public String yaml() {
            return this.env.getYaml();
        }
    }

    private static class SlotStatusAdapter
    implements SlotStatus {
        private final Operations.SlotStatus slotStatus;

        SlotStatusAdapter(Operations.SlotStatus slotStatus) {
            this.slotStatus = slotStatus;
        }

        @Override
        @Nullable
        public String channelId() {
            return this.slotStatus.getConnectedTo();
        }

        @Override
        public String user() {
            return this.slotStatus.getUser();
        }

        @Override
        public UUID tid() {
            return this.slotStatus.getTaskId() != null && !this.slotStatus.getTaskId().isEmpty() ? UUID.fromString(this.slotStatus.getTaskId()) : null;
        }

        @Override
        public Slot slot() {
            return gRPCConverter.from(this.slotStatus.getDeclaration());
        }

        @Override
        public URI connected() {
            return this.slotStatus.getConnectedTo().isEmpty() ? null : URI.create(this.slotStatus.getConnectedTo());
        }

        @Override
        public long pointer() {
            return this.slotStatus.getPointer();
        }

        @Override
        public SlotStatus.State state() {
            return SlotStatus.State.valueOf(this.slotStatus.getState().name());
        }
    }

    private static class SlotAdapter
    implements Slot {
        private final Operations.Slot s;

        SlotAdapter(Operations.Slot s) {
            this.s = s;
        }

        @Override
        public String name() {
            return this.s.getName();
        }

        @Override
        public Slot.Media media() {
            return Slot.Media.valueOf(this.s.getMedia().name());
        }

        @Override
        public Slot.Direction direction() {
            return Slot.Direction.valueOf(this.s.getDirection().name());
        }

        @Override
        @Nullable
        public DataSchema contentType() {
            return gRPCConverter.contentTypeFrom(this.s.getContentType());
        }

        public int hashCode() {
            return this.s.getName().hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof Slot && ((Slot)obj).name().equals(this.s.getName());
        }
    }

    private static class AtomicZygoteAdapter
    implements AtomicZygote {
        private final Operations.Zygote operation;

        AtomicZygoteAdapter(Operations.Zygote operation) {
            this.operation = operation;
        }

        @Override
        public void run() {
        }

        @Override
        public Slot[] input() {
            return (Slot[])this.operation.getSlotsList().stream().filter(s -> s.getDirection() == Operations.Slot.Direction.INPUT).map(SlotAdapter::new).toArray(Slot[]::new);
        }

        @Override
        public Slot[] output() {
            return (Slot[])this.operation.getSlotsList().stream().filter(s -> s.getDirection() == Operations.Slot.Direction.OUTPUT).map(SlotAdapter::new).toArray(Slot[]::new);
        }

        @Override
        public Env env() {
            return gRPCConverter.envFrom(this.operation.getEnv());
        }

        @Override
        public Provisioning provisioning() {
            return gRPCConverter.provisioningFrom(this.operation.getProvisioning());
        }

        @Override
        public String fuze() {
            return this.operation.getFuze();
        }
    }
}

