/*! Copyright (c) 2011 Brandon Aaron (http://brandonaaron.net)
* Licensed under the MIT License (LICENSE.txt).
*
* Thanks to: http://adomas.org/javascript-mouse-wheel/ for some pointers.
* Thanks to: Mathias Bank(http://www.mathias-bank.de) for a scope bug fix.
* Thanks to: Seamus Leahy for adding deltaX and deltaY
*
* Version: 3.0.6
*
* Requires: 1.2.2+
*/

(function($) {

var types = ['DOMMouseScroll', 'mousewheel'];

if ($.event.fixHooks) {
    for ( var i=types.length; i; ) {
        $.event.fixHooks[ types[--i] ] = $.event.mouseHooks;
    }
}

$.event.special.mousewheel = {
    setup: function() {
        if ( this.addEventListener ) {
            for ( var i=types.length; i; ) {
                this.addEventListener( types[--i], handler, false );
            }
        } else {
            this.onmousewheel = handler;
        }
    },

    teardown: function() {
        if ( this.removeEventListener ) {
            for ( var i=types.length; i; ) {
                this.removeEventListener( types[--i], handler, false );
            }
        } else {
            this.onmousewheel = null;
        }
    }
};

$.fn.extend({
    mousewheel: function(fn) {
        return fn ? this.bind("mousewheel", fn) : this.trigger("mousewheel");
    },

    unmousewheel: function(fn) {
        return this.unbind("mousewheel", fn);
    }
});


function handler(event) {
    var orgEvent = event || window.event, args = [].slice.call( arguments, 1 ), delta = 0, returnValue = true, deltaX = 0, deltaY = 0;
    event = $.event.fix(orgEvent);
    event.type = "mousewheel";

    // Old school scrollwheel delta
    if ( orgEvent.wheelDelta ) { delta = orgEvent.wheelDelta/120; }
    if ( orgEvent.detail ) { delta = -orgEvent.detail/3; }

    // New school multidimensional scroll (touchpads) deltas
    deltaY = delta;

    // Gecko
    if ( orgEvent.axis !== undefined && orgEvent.axis === orgEvent.HORIZONTAL_AXIS ) {
        deltaY = 0;
        deltaX = -1*delta;
    }

    // Webkit
    if ( orgEvent.wheelDeltaY !== undefined ) { deltaY = orgEvent.wheelDeltaY/120; }
    if ( orgEvent.wheelDeltaX !== undefined ) { deltaX = -1*orgEvent.wheelDeltaX/120; }

    // Add event and delta to the front of the arguments
    args.unshift(event, delta, deltaX, deltaY);

    return ($.event.dispatch || $.event.handle).apply(this, args);
}

})(jQuery);

/*! jQuery UI - v1.10.3 - 2013-08-21
* http://jqueryui.com
* Includes: jquery.ui.core.js, jquery.ui.widget.js, jquery.ui.mouse.js, jquery.ui.position.js, jquery.ui.slider.js
* Copyright 2013 jQuery Foundation and other contributors Licensed MIT */

(function( $, undefined ) {

var uuid = 0,
	runiqueId = /^ui-id-\d+$/;

// $.ui might exist from components with no dependencies, e.g., $.ui.position
$.ui = $.ui || {};

$.extend( $.ui, {
	version: "1.10.3",

	keyCode: {
		BACKSPACE: 8,
		COMMA: 188,
		DELETE: 46,
		DOWN: 40,
		END: 35,
		ENTER: 13,
		ESCAPE: 27,
		HOME: 36,
		LEFT: 37,
		NUMPAD_ADD: 107,
		NUMPAD_DECIMAL: 110,
		NUMPAD_DIVIDE: 111,
		NUMPAD_ENTER: 108,
		NUMPAD_MULTIPLY: 106,
		NUMPAD_SUBTRACT: 109,
		PAGE_DOWN: 34,
		PAGE_UP: 33,
		PERIOD: 190,
		RIGHT: 39,
		SPACE: 32,
		TAB: 9,
		UP: 38
	}
});

// plugins
$.fn.extend({
	focus: (function( orig ) {
		return function( delay, fn ) {
			return typeof delay === "number" ?
				this.each(function() {
					var elem = this;
					setTimeout(function() {
						$( elem ).focus();
						if ( fn ) {
							fn.call( elem );
						}
					}, delay );
				}) :
				orig.apply( this, arguments );
		};
	})( $.fn.focus ),

	scrollParent: function() {
		var scrollParent;
		if (($.ui.ie && (/(static|relative)/).test(this.css("position"))) || (/absolute/).test(this.css("position"))) {
			scrollParent = this.parents().filter(function() {
				return (/(relative|absolute|fixed)/).test($.css(this,"position")) && (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
			}).eq(0);
		} else {
			scrollParent = this.parents().filter(function() {
				return (/(auto|scroll)/).test($.css(this,"overflow")+$.css(this,"overflow-y")+$.css(this,"overflow-x"));
			}).eq(0);
		}

		return (/fixed/).test(this.css("position")) || !scrollParent.length ? $(document) : scrollParent;
	},

	zIndex: function( zIndex ) {
		if ( zIndex !== undefined ) {
			return this.css( "zIndex", zIndex );
		}

		if ( this.length ) {
			var elem = $( this[ 0 ] ), position, value;
			while ( elem.length && elem[ 0 ] !== document ) {
				// Ignore z-index if position is set to a value where z-index is ignored by the browser
				// This makes behavior of this function consistent across browsers
				// WebKit always returns auto if the element is positioned
				position = elem.css( "position" );
				if ( position === "absolute" || position === "relative" || position === "fixed" ) {
					// IE returns 0 when zIndex is not specified
					// other browsers return a string
					// we ignore the case of nested elements with an explicit value of 0
					// <div style="z-index: -10;"><div style="z-index: 0;"></div></div>
					value = parseInt( elem.css( "zIndex" ), 10 );
					if ( !isNaN( value ) && value !== 0 ) {
						return value;
					}
				}
				elem = elem.parent();
			}
		}

		return 0;
	},

	uniqueId: function() {
		return this.each(function() {
			if ( !this.id ) {
				this.id = "ui-id-" + (++uuid);
			}
		});
	},

	removeUniqueId: function() {
		return this.each(function() {
			if ( runiqueId.test( this.id ) ) {
				$( this ).removeAttr( "id" );
			}
		});
	}
});

// selectors
function focusable( element, isTabIndexNotNaN ) {
	var map, mapName, img,
		nodeName = element.nodeName.toLowerCase();
	if ( "area" === nodeName ) {
		map = element.parentNode;
		mapName = map.name;
		if ( !element.href || !mapName || map.nodeName.toLowerCase() !== "map" ) {
			return false;
		}
		img = $( "img[usemap=#" + mapName + "]" )[0];
		return !!img && visible( img );
	}
	return ( /input|select|textarea|button|object/.test( nodeName ) ?
		!element.disabled :
		"a" === nodeName ?
			element.href || isTabIndexNotNaN :
			isTabIndexNotNaN) &&
		// the element and all of its ancestors must be visible
		visible( element );
}

function visible( element ) {
	return $.expr.filters.visible( element ) &&
		!$( element ).parents().addBack().filter(function() {
			return $.css( this, "visibility" ) === "hidden";
		}).length;
}

$.extend( $.expr[ ":" ], {
	data: $.expr.createPseudo ?
		$.expr.createPseudo(function( dataName ) {
			return function( elem ) {
				return !!$.data( elem, dataName );
			};
		}) :
		// support: jQuery <1.8
		function( elem, i, match ) {
			return !!$.data( elem, match[ 3 ] );
		},

	focusable: function( element ) {
		return focusable( element, !isNaN( $.attr( element, "tabindex" ) ) );
	},

	tabbable: function( element ) {
		var tabIndex = $.attr( element, "tabindex" ),
			isTabIndexNaN = isNaN( tabIndex );
		return ( isTabIndexNaN || tabIndex >= 0 ) && focusable( element, !isTabIndexNaN );
	}
});

// support: jQuery <1.8
if ( !$( "<a>" ).outerWidth( 1 ).jquery ) {
	$.each( [ "Width", "Height" ], function( i, name ) {
		var side = name === "Width" ? [ "Left", "Right" ] : [ "Top", "Bottom" ],
			type = name.toLowerCase(),
			orig = {
				innerWidth: $.fn.innerWidth,
				innerHeight: $.fn.innerHeight,
				outerWidth: $.fn.outerWidth,
				outerHeight: $.fn.outerHeight
			};

		function reduce( elem, size, border, margin ) {
			$.each( side, function() {
				size -= parseFloat( $.css( elem, "padding" + this ) ) || 0;
				if ( border ) {
					size -= parseFloat( $.css( elem, "border" + this + "Width" ) ) || 0;
				}
				if ( margin ) {
					size -= parseFloat( $.css( elem, "margin" + this ) ) || 0;
				}
			});
			return size;
		}

		$.fn[ "inner" + name ] = function( size ) {
			if ( size === undefined ) {
				return orig[ "inner" + name ].call( this );
			}

			return this.each(function() {
				$( this ).css( type, reduce( this, size ) + "px" );
			});
		};

		$.fn[ "outer" + name] = function( size, margin ) {
			if ( typeof size !== "number" ) {
				return orig[ "outer" + name ].call( this, size );
			}

			return this.each(function() {
				$( this).css( type, reduce( this, size, true, margin ) + "px" );
			});
		};
	});
}

// support: jQuery <1.8
if ( !$.fn.addBack ) {
	$.fn.addBack = function( selector ) {
		return this.add( selector == null ?
			this.prevObject : this.prevObject.filter( selector )
		);
	};
}

// support: jQuery 1.6.1, 1.6.2 (http://bugs.jquery.com/ticket/9413)
if ( $( "<a>" ).data( "a-b", "a" ).removeData( "a-b" ).data( "a-b" ) ) {
	$.fn.removeData = (function( removeData ) {
		return function( key ) {
			if ( arguments.length ) {
				return removeData.call( this, $.camelCase( key ) );
			} else {
				return removeData.call( this );
			}
		};
	})( $.fn.removeData );
}





// deprecated
$.ui.ie = !!/msie [\w.]+/.exec( navigator.userAgent.toLowerCase() );

$.support.selectstart = "onselectstart" in document.createElement( "div" );
$.fn.extend({
	disableSelection: function() {
		return this.bind( ( $.support.selectstart ? "selectstart" : "mousedown" ) +
			".ui-disableSelection", function( event ) {
				event.preventDefault();
			});
	},

	enableSelection: function() {
		return this.unbind( ".ui-disableSelection" );
	}
});

$.extend( $.ui, {
	// $.ui.plugin is deprecated. Use $.widget() extensions instead.
	plugin: {
		add: function( module, option, set ) {
			var i,
				proto = $.ui[ module ].prototype;
			for ( i in set ) {
				proto.plugins[ i ] = proto.plugins[ i ] || [];
				proto.plugins[ i ].push( [ option, set[ i ] ] );
			}
		},
		call: function( instance, name, args ) {
			var i,
				set = instance.plugins[ name ];
			if ( !set || !instance.element[ 0 ].parentNode || instance.element[ 0 ].parentNode.nodeType === 11 ) {
				return;
			}

			for ( i = 0; i < set.length; i++ ) {
				if ( instance.options[ set[ i ][ 0 ] ] ) {
					set[ i ][ 1 ].apply( instance.element, args );
				}
			}
		}
	},

	// only used by resizable
	hasScroll: function( el, a ) {

		//If overflow is hidden, the element might have extra content, but the user wants to hide it
		if ( $( el ).css( "overflow" ) === "hidden") {
			return false;
		}

		var scroll = ( a && a === "left" ) ? "scrollLeft" : "scrollTop",
			has = false;

		if ( el[ scroll ] > 0 ) {
			return true;
		}

		// TODO: determine which cases actually cause this to happen
		// if the element doesn't have the scroll set, see if it's possible to
		// set the scroll
		el[ scroll ] = 1;
		has = ( el[ scroll ] > 0 );
		el[ scroll ] = 0;
		return has;
	}
});

})( jQuery );
(function( $, undefined ) {

var uuid = 0,
	slice = Array.prototype.slice,
	_cleanData = $.cleanData;
$.cleanData = function( elems ) {
	for ( var i = 0, elem; (elem = elems[i]) != null; i++ ) {
		try {
			$( elem ).triggerHandler( "remove" );
		// http://bugs.jquery.com/ticket/8235
		} catch( e ) {}
	}
	_cleanData( elems );
};

$.widget = function( name, base, prototype ) {
	var fullName, existingConstructor, constructor, basePrototype,
		// proxiedPrototype allows the provided prototype to remain unmodified
		// so that it can be used as a mixin for multiple widgets (#8876)
		proxiedPrototype = {},
		namespace = name.split( "." )[ 0 ];

	name = name.split( "." )[ 1 ];
	fullName = namespace + "-" + name;

	if ( !prototype ) {
		prototype = base;
		base = $.Widget;
	}

	// create selector for plugin
	$.expr[ ":" ][ fullName.toLowerCase() ] = function( elem ) {
		return !!$.data( elem, fullName );
	};

	$[ namespace ] = $[ namespace ] || {};
	existingConstructor = $[ namespace ][ name ];
	constructor = $[ namespace ][ name ] = function( options, element ) {
		// allow instantiation without "new" keyword
		if ( !this._createWidget ) {
			return new constructor( options, element );
		}

		// allow instantiation without initializing for simple inheritance
		// must use "new" keyword (the code above always passes args)
		if ( arguments.length ) {
			this._createWidget( options, element );
		}
	};
	// extend with the existing constructor to carry over any static properties
	$.extend( constructor, existingConstructor, {
		version: prototype.version,
		// copy the object used to create the prototype in case we need to
		// redefine the widget later
		_proto: $.extend( {}, prototype ),
		// track widgets that inherit from this widget in case this widget is
		// redefined after a widget inherits from it
		_childConstructors: []
	});

	basePrototype = new base();
	// we need to make the options hash a property directly on the new instance
	// otherwise we'll modify the options hash on the prototype that we're
	// inheriting from
	basePrototype.options = $.widget.extend( {}, basePrototype.options );
	$.each( prototype, function( prop, value ) {
		if ( !$.isFunction( value ) ) {
			proxiedPrototype[ prop ] = value;
			return;
		}
		proxiedPrototype[ prop ] = (function() {
			var _super = function() {
					return base.prototype[ prop ].apply( this, arguments );
				},
				_superApply = function( args ) {
					return base.prototype[ prop ].apply( this, args );
				};
			return function() {
				var __super = this._super,
					__superApply = this._superApply,
					returnValue;

				this._super = _super;
				this._superApply = _superApply;

				returnValue = value.apply( this, arguments );

				this._super = __super;
				this._superApply = __superApply;

				return returnValue;
			};
		})();
	});
	constructor.prototype = $.widget.extend( basePrototype, {
		// TODO: remove support for widgetEventPrefix
		// always use the name + a colon as the prefix, e.g., draggable:start
		// don't prefix for widgets that aren't DOM-based
		widgetEventPrefix: existingConstructor ? basePrototype.widgetEventPrefix : name
	}, proxiedPrototype, {
		constructor: constructor,
		namespace: namespace,
		widgetName: name,
		widgetFullName: fullName
	});

	// If this widget is being redefined then we need to find all widgets that
	// are inheriting from it and redefine all of them so that they inherit from
	// the new version of this widget. We're essentially trying to replace one
	// level in the prototype chain.
	if ( existingConstructor ) {
		$.each( existingConstructor._childConstructors, function( i, child ) {
			var childPrototype = child.prototype;

			// redefine the child widget using the same prototype that was
			// originally used, but inherit from the new version of the base
			$.widget( childPrototype.namespace + "." + childPrototype.widgetName, constructor, child._proto );
		});
		// remove the list of existing child constructors from the old constructor
		// so the old child constructors can be garbage collected
		delete existingConstructor._childConstructors;
	} else {
		base._childConstructors.push( constructor );
	}

	$.widget.bridge( name, constructor );
};

$.widget.extend = function( target ) {
	var input = slice.call( arguments, 1 ),
		inputIndex = 0,
		inputLength = input.length,
		key,
		value;
	for ( ; inputIndex < inputLength; inputIndex++ ) {
		for ( key in input[ inputIndex ] ) {
			value = input[ inputIndex ][ key ];
			if ( input[ inputIndex ].hasOwnProperty( key ) && value !== undefined ) {
				// Clone objects
				if ( $.isPlainObject( value ) ) {
					target[ key ] = $.isPlainObject( target[ key ] ) ?
						$.widget.extend( {}, target[ key ], value ) :
						// Don't extend strings, arrays, etc. with objects
						$.widget.extend( {}, value );
				// Copy everything else by reference
				} else {
					target[ key ] = value;
				}
			}
		}
	}
	return target;
};

$.widget.bridge = function( name, object ) {
	var fullName = object.prototype.widgetFullName || name;
	$.fn[ name ] = function( options ) {
		var isMethodCall = typeof options === "string",
			args = slice.call( arguments, 1 ),
			returnValue = this;

		// allow multiple hashes to be passed on init
		options = !isMethodCall && args.length ?
			$.widget.extend.apply( null, [ options ].concat(args) ) :
			options;

		if ( isMethodCall ) {
			this.each(function() {
				var methodValue,
					instance = $.data( this, fullName );
				if ( !instance ) {
					return $.error( "cannot call methods on " + name + " prior to initialization; " +
						"attempted to call method '" + options + "'" );
				}
				if ( !$.isFunction( instance[options] ) || options.charAt( 0 ) === "_" ) {
					return $.error( "no such method '" + options + "' for " + name + " widget instance" );
				}
				methodValue = instance[ options ].apply( instance, args );
				if ( methodValue !== instance && methodValue !== undefined ) {
					returnValue = methodValue && methodValue.jquery ?
						returnValue.pushStack( methodValue.get() ) :
						methodValue;
					return false;
				}
			});
		} else {
			this.each(function() {
				var instance = $.data( this, fullName );
				if ( instance ) {
					instance.option( options || {} )._init();
				} else {
					$.data( this, fullName, new object( options, this ) );
				}
			});
		}

		return returnValue;
	};
};

$.Widget = function( /* options, element */ ) {};
$.Widget._childConstructors = [];

$.Widget.prototype = {
	widgetName: "widget",
	widgetEventPrefix: "",
	defaultElement: "<div>",
	options: {
		disabled: false,

		// callbacks
		create: null
	},
	_createWidget: function( options, element ) {
		element = $( element || this.defaultElement || this )[ 0 ];
		this.element = $( element );
		this.uuid = uuid++;
		this.eventNamespace = "." + this.widgetName + this.uuid;
		this.options = $.widget.extend( {},
			this.options,
			this._getCreateOptions(),
			options );

		this.bindings = $();
		this.hoverable = $();
		this.focusable = $();

		if ( element !== this ) {
			$.data( element, this.widgetFullName, this );
			this._on( true, this.element, {
				remove: function( event ) {
					if ( event.target === element ) {
						this.destroy();
					}
				}
			});
			this.document = $( element.style ?
				// element within the document
				element.ownerDocument :
				// element is window or document
				element.document || element );
			this.window = $( this.document[0].defaultView || this.document[0].parentWindow );
		}

		this._create();
		this._trigger( "create", null, this._getCreateEventData() );
		this._init();
	},
	_getCreateOptions: $.noop,
	_getCreateEventData: $.noop,
	_create: $.noop,
	_init: $.noop,

	destroy: function() {
		this._destroy();
		// we can probably remove the unbind calls in 2.0
		// all event bindings should go through this._on()
		this.element
			.unbind( this.eventNamespace )
			// 1.9 BC for #7810
			// TODO remove dual storage
			.removeData( this.widgetName )
			.removeData( this.widgetFullName )
			// support: jquery <1.6.3
			// http://bugs.jquery.com/ticket/9413
			.removeData( $.camelCase( this.widgetFullName ) );
		this.widget()
			.unbind( this.eventNamespace )
			.removeAttr( "aria-disabled" )
			.removeClass(
				this.widgetFullName + "-disabled " +
				"ui-state-disabled" );

		// clean up events and states
		this.bindings.unbind( this.eventNamespace );
		this.hoverable.removeClass( "ui-state-hover" );
		this.focusable.removeClass( "ui-state-focus" );
	},
	_destroy: $.noop,

	widget: function() {
		return this.element;
	},

	option: function( key, value ) {
		var options = key,
			parts,
			curOption,
			i;

		if ( arguments.length === 0 ) {
			// don't return a reference to the internal hash
			return $.widget.extend( {}, this.options );
		}

		if ( typeof key === "string" ) {
			// handle nested keys, e.g., "foo.bar" => { foo: { bar: ___ } }
			options = {};
			parts = key.split( "." );
			key = parts.shift();
			if ( parts.length ) {
				curOption = options[ key ] = $.widget.extend( {}, this.options[ key ] );
				for ( i = 0; i < parts.length - 1; i++ ) {
					curOption[ parts[ i ] ] = curOption[ parts[ i ] ] || {};
					curOption = curOption[ parts[ i ] ];
				}
				key = parts.pop();
				if ( value === undefined ) {
					return curOption[ key ] === undefined ? null : curOption[ key ];
				}
				curOption[ key ] = value;
			} else {
				if ( value === undefined ) {
					return this.options[ key ] === undefined ? null : this.options[ key ];
				}
				options[ key ] = value;
			}
		}

		this._setOptions( options );

		return this;
	},
	_setOptions: function( options ) {
		var key;

		for ( key in options ) {
			this._setOption( key, options[ key ] );
		}

		return this;
	},
	_setOption: function( key, value ) {
		this.options[ key ] = value;

		if ( key === "disabled" ) {
			this.widget()
				.toggleClass( this.widgetFullName + "-disabled ui-state-disabled", !!value )
				.attr( "aria-disabled", value );
			this.hoverable.removeClass( "ui-state-hover" );
			this.focusable.removeClass( "ui-state-focus" );
		}

		return this;
	},

	enable: function() {
		return this._setOption( "disabled", false );
	},
	disable: function() {
		return this._setOption( "disabled", true );
	},

	_on: function( suppressDisabledCheck, element, handlers ) {
		var delegateElement,
			instance = this;

		// no suppressDisabledCheck flag, shuffle arguments
		if ( typeof suppressDisabledCheck !== "boolean" ) {
			handlers = element;
			element = suppressDisabledCheck;
			suppressDisabledCheck = false;
		}

		// no element argument, shuffle and use this.element
		if ( !handlers ) {
			handlers = element;
			element = this.element;
			delegateElement = this.widget();
		} else {
			// accept selectors, DOM elements
			element = delegateElement = $( element );
			this.bindings = this.bindings.add( element );
		}

		$.each( handlers, function( event, handler ) {
			function handlerProxy() {
				// allow widgets to customize the disabled handling
				// - disabled as an array instead of boolean
				// - disabled class as method for disabling individual parts
				if ( !suppressDisabledCheck &&
						( instance.options.disabled === true ||
							$( this ).hasClass( "ui-state-disabled" ) ) ) {
					return;
				}
				return ( typeof handler === "string" ? instance[ handler ] : handler )
					.apply( instance, arguments );
			}

			// copy the guid so direct unbinding works
			if ( typeof handler !== "string" ) {
				handlerProxy.guid = handler.guid =
					handler.guid || handlerProxy.guid || $.guid++;
			}

			var match = event.match( /^(\w+)\s*(.*)$/ ),
				eventName = match[1] + instance.eventNamespace,
				selector = match[2];
			if ( selector ) {
				delegateElement.delegate( selector, eventName, handlerProxy );
			} else {
				element.bind( eventName, handlerProxy );
			}
		});
	},

	_off: function( element, eventName ) {
		eventName = (eventName || "").split( " " ).join( this.eventNamespace + " " ) + this.eventNamespace;
		element.unbind( eventName ).undelegate( eventName );
	},

	_delay: function( handler, delay ) {
		function handlerProxy() {
			return ( typeof handler === "string" ? instance[ handler ] : handler )
				.apply( instance, arguments );
		}
		var instance = this;
		return setTimeout( handlerProxy, delay || 0 );
	},

	_hoverable: function( element ) {
		this.hoverable = this.hoverable.add( element );
		this._on( element, {
			mouseenter: function( event ) {
				$( event.currentTarget ).addClass( "ui-state-hover" );
			},
			mouseleave: function( event ) {
				$( event.currentTarget ).removeClass( "ui-state-hover" );
			}
		});
	},

	_focusable: function( element ) {
		this.focusable = this.focusable.add( element );
		this._on( element, {
			focusin: function( event ) {
				$( event.currentTarget ).addClass( "ui-state-focus" );
			},
			focusout: function( event ) {
				$( event.currentTarget ).removeClass( "ui-state-focus" );
			}
		});
	},

	_trigger: function( type, event, data ) {
		var prop, orig,
			callback = this.options[ type ];

		data = data || {};
		event = $.Event( event );
		event.type = ( type === this.widgetEventPrefix ?
			type :
			this.widgetEventPrefix + type ).toLowerCase();
		// the original event may come from any element
		// so we need to reset the target on the new event
		event.target = this.element[ 0 ];

		// copy original event properties over to the new event
		orig = event.originalEvent;
		if ( orig ) {
			for ( prop in orig ) {
				if ( !( prop in event ) ) {
					event[ prop ] = orig[ prop ];
				}
			}
		}

		this.element.trigger( event, data );
		return !( $.isFunction( callback ) &&
			callback.apply( this.element[0], [ event ].concat( data ) ) === false ||
			event.isDefaultPrevented() );
	}
};

$.each( { show: "fadeIn", hide: "fadeOut" }, function( method, defaultEffect ) {
	$.Widget.prototype[ "_" + method ] = function( element, options, callback ) {
		if ( typeof options === "string" ) {
			options = { effect: options };
		}
		var hasOptions,
			effectName = !options ?
				method :
				options === true || typeof options === "number" ?
					defaultEffect :
					options.effect || defaultEffect;
		options = options || {};
		if ( typeof options === "number" ) {
			options = { duration: options };
		}
		hasOptions = !$.isEmptyObject( options );
		options.complete = callback;
		if ( options.delay ) {
			element.delay( options.delay );
		}
		if ( hasOptions && $.effects && $.effects.effect[ effectName ] ) {
			element[ method ]( options );
		} else if ( effectName !== method && element[ effectName ] ) {
			element[ effectName ]( options.duration, options.easing, callback );
		} else {
			element.queue(function( next ) {
				$( this )[ method ]();
				if ( callback ) {
					callback.call( element[ 0 ] );
				}
				next();
			});
		}
	};
});

})( jQuery );
(function( $, undefined ) {

var mouseHandled = false;
$( document ).mouseup( function() {
	mouseHandled = false;
});

$.widget("ui.mouse", {
	version: "1.10.3",
	options: {
		cancel: "input,textarea,button,select,option",
		distance: 1,
		delay: 0
	},
	_mouseInit: function() {
		var that = this;

		this.element
			.bind("mousedown."+this.widgetName, function(event) {
				return that._mouseDown(event);
			})
			.bind("click."+this.widgetName, function(event) {
				if (true === $.data(event.target, that.widgetName + ".preventClickEvent")) {
					$.removeData(event.target, that.widgetName + ".preventClickEvent");
					event.stopImmediatePropagation();
					return false;
				}
			});

		this.started = false;
	},

	// TODO: make sure destroying one instance of mouse doesn't mess with
	// other instances of mouse
	_mouseDestroy: function() {
		this.element.unbind("."+this.widgetName);
		if ( this._mouseMoveDelegate ) {
			$(document)
				.unbind("mousemove."+this.widgetName, this._mouseMoveDelegate)
				.unbind("mouseup."+this.widgetName, this._mouseUpDelegate);
		}
	},

	_mouseDown: function(event) {
		// don't let more than one widget handle mouseStart
		if( mouseHandled ) { return; }

		// we may have missed mouseup (out of window)
		(this._mouseStarted && this._mouseUp(event));

		this._mouseDownEvent = event;

		var that = this,
			btnIsLeft = (event.which === 1),
			// event.target.nodeName works around a bug in IE 8 with
			// disabled inputs (#7620)
			elIsCancel = (typeof this.options.cancel === "string" && event.target.nodeName ? $(event.target).closest(this.options.cancel).length : false);
		if (!btnIsLeft || elIsCancel || !this._mouseCapture(event)) {
			return true;
		}

		this.mouseDelayMet = !this.options.delay;
		if (!this.mouseDelayMet) {
			this._mouseDelayTimer = setTimeout(function() {
				that.mouseDelayMet = true;
			}, this.options.delay);
		}

		if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
			this._mouseStarted = (this._mouseStart(event) !== false);
			if (!this._mouseStarted) {
				event.preventDefault();
				return true;
			}
		}

		// Click event may never have fired (Gecko & Opera)
		if (true === $.data(event.target, this.widgetName + ".preventClickEvent")) {
			$.removeData(event.target, this.widgetName + ".preventClickEvent");
		}

		// these delegates are required to keep context
		this._mouseMoveDelegate = function(event) {
			return that._mouseMove(event);
		};
		this._mouseUpDelegate = function(event) {
			return that._mouseUp(event);
		};
		$(document)
			.bind("mousemove."+this.widgetName, this._mouseMoveDelegate)
			.bind("mouseup."+this.widgetName, this._mouseUpDelegate);

		event.preventDefault();

		mouseHandled = true;
		return true;
	},

	_mouseMove: function(event) {
		// IE mouseup check - mouseup happened when mouse was out of window
		if ($.ui.ie && ( !document.documentMode || document.documentMode < 9 ) && !event.button) {
			return this._mouseUp(event);
		}

		if (this._mouseStarted) {
			this._mouseDrag(event);
			return event.preventDefault();
		}

		if (this._mouseDistanceMet(event) && this._mouseDelayMet(event)) {
			this._mouseStarted =
				(this._mouseStart(this._mouseDownEvent, event) !== false);
			(this._mouseStarted ? this._mouseDrag(event) : this._mouseUp(event));
		}

		return !this._mouseStarted;
	},

	_mouseUp: function(event) {
		$(document)
			.unbind("mousemove."+this.widgetName, this._mouseMoveDelegate)
			.unbind("mouseup."+this.widgetName, this._mouseUpDelegate);

		if (this._mouseStarted) {
			this._mouseStarted = false;

			if (event.target === this._mouseDownEvent.target) {
				$.data(event.target, this.widgetName + ".preventClickEvent", true);
			}

			this._mouseStop(event);
		}

		return false;
	},

	_mouseDistanceMet: function(event) {
		return (Math.max(
				Math.abs(this._mouseDownEvent.pageX - event.pageX),
				Math.abs(this._mouseDownEvent.pageY - event.pageY)
			) >= this.options.distance
		);
	},

	_mouseDelayMet: function(/* event */) {
		return this.mouseDelayMet;
	},

	// These are placeholder methods, to be overriden by extending plugin
	_mouseStart: function(/* event */) {},
	_mouseDrag: function(/* event */) {},
	_mouseStop: function(/* event */) {},
	_mouseCapture: function(/* event */) { return true; }
});

})(jQuery);
(function( $, undefined ) {

$.ui = $.ui || {};

var cachedScrollbarWidth,
	max = Math.max,
	abs = Math.abs,
	round = Math.round,
	rhorizontal = /left|center|right/,
	rvertical = /top|center|bottom/,
	roffset = /[\+\-]\d+(\.[\d]+)?%?/,
	rposition = /^\w+/,
	rpercent = /%$/,
	_position = $.fn.position;

function getOffsets( offsets, width, height ) {
	return [
		parseFloat( offsets[ 0 ] ) * ( rpercent.test( offsets[ 0 ] ) ? width / 100 : 1 ),
		parseFloat( offsets[ 1 ] ) * ( rpercent.test( offsets[ 1 ] ) ? height / 100 : 1 )
	];
}

function parseCss( element, property ) {
	return parseInt( $.css( element, property ), 10 ) || 0;
}

function getDimensions( elem ) {
	var raw = elem[0];
	if ( raw.nodeType === 9 ) {
		return {
			width: elem.width(),
			height: elem.height(),
			offset: { top: 0, left: 0 }
		};
	}
	if ( $.isWindow( raw ) ) {
		return {
			width: elem.width(),
			height: elem.height(),
			offset: { top: elem.scrollTop(), left: elem.scrollLeft() }
		};
	}
	if ( raw.preventDefault ) {
		return {
			width: 0,
			height: 0,
			offset: { top: raw.pageY, left: raw.pageX }
		};
	}
	return {
		width: elem.outerWidth(),
		height: elem.outerHeight(),
		offset: elem.offset()
	};
}

$.position = {
	scrollbarWidth: function() {
		if ( cachedScrollbarWidth !== undefined ) {
			return cachedScrollbarWidth;
		}
		var w1, w2,
			div = $( "<div style='display:block;width:50px;height:50px;overflow:hidden;'><div style='height:100px;width:auto;'></div></div>" ),
			innerDiv = div.children()[0];

		$( "body" ).append( div );
		w1 = innerDiv.offsetWidth;
		div.css( "overflow", "scroll" );

		w2 = innerDiv.offsetWidth;

		if ( w1 === w2 ) {
			w2 = div[0].clientWidth;
		}

		div.remove();

		return (cachedScrollbarWidth = w1 - w2);
	},
	getScrollInfo: function( within ) {
		var overflowX = within.isWindow ? "" : within.element.css( "overflow-x" ),
			overflowY = within.isWindow ? "" : within.element.css( "overflow-y" ),
			hasOverflowX = overflowX === "scroll" ||
				( overflowX === "auto" && within.width < within.element[0].scrollWidth ),
			hasOverflowY = overflowY === "scroll" ||
				( overflowY === "auto" && within.height < within.element[0].scrollHeight );
		return {
			width: hasOverflowY ? $.position.scrollbarWidth() : 0,
			height: hasOverflowX ? $.position.scrollbarWidth() : 0
		};
	},
	getWithinInfo: function( element ) {
		var withinElement = $( element || window ),
			isWindow = $.isWindow( withinElement[0] );
		return {
			element: withinElement,
			isWindow: isWindow,
			offset: withinElement.offset() || { left: 0, top: 0 },
			scrollLeft: withinElement.scrollLeft(),
			scrollTop: withinElement.scrollTop(),
			width: isWindow ? withinElement.width() : withinElement.outerWidth(),
			height: isWindow ? withinElement.height() : withinElement.outerHeight()
		};
	}
};

$.fn.position = function( options ) {
	if ( !options || !options.of ) {
		return _position.apply( this, arguments );
	}

	// make a copy, we don't want to modify arguments
	options = $.extend( {}, options );

	var atOffset, targetWidth, targetHeight, targetOffset, basePosition, dimensions,
		target = $( options.of ),
		within = $.position.getWithinInfo( options.within ),
		scrollInfo = $.position.getScrollInfo( within ),
		collision = ( options.collision || "flip" ).split( " " ),
		offsets = {};

	dimensions = getDimensions( target );
	if ( target[0].preventDefault ) {
		// force left top to allow flipping
		options.at = "left top";
	}
	targetWidth = dimensions.width;
	targetHeight = dimensions.height;
	targetOffset = dimensions.offset;
	// clone to reuse original targetOffset later
	basePosition = $.extend( {}, targetOffset );

	// force my and at to have valid horizontal and vertical positions
	// if a value is missing or invalid, it will be converted to center
	$.each( [ "my", "at" ], function() {
		var pos = ( options[ this ] || "" ).split( " " ),
			horizontalOffset,
			verticalOffset;

		if ( pos.length === 1) {
			pos = rhorizontal.test( pos[ 0 ] ) ?
				pos.concat( [ "center" ] ) :
				rvertical.test( pos[ 0 ] ) ?
					[ "center" ].concat( pos ) :
					[ "center", "center" ];
		}
		pos[ 0 ] = rhorizontal.test( pos[ 0 ] ) ? pos[ 0 ] : "center";
		pos[ 1 ] = rvertical.test( pos[ 1 ] ) ? pos[ 1 ] : "center";

		// calculate offsets
		horizontalOffset = roffset.exec( pos[ 0 ] );
		verticalOffset = roffset.exec( pos[ 1 ] );
		offsets[ this ] = [
			horizontalOffset ? horizontalOffset[ 0 ] : 0,
			verticalOffset ? verticalOffset[ 0 ] : 0
		];

		// reduce to just the positions without the offsets
		options[ this ] = [
			rposition.exec( pos[ 0 ] )[ 0 ],
			rposition.exec( pos[ 1 ] )[ 0 ]
		];
	});

	// normalize collision option
	if ( collision.length === 1 ) {
		collision[ 1 ] = collision[ 0 ];
	}

	if ( options.at[ 0 ] === "right" ) {
		basePosition.left += targetWidth;
	} else if ( options.at[ 0 ] === "center" ) {
		basePosition.left += targetWidth / 2;
	}

	if ( options.at[ 1 ] === "bottom" ) {
		basePosition.top += targetHeight;
	} else if ( options.at[ 1 ] === "center" ) {
		basePosition.top += targetHeight / 2;
	}

	atOffset = getOffsets( offsets.at, targetWidth, targetHeight );
	basePosition.left += atOffset[ 0 ];
	basePosition.top += atOffset[ 1 ];

	return this.each(function() {
		var collisionPosition, using,
			elem = $( this ),
			elemWidth = elem.outerWidth(),
			elemHeight = elem.outerHeight(),
			marginLeft = parseCss( this, "marginLeft" ),
			marginTop = parseCss( this, "marginTop" ),
			collisionWidth = elemWidth + marginLeft + parseCss( this, "marginRight" ) + scrollInfo.width,
			collisionHeight = elemHeight + marginTop + parseCss( this, "marginBottom" ) + scrollInfo.height,
			position = $.extend( {}, basePosition ),
			myOffset = getOffsets( offsets.my, elem.outerWidth(), elem.outerHeight() );

		if ( options.my[ 0 ] === "right" ) {
			position.left -= elemWidth;
		} else if ( options.my[ 0 ] === "center" ) {
			position.left -= elemWidth / 2;
		}

		if ( options.my[ 1 ] === "bottom" ) {
			position.top -= elemHeight;
		} else if ( options.my[ 1 ] === "center" ) {
			position.top -= elemHeight / 2;
		}

		position.left += myOffset[ 0 ];
		position.top += myOffset[ 1 ];

		// if the browser doesn't support fractions, then round for consistent results
		if ( !$.support.offsetFractions ) {
			position.left = round( position.left );
			position.top = round( position.top );
		}

		collisionPosition = {
			marginLeft: marginLeft,
			marginTop: marginTop
		};

		$.each( [ "left", "top" ], function( i, dir ) {
			if ( $.ui.position[ collision[ i ] ] ) {
				$.ui.position[ collision[ i ] ][ dir ]( position, {
					targetWidth: targetWidth,
					targetHeight: targetHeight,
					elemWidth: elemWidth,
					elemHeight: elemHeight,
					collisionPosition: collisionPosition,
					collisionWidth: collisionWidth,
					collisionHeight: collisionHeight,
					offset: [ atOffset[ 0 ] + myOffset[ 0 ], atOffset [ 1 ] + myOffset[ 1 ] ],
					my: options.my,
					at: options.at,
					within: within,
					elem : elem
				});
			}
		});

		if ( options.using ) {
			// adds feedback as second argument to using callback, if present
			using = function( props ) {
				var left = targetOffset.left - position.left,
					right = left + targetWidth - elemWidth,
					top = targetOffset.top - position.top,
					bottom = top + targetHeight - elemHeight,
					feedback = {
						target: {
							element: target,
							left: targetOffset.left,
							top: targetOffset.top,
							width: targetWidth,
							height: targetHeight
						},
						element: {
							element: elem,
							left: position.left,
							top: position.top,
							width: elemWidth,
							height: elemHeight
						},
						horizontal: right < 0 ? "left" : left > 0 ? "right" : "center",
						vertical: bottom < 0 ? "top" : top > 0 ? "bottom" : "middle"
					};
				if ( targetWidth < elemWidth && abs( left + right ) < targetWidth ) {
					feedback.horizontal = "center";
				}
				if ( targetHeight < elemHeight && abs( top + bottom ) < targetHeight ) {
					feedback.vertical = "middle";
				}
				if ( max( abs( left ), abs( right ) ) > max( abs( top ), abs( bottom ) ) ) {
					feedback.important = "horizontal";
				} else {
					feedback.important = "vertical";
				}
				options.using.call( this, props, feedback );
			};
		}

		elem.offset( $.extend( position, { using: using } ) );
	});
};

$.ui.position = {
	fit: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollLeft : within.offset.left,
				outerWidth = within.width,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = withinOffset - collisionPosLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - withinOffset,
				newOverRight;

			// element is wider than within
			if ( data.collisionWidth > outerWidth ) {
				// element is initially over the left side of within
				if ( overLeft > 0 && overRight <= 0 ) {
					newOverRight = position.left + overLeft + data.collisionWidth - outerWidth - withinOffset;
					position.left += overLeft - newOverRight;
				// element is initially over right side of within
				} else if ( overRight > 0 && overLeft <= 0 ) {
					position.left = withinOffset;
				// element is initially over both left and right sides of within
				} else {
					if ( overLeft > overRight ) {
						position.left = withinOffset + outerWidth - data.collisionWidth;
					} else {
						position.left = withinOffset;
					}
				}
			// too far left -> align with left edge
			} else if ( overLeft > 0 ) {
				position.left += overLeft;
			// too far right -> align with right edge
			} else if ( overRight > 0 ) {
				position.left -= overRight;
			// adjust based on position and margin
			} else {
				position.left = max( position.left - collisionPosLeft, position.left );
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.isWindow ? within.scrollTop : within.offset.top,
				outerHeight = data.within.height,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = withinOffset - collisionPosTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - withinOffset,
				newOverBottom;

			// element is taller than within
			if ( data.collisionHeight > outerHeight ) {
				// element is initially over the top of within
				if ( overTop > 0 && overBottom <= 0 ) {
					newOverBottom = position.top + overTop + data.collisionHeight - outerHeight - withinOffset;
					position.top += overTop - newOverBottom;
				// element is initially over bottom of within
				} else if ( overBottom > 0 && overTop <= 0 ) {
					position.top = withinOffset;
				// element is initially over both top and bottom of within
				} else {
					if ( overTop > overBottom ) {
						position.top = withinOffset + outerHeight - data.collisionHeight;
					} else {
						position.top = withinOffset;
					}
				}
			// too far up -> align with top
			} else if ( overTop > 0 ) {
				position.top += overTop;
			// too far down -> align with bottom edge
			} else if ( overBottom > 0 ) {
				position.top -= overBottom;
			// adjust based on position and margin
			} else {
				position.top = max( position.top - collisionPosTop, position.top );
			}
		}
	},
	flip: {
		left: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.left + within.scrollLeft,
				outerWidth = within.width,
				offsetLeft = within.isWindow ? within.scrollLeft : within.offset.left,
				collisionPosLeft = position.left - data.collisionPosition.marginLeft,
				overLeft = collisionPosLeft - offsetLeft,
				overRight = collisionPosLeft + data.collisionWidth - outerWidth - offsetLeft,
				myOffset = data.my[ 0 ] === "left" ?
					-data.elemWidth :
					data.my[ 0 ] === "right" ?
						data.elemWidth :
						0,
				atOffset = data.at[ 0 ] === "left" ?
					data.targetWidth :
					data.at[ 0 ] === "right" ?
						-data.targetWidth :
						0,
				offset = -2 * data.offset[ 0 ],
				newOverRight,
				newOverLeft;

			if ( overLeft < 0 ) {
				newOverRight = position.left + myOffset + atOffset + offset + data.collisionWidth - outerWidth - withinOffset;
				if ( newOverRight < 0 || newOverRight < abs( overLeft ) ) {
					position.left += myOffset + atOffset + offset;
				}
			}
			else if ( overRight > 0 ) {
				newOverLeft = position.left - data.collisionPosition.marginLeft + myOffset + atOffset + offset - offsetLeft;
				if ( newOverLeft > 0 || abs( newOverLeft ) < overRight ) {
					position.left += myOffset + atOffset + offset;
				}
			}
		},
		top: function( position, data ) {
			var within = data.within,
				withinOffset = within.offset.top + within.scrollTop,
				outerHeight = within.height,
				offsetTop = within.isWindow ? within.scrollTop : within.offset.top,
				collisionPosTop = position.top - data.collisionPosition.marginTop,
				overTop = collisionPosTop - offsetTop,
				overBottom = collisionPosTop + data.collisionHeight - outerHeight - offsetTop,
				top = data.my[ 1 ] === "top",
				myOffset = top ?
					-data.elemHeight :
					data.my[ 1 ] === "bottom" ?
						data.elemHeight :
						0,
				atOffset = data.at[ 1 ] === "top" ?
					data.targetHeight :
					data.at[ 1 ] === "bottom" ?
						-data.targetHeight :
						0,
				offset = -2 * data.offset[ 1 ],
				newOverTop,
				newOverBottom;
			if ( overTop < 0 ) {
				newOverBottom = position.top + myOffset + atOffset + offset + data.collisionHeight - outerHeight - withinOffset;
				if ( ( position.top + myOffset + atOffset + offset) > overTop && ( newOverBottom < 0 || newOverBottom < abs( overTop ) ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
			else if ( overBottom > 0 ) {
				newOverTop = position.top -  data.collisionPosition.marginTop + myOffset + atOffset + offset - offsetTop;
				if ( ( position.top + myOffset + atOffset + offset) > overBottom && ( newOverTop > 0 || abs( newOverTop ) < overBottom ) ) {
					position.top += myOffset + atOffset + offset;
				}
			}
		}
	},
	flipfit: {
		left: function() {
			$.ui.position.flip.left.apply( this, arguments );
			$.ui.position.fit.left.apply( this, arguments );
		},
		top: function() {
			$.ui.position.flip.top.apply( this, arguments );
			$.ui.position.fit.top.apply( this, arguments );
		}
	}
};

// fraction support test
(function () {
	var testElement, testElementParent, testElementStyle, offsetLeft, i,
		body = document.getElementsByTagName( "body" )[ 0 ],
		div = document.createElement( "div" );

	//Create a "fake body" for testing based on method used in jQuery.support
	testElement = document.createElement( body ? "div" : "body" );
	testElementStyle = {
		visibility: "hidden",
		width: 0,
		height: 0,
		border: 0,
		margin: 0,
		background: "none"
	};
	if ( body ) {
		$.extend( testElementStyle, {
			position: "absolute",
			left: "-1000px",
			top: "-1000px"
		});
	}
	for ( i in testElementStyle ) {
		testElement.style[ i ] = testElementStyle[ i ];
	}
	testElement.appendChild( div );
	testElementParent = body || document.documentElement;
	testElementParent.insertBefore( testElement, testElementParent.firstChild );

	div.style.cssText = "position: absolute; left: 10.7432222px;";

	offsetLeft = $( div ).offset().left;
	$.support.offsetFractions = offsetLeft > 10 && offsetLeft < 11;

	testElement.innerHTML = "";
	testElementParent.removeChild( testElement );
})();

}( jQuery ) );
(function( $, undefined ) {

// number of pages in a slider
// (how many times can you page up/down to go through the whole range)
var numPages = 5;

$.widget( "ui.slider", $.ui.mouse, {
	version: "1.10.3",
	widgetEventPrefix: "slide",

	options: {
		animate: false,
		distance: 0,
		max: 100,
		min: 0,
		orientation: "horizontal",
		range: false,
		step: 1,
		value: 0,
		values: null,

		// callbacks
		change: null,
		slide: null,
		start: null,
		stop: null
	},

	_create: function() {
		this._keySliding = false;
		this._mouseSliding = false;
		this._animateOff = true;
		this._handleIndex = null;
		this._detectOrientation();
		this._mouseInit();

		this.element
			.addClass( "ui-slider" +
				" ui-slider-" + this.orientation +
				" ui-widget" +
				" ui-widget-content" +
				" ui-corner-all");

		this._refresh();
		this._setOption( "disabled", this.options.disabled );

		this._animateOff = false;
	},

	_refresh: function() {
		this._createRange();
		this._createHandles();
		this._setupEvents();
		this._refreshValue();
	},

	_createHandles: function() {
		var i, handleCount,
			options = this.options,
			existingHandles = this.element.find( ".ui-slider-handle" ).addClass( "ui-state-default ui-corner-all" ),
			handle = "<a class='ui-slider-handle ui-state-default ui-corner-all' href='#'></a>",
			handles = [];

		handleCount = ( options.values && options.values.length ) || 1;

		if ( existingHandles.length > handleCount ) {
			existingHandles.slice( handleCount ).remove();
			existingHandles = existingHandles.slice( 0, handleCount );
		}

		for ( i = existingHandles.length; i < handleCount; i++ ) {
			handles.push( handle );
		}

		this.handles = existingHandles.add( $( handles.join( "" ) ).appendTo( this.element ) );

		this.handle = this.handles.eq( 0 );

		this.handles.each(function( i ) {
			$( this ).data( "ui-slider-handle-index", i );
		});
	},

	_createRange: function() {
		var options = this.options,
			classes = "";

		if ( options.range ) {
			if ( options.range === true ) {
				if ( !options.values ) {
					options.values = [ this._valueMin(), this._valueMin() ];
				} else if ( options.values.length && options.values.length !== 2 ) {
					options.values = [ options.values[0], options.values[0] ];
				} else if ( $.isArray( options.values ) ) {
					options.values = options.values.slice(0);
				}
			}

			if ( !this.range || !this.range.length ) {
				this.range = $( "<div></div>" )
					.appendTo( this.element );

				classes = "ui-slider-range" +
				// note: this isn't the most fittingly semantic framework class for this element,
				// but worked best visually with a variety of themes
				" ui-widget-header ui-corner-all";
			} else {
				this.range.removeClass( "ui-slider-range-min ui-slider-range-max" )
					// Handle range switching from true to min/max
					.css({
						"left": "",
						"bottom": ""
					});
			}

			this.range.addClass( classes +
				( ( options.range === "min" || options.range === "max" ) ? " ui-slider-range-" + options.range : "" ) );
		} else {
			this.range = $([]);
		}
	},

	_setupEvents: function() {
		var elements = this.handles.add( this.range ).filter( "a" );
		this._off( elements );
		this._on( elements, this._handleEvents );
		this._hoverable( elements );
		this._focusable( elements );
	},

	_destroy: function() {
		this.handles.remove();
		this.range.remove();

		this.element
			.removeClass( "ui-slider" +
				" ui-slider-horizontal" +
				" ui-slider-vertical" +
				" ui-widget" +
				" ui-widget-content" +
				" ui-corner-all" );

		this._mouseDestroy();
	},

	_mouseCapture: function( event ) {
		var position, normValue, distance, closestHandle, index, allowed, offset, mouseOverHandle,
			that = this,
			o = this.options;

		if ( o.disabled ) {
			return false;
		}

		this.elementSize = {
			width: this.element.outerWidth(),
			height: this.element.outerHeight()
		};
		this.elementOffset = this.element.offset();

		position = { x: event.pageX, y: event.pageY };
		normValue = this._normValueFromMouse( position );
		distance = this._valueMax() - this._valueMin() + 1;
		this.handles.each(function( i ) {
			var thisDistance = Math.abs( normValue - that.values(i) );
			if (( distance > thisDistance ) ||
				( distance === thisDistance &&
					(i === that._lastChangedValue || that.values(i) === o.min ))) {
				distance = thisDistance;
				closestHandle = $( this );
				index = i;
			}
		});

		allowed = this._start( event, index );
		if ( allowed === false ) {
			return false;
		}
		this._mouseSliding = true;

		this._handleIndex = index;

		closestHandle
			.addClass( "ui-state-active" )
			.focus();

		offset = closestHandle.offset();
		mouseOverHandle = !$( event.target ).parents().addBack().is( ".ui-slider-handle" );
		this._clickOffset = mouseOverHandle ? { left: 0, top: 0 } : {
			left: event.pageX - offset.left - ( closestHandle.width() / 2 ),
			top: event.pageY - offset.top -
				( closestHandle.height() / 2 ) -
				( parseInt( closestHandle.css("borderTopWidth"), 10 ) || 0 ) -
				( parseInt( closestHandle.css("borderBottomWidth"), 10 ) || 0) +
				( parseInt( closestHandle.css("marginTop"), 10 ) || 0)
		};

		if ( !this.handles.hasClass( "ui-state-hover" ) ) {
			this._slide( event, index, normValue );
		}
		this._animateOff = true;
		return true;
	},

	_mouseStart: function() {
		return true;
	},

	_mouseDrag: function( event ) {
		var position = { x: event.pageX, y: event.pageY },
			normValue = this._normValueFromMouse( position );

		this._slide( event, this._handleIndex, normValue );

		return false;
	},

	_mouseStop: function( event ) {
		this.handles.removeClass( "ui-state-active" );
		this._mouseSliding = false;

		this._stop( event, this._handleIndex );
		this._change( event, this._handleIndex );

		this._handleIndex = null;
		this._clickOffset = null;
		this._animateOff = false;

		return false;
	},

	_detectOrientation: function() {
		this.orientation = ( this.options.orientation === "vertical" ) ? "vertical" : "horizontal";
	},

	_normValueFromMouse: function( position ) {
		var pixelTotal,
			pixelMouse,
			percentMouse,
			valueTotal,
			valueMouse;

		if ( this.orientation === "horizontal" ) {
			pixelTotal = this.elementSize.width;
			pixelMouse = position.x - this.elementOffset.left - ( this._clickOffset ? this._clickOffset.left : 0 );
		} else {
			pixelTotal = this.elementSize.height;
			pixelMouse = position.y - this.elementOffset.top - ( this._clickOffset ? this._clickOffset.top : 0 );
		}

		percentMouse = ( pixelMouse / pixelTotal );
		if ( percentMouse > 1 ) {
			percentMouse = 1;
		}
		if ( percentMouse < 0 ) {
			percentMouse = 0;
		}
		if ( this.orientation === "vertical" ) {
			percentMouse = 1 - percentMouse;
		}

		valueTotal = this._valueMax() - this._valueMin();
		valueMouse = this._valueMin() + percentMouse * valueTotal;

		return this._trimAlignValue( valueMouse );
	},

	_start: function( event, index ) {
		var uiHash = {
			handle: this.handles[ index ],
			value: this.value()
		};
		if ( this.options.values && this.options.values.length ) {
			uiHash.value = this.values( index );
			uiHash.values = this.values();
		}
		return this._trigger( "start", event, uiHash );
	},

	_slide: function( event, index, newVal ) {
		var otherVal,
			newValues,
			allowed;

		if ( this.options.values && this.options.values.length ) {
			otherVal = this.values( index ? 0 : 1 );

			if ( ( this.options.values.length === 2 && this.options.range === true ) &&
					( ( index === 0 && newVal > otherVal) || ( index === 1 && newVal < otherVal ) )
				) {
				newVal = otherVal;
			}

			if ( newVal !== this.values( index ) ) {
				newValues = this.values();
				newValues[ index ] = newVal;
				// A slide can be canceled by returning false from the slide callback
				allowed = this._trigger( "slide", event, {
					handle: this.handles[ index ],
					value: newVal,
					values: newValues
				} );
				otherVal = this.values( index ? 0 : 1 );
				if ( allowed !== false ) {
					this.values( index, newVal, true );
				}
			}
		} else {
			if ( newVal !== this.value() ) {
				// A slide can be canceled by returning false from the slide callback
				allowed = this._trigger( "slide", event, {
					handle: this.handles[ index ],
					value: newVal
				} );
				if ( allowed !== false ) {
					this.value( newVal );
				}
			}
		}
	},

	_stop: function( event, index ) {
		var uiHash = {
			handle: this.handles[ index ],
			value: this.value()
		};
		if ( this.options.values && this.options.values.length ) {
			uiHash.value = this.values( index );
			uiHash.values = this.values();
		}

		this._trigger( "stop", event, uiHash );
	},

	_change: function( event, index ) {
		if ( !this._keySliding && !this._mouseSliding ) {
			var uiHash = {
				handle: this.handles[ index ],
				value: this.value()
			};
			if ( this.options.values && this.options.values.length ) {
				uiHash.value = this.values( index );
				uiHash.values = this.values();
			}

			//store the last changed value index for reference when handles overlap
			this._lastChangedValue = index;

			this._trigger( "change", event, uiHash );
		}
	},

	value: function( newValue ) {
		if ( arguments.length ) {
			this.options.value = this._trimAlignValue( newValue );
			this._refreshValue();
			this._change( null, 0 );
			return;
		}

		return this._value();
	},

	values: function( index, newValue ) {
		var vals,
			newValues,
			i;

		if ( arguments.length > 1 ) {
			this.options.values[ index ] = this._trimAlignValue( newValue );
			this._refreshValue();
			this._change( null, index );
			return;
		}

		if ( arguments.length ) {
			if ( $.isArray( arguments[ 0 ] ) ) {
				vals = this.options.values;
				newValues = arguments[ 0 ];
				for ( i = 0; i < vals.length; i += 1 ) {
					vals[ i ] = this._trimAlignValue( newValues[ i ] );
					this._change( null, i );
				}
				this._refreshValue();
			} else {
				if ( this.options.values && this.options.values.length ) {
					return this._values( index );
				} else {
					return this.value();
				}
			}
		} else {
			return this._values();
		}
	},

	_setOption: function( key, value ) {
		var i,
			valsLength = 0;

		if ( key === "range" && this.options.range === true ) {
			if ( value === "min" ) {
				this.options.value = this._values( 0 );
				this.options.values = null;
			} else if ( value === "max" ) {
				this.options.value = this._values( this.options.values.length-1 );
				this.options.values = null;
			}
		}

		if ( $.isArray( this.options.values ) ) {
			valsLength = this.options.values.length;
		}

		$.Widget.prototype._setOption.apply( this, arguments );

		switch ( key ) {
			case "orientation":
				this._detectOrientation();
				this.element
					.removeClass( "ui-slider-horizontal ui-slider-vertical" )
					.addClass( "ui-slider-" + this.orientation );
				this._refreshValue();
				break;
			case "value":
				this._animateOff = true;
				this._refreshValue();
				this._change( null, 0 );
				this._animateOff = false;
				break;
			case "values":
				this._animateOff = true;
				this._refreshValue();
				for ( i = 0; i < valsLength; i += 1 ) {
					this._change( null, i );
				}
				this._animateOff = false;
				break;
			case "min":
			case "max":
				this._animateOff = true;
				this._refreshValue();
				this._animateOff = false;
				break;
			case "range":
				this._animateOff = true;
				this._refresh();
				this._animateOff = false;
				break;
		}
	},

	//internal value getter
	// _value() returns value trimmed by min and max, aligned by step
	_value: function() {
		var val = this.options.value;
		val = this._trimAlignValue( val );

		return val;
	},

	//internal values getter
	// _values() returns array of values trimmed by min and max, aligned by step
	// _values( index ) returns single value trimmed by min and max, aligned by step
	_values: function( index ) {
		var val,
			vals,
			i;

		if ( arguments.length ) {
			val = this.options.values[ index ];
			val = this._trimAlignValue( val );

			return val;
		} else if ( this.options.values && this.options.values.length ) {
			// .slice() creates a copy of the array
			// this copy gets trimmed by min and max and then returned
			vals = this.options.values.slice();
			for ( i = 0; i < vals.length; i+= 1) {
				vals[ i ] = this._trimAlignValue( vals[ i ] );
			}

			return vals;
		} else {
			return [];
		}
	},

	// returns the step-aligned value that val is closest to, between (inclusive) min and max
	_trimAlignValue: function( val ) {
		if ( val <= this._valueMin() ) {
			return this._valueMin();
		}
		if ( val >= this._valueMax() ) {
			return this._valueMax();
		}
		var step = ( this.options.step > 0 ) ? this.options.step : 1,
			valModStep = (val - this._valueMin()) % step,
			alignValue = val - valModStep;

		if ( Math.abs(valModStep) * 2 >= step ) {
			alignValue += ( valModStep > 0 ) ? step : ( -step );
		}

		// Since JavaScript has problems with large floats, round
		// the final value to 5 digits after the decimal point (see #4124)
		return parseFloat( alignValue.toFixed(5) );
	},

	_valueMin: function() {
		return this.options.min;
	},

	_valueMax: function() {
		return this.options.max;
	},

	_refreshValue: function() {
		var lastValPercent, valPercent, value, valueMin, valueMax,
			oRange = this.options.range,
			o = this.options,
			that = this,
			animate = ( !this._animateOff ) ? o.animate : false,
			_set = {};

		if ( this.options.values && this.options.values.length ) {
			this.handles.each(function( i ) {
				valPercent = ( that.values(i) - that._valueMin() ) / ( that._valueMax() - that._valueMin() ) * 100;
				_set[ that.orientation === "horizontal" ? "left" : "bottom" ] = valPercent + "%";
				$( this ).stop( 1, 1 )[ animate ? "animate" : "css" ]( _set, o.animate );
				if ( that.options.range === true ) {
					if ( that.orientation === "horizontal" ) {
						if ( i === 0 ) {
							that.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { left: valPercent + "%" }, o.animate );
						}
						if ( i === 1 ) {
							that.range[ animate ? "animate" : "css" ]( { width: ( valPercent - lastValPercent ) + "%" }, { queue: false, duration: o.animate } );
						}
					} else {
						if ( i === 0 ) {
							that.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { bottom: ( valPercent ) + "%" }, o.animate );
						}
						if ( i === 1 ) {
							that.range[ animate ? "animate" : "css" ]( { height: ( valPercent - lastValPercent ) + "%" }, { queue: false, duration: o.animate } );
						}
					}
				}
				lastValPercent = valPercent;
			});
		} else {
			value = this.value();
			valueMin = this._valueMin();
			valueMax = this._valueMax();
			valPercent = ( valueMax !== valueMin ) ?
					( value - valueMin ) / ( valueMax - valueMin ) * 100 :
					0;
			_set[ this.orientation === "horizontal" ? "left" : "bottom" ] = valPercent + "%";
			this.handle.stop( 1, 1 )[ animate ? "animate" : "css" ]( _set, o.animate );

			if ( oRange === "min" && this.orientation === "horizontal" ) {
				this.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { width: valPercent + "%" }, o.animate );
			}
			if ( oRange === "max" && this.orientation === "horizontal" ) {
				this.range[ animate ? "animate" : "css" ]( { width: ( 100 - valPercent ) + "%" }, { queue: false, duration: o.animate } );
			}
			if ( oRange === "min" && this.orientation === "vertical" ) {
				this.range.stop( 1, 1 )[ animate ? "animate" : "css" ]( { height: valPercent + "%" }, o.animate );
			}
			if ( oRange === "max" && this.orientation === "vertical" ) {
				this.range[ animate ? "animate" : "css" ]( { height: ( 100 - valPercent ) + "%" }, { queue: false, duration: o.animate } );
			}
		}
	},

	_handleEvents: {
		keydown: function( event ) {
			/*jshint maxcomplexity:25*/
			var allowed, curVal, newVal, step,
				index = $( event.target ).data( "ui-slider-handle-index" );

			switch ( event.keyCode ) {
				case $.ui.keyCode.HOME:
				case $.ui.keyCode.END:
				case $.ui.keyCode.PAGE_UP:
				case $.ui.keyCode.PAGE_DOWN:
				case $.ui.keyCode.UP:
				case $.ui.keyCode.RIGHT:
				case $.ui.keyCode.DOWN:
				case $.ui.keyCode.LEFT:
					event.preventDefault();
					if ( !this._keySliding ) {
						this._keySliding = true;
						$( event.target ).addClass( "ui-state-active" );
						allowed = this._start( event, index );
						if ( allowed === false ) {
							return;
						}
					}
					break;
			}

			step = this.options.step;
			if ( this.options.values && this.options.values.length ) {
				curVal = newVal = this.values( index );
			} else {
				curVal = newVal = this.value();
			}

			switch ( event.keyCode ) {
				case $.ui.keyCode.HOME:
					newVal = this._valueMin();
					break;
				case $.ui.keyCode.END:
					newVal = this._valueMax();
					break;
				case $.ui.keyCode.PAGE_UP:
					newVal = this._trimAlignValue( curVal + ( (this._valueMax() - this._valueMin()) / numPages ) );
					break;
				case $.ui.keyCode.PAGE_DOWN:
					newVal = this._trimAlignValue( curVal - ( (this._valueMax() - this._valueMin()) / numPages ) );
					break;
				case $.ui.keyCode.UP:
				case $.ui.keyCode.RIGHT:
					if ( curVal === this._valueMax() ) {
						return;
					}
					newVal = this._trimAlignValue( curVal + step );
					break;
				case $.ui.keyCode.DOWN:
				case $.ui.keyCode.LEFT:
					if ( curVal === this._valueMin() ) {
						return;
					}
					newVal = this._trimAlignValue( curVal - step );
					break;
			}

			this._slide( event, index, newVal );
		},
		click: function( event ) {
			event.preventDefault();
		},
		keyup: function( event ) {
			var index = $( event.target ).data( "ui-slider-handle-index" );

			if ( this._keySliding ) {
				this._keySliding = false;
				this._stop( event, index );
				this._change( event, index );
				$( event.target ).removeClass( "ui-state-active" );
			}
		}
	}

});

}(jQuery));

//     Underscore.js 1.4.4
//     http://underscorejs.org
//     (c) 2009-2013 Jeremy Ashkenas, DocumentCloud Inc.
//     Underscore may be freely distributed under the MIT license.

(function() {

  // Baseline setup
  // --------------

  // Establish the root object, `window` in the browser, or `global` on the server.
  var root = this;

  // Save the previous value of the `_` variable.
  var previousUnderscore = root._;

  // Establish the object that gets returned to break out of a loop iteration.
  var breaker = {};

  // Save bytes in the minified (but not gzipped) version:
  var ArrayProto = Array.prototype, ObjProto = Object.prototype, FuncProto = Function.prototype;

  // Create quick reference variables for speed access to core prototypes.
  var push             = ArrayProto.push,
      slice            = ArrayProto.slice,
      concat           = ArrayProto.concat,
      toString         = ObjProto.toString,
      hasOwnProperty   = ObjProto.hasOwnProperty;

  // All **ECMAScript 5** native function implementations that we hope to use
  // are declared here.
  var
    nativeForEach      = ArrayProto.forEach,
    nativeMap          = ArrayProto.map,
    nativeReduce       = ArrayProto.reduce,
    nativeReduceRight  = ArrayProto.reduceRight,
    nativeFilter       = ArrayProto.filter,
    nativeEvery        = ArrayProto.every,
    nativeSome         = ArrayProto.some,
    nativeIndexOf      = ArrayProto.indexOf,
    nativeLastIndexOf  = ArrayProto.lastIndexOf,
    nativeIsArray      = Array.isArray,
    nativeKeys         = Object.keys,
    nativeBind         = FuncProto.bind;

  // Create a safe reference to the Underscore object for use below.
  var _ = function(obj) {
    if (obj instanceof _) return obj;
    if (!(this instanceof _)) return new _(obj);
    this._wrapped = obj;
  };

  // Export the Underscore object for **Node.js**, with
  // backwards-compatibility for the old `require()` API. If we're in
  // the browser, add `_` as a global object via a string identifier,
  // for Closure Compiler "advanced" mode.
  if (typeof exports !== 'undefined') {
    if (typeof module !== 'undefined' && module.exports) {
      exports = module.exports = _;
    }
    exports._ = _;
  } else {
    root._ = _;
  }

  // Current version.
  _.VERSION = '1.4.4';

  // Collection Functions
  // --------------------

  // The cornerstone, an `each` implementation, aka `forEach`.
  // Handles objects with the built-in `forEach`, arrays, and raw objects.
  // Delegates to **ECMAScript 5**'s native `forEach` if available.
  var each = _.each = _.forEach = function(obj, iterator, context) {
    if (obj == null) return;
    if (nativeForEach && obj.forEach === nativeForEach) {
      obj.forEach(iterator, context);
    } else if (obj.length === +obj.length) {
      for (var i = 0, l = obj.length; i < l; i++) {
        if (iterator.call(context, obj[i], i, obj) === breaker) return;
      }
    } else {
      for (var key in obj) {
        if (_.has(obj, key)) {
          if (iterator.call(context, obj[key], key, obj) === breaker) return;
        }
      }
    }
  };

  // Return the results of applying the iterator to each element.
  // Delegates to **ECMAScript 5**'s native `map` if available.
  _.map = _.collect = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeMap && obj.map === nativeMap) return obj.map(iterator, context);
    each(obj, function(value, index, list) {
      results[results.length] = iterator.call(context, value, index, list);
    });
    return results;
  };

  var reduceError = 'Reduce of empty array with no initial value';

  // **Reduce** builds up a single result from a list of values, aka `inject`,
  // or `foldl`. Delegates to **ECMAScript 5**'s native `reduce` if available.
  _.reduce = _.foldl = _.inject = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduce && obj.reduce === nativeReduce) {
      if (context) iterator = _.bind(iterator, context);
      return initial ? obj.reduce(iterator, memo) : obj.reduce(iterator);
    }
    each(obj, function(value, index, list) {
      if (!initial) {
        memo = value;
        initial = true;
      } else {
        memo = iterator.call(context, memo, value, index, list);
      }
    });
    if (!initial) throw new TypeError(reduceError);
    return memo;
  };

  // The right-associative version of reduce, also known as `foldr`.
  // Delegates to **ECMAScript 5**'s native `reduceRight` if available.
  _.reduceRight = _.foldr = function(obj, iterator, memo, context) {
    var initial = arguments.length > 2;
    if (obj == null) obj = [];
    if (nativeReduceRight && obj.reduceRight === nativeReduceRight) {
      if (context) iterator = _.bind(iterator, context);
      return initial ? obj.reduceRight(iterator, memo) : obj.reduceRight(iterator);
    }
    var length = obj.length;
    if (length !== +length) {
      var keys = _.keys(obj);
      length = keys.length;
    }
    each(obj, function(value, index, list) {
      index = keys ? keys[--length] : --length;
      if (!initial) {
        memo = obj[index];
        initial = true;
      } else {
        memo = iterator.call(context, memo, obj[index], index, list);
      }
    });
    if (!initial) throw new TypeError(reduceError);
    return memo;
  };

  // Return the first value which passes a truth test. Aliased as `detect`.
  _.find = _.detect = function(obj, iterator, context) {
    var result;
    any(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) {
        result = value;
        return true;
      }
    });
    return result;
  };

  // Return all the elements that pass a truth test.
  // Delegates to **ECMAScript 5**'s native `filter` if available.
  // Aliased as `select`.
  _.filter = _.select = function(obj, iterator, context) {
    var results = [];
    if (obj == null) return results;
    if (nativeFilter && obj.filter === nativeFilter) return obj.filter(iterator, context);
    each(obj, function(value, index, list) {
      if (iterator.call(context, value, index, list)) results[results.length] = value;
    });
    return results;
  };

  // Return all the elements for which a truth test fails.
  _.reject = function(obj, iterator, context) {
    return _.filter(obj, function(value, index, list) {
      return !iterator.call(context, value, index, list);
    }, context);
  };

  // Determine whether all of the elements match a truth test.
  // Delegates to **ECMAScript 5**'s native `every` if available.
  // Aliased as `all`.
  _.every = _.all = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = true;
    if (obj == null) return result;
    if (nativeEvery && obj.every === nativeEvery) return obj.every(iterator, context);
    each(obj, function(value, index, list) {
      if (!(result = result && iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if at least one element in the object matches a truth test.
  // Delegates to **ECMAScript 5**'s native `some` if available.
  // Aliased as `any`.
  var any = _.some = _.any = function(obj, iterator, context) {
    iterator || (iterator = _.identity);
    var result = false;
    if (obj == null) return result;
    if (nativeSome && obj.some === nativeSome) return obj.some(iterator, context);
    each(obj, function(value, index, list) {
      if (result || (result = iterator.call(context, value, index, list))) return breaker;
    });
    return !!result;
  };

  // Determine if the array or object contains a given value (using `===`).
  // Aliased as `include`.
  _.contains = _.include = function(obj, target) {
    if (obj == null) return false;
    if (nativeIndexOf && obj.indexOf === nativeIndexOf) return obj.indexOf(target) != -1;
    return any(obj, function(value) {
      return value === target;
    });
  };

  // Invoke a method (with arguments) on every item in a collection.
  _.invoke = function(obj, method) {
    var args = slice.call(arguments, 2);
    var isFunc = _.isFunction(method);
    return _.map(obj, function(value) {
      return (isFunc ? method : value[method]).apply(value, args);
    });
  };

  // Convenience version of a common use case of `map`: fetching a property.
  _.pluck = function(obj, key) {
    return _.map(obj, function(value){ return value[key]; });
  };

  // Convenience version of a common use case of `filter`: selecting only objects
  // containing specific `key:value` pairs.
  _.where = function(obj, attrs, first) {
    if (_.isEmpty(attrs)) return first ? null : [];
    return _[first ? 'find' : 'filter'](obj, function(value) {
      for (var key in attrs) {
        if (attrs[key] !== value[key]) return false;
      }
      return true;
    });
  };

  // Convenience version of a common use case of `find`: getting the first object
  // containing specific `key:value` pairs.
  _.findWhere = function(obj, attrs) {
    return _.where(obj, attrs, true);
  };

  // Return the maximum element or (element-based computation).
  // Can't optimize arrays of integers longer than 65,535 elements.
  // See: https://bugs.webkit.org/show_bug.cgi?id=80797
  _.max = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.max.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return -Infinity;
    var result = {computed : -Infinity, value: -Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed >= result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Return the minimum element (or element-based computation).
  _.min = function(obj, iterator, context) {
    if (!iterator && _.isArray(obj) && obj[0] === +obj[0] && obj.length < 65535) {
      return Math.min.apply(Math, obj);
    }
    if (!iterator && _.isEmpty(obj)) return Infinity;
    var result = {computed : Infinity, value: Infinity};
    each(obj, function(value, index, list) {
      var computed = iterator ? iterator.call(context, value, index, list) : value;
      computed < result.computed && (result = {value : value, computed : computed});
    });
    return result.value;
  };

  // Shuffle an array.
  _.shuffle = function(obj) {
    var rand;
    var index = 0;
    var shuffled = [];
    each(obj, function(value) {
      rand = _.random(index++);
      shuffled[index - 1] = shuffled[rand];
      shuffled[rand] = value;
    });
    return shuffled;
  };

  // An internal function to generate lookup iterators.
  var lookupIterator = function(value) {
    return _.isFunction(value) ? value : function(obj){ return obj[value]; };
  };

  // Sort the object's values by a criterion produced by an iterator.
  _.sortBy = function(obj, value, context) {
    var iterator = lookupIterator(value);
    return _.pluck(_.map(obj, function(value, index, list) {
      return {
        value : value,
        index : index,
        criteria : iterator.call(context, value, index, list)
      };
    }).sort(function(left, right) {
      var a = left.criteria;
      var b = right.criteria;
      if (a !== b) {
        if (a > b || a === void 0) return 1;
        if (a < b || b === void 0) return -1;
      }
      return left.index < right.index ? -1 : 1;
    }), 'value');
  };

  // An internal function used for aggregate "group by" operations.
  var group = function(obj, value, context, behavior) {
    var result = {};
    var iterator = lookupIterator(value || _.identity);
    each(obj, function(value, index) {
      var key = iterator.call(context, value, index, obj);
      behavior(result, key, value);
    });
    return result;
  };

  // Groups the object's values by a criterion. Pass either a string attribute
  // to group by, or a function that returns the criterion.
  _.groupBy = function(obj, value, context) {
    return group(obj, value, context, function(result, key, value) {
      (_.has(result, key) ? result[key] : (result[key] = [])).push(value);
    });
  };

  // Counts instances of an object that group by a certain criterion. Pass
  // either a string attribute to count by, or a function that returns the
  // criterion.
  _.countBy = function(obj, value, context) {
    return group(obj, value, context, function(result, key) {
      if (!_.has(result, key)) result[key] = 0;
      result[key]++;
    });
  };

  // Use a comparator function to figure out the smallest index at which
  // an object should be inserted so as to maintain order. Uses binary search.
  _.sortedIndex = function(array, obj, iterator, context) {
    iterator = iterator == null ? _.identity : lookupIterator(iterator);
    var value = iterator.call(context, obj);
    var low = 0, high = array.length;
    while (low < high) {
      var mid = (low + high) >>> 1;
      iterator.call(context, array[mid]) < value ? low = mid + 1 : high = mid;
    }
    return low;
  };

  // Safely convert anything iterable into a real, live array.
  _.toArray = function(obj) {
    if (!obj) return [];
    if (_.isArray(obj)) return slice.call(obj);
    if (obj.length === +obj.length) return _.map(obj, _.identity);
    return _.values(obj);
  };

  // Return the number of elements in an object.
  _.size = function(obj) {
    if (obj == null) return 0;
    return (obj.length === +obj.length) ? obj.length : _.keys(obj).length;
  };

  // Array Functions
  // ---------------

  // Get the first element of an array. Passing **n** will return the first N
  // values in the array. Aliased as `head` and `take`. The **guard** check
  // allows it to work with `_.map`.
  _.first = _.head = _.take = function(array, n, guard) {
    if (array == null) return void 0;
    return (n != null) && !guard ? slice.call(array, 0, n) : array[0];
  };

  // Returns everything but the last entry of the array. Especially useful on
  // the arguments object. Passing **n** will return all the values in
  // the array, excluding the last N. The **guard** check allows it to work with
  // `_.map`.
  _.initial = function(array, n, guard) {
    return slice.call(array, 0, array.length - ((n == null) || guard ? 1 : n));
  };

  // Get the last element of an array. Passing **n** will return the last N
  // values in the array. The **guard** check allows it to work with `_.map`.
  _.last = function(array, n, guard) {
    if (array == null) return void 0;
    if ((n != null) && !guard) {
      return slice.call(array, Math.max(array.length - n, 0));
    } else {
      return array[array.length - 1];
    }
  };

  // Returns everything but the first entry of the array. Aliased as `tail` and `drop`.
  // Especially useful on the arguments object. Passing an **n** will return
  // the rest N values in the array. The **guard**
  // check allows it to work with `_.map`.
  _.rest = _.tail = _.drop = function(array, n, guard) {
    return slice.call(array, (n == null) || guard ? 1 : n);
  };

  // Trim out all falsy values from an array.
  _.compact = function(array) {
    return _.filter(array, _.identity);
  };

  // Internal implementation of a recursive `flatten` function.
  var flatten = function(input, shallow, output) {
    each(input, function(value) {
      if (_.isArray(value)) {
        shallow ? push.apply(output, value) : flatten(value, shallow, output);
      } else {
        output.push(value);
      }
    });
    return output;
  };

  // Return a completely flattened version of an array.
  _.flatten = function(array, shallow) {
    return flatten(array, shallow, []);
  };

  // Return a version of the array that does not contain the specified value(s).
  _.without = function(array) {
    return _.difference(array, slice.call(arguments, 1));
  };

  // Produce a duplicate-free version of the array. If the array has already
  // been sorted, you have the option of using a faster algorithm.
  // Aliased as `unique`.
  _.uniq = _.unique = function(array, isSorted, iterator, context) {
    if (_.isFunction(isSorted)) {
      context = iterator;
      iterator = isSorted;
      isSorted = false;
    }
    var initial = iterator ? _.map(array, iterator, context) : array;
    var results = [];
    var seen = [];
    each(initial, function(value, index) {
      if (isSorted ? (!index || seen[seen.length - 1] !== value) : !_.contains(seen, value)) {
        seen.push(value);
        results.push(array[index]);
      }
    });
    return results;
  };

  // Produce an array that contains the union: each distinct element from all of
  // the passed-in arrays.
  _.union = function() {
    return _.uniq(concat.apply(ArrayProto, arguments));
  };

  // Produce an array that contains every item shared between all the
  // passed-in arrays.
  _.intersection = function(array) {
    var rest = slice.call(arguments, 1);
    return _.filter(_.uniq(array), function(item) {
      return _.every(rest, function(other) {
        return _.indexOf(other, item) >= 0;
      });
    });
  };

  // Take the difference between one array and a number of other arrays.
  // Only the elements present in just the first array will remain.
  _.difference = function(array) {
    var rest = concat.apply(ArrayProto, slice.call(arguments, 1));
    return _.filter(array, function(value){ return !_.contains(rest, value); });
  };

  // Zip together multiple lists into a single array -- elements that share
  // an index go together.
  _.zip = function() {
    var args = slice.call(arguments);
    var length = _.max(_.pluck(args, 'length'));
    var results = new Array(length);
    for (var i = 0; i < length; i++) {
      results[i] = _.pluck(args, "" + i);
    }
    return results;
  };

  // Converts lists into objects. Pass either a single array of `[key, value]`
  // pairs, or two parallel arrays of the same length -- one of keys, and one of
  // the corresponding values.
  _.object = function(list, values) {
    if (list == null) return {};
    var result = {};
    for (var i = 0, l = list.length; i < l; i++) {
      if (values) {
        result[list[i]] = values[i];
      } else {
        result[list[i][0]] = list[i][1];
      }
    }
    return result;
  };

  // If the browser doesn't supply us with indexOf (I'm looking at you, **MSIE**),
  // we need this function. Return the position of the first occurrence of an
  // item in an array, or -1 if the item is not included in the array.
  // Delegates to **ECMAScript 5**'s native `indexOf` if available.
  // If the array is large and already in sort order, pass `true`
  // for **isSorted** to use binary search.
  _.indexOf = function(array, item, isSorted) {
    if (array == null) return -1;
    var i = 0, l = array.length;
    if (isSorted) {
      if (typeof isSorted == 'number') {
        i = (isSorted < 0 ? Math.max(0, l + isSorted) : isSorted);
      } else {
        i = _.sortedIndex(array, item);
        return array[i] === item ? i : -1;
      }
    }
    if (nativeIndexOf && array.indexOf === nativeIndexOf) return array.indexOf(item, isSorted);
    for (; i < l; i++) if (array[i] === item) return i;
    return -1;
  };

  // Delegates to **ECMAScript 5**'s native `lastIndexOf` if available.
  _.lastIndexOf = function(array, item, from) {
    if (array == null) return -1;
    var hasIndex = from != null;
    if (nativeLastIndexOf && array.lastIndexOf === nativeLastIndexOf) {
      return hasIndex ? array.lastIndexOf(item, from) : array.lastIndexOf(item);
    }
    var i = (hasIndex ? from : array.length);
    while (i--) if (array[i] === item) return i;
    return -1;
  };

  // Generate an integer Array containing an arithmetic progression. A port of
  // the native Python `range()` function. See
  // [the Python documentation](http://docs.python.org/library/functions.html#range).
  _.range = function(start, stop, step) {
    if (arguments.length <= 1) {
      stop = start || 0;
      start = 0;
    }
    step = arguments[2] || 1;

    var len = Math.max(Math.ceil((stop - start) / step), 0);
    var idx = 0;
    var range = new Array(len);

    while(idx < len) {
      range[idx++] = start;
      start += step;
    }

    return range;
  };

  // Function (ahem) Functions
  // ------------------

  // Create a function bound to a given object (assigning `this`, and arguments,
  // optionally). Delegates to **ECMAScript 5**'s native `Function.bind` if
  // available.
  _.bind = function(func, context) {
    if (func.bind === nativeBind && nativeBind) return nativeBind.apply(func, slice.call(arguments, 1));
    var args = slice.call(arguments, 2);
    return function() {
      return func.apply(context, args.concat(slice.call(arguments)));
    };
  };

  // Partially apply a function by creating a version that has had some of its
  // arguments pre-filled, without changing its dynamic `this` context.
  _.partial = function(func) {
    var args = slice.call(arguments, 1);
    return function() {
      return func.apply(this, args.concat(slice.call(arguments)));
    };
  };

  // Bind all of an object's methods to that object. Useful for ensuring that
  // all callbacks defined on an object belong to it.
  _.bindAll = function(obj) {
    var funcs = slice.call(arguments, 1);
    if (funcs.length === 0) funcs = _.functions(obj);
    each(funcs, function(f) { obj[f] = _.bind(obj[f], obj); });
    return obj;
  };

  // Memoize an expensive function by storing its results.
  _.memoize = function(func, hasher) {
    var memo = {};
    hasher || (hasher = _.identity);
    return function() {
      var key = hasher.apply(this, arguments);
      return _.has(memo, key) ? memo[key] : (memo[key] = func.apply(this, arguments));
    };
  };

  // Delays a function for the given number of milliseconds, and then calls
  // it with the arguments supplied.
  _.delay = function(func, wait) {
    var args = slice.call(arguments, 2);
    return setTimeout(function(){ return func.apply(null, args); }, wait);
  };

  // Defers a function, scheduling it to run after the current call stack has
  // cleared.
  _.defer = function(func) {
    return _.delay.apply(_, [func, 1].concat(slice.call(arguments, 1)));
  };

  // Returns a function, that, when invoked, will only be triggered at most once
  // during a given window of time.
  _.throttle = function(func, wait) {
    var context, args, timeout, result;
    var previous = 0;
    var later = function() {
      previous = new Date;
      timeout = null;
      result = func.apply(context, args);
    };
    return function() {
      var now = new Date;
      var remaining = wait - (now - previous);
      context = this;
      args = arguments;
      if (remaining <= 0) {
        clearTimeout(timeout);
        timeout = null;
        previous = now;
        result = func.apply(context, args);
      } else if (!timeout) {
        timeout = setTimeout(later, remaining);
      }
      return result;
    };
  };

  // Returns a function, that, as long as it continues to be invoked, will not
  // be triggered. The function will be called after it stops being called for
  // N milliseconds. If `immediate` is passed, trigger the function on the
  // leading edge, instead of the trailing.
  _.debounce = function(func, wait, immediate) {
    var timeout, result;
    return function() {
      var context = this, args = arguments;
      var later = function() {
        timeout = null;
        if (!immediate) result = func.apply(context, args);
      };
      var callNow = immediate && !timeout;
      clearTimeout(timeout);
      timeout = setTimeout(later, wait);
      if (callNow) result = func.apply(context, args);
      return result;
    };
  };

  // Returns a function that will be executed at most one time, no matter how
  // often you call it. Useful for lazy initialization.
  _.once = function(func) {
    var ran = false, memo;
    return function() {
      if (ran) return memo;
      ran = true;
      memo = func.apply(this, arguments);
      func = null;
      return memo;
    };
  };

  // Returns the first function passed as an argument to the second,
  // allowing you to adjust arguments, run code before and after, and
  // conditionally execute the original function.
  _.wrap = function(func, wrapper) {
    return function() {
      var args = [func];
      push.apply(args, arguments);
      return wrapper.apply(this, args);
    };
  };

  // Returns a function that is the composition of a list of functions, each
  // consuming the return value of the function that follows.
  _.compose = function() {
    var funcs = arguments;
    return function() {
      var args = arguments;
      for (var i = funcs.length - 1; i >= 0; i--) {
        args = [funcs[i].apply(this, args)];
      }
      return args[0];
    };
  };

  // Returns a function that will only be executed after being called N times.
  _.after = function(times, func) {
    if (times <= 0) return func();
    return function() {
      if (--times < 1) {
        return func.apply(this, arguments);
      }
    };
  };

  // Object Functions
  // ----------------

  // Retrieve the names of an object's properties.
  // Delegates to **ECMAScript 5**'s native `Object.keys`
  _.keys = nativeKeys || function(obj) {
    if (obj !== Object(obj)) throw new TypeError('Invalid object');
    var keys = [];
    for (var key in obj) if (_.has(obj, key)) keys[keys.length] = key;
    return keys;
  };

  // Retrieve the values of an object's properties.
  _.values = function(obj) {
    var values = [];
    for (var key in obj) if (_.has(obj, key)) values.push(obj[key]);
    return values;
  };

  // Convert an object into a list of `[key, value]` pairs.
  _.pairs = function(obj) {
    var pairs = [];
    for (var key in obj) if (_.has(obj, key)) pairs.push([key, obj[key]]);
    return pairs;
  };

  // Invert the keys and values of an object. The values must be serializable.
  _.invert = function(obj) {
    var result = {};
    for (var key in obj) if (_.has(obj, key)) result[obj[key]] = key;
    return result;
  };

  // Return a sorted list of the function names available on the object.
  // Aliased as `methods`
  _.functions = _.methods = function(obj) {
    var names = [];
    for (var key in obj) {
      if (_.isFunction(obj[key])) names.push(key);
    }
    return names.sort();
  };

  // Extend a given object with all the properties in passed-in object(s).
  _.extend = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      if (source) {
        for (var prop in source) {
          obj[prop] = source[prop];
        }
      }
    });
    return obj;
  };

  // Return a copy of the object only containing the whitelisted properties.
  _.pick = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    each(keys, function(key) {
      if (key in obj) copy[key] = obj[key];
    });
    return copy;
  };

   // Return a copy of the object without the blacklisted properties.
  _.omit = function(obj) {
    var copy = {};
    var keys = concat.apply(ArrayProto, slice.call(arguments, 1));
    for (var key in obj) {
      if (!_.contains(keys, key)) copy[key] = obj[key];
    }
    return copy;
  };

  // Fill in a given object with default properties.
  _.defaults = function(obj) {
    each(slice.call(arguments, 1), function(source) {
      if (source) {
        for (var prop in source) {
          if (obj[prop] == null) obj[prop] = source[prop];
        }
      }
    });
    return obj;
  };

  // Create a (shallow-cloned) duplicate of an object.
  _.clone = function(obj) {
    if (!_.isObject(obj)) return obj;
    return _.isArray(obj) ? obj.slice() : _.extend({}, obj);
  };

  // Invokes interceptor with the obj, and then returns obj.
  // The primary purpose of this method is to "tap into" a method chain, in
  // order to perform operations on intermediate results within the chain.
  _.tap = function(obj, interceptor) {
    interceptor(obj);
    return obj;
  };

  // Internal recursive comparison function for `isEqual`.
  var eq = function(a, b, aStack, bStack) {
    // Identical objects are equal. `0 === -0`, but they aren't identical.
    // See the Harmony `egal` proposal: http://wiki.ecmascript.org/doku.php?id=harmony:egal.
    if (a === b) return a !== 0 || 1 / a == 1 / b;
    // A strict comparison is necessary because `null == undefined`.
    if (a == null || b == null) return a === b;
    // Unwrap any wrapped objects.
    if (a instanceof _) a = a._wrapped;
    if (b instanceof _) b = b._wrapped;
    // Compare `[[Class]]` names.
    var className = toString.call(a);
    if (className != toString.call(b)) return false;
    switch (className) {
      // Strings, numbers, dates, and booleans are compared by value.
      case '[object String]':
        // Primitives and their corresponding object wrappers are equivalent; thus, `"5"` is
        // equivalent to `new String("5")`.
        return a == String(b);
      case '[object Number]':
        // `NaN`s are equivalent, but non-reflexive. An `egal` comparison is performed for
        // other numeric values.
        return a != +a ? b != +b : (a == 0 ? 1 / a == 1 / b : a == +b);
      case '[object Date]':
      case '[object Boolean]':
        // Coerce dates and booleans to numeric primitive values. Dates are compared by their
        // millisecond representations. Note that invalid dates with millisecond representations
        // of `NaN` are not equivalent.
        return +a == +b;
      // RegExps are compared by their source patterns and flags.
      case '[object RegExp]':
        return a.source == b.source &&
               a.global == b.global &&
               a.multiline == b.multiline &&
               a.ignoreCase == b.ignoreCase;
    }
    if (typeof a != 'object' || typeof b != 'object') return false;
    // Assume equality for cyclic structures. The algorithm for detecting cyclic
    // structures is adapted from ES 5.1 section 15.12.3, abstract operation `JO`.
    var length = aStack.length;
    while (length--) {
      // Linear search. Performance is inversely proportional to the number of
      // unique nested structures.
      if (aStack[length] == a) return bStack[length] == b;
    }
    // Add the first object to the stack of traversed objects.
    aStack.push(a);
    bStack.push(b);
    var size = 0, result = true;
    // Recursively compare objects and arrays.
    if (className == '[object Array]') {
      // Compare array lengths to determine if a deep comparison is necessary.
      size = a.length;
      result = size == b.length;
      if (result) {
        // Deep compare the contents, ignoring non-numeric properties.
        while (size--) {
          if (!(result = eq(a[size], b[size], aStack, bStack))) break;
        }
      }
    } else {
      // Objects with different constructors are not equivalent, but `Object`s
      // from different frames are.
      var aCtor = a.constructor, bCtor = b.constructor;
      if (aCtor !== bCtor && !(_.isFunction(aCtor) && (aCtor instanceof aCtor) &&
                               _.isFunction(bCtor) && (bCtor instanceof bCtor))) {
        return false;
      }
      // Deep compare objects.
      for (var key in a) {
        if (_.has(a, key)) {
          // Count the expected number of properties.
          size++;
          // Deep compare each member.
          if (!(result = _.has(b, key) && eq(a[key], b[key], aStack, bStack))) break;
        }
      }
      // Ensure that both objects contain the same number of properties.
      if (result) {
        for (key in b) {
          if (_.has(b, key) && !(size--)) break;
        }
        result = !size;
      }
    }
    // Remove the first object from the stack of traversed objects.
    aStack.pop();
    bStack.pop();
    return result;
  };

  // Perform a deep comparison to check if two objects are equal.
  _.isEqual = function(a, b) {
    return eq(a, b, [], []);
  };

  // Is a given array, string, or object empty?
  // An "empty" object has no enumerable own-properties.
  _.isEmpty = function(obj) {
    if (obj == null) return true;
    if (_.isArray(obj) || _.isString(obj)) return obj.length === 0;
    for (var key in obj) if (_.has(obj, key)) return false;
    return true;
  };

  // Is a given value a DOM element?
  _.isElement = function(obj) {
    return !!(obj && obj.nodeType === 1);
  };

  // Is a given value an array?
  // Delegates to ECMA5's native Array.isArray
  _.isArray = nativeIsArray || function(obj) {
    return toString.call(obj) == '[object Array]';
  };

  // Is a given variable an object?
  _.isObject = function(obj) {
    return obj === Object(obj);
  };

  // Add some isType methods: isArguments, isFunction, isString, isNumber, isDate, isRegExp.
  each(['Arguments', 'Function', 'String', 'Number', 'Date', 'RegExp'], function(name) {
    _['is' + name] = function(obj) {
      return toString.call(obj) == '[object ' + name + ']';
    };
  });

  // Define a fallback version of the method in browsers (ahem, IE), where
  // there isn't any inspectable "Arguments" type.
  if (!_.isArguments(arguments)) {
    _.isArguments = function(obj) {
      return !!(obj && _.has(obj, 'callee'));
    };
  }

  // Optimize `isFunction` if appropriate.
  if (typeof (/./) !== 'function') {
    _.isFunction = function(obj) {
      return typeof obj === 'function';
    };
  }

  // Is a given object a finite number?
  _.isFinite = function(obj) {
    return isFinite(obj) && !isNaN(parseFloat(obj));
  };

  // Is the given value `NaN`? (NaN is the only number which does not equal itself).
  _.isNaN = function(obj) {
    return _.isNumber(obj) && obj != +obj;
  };

  // Is a given value a boolean?
  _.isBoolean = function(obj) {
    return obj === true || obj === false || toString.call(obj) == '[object Boolean]';
  };

  // Is a given value equal to null?
  _.isNull = function(obj) {
    return obj === null;
  };

  // Is a given variable undefined?
  _.isUndefined = function(obj) {
    return obj === void 0;
  };

  // Shortcut function for checking if an object has a given property directly
  // on itself (in other words, not on a prototype).
  _.has = function(obj, key) {
    return hasOwnProperty.call(obj, key);
  };

  // Utility Functions
  // -----------------

  // Run Underscore.js in *noConflict* mode, returning the `_` variable to its
  // previous owner. Returns a reference to the Underscore object.
  _.noConflict = function() {
    root._ = previousUnderscore;
    return this;
  };

  // Keep the identity function around for default iterators.
  _.identity = function(value) {
    return value;
  };

  // Run a function **n** times.
  _.times = function(n, iterator, context) {
    var accum = Array(n);
    for (var i = 0; i < n; i++) accum[i] = iterator.call(context, i);
    return accum;
  };

  // Return a random integer between min and max (inclusive).
  _.random = function(min, max) {
    if (max == null) {
      max = min;
      min = 0;
    }
    return min + Math.floor(Math.random() * (max - min + 1));
  };

  // List of HTML entities for escaping.
  var entityMap = {
    escape: {
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      '"': '&quot;',
      "'": '&#x27;',
      '/': '&#x2F;'
    }
  };
  entityMap.unescape = _.invert(entityMap.escape);

  // Regexes containing the keys and values listed immediately above.
  var entityRegexes = {
    escape:   new RegExp('[' + _.keys(entityMap.escape).join('') + ']', 'g'),
    unescape: new RegExp('(' + _.keys(entityMap.unescape).join('|') + ')', 'g')
  };

  // Functions for escaping and unescaping strings to/from HTML interpolation.
  _.each(['escape', 'unescape'], function(method) {
    _[method] = function(string) {
      if (string == null) return '';
      return ('' + string).replace(entityRegexes[method], function(match) {
        return entityMap[method][match];
      });
    };
  });

  // If the value of the named property is a function then invoke it;
  // otherwise, return it.
  _.result = function(object, property) {
    if (object == null) return null;
    var value = object[property];
    return _.isFunction(value) ? value.call(object) : value;
  };

  // Add your own custom functions to the Underscore object.
  _.mixin = function(obj) {
    each(_.functions(obj), function(name){
      var func = _[name] = obj[name];
      _.prototype[name] = function() {
        var args = [this._wrapped];
        push.apply(args, arguments);
        return result.call(this, func.apply(_, args));
      };
    });
  };

  // Generate a unique integer id (unique within the entire client session).
  // Useful for temporary DOM ids.
  var idCounter = 0;
  _.uniqueId = function(prefix) {
    var id = ++idCounter + '';
    return prefix ? prefix + id : id;
  };

  // By default, Underscore uses ERB-style template delimiters, change the
  // following template settings to use alternative delimiters.
  _.templateSettings = {
    evaluate    : /<%([\s\S]+?)%>/g,
    interpolate : /<%=([\s\S]+?)%>/g,
    escape      : /<%-([\s\S]+?)%>/g
  };

  // When customizing `templateSettings`, if you don't want to define an
  // interpolation, evaluation or escaping regex, we need one that is
  // guaranteed not to match.
  var noMatch = /(.)^/;

  // Certain characters need to be escaped so that they can be put into a
  // string literal.
  var escapes = {
    "'":      "'",
    '\\':     '\\',
    '\r':     'r',
    '\n':     'n',
    '\t':     't',
    '\u2028': 'u2028',
    '\u2029': 'u2029'
  };

  var escaper = /\\|'|\r|\n|\t|\u2028|\u2029/g;

  // JavaScript micro-templating, similar to John Resig's implementation.
  // Underscore templating handles arbitrary delimiters, preserves whitespace,
  // and correctly escapes quotes within interpolated code.
  _.template = function(text, data, settings) {
    var render;
    settings = _.defaults({}, settings, _.templateSettings);

    // Combine delimiters into one regular expression via alternation.
    var matcher = new RegExp([
      (settings.escape || noMatch).source,
      (settings.interpolate || noMatch).source,
      (settings.evaluate || noMatch).source
    ].join('|') + '|$', 'g');

    // Compile the template source, escaping string literals appropriately.
    var index = 0;
    var source = "__p+='";
    text.replace(matcher, function(match, escape, interpolate, evaluate, offset) {
      source += text.slice(index, offset)
        .replace(escaper, function(match) { return '\\' + escapes[match]; });

      if (escape) {
        source += "'+\n((__t=(" + escape + "))==null?'':_.escape(__t))+\n'";
      }
      if (interpolate) {
        source += "'+\n((__t=(" + interpolate + "))==null?'':__t)+\n'";
      }
      if (evaluate) {
        source += "';\n" + evaluate + "\n__p+='";
      }
      index = offset + match.length;
      return match;
    });
    source += "';\n";

    // If a variable is not specified, place data values in local scope.
    if (!settings.variable) source = 'with(obj||{}){\n' + source + '}\n';

    source = "var __t,__p='',__j=Array.prototype.join," +
      "print=function(){__p+=__j.call(arguments,'');};\n" +
      source + "return __p;\n";

    try {
      render = new Function(settings.variable || 'obj', '_', source);
    } catch (e) {
      e.source = source;
      throw e;
    }

    if (data) return render(data, _);
    var template = function(data) {
      return render.call(this, data, _);
    };

    // Provide the compiled function source as a convenience for precompilation.
    template.source = 'function(' + (settings.variable || 'obj') + '){\n' + source + '}';

    return template;
  };

  // Add a "chain" function, which will delegate to the wrapper.
  _.chain = function(obj) {
    return _(obj).chain();
  };

  // OOP
  // ---------------
  // If Underscore is called as a function, it returns a wrapped object that
  // can be used OO-style. This wrapper holds altered versions of all the
  // underscore functions. Wrapped objects may be chained.

  // Helper function to continue chaining intermediate results.
  var result = function(obj) {
    return this._chain ? _(obj).chain() : obj;
  };

  // Add all of the Underscore functions to the wrapper object.
  _.mixin(_);

  // Add all mutator Array functions to the wrapper.
  each(['pop', 'push', 'reverse', 'shift', 'sort', 'splice', 'unshift'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      var obj = this._wrapped;
      method.apply(obj, arguments);
      if ((name == 'shift' || name == 'splice') && obj.length === 0) delete obj[0];
      return result.call(this, obj);
    };
  });

  // Add all accessor Array functions to the wrapper.
  each(['concat', 'join', 'slice'], function(name) {
    var method = ArrayProto[name];
    _.prototype[name] = function() {
      return result.call(this, method.apply(this._wrapped, arguments));
    };
  });

  _.extend(_.prototype, {

    // Start chaining a wrapped Underscore object.
    chain: function() {
      this._chain = true;
      return this;
    },

    // Extracts the result from a wrapped and chained object.
    value: function() {
      return this._wrapped;
    }

  });

}).call(this);

//     Backbone.js 0.9.10

//     (c) 2010-2012 Jeremy Ashkenas, DocumentCloud Inc.
//     Backbone may be freely distributed under the MIT license.
//     For all details and documentation:
//     http://backbonejs.org

(function(){

  // Initial Setup
  // -------------

  // Save a reference to the global object (`window` in the browser, `exports`
  // on the server).
  var root = this;

  // Save the previous value of the `Backbone` variable, so that it can be
  // restored later on, if `noConflict` is used.
  var previousBackbone = root.Backbone;

  // Create a local reference to array methods.
  var array = [];
  var push = array.push;
  var slice = array.slice;
  var splice = array.splice;

  // The top-level namespace. All public Backbone classes and modules will
  // be attached to this. Exported for both CommonJS and the browser.
  var Backbone;
  if (typeof exports !== 'undefined') {
    Backbone = exports;
  } else {
    Backbone = root.Backbone = {};
  }

  // Current version of the library. Keep in sync with `package.json`.
  Backbone.VERSION = '0.9.10';

  // Require Underscore, if we're on the server, and it's not already present.
  var _ = root._;
  if (!_ && (typeof require !== 'undefined')) _ = require('underscore');

  // For Backbone's purposes, jQuery, Zepto, or Ender owns the `$` variable.
  Backbone.$ = root.jQuery || root.Zepto || root.ender;

  // Runs Backbone.js in *noConflict* mode, returning the `Backbone` variable
  // to its previous owner. Returns a reference to this Backbone object.
  Backbone.noConflict = function() {
    root.Backbone = previousBackbone;
    return this;
  };

  // Turn on `emulateHTTP` to support legacy HTTP servers. Setting this option
  // will fake `"PUT"` and `"DELETE"` requests via the `_method` parameter and
  // set a `X-Http-Method-Override` header.
  Backbone.emulateHTTP = false;

  // Turn on `emulateJSON` to support legacy servers that can't deal with direct
  // `application/json` requests ... will encode the body as
  // `application/x-www-form-urlencoded` instead and will send the model in a
  // form param named `model`.
  Backbone.emulateJSON = false;

  // Backbone.Events
  // ---------------

  // Regular expression used to split event strings.
  var eventSplitter = /\s+/;

  // Implement fancy features of the Events API such as multiple event
  // names `"change blur"` and jQuery-style event maps `{change: action}`
  // in terms of the existing API.
  var eventsApi = function(obj, action, name, rest) {
    if (!name) return true;
    if (typeof name === 'object') {
      for (var key in name) {
        obj[action].apply(obj, [key, name[key]].concat(rest));
      }
    } else if (eventSplitter.test(name)) {
      var names = name.split(eventSplitter);
      for (var i = 0, l = names.length; i < l; i++) {
        obj[action].apply(obj, [names[i]].concat(rest));
      }
    } else {
      return true;
    }
  };

  // Optimized internal dispatch function for triggering events. Tries to
  // keep the usual cases speedy (most Backbone events have 3 arguments).
  var triggerEvents = function(events, args) {
    var ev, i = -1, l = events.length;
    switch (args.length) {
    case 0: while (++i < l) (ev = events[i]).callback.call(ev.ctx);
    return;
    case 1: while (++i < l) (ev = events[i]).callback.call(ev.ctx, args[0]);
    return;
    case 2: while (++i < l) (ev = events[i]).callback.call(ev.ctx, args[0], args[1]);
    return;
    case 3: while (++i < l) (ev = events[i]).callback.call(ev.ctx, args[0], args[1], args[2]);
    return;
    default: while (++i < l) (ev = events[i]).callback.apply(ev.ctx, args);
    }
  };

  // A module that can be mixed in to *any object* in order to provide it with
  // custom events. You may bind with `on` or remove with `off` callback
  // functions to an event; `trigger`-ing an event fires all callbacks in
  // succession.
  //
  //     var object = {};
  //     _.extend(object, Backbone.Events);
  //     object.on('expand', function(){ alert('expanded'); });
  //     object.trigger('expand');
  //
  var Events = Backbone.Events = {

    // Bind one or more space separated events, or an events map,
    // to a `callback` function. Passing `"all"` will bind the callback to
    // all events fired.
    on: function(name, callback, context) {
      if (!(eventsApi(this, 'on', name, [callback, context]) && callback)) return this;
      this._events || (this._events = {});
      var list = this._events[name] || (this._events[name] = []);
      list.push({callback: callback, context: context, ctx: context || this});
      return this;
    },

    // Bind events to only be triggered a single time. After the first time
    // the callback is invoked, it will be removed.
    once: function(name, callback, context) {
      if (!(eventsApi(this, 'once', name, [callback, context]) && callback)) return this;
      var self = this;
      var once = _.once(function() {
        self.off(name, once);
        callback.apply(this, arguments);
      });
      once._callback = callback;
      this.on(name, once, context);
      return this;
    },

    // Remove one or many callbacks. If `context` is null, removes all
    // callbacks with that function. If `callback` is null, removes all
    // callbacks for the event. If `name` is null, removes all bound
    // callbacks for all events.
    off: function(name, callback, context) {
      var list, ev, events, names, i, l, j, k;
      if (!this._events || !eventsApi(this, 'off', name, [callback, context])) return this;
      if (!name && !callback && !context) {
        this._events = {};
        return this;
      }

      names = name ? [name] : _.keys(this._events);
      for (i = 0, l = names.length; i < l; i++) {
        name = names[i];
        if (list = this._events[name]) {
          events = [];
          if (callback || context) {
            for (j = 0, k = list.length; j < k; j++) {
              ev = list[j];
              if ((callback && callback !== ev.callback &&
                               callback !== ev.callback._callback) ||
                  (context && context !== ev.context)) {
                events.push(ev);
              }
            }
          }
          this._events[name] = events;
        }
      }

      return this;
    },

    // Trigger one or many events, firing all bound callbacks. Callbacks are
    // passed the same arguments as `trigger` is, apart from the event name
    // (unless you're listening on `"all"`, which will cause your callback to
    // receive the true name of the event as the first argument).
    trigger: function(name) {
      if (!this._events) return this;
      var args = slice.call(arguments, 1);
      if (!eventsApi(this, 'trigger', name, args)) return this;
      var events = this._events[name];
      var allEvents = this._events.all;
      if (events) triggerEvents(events, args);
      if (allEvents) triggerEvents(allEvents, arguments);
      return this;
    },

    // An inversion-of-control version of `on`. Tell *this* object to listen to
    // an event in another object ... keeping track of what it's listening to.
    listenTo: function(obj, name, callback) {
      var listeners = this._listeners || (this._listeners = {});
      var id = obj._listenerId || (obj._listenerId = _.uniqueId('l'));
      listeners[id] = obj;
      obj.on(name, typeof name === 'object' ? this : callback, this);
      return this;
    },

    // Tell this object to stop listening to either specific events ... or
    // to every object it's currently listening to.
    stopListening: function(obj, name, callback) {
      var listeners = this._listeners;
      if (!listeners) return;
      if (obj) {
        obj.off(name, typeof name === 'object' ? this : callback, this);
        if (!name && !callback) delete listeners[obj._listenerId];
      } else {
        if (typeof name === 'object') callback = this;
        for (var id in listeners) {
          listeners[id].off(name, callback, this);
        }
        this._listeners = {};
      }
      return this;
    }
  };

  // Aliases for backwards compatibility.
  Events.bind   = Events.on;
  Events.unbind = Events.off;

  // Allow the `Backbone` object to serve as a global event bus, for folks who
  // want global "pubsub" in a convenient place.
  _.extend(Backbone, Events);

  // Backbone.Model
  // --------------

  // Create a new model, with defined attributes. A client id (`cid`)
  // is automatically generated and assigned for you.
  var Model = Backbone.Model = function(attributes, options) {
    var defaults;
    var attrs = attributes || {};
    this.cid = _.uniqueId('c');
    this.attributes = {};
    if (options && options.collection) this.collection = options.collection;
    if (options && options.parse) attrs = this.parse(attrs, options) || {};
    if (defaults = _.result(this, 'defaults')) {
      attrs = _.defaults({}, attrs, defaults);
    }
    this.set(attrs, options);
    this.changed = {};
    this.initialize.apply(this, arguments);
  };

  // Attach all inheritable methods to the Model prototype.
  _.extend(Model.prototype, Events, {

    // A hash of attributes whose current and previous value differ.
    changed: null,

    // The default name for the JSON `id` attribute is `"id"`. MongoDB and
    // CouchDB users may want to set this to `"_id"`.
    idAttribute: 'id',

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // Return a copy of the model's `attributes` object.
    toJSON: function(options) {
      return _.clone(this.attributes);
    },

    // Proxy `Backbone.sync` by default.
    sync: function() {
      return Backbone.sync.apply(this, arguments);
    },

    // Get the value of an attribute.
    get: function(attr) {
      return this.attributes[attr];
    },

    // Get the HTML-escaped value of an attribute.
    escape: function(attr) {
      return _.escape(this.get(attr));
    },

    // Returns `true` if the attribute contains a value that is not null
    // or undefined.
    has: function(attr) {
      return this.get(attr) != null;
    },

    // ----------------------------------------------------------------------

    // Set a hash of model attributes on the object, firing `"change"` unless
    // you choose to silence it.
    set: function(key, val, options) {
      var attr, attrs, unset, changes, silent, changing, prev, current;
      if (key == null) return this;

      // Handle both `"key", value` and `{key: value}` -style arguments.
      if (typeof key === 'object') {
        attrs = key;
        options = val;
      } else {
        (attrs = {})[key] = val;
      }

      options || (options = {});

      // Run validation.
      if (!this._validate(attrs, options)) return false;

      // Extract attributes and options.
      unset           = options.unset;
      silent          = options.silent;
      changes         = [];
      changing        = this._changing;
      this._changing  = true;

      if (!changing) {
        this._previousAttributes = _.clone(this.attributes);
        this.changed = {};
      }
      current = this.attributes, prev = this._previousAttributes;

      // Check for changes of `id`.
      if (this.idAttribute in attrs) this.id = attrs[this.idAttribute];

      // For each `set` attribute, update or delete the current value.
      for (attr in attrs) {
        val = attrs[attr];
        if (!_.isEqual(current[attr], val)) changes.push(attr);
        if (!_.isEqual(prev[attr], val)) {
          this.changed[attr] = val;
        } else {
          delete this.changed[attr];
        }
        unset ? delete current[attr] : current[attr] = val;
      }

      // Trigger all relevant attribute changes.
      if (!silent) {
        if (changes.length) this._pending = true;
        for (var i = 0, l = changes.length; i < l; i++) {
          this.trigger('change:' + changes[i], this, current[changes[i]], options);
        }
      }

      if (changing) return this;
      if (!silent) {
        while (this._pending) {
          this._pending = false;
          this.trigger('change', this, options);
        }
      }
      this._pending = false;
      this._changing = false;
      return this;
    },

    // Remove an attribute from the model, firing `"change"` unless you choose
    // to silence it. `unset` is a noop if the attribute doesn't exist.
    unset: function(attr, options) {
      return this.set(attr, void 0, _.extend({}, options, {unset: true}));
    },

    // Clear all attributes on the model, firing `"change"` unless you choose
    // to silence it.
    clear: function(options) {
      var attrs = {};
      for (var key in this.attributes) attrs[key] = void 0;
      return this.set(attrs, _.extend({}, options, {unset: true}));
    },

    // Determine if the model has changed since the last `"change"` event.
    // If you specify an attribute name, determine if that attribute has changed.
    hasChanged: function(attr) {
      if (attr == null) return !_.isEmpty(this.changed);
      return _.has(this.changed, attr);
    },

    // Return an object containing all the attributes that have changed, or
    // false if there are no changed attributes. Useful for determining what
    // parts of a view need to be updated and/or what attributes need to be
    // persisted to the server. Unset attributes will be set to undefined.
    // You can also pass an attributes object to diff against the model,
    // determining if there *would be* a change.
    changedAttributes: function(diff) {
      if (!diff) return this.hasChanged() ? _.clone(this.changed) : false;
      var val, changed = false;
      var old = this._changing ? this._previousAttributes : this.attributes;
      for (var attr in diff) {
        if (_.isEqual(old[attr], (val = diff[attr]))) continue;
        (changed || (changed = {}))[attr] = val;
      }
      return changed;
    },

    // Get the previous value of an attribute, recorded at the time the last
    // `"change"` event was fired.
    previous: function(attr) {
      if (attr == null || !this._previousAttributes) return null;
      return this._previousAttributes[attr];
    },

    // Get all of the attributes of the model at the time of the previous
    // `"change"` event.
    previousAttributes: function() {
      return _.clone(this._previousAttributes);
    },

    // ---------------------------------------------------------------------

    // Fetch the model from the server. If the server's representation of the
    // model differs from its current attributes, they will be overriden,
    // triggering a `"change"` event.
    fetch: function(options) {
      options = options ? _.clone(options) : {};
      if (options.parse === void 0) options.parse = true;
      var success = options.success;
      options.success = function(model, resp, options) {
        if (!model.set(model.parse(resp, options), options)) return false;
        if (success) success(model, resp, options);
      };
      return this.sync('read', this, options);
    },

    // Set a hash of model attributes, and sync the model to the server.
    // If the server returns an attributes hash that differs, the model's
    // state will be `set` again.
    save: function(key, val, options) {
      var attrs, success, method, xhr, attributes = this.attributes;

      // Handle both `"key", value` and `{key: value}` -style arguments.
      if (key == null || typeof key === 'object') {
        attrs = key;
        options = val;
      } else {
        (attrs = {})[key] = val;
      }

      // If we're not waiting and attributes exist, save acts as `set(attr).save(null, opts)`.
      if (attrs && (!options || !options.wait) && !this.set(attrs, options)) return false;

      options = _.extend({validate: true}, options);

      // Do not persist invalid models.
      if (!this._validate(attrs, options)) return false;

      // Set temporary attributes if `{wait: true}`.
      if (attrs && options.wait) {
        this.attributes = _.extend({}, attributes, attrs);
      }

      // After a successful server-side save, the client is (optionally)
      // updated with the server-side state.
      if (options.parse === void 0) options.parse = true;
      success = options.success;
      options.success = function(model, resp, options) {
        // Ensure attributes are restored during synchronous saves.
        model.attributes = attributes;
        var serverAttrs = model.parse(resp, options);
        if (options.wait) serverAttrs = _.extend(attrs || {}, serverAttrs);
        if (_.isObject(serverAttrs) && !model.set(serverAttrs, options)) {
          return false;
        }
        if (success) success(model, resp, options);
      };

      // Finish configuring and sending the Ajax request.
      method = this.isNew() ? 'create' : (options.patch ? 'patch' : 'update');
      if (method === 'patch') options.attrs = attrs;
      xhr = this.sync(method, this, options);

      // Restore attributes.
      if (attrs && options.wait) this.attributes = attributes;

      return xhr;
    },

    // Destroy this model on the server if it was already persisted.
    // Optimistically removes the model from its collection, if it has one.
    // If `wait: true` is passed, waits for the server to respond before removal.
    destroy: function(options) {
      options = options ? _.clone(options) : {};
      var model = this;
      var success = options.success;

      var destroy = function() {
        model.trigger('destroy', model, model.collection, options);
      };

      options.success = function(model, resp, options) {
        if (options.wait || model.isNew()) destroy();
        if (success) success(model, resp, options);
      };

      if (this.isNew()) {
        options.success(this, null, options);
        return false;
      }

      var xhr = this.sync('delete', this, options);
      if (!options.wait) destroy();
      return xhr;
    },

    // Default URL for the model's representation on the server -- if you're
    // using Backbone's restful methods, override this to change the endpoint
    // that will be called.
    url: function() {
      var base = _.result(this, 'urlRoot') || _.result(this.collection, 'url') || urlError();
      if (this.isNew()) return base;
      return base + (base.charAt(base.length - 1) === '/' ? '' : '/') + encodeURIComponent(this.id);
    },

    // **parse** converts a response into the hash of attributes to be `set` on
    // the model. The default implementation is just to pass the response along.
    parse: function(resp, options) {
      return resp;
    },

    // Create a new model with identical attributes to this one.
    clone: function() {
      return new this.constructor(this.attributes);
    },

    // A model is new if it has never been saved to the server, and lacks an id.
    isNew: function() {
      return this.id == null;
    },

    // Check if the model is currently in a valid state.
    isValid: function(options) {
      return !this.validate || !this.validate(this.attributes, options);
    },

    // Run validation against the next complete set of model attributes,
    // returning `true` if all is well. Otherwise, fire a general
    // `"error"` event and call the error callback, if specified.
    _validate: function(attrs, options) {
      if (!options.validate || !this.validate) return true;
      attrs = _.extend({}, this.attributes, attrs);
      var error = this.validationError = this.validate(attrs, options) || null;
      if (!error) return true;
      this.trigger('invalid', this, error, options || {});
      return false;
    }

  });

  // Backbone.Collection
  // -------------------

  // Provides a standard collection class for our sets of models, ordered
  // or unordered. If a `comparator` is specified, the Collection will maintain
  // its models in sort order, as they're added and removed.
  var Collection = Backbone.Collection = function(models, options) {
    options || (options = {});
    if (options.model) this.model = options.model;
    if (options.comparator !== void 0) this.comparator = options.comparator;
    this.models = [];
    this._reset();
    this.initialize.apply(this, arguments);
    if (models) this.reset(models, _.extend({silent: true}, options));
  };

  // Define the Collection's inheritable methods.
  _.extend(Collection.prototype, Events, {

    // The default model for a collection is just a **Backbone.Model**.
    // This should be overridden in most cases.
    model: Model,

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // The JSON representation of a Collection is an array of the
    // models' attributes.
    toJSON: function(options) {
      return this.map(function(model){ return model.toJSON(options); });
    },

    // Proxy `Backbone.sync` by default.
    sync: function() {
      return Backbone.sync.apply(this, arguments);
    },

    // Add a model, or list of models to the set.
    add: function(models, options) {
      models = _.isArray(models) ? models.slice() : [models];
      options || (options = {});
      var i, l, model, attrs, existing, doSort, add, at, sort, sortAttr;
      add = [];
      at = options.at;
      sort = this.comparator && (at == null) && options.sort != false;
      sortAttr = _.isString(this.comparator) ? this.comparator : null;

      // Turn bare objects into model references, and prevent invalid models
      // from being added.
      for (i = 0, l = models.length; i < l; i++) {
        if (!(model = this._prepareModel(attrs = models[i], options))) {
          this.trigger('invalid', this, attrs, options);
          continue;
        }

        // If a duplicate is found, prevent it from being added and
        // optionally merge it into the existing model.
        if (existing = this.get(model)) {
          if (options.merge) {
            existing.set(attrs === model ? model.attributes : attrs, options);
            if (sort && !doSort && existing.hasChanged(sortAttr)) doSort = true;
          }
          continue;
        }

        // This is a new model, push it to the `add` list.
        add.push(model);

        // Listen to added models' events, and index models for lookup by
        // `id` and by `cid`.
        model.on('all', this._onModelEvent, this);
        this._byId[model.cid] = model;
        if (model.id != null) this._byId[model.id] = model;
      }

      // See if sorting is needed, update `length` and splice in new models.
      if (add.length) {
        if (sort) doSort = true;
        this.length += add.length;
        if (at != null) {
          splice.apply(this.models, [at, 0].concat(add));
        } else {
          push.apply(this.models, add);
        }
      }

      // Silently sort the collection if appropriate.
      if (doSort) this.sort({silent: true});

      if (options.silent) return this;

      // Trigger `add` events.
      for (i = 0, l = add.length; i < l; i++) {
        (model = add[i]).trigger('add', model, this, options);
      }

      // Trigger `sort` if the collection was sorted.
      if (doSort) this.trigger('sort', this, options);

      return this;
    },

    // Remove a model, or a list of models from the set.
    remove: function(models, options) {
      models = _.isArray(models) ? models.slice() : [models];
      options || (options = {});
      var i, l, index, model;
      for (i = 0, l = models.length; i < l; i++) {
        model = this.get(models[i]);
        if (!model) continue;
        delete this._byId[model.id];
        delete this._byId[model.cid];
        index = this.indexOf(model);
        this.models.splice(index, 1);
        this.length--;
        if (!options.silent) {
          options.index = index;
          model.trigger('remove', model, this, options);
        }
        this._removeReference(model);
      }
      return this;
    },

    // Add a model to the end of the collection.
    push: function(model, options) {
      model = this._prepareModel(model, options);
      this.add(model, _.extend({at: this.length}, options));
      return model;
    },

    // Remove a model from the end of the collection.
    pop: function(options) {
      var model = this.at(this.length - 1);
      this.remove(model, options);
      return model;
    },

    // Add a model to the beginning of the collection.
    unshift: function(model, options) {
      model = this._prepareModel(model, options);
      this.add(model, _.extend({at: 0}, options));
      return model;
    },

    // Remove a model from the beginning of the collection.
    shift: function(options) {
      var model = this.at(0);
      this.remove(model, options);
      return model;
    },

    // Slice out a sub-array of models from the collection.
    slice: function(begin, end) {
      return this.models.slice(begin, end);
    },

    // Get a model from the set by id.
    get: function(obj) {
      if (obj == null) return void 0;
      this._idAttr || (this._idAttr = this.model.prototype.idAttribute);
      return this._byId[obj.id || obj.cid || obj[this._idAttr] || obj];
    },

    // Get the model at the given index.
    at: function(index) {
      return this.models[index];
    },

    // Return models with matching attributes. Useful for simple cases of `filter`.
    where: function(attrs) {
      if (_.isEmpty(attrs)) return [];
      return this.filter(function(model) {
        for (var key in attrs) {
          if (attrs[key] !== model.get(key)) return false;
        }
        return true;
      });
    },

    // Force the collection to re-sort itself. You don't need to call this under
    // normal circumstances, as the set will maintain sort order as each item
    // is added.
    sort: function(options) {
      if (!this.comparator) {
        throw new Error('Cannot sort a set without a comparator');
      }
      options || (options = {});

      // Run sort based on type of `comparator`.
      if (_.isString(this.comparator) || this.comparator.length === 1) {
        this.models = this.sortBy(this.comparator, this);
      } else {
        this.models.sort(_.bind(this.comparator, this));
      }

      if (!options.silent) this.trigger('sort', this, options);
      return this;
    },

    // Pluck an attribute from each model in the collection.
    pluck: function(attr) {
      return _.invoke(this.models, 'get', attr);
    },

    // Smartly update a collection with a change set of models, adding,
    // removing, and merging as necessary.
    update: function(models, options) {
      options = _.extend({add: true, merge: true, remove: true}, options);
      if (options.parse) models = this.parse(models, options);
      var model, i, l, existing;
      var add = [], remove = [], modelMap = {};

      // Allow a single model (or no argument) to be passed.
      if (!_.isArray(models)) models = models ? [models] : [];

      // Proxy to `add` for this case, no need to iterate...
      if (options.add && !options.remove) return this.add(models, options);

      // Determine which models to add and merge, and which to remove.
      for (i = 0, l = models.length; i < l; i++) {
        model = models[i];
        existing = this.get(model);
        if (options.remove && existing) modelMap[existing.cid] = true;
        if ((options.add && !existing) || (options.merge && existing)) {
          add.push(model);
        }
      }
      if (options.remove) {
        for (i = 0, l = this.models.length; i < l; i++) {
          model = this.models[i];
          if (!modelMap[model.cid]) remove.push(model);
        }
      }

      // Remove models (if applicable) before we add and merge the rest.
      if (remove.length) this.remove(remove, options);
      if (add.length) this.add(add, options);
      return this;
    },

    // When you have more items than you want to add or remove individually,
    // you can reset the entire set with a new list of models, without firing
    // any `add` or `remove` events. Fires `reset` when finished.
    reset: function(models, options) {
      options || (options = {});
      if (options.parse) models = this.parse(models, options);
      for (var i = 0, l = this.models.length; i < l; i++) {
        this._removeReference(this.models[i]);
      }
      options.previousModels = this.models.slice();
      this._reset();
      if (models) this.add(models, _.extend({silent: true}, options));
      if (!options.silent) this.trigger('reset', this, options);
      return this;
    },

    // Fetch the default set of models for this collection, resetting the
    // collection when they arrive. If `update: true` is passed, the response
    // data will be passed through the `update` method instead of `reset`.
    fetch: function(options) {
      options = options ? _.clone(options) : {};
      if (options.parse === void 0) options.parse = true;
      var success = options.success;
      options.success = function(collection, resp, options) {
        var method = options.update ? 'update' : 'reset';
        collection[method](resp, options);
        if (success) success(collection, resp, options);
      };
      return this.sync('read', this, options);
    },

    // Create a new instance of a model in this collection. Add the model to the
    // collection immediately, unless `wait: true` is passed, in which case we
    // wait for the server to agree.
    create: function(model, options) {
      options = options ? _.clone(options) : {};
      if (!(model = this._prepareModel(model, options))) return false;
      if (!options.wait) this.add(model, options);
      var collection = this;
      var success = options.success;
      options.success = function(model, resp, options) {
        if (options.wait) collection.add(model, options);
        if (success) success(model, resp, options);
      };
      model.save(null, options);
      return model;
    },

    // **parse** converts a response into a list of models to be added to the
    // collection. The default implementation is just to pass it through.
    parse: function(resp, options) {
      return resp;
    },

    // Create a new collection with an identical list of models as this one.
    clone: function() {
      return new this.constructor(this.models);
    },

    // Reset all internal state. Called when the collection is reset.
    _reset: function() {
      this.length = 0;
      this.models.length = 0;
      this._byId  = {};
    },

    // Prepare a model or hash of attributes to be added to this collection.
    _prepareModel: function(attrs, options) {
      if (attrs instanceof Model) {
        if (!attrs.collection) attrs.collection = this;
        return attrs;
      }
      options || (options = {});
      options.collection = this;
      var model = new this.model(attrs, options);
      if (!model._validate(attrs, options)) return false;
      return model;
    },

    // Internal method to remove a model's ties to a collection.
    _removeReference: function(model) {
      if (this === model.collection) delete model.collection;
      model.off('all', this._onModelEvent, this);
    },

    // Internal method called every time a model in the set fires an event.
    // Sets need to update their indexes when models change ids. All other
    // events simply proxy through. "add" and "remove" events that originate
    // in other collections are ignored.
    _onModelEvent: function(event, model, collection, options) {
      if ((event === 'add' || event === 'remove') && collection !== this) return;
      if (event === 'destroy') this.remove(model, options);
      if (model && event === 'change:' + model.idAttribute) {
        delete this._byId[model.previous(model.idAttribute)];
        if (model.id != null) this._byId[model.id] = model;
      }
      this.trigger.apply(this, arguments);
    },

    sortedIndex: function (model, value, context) {
      value || (value = this.comparator);
      var iterator = _.isFunction(value) ? value : function(model) {
        return model.get(value);
      };
      return _.sortedIndex(this.models, model, iterator, context);
    }

  });

  // Underscore methods that we want to implement on the Collection.
  var methods = ['forEach', 'each', 'map', 'collect', 'reduce', 'foldl',
    'inject', 'reduceRight', 'foldr', 'find', 'detect', 'filter', 'select',
    'reject', 'every', 'all', 'some', 'any', 'include', 'contains', 'invoke',
    'max', 'min', 'toArray', 'size', 'first', 'head', 'take', 'initial', 'rest',
    'tail', 'drop', 'last', 'without', 'indexOf', 'shuffle', 'lastIndexOf',
    'isEmpty', 'chain'];

  // Mix in each Underscore method as a proxy to `Collection#models`.
  _.each(methods, function(method) {
    Collection.prototype[method] = function() {
      var args = slice.call(arguments);
      args.unshift(this.models);
      return _[method].apply(_, args);
    };
  });

  // Underscore methods that take a property name as an argument.
  var attributeMethods = ['groupBy', 'countBy', 'sortBy'];

  // Use attributes instead of properties.
  _.each(attributeMethods, function(method) {
    Collection.prototype[method] = function(value, context) {
      var iterator = _.isFunction(value) ? value : function(model) {
        return model.get(value);
      };
      return _[method](this.models, iterator, context);
    };
  });

  // Backbone.Router
  // ---------------

  // Routers map faux-URLs to actions, and fire events when routes are
  // matched. Creating a new one sets its `routes` hash, if not set statically.
  var Router = Backbone.Router = function(options) {
    options || (options = {});
    if (options.routes) this.routes = options.routes;
    this._bindRoutes();
    this.initialize.apply(this, arguments);
  };

  // Cached regular expressions for matching named param parts and splatted
  // parts of route strings.
  var optionalParam = /\((.*?)\)/g;
  var namedParam    = /(\(\?)?:\w+/g;
  var splatParam    = /\*\w+/g;
  var escapeRegExp  = /[\-{}\[\]+?.,\\\^$|#\s]/g;

  // Set up all inheritable **Backbone.Router** properties and methods.
  _.extend(Router.prototype, Events, {

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // Manually bind a single named route to a callback. For example:
    //
    //     this.route('search/:query/p:num', 'search', function(query, num) {
    //       ...
    //     });
    //
    route: function(route, name, callback) {
      if (!_.isRegExp(route)) route = this._routeToRegExp(route);
      if (!callback) callback = this[name];
      Backbone.history.route(route, _.bind(function(fragment) {
        var args = this._extractParameters(route, fragment);
        callback && callback.apply(this, args);
        this.trigger.apply(this, ['route:' + name].concat(args));
        this.trigger('route', name, args);
        Backbone.history.trigger('route', this, name, args);
      }, this));
      return this;
    },

    // Simple proxy to `Backbone.history` to save a fragment into the history.
    navigate: function(fragment, options) {
      Backbone.history.navigate(fragment, options);
      return this;
    },

    // Bind all defined routes to `Backbone.history`. We have to reverse the
    // order of the routes here to support behavior where the most general
    // routes can be defined at the bottom of the route map.
    _bindRoutes: function() {
      if (!this.routes) return;
      var route, routes = _.keys(this.routes);
      while ((route = routes.pop()) != null) {
        this.route(route, this.routes[route]);
      }
    },

    // Convert a route string into a regular expression, suitable for matching
    // against the current location hash.
    _routeToRegExp: function(route) {
      route = route.replace(escapeRegExp, '\\$&')
                   .replace(optionalParam, '(?:$1)?')
                   .replace(namedParam, function(match, optional){
                     return optional ? match : '([^\/]+)';
                   })
                   .replace(splatParam, '(.*?)');
      return new RegExp('^' + route + '$');
    },

    // Given a route, and a URL fragment that it matches, return the array of
    // extracted parameters.
    _extractParameters: function(route, fragment) {
      return route.exec(fragment).slice(1);
    }

  });

  // Backbone.History
  // ----------------

  // Handles cross-browser history management, based on URL fragments. If the
  // browser does not support `onhashchange`, falls back to polling.
  var History = Backbone.History = function() {
    this.handlers = [];
    _.bindAll(this, 'checkUrl');

    // Ensure that `History` can be used outside of the browser.
    if (typeof window !== 'undefined') {
      this.location = window.location;
      this.history = window.history;
    }
  };

  // Cached regex for stripping a leading hash/slash and trailing space.
  var routeStripper = /^[#\/]|\s+$/g;

  // Cached regex for stripping leading and trailing slashes.
  var rootStripper = /^\/+|\/+$/g;

  // Cached regex for detecting MSIE.
  var isExplorer = /msie [\w.]+/;

  // Cached regex for removing a trailing slash.
  var trailingSlash = /\/$/;

  // Has the history handling already been started?
  History.started = false;

  // Set up all inheritable **Backbone.History** properties and methods.
  _.extend(History.prototype, Events, {

    // The default interval to poll for hash changes, if necessary, is
    // twenty times a second.
    interval: 50,

    // Gets the true hash value. Cannot use location.hash directly due to bug
    // in Firefox where location.hash will always be decoded.
    getHash: function(window) {
      var match = (window || this).location.href.match(/#(.*)$/);
      return match ? match[1] : '';
    },

    // Get the cross-browser normalized URL fragment, either from the URL,
    // the hash, or the override.
    getFragment: function(fragment, forcePushState) {
      if (fragment == null) {
        if (this._hasPushState || !this._wantsHashChange || forcePushState) {
          fragment = this.location.pathname;
          var root = this.root.replace(trailingSlash, '');
          if (!fragment.indexOf(root)) fragment = fragment.substr(root.length);
        } else {
          fragment = this.getHash();
        }
      }
      return fragment.replace(routeStripper, '');
    },

    // Start the hash change handling, returning `true` if the current URL matches
    // an existing route, and `false` otherwise.
    start: function(options) {
      if (History.started) throw new Error("Backbone.history has already been started");
      History.started = true;

      // Figure out the initial configuration. Do we need an iframe?
      // Is pushState desired ... is it available?
      this.options          = _.extend({}, {root: '/'}, this.options, options);
      this.root             = this.options.root;
      this._wantsHashChange = this.options.hashChange !== false;
      this._wantsPushState  = !!this.options.pushState;
      this._hasPushState    = !!(this.options.pushState && this.history && this.history.pushState);
      var fragment          = this.getFragment();
      var docMode           = document.documentMode;
      var oldIE             = (isExplorer.exec(navigator.userAgent.toLowerCase()) && (!docMode || docMode <= 7));

      // Normalize root to always include a leading and trailing slash.
      this.root = ('/' + this.root + '/').replace(rootStripper, '/');

      if (oldIE && this._wantsHashChange) {
        this.iframe = Backbone.$('<iframe src="javascript:0" tabindex="-1" />').hide().appendTo('body')[0].contentWindow;
        this.navigate(fragment);
      }

      // Depending on whether we're using pushState or hashes, and whether
      // 'onhashchange' is supported, determine how we check the URL state.
      if (this._hasPushState) {
        Backbone.$(window).on('popstate', this.checkUrl);
      } else if (this._wantsHashChange && ('onhashchange' in window) && !oldIE) {
        Backbone.$(window).on('hashchange', this.checkUrl);
      } else if (this._wantsHashChange) {
        this._checkUrlInterval = setInterval(this.checkUrl, this.interval);
      }

      // Determine if we need to change the base url, for a pushState link
      // opened by a non-pushState browser.
      this.fragment = fragment;
      var loc = this.location;
      var atRoot = loc.pathname.replace(/[^\/]$/, '$&/') === this.root;

      // If we've started off with a route from a `pushState`-enabled browser,
      // but we're currently in a browser that doesn't support it...
      if (this._wantsHashChange && this._wantsPushState && !this._hasPushState && !atRoot) {
        this.fragment = this.getFragment(null, true);
        this.location.replace(this.root + this.location.search + '#' + this.fragment);
        // Return immediately as browser will do redirect to new url
        return true;

      // Or if we've started out with a hash-based route, but we're currently
      // in a browser where it could be `pushState`-based instead...
      } else if (this._wantsPushState && this._hasPushState && atRoot && loc.hash) {
        this.fragment = this.getHash().replace(routeStripper, '');
        this.history.replaceState({}, document.title, this.root + this.fragment + loc.search);
      }

      if (!this.options.silent) return this.loadUrl();
    },

    // Disable Backbone.history, perhaps temporarily. Not useful in a real app,
    // but possibly useful for unit testing Routers.
    stop: function() {
      Backbone.$(window).off('popstate', this.checkUrl).off('hashchange', this.checkUrl);
      clearInterval(this._checkUrlInterval);
      History.started = false;
    },

    // Add a route to be tested when the fragment changes. Routes added later
    // may override previous routes.
    route: function(route, callback) {
      this.handlers.unshift({route: route, callback: callback});
    },

    // Checks the current URL to see if it has changed, and if it has,
    // calls `loadUrl`, normalizing across the hidden iframe.
    checkUrl: function(e) {
      var current = this.getFragment();
      if (current === this.fragment && this.iframe) {
        current = this.getFragment(this.getHash(this.iframe));
      }
      if (current === this.fragment) return false;
      if (this.iframe) this.navigate(current);
      this.loadUrl() || this.loadUrl(this.getHash());
    },

    // Attempt to load the current URL fragment. If a route succeeds with a
    // match, returns `true`. If no defined routes matches the fragment,
    // returns `false`.
    loadUrl: function(fragmentOverride) {
      var fragment = this.fragment = this.getFragment(fragmentOverride);
      var matched = _.any(this.handlers, function(handler) {
        if (handler.route.test(fragment)) {
          handler.callback(fragment);
          return true;
        }
      });
      return matched;
    },

    // Save a fragment into the hash history, or replace the URL state if the
    // 'replace' option is passed. You are responsible for properly URL-encoding
    // the fragment in advance.
    //
    // The options object can contain `trigger: true` if you wish to have the
    // route callback be fired (not usually desirable), or `replace: true`, if
    // you wish to modify the current URL without adding an entry to the history.
    navigate: function(fragment, options) {
      if (!History.started) return false;
      if (!options || options === true) options = {trigger: options};
      fragment = this.getFragment(fragment || '');
      if (this.fragment === fragment) return;
      this.fragment = fragment;
      var url = this.root + fragment;

      // If pushState is available, we use it to set the fragment as a real URL.
      if (this._hasPushState) {
        this.history[options.replace ? 'replaceState' : 'pushState']({}, document.title, url);

      // If hash changes haven't been explicitly disabled, update the hash
      // fragment to store history.
      } else if (this._wantsHashChange) {
        this._updateHash(this.location, fragment, options.replace);
        if (this.iframe && (fragment !== this.getFragment(this.getHash(this.iframe)))) {
          // Opening and closing the iframe tricks IE7 and earlier to push a
          // history entry on hash-tag change.  When replace is true, we don't
          // want this.
          if(!options.replace) this.iframe.document.open().close();
          this._updateHash(this.iframe.location, fragment, options.replace);
        }

      // If you've told us that you explicitly don't want fallback hashchange-
      // based history, then `navigate` becomes a page refresh.
      } else {
        return this.location.assign(url);
      }
      if (options.trigger) this.loadUrl(fragment);
    },

    // Update the hash location, either replacing the current entry, or adding
    // a new one to the browser history.
    _updateHash: function(location, fragment, replace) {
      if (replace) {
        var href = location.href.replace(/(javascript:|#).*$/, '');
        location.replace(href + '#' + fragment);
      } else {
        // Some browsers require that `hash` contains a leading #.
        location.hash = '#' + fragment;
      }
    }

  });

  // Create the default Backbone.history.
  Backbone.history = new History;

  // Backbone.View
  // -------------

  // Creating a Backbone.View creates its initial element outside of the DOM,
  // if an existing element is not provided...
  var View = Backbone.View = function(options) {
    this.cid = _.uniqueId('view');
    this._configure(options || {});
    this._ensureElement();
    this.initialize.apply(this, arguments);
    this.delegateEvents();
  };

  // Cached regex to split keys for `delegate`.
  var delegateEventSplitter = /^(\S+)\s*(.*)$/;

  // List of view options to be merged as properties.
  var viewOptions = ['model', 'collection', 'el', 'id', 'attributes', 'className', 'tagName', 'events'];

  // Set up all inheritable **Backbone.View** properties and methods.
  _.extend(View.prototype, Events, {

    // The default `tagName` of a View's element is `"div"`.
    tagName: 'div',

    // jQuery delegate for element lookup, scoped to DOM elements within the
    // current view. This should be prefered to global lookups where possible.
    $: function(selector) {
      return this.$el.find(selector);
    },

    // Initialize is an empty function by default. Override it with your own
    // initialization logic.
    initialize: function(){},

    // **render** is the core function that your view should override, in order
    // to populate its element (`this.el`), with the appropriate HTML. The
    // convention is for **render** to always return `this`.
    render: function() {
      return this;
    },

    // Remove this view by taking the element out of the DOM, and removing any
    // applicable Backbone.Events listeners.
    remove: function() {
      this.$el.remove();
      this.stopListening();
      return this;
    },

    // Change the view's element (`this.el` property), including event
    // re-delegation.
    setElement: function(element, delegate) {
      if (this.$el) this.undelegateEvents();
      this.$el = element instanceof Backbone.$ ? element : Backbone.$(element);
      this.el = this.$el[0];
      if (delegate !== false) this.delegateEvents();
      return this;
    },

    // Set callbacks, where `this.events` is a hash of
    //
    // *{"event selector": "callback"}*
    //
    //     {
    //       'mousedown .title':  'edit',
    //       'click .button':     'save'
    //       'click .open':       function(e) { ... }
    //     }
    //
    // pairs. Callbacks will be bound to the view, with `this` set properly.
    // Uses event delegation for efficiency.
    // Omitting the selector binds the event to `this.el`.
    // This only works for delegate-able events: not `focus`, `blur`, and
    // not `change`, `submit`, and `reset` in Internet Explorer.
    delegateEvents: function(events) {
      if (!(events || (events = _.result(this, 'events')))) return;
      this.undelegateEvents();
      for (var key in events) {
        var method = events[key];
        if (!_.isFunction(method)) method = this[events[key]];
        if (!method) throw new Error('Method "' + events[key] + '" does not exist');
        var match = key.match(delegateEventSplitter);
        var eventName = match[1], selector = match[2];
        method = _.bind(method, this);
        eventName += '.delegateEvents' + this.cid;
        if (selector === '') {
          this.$el.on(eventName, method);
        } else {
          this.$el.on(eventName, selector, method);
        }
      }
    },

    // Clears all callbacks previously bound to the view with `delegateEvents`.
    // You usually don't need to use this, but may wish to if you have multiple
    // Backbone views attached to the same DOM element.
    undelegateEvents: function() {
      this.$el.off('.delegateEvents' + this.cid);
    },

    // Performs the initial configuration of a View with a set of options.
    // Keys with special meaning *(model, collection, id, className)*, are
    // attached directly to the view.
    _configure: function(options) {
      if (this.options) options = _.extend({}, _.result(this, 'options'), options);
      _.extend(this, _.pick(options, viewOptions));
      this.options = options;
    },

    // Ensure that the View has a DOM element to render into.
    // If `this.el` is a string, pass it through `$()`, take the first
    // matching element, and re-assign it to `el`. Otherwise, create
    // an element from the `id`, `className` and `tagName` properties.
    _ensureElement: function() {
      if (!this.el) {
        var attrs = _.extend({}, _.result(this, 'attributes'));
        if (this.id) attrs.id = _.result(this, 'id');
        if (this.className) attrs['class'] = _.result(this, 'className');
        var $el = Backbone.$('<' + _.result(this, 'tagName') + '>').attr(attrs);
        this.setElement($el, false);
      } else {
        this.setElement(_.result(this, 'el'), false);
      }
    }

  });

  // Backbone.sync
  // -------------

  // Map from CRUD to HTTP for our default `Backbone.sync` implementation.
  var methodMap = {
    'create': 'POST',
    'update': 'PUT',
    'patch':  'PATCH',
    'delete': 'DELETE',
    'read':   'GET'
  };

  // Override this function to change the manner in which Backbone persists
  // models to the server. You will be passed the type of request, and the
  // model in question. By default, makes a RESTful Ajax request
  // to the model's `url()`. Some possible customizations could be:
  //
  // * Use `setTimeout` to batch rapid-fire updates into a single request.
  // * Send up the models as XML instead of JSON.
  // * Persist models via WebSockets instead of Ajax.
  //
  // Turn on `Backbone.emulateHTTP` in order to send `PUT` and `DELETE` requests
  // as `POST`, with a `_method` parameter containing the true HTTP method,
  // as well as all requests with the body as `application/x-www-form-urlencoded`
  // instead of `application/json` with the model in a param named `model`.
  // Useful when interfacing with server-side languages like **PHP** that make
  // it difficult to read the body of `PUT` requests.
  Backbone.sync = function(method, model, options) {
    var type = methodMap[method];

    // Default options, unless specified.
    _.defaults(options || (options = {}), {
      emulateHTTP: Backbone.emulateHTTP,
      emulateJSON: Backbone.emulateJSON
    });

    // Default JSON-request options.
    var params = {type: type, dataType: 'json'};

    // Ensure that we have a URL.
    if (!options.url) {
      params.url = _.result(model, 'url') || urlError();
    }
    // Ensure that we have the appropriate request data.
    if (options.data == null && model && (method === 'create' || method === 'update' || method === 'patch')) {
      params.contentType = 'application/json';
      params.data = JSON.stringify(options.attrs || model.toJSON(options));
    }

    // For older servers, emulate JSON by encoding the request into an HTML-form.
    if (options.emulateJSON) {
      params.contentType = 'application/x-www-form-urlencoded';
      params.data = params.data ? {model: params.data} : {};
    }

    // For older servers, emulate HTTP by mimicking the HTTP method with `_method`
    // And an `X-HTTP-Method-Override` header.
    if (options.emulateHTTP && (type === 'PUT' || type === 'DELETE' || type === 'PATCH')) {
      params.type = 'POST';
      if (options.emulateJSON) params.data._method = type;
      var beforeSend = options.beforeSend;
      options.beforeSend = function(xhr) {
        xhr.setRequestHeader('X-HTTP-Method-Override', type);
        if (beforeSend) return beforeSend.apply(this, arguments);
      };
    }

    // Don't process data on a non-GET request.
    if (params.type !== 'GET' && !options.emulateJSON) {
      params.processData = false;
    }

    var success = options.success;
    options.success = function(resp) {
      if (success) success(model, resp, options);
      model.trigger('sync', model, resp, options);
    };

    var error = options.error;
    options.error = function(xhr) {
      if (error) error(model, xhr, options);
      model.trigger('error', model, xhr, options);
    };

    // Make the request, allowing the user to override any Ajax options.
    var xhr = options.xhr = Backbone.ajax(_.extend(params, options));
    model.trigger('request', model, xhr, options);
    return xhr;
  };

  // Set the default implementation of `Backbone.ajax` to proxy through to `$`.
  Backbone.ajax = function() {
    return Backbone.$.ajax.apply(Backbone.$, arguments);
  };

  // Helpers
  // -------

  // Helper function to correctly set up the prototype chain, for subclasses.
  // Similar to `goog.inherits`, but uses a hash of prototype properties and
  // class properties to be extended.
  var extend = function(protoProps, staticProps) {
    var parent = this;
    var child;

    // The constructor function for the new subclass is either defined by you
    // (the "constructor" property in your `extend` definition), or defaulted
    // by us to simply call the parent's constructor.
    if (protoProps && _.has(protoProps, 'constructor')) {
      child = protoProps.constructor;
    } else {
      child = function(){ return parent.apply(this, arguments); };
    }

    // Add static properties to the constructor function, if supplied.
    _.extend(child, parent, staticProps);

    // Set the prototype chain to inherit from `parent`, without calling
    // `parent`'s constructor function.
    var Surrogate = function(){ this.constructor = child; };
    Surrogate.prototype = parent.prototype;
    child.prototype = new Surrogate;

    // Add prototype properties (instance properties) to the subclass,
    // if supplied.
    if (protoProps) _.extend(child.prototype, protoProps);

    // Set a convenience property in case the parent's prototype is needed
    // later.
    child.__super__ = parent.prototype;

    return child;
  };

  // Set up inheritance for the model, collection, router, view and history.
  Model.extend = Collection.extend = Router.extend = View.extend = History.extend = extend;

  // Throw an error when a URL is needed, and none is supplied.
  var urlError = function() {
    throw new Error('A "url" property or function must be specified');
  };

}).call(this);

// Copyright 2012 Mauricio Santos. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
//
// Some documentation is borrowed from the official Java API
// as it serves the same porpose.

/**
 * @namespace Top level namespace for Buckets, a JavaScript data structure library.
 */
var buckets = {};

/**
 * Default function to compare element order.
 * @function
 * @private
 */
buckets.defaultCompare = function(a, b) {
    if (a < b) {
        return - 1;
    } else if (a === b) {
        return 0;
    } else {
        return 1;
    }
};
/**
 * Default function to test equality.
 * @function
 * @private
 */
buckets.defaultEquals = function(a, b) {
    return a === b;
};

/**
 * Default function to convert an object to a string.
 * @function
 * @private
 */
buckets.defaultToString = function(item) {
    if (item === null) {
        return 'BUCKETS_NULL';
    } else if (buckets.isUndefined(item)) {
        return 'BUCKETS_UNDEFINED';
    } else if (buckets.isString(item)) {
        return item;
    } else {
        return item.toString();
    }
};

/**
 * Checks if the given argument is a function.
 * @function
 * @private
 */
buckets.isFunction = function(func) {
    return (typeof func) === 'function';
};

/**
 * Checks if the given argument is undefined.
 * @function
 * @private
 */
buckets.isUndefined = function(obj) {
    return (typeof obj) === 'undefined';
};

/**
 * Checks if the given argument is a string.
 * @function
 * @private
 */
buckets.isString = function(obj) {
    return Object.prototype.toString.call(obj) === '[object String]';
};

/**
 * Reverses a compare function.
 * @function
 * @private
 */
buckets.reverseCompareFunction = function(compareFunction) {
    if (!buckets.isFunction(compareFunction)) {
        return function(a, b) {
            if (a < b) {
                return 1;
            } else if (a === b) {
                return 0;
            } else {
                return - 1;
            }
        };
    } else {
        return function(d, v) {
            return compareFunction(d, v) * -1;
        };
    }
};

/**
 * Returns an equal function given a compare function.
 * @function
 * @private
 */
buckets.compareToEquals = function(compareFunction) {
    return function(a, b) {
        return compareFunction(a, b) === 0;
    };
};

/**
 * @namespace Contains various functions for manipulating arrays.
 */
buckets.arrays = {};

/**
 * Returns the position of the first occurrence of the specified item
 * within the specified array.
 * @param {*} array the array in which to search the element.
 * @param {Object} item the element to search.
 * @param {function(Object,Object):boolean=} equalsFunction optional function used to 
 * check equality between 2 elements.
 * @return {number} the position of the first occurrence of the specified element
 * within the specified array, or -1 if not found.
 */
buckets.arrays.indexOf = function(array, item, equalsFunction) {
    var equals = equalsFunction || buckets.defaultEquals;
    var length = array.length;
    for (var i = 0; i < length; i++) {
        if (equals(array[i], item)) {
            return i;
        }
    }
    return - 1;
};

/**
 * Returns the position of the last occurrence of the specified element
 * within the specified array.
 * @param {*} array the array in which to search the element.
 * @param {Object} item the element to search.
 * @param {function(Object,Object):boolean=} equalsFunction optional function used to 
 * check equality between 2 elements.
 * @return {number} the position of the last occurrence of the specified element
 * within the specified array or -1 if not found.
 */
buckets.arrays.lastIndexOf = function(array, item, equalsFunction) {
    var equals = equalsFunction || buckets.defaultEquals;
    var length = array.length;
    for (var i = length - 1; i >= 0; i--) {
        if (equals(array[i], item)) {
            return i;
        }
    }
    return - 1;
};

/**
 * Returns true if the specified array contains the specified element.
 * @param {*} array the array in which to search the element.
 * @param {Object} item the element to search.
 * @param {function(Object,Object):boolean=} equalsFunction optional function to 
 * check equality between 2 elements.
 * @return {boolean} true if the specified array contains the specified element.
 */
buckets.arrays.contains = function(array, item, equalsFunction) {
    return buckets.arrays.indexOf(array, item, equalsFunction) >= 0;
};


/**
 * Removes the first ocurrence of the specified element from the specified array.
 * @param {*} array the array in which to search element.
 * @param {Object} item the element to search.
 * @param {function(Object,Object):boolean=} equalsFunction optional function to 
 * check equality between 2 elements.
 * @return {boolean} true if the array changed after this call.
 */
buckets.arrays.remove = function(array, item, equalsFunction) {
    var index = buckets.arrays.indexOf(array, item, equalsFunction);
    if (index < 0) {
        return false;
    }
    array.splice(index, 1);
    return true;
};

/**
 * Returns the number of elements in the specified array equal
 * to the specified object.
 * @param {Array} array the array in which to determine the frequency of the element.
 * @param {Object} item the element whose frequency is to be determined.
 * @param {function(Object,Object):boolean=} equalsFunction optional function used to 
 * check equality between 2 elements.
 * @return {number} the number of elements in the specified array 
 * equal to the specified object.
 */
buckets.arrays.frequency = function(array, item, equalsFunction) {
    var equals = equalsFunction || buckets.defaultEquals;
    var length = array.length;
    var freq = 0;
    for (var i = 0; i < length; i++) {
        if (equals(array[i], item)) {
            freq++;
        }
    }
    return freq;
};

/**
 * Returns true if the two specified arrays are equal to one another.
 * Two arrays are considered equal if both arrays contain the same number
 * of elements, and all corresponding pairs of elements in the two 
 * arrays are equal and are in the same order. 
 * @param {Array} array1 one array to be tested for equality.
 * @param {Array} array2 the other array to be tested for equality.
 * @param {function(Object,Object):boolean=} equalsFunction optional function used to 
 * check equality between elemements in the arrays.
 * @return {boolean} true if the two arrays are equal
 */
buckets.arrays.equals = function(array1, array2, equalsFunction) {
    var equals = equalsFunction || buckets.defaultEquals;

    if (array1.length !== array2.length) {
        return false;
    }
    var length = array1.length;
    for (var i = 0; i < length; i++) {
        if (!equals(array1[i], array2[i])) {
            return false;
        }
    }
    return true;
};

/**
 * Returns shallow a copy of the specified array.
 * @param {*} array the array to copy.
 * @return {Array} a copy of the specified array
 */
buckets.arrays.copy = function(array) {
    return array.concat();
};

/**
 * Swaps the elements at the specified positions in the specified array.
 * @param {Array} array The array in which to swap elements.
 * @param {number} i the index of one element to be swapped.
 * @param {number} j the index of the other element to be swapped.
 * @return {boolean} true if the array is defined and the indexes are valid.
 */
buckets.arrays.swap = function(array, i, j) {
    if (i < 0 || i >= array.length || j < 0 || j >= array.length) {
        return false;
    }
    var temp = array[i];
    array[i] = array[j];
    array[j] = temp;
    return true;
};

/**
 * Executes the provided function once for each element present in this array 
 * starting from index 0 to length - 1.
 * @param {Array} array The array in which to iterate.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element value, to break the iteration you can 
 * optionally return false.
 */
buckets.arrays.forEach = function(array, callback) {
   var lenght = array.length;
   for (var i=0; i < lenght; i++) {
   		if(callback(array[i])===false){
			return;
		}
   }	 
};

/**
 * Creates an empty Linked List.
 * @class A linked list is a data structure consisting of a group of nodes
 * which together represent a sequence.
 * @constructor
 */
buckets.LinkedList = function() {

    /**
     * First node in the list
     * @type {Object}
     * @private
     */
    this.firstNode = null;

    /**
     * Last node in the list
     * @type {Object}
     * @private
     */
    this.lastNode = null;

    /**
     * Number of elements in the list
     * @type {number}
     * @private
     */
    this.nElements = 0;
};


/**
 * Adds an element to this list.
 * @param {Object} item element to be added.
 * @param {number=} index optional index to add the element. If no index is specified
 * the element is added to the end of this list.
 * @return {boolean} true if the element was added or false if the index is invalid
 * or if the element is undefined.
 */
buckets.LinkedList.prototype.add = function(item, index) {

    if (buckets.isUndefined(index)) {
        index = this.nElements;
    }
    if (index < 0 || index > this.nElements || buckets.isUndefined(item)) {
        return false;
    }
    var newNode = this.createNode(item);
    if (this.nElements === 0) {
        // First node in the list.
        this.firstNode = newNode;
        this.lastNode = newNode;
    } else if (index === this.nElements) {
        // Insert at the end.
        this.lastNode.next = newNode;
        this.lastNode = newNode;
    } else if (index === 0) {
        // Change first node.
        newNode.next = this.firstNode;
        this.firstNode = newNode;
    } else {
        var prev = this.nodeAtIndex(index - 1);
        newNode.next = prev.next;
        prev.next = newNode;
    }
    this.nElements++;
    return true;
};


/**
 * Returns the first element in this list.
 * @return {*} the first element of the list or undefined if the list is
 * empty.
 */
buckets.LinkedList.prototype.first = function() {

    if (this.firstNode !== null) {
        return this.firstNode.element;
    }
    return undefined;
};

/**
 * Returns the last element in this list.
 * @return {*} the last element in the list or undefined if the list is
 * empty.
 */
buckets.LinkedList.prototype.last = function() {

    if (this.lastNode !== null) {
        return this.lastNode.element;
    }
    return undefined;
};


/**
 * Returns the element at the specified position in this list.
 * @param {number} index desired index.
 * @return {*} the element at the given index or undefined if the index is
 * out of bounds.
 */
buckets.LinkedList.prototype.elementAtIndex = function(index) {

    var node = this.nodeAtIndex(index);
    if (node === null) {
        return undefined;
    }
    return node.element;
};

/**
 * Returns the index in this list of the first occurrence of the
 * specified element, or -1 if the List does not contain this element.
 * <p>If the elements inside this list are
 * not comparable with the === operator a custom equals function should be
 * provided to perform searches, the function must receive two arguments and
 * return true if they are equal, false otherwise. Example:</p>
 *
 * <pre>
 * var petsAreEqualByName = function(pet1, pet2) {
 *  return pet1.name === pet2.name;
 * }
 * </pre>
 * @param {Object} item element to search for.
 * @param {function(Object,Object):boolean=} equalsFunction Optional
 * function used to check if two elements are equal.
 * @return {number} the index in this list of the first occurrence
 * of the specified element, or -1 if this list does not contain the
 * element.
 */
buckets.LinkedList.prototype.indexOf = function(item, equalsFunction) {

    var equalsF = equalsFunction || buckets.defaultEquals;
    if (buckets.isUndefined(item)) {
        return - 1;
    }
    var currentNode = this.firstNode;
    var index = 0;
    while (currentNode !== null) {
        if (equalsF(currentNode.element, item)) {
            return index;
        }
        index++;
        currentNode = currentNode.next;
    }
    return - 1;
};

/**
 * Returns true if this list contains the specified element.
 * <p>If the elements inside the list are
 * not comparable with the === operator a custom equals function should be
 * provided to perform searches, the function must receive two arguments and
 * return true if they are equal, false otherwise. Example:</p>
 *
 * <pre>
 * var petsAreEqualByName = function(pet1, pet2) {
 *  return pet1.name === pet2.name;
 * }
 * </pre>
 * @param {Object} item element to search for.
 * @param {function(Object,Object):boolean=} equalsFunction Optional
 * function used to check if two elements are equal.
 * @return {boolean} true if this list contains the specified element, false
 * otherwise.
 */
buckets.LinkedList.prototype.contains = function(item, equalsFunction) {
    return (this.indexOf(item, equalsFunction) >= 0);
};

/**
 * Removes the first occurrence of the specified element in this list.
 * <p>If the elements inside the list are
 * not comparable with the === operator a custom equals function should be
 * provided to perform searches, the function must receive two arguments and
 * return true if they are equal, false otherwise. Example:</p>
 *
 * <pre>
 * var petsAreEqualByName = function(pet1, pet2) {
 *  return pet1.name === pet2.name;
 * }
 * </pre>
 * @param {Object} item element to be removed from this list, if present.
 * @return {boolean} true if the list contained the specified element.
 */
buckets.LinkedList.prototype.remove = function(item, equalsFunction) {
    var equalsF = equalsFunction || buckets.defaultEquals;
    if (this.nElements < 1 || buckets.isUndefined(item)) {
        return false;
    }
    var previous = null;
    var currentNode = this.firstNode;
    while (currentNode !== null) {

        if (equalsF(currentNode.element, item)) {

            if (currentNode === this.firstNode) {
                this.firstNode = this.firstNode.next;
                if (currentNode === this.lastNode) {
                    this.lastNode = null;
                }
            } else if (currentNode === this.lastNode) {
                this.lastNode = previous;
                previous.next = currentNode.next;
                currentNode.next = null;
            } else {
                previous.next = currentNode.next;
                currentNode.next = null;
            }
            this.nElements--;
            return true;
        }
        previous = currentNode;
        currentNode = currentNode.next;
    }
    return false;
};

/**
 * Removes all of the elements from this list.
 */
buckets.LinkedList.prototype.clear = function() {
    this.firstNode = null;
    this.lastNode = null;
    this.nElements = 0;
};

/**
 * Returns true if this list is equal to the given list.
 * Two lists are equal if they have the same elements in the same order.
 * @param {buckets.LinkedList} other the other list.
 * @param {function(Object,Object):boolean=} equalsFunction optional
 * function used to check if two elements are equal. If the elements in the lists
 * are custom objects you should provide a function, otherwise the
 * the === operator is used to check equality between elements.
 * @return {boolean} true if this list is equal to the given list.
 */
buckets.LinkedList.prototype.equals = function(other, equalsFunction) {
    var eqF = equalsFunction || buckets.defaultEquals;
    if (! (other instanceof buckets.LinkedList)) {
        return false;
    }
    if (this.size() !== other.size()) {
        return false;
    }
    return this.equalsAux(this.firstNode, other.firstNode, eqF);
};

/**
 * @private
 */
buckets.LinkedList.prototype.equalsAux = function(n1, n2, eqF) {
    while (n1 !== null) {
        if (!eqF(n1.element, n2.element)) {
            return false;
        }
        n1 = n1.next;
        n2 = n2.next;
    }
    return true;
};

/**
 * Removes the element at the specified position in this list.
 * @param {number} index given index.
 * @return {*} removed element or undefined if the index is out of bounds.
 */
buckets.LinkedList.prototype.removeElementAtIndex = function(index) {

    if (index < 0 || index >= this.nElements) {
        return undefined;
    }
    var element;
    if (this.nElements === 1) {
        //First node in the list.
        element = this.firstNode.element;
        this.firstNode = null;
        this.lastNode = null;
    } else {
        var previous = this.nodeAtIndex(index - 1);
        if (previous === null) {
            element = this.firstNode.element;
            this.firstNode = this.firstNode.next;
        } else if (previous.next === this.lastNode) {
            element = this.lastNode.element;
            this.lastNode = previous;
        }
        if (previous !== null) {
            element = previous.next.element;
            previous.next = previous.next.next;
        }
    }
    this.nElements--;
    return element;
};

/**
 * Executes the provided function once for each element present in this list in order.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element value, to break the iteration you can 
 * optionally return false.
 */
buckets.LinkedList.prototype.forEach = function(callback) {
    var currentNode = this.firstNode;
    while (currentNode !== null) {
        if (callback(currentNode.element) === false) {
            break;
        }
        currentNode = currentNode.next;
    }
};

/**
 * Reverses the order of the elements in this linked list (makes the last 
 * element first, and the first element last).
 */
buckets.LinkedList.prototype.reverse = function() {
    var previous = null;
    var current = this.firstNode;
    var temp = null;
    while (current !== null) {
        temp = current.next;
        current.next = previous;
        previous = current;
        current = temp;
    }
    temp = this.firstNode;
    this.firstNode = this.lastNode;
    this.lastNode = temp;
};


/**
 * Returns an array containing all of the elements in this list in proper
 * sequence.
 * @return {Array.<*>} an array containing all of the elements in this list,
 * in proper sequence.
 */
buckets.LinkedList.prototype.toArray = function() {
    var array = [];
    var currentNode = this.firstNode;
    while (currentNode !== null) {
        array.push(currentNode.element);
        currentNode = currentNode.next;
    }
    return array;
};
/**
 * Returns the number of elements in this list.
 * @return {number} the number of elements in this list.
 */
buckets.LinkedList.prototype.size = function() {
    return this.nElements;
};

/**
 * Returns true if this list contains no elements.
 * @return {boolean} true if this list contains no elements.
 */
buckets.LinkedList.prototype.isEmpty = function() {
    return this.nElements <= 0;
};

/**
 * @private
 */
buckets.LinkedList.prototype.nodeAtIndex = function(index) {

    if (index < 0 || index >= this.nElements) {
        return null;
    }
    if (index === (this.nElements - 1)) {
        return this.lastNode;
    }
    var node = this.firstNode;
    for (var i = 0; i < index; i++) {
        node = node.next;
    }
    return node;
};
/**
 * @private
 */
buckets.LinkedList.prototype.createNode = function(item) {
    return {
        element: item,
        next: null
    };
};


/**
 * Creates an empty dictionary. 
 * @class <p>Dictionaries map keys to values; each key can map to at most one value.
 * This implementation accepts any kind of objects as keys.</p>
 *
 * <p>If the keys are custom objects a function which converts keys to unique
 * strings must be provided. Example:</p>
 * <pre>
 * function petToString(pet) {
 *  return pet.name;
 * }
 * </pre>
 * @constructor
 * @param {function(Object):string=} toStrFunction optional function used
 * to convert keys to strings. If the keys aren't strings or if toString()
 * is not appropriate, a custom function which receives a key and returns a
 * unique string must be provided.
 */
buckets.Dictionary = function(toStrFunction) {

    /**
     * Object holding the key-value pairs.
     * @type {Object}
     * @private
     */
    this.table = {};

    /**
     * Number of elements in the list.
     * @type {number}
     * @private
     */
    this.nElements = 0;

    /**
     * Function used to convert keys to strings.
     * @type {function(Object):string}
     * @private
     */
    this.toStr = toStrFunction || buckets.defaultToString;
};

/**
 * Returns the value to which this dictionary maps the specified key.
 * Returns undefined if this dictionary contains no mapping for this key.
 * @param {Object} key key whose associated value is to be returned.
 * @return {*} the value to which this dictionary maps the specified key or
 * undefined if the map contains no mapping for this key.
 */
buckets.Dictionary.prototype.get = function(key) {

    var pair = this.table[this.toStr(key)];
    if (buckets.isUndefined(pair)) {
        return undefined;
    }
    return pair.value;
};
/**
 * Associates the specified value with the specified key in this dictionary.
 * If the dictionary previously contained a mapping for this key, the old
 * value is replaced by the specified value.
 * @param {Object} key key with which the specified value is to be
 * associated.
 * @param {Object} value value to be associated with the specified key.
 * @return {*} previous value associated with the specified key, or undefined if
 * there was no mapping for the key or if the key/value are undefined.
 */
buckets.Dictionary.prototype.set = function(key, value) {

    if (buckets.isUndefined(key) || buckets.isUndefined(value)) {
        return undefined;
    }

    var ret;
    var k = this.toStr(key);
    var previousElement = this.table[k];
    if (buckets.isUndefined(previousElement)) {
        this.nElements++;
        ret = undefined;
    } else {
        ret = previousElement.value;
    }
    this.table[k] = {
        key: key,
        value: value
    };
    return ret;
};
/**
 * Removes the mapping for this key from this dictionary if it is present.
 * @param {Object} key key whose mapping is to be removed from the
 * dictionary.
 * @return {*} previous value associated with specified key, or undefined if
 * there was no mapping for key.
 */
buckets.Dictionary.prototype.remove = function(key) {
    var k = this.toStr(key);
    var previousElement = this.table[k];
    if (!buckets.isUndefined(previousElement)) {
        delete this.table[k];
        this.nElements--;
        return previousElement.value;
    }
    return undefined;
};
/**
 * Returns an array containing all of the keys in this dictionary.
 * @return {Array} an array containing all of the keys in this dictionary.
 */
buckets.Dictionary.prototype.keys = function() {
    var array = [];
    for (var name in this.table) {
        if (this.table.hasOwnProperty(name)) {
            array.push(this.table[name].key);
        }
    }
    return array;
};
/**
 * Returns an array containing all of the values in this dictionary.
 * @return {Array} an array containing all of the values in this dictionary.
 */
buckets.Dictionary.prototype.values = function() {
    var array = [];
    for (var name in this.table) {
        if (this.table.hasOwnProperty(name)) {
            array.push(this.table[name].value);
        }
    }
    return array;
};

/**
 * Executes the provided function once for each key-value pair 
 * present in this dictionary.
 * @param {function(Object,Object):*} callback function to execute, it is
 * invoked with two arguments: key and value. To break the iteration you can 
 * optionally return false.
 */
buckets.Dictionary.prototype.forEach = function(callback) {
    for (var name in this.table) {
        if (this.table.hasOwnProperty(name)) {
            var pair = this.table[name];
            var ret = callback(pair.key, pair.value);
            if (ret === false) {
                return;
            }
        }
    }
};

/**
 * Returns true if this dictionary contains a mapping for the specified key.
 * @param {Object} key key whose presence in this dictionary is to be
 * tested.
 * @return {boolean} true if this dictionary contains a mapping for the
 * specified key.
 */
buckets.Dictionary.prototype.containsKey = function(key) {
    return ! buckets.isUndefined(this.get(key));
};
/**
 * Removes all mappings from this dictionary.
 * @this {buckets.Dictionary}
 */
buckets.Dictionary.prototype.clear = function() {

    this.table = {};
    this.nElements = 0;
};
/**
 * Returns the number of keys in this dictionary.
 * @return {number} the number of key-value mappings in this dictionary.
 */
buckets.Dictionary.prototype.size = function() {
    return this.nElements;
};

/**
 * Returns true if this dictionary contains no mappings.
 * @return {boolean} true if this dictionary contains no mappings.
 */
buckets.Dictionary.prototype.isEmpty = function() {
    return this.nElements <= 0;
};

// /**
//  * Returns true if this dictionary is equal to the given dictionary.
//  * Two dictionaries are equal if they contain the same mappings.
//  * @param {buckets.Dictionary} other the other dictionary.
//  * @param {function(Object,Object):boolean=} valuesEqualFunction optional
//  * function used to check if two values are equal.
//  * @return {boolean} true if this dictionary is equal to the given dictionary.
//  */
// buckets.Dictionary.prototype.equals = function(other,valuesEqualFunction) {
// 	var eqF = valuesEqualFunction || buckets.defaultEquals;
// 	if(!(other instanceof buckets.Dictionary)){
// 		return false;
// 	}
// 	if(this.size() !== other.size()){
// 		return false;
// 	}
// 	return this.equalsAux(this.firstNode,other.firstNode,eqF);
// };
/**
 * Creates an empty multi dictionary. 
 * @class <p>A multi dictionary is a special kind of dictionary that holds
 * multiple values against each key. Setting a value into the dictionary will 
 * add the value to an array at that key. Getting a key will return an array,
 * holding all the values set to that key.
 * This implementation accepts any kind of objects as keys.</p>
 *
 * <p>If the keys are custom objects a function which converts keys to strings must be
 * provided. Example:</p>
 *
 * <pre>
 * function petToString(pet) {
 *  return pet.name;
 * }
 * </pre>
 * <p>If the values are custom objects a function to check equality between values
 * must be provided. Example:</p>
 *
 * <pre>
 * function petsAreEqualByAge(pet1,pet2) {
 *  return pet1.age===pet2.age;
 * }
 * </pre>
 * @constructor
 * @param {function(Object):string=} toStrFunction optional function
 * to convert keys to strings. If the keys aren't strings or if toString()
 * is not appropriate, a custom function which receives a key and returns a
 * unique string must be provided.
 * @param {function(Object,Object):boolean=} valuesEqualsFunction optional
 * function to check if two values are equal.
 * 
 */
buckets.MultiDictionary = function(toStrFunction, valuesEqualsFunction) {
    // Call the parent's constructor
    this.parent = new buckets.Dictionary(toStrFunction);
    this.equalsF = valuesEqualsFunction || buckets.defaultEquals;
};

/**
 * Returns an array holding the values to which this dictionary maps
 * the specified key.
 * Returns an empty array if this dictionary contains no mappings for this key.
 * @param {Object} key key whose associated values are to be returned.
 * @return {Array} an array holding the values to which this dictionary maps
 * the specified key.
 */
buckets.MultiDictionary.prototype.get = function(key) {
    var values = this.parent.get(key);
    if (buckets.isUndefined(values)) {
        return [];
    }
    return buckets.arrays.copy(values);
};

/**
 * Adds the value to the array associated with the specified key, if 
 * it is not already present.
 * @param {Object} key key with which the specified value is to be
 * associated.
 * @param {Object} value the value to add to the array at the key
 * @return {boolean} true if the value was not already associated with that key.
 */
buckets.MultiDictionary.prototype.set = function(key, value) {

    if (buckets.isUndefined(key) || buckets.isUndefined(value)) {
        return false;
    }
    if (!this.containsKey(key)) {
        this.parent.set(key, [value]);
        return true;
    }
    var array = this.parent.get(key);
    if (buckets.arrays.contains(array, value, this.equalsF)) {
        return false;
    }
    array.push(value);
    return true;
};

/**
 * Removes the specified values from the array of values associated with the
 * specified key. If a value isn't given, all values associated with the specified 
 * key are removed.
 * @param {Object} key key whose mapping is to be removed from the
 * dictionary.
 * @param {Object=} value optional argument to specify the value to remove 
 * from the array associated with the specified key.
 * @return {*} true if the dictionary changed, false if the key doesn't exist or 
 * if the specified value isn't associated with the specified key.
 */
buckets.MultiDictionary.prototype.remove = function(key, value) {
    if (buckets.isUndefined(value)) {
        var v = this.parent.remove(key);
        if (buckets.isUndefined(v)) {
            return false;
        }
        return true;
    }
    var array = this.parent.get(key);
    if (buckets.arrays.remove(array, value, this.equalsF)) {
        if (array.length === 0) {
            this.parent.remove(key);
        }
        return true;
    }
    return false;
};

/**
 * Returns an array containing all of the keys in this dictionary.
 * @return {Array} an array containing all of the keys in this dictionary.
 */
buckets.MultiDictionary.prototype.keys = function() {
    return this.parent.keys();
};

/**
 * Returns an array containing all of the values in this dictionary.
 * @return {Array} an array containing all of the values in this dictionary.
 */
buckets.MultiDictionary.prototype.values = function() {
    var values = this.parent.values();
    var array = [];
    for (var i = 0; i < values.length; i++) {
        var v = values[i];
        for (var j = 0; j < v.length; j++) {
            array.push(v[j]);
        }
    }
    return array;
};

/**
 * Returns true if this dictionary at least one value associatted the specified key.
 * @param {Object} key key whose presence in this dictionary is to be
 * tested.
 * @return {boolean} true if this dictionary at least one value associatted 
 * the specified key.
 */
buckets.MultiDictionary.prototype.containsKey = function(key) {
    return this.parent.containsKey(key);
};

/**
 * Removes all mappings from this dictionary.
 */
buckets.MultiDictionary.prototype.clear = function() {
    return this.parent.clear();
};

/**
 * Returns the number of keys in this dictionary.
 * @return {number} the number of key-value mappings in this dictionary.
 */
buckets.MultiDictionary.prototype.size = function() {
    return this.parent.size();
};

/**
 * Returns true if this dictionary contains no mappings.
 * @return {boolean} true if this dictionary contains no mappings.
 */
buckets.MultiDictionary.prototype.isEmpty = function() {
    return this.parent.isEmpty();
};

/**
 * Creates an empty Heap.
 * @class 
 * <p>A heap is a binary tree, where the nodes maintain the heap property: 
 * each node is smaller than each of its children. 
 * This implementation uses an array to store elements.</p>
 * <p>If the inserted elements are custom objects a compare function must be provided, 
 *  at construction time, otherwise the <=, === and >= operators are 
 * used to compare elements. Example:</p>
 *
 * <pre>
 * function compare(a, b) {
 *  if (a is less than b by some ordering criterion) {
 *     return -1;
 *  } if (a is greater than b by the ordering criterion) {
 *     return 1;
 *  } 
 *  // a must be equal to b
 *  return 0;
 * }
 * </pre>
 *
 * <p>If a Max-Heap is wanted (greater elements on top) you can a provide a
 * reverse compare function to accomplish that behavior. Example:</p>
 *
 * <pre>
 * function reverseCompare(a, b) {
 *  if (a is less than b by some ordering criterion) {
 *     return 1;
 *  } if (a is greater than b by the ordering criterion) {
 *     return -1;
 *  } 
 *  // a must be equal to b
 *  return 0;
 * }
 * </pre>
 *
 * @constructor
 * @param {function(Object,Object):number=} compareFunction optional
 * function used to compare two elements. Must return a negative integer,
 * zero, or a positive integer as the first argument is less than, equal to,
 * or greater than the second.
 */
buckets.Heap = function(compareFunction) {

    /**
     * Array used to store the elements od the heap.
     * @type {Array.<Object>}
     * @private
     */
    this.data = [];

    /**
     * Function used to compare elements.
     * @type {function(Object,Object):number}
     * @private
     */
    this.compare = compareFunction || buckets.defaultCompare;
};
/**
 * Returns the index of the left child of the node at the given index.
 * @param {number} nodeIndex The index of the node to get the left child
 * for.
 * @return {number} The index of the left child.
 * @private
 */
buckets.Heap.prototype.leftChildIndex = function(nodeIndex) {
    return (2 * nodeIndex) + 1;
};
/**
 * Returns the index of the right child of the node at the given index.
 * @param {number} nodeIndex The index of the node to get the right child
 * for.
 * @return {number} The index of the right child.
 * @private
 */
buckets.Heap.prototype.rightChildIndex = function(nodeIndex) {
    return (2 * nodeIndex) + 2;
};
/**
 * Returns the index of the parent of the node at the given index.
 * @param {number} nodeIndex The index of the node to get the parent for.
 * @return {number} The index of the parent.
 * @private
 */
buckets.Heap.prototype.parentIndex = function(nodeIndex) {
    return Math.floor((nodeIndex - 1) / 2);
};
/**
 * Returns the index of the smaller child node (if it exists).
 * @param {number} leftChild left child index.
 * @param {number} rightChild right child index.
 * @return {number} the index with the minimum value or -1 if it doesn't
 * exists.
 * @private
 */
buckets.Heap.prototype.minIndex = function(leftChild, rightChild) {

    if (rightChild >= this.data.length) {
        if (leftChild >= this.data.length) {
            return - 1;
        } else {
            return leftChild;
        }
    } else {
        if (this.compare(this.data[leftChild], this.data[rightChild]) <= 0) {
            return leftChild;
        } else {
            return rightChild;
        }
    }
};
/**
 * Moves the node at the given index up to its proper place in the heap.
 * @param {number} index The index of the node to move up.
 * @private
 */
buckets.Heap.prototype.siftUp = function(index) {

    var parent = this.parentIndex(index);
    while (index > 0 && this.compare(this.data[parent], this.data[index]) > 0) {
        buckets.arrays.swap(this.data, parent, index);
        index = parent;
        parent = this.parentIndex(index);
    }
};
/**
 * Moves the node at the given index down to its proper place in the heap.
 * @param {number} nodeIndex The index of the node to move down.
 * @private
 */
buckets.Heap.prototype.siftDown = function(nodeIndex) {

    //smaller child index
    var min = this.minIndex(this.leftChildIndex(nodeIndex),
    this.rightChildIndex(nodeIndex));

    while (min >= 0 && this.compare(this.data[nodeIndex],
    this.data[min]) > 0) {
        buckets.arrays.swap(this.data, min, nodeIndex);
        nodeIndex = min;
        min = this.minIndex(this.leftChildIndex(nodeIndex),
        this.rightChildIndex(nodeIndex));
    }
};
/**
 * Retrieves but does not remove the root element of this heap.
 * @return {*} The value at the root of the heap. Returns undefined if the
 * heap is empty.
 */
buckets.Heap.prototype.peek = function() {

    if (this.data.length > 0) {
        return this.data[0];
    } else {
        return undefined;
    }
};
/**
 * Adds the given element into the heap.
 * @param {*} element the element.
 * @return true if the element was added or fals if it is undefined.
 */
buckets.Heap.prototype.add = function(element) {
    if (buckets.isUndefined(element)) {
        return undefined;
    }
    this.data.push(element);
    this.siftUp(this.data.length - 1);
    return true;
};

/**
 * Retrieves and removes the root element of this heap.
 * @return {*} The value removed from the root of the heap. Returns
 * undefined if the heap is empty.
 */
buckets.Heap.prototype.removeRoot = function() {

    if (this.data.length > 0) {
        var obj = this.data[0];
        this.data[0] = this.data[this.data.length - 1];
        this.data.splice(this.data.length - 1, 1);
        if (this.data.length > 0) {
            this.siftDown(0);
        }
        return obj;
    }
    return undefined;
};
/**
 * Returns true if this heap contains the specified element.
 * @param {Object} element element to search for.
 * @return {boolean} true if this Heap contains the specified element, false
 * otherwise.
 */
buckets.Heap.prototype.contains = function(element) {
    var equF = buckets.compareToEquals(this.compare);
    return buckets.arrays.contains(this.data, element, equF);
};
/**
 * Returns the number of elements in this heap.
 * @return {number} the number of elements in this heap.
 */
buckets.Heap.prototype.size = function() {
    return this.data.length;
};
/**
 * Checks if this heap is empty.
 * @return {boolean} true if and only if this heap contains no items; false
 * otherwise.
 */
buckets.Heap.prototype.isEmpty = function() {
    return this.data.length <= 0;
};
/**
 * Removes all of the elements from this heap.
 */
buckets.Heap.prototype.clear = function() {
    this.data.length = 0;
};

/**
 * Executes the provided function once for each element present in this heap in 
 * no particular order.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element value, to break the iteration you can 
 * optionally return false.
 */
buckets.Heap.prototype.forEach = function(callback) {
   buckets.arrays.forEach(this.data,callback);
};

/**
 * Creates an empty Stack.
 * @class A Stack is a Last-In-First-Out (LIFO) data structure, the last
 * element added to the stack will be the first one to be removed. This
 * implementation uses a linked list as a container.
 * @constructor
 */
buckets.Stack = function() {

    /**
     * List containing the elements.
     * @type buckets.LinkedList
     * @private
     */
    this.list = new buckets.LinkedList();
};
/**
 * Pushes an item onto the top of this stack.
 * @param {Object} elem the element to be pushed onto this stack.
 * @return {boolean} true if the element was pushed or false if it is undefined.
 */
buckets.Stack.prototype.push = function(elem) {
    return this.list.add(elem, 0);
};
/**
 * Pushes an item onto the top of this stack.
 * @param {Object} elem the element to be pushed onto this stack.
 * @return {boolean} true if the element was pushed or false if it is undefined.
 */
buckets.Stack.prototype.add = function(elem) {
    return this.list.add(elem, 0);
};
/**
 * Removes the object at the top of this stack and returns that object.
 * @return {*} the object at the top of this stack or undefined if the
 * stack is empty.
 */
buckets.Stack.prototype.pop = function() {
    return this.list.removeElementAtIndex(0);
};
/**
 * Looks at the object at the top of this stack without removing it from the
 * stack.
 * @return {*} the object at the top of this stack or undefined if the
 * stack is empty.
 */
buckets.Stack.prototype.peek = function() {
    return this.list.first();
};
/**
 * Returns the number of elements in this stack.
 * @return {number} the number of elements in this stack.
 */
buckets.Stack.prototype.size = function() {
    return this.list.size();
};

/**
 * Returns true if this stack contains the specified element.
 * <p>If the elements inside this stack are
 * not comparable with the === operator, a custom equals function should be
 * provided to perform searches, the function must receive two arguments and
 * return true if they are equal, false otherwise. Example:</p>
 *
 * <pre>
 * var petsAreEqualByName = function(pet1, pet2) {
 *  return pet1.name === pet2.name;
 * }
 * </pre>
 * @param {Object} elem element to search for.
 * @param {function(Object,Object):boolean=} equalsFunction optional
 * function to check if two elements are equal.
 * @return {boolean} true if this stack contains the specified element,
 * false otherwise.
 */
buckets.Stack.prototype.contains = function(elem, equalsFunction) {
    return this.list.contains(elem, equalsFunction);
};
/**
 * Checks if this stack is empty.
 * @return {boolean} true if and only if this stack contains no items; false
 * otherwise.
 */
buckets.Stack.prototype.isEmpty = function() {
    return this.list.isEmpty();
};
/**
 * Removes all of the elements from this stack.
 */
buckets.Stack.prototype.clear = function() {
    this.list.clear();
};

/**
 * Executes the provided function once for each element present in this stack in 
 * LIFO order.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element value, to break the iteration you can 
 * optionally return false.
 */
buckets.Stack.prototype.forEach = function(callback) {
   this.list.forEach(callback);
};

/**
 * Creates an empty queue.
 * @class A queue is a First-In-First-Out (FIFO) data structure, the first
 * element added to the queue will be the first one to be removed. This
 * implementation uses a linked list as a container.
 * @constructor
 */
buckets.Queue = function() {

    /**
     * List containing the elements.
     * @type buckets.LinkedList
     * @private
     */
    this.list = new buckets.LinkedList();
};
/**
 * Inserts the specified element into the end of this queue.
 * @param {Object} elem the element to insert.
 * @return {boolean} true if the element was inserted, or false if it is undefined.
 */
buckets.Queue.prototype.enqueue = function(elem) {
    return this.list.add(elem);
};
/**
 * Inserts the specified element into the end of this queue.
 * @param {Object} elem the element to insert.
 * @return {boolean} true if the element was inserted, or false if it is undefined.
 */
buckets.Queue.prototype.add = function(elem) {
    return this.list.add(elem);
};
/**
 * Retrieves and removes the head of this queue.
 * @return {*} the head of this queue, or undefined if this queue is empty.
 */
buckets.Queue.prototype.dequeue = function() {
    if (this.list.size() !== 0) {
        var el = this.list.first();
        this.list.removeElementAtIndex(0);
        return el;
    }
    return undefined;
};
/**
 * Retrieves, but does not remove, the head of this queue.
 * @return {*} the head of this queue, or undefined if this queue is empty.
 */
buckets.Queue.prototype.peek = function() {

    if (this.list.size() !== 0) {
        return this.list.first();
    }
    return undefined;
};

/**
 * Returns the number of elements in this queue.
 * @return {number} the number of elements in this queue.
 */
buckets.Queue.prototype.size = function() {
    return this.list.size();
};

/**
 * Returns true if this queue contains the specified element.
 * <p>If the elements inside this stack are
 * not comparable with the === operator, a custom equals function should be
 * provided to perform searches, the function must receive two arguments and
 * return true if they are equal, false otherwise. Example:</p>
 *
 * <pre>
 * var petsAreEqualByName = function(pet1, pet2) {
 *  return pet1.name === pet2.name;
 * }
 * </pre>
 * @param {Object} elem element to search for.
 * @param {function(Object,Object):boolean=} equalsFunction optional
 * function to check if two elements are equal.
 * @return {boolean} true if this queue contains the specified element,
 * false otherwise.
 */
buckets.Queue.prototype.contains = function(elem, equalsFunction) {
    return this.list.contains(elem, equalsFunction);
};

/**
 * Checks if this queue is empty.
 * @return {boolean} true if and only if this queue contains no items; false
 * otherwise.
 */
buckets.Queue.prototype.isEmpty = function() {
    return this.list.size() <= 0;
};

/**
 * Removes all of the elements from this queue.
 */
buckets.Queue.prototype.clear = function() {
    this.list.clear();
};

/**
 * Executes the provided function once for each element present in this queue in 
 * FIFO order.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element value, to break the iteration you can 
 * optionally return false.
 */
buckets.Queue.prototype.forEach = function(callback) {
   this.list.forEach(callback);
};

/**
 * Creates an empty priority queue.
 * @class <p>In a priority queue each element is associated with a "priority",
 * elements are dequeued in highest-priority-first order (the elements with the 
 * highest priority are dequeued first). Priority Queues are implemented as heaps. 
 * If the inserted elements are custom objects a compare function must be provided, 
 * otherwise the <=, === and >= operators are used to compare object priority.</p>
 * <pre>
 * function compare(a, b) {
 *  if (a is less than b by some ordering criterion) {
 *     return -1;
 *  } if (a is greater than b by the ordering criterion) {
 *     return 1;
 *  } 
 *  // a must be equal to b
 *  return 0;
 * }
 * </pre>
 * @constructor
 * @param {function(Object,Object):number=} compareFunction optional
 * function used to compare two element priorities. Must return a negative integer,
 * zero, or a positive integer as the first argument is less than, equal to,
 * or greater than the second.
 */
buckets.PriorityQueue = function(compareFunction) {
    this.heap = new buckets.Heap(buckets.reverseCompareFunction(compareFunction));
};

/**
 * Inserts the specified element into this priority queue.
 * @param {Object} element the element to insert.
 * @return {boolean} true if the element was inserted, or false if it is undefined.
 */
buckets.PriorityQueue.prototype.enqueue = function(element) {
    return this.heap.add(element);
};

/**
 * Inserts the specified element into this priority queue.
 * @param {Object} element the element to insert.
 * @return {boolean} true if the element was inserted, or false if it is undefined.
 */
buckets.PriorityQueue.prototype.add = function(element) {
    return this.heap.add(element);
};

/**
 * Retrieves and removes the highest priority element of this queue.
 * @return {*} the the highest priority element of this queue, 
or undefined if this queue is empty.
 */
buckets.PriorityQueue.prototype.dequeue = function() {
    if (this.heap.size() !== 0) {
        var el = this.heap.peek();
        this.heap.removeRoot();
        return el;
    }
    return undefined;
};

/**
 * Retrieves, but does not remove, the highest priority element of this queue.
 * @return {*} the highest priority element of this queue, or undefined if this queue is empty.
 */
buckets.PriorityQueue.prototype.peek = function() {
    return this.heap.peek();
};

/**
 * Returns true if this priority queue contains the specified element.
 * @param {Object} element element to search for.
 * @return {boolean} true if this priority queue contains the specified element,
 * false otherwise.
 */
buckets.PriorityQueue.prototype.contains = function(element) {
    return this.heap.contains(element);
};

/**
 * Checks if this priority queue is empty.
 * @return {boolean} true if and only if this priority queue contains no items; false
 * otherwise.
 */
buckets.PriorityQueue.prototype.isEmpty = function() {
    return this.heap.isEmpty();
};

/**
 * Returns the number of elements in this priority queue.
 * @return {number} the number of elements in this priority queue.
 */
buckets.PriorityQueue.prototype.size = function() {
    return this.heap.size();
};

/**
 * Removes all of the elements from this priority queue.
 */
buckets.PriorityQueue.prototype.clear = function() {
    this.heap.clear();
};

/**
 * Executes the provided function once for each element present in this queue in 
 * no particular order.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element value, to break the iteration you can 
 * optionally return false.
 */
buckets.PriorityQueue.prototype.forEach = function(callback) {
   buckets.heap.forEach(callback);
};


/**
 * Creates an empty set.
 * @class <p>A set is a data structure that contains no duplicate items.</p>
 * <p>If the inserted elements are custom objects a function 
 * which converts elements to strings must be provided. Example:</p>
 *
 * <pre>
 * function petToString(pet) {
 *  return pet.name;
 * }
 * </pre>
 *
 * @constructor
 * @param {function(Object):string=} toStringFunction optional function used
 * to convert elements to strings. If the elements aren't strings or if toString()
 * is not appropriate, a custom function which receives a onject and returns a
 * unique string must be provided.
 */
buckets.Set = function(toStringFunction) {
    this.dictionary = new buckets.Dictionary(toStringFunction);
};

/**
 * Returns true if this set contains the specified element.
 * @param {Object} element element to search for.
 * @return {boolean} true if this set contains the specified element,
 * false otherwise.
 */
buckets.Set.prototype.contains = function(element) {
    return this.dictionary.containsKey(element);
};

/**
 * Adds the specified element to this set if it is not already present.
 * @param {Object} element the element to insert.
 * @return {boolean} true if this set did not already contain the specified element.
 */
buckets.Set.prototype.add = function(element) {
    if (this.contains(element) || buckets.isUndefined(element)) {
        return false;
    } else {
        this.dictionary.set(element, element);
        return true;
    }
};

/**
 * Performs an intersecion between this an another set.
 * Removes all values that are not present this set and the given set.
 * @param {buckets.Set} otherSet other set.
 */
buckets.Set.prototype.intersection = function(otherSet) {
    var set = this;
    this.forEach(function(element) {
        if (!otherSet.contains(element)) {
            set.remove(element);
        }
    });
};

/**
 * Performs a union between this an another set.
 * Adds all values from the given set to this set.
 * @param {buckets.Set} otherSet other set.
 */
buckets.Set.prototype.union = function(otherSet) {
    var set = this;
    otherSet.forEach(function(element) {
        set.add(element);
    });
};

/**
 * Performs a difference between this an another set.
 * Removes from this set all the values that are present in the given set.
 * @param {buckets.Set} otherSet other set.
 */
buckets.Set.prototype.difference = function(otherSet) {
    var set = this;
    otherSet.forEach(function(element) {
        set.remove(element);
    });
};

/**
 * Checks whether the given set contains all the elements in this set.
 * @param {buckets.Set} otherSet other set.
 * @return {boolean} true if this set is a subset of the given set.
 */
buckets.Set.prototype.isSubsetOf = function(otherSet) {
    if (this.size() > otherSet.size()) {
        return false;
    }

    this.forEach(function(element) {
        if (!otherSet.contains(element)) {
            return false;
        }
    });
    return true;
};

/**
 * Removes the specified element from this set if it is present.
 * @return {boolean} true if this set contained the specified element.
 */
buckets.Set.prototype.remove = function(element) {
    if (!this.contains(element)) {
        return false;
    } else {
        this.dictionary.remove(element);
        return true;
    }
};

/**
 * Executes the provided function once for each element 
 * present in this set.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one arguments: the element. To break the iteration you can 
 * optionally return false.
 */
buckets.Set.prototype.forEach = function(callback) {
    this.dictionary.forEach(function(k, v) {
        return callback(v);
    });
};

/**
 * Returns an array containing all of the elements in this set in arbitrary order.
 * @return {Array} an array containing all of the elements in this set.
 */
buckets.Set.prototype.toArray = function() {
    return this.dictionary.values();
};

/**
 * Returns true if this set contains no elements.
 * @return {boolean} true if this set contains no elements.
 */
buckets.Set.prototype.isEmpty = function() {
    return this.dictionary.isEmpty();
};

/**
 * Returns the number of elements in this set.
 * @return {number} the number of elements in this set.
 */
buckets.Set.prototype.size = function() {
    return this.dictionary.size();
};

/**
 * Removes all of the elements from this set.
 */
buckets.Set.prototype.clear = function() {
    this.dictionary.clear();
};

/**
 * Creates an empty bag.
 * @class <p>A bag is a special kind of set in which members are 
 * allowed to appear more than once.</p>
 * <p>If the inserted elements are custom objects a function 
 * which converts elements to unique strings must be provided. Example:</p>
 *
 * <pre>
 * function petToString(pet) {
 *  return pet.name;
 * }
 * </pre>
 *
 * @constructor
 * @param {function(Object):string=} toStringFunction optional function used
 * to convert elements to strings. If the elements aren't strings or if toString()
 * is not appropriate, a custom function which receives an object and returns a
 * unique string must be provided.
 */
buckets.Bag = function(toStrFunction) {
    this.toStrF = toStrFunction || buckets.defaultToString;
    this.dictionary = new buckets.Dictionary(this.toStrF);
    this.nElements = 0;
};

/**
* Adds nCopies of the specified object to this bag.
* @param {Object} element element to add.
* @param {number=} nCopies the number of copies to add, if this argument is
* undefined 1 copy is added.
* @return {boolean} true unless element is undefined.
*/
buckets.Bag.prototype.add = function(element, nCopies) {

    if (isNaN(nCopies) || buckets.isUndefined(nCopies)) {
        nCopies = 1;
    }
    if (buckets.isUndefined(element) || nCopies <= 0) {
        return false;
    }

    if (!this.contains(element)) {
        var node = {
            value: element,
            copies: nCopies
        };
        this.dictionary.set(element, node);
    } else {
        this.dictionary.get(element).copies += nCopies;
    }
    this.nElements += nCopies;
    return true;
};

/**
* Counts the number of copies of the specified object in this bag.
* @param {Object} element the object to search for..
* @return {number} the number of copies of the object, 0 if not found
*/
buckets.Bag.prototype.count = function(element) {

    if (!this.contains(element)) {
        return 0;
    } else {
        return this.dictionary.get(element).copies;
    }
};

/**
 * Returns true if this bag contains the specified element.
 * @param {Object} element element to search for.
 * @return {boolean} true if this bag contains the specified element,
 * false otherwise.
 */
buckets.Bag.prototype.contains = function(element) {
    return this.dictionary.containsKey(element);
};

/**
* Removes nCopies of the specified object to this bag.
* If the number of copies to remove is greater than the actual number 
* of copies in the Bag, all copies are removed. 
* @param {Object} element element to remove.
* @param {number=} nCopies the number of copies to remove, if this argument is
* undefined 1 copy is removed.
* @return {boolean} true if at least 1 element was removed.
*/
buckets.Bag.prototype.remove = function(element, nCopies) {

    if (isNaN(nCopies) || buckets.isUndefined(nCopies)) {
        nCopies = 1;
    }
    if (buckets.isUndefined(element) || nCopies <= 0) {
        return false;
    }

    if (!this.contains(element)) {
        return false;
    } else {
        var node = this.dictionary.get(element);
        if (nCopies > node.copies) {
            this.nElements -= node.copies;
        } else {
            this.nElements -= nCopies;
        }
        node.copies -= nCopies;
        if (node.copies <= 0) {
            this.dictionary.remove(element);
        }
        return true;
    }
};

/**
 * Returns an array containing all of the elements in this big in arbitrary order, 
 * including multiple copies.
 * @return {Array} an array containing all of the elements in this bag.
 */
buckets.Bag.prototype.toArray = function() {
    var a = [];
    var values = this.dictionary.values();
    var vl = values.length;
    for (var i = 0; i < vl; i++) {
        var node = values[i];
        var element = node.value;
        var copies = node.copies;
        for (var j = 0; j < copies; j++) {
            a.push(element);
        }
    }
    return a;
};

/**
 * Returns a set of unique elements in this bag. 
 * @return {buckets.Set} a set of unique elements in this bag.
 */
buckets.Bag.prototype.toSet = function() {
    var set = new buckets.Set(this.toStrF);
    var elements = this.dictionary.values();
    var l = elements.length;
    for (var i = 0; i < l; i++) {
        var value = elements[i].value;
        set.add(value);
    }
    return set;
};

/**
 * Executes the provided function once for each element 
 * present in this bag, including multiple copies.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element. To break the iteration you can 
 * optionally return false.
 */
buckets.Bag.prototype.forEach = function(callback) {
    this.dictionary.forEach(function(k, v) {
        var value = v.value;
        var copies = v.copies;
        for (var i = 0; i < copies; i++) {
            if (callback(value) === false) {
                return false;
            }
        }
        return true;
    });
};
/**
 * Returns the number of elements in this bag.
 * @return {number} the number of elements in this bag.
 */
buckets.Bag.prototype.size = function() {
    return this.nElements;
};

/**
 * Returns true if this bag contains no elements.
 * @return {boolean} true if this bag contains no elements.
 */
buckets.Bag.prototype.isEmpty = function() {
    return this.nElements === 0;
};

/**
 * Removes all of the elements from this bag.
 */
buckets.Bag.prototype.clear = function() {
    this.nElements = 0;
    this.dictionary.clear();
};



/**
 * Creates an empty binary search tree.
 * @class <p>A binary search tree is a binary tree in which each 
 * internal node stores an element such that the elements stored in the 
 * left subtree are less than it and the elements 
 * stored in the right subtree are greater.</p>
 * <p>Formally, a binary search tree is a node-based binary tree data structure which 
 * has the following properties:</p>
 * <ul>
 * <li>The left subtree of a node contains only nodes with elements less 
 * than the node's element</li>
 * <li>The right subtree of a node contains only nodes with elements greater 
 * than the node's element</li>
 * <li>Both the left and right subtrees must also be binary search trees.</li>
 * </ul>
 * <p>If the inserted elements are custom objects a compare function must 
 * be provided at construction time, otherwise the <=, === and >= operators are 
 * used to compare elements. Example:</p>
 * <pre>
 * function compare(a, b) {
 *  if (a is less than b by some ordering criterion) {
 *     return -1;
 *  } if (a is greater than b by the ordering criterion) {
 *     return 1;
 *  } 
 *  // a must be equal to b
 *  return 0;
 * }
 * </pre>
 * @constructor
 * @param {function(Object,Object):number=} compareFunction optional
 * function used to compare two elements. Must return a negative integer,
 * zero, or a positive integer as the first argument is less than, equal to,
 * or greater than the second.
 */
buckets.BSTree = function(compareFunction) {
    this.root = null;
    this.compare = compareFunction || buckets.defaultCompare;
    this.nElements = 0;
};


/**
 * Adds the specified element to this tree if it is not already present.
 * @param {Object} element the element to insert.
 * @return {boolean} true if this tree did not already contain the specified element.
 */
buckets.BSTree.prototype.add = function(element) {
    if (buckets.isUndefined(element)) {
        return false;
    }

    if (this.insertNode(this.createNode(element)) !== null) {
        this.nElements++;
        return true;
    }
    return false;
};

/**
 * Removes all of the elements from this tree.
 */
buckets.BSTree.prototype.clear = function() {
    this.root = null;
    this.nElements = 0;
};

/**
 * Returns true if this tree contains no elements.
 * @return {boolean} true if this tree contains no elements.
 */
buckets.BSTree.prototype.isEmpty = function() {
    return this.nElements === 0;
};

/**
 * Returns the number of elements in this tree.
 * @return {number} the number of elements in this tree.
 */
buckets.BSTree.prototype.size = function() {
    return this.nElements;
};

/**
 * Returns true if this tree contains the specified element.
 * @param {Object} element element to search for.
 * @return {boolean} true if this tree contains the specified element,
 * false otherwise.
 */
buckets.BSTree.prototype.contains = function(element) {
    if (buckets.isUndefined(element)) {
        return false;
    }
    return this.searchNode(this.root, element) !== null;
};

/**
 * Removes the specified element from this tree if it is present.
 * @return {boolean} true if this tree contained the specified element.
 */
buckets.BSTree.prototype.remove = function(element) {
    var node = this.searchNode(this.root, element);
    if (node === null) {
        return false;
    }
    this.removeNode(node);
    this.nElements--;
    return true;
};

/**
 * Executes the provided function once for each element present in this tree in 
 * in-order.
 * @param {function(Object):*} callback function to execute, it is invoked with one 
 * argument: the element value, to break the iteration you can optionally return false.
 */
buckets.BSTree.prototype.inorderTraversal = function(callback) {
    this.inorderTraversalAux(this.root, callback, {
        stop: false
    });
};

/**
 * Executes the provided function once for each element present in this tree in pre-order.
 * @param {function(Object):*} callback function to execute, it is invoked with one 
 * argument: the element value, to break the iteration you can optionally return false.
 */
buckets.BSTree.prototype.preorderTraversal = function(callback) {
    this.preorderTraversalAux(this.root, callback, {
        stop: false
    });
};

/**
 * Executes the provided function once for each element present in this tree in post-order.
 * @param {function(Object):*} callback function to execute, it is invoked with one 
 * argument: the element value, to break the iteration you can optionally return false.
 */
buckets.BSTree.prototype.postorderTraversal = function(callback) {
    this.postorderTraversalAux(this.root, callback, {
        stop: false
    });
};

/**
 * Executes the provided function once for each element present in this tree in 
 * level-order.
 * @param {function(Object):*} callback function to execute, it is invoked with one 
 * argument: the element value, to break the iteration you can optionally return false.
 */
buckets.BSTree.prototype.levelTraversal = function(callback) {
    this.levelTraversalAux(this.root, callback);
};

/**
 * Returns the minimum element of this tree.
 * @return {*} the minimum element of this tree or undefined if this tree is
 * is empty.
 */
buckets.BSTree.prototype.minimum = function() {
    if (this.isEmpty()) {
        return undefined;
    }
    return this.minimumAux(this.root).element;
};

/**
 * Returns the maximum element of this tree.
 * @return {*} the maximum element of this tree or undefined if this tree is
 * is empty.
 */
buckets.BSTree.prototype.maximum = function() {
    if (this.isEmpty()) {
        return undefined;
    }
    return this.maximumAux(this.root).element;
};

/**
 * Executes the provided function once for each element present in this tree in inorder.
 * Equivalent to inorderTraversal.
 * @param {function(Object):*} callback function to execute, it is
 * invoked with one argument: the element value, to break the iteration you can 
 * optionally return false.
 */
buckets.BSTree.prototype.forEach = function(callback) {
    this.inorderTraversal(callback);
};

/**
 * Returns an array containing all of the elements in this tree in in-order.
 * @return {Array} an array containing all of the elements in this tree in in-order.
 */
buckets.BSTree.prototype.toArray = function() {
    var array = [];
    this.inorderTraversal(function(element) {
        array.push(element);
    });
    return array;
};

/**
 * Returns the height of this tree.
 * @return {number} the height of this tree or -1 if is empty.
 */
buckets.BSTree.prototype.height = function() {
    return this.heightAux(this.root);
};

/**
* @private
*/
buckets.BSTree.prototype.searchNode = function(node, element) {
    var cmp = null;
    while (node !== null && cmp !== 0) {
        cmp = this.compare(element, node.element);
        if (cmp < 0) {
            node = node.leftCh;
        } else if (cmp > 0) {
            node = node.rightCh;
        }
    }
    return node;
};


/**
* @private
*/
buckets.BSTree.prototype.transplant = function(n1, n2) {
    if (n1.parent === null) {
        this.root = n2;
    } else if (n1 === n1.parent.leftCh) {
        n1.parent.leftCh = n2;
    } else {
        n1.parent.rightCh = n2;
    }
    if (n2 !== null) {
        n2.parent = n1.parent;
    }
};


/**
* @private
*/
buckets.BSTree.prototype.removeNode = function(node) {
    if (node.leftCh === null) {
        this.transplant(node, node.rightCh);
    } else if (node.rightCh === null) {
        this.transplant(node, node.leftCh);
    } else {
        var y = this.minimumAux(node.rightCh);
        if (y.parent !== node) {
            this.transplant(y, y.rightCh);
            y.rightCh = node.rightCh;
            y.rightCh.parent = y;
        }
        this.transplant(node, y);
        y.leftCh = node.leftCh;
        y.leftCh.parent = y;
    }
};
/**
* @private
*/
buckets.BSTree.prototype.inorderTraversalAux = function(node, callback, signal) {
    if (node === null || signal.stop) {
        return;
    }
    this.inorderTraversalAux(node.leftCh, callback, signal);
    if (signal.stop) {
        return;
    }
    signal.stop = callback(node.element) === false;
    if (signal.stop) {
        return;
    }
    this.inorderTraversalAux(node.rightCh, callback, signal);
};

/**
* @private
*/
buckets.BSTree.prototype.levelTraversalAux = function(node, callback) {
    var queue = new buckets.Queue();
    if (node !== null) {
        queue.enqueue(node);
    }
    while (!queue.isEmpty()) {
        node = queue.dequeue();
        if (callback(node.element) === false) {
            return;
        }
        if (node.leftCh !== null) {
            queue.enqueue(node.leftCh);
        }
        if (node.rightCh !== null) {
            queue.enqueue(node.rightCh);
        }
    }
};

/**
* @private
*/
buckets.BSTree.prototype.preorderTraversalAux = function(node, callback, signal) {
    if (node === null || signal.stop) {
        return;
    }
    signal.stop = callback(node.element) === false;
    if (signal.stop) {
        return;
    }
    this.preorderTraversalAux(node.leftCh, callback, signal);
    if (signal.stop) {
        return;
    }
    this.preorderTraversalAux(node.rightCh, callback, signal);
};
/**
* @private
*/
buckets.BSTree.prototype.postorderTraversalAux = function(node, callback, signal) {
    if (node === null || signal.stop) {
        return;
    }
    this.postorderTraversalAux(node.leftCh, callback, signal);
    if (signal.stop) {
        return;
    }
    this.postorderTraversalAux(node.rightCh, callback, signal);
    if (signal.stop) {
        return;
    }
    signal.stop = callback(node.element) === false;
};

/**
* @private
*/
buckets.BSTree.prototype.minimumAux = function(node) {
    while (node.leftCh !== null) {
        node = node.leftCh;
    }
    return node;
};

/**
* @private
*/
buckets.BSTree.prototype.maximumAux = function(node) {
    while (node.rightCh !== null) {
        node = node.rightCh;
    }
    return node;
};

/**
* @private
*/
buckets.BSTree.prototype.successorNode = function(node) {
    if (node.rightCh !== null) {
        return this.minimumAux(node.rightCh);
    }
    var successor = node.parent;
    while (successor !== null && node === successor.rightCh) {
        node = successor;
        successor = node.parent;
    }
    return successor;
};

/**
* @private
*/
buckets.BSTree.prototype.heightAux = function(node) {
    if (node === null) {
        return - 1;
    }
    return Math.max(this.heightAux(node.leftCh), this.heightAux(node.rightCh)) + 1;
};

/*
* @private
*/
buckets.BSTree.prototype.insertNode = function(node) {

    var parent = null;
    var position = this.root;
    var cmp = null;
    while (position !== null) {
        cmp = this.compare(node.element, position.element);
        if (cmp === 0) {
            return null;
        } else if (cmp < 0) {
            parent = position;
            position = position.leftCh;
        } else {
            parent = position;
            position = position.rightCh;
        }
    }
    node.parent = parent;
    if (parent === null) {
        // tree is empty
        this.root = node;
    } else if (this.compare(node.element, parent.element) < 0) {
        parent.leftCh = node;
    } else {
        parent.rightCh = node;
    }
    return node;
};

/**
* @private
*/
buckets.BSTree.prototype.createNode = function(element) {
    return {
        element: element,
        leftCh: null,
        rightCh: null,
        parent: null
    };
};
!function (definition) {
  if (typeof module == "object" && module.exports) module.exports = definition();
  else if (typeof define == "function") define(definition);
  else this.tz = definition();
} (function () {
/*
  function die () {
    console.log.apply(console, __slice.call(arguments, 0));
    return process.exit(1);
  }

  function say () { return console.log.apply(console, __slice.call(arguments, 0)) }
*/
  function actualize (entry, rule, year) {
    var actualized, date = rule.day[1];

    do {
      actualized = new Date(Date.UTC(year, rule.month, Math.abs(date++)));
    } while (rule.day[0] < 7 && actualized.getUTCDay() != rule.day[0])

    actualized = {
      clock: rule.clock,
      sort: actualized.getTime(),
      rule: rule,
      save: rule.save * 6e4,
      offset: entry.offset
    };

    actualized[actualized.clock] = actualized.sort + rule.time * 6e4;

    if (actualized.posix) {
      actualized.wallclock = actualized[actualized.clock] + (entry.offset + rule.saved);
    } else {
      actualized.posix = actualized[actualized.clock] - (entry.offset + rule.saved);
    }

    return actualized;
  }

  function find (request, clock, time) {
    var i, I, entry, found, zone = request[request.zone], actualized = [], abbrev, rules
      , j, year = new Date(time).getUTCFullYear(), off = 1;
    for (i = 1, I = zone.length; i < I; i++) if (zone[i][clock] <= time) break;
    entry = zone[i];
    if (entry.rules) {
      rules = request[entry.rules];
      for (j = year + 1; j >= year - off; --j)
        for (i = 0, I = rules.length; i < I; i++)
          if (rules[i].from <= j && j <= rules[i].to) actualized.push(actualize(entry, rules[i], j));
          else if (rules[i].to < j && off == 1) off = j - rules[i].to;
      actualized.sort(function (a, b) { return a.sort - b.sort });
      for (i = 0, I = actualized.length; i < I; i++) {
        if (time >= actualized[i][clock] && actualized[i][actualized[i].clock] > entry[actualized[i].clock]) found = actualized[i];
      }
    }
    if (found) {
      if (abbrev = /^(.*)\/(.*)$/.exec(entry.format)) {
        found.abbrev = abbrev[found.save ? 2 : 1];
      } else {
        found.abbrev = entry.format.replace(/%s/, found.rule.letter);
      }
    }
    return found || entry;
  }

  function convertToWallclock (request, posix) {
    if (request.zone == "UTC") return posix;
    request.entry = find(request, "posix", posix);
    return posix + request.entry.offset + request.entry.save;
  }

  function convertToPOSIX (request, wallclock) {
    if (request.zone == "UTC") return wallclock;

    var entry, diff;
    request.entry = entry = find(request, "wallclock", wallclock);
    diff = wallclock - entry.wallclock;

    return 0 < diff && diff < entry.save ? null : wallclock - entry.offset - entry.save;
  }

  function adjust (request, posix, match) {
    var increment = +(match[1] + 1) // conversion necessary for week day addition
      , offset = match[2] * increment
      , index = UNITS.indexOf(match[3].toLowerCase())
      , date
      ;
    if (index > 9) {
      posix += offset * TIME[index - 10];
    } else {
      date = new Date(convertToWallclock(request, posix));
      if (index < 7) {
        while (offset) {
          date.setUTCDate(date.getUTCDate() + increment);
          if (date.getUTCDay() == index) offset -= increment;
        }
      } else if (index == 7) {
        date.setUTCFullYear(date.getUTCFullYear() + offset);
      } else if (index == 8) {
        date.setUTCMonth(date.getUTCMonth() + offset);
      } else {
        date.setUTCDate(date.getUTCDate() + offset);
      }
      if ((posix = convertToPOSIX(request, date.getTime())) == null) {
        posix = convertToPOSIX(request, date.getTime() + 864e5 * increment) - 864e5 * increment;
      }
    }
    return posix;
  }

  function convert (vargs) {
    if (!vargs.length) return "0.0.23";

    var request = Object.create(this)
      , adjustments = []
      , i, I, $, argument, date
      ;

    for (i = 0; i < vargs.length; i++) { // leave the for loop alone, it works.
      argument = vargs[i];
      // https://twitter.com/bigeasy/status/215112186572439552
      if (Array.isArray(argument)) {
        if (!i && !isNaN(argument[1])) {
          date = argument;
        } else {
          argument.splice.apply(vargs, [ i--, 1 ].concat(argument));
        }
      } else if (isNaN(argument)) {
        $ = typeof argument;
        if ($ == "string") {
          if (~argument.indexOf("%")) {
            request.format = argument;
          } else if (!i && argument == "*") {
            date = argument;
          } else if (!i && ($ = /^(\d{4})-(\d{2})-(\d{2})(?:[T\s](\d{2}):(\d{2})(?::(\d{2})(?:\.(\d+))?)?(Z|(([+-])(\d{2}(:\d{2}){0,2})))?)?$/.exec(argument))) {
            date = [];
            date.push.apply(date, $.slice(1, 8));
            if ($[9]) {
              date.push($[10] + 1);
              date.push.apply(date, $[11].split(/:/));
            } else if ($[8]) {
              date.push(1);
            }
          } else if (/^\w{2,3}_\w{2}$/.test(argument)) {
            request.locale = argument;
          } else if ($ = UNIT_RE.exec(argument)) {
            adjustments.push($);
          } else {
            request.zone = argument;
          }
        } else if ($ == "function") {
          if ($ = argument.call(request)) return $;
        } else if (/^\w{2,3}_\w{2}$/.test(argument.name)) {
          request[argument.name] = argument;
        } else if (argument.zones) {
          for ($ in argument.zones) request[$] = argument.zones[$];
          for ($ in argument.rules) request[$] = argument.rules[$];
        }
      } else if (!i) {
        date = argument;
      }
    }

    if (!request[request.locale]) delete request.locale;
    if (!request[request.zone]) delete request.zone;

    if (date != null) {
      if (date == "*") {
        date = request.clock();
      } else if (Array.isArray(date)) {
        I = !date[7];
        for (i = 0; i < 11; i++) date[i] = +(date[i] || 0); // conversion necessary for decrement
        --date[1]; // Grr..
        date = Date.UTC.apply(Date.UTC, date.slice(0, 8)) +
          -date[7] * (date[8] * 36e5 + date[9] * 6e4 + date[10] * 1e3);
      } else {
        date = Math.floor(date);
      }
      if (!isNaN(date)) {
        if (I) date = convertToPOSIX(request, date);

        if (date == null) return date;

        for (i = 0, I = adjustments.length; i < I; i++) {
          date = adjust(request, date, adjustments[i]);
        }

        if (!request.format) return date;

        $ = new Date(convertToWallclock(request, date));
        return request.format.replace(/%([-0_^]?)(:{0,3})(\d*)(.)/g,
        function (value, flag, colons, padding, specifier) {
          var f, fill = "0", pad;
          if (f = request[specifier]) {
            value = String(f.call(request, $, date, flag, colons.length));
            if ((flag || f.style) == "_") fill = " ";
            pad = flag == "-" ? 0 : f.pad || 0;
            while (value.length < pad) value = fill + value;
            pad = flag == "-" ? 0 : padding || f.pad;
            while (value.length < pad) value = fill + value;
            if (specifier == "N" && pad < value.length) value = value.slice(0, pad);
            if (flag == "^") value = value.toUpperCase();
          }
          return value;
        });
      }
    }

    return function () { return request.convert(arguments) };
  }

  var context =
    { clock: function () { return +(new Date()) }
    , zone: "UTC"
    , entry: { abbrev: "UTC", offset: 0, save: 0 }
    , UTC: 1
    , z: function(date, posix, flag, delimiters) {
        var offset = this.entry.offset + this.entry.save
          , seconds = Math.abs(offset / 1000), parts = [], part = 3600, i, z;
        for (i = 0; i < 3; i++) {
          parts.push(("0" + Math.floor(seconds / part)).slice(-2));
          seconds %= part;
          part /= 60;
        }
        if (flag == "^" && !offset) return "Z";
        if (flag == "^") delimiters = 3;
        if (delimiters == 3) {
          z = parts.join(":");
          z = z.replace(/:00$/, "");
          if (flag != "^") z = z.replace(/:00$/, "");
        } else if (delimiters) {
          z = parts.slice(0, delimiters + 1).join(":");
          if (flag == "^") z = z.replace(/:00$/, "");
        } else {
          z = parts.slice(0, 2).join("");
        }
        z = (offset < 0 ? "-" : "+") + z;
        z = z.replace(/([-+])(0)/, { "_": " $1", "-": "$1" }[flag] || "$1$2");
        return z;
      }
    , "%": function(date) { return "%" }
    , n: function (date) { return "\n" }
    , t: function (date) { return "\t" }
    , U: function (date) { return weekOfYear(date, 0) }
    , W: function (date) { return weekOfYear(date, 1) }
    , V: function (date) { return isoWeek(date)[0] }
    , G: function (date) { return isoWeek(date)[1] }
    , g: function (date) { return isoWeek(date)[1] % 100 }
    , j: function (date) { return Math.floor((date.getTime() - Date.UTC(date.getUTCFullYear(), 0)) / 864e5) + 1 }
    , s: function (date) { return Math.floor(date.getTime() / 1000) }
    , C: function (date) { return Math.floor(date.getUTCFullYear() / 100) }
    , N: function (date) { return date.getTime() % 1000 * 1000000 }
    , m: function (date) { return date.getUTCMonth() + 1 }
    , Y: function (date) { return date.getUTCFullYear() }
    , y: function (date) { return date.getUTCFullYear() % 100 }
    , H: function (date) { return date.getUTCHours() }
    , M: function (date) { return date.getUTCMinutes() }
    , S: function (date) { return date.getUTCSeconds() }
    , e: function (date) { return date.getUTCDate() }
    , d: function (date) { return date.getUTCDate() }
    , u: function (date) { return date.getUTCDay() || 7 }
    , w: function (date) { return date.getUTCDay() }
    , l: function (date) { return date.getUTCHours() % 12 || 12 }
    , I: function (date) { return date.getUTCHours() % 12 || 12 }
    , k: function (date) { return date.getUTCHours() }
    , Z: function (date) { return this.entry.abbrev }
    , a: function (date) { return this[this.locale].day.abbrev[date.getUTCDay()] }
    , A: function (date) { return this[this.locale].day.full[date.getUTCDay()] }
    , h: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()] }
    , b: function (date) { return this[this.locale].month.abbrev[date.getUTCMonth()] }
    , B: function (date) { return this[this.locale].month.full[date.getUTCMonth()] }
    , P: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)].toLowerCase() }
    , p: function (date) { return this[this.locale].meridiem[Math.floor(date.getUTCHours() / 12)] }
    , R: function (date, posix) { return this.convert([ posix, "%H:%M" ]) }
    , T: function (date, posix) { return this.convert([ posix, "%H:%M:%S" ]) }
    , D: function (date, posix) { return this.convert([ posix, "%m/%d/%y" ]) }
    , F: function (date, posix) { return this.convert([ posix, "%Y-%m-%d" ]) }
    , x: function (date, posix) { return this.convert([ posix, this[this.locale].date ]) }
    , r: function (date, posix) { return this.convert([ posix, this[this.locale].time12 || '%I:%M:%S' ]) }
    , X: function (date, posix) { return this.convert([ posix, this[this.locale].time24 ]) }
    , c: function (date, posix) { return this.convert([ posix, this[this.locale].dateTime ]) }
    , convert: convert
    , locale: "en_US"
    , en_US: {
        date: "%m/%d/%Y",
        time24: "%I:%M:%S %p",
        time12: "%I:%M:%S %p",
        dateTime: "%a %d %b %Y %I:%M:%S %p %Z",
        meridiem: [ "AM", "PM" ],
        month: {
          abbrev: "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec".split("|"),
          full: "January|February|March|April|May|June|July|August|September|October|November|December".split("|")
        },
        day: {
          abbrev: "Sun|Mon|Tue|Wed|Thu|Fri|Sat".split("|"),
          full: "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday".split("|")
        }
      }
    };
  var UNITS = "Sunday|Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|year|month|day|hour|minute|second|millisecond"
    , UNIT_RE = new RegExp("^\\s*([+-])(\\d+)\\s+(" + UNITS + ")s?\\s*$", "i")
    , TIME = [ 36e5, 6e4, 1e3, 1 ]
    ;
  UNITS = UNITS.toLowerCase().split("|");

  "delmHMSUWVgCIky".replace(/./g, function (e) { context[e].pad = 2 });

  context.N.pad = 9;
  context.j.pad = 3;

  context.k.style = "_";
  context.l.style = "_";
  context.e.style = "_";

  function weekOfYear (date, startOfWeek) {
    var diff, nyd, weekStart;
    nyd = new Date(Date.UTC(date.getUTCFullYear(), 0));
    diff = Math.floor((date.getTime() - nyd.getTime()) / 864e5);
    if (nyd.getUTCDay() == startOfWeek) {
      weekStart = 0;
    } else {
      weekStart = 7 - nyd.getUTCDay() + startOfWeek;
      if (weekStart == 8) {
        weekStart = 1;
      }
    }
    return diff >= weekStart ? Math.floor((diff - weekStart) / 7) + 1 : 0;
  }

  function isoWeek (date) {
    var nyd, nyy, week;
    nyy = date.getUTCFullYear();
    nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
    week = weekOfYear(date, 1) + (nyd > 1 && nyd <= 4 ? 1 : 0);
    if (!week) {
      nyy = date.getUTCFullYear() - 1;
      nyd = new Date(Date.UTC(nyy, 0)).getUTCDay();
      week = nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29) ? 53 : 52;
      return [week, date.getUTCFullYear() - 1];
    } else if (week == 53 && !(nyd == 4 || (nyd == 3 && new Date(nyy, 1, 29).getDate() == 29))) {
      return [1, date.getUTCFullYear() + 1];
    } else {
      return [week, date.getUTCFullYear()];
    }
  }

  return function () { return context.convert(arguments) };
});

/*! sprintf.js | Copyright (c) 2007-2013 Alexandru Marasteanu <hello at alexei dot ro> | 3 clause BSD license */(function(e){function r(e){return Object.prototype.toString.call(e).slice(8,-1).toLowerCase()}function i(e,t){for(var n=[];t>0;n[--t]=e);return n.join("")}var t=function(){return t.cache.hasOwnProperty(arguments[0])||(t.cache[arguments[0]]=t.parse(arguments[0])),t.format.call(null,t.cache[arguments[0]],arguments)};t.format=function(e,n){var s=1,o=e.length,u="",a,f=[],l,c,h,p,d,v;for(l=0;l<o;l++){u=r(e[l]);if(u==="string")f.push(e[l]);else if(u==="array"){h=e[l];if(h[2]){a=n[s];for(c=0;c<h[2].length;c++){if(!a.hasOwnProperty(h[2][c]))throw t('[sprintf] property "%s" does not exist',h[2][c]);a=a[h[2][c]]}}else h[1]?a=n[h[1]]:a=n[s++];if(/[^s]/.test(h[8])&&r(a)!="number")throw t("[sprintf] expecting number but found %s",r(a));switch(h[8]){case"b":a=a.toString(2);break;case"c":a=String.fromCharCode(a);break;case"d":a=parseInt(a,10);break;case"e":a=h[7]?a.toExponential(h[7]):a.toExponential();break;case"f":a=h[7]?parseFloat(a).toFixed(h[7]):parseFloat(a);break;case"o":a=a.toString(8);break;case"s":a=(a=String(a))&&h[7]?a.substring(0,h[7]):a;break;case"u":a>>>=0;break;case"x":a=a.toString(16);break;case"X":a=a.toString(16).toUpperCase()}a=/[def]/.test(h[8])&&h[3]&&a>=0?"+"+a:a,d=h[4]?h[4]=="0"?"0":h[4].charAt(1):" ",v=h[6]-String(a).length,p=h[6]?i(d,v):"",f.push(h[5]?a+p:p+a)}}return f.join("")},t.cache={},t.parse=function(e){var t=e,n=[],r=[],i=0;while(t){if((n=/^[^\x25]+/.exec(t))!==null)r.push(n[0]);else if((n=/^\x25{2}/.exec(t))!==null)r.push("%");else{if((n=/^\x25(?:([1-9]\d*)\$|\(([^\)]+)\))?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(t))===null)throw"[sprintf] huh?";if(n[2]){i|=1;var s=[],o=n[2],u=[];if((u=/^([a-z_][a-z_\d]*)/i.exec(o))===null)throw"[sprintf] huh?";s.push(u[1]);while((o=o.substring(u[0].length))!=="")if((u=/^\.([a-z_][a-z_\d]*)/i.exec(o))!==null)s.push(u[1]);else{if((u=/^\[(\d+)\]/.exec(o))===null)throw"[sprintf] huh?";s.push(u[1])}n[2]=s}else i|=2;if(i===3)throw"[sprintf] mixing positional and named placeholders is not (yet) supported";r.push(n)}t=t.substring(n[0].length)}return r};var n=function(e,n,r){return r=n.slice(0),r.splice(0,0,e),t.apply(null,r)};e.sprintf=t,e.vsprintf=n})(typeof exports!="undefined"?exports:window);
/*
 * memoize.js
 * by @philogb and @addyosmani
 * with further optimizations by @mathias
 * and @DmitryBaranovsk
 * perf tests: http://bit.ly/q3zpG3
 * Released under an MIT license.
 */
function memoize( fn ) {
    return function () {
        var args = Array.prototype.slice.call(arguments),
        hash = "",
        i = args.length;
        currentArg = null;
        while (i--) {
            currentArg = args[i];
            hash += (currentArg === Object(currentArg)) ?
                JSON.stringify(currentArg) : currentArg;
            fn.memoize || (fn.memoize = {});
        }
        return (hash in fn.memoize) ? fn.memoize[hash] :
            fn.memoize[hash] = fn.apply(this, args);
    };
}

/*
function memoize(f){
    var cache = {};
    cache['hits'] = 0
    cache['misses'] = 0
    return function(){

        var key = JSON.stringify(Array.prototype.slice.call(arguments));

        if(key in cache){
            cache['hits'] += 1
            console.log('From cache...', cache['hits'], cache['misses']);
            return cache[key]
        }else{
            cache['misses'] +=1
            console.log('Computing..', cache['hits'], cache['misses']);
            return cache[key] = f.apply(this,arguments);
        }

    }

}
*/

//customizations to libraries
(function () {
  "use strict";
_.uniqueId = function (prefix) {
    //from ipython project
    // http://www.ietf.org/rfc/rfc4122.txt
    var s = [];
    var hexDigits = "0123456789ABCDEF";
    for (var i = 0; i < 32; i++) {
        s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
    }
    s[12] = "4";  // bits 12-15 of the time_hi_and_version field to 0010
    s[16] = hexDigits.substr((s[16] & 0x3) | 0x8, 1);  // bits 6-7 of the clock_seq_hi_and_reserved to 01

    var uuid = s.join("");
    if (prefix){
        return prefix + "-" + uuid;
    }else{
        return uuid;
    }
};

_.isNullOrUndefined = function(x){
    return _.isNull(x) || _.isUndefined(x);
};

_.setdefault = function(obj, key, value){
    if (_.has(obj, key)){
        return obj[key]}
    else{
        obj[key] = value
        return value
    }
};
}).call(this);


(function(/*! Stitch !*/) {
  if (!this.rrequire) {
    var modules = {}, cache = {}, require = function(name, root) {
      var path = expand(root, name), indexPath = expand(path, './index'), module, fn;
      module   = cache[path] || cache[indexPath]
      if (module) {
        return module.exports;
      } else if (fn = modules[path] || modules[path = indexPath]) {
        module = {id: path, exports: {}};
        try {
          cache[path] = module;
          fn(module.exports, function(name) {
            return require(name, dirname(path));
          }, module);
          return module.exports;
        } catch (err) {
          delete cache[path];
          throw err;
        }
      } else {
        throw 'module \'' + name + '\' not found';
      }
    }, expand = function(root, name) {
      var results = [], parts, part;
      if (/^\.\.?(\/|$)/.test(name)) {
        parts = [root, name].join('/').split('/');
      } else {
        parts = name.split('/');
      }
      for (var i = 0, length = parts.length; i < length; i++) {
        part = parts[i];
        if (part == '..') {
          results.pop();
        } else if (part != '.' && part != '') {
          results.push(part);
        }
      }
      return results.join('/');
    }, dirname = function(path) {
      return path.split('/').slice(0, -1).join('/');
    };
    this.rrequire = function(name) {
      return require(name, '');
    }
    this.rrequire.define = function(bundle) {
      for (var key in bundle)
        modules[key] = bundle[key];
    };
    this.rrequire.modules = modules;
    this.rrequire.cache   = cache;
  }
  return this.rrequire.define;
}).call(this)({
  "embed_core": function(exports, require, module) {(function() {
  var addDirectPlot, addDirectPlotWrap, addPlot, addPlotWrap, base, find_injections, foundEls, injectCss, parse_el, search_and_plot, serverLoad, unsatisfied_els, utility,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  base = require("./base");

  utility = require("./serverutils").utility;

  addPlotWrap = function(settings, dd) {
    return addPlot(settings.bokeh_modelid, settings.bokeh_modeltype, settings.element, dd);
  };

  addPlot = function(modelid, modeltype, element, data) {
    var data_plot_id, model, view;
    data_plot_id = _.keys(data)[0];
    if (!data_plot_id === modelid) {
      return;
    }
    console.log("addPlot");
    console.log(modelid, modeltype, element);
    base.load_models(data[data_plot_id]);
    model = base.Collections(modeltype).get(modelid);
    view = new model.default_view({
      model: model
    });
    view.render();
    return _.delay(function() {
      return $(element).append(view.$el);
    });
  };

  addDirectPlotWrap = function(settings) {
    console.log("addDirectPlotWrap");
    return addDirectPlot(settings.bokeh_docid, settings.bokeh_ws_conn_string, settings.bokeh_docapikey, settings.bokeh_root_url, settings.bokeh_modelid, settings.bokeh_modeltype, settings.element);
  };

  serverLoad = function(docid, ws_conn_string, docapikey, root_url) {
    var BokehConfig, headers;
    console.log("serverLoad");
    headers = {
      'BOKEH-API-KEY': docapikey
    };
    $.ajaxSetup({
      'headers': headers
    });
    BokehConfig = base.Config;
    BokehConfig.prefix = root_url;
    BokehConfig.ws_conn_string = ws_conn_string;
    return utility.load_doc_once(docid);
  };

  addDirectPlot = function(docid, ws_conn_string, docapikey, root_url, modelid, modeltype, element) {
    return serverLoad(docid, ws_conn_string, docapikey, root_url).done(function() {
      var model, plot_collection, view;
      console.log("addPlot");
      console.log(modelid, modeltype, element);
      plot_collection = base.Collections(modeltype);
      model = plot_collection.get(modelid);
      view = new model.default_view({
        model: model
      });
      return _.delay(function() {
        return $(element).append(view.$el);
      });
    });
  };

  injectCss = function(host) {
    var css_urls, load_css, static_base;
    static_base = "" + host + "vendor/bokehjs/";
    css_urls = ["" + static_base + "css/bokeh.css", "" + static_base + "css/continuum.css", "" + static_base + "vendor/bootstrap/css/bootstrap.css", "" + static_base + "vendor/jquery/css/themes/base/jquery-ui.min.css"];
    load_css = function(url) {
      var link;
      link = document.createElement('link');
      link.href = url;
      link.rel = "stylesheet";
      link.type = "text/css";
      return document.body.appendChild(link);
    };
    return _.map(css_urls, load_css);
  };

  foundEls = [];

  parse_el = function(el) {
    "this takes a bokeh embed script element and returns the relvant\nattributes through to a dictionary, ";

    var attr, attrs, bokehCount, bokehRe, info, _i, _len;
    attrs = el.attributes;
    bokehRe = /bokeh.*/;
    info = {};
    bokehCount = 0;
    for (_i = 0, _len = attrs.length; _i < _len; _i++) {
      attr = attrs[_i];
      if (attr.name.match(bokehRe)) {
        info[attr.name] = attr.value;
        bokehCount++;
      }
    }
    if (bokehCount > 0) {
      return info;
    } else {
      return false;
    }
  };

  unsatisfied_els = {};

  find_injections = function() {
    var container, d, el, els, info, is_new_el, matches, new_settings, re, _i, _len;
    els = document.getElementsByTagName('script');
    re = /.*embed.js.*/;
    new_settings = [];
    for (_i = 0, _len = els.length; _i < _len; _i++) {
      el = els[_i];
      is_new_el = __indexOf.call(foundEls, el) < 0;
      matches = el.src.match(re);
      if (is_new_el && matches) {
        foundEls.push(el);
        info = parse_el(el);
        d = document.createElement('div');
        container = document.createElement('div');
        el.parentNode.insertBefore(container, el);
        info['element'] = container;
        new_settings.push(info);
      }
    }
    return new_settings;
  };

  search_and_plot = function(dd) {
    var new_plot_dicts, plot_from_dict;
    plot_from_dict = function(info_dict, key) {
      var dd_id;
      if (info_dict.bokeh_plottype === 'embeddata') {
        dd_id = _.keys(dd)[0];
        if (key === dd_id) {
          addPlotWrap(info_dict, dd);
          return delete unsatisfied_els[key];
        }
      } else {
        addDirectPlotWrap(info_dict);
        return delete unsatisfied_els[key];
      }
    };
    new_plot_dicts = find_injections();
    _.each(new_plot_dicts, function(plotdict) {
      return unsatisfied_els[plotdict['bokeh_modelid']] = plotdict;
    });
    return _.map(unsatisfied_els, plot_from_dict);
  };

  exports.search_and_plot = search_and_plot;

  exports.injectCss = injectCss;

  console.log('embed_core');

}).call(this);
}, "serverrun": function(exports, require, module) {(function() {
  var Config, Promises, base, usercontext, utility, utils;

  utils = require("./serverutils");

  base = require("./base");

  Config = base.Config;

  utility = utils.utility;

  Promises = utils.Promises;

  Config.ws_conn_string = "ws://" + window.location.host + "/bokeh/sub";

  usercontext = require("usercontext/usercontext");

  $(function() {
    var load, userdocs, wswrapper;
    wswrapper = utility.make_websocket();
    userdocs = new usercontext.UserDocs();
    userdocs.subscribe(wswrapper, 'defaultuser');
    window.userdocs = userdocs;
    load = userdocs.fetch();
    return load.done(function() {
      var userdocsview;
      userdocsview = new usercontext.UserDocsView({
        collection: userdocs
      });
      return $('#PlotPane').append(userdocsview.el);
    });
  });

}).call(this);
}, "serverutils": function(exports, require, module) {(function() {
  var Collections, Config, Deferreds, HasProperties, Promises, WebSocketWrapper, base, load_models, submodels, utility;

  Deferreds = {};

  Promises = {};

  Deferreds._doc_loaded = $.Deferred();

  Deferreds._doc_requested = $.Deferred();

  Promises.doc_loaded = Deferreds._doc_loaded.promise();

  Promises.doc_requested = Deferreds._doc_requested.promise();

  Promises.doc_promises = {};

  base = require("./base");

  Collections = base.Collections;

  HasProperties = base.HasProperties;

  load_models = base.load_models;

  submodels = base.submodels;

  WebSocketWrapper = base.WebSocketWrapper;

  Config = base.Config;

  exports.wswrapper = null;

  exports.plotcontext = null;

  exports.plotcontextview = null;

  exports.Promises = Promises;

  HasProperties.prototype.sync = Backbone.sync;

  utility = {
    load_user: function() {
      var response;
      response = $.get('/bokeh/userinfo/', {});
      return response;
    },
    load_doc_once: function(docid) {
      var doc_prom;
      if (_.has(Promises.doc_promises, docid)) {
        console.log("already found " + docid + " in promises");
        return Promises.doc_promises[docid];
      } else {
        console.log("" + docid + " not in promises, loading it");
        doc_prom = utility.load_doc(docid);
        Promises.doc_promises[docid] = doc_prom;
        return doc_prom;
      }
    },
    load_doc_by_title: function(title) {
      var response;
      response = $.get(Config.prefix + "/bokeh/doc", {
        title: title
      }).done(function(data) {
        var all_models, apikey, docid;
        all_models = data['all_models'];
        load_models(all_models);
        apikey = data['apikey'];
        docid = data['docid'];
        return submodels(exports.wswrapper, "bokehplot:" + docid, apikey);
      });
      return response;
    },
    load_doc_static: function(docid, data) {
      " loads data without making a websocket connection ";

      var promise;
      load_data(data['all_models']);
      promise = jQuery.Deferred();
      promise.resolve();
      return promise;
    },
    load_doc: function(docid) {
      var response, wswrapper;
      wswrapper = utility.make_websocket();
      response = $.get(Config.prefix + ("/bokeh/bokehinfo/" + docid + "/"), {}).done(function(data) {
        var all_models, apikey;
        all_models = data['all_models'];
        load_models(all_models);
        apikey = data['apikey'];
        return submodels(exports.wswrapper, "bokehplot:" + docid, apikey);
      });
      return response;
    },
    make_websocket: function() {
      var wswrapper;
      wswrapper = new WebSocketWrapper(Config.ws_conn_string);
      exports.wswrapper = wswrapper;
      return wswrapper;
    },
    render_plots: function(plot_context_ref, viewclass, viewoptions) {
      var options, plotcontext, plotcontextview;
      if (viewclass == null) {
        viewclass = null;
      }
      if (viewoptions == null) {
        viewoptions = {};
      }
      plotcontext = Collections(plot_context_ref.type).get(plot_context_ref.id);
      if (!viewclass) {
        viewclass = plotcontext.default_view;
      }
      options = _.extend(viewoptions, {
        model: plotcontext
      });
      plotcontextview = new viewclass(options);
      plotcontext = plotcontext;
      plotcontextview = plotcontextview;
      plotcontextview.render();
      exports.plotcontext = plotcontext;
      return exports.plotcontextview = plotcontextview;
    },
    bokeh_connection: function(host, docid, protocol) {
      if (_.isUndefined(protocol)) {
        protocol = "https";
      }
      if (Promises.doc_requested.state() === "pending") {
        Deferreds._doc_requested.resolve();
        return $.get("" + protocol + "://" + host + "/bokeh/publicbokehinfo/" + docid, {}, function(data) {
          console.log('instatiate_doc_single, docid', docid);
          data = JSON.parse(data);
          load_models(data['all_models']);
          return Deferreds._doc_loaded.resolve(data);
        });
      }
    },
    instantiate_doc_single_plot: function(docid, view_model_id, target_el, host) {
      var container;
      if (target_el == null) {
        target_el = "#PlotPane";
      }
      if (host == null) {
        host = "www.wakari.io";
      }
      container = require("./container");
      utility.bokeh_connection(host, docid, "https");
      return Deferreds._doc_loaded.done(function(data) {
        utility.render_plots(data.plot_context_ref, container.PlotContextView, {
          target_model_id: view_model_id
        });
        return $(target_el).empty().append(exports.plotcontextview.el);
      });
    }
  };

  exports.utility = utility;

}).call(this);
}, "usercontext/documentationtemplate": function(exports, require, module) {module.exports = function(__obj) {
  if (!__obj) __obj = {};
  var __out = [], __capture = function(callback) {
    var out = __out, result;
    __out = [];
    callback.call(this);
    result = __out.join('');
    __out = out;
    return __safe(result);
  }, __sanitize = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else if (typeof value !== 'undefined' && value != null) {
      return __escape(value);
    } else {
      return '';
    }
  }, __safe, __objSafe = __obj.safe, __escape = __obj.escape;
  __safe = __obj.safe = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else {
      if (!(typeof value !== 'undefined' && value != null)) value = '';
      var result = new String(value);
      result.ecoSafe = true;
      return result;
    }
  };
  if (!__escape) {
    __escape = __obj.escape = function(value) {
      return ('' + value)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;');
    };
  }
  (function() {
    (function() {
    
      __out.push('<p>\n  <b>\n    You have no Plots.  Follow the intsructions\n    below to create some\n  </b>\n</p>\n');
    
    }).call(this);
    
  }).call(__obj);
  __obj.safe = __objSafe, __obj.escape = __escape;
  return __out.join('');
}}, "usercontext/usercontext": function(exports, require, module) {(function() {
  var ContinuumView, Doc, DocView, HasParent, HasProperties, UserDocs, UserDocsView, base, build_views, documentationtemplate, load_models, userdocstemplate, utility,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require("../base");

  ContinuumView = require("../common/continuum_view").ContinuumView;

  HasParent = base.HasParent;

  HasProperties = base.HasProperties;

  load_models = base.load_models;

  userdocstemplate = require("./userdocstemplate");

  documentationtemplate = require("./documentationtemplate");

  utility = require("../serverutils").utility;

  build_views = base.build_views;

  DocView = (function(_super) {

    __extends(DocView, _super);

    function DocView() {
      return DocView.__super__.constructor.apply(this, arguments);
    }

    DocView.prototype.template = require("./wrappertemplate");

    DocView.prototype.attributes = {
      "class": 'accordion-group'
    };

    DocView.prototype.events = {
      "click .bokehdoclabel": "loaddoc",
      "click .bokehdelete": "deldoc"
    };

    DocView.prototype.deldoc = function(e) {
      console.log('foo');
      e.preventDefault();
      this.model.destroy();
      return false;
    };

    DocView.prototype.loaddoc = function() {
      return this.model.load();
    };

    DocView.prototype.initialize = function(options) {
      DocView.__super__.initialize.call(this, options);
      return this.render_init();
    };

    DocView.prototype.delegateEvents = function(events) {
      DocView.__super__.delegateEvents.call(this, events);
      return this.listenTo(this.model, 'loaded', this.render);
    };

    DocView.prototype.render_init = function() {
      var html;
      html = this.template({
        model: this.model,
        bodyid: _.uniqueId()
      });
      return this.$el.html(html);
    };

    DocView.prototype.render = function() {
      var plot_context;
      plot_context = this.model.get_obj('plot_context');
      this.plot_context_view = new plot_context.default_view({
        model: plot_context
      });
      this.$el.find('.plots').append(this.plot_context_view.el);
      return true;
    };

    return DocView;

  })(ContinuumView);

  UserDocsView = (function(_super) {

    __extends(UserDocsView, _super);

    function UserDocsView() {
      return UserDocsView.__super__.constructor.apply(this, arguments);
    }

    UserDocsView.prototype.initialize = function(options) {
      this.docs = options.docs;
      this.collection = options.collection;
      this.views = {};
      UserDocsView.__super__.initialize.call(this, options);
      return this.render();
    };

    UserDocsView.prototype.attributes = {
      "class": 'usercontext'
    };

    UserDocsView.prototype.events = {
      'click .bokehrefresh': function() {
        return this.collection.fetch({
          update: true
        });
      }
    };

    UserDocsView.prototype.delegateEvents = function(events) {
      var _this = this;
      UserDocsView.__super__.delegateEvents.call(this, events);
      this.listenTo(this.collection, 'add', this.render);
      this.listenTo(this.collection, 'remove', this.render);
      this.listenTo(this.collection, 'add', function(model, collection, options) {
        return _this.listenTo(model, 'loaded', function() {
          return _this.listenTo(model.get_obj('plot_context'), 'change', function() {
            return _this.trigger('show');
          });
        });
      });
      return this.listenTo(this.collection, 'remove', function(model, collection, options) {
        return _this.stopListening(model);
      });
    };

    UserDocsView.prototype.render_docs = function() {
      this.$el.html(documentationtemplate());
      return this.$el.append(this.docs);
    };

    UserDocsView.prototype.render = function() {
      var html, model, models, _i, _len;
      if (this.collection.models.length === 0 && this.docs) {
        return this.render_docs();
      }
      html = userdocstemplate();
      _.map(_.values(this.views), function(view) {
        return view.$el.detach();
      });
      models = this.collection.models.slice().reverse();
      build_views(this.views, models, {});
      this.$el.html(html);
      for (_i = 0, _len = models.length; _i < _len; _i++) {
        model = models[_i];
        this.$el.find(".accordion").append(this.views[model.id].el);
      }
      return this;
    };

    return UserDocsView;

  })(ContinuumView);

  Doc = (function(_super) {

    __extends(Doc, _super);

    function Doc() {
      return Doc.__super__.constructor.apply(this, arguments);
    }

    Doc.prototype.default_view = DocView;

    Doc.prototype.idAttribute = 'docid';

    Doc.prototype.defaults = {
      docid: null,
      title: null,
      plot_context: null,
      apikey: null
    };

    Doc.prototype.sync = function() {};

    Doc.prototype.destroy = function(options) {
      Doc.__super__.destroy.call(this, options);
      return $.ajax({
        url: "/bokeh/doc/" + (this.get('docid')) + "/",
        type: 'delete'
      });
    };

    Doc.prototype.load = function(use_title) {
      var docid, resp, title,
        _this = this;
      if (this.loaded) {
        return;
      }
      if (use_title) {
        title = this.get('title');
        resp = utility.load_doc_by_title(title);
      } else {
        docid = this.get('docid');
        resp = utility.load_doc(docid);
      }
      return resp.done(function(data) {
        _this.set('docid', data.docid);
        _this.set('apikey', data['apikey']);
        _this.set('plot_context', data['plot_context_ref']);
        _this.trigger('loaded');
        return _this.loaded = true;
      });
    };

    return Doc;

  })(HasParent);

  UserDocs = (function(_super) {

    __extends(UserDocs, _super);

    function UserDocs() {
      return UserDocs.__super__.constructor.apply(this, arguments);
    }

    UserDocs.prototype.model = Doc;

    UserDocs.prototype.subscribe = function(wswrapper, username) {
      wswrapper.subscribe("bokehuser:" + username, null);
      return this.listenTo(wswrapper, "msg:bokehuser:" + username, function(msg) {
        msg = JSON.parse(msg);
        if (msg['msgtype'] === 'docchange') {
          return this.fetch({
            update: true
          });
        }
      });
    };

    UserDocs.prototype.fetch = function(options) {
      var resp, response,
        _this = this;
      if (_.isUndefined(options)) {
        options = {};
      }
      resp = response = $.get('/bokeh/userinfo/', {});
      resp.done(function(data) {
        var docs;
        docs = data['docs'];
        if (options.update) {
          return _this.update(docs, options);
        } else {
          return _this.reset(docs, options);
        }
      });
      return resp;
    };

    return UserDocs;

  })(Backbone.Collection);

  exports.UserDocs = UserDocs;

  exports.UserDocsView = UserDocsView;

  exports.Doc = Doc;

  exports.DocView = DocView;

}).call(this);
}, "usercontext/userdocstemplate": function(exports, require, module) {module.exports = function(__obj) {
  if (!__obj) __obj = {};
  var __out = [], __capture = function(callback) {
    var out = __out, result;
    __out = [];
    callback.call(this);
    result = __out.join('');
    __out = out;
    return __safe(result);
  }, __sanitize = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else if (typeof value !== 'undefined' && value != null) {
      return __escape(value);
    } else {
      return '';
    }
  }, __safe, __objSafe = __obj.safe, __escape = __obj.escape;
  __safe = __obj.safe = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else {
      if (!(typeof value !== 'undefined' && value != null)) value = '';
      var result = new String(value);
      result.ecoSafe = true;
      return result;
    }
  };
  if (!__escape) {
    __escape = __obj.escape = function(value) {
      return ('' + value)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;');
    };
  }
  (function() {
    (function() {
    
      __out.push('<div class="accordion">\n</div>\n');
    
    }).call(this);
    
  }).call(__obj);
  __obj.safe = __objSafe, __obj.escape = __escape;
  return __out.join('');
}}, "usercontext/wrappertemplate": function(exports, require, module) {module.exports = function(__obj) {
  if (!__obj) __obj = {};
  var __out = [], __capture = function(callback) {
    var out = __out, result;
    __out = [];
    callback.call(this);
    result = __out.join('');
    __out = out;
    return __safe(result);
  }, __sanitize = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else if (typeof value !== 'undefined' && value != null) {
      return __escape(value);
    } else {
      return '';
    }
  }, __safe, __objSafe = __obj.safe, __escape = __obj.escape;
  __safe = __obj.safe = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else {
      if (!(typeof value !== 'undefined' && value != null)) value = '';
      var result = new String(value);
      result.ecoSafe = true;
      return result;
    }
  };
  if (!__escape) {
    __escape = __obj.escape = function(value) {
      return ('' + value)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;');
    };
  }
  (function() {
    (function() {
    
      __out.push('<div class="accordion-heading bokehdocheading">\n  <a class="accordion-toggle bokehdoclabel" data-toggle="collapse" \n     href="#');
    
      __out.push(__sanitize(this.bodyid));
    
      __out.push('">\n    Document: ');
    
      __out.push(__sanitize(this.model.get('title')));
    
      __out.push('\n    <i class="bokehdelete icon-trash"></i>\n  </a>\n</div>\n<div id="');
    
      __out.push(__sanitize(this.bodyid));
    
      __out.push('" class="accordion-body collapse">\n  <div class="accordion-inner plots">\n  </div>\n</div>\n\n\n');
    
    }).call(this);
    
  }).call(__obj);
  __obj.safe = __objSafe, __obj.escape = __escape;
  return __out.join('');
}}, "base": function(exports, require, module) {(function() {
  var Collections, Config, HasParent, HasProperties, WebSocketWrapper, build_views, load_models, locations, mod_cache, safebind, submodels,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  Config = {
    prefix: ''
  };

  safebind = function(binder, target, event, callback) {
    var _this = this;
    if (!_.has(binder, 'eventers')) {
      binder['eventers'] = {};
    }
    try {
      binder['eventers'][target.id] = target;
    } catch (error) {

    }
    if (target != null) {
      target.on(event, callback, binder);
      target.on('destroy remove', function() {
        return delete binder['eventers'][target];
      }, binder);
    } else {
      debugger;
      console.log("error with binder", binder, event);
    }
    return null;
  };

  load_models = function(modelspecs) {
    var attrs, coll, coll_attrs, model, newspecs, oldspecs, _i, _j, _k, _l, _len, _len1, _len2, _len3, _len4, _m;
    newspecs = [];
    oldspecs = [];
    for (_i = 0, _len = modelspecs.length; _i < _len; _i++) {
      model = modelspecs[_i];
      coll = Collections(model['type']);
      attrs = model['attributes'];
      if (coll && coll.get(attrs['id'])) {
        oldspecs.push([coll, attrs]);
      } else {
        newspecs.push([coll, attrs]);
      }
    }
    for (_j = 0, _len1 = newspecs.length; _j < _len1; _j++) {
      coll_attrs = newspecs[_j];
      coll = coll_attrs[0], attrs = coll_attrs[1];
      if (coll) {
        coll.add(attrs, {
          'silent': true
        });
      }
    }
    for (_k = 0, _len2 = newspecs.length; _k < _len2; _k++) {
      coll_attrs = newspecs[_k];
      coll = coll_attrs[0], attrs = coll_attrs[1];
      if (coll) {
        coll.get(attrs['id']).dinitialize(attrs);
      }
    }
    for (_l = 0, _len3 = newspecs.length; _l < _len3; _l++) {
      coll_attrs = newspecs[_l];
      coll = coll_attrs[0], attrs = coll_attrs[1];
      if (coll) {
        model = coll.get(attrs.id);
        model.trigger('add', model, coll, {});
      }
    }
    for (_m = 0, _len4 = oldspecs.length; _m < _len4; _m++) {
      coll_attrs = oldspecs[_m];
      coll = coll_attrs[0], attrs = coll_attrs[1];
      if (coll) {
        coll.get(attrs['id']).set(attrs);
      }
    }
    return null;
  };

  WebSocketWrapper = (function() {

    _.extend(WebSocketWrapper.prototype, Backbone.Events);

    function WebSocketWrapper(ws_conn_string) {
      this.onmessage = __bind(this.onmessage, this);

      var _this = this;
      this.auth = {};
      this.ws_conn_string = ws_conn_string;
      this._connected = $.Deferred();
      this.connected = this._connected.promise();
      if (window.MozWebSocket) {
        this.s = new MozWebSocket(ws_conn_string);
      } else {
        this.s = new WebSocket(ws_conn_string);
      }
      this.s.onopen = function() {
        return _this._connected.resolve();
      };
      this.s.onmessage = this.onmessage;
    }

    WebSocketWrapper.prototype.onmessage = function(msg) {
      var data, index, topic;
      data = msg.data;
      index = data.indexOf(":");
      index = data.indexOf(":", index + 1);
      topic = data.substring(0, index);
      data = data.substring(index + 1);
      this.trigger("msg:" + topic, data);
      return null;
    };

    WebSocketWrapper.prototype.send = function(msg) {
      var _this = this;
      return $.when(this.connected).done(function() {
        return _this.s.send(msg);
      });
    };

    WebSocketWrapper.prototype.subscribe = function(topic, auth) {
      var msg;
      this.auth[topic] = auth;
      msg = JSON.stringify({
        msgtype: 'subscribe',
        topic: topic,
        auth: auth
      });
      return this.send(msg);
    };

    return WebSocketWrapper;

  })();

  submodels = function(wswrapper, topic, apikey) {
    wswrapper.subscribe(topic, apikey);
    return wswrapper.on("msg:" + topic, function(msg) {
      var clientid, model, msgobj, ref, _i, _len, _ref;
      msgobj = JSON.parse(msg);
      if (msgobj['msgtype'] === 'modelpush') {
        load_models(msgobj['modelspecs']);
      } else if (msgobj['msgtype'] === 'modeldel') {
        _ref = msgobj['modelspecs'];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          ref = _ref[_i];
          model = resolve_ref(ref['type'], ref['id']);
          if (model) {
            model.destroy({
              'local': true
            });
          }
        }
      } else if (msgobj['msgtype'] === 'status' && msgobj['status'][0] === 'subscribesuccess') {
        clientid = msgobj['status'][2];
        Config.clientid = clientid;
        $.ajaxSetup({
          'headers': {
            'Continuum-Clientid': clientid
          }
        });
      } else {
        console.log(msgobj);
      }
      return null;
    });
  };

  HasProperties = (function(_super) {

    __extends(HasProperties, _super);

    function HasProperties() {
      this.rpc = __bind(this.rpc, this);

      this.get_obj = __bind(this.get_obj, this);

      this.resolve_ref = __bind(this.resolve_ref, this);

      this.convert_to_ref = __bind(this.convert_to_ref, this);
      return HasProperties.__super__.constructor.apply(this, arguments);
    }

    HasProperties.prototype.destroy = function(options) {
      var target, val, _ref, _results;
      HasProperties.__super__.destroy.call(this, options);
      if (_.has(this, 'eventers')) {
        _ref = this.eventers;
        _results = [];
        for (target in _ref) {
          if (!__hasProp.call(_ref, target)) continue;
          val = _ref[target];
          _results.push(val.off(null, null, this));
        }
        return _results;
      }
    };

    HasProperties.prototype.isNew = function() {
      return false;
    };

    HasProperties.prototype.initialize = function(attrs, options) {
      var _this = this;
      if (!attrs) {
        attrs = {};
      }
      if (!options) {
        options = {};
      }
      HasProperties.__super__.initialize.call(this, attrs, options);
      this.properties = {};
      this.property_cache = {};
      if (!_.has(attrs, this.idAttribute)) {
        this.id = _.uniqueId(this.type);
        this.attributes[this.idAttribute] = this.id;
      }
      return _.defer(function() {
        if (!_this.inited) {
          return _this.dinitialize(attrs, options);
        }
      });
    };

    HasProperties.prototype.dinitialize = function(attrs, options) {
      return this.inited = true;
    };

    HasProperties.prototype.set_obj = function(key, value, options) {
      var attrs, val;
      if (_.isObject(key) || key === null) {
        attrs = key;
        options = value;
      } else {
        attrs = {};
        attrs[key] = value;
      }
      for (key in attrs) {
        if (!__hasProp.call(attrs, key)) continue;
        val = attrs[key];
        attrs[key] = this.convert_to_ref(val);
      }
      return this.set(attrs, options);
    };

    HasProperties.prototype.set = function(key, value, options) {
      var attrs, toremove, val, _i, _len;
      if (_.isObject(key) || key === null) {
        attrs = key;
        options = value;
      } else {
        attrs = {};
        attrs[key] = value;
      }
      toremove = [];
      for (key in attrs) {
        if (!__hasProp.call(attrs, key)) continue;
        val = attrs[key];
        if (_.has(this, 'properties') && _.has(this.properties, key) && this.properties[key]['setter']) {
          this.properties[key]['setter'].call(this, val);
          toremove.push(key);
        }
      }
      for (_i = 0, _len = toremove.length; _i < _len; _i++) {
        key = toremove[_i];
        delete attrs[key];
      }
      if (!_.isEmpty(attrs)) {
        return HasProperties.__super__.set.call(this, attrs, options);
      }
    };

    HasProperties.prototype.convert_to_ref = function(value) {
      if (_.isArray(value)) {
        return _.map(value, this.convert_to_ref);
      } else {
        if (value instanceof HasProperties) {
          return value.ref();
        }
      }
    };

    HasProperties.prototype.add_dependencies = function(prop_name, object, fields) {
      var fld, prop_spec, _i, _len, _results;
      if (!_.isArray(fields)) {
        fields = [fields];
      }
      prop_spec = this.properties[prop_name];
      prop_spec.dependencies = prop_spec.dependencies.concat({
        obj: object,
        fields: fields
      });
      _results = [];
      for (_i = 0, _len = fields.length; _i < _len; _i++) {
        fld = fields[_i];
        _results.push(safebind(this, object, "change:" + fld, prop_spec['callbacks']['changedep']));
      }
      return _results;
    };

    HasProperties.prototype.register_setter = function(prop_name, setter) {
      var prop_spec;
      prop_spec = this.properties[prop_name];
      return prop_spec.setter = setter;
    };

    HasProperties.prototype.register_property = function(prop_name, getter, use_cache) {
      var changedep, prop_spec, propchange,
        _this = this;
      if (_.isUndefined(use_cache)) {
        use_cache = true;
      }
      if (_.has(this.properties, prop_name)) {
        this.remove_property(prop_name);
      }
      changedep = function() {
        return _this.trigger('changedep:' + prop_name);
      };
      propchange = function() {
        var firechange, new_val, old_val;
        firechange = true;
        if (prop_spec['use_cache']) {
          old_val = _this.get_cache(prop_name);
          _this.clear_cache(prop_name);
          new_val = _this.get(prop_name);
          firechange = new_val !== old_val;
        }
        if (firechange) {
          _this.trigger('change:' + prop_name, _this, _this.get(prop_name));
          return _this.trigger('change', _this);
        }
      };
      prop_spec = {
        'getter': getter,
        'dependencies': [],
        'use_cache': use_cache,
        'setter': null,
        'callbacks': {
          changedep: changedep,
          propchange: propchange
        }
      };
      this.properties[prop_name] = prop_spec;
      safebind(this, this, "changedep:" + prop_name, prop_spec['callbacks']['propchange']);
      return prop_spec;
    };

    HasProperties.prototype.remove_property = function(prop_name) {
      var dep, dependencies, fld, obj, prop_spec, _i, _j, _len, _len1, _ref;
      prop_spec = this.properties[prop_name];
      dependencies = prop_spec.dependencies;
      for (_i = 0, _len = dependencies.length; _i < _len; _i++) {
        dep = dependencies[_i];
        obj = dep.obj;
        _ref = dep['fields'];
        for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
          fld = _ref[_j];
          obj.off('change:' + fld, prop_spec['callbacks']['changedep'], this);
        }
      }
      this.off("changedep:" + dep);
      delete this.properties[prop_name];
      if (prop_spec.use_cache) {
        return this.clear_cache(prop_name);
      }
    };

    HasProperties.prototype.has_cache = function(prop_name) {
      return _.has(this.property_cache, prop_name);
    };

    HasProperties.prototype.add_cache = function(prop_name, val) {
      return this.property_cache[prop_name] = val;
    };

    HasProperties.prototype.clear_cache = function(prop_name, val) {
      return delete this.property_cache[prop_name];
    };

    HasProperties.prototype.get_cache = function(prop_name) {
      return this.property_cache[prop_name];
    };

    HasProperties.prototype.get = function(prop_name) {
      var computed, getter, prop_spec;
      if (_.has(this.properties, prop_name)) {
        prop_spec = this.properties[prop_name];
        if (prop_spec.use_cache && this.has_cache(prop_name)) {
          return this.property_cache[prop_name];
        } else {
          getter = prop_spec.getter;
          computed = getter.apply(this, this);
          if (this.properties[prop_name].use_cache) {
            this.add_cache(prop_name, computed);
          }
          return computed;
        }
      } else {
        return HasProperties.__super__.get.call(this, prop_name);
      }
    };

    HasProperties.prototype.ref = function() {
      return {
        'type': this.type,
        'id': this.id
      };
    };

    HasProperties.prototype.resolve_ref = function(ref) {
      if (_.isArray(ref)) {
        return _.map(ref, this.resolve_ref);
      }
      if (!ref) {
        console.log('ERROR, null reference');
      }
      if (ref['type'] === this.type && ref['id'] === this.id) {
        return this;
      } else {
        return Collections(ref['type']).get(ref['id']);
      }
    };

    HasProperties.prototype.get_obj = function(ref_name) {
      var ref;
      ref = this.get(ref_name);
      if (ref) {
        return this.resolve_ref(ref);
      }
    };

    HasProperties.prototype.url = function() {
      var base;
      base = Config.prefix + "/bokeh/bb/" + this.get('doc') + "/" + this.type + "/";
      if (this.isNew()) {
        return base;
      }
      return base + this.get('id') + "/";
    };

    HasProperties.prototype.sync = function(method, model, options) {
      return options.success(model, null, {});
    };

    HasProperties.prototype.defaults = {};

    HasProperties.prototype.rpc = function(funcname, args, kwargs) {
      var data, docid, id, prefix, resp, type, url;
      prefix = Config.prefix;
      docid = this.get('doc');
      id = this.get('id');
      type = this.type;
      url = "" + prefix + "/bokeh/bb/rpc/" + docid + "/" + type + "/" + id + "/" + funcname + "/";
      data = {
        args: args,
        kwargs: kwargs
      };
      resp = $.ajax({
        type: 'POST',
        url: url,
        data: JSON.stringify(data),
        contentType: 'application/json',
        xhrFields: {
          withCredentials: true
        }
      });
      return resp;
    };

    return HasProperties;

  })(Backbone.Model);

  HasParent = (function(_super) {

    __extends(HasParent, _super);

    function HasParent() {
      return HasParent.__super__.constructor.apply(this, arguments);
    }

    HasParent.prototype.get_fallback = function(attr) {
      var retval;
      if (this.get_obj('parent') && _.indexOf(this.get_obj('parent').parent_properties, attr) >= 0 && !_.isUndefined(this.get_obj('parent').get(attr))) {
        return this.get_obj('parent').get(attr);
      } else {
        retval = this.display_defaults[attr];
        return retval;
      }
    };

    HasParent.prototype.get = function(attr) {
      var normalval;
      normalval = HasParent.__super__.get.call(this, attr);
      if (!_.isUndefined(normalval)) {
        return normalval;
      } else if (!(attr === 'parent')) {
        return this.get_fallback(attr);
      }
    };

    HasParent.prototype.display_defaults = {};

    return HasParent;

  })(HasProperties);

  build_views = function(view_storage, view_models, options, view_types) {
    var created_views, i_model, key, model, newmodels, to_remove, view_specific_option, _i, _j, _len, _len1;
    if (view_types == null) {
      view_types = [];
    }
    "use strict";

    created_views = [];
    try {
      newmodels = _.filter(view_models, function(x) {
        return !_.has(view_storage, x.id);
      });
    } catch (error) {
      debugger;
      console.log(error);
      throw error;
    }
    for (i_model = _i = 0, _len = newmodels.length; _i < _len; i_model = ++_i) {
      model = newmodels[i_model];
      view_specific_option = _.extend({}, options, {
        'model': model
      });
      try {
        if (i_model < view_types.length) {
          view_storage[model.id] = new view_types[i_model](view_specific_option);
        } else {
          view_storage[model.id] = new model.default_view(view_specific_option);
        }
      } catch (error) {
        console.log("error on model of", model, error);
        throw error;
      }
      created_views.push(view_storage[model.id]);
    }
    to_remove = _.difference(_.keys(view_storage), _.pluck(view_models, 'id'));
    for (_j = 0, _len1 = to_remove.length; _j < _len1; _j++) {
      key = to_remove[_j];
      view_storage[key].remove();
      delete view_storage[key];
    }
    return created_views;
  };

  locations = {
    AnnotationRenderer: ['./renderers/annotation_renderer', 'annotationrenderers'],
    GlyphRenderer: ['./renderers/glyph_renderer', 'glyphrenderers'],
    GuideRenderer: ['./renderers/guide_renderer', 'guiderenderers'],
    PanTool: ['./tools/pan_tool', 'pantools'],
    ZoomTool: ['./tools/zoom_tool', 'zoomtools'],
    ResizeTool: ['./tools/resize_tool', 'resizetools'],
    SelectionTool: ['./tools/select_tool', 'selectiontools'],
    DataRangeBoxSelectionTool: ['./tools/select_tool', 'datarangeboxselectiontools'],
    PreviewSaveTool: ['./tools/preview_save_tool', 'previewsavetools'],
    EmbedTool: ['./tools/embed_tool', 'embedtools'],
    BoxSelectionOverlay: ['./overlays/boxselectionoverlay', 'boxselectionoverlays'],
    ObjectArrayDataSource: ['./common/datasource', 'objectarraydatasources'],
    ColumnDataSource: ['./common/datasource', 'columndatasources'],
    Range1d: ['./common/ranges', 'range1ds'],
    DataRange1d: ['./common/ranges', 'datarange1ds'],
    DataFactorRange: ['./common/ranges', 'datafactorranges'],
    Plot: ['./common/plot', 'plots'],
    GMapPlot: ['./common/gmap_plot', 'gmapplots'],
    GridPlot: ['./common/grid_plot', 'gridplots'],
    CDXPlotContext: ['./common/plot_context', 'plotcontexts'],
    PlotContext: ['./common/plot_context', 'plotcontexts'],
    PlotList: ['./common/plot_context', 'plotlists'],
    DataTable: ['./widgets/table', 'datatables'],
    IPythonRemoteData: ['./pandas/pandas', 'ipythonremotedatas'],
    PandasPivotTable: ['./pandas/pandas', 'pandaspivottables'],
    PandasPlotSource: ['./pandas/pandas', 'pandasplotsources'],
    LinearAxis: ['./renderers/guide/linear_axis', 'linearaxes'],
    DatetimeAxis: ['./renderers/guide/datetime_axis', 'datetimeaxes'],
    Grid: ['./renderers/guide/grid', 'grids'],
    Legend: ['./renderers/annotation_renderer', 'annotationrenderers'],
    DataSlider: ['./tools/slider', 'datasliders']
  };

  exports.locations = locations;

  mod_cache = {};

  Collections = function(typename) {
    var collection, modulename, _ref;
    if (!locations[typename]) {
      throw "./base: Unknown Collection " + typename;
    }
    _ref = locations[typename], modulename = _ref[0], collection = _ref[1];
    if (!(mod_cache[modulename] != null)) {
      console.log("calling require", modulename);
      mod_cache[modulename] = require(modulename);
    }
    return mod_cache[modulename][collection];
  };

  Collections.bulksave = function(models) {
    var doc, jsondata, m, url, xhr;
    doc = models[0].get('doc');
    jsondata = (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = models.length; _i < _len; _i++) {
        m = models[_i];
        _results.push({
          type: m.type,
          attributes: _.clone(m.attributes)
        });
      }
      return _results;
    })();
    jsondata = JSON.stringify(jsondata);
    url = Config.prefix + "/bokeh/bb/" + doc + "/bulkupsert";
    xhr = $.ajax({
      type: 'POST',
      url: url,
      contentType: "application/json",
      data: jsondata,
      header: {
        client: "javascript"
      }
    });
    xhr.done(function(data) {
      return load_models(data.modelspecs);
    });
    return xhr;
  };

  exports.Collections = Collections;

  exports.Config = Config;

  exports.safebind = safebind;

  exports.load_models = load_models;

  exports.WebSocketWrapper = WebSocketWrapper;

  exports.submodels = submodels;

  exports.HasProperties = HasProperties;

  exports.HasParent = HasParent;

  exports.build_views = build_views;

}).call(this);
}, "common/affine": function(exports, require, module) {(function() {
  var Affine;

  Affine = (function() {

    function Affine(a, b, c, d, tx, ty) {
      this.a = a != null ? a : 1;
      this.b = b != null ? b : 0;
      this.c = c != null ? c : 0;
      this.d = d != null ? d : 1;
      this.tx = tx != null ? tx : 0;
      this.ty = ty != null ? ty : 0;
    }

    Affine.prototype.apply = function(x, y) {
      return [this.a * x + this.b * y + this.tx, this.c * x + this.d * y + this.ty];
    };

    Affine.prototype.v_apply = function(xs, ys) {
      var i, xres, yres, _i, _ref;
      xres = new Float32Array(xs.length);
      yres = new Float32Array(ys.length);
      for (i = _i = 0, _ref = xs.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        xres[i] = this.a * xs[i] + this.b * ys[i] + this.tx;
        yres[i] = this.c * xs[i] + this.d * ys[i] + this.ty;
      }
      return [xres, yres];
    };

    Affine.prototype.is_identity = function() {
      return this.a === 1 && this.b === 0 && this.c === 0 && this.d === 1 && this.tx === 0 && this.ty === 0;
    };

    Affine.prototype.translate = function(tx, ty) {
      this.tx = this.a * tx + this.b * ty;
      return this.ty = this.c * tx + this.d * ty;
    };

    Affine.prototype.scale = function(sx, sy) {
      this.a *= sx;
      this.b *= sy;
      this.c *= sx;
      return this.d *= sy;
    };

    Affine.prototype.rotate = function(alpha) {
      var C, S, a, b, c, d;
      C = Math.cos(alpha);
      S = Math.sin(alpha);
      a = C * this.a + S * this.b;
      b = C * this.b - S * this.a;
      c = C * this.c + S * this.d;
      d = C * this.d - S * this.c;
      this.a = a;
      this.b = b;
      this.c = c;
      return this.d = d;
    };

    Affine.prototype.shear = function(kx, ky) {
      var a, b, c, d;
      a = this.a + kx * this.c;
      b = this.b + kx * this.d;
      c = this.c + ky * this.a;
      d = this.d + ky * this.b;
      this.a = a;
      this.b = b;
      this.c = c;
      return this.d = d;
    };

    Affine.prototype.reflect_x = function(x0) {
      this.tx = 2 * this.a * x0 + this.tx;
      this.ty = 2 * this.c * x0 + this.ty;
      this.a = -this.a;
      return this.c = -this.c;
    };

    Affine.prototype.reflect_y = function(y0) {
      this.tx = 2 * this.b * y0 + this.tx;
      this.ty = 2 * this.d * y0 + this.ty;
      this.b = -this.b;
      return this.d = -this.d;
    };

    Affine.prototype.reflect_xy = function(x0, y0) {
      this.tx = 2 * (this.a * x0 + this.b * y0) + this.tx;
      this.ty = 2 * (this.c * x0 + this.d * y0) + this.ty;
      this.a = -this.a;
      this.b = -this.b;
      this.c = -this.c;
      return this.d = -this.d;
    };

    Affine.prototype.compose_right = function(m) {
      var a, b, c, d, tx, ty;
      a = this.a * m.a + this.b * m.c;
      b = this.a * m.b + this.b * m.d;
      c = this.c * m.a + this.d * m.c;
      d = this.c * m.b + this.d * m.d;
      tx = this.a * m.tx + this.b * m.ty + this.tx;
      ty = this.c * m.tx + this.d * m.ty + this.ty;
      this.a = a;
      this.b = b;
      this.c = c;
      this.d = d;
      this.tx = tx;
      return this.ty = ty;
    };

    Affine.prototype.compose_left = function(m) {
      var a, b, c, d, tx, ty;
      a = m.a * this.a + m.b * this.c;
      b = m.a * this.b + m.b * this.d;
      c = m.c * this.a + m.d * this.c;
      d = m.c * this.b + m.d * this.d;
      tx = m.a * this.tx + m.b * this.ty + m.tx;
      ty = m.c * this.tx + m.d * this.ty + m.ty;
      this.a = a;
      this.b = b;
      this.c = c;
      this.d = d;
      this.tx = tx;
      return this.ty = ty;
    };

    return Affine;

  })();

}).call(this);
}, "common/continuum_view": function(exports, require, module) {(function() {
  var ContinuumView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  ContinuumView = (function(_super) {

    __extends(ContinuumView, _super);

    function ContinuumView() {
      return ContinuumView.__super__.constructor.apply(this, arguments);
    }

    ContinuumView.prototype.initialize = function(options) {
      if (!_.has(options, 'id')) {
        return this.id = _.uniqueId('ContinuumView');
      }
    };

    ContinuumView.prototype.bind_bokeh_events = function() {
      return 'pass';
    };

    ContinuumView.prototype.delegateEvents = function(events) {
      return ContinuumView.__super__.delegateEvents.call(this, events);
    };

    ContinuumView.prototype.remove = function() {
      var target, val, _ref;
      if (_.has(this, 'eventers')) {
        _ref = this.eventers;
        for (target in _ref) {
          if (!__hasProp.call(_ref, target)) continue;
          val = _ref[target];
          val.off(null, null, this);
        }
      }
      this.trigger('remove');
      return ContinuumView.__super__.remove.call(this);
    };

    ContinuumView.prototype.mget = function() {
      return this.model.get.apply(this.model, arguments);
    };

    ContinuumView.prototype.mset = function() {
      return this.model.set.apply(this.model, arguments);
    };

    ContinuumView.prototype.mget_obj = function(fld) {
      return this.model.get_obj(fld);
    };

    ContinuumView.prototype.render_end = function() {
      return "pass";
    };

    return ContinuumView;

  })(Backbone.View);

  exports.ContinuumView = ContinuumView;

}).call(this);
}, "common/datasource": function(exports, require, module) {(function() {
  var ColumnDataSource, ColumnDataSources, HasProperties, ObjectArrayDataSource, ObjectArrayDataSources, base,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require("../base");

  HasProperties = base.HasProperties;

  ObjectArrayDataSource = (function(_super) {

    __extends(ObjectArrayDataSource, _super);

    function ObjectArrayDataSource() {
      return ObjectArrayDataSource.__super__.constructor.apply(this, arguments);
    }

    ObjectArrayDataSource.prototype.type = 'ObjectArrayDataSource';

    ObjectArrayDataSource.prototype.initialize = function(attrs, options) {
      ObjectArrayDataSource.__super__.initialize.call(this, attrs, options);
      this.cont_ranges = {};
      return this.discrete_ranges = {};
    };

    ObjectArrayDataSource.prototype.getcolumn = function(colname) {
      var x;
      return (function() {
        var _i, _len, _ref, _results;
        _ref = this.get('data');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          x = _ref[_i];
          _results.push(x[colname]);
        }
        return _results;
      }).call(this);
    };

    ObjectArrayDataSource.prototype.compute_cont_range = function(field) {
      var data;
      data = this.getcolumn(field);
      return [_.max(data), _.min(data)];
    };

    ObjectArrayDataSource.prototype.compute_discrete_factor = function(field) {
      var temp, uniques, val, _i, _len, _ref;
      temp = {};
      _ref = this.getcolumn(field);
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        val = _ref[_i];
        temp[val] = true;
      }
      uniques = _.keys(temp);
      return uniques = _.sortBy(uniques, (function(x) {
        return x;
      }));
    };

    ObjectArrayDataSource.prototype.get_cont_range = function(field, padding) {
      var center, max, min, span, _ref, _ref1,
        _this = this;
      if (_.isUndefined(padding)) {
        padding = 1.0;
      }
      if (!_.exists(this.cont_ranges, field)) {
        _ref = this.compute_cont_range(field), min = _ref[0], max = _ref[1];
        span = (max - min) * (1 + padding);
        center = (max + min) / 2.0;
        _ref1 = [center - span / 2.0, center + span / 2.0], min = _ref1[0], max = _ref1[1];
        this.cont_ranges[field] = Collections('Range1d').create({
          start: min,
          end: max
        });
        this.on('change:data', function() {
          var _ref2;
          _ref2 = _this.compute_cont_range(field), max = _ref2[0], min = _ref2[1];
          _this.cont_ranges[field].set('start', min);
          return _this.cont_ranges[field].set('end', max);
        });
      }
      return this.cont_ranges[field];
    };

    ObjectArrayDataSource.prototype.get_discrete_range = function(field) {
      var factors,
        _this = this;
      if (!_.exists(this.discrete_ranges, field)) {
        factors = this.compute_discrete_factor(field);
        this.discrete_ranges[field] = Collections('FactorRange').create({
          values: factors
        });
        this.on('change:data', function() {
          factors = _this.compute_discrete_factor(field);
          return _this.discrete_ranges[field] = Collections('FactorRange').set('values', factors);
        });
      }
      return this.discrete_ranges[field];
    };

    ObjectArrayDataSource.prototype.select = function(fields, func) {
      var args, idx, selected, val, x, _i, _len, _ref;
      selected = [];
      _ref = this.get('data');
      for (idx = _i = 0, _len = _ref.length; _i < _len; idx = ++_i) {
        val = _ref[idx];
        args = (function() {
          var _j, _len1, _results;
          _results = [];
          for (_j = 0, _len1 = fields.length; _j < _len1; _j++) {
            x = fields[_j];
            _results.push(val[x]);
          }
          return _results;
        })();
        if (func.apply(func, args)) {
          selected.push(idx);
        }
      }
      selected.sort();
      return selected;
    };

    return ObjectArrayDataSource;

  })(HasProperties);

  ObjectArrayDataSource.prototype.defaults = _.clone(ObjectArrayDataSource.prototype.defaults);

  _.extend(ObjectArrayDataSource.prototype.defaults, {
    data: [{}],
    name: 'data',
    selected: [],
    selecting: false
  });

  ObjectArrayDataSources = (function(_super) {

    __extends(ObjectArrayDataSources, _super);

    function ObjectArrayDataSources() {
      return ObjectArrayDataSources.__super__.constructor.apply(this, arguments);
    }

    ObjectArrayDataSources.prototype.model = ObjectArrayDataSource;

    return ObjectArrayDataSources;

  })(Backbone.Collection);

  ColumnDataSource = (function(_super) {

    __extends(ColumnDataSource, _super);

    function ColumnDataSource() {
      return ColumnDataSource.__super__.constructor.apply(this, arguments);
    }

    ColumnDataSource.prototype.type = 'ColumnDataSource';

    ColumnDataSource.prototype.initialize = function(attrs, options) {
      ColumnDataSource.__super__.initialize.call(this, attrs, options);
      this.cont_ranges = {};
      return this.discrete_ranges = {};
    };

    ColumnDataSource.prototype.getcolumn = function(colname) {
      return this.get('data')[colname];
    };

    ColumnDataSource.prototype.datapoints = function() {
      var data, field, fields, i, point, points, _i, _j, _len, _ref;
      data = this.get('data');
      fields = _.keys(data);
      points = [];
      for (i = _i = 0, _ref = data[fields[0]].length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        point = {};
        for (_j = 0, _len = fields.length; _j < _len; _j++) {
          field = fields[_j];
          point[field] = data[field][i];
        }
        points.push(point);
      }
      return points;
    };

    return ColumnDataSource;

  })(ObjectArrayDataSource);

  ColumnDataSources = (function(_super) {

    __extends(ColumnDataSources, _super);

    function ColumnDataSources() {
      return ColumnDataSources.__super__.constructor.apply(this, arguments);
    }

    ColumnDataSources.prototype.model = ColumnDataSource;

    return ColumnDataSources;

  })(Backbone.Collection);

  exports.objectarraydatasources = new ObjectArrayDataSources;

  exports.columndatasources = new ColumnDataSources;

  exports.ObjectArrayDataSource = ObjectArrayDataSource;

  exports.ColumnDataSource = ColumnDataSource;

}).call(this);
}, "common/gmap_plot": function(exports, require, module) {(function() {
  var ActiveToolManager, Collections, ContinuumView, GMapPlot, GMapPlotView, GMapPlots, GridMapper, HasParent, LEVELS, LinearMapper, ViewState, base, build_views, properties, safebind, text_properties,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../base');

  Collections = base.Collections;

  HasParent = base.HasParent;

  safebind = base.safebind;

  build_views = base.build_views;

  properties = require('../renderers/properties');

  text_properties = properties.text_properties;

  ContinuumView = require('./continuum_view').ContinuumView;

  LinearMapper = require('../mappers/1d/linear_mapper').LinearMapper;

  GridMapper = require('../mappers/2d/grid_mapper').GridMapper;

  ViewState = require('./view_state').ViewState;

  ActiveToolManager = require("../tools/active_tool_manager").ActiveToolManager;

  LEVELS = ['image', 'underlay', 'glyph', 'overlay', 'annotation', 'tool'];

  GMapPlotView = (function(_super) {

    __extends(GMapPlotView, _super);

    function GMapPlotView() {
      this.bounds_change = __bind(this.bounds_change, this);

      this._mousemove = __bind(this._mousemove, this);

      this._mousedown = __bind(this._mousedown, this);
      return GMapPlotView.__super__.constructor.apply(this, arguments);
    }

    GMapPlotView.prototype.events = {
      "mousemove .bokeh_canvas_wrapper": "_mousemove",
      "mousedown .bokeh_canvas_wrapper": "_mousedown"
    };

    GMapPlotView.prototype.className = "bokeh";

    GMapPlotView.prototype.view_options = function() {
      return _.extend({
        plot_model: this.model,
        plot_view: this
      }, this.options);
    };

    GMapPlotView.prototype._mousedown = function(e) {
      var f, _i, _len, _ref, _results;
      _ref = this.mousedownCallbacks;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        f = _ref[_i];
        _results.push(f(e, e.layerX, e.layerY));
      }
      return _results;
    };

    GMapPlotView.prototype._mousemove = function(e) {
      var f, _i, _len, _ref, _results;
      _ref = this.moveCallbacks;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        f = _ref[_i];
        _results.push(f(e, e.layerX, e.layerY));
      }
      return _results;
    };

    GMapPlotView.prototype.pause = function() {
      return this.is_paused = true;
    };

    GMapPlotView.prototype.unpause = function(render_canvas) {
      if (render_canvas == null) {
        render_canvas = false;
      }
      this.is_paused = false;
      if (render_canvas) {
        return this.request_render_canvas(true);
      } else {
        return this.request_render();
      }
    };

    GMapPlotView.prototype.request_render = function() {
      if (!this.is_paused) {
        this.throttled_render();
      }
    };

    GMapPlotView.prototype.request_render_canvas = function(full_render) {
      if (!this.is_paused) {
        this.throttled_render_canvas(full_render);
      }
    };

    GMapPlotView.prototype.initialize = function(options) {
      var level, tool, _i, _j, _len, _len1, _ref, _ref1, _ref10, _ref11, _ref12, _ref13, _ref14, _ref15, _ref16, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9;
      GMapPlotView.__super__.initialize.call(this, _.defaults(options, this.default_options));
      this.throttled_render = _.throttle(this.render, 100);
      this.throttled_render_canvas = _.throttle(this.render_canvas, 100);
      this.title_props = new text_properties(this, {}, 'title_');
      this.view_state = new ViewState({
        canvas_width: (_ref = options.canvas_width) != null ? _ref : this.mget('canvas_width'),
        canvas_height: (_ref1 = options.canvas_height) != null ? _ref1 : this.mget('canvas_height'),
        x_offset: (_ref2 = options.x_offset) != null ? _ref2 : this.mget('x_offset'),
        y_offset: (_ref3 = options.y_offset) != null ? _ref3 : this.mget('y_offset'),
        outer_width: (_ref4 = options.outer_width) != null ? _ref4 : this.mget('outer_width'),
        outer_height: (_ref5 = options.outer_height) != null ? _ref5 : this.mget('outer_height'),
        min_border_top: (_ref6 = (_ref7 = options.min_border_top) != null ? _ref7 : this.mget('min_border_top')) != null ? _ref6 : this.mget('min_border'),
        min_border_bottom: (_ref8 = (_ref9 = options.min_border_bottom) != null ? _ref9 : this.mget('min_border_bottom')) != null ? _ref8 : this.mget('min_border'),
        min_border_left: (_ref10 = (_ref11 = options.min_border_left) != null ? _ref11 : this.mget('min_border_left')) != null ? _ref10 : this.mget('min_border'),
        min_border_right: (_ref12 = (_ref13 = options.min_border_right) != null ? _ref13 : this.mget('min_border_right')) != null ? _ref12 : this.mget('min_border'),
        requested_border_top: 0,
        requested_border_bottom: 0,
        requested_border_left: 0,
        requested_border_right: 0
      });
      this.x_range = (_ref14 = options.x_range) != null ? _ref14 : this.mget_obj('x_range');
      this.y_range = (_ref15 = options.y_range) != null ? _ref15 : this.mget_obj('y_range');
      this.xmapper = new LinearMapper({
        source_range: this.x_range,
        target_range: this.view_state.get('inner_range_horizontal')
      });
      this.ymapper = new LinearMapper({
        source_range: this.y_range,
        target_range: this.view_state.get('inner_range_vertical')
      });
      this.mapper = new GridMapper({
        domain_mapper: this.xmapper,
        codomain_mapper: this.ymapper
      });
      _ref16 = this.mget_obj('tools');
      for (_i = 0, _len = _ref16.length; _i < _len; _i++) {
        tool = _ref16[_i];
        if (tool.type === "PanTool" || tool.type === "ZoomTool") {
          tool.set_obj('dataranges', [this.x_range, this.y_range]);
          tool.set('dimensions', ['width', 'height']);
        }
      }
      this.requested_padding = {
        top: 0,
        bottom: 0,
        left: 0,
        right: 0
      };
      this.old_mapper_state = {
        x: null,
        y: null
      };
      this.am_rendering = false;
      this.renderers = {};
      this.tools = {};
      this.zoom_count = null;
      this.eventSink = _.extend({}, Backbone.Events);
      this.moveCallbacks = [];
      this.mousedownCallbacks = [];
      this.keydownCallbacks = [];
      this.render_init();
      this.render_canvas(false);
      this.atm = new ActiveToolManager(this.eventSink);
      this.levels = {};
      for (_j = 0, _len1 = LEVELS.length; _j < _len1; _j++) {
        level = LEVELS[_j];
        this.levels[level] = {};
      }
      this.build_levels();
      this.request_render();
      this.atm.bind_bokeh_events();
      this.bind_bokeh_events();
      return this;
    };

    GMapPlotView.prototype.map_to_screen = function(x, x_units, y, y_units, units) {
      var sx, sy, _ref;
      if (x_units === 'screen') {
        sx = x.slice(0);
        sy = y.slice(0);
      } else {
        _ref = this.mapper.v_map_to_target(x, y), sx = _ref[0], sy = _ref[1];
      }
      sx = this.view_state.v_sx_to_device(sx);
      sy = this.view_state.v_sy_to_device(sy);
      return [sx, sy];
    };

    GMapPlotView.prototype.map_from_screen = function(sx, sy, units) {
      var x, y, _ref;
      sx = this.view_state.v_device_sx(sx.slice(0));
      sy = this.view_state.v_device_sx(sy.slice(0));
      if (units === 'screen') {
        x = sx;
        y = sy;
      } else {
        _ref = this.mapper.v_map_from_target(sx, sy), x = _ref[0], y = _ref[1];
      }
      return [x, y];
    };

    GMapPlotView.prototype.update_range = function(range_info) {
      var center, ne_lat, ne_lng, sw_lat, sw_lng;
      this.pause();
      if (range_info.sdx != null) {
        this.map.panBy(range_info.sdx, range_info.sdy);
      } else {
        sw_lng = Math.min(range_info.xr.start, range_info.xr.end);
        ne_lng = Math.max(range_info.xr.start, range_info.xr.end);
        sw_lat = Math.min(range_info.yr.start, range_info.yr.end);
        ne_lat = Math.max(range_info.yr.start, range_info.yr.end);
        center = new google.maps.LatLng((ne_lat + sw_lat) / 2, (ne_lng + sw_lng) / 2);
        if (range_info.factor > 0) {
          this.zoom_count += 1;
          if (this.zoom_count === 10) {
            this.map.setZoom(this.map.getZoom() + 1);
            this.zoom_count = 0;
          }
        } else {
          this.zoom_count -= 1;
          if (this.zoom_count === -10) {
            this.map.setCenter(center);
            this.map.setZoom(this.map.getZoom() - 1);
            this.map.setCenter(center);
            this.zoom_count = 0;
          }
        }
      }
      return this.unpause();
    };

    GMapPlotView.prototype.build_tools = function() {
      return build_views(this.tools, this.mget_obj('tools'), this.view_options());
    };

    GMapPlotView.prototype.build_views = function() {
      return build_views(this.renderers, this.mget_obj('renderers'), this.view_options());
    };

    GMapPlotView.prototype.build_levels = function() {
      var level, t, tools, v, views, _i, _j, _len, _len1;
      views = this.build_views();
      tools = this.build_tools();
      for (_i = 0, _len = views.length; _i < _len; _i++) {
        v = views[_i];
        level = v.mget('level');
        this.levels[level][v.model.id] = v;
        v.bind_bokeh_events();
      }
      for (_j = 0, _len1 = tools.length; _j < _len1; _j++) {
        t = tools[_j];
        level = t.mget('level');
        this.levels[level][t.model.id] = t;
        t.bind_bokeh_events();
      }
      return this;
    };

    GMapPlotView.prototype.bind_bokeh_events = function() {
      var _this = this;
      safebind(this, this.view_state, 'change', function() {
        _this.request_render_canvas();
        return _this.request_render();
      });
      safebind(this, this.x_range, 'change', this.request_render);
      safebind(this, this.y_range, 'change', this.request_render);
      safebind(this, this.model, 'change:renderers', this.build_levels);
      safebind(this, this.model, 'change:tool', this.build_levels);
      safebind(this, this.model, 'change', this.request_render);
      return safebind(this, this.model, 'destroy', function() {
        return _this.remove();
      });
    };

    GMapPlotView.prototype.render_init = function() {
      this.$el.append($("<div class='button_bar btn-group'/>\n<div class='plotarea'>\n<div class='bokeh_canvas_wrapper'>\n  <div class=\"bokeh_gmap\"></div>\n  <canvas class='bokeh_canvas'></canvas>\n</div>\n</div>"));
      this.button_bar = this.$el.find('.button_bar');
      this.canvas_wrapper = this.$el.find('.bokeh_canvas_wrapper');
      this.canvas = this.$el.find('canvas.bokeh_canvas');
      return this.gmap_div = this.$el.find('.bokeh_gmap');
    };

    GMapPlotView.prototype.render_canvas = function(full_render) {
      var build_map, ih, iw, left, oh, ow, top,
        _this = this;
      if (full_render == null) {
        full_render = true;
      }
      oh = this.view_state.get('outer_height');
      ow = this.view_state.get('outer_width');
      iw = this.view_state.get('inner_width');
      ih = this.view_state.get('inner_height');
      top = this.view_state.get('border_top');
      left = this.view_state.get('border_left');
      this.button_bar.width("" + ow + "px");
      this.canvas_wrapper.width("" + ow + "px").height("" + oh + "px");
      this.canvas.attr('width', ow).attr('height', oh);
      this.$el.attr("width", ow).attr('height', oh);
      this.gmap_div.attr("style", "top: " + top + "px; left: " + left + "px; position: absolute");
      this.gmap_div.width("" + iw + "px").height("" + ih + "px");
      build_map = function() {
        var map_options, mo;
        mo = _this.mget('map_options');
        map_options = {
          center: new google.maps.LatLng(mo.lat, mo.lng),
          zoom: mo.zoom,
          disableDefaultUI: true,
          mapTypeId: google.maps.MapTypeId.SATELLITE
        };
        _this.map = new google.maps.Map(_this.gmap_div[0], map_options);
        return google.maps.event.addListener(_this.map, 'bounds_changed', _this.bounds_change);
      };
      _.defer(build_map);
      this.ctx = this.canvas[0].getContext('2d');
      if (full_render) {
        return this.render();
      }
    };

    GMapPlotView.prototype.bounds_change = function() {
      var bds, ne, sw;
      bds = this.map.getBounds();
      ne = bds.getNorthEast();
      sw = bds.getSouthWest();
      this.x_range.set({
        start: sw.lng(),
        end: ne.lng(),
        silent: true
      });
      return this.y_range.set({
        start: sw.lat(),
        end: ne.lat()
      });
    };

    GMapPlotView.prototype.save_png = function() {
      var data_uri;
      this.render();
      data_uri = this.canvas[0].toDataURL();
      this.model.set('png', this.canvas[0].toDataURL());
      return base.Collections.bulksave([this.model]);
    };

    GMapPlotView.prototype.render = function(force) {
      var have_new_mapper_state, hpadding, ih, iw, k, left, level, oh, ow, pr, renderers, sx, sy, sym, th, title, top, v, xms, yms, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _ref3;
      this.requested_padding = {
        top: 0,
        bottom: 0,
        left: 0,
        right: 0
      };
      _ref = ['image', 'underlay', 'glyph', 'overlay', 'annotation', 'tool'];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        level = _ref[_i];
        renderers = this.levels[level];
        for (k in renderers) {
          v = renderers[k];
          if (v.padding_request != null) {
            pr = v.padding_request();
            for (k in pr) {
              v = pr[k];
              this.requested_padding[k] += v;
            }
          }
        }
      }
      title = this.mget('title');
      if (title) {
        this.title_props.set(this.ctx, {});
        th = this.ctx.measureText(this.mget('title')).ascent;
        this.requested_padding['top'] += th + this.mget('title_standoff');
      }
      sym = this.mget('border_symmetry');
      if (sym.indexOf('h') >= 0 || sym.indexOf('H') >= 0) {
        hpadding = Math.max(this.requested_padding['left'], this.requested_padding['right']);
        this.requested_padding['left'] = hpadding;
        this.requested_padding['right'] = hpadding;
      }
      if (sym.indexOf('v') >= 0 || sym.indexOf('V') >= 0) {
        hpadding = Math.max(this.requested_padding['top'], this.requested_padding['bottom']);
        this.requested_padding['top'] = hpadding;
        this.requested_padding['bottom'] = hpadding;
      }
      this.is_paused = true;
      _ref1 = this.requested_padding;
      for (k in _ref1) {
        v = _ref1[k];
        this.view_state.set("requested_border_" + k, v);
      }
      this.is_paused = false;
      oh = this.view_state.get('outer_height');
      ow = this.view_state.get('outer_width');
      iw = this.view_state.get('inner_width');
      ih = this.view_state.get('inner_height');
      top = this.view_state.get('border_top');
      left = this.view_state.get('border_left');
      this.gmap_div.attr("style", "top: " + top + "px; left: " + left + "px;");
      this.gmap_div.width("" + iw + "px").height("" + ih + "px");
      this.ctx.clearRect(0, 0, ow, oh);
      this.ctx.beginPath();
      this.ctx.moveTo(0, 0);
      this.ctx.lineTo(0, oh);
      this.ctx.lineTo(ow, oh);
      this.ctx.lineTo(ow, 0);
      this.ctx.lineTo(0, 0);
      this.ctx.moveTo(left, top);
      this.ctx.lineTo(left + iw, top);
      this.ctx.lineTo(left + iw, top + ih);
      this.ctx.lineTo(left, top + ih);
      this.ctx.lineTo(left, top);
      this.ctx.closePath();
      this.ctx.fillStyle = this.mget('border_fill');
      this.ctx.fill();
      have_new_mapper_state = false;
      xms = this.xmapper.get('mapper_state')[0];
      yms = this.xmapper.get('mapper_state')[0];
      if (Math.abs(this.old_mapper_state.x - xms) > 1e-8 || Math.abs(this.old_mapper_state.y - yms) > 1e-8) {
        this.old_mapper_state.x = xms;
        this.old_mapper_state.y = yms;
        have_new_mapper_state = true;
      }
      this.ctx.save();
      this.ctx.beginPath();
      this.ctx.rect(this.view_state.get('border_left'), this.view_state.get('border_top'), this.view_state.get('inner_width'), this.view_state.get('inner_height'));
      this.ctx.clip();
      this.ctx.beginPath();
      _ref2 = ['image', 'underlay', 'glyph'];
      for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
        level = _ref2[_j];
        renderers = this.levels[level];
        for (k in renderers) {
          v = renderers[k];
          v.render(have_new_mapper_state);
        }
      }
      this.ctx.restore();
      _ref3 = ['overlay', 'annotation', 'tool'];
      for (_k = 0, _len2 = _ref3.length; _k < _len2; _k++) {
        level = _ref3[_k];
        renderers = this.levels[level];
        for (k in renderers) {
          v = renderers[k];
          v.render(have_new_mapper_state);
        }
      }
      if (title) {
        sx = this.view_state.get('outer_width') / 2;
        sy = th;
        this.title_props.set(this.ctx, {});
        return this.ctx.fillText(title, sx, sy);
      }
    };

    return GMapPlotView;

  })(ContinuumView);

  GMapPlot = (function(_super) {

    __extends(GMapPlot, _super);

    function GMapPlot() {
      return GMapPlot.__super__.constructor.apply(this, arguments);
    }

    GMapPlot.prototype.type = 'GMapPlot';

    GMapPlot.prototype.default_view = GMapPlotView;

    GMapPlot.prototype.add_renderers = function(new_renderers) {
      var renderers;
      renderers = this.get('renderers');
      renderers = renderers.concat(new_renderers);
      return this.set('renderers', renderers);
    };

    GMapPlot.prototype.parent_properties = ['border_fill', 'canvas_width', 'canvas_height', 'outer_width', 'outer_height', 'min_border', 'min_border_top', 'min_border_bottom', 'min_border_left', 'min_border_right'];

    return GMapPlot;

  })(HasParent);

  GMapPlot.prototype.defaults = _.clone(GMapPlot.prototype.defaults);

  _.extend(GMapPlot.prototype.defaults, {
    'data_sources': {},
    'renderers': [],
    'tools': [],
    'title': 'GMapPlot'
  });

  GMapPlot.prototype.display_defaults = _.clone(GMapPlot.prototype.display_defaults);

  _.extend(GMapPlot.prototype.display_defaults, {
    border_fill: "#eee",
    border_symmetry: 'h',
    min_border: 40,
    x_offset: 0,
    y_offset: 0,
    canvas_width: 300,
    canvas_height: 300,
    outer_width: 300,
    outer_height: 300,
    title_standoff: 8,
    title_text_font: "helvetica",
    title_text_font_size: "20pt",
    title_text_font_style: "normal",
    title_text_color: "#444444",
    title_text_alpha: 1.0,
    title_text_align: "center",
    title_text_baseline: "alphabetic"
  });

  GMapPlots = (function(_super) {

    __extends(GMapPlots, _super);

    function GMapPlots() {
      return GMapPlots.__super__.constructor.apply(this, arguments);
    }

    GMapPlots.prototype.model = GMapPlot;

    return GMapPlots;

  })(Backbone.Collection);

  exports.GMapPlot = GMapPlot;

  exports.GMapPlotView = GMapPlotView;

  exports.gmapplots = new GMapPlots;

}).call(this);
}, "common/grid_plot": function(exports, require, module) {(function() {
  var ActiveToolManager, ContinuumView, GridPlot, GridPlotView, GridPlots, GridViewState, HasParent, HasProperties, PanToolView, ViewState, ZoomToolView, base, build_views, safebind,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require("../base");

  HasParent = base.HasParent;

  HasProperties = base.HasProperties;

  safebind = base.safebind;

  build_views = base.build_views;

  ContinuumView = require('./continuum_view').ContinuumView;

  ViewState = require('./view_state').ViewState;

  GridViewState = require('./grid_view_state').GridViewState;

  ActiveToolManager = require("../tools/active_tool_manager").ActiveToolManager;

  PanToolView = require('../tools/pan_tool').PanToolView;

  ZoomToolView = require('../tools/zoom_tool').ZoomToolView;

  GridPlotView = (function(_super) {

    __extends(GridPlotView, _super);

    function GridPlotView() {
      return GridPlotView.__super__.constructor.apply(this, arguments);
    }

    GridPlotView.prototype.tagName = 'div';

    GridPlotView.prototype.className = "bokeh grid_plot";

    GridPlotView.prototype.default_options = {
      scale: 1.0
    };

    GridPlotView.prototype.set_child_view_states = function() {
      var row, viewstaterow, viewstates, x, _i, _len, _ref;
      viewstates = [];
      _ref = this.mget('children');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        row = _ref[_i];
        viewstaterow = (function() {
          var _j, _len1, _results;
          _results = [];
          for (_j = 0, _len1 = row.length; _j < _len1; _j++) {
            x = row[_j];
            _results.push(this.childviews[x.id].view_state);
          }
          return _results;
        }).call(this);
        viewstates.push(viewstaterow);
      }
      return this.viewstate.set('childviewstates', viewstates);
    };

    GridPlotView.prototype.initialize = function(options) {
      GridPlotView.__super__.initialize.call(this, _.defaults(options, this.default_options));
      this.viewstate = new GridViewState();
      this.toolbar_height = 0;
      this.childviews = {};
      this.build_children();
      this.bind_bokeh_events();
      this.render();
      return this;
    };

    GridPlotView.prototype.bind_bokeh_events = function() {
      var _this = this;
      safebind(this, this.model, 'change:children', this.build_children);
      safebind(this, this.model, 'change', this.render);
      safebind(this, this.viewstate, 'change', this.render);
      return safebind(this, this.model, 'destroy', function() {
        return _this.remove();
      });
    };

    GridPlotView.prototype.b_events = {
      "change:children model": "build_children",
      "change model": "render",
      "change viewstate": "render",
      "destroy model": "remove"
    };

    GridPlotView.prototype.build_children = function() {
      var childmodels, plot, row, _i, _j, _len, _len1, _ref;
      childmodels = [];
      _ref = this.mget_obj('children');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        row = _ref[_i];
        for (_j = 0, _len1 = row.length; _j < _len1; _j++) {
          plot = row[_j];
          childmodels.push(plot);
        }
      }
      build_views(this.childviews, childmodels, {});
      return this.set_child_view_states();
    };

    GridPlotView.prototype.makeButton = function(eventSink, constructor, toolbar_div, button_name) {
      var all_tools, button, button_activated, specific_tools, tool_active;
      all_tools = _.flatten(_.map(_.pluck(this.childviews, 'tools'), _.values));
      specific_tools = _.where(all_tools, {
        constructor: constructor
      });
      button = $("<button class='btn btn-small'>" + button_name + "</button>");
      toolbar_div.append(button);
      tool_active = false;
      button_activated = false;
      button.click(function() {
        if (button_activated) {
          return eventSink.trigger('clear_active_tool');
        } else {
          return eventSink.trigger('active_tool', button_name);
        }
      });
      eventSink.on("" + button_name + ":deactivated", function() {
        button.removeClass('active');
        button_activated = false;
        return _.each(specific_tools, function(t) {
          var t_name;
          t_name = t.evgen.toolName;
          return t.evgen.eventSink.trigger("" + t_name + ":deactivated");
        });
      });
      return eventSink.on("" + button_name + ":activated", function() {
        button.addClass('active');
        button_activated = true;
        return _.each(specific_tools, function(t) {
          var t_name;
          t_name = t.evgen.toolName;
          return t.evgen.eventSink.trigger("" + t_name + ":activated");
        });
      });
    };

    GridPlotView.prototype.addGridToolbar = function() {
      var all_tool_classes, all_tools, tool_name_dict,
        _this = this;
      this.button_bar = $("<div class='grid_button_bar'/>");
      this.button_bar.attr('style', "position:absolute; left:10px; top:5px; ");
      this.toolEventSink = _.extend({}, Backbone.Events);
      this.atm = new ActiveToolManager(this.toolEventSink);
      this.atm.bind_bokeh_events();
      this.$el.append(this.button_bar);
      all_tools = _.flatten(_.map(_.pluck(this.childviews, 'tools'), _.values));
      all_tool_classes = _.uniq(_.pluck(all_tools, 'constructor'));
      if (all_tool_classes.length > 0) {
        this.toolbar_height = 20;
      }
      tool_name_dict = {};
      _.each(all_tool_classes, function(klass) {
        var btext;
        btext = _.where(all_tools, {
          constructor: klass
        })[0].evgen_options.buttonText;
        return tool_name_dict[btext] = klass;
      });
      _.map(tool_name_dict, function(klass, button_text) {
        return _this.makeButton(_this.toolEventSink, klass, _this.button_bar, button_text);
      });
      return _.map(all_tools, function(t) {
        return t.evgen.hide_button();
      });
    };

    GridPlotView.prototype.render = function() {
      var add, cidx, col_widths, height, last_plot, plot_divs, plot_wrapper, plotspec, ridx, row, row_heights, total_height, view, width, x_coords, xpos, y_coords, ypos, _i, _j, _k, _len, _len1, _len2, _ref, _ref1;
      GridPlotView.__super__.render.call(this);
      _ref = _.values(this.childviews);
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        view = _ref[_i];
        view.$el.detach();
      }
      this.$el.html('');
      this.addGridToolbar();
      row_heights = this.viewstate.get('layout_heights');
      col_widths = this.viewstate.get('layout_widths');
      y_coords = [0];
      _.reduceRight(row_heights.slice(1), function(x, y) {
        var val;
        val = x + y;
        y_coords.push(val);
        return val;
      }, 0);
      y_coords.reverse();
      x_coords = [0];
      _.reduce(col_widths.slice(0), function(x, y) {
        var val;
        val = x + y;
        x_coords.push(val);
        return val;
      }, 0);
      plot_divs = [];
      last_plot = null;
      _ref1 = this.mget('children');
      for (ridx = _j = 0, _len1 = _ref1.length; _j < _len1; ridx = ++_j) {
        row = _ref1[ridx];
        for (cidx = _k = 0, _len2 = row.length; _k < _len2; cidx = ++_k) {
          plotspec = row[cidx];
          view = this.childviews[plotspec.id];
          ypos = this.viewstate.position_child_y(y_coords[ridx], view.view_state.get('outer_height') - this.toolbar_height);
          xpos = this.viewstate.position_child_x(x_coords[cidx], view.view_state.get('outer_width'));
          plot_wrapper = $("<div class='gp_plotwrapper'></div>");
          plot_wrapper.attr('style', "position: absolute; left:" + xpos + "px; top:" + ypos + "px");
          plot_wrapper.append(view.$el);
          this.$el.append(plot_wrapper);
        }
      }
      add = function(a, b) {
        return a + b;
      };
      total_height = _.reduce(row_heights, add, 0);
      height = total_height + this.toolbar_height;
      width = this.viewstate.get('outerwidth');
      this.$el.attr('style', "position:relative; height:" + height + "px;width:" + width + "px");
      return this.render_end();
    };

    return GridPlotView;

  })(ContinuumView);

  GridPlot = (function(_super) {

    __extends(GridPlot, _super);

    function GridPlot() {
      return GridPlot.__super__.constructor.apply(this, arguments);
    }

    GridPlot.prototype.type = 'GridPlot';

    GridPlot.prototype.default_view = GridPlotView;

    return GridPlot;

  })(HasParent);

  GridPlot.prototype.defaults = _.clone(GridPlot.prototype.defaults);

  _.extend(GridPlot.prototype.defaults, {
    children: [[]],
    border_space: 0
  });

  GridPlots = (function(_super) {

    __extends(GridPlots, _super);

    function GridPlots() {
      return GridPlots.__super__.constructor.apply(this, arguments);
    }

    GridPlots.prototype.model = GridPlot;

    return GridPlots;

  })(Backbone.Collection);

  exports.GridPlot = GridPlot;

  exports.GridPlotView = GridPlotView;

  exports.gridplots = new GridPlots;

}).call(this);
}, "common/grid_view_state": function(exports, require, module) {(function() {
  var GridViewState, ViewState, base, safebind,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require("../base");

  safebind = base.safebind;

  ViewState = require('./view_state').ViewState;

  GridViewState = (function(_super) {

    __extends(GridViewState, _super);

    function GridViewState() {
      this.layout_widths = __bind(this.layout_widths, this);

      this.layout_heights = __bind(this.layout_heights, this);

      this.setup_layout_properties = __bind(this.setup_layout_properties, this);
      return GridViewState.__super__.constructor.apply(this, arguments);
    }

    GridViewState.prototype.setup_layout_properties = function() {
      var row, viewstate, _i, _len, _ref, _results;
      this.register_property('layout_heights', this.layout_heights, true);
      this.register_property('layout_widths', this.layout_widths, true);
      _ref = this.get('childviewstates');
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        row = _ref[_i];
        _results.push((function() {
          var _j, _len1, _results1;
          _results1 = [];
          for (_j = 0, _len1 = row.length; _j < _len1; _j++) {
            viewstate = row[_j];
            this.add_dependencies('layout_heights', viewstate, 'outer_height');
            _results1.push(this.add_dependencies('layout_widths', viewstate, 'outer_width'));
          }
          return _results1;
        }).call(this));
      }
      return _results;
    };

    GridViewState.prototype.initialize = function(attrs, options) {
      GridViewState.__super__.initialize.call(this, attrs, options);
      this.setup_layout_properties();
      safebind(this, this, 'change:childviewstates', this.setup_layout_properties);
      this.register_property('height', function() {
        return _.reduce(this.get('layout_heights'), (function(x, y) {
          return x + y;
        }), 0);
      }, true);
      this.add_dependencies('height', this, 'layout_heights');
      this.register_property('width', function() {
        return _.reduce(this.get('layout_widths'), (function(x, y) {
          return x + y;
        }), 0);
      }, true);
      return this.add_dependencies('width', this, 'layout_widths');
    };

    GridViewState.prototype.position_child_x = function(offset, childsize) {
      return offset;
    };

    GridViewState.prototype.position_child_y = function(offset, childsize) {
      return this.get('height') - offset - childsize;
    };

    GridViewState.prototype.maxdim = function(dim, row) {
      if (row.length === 0) {
        return 0;
      } else {
        return _.max(_.map(row, (function(x) {
          return x.get(dim);
        })));
      }
    };

    GridViewState.prototype.layout_heights = function() {
      var row, row_heights;
      row_heights = (function() {
        var _i, _len, _ref, _results;
        _ref = this.get('childviewstates');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          row = _ref[_i];
          _results.push(this.maxdim('outer_height', row));
        }
        return _results;
      }).call(this);
      return row_heights;
    };

    GridViewState.prototype.layout_widths = function() {
      var col, col_widths, columns, n, num_cols, row;
      num_cols = this.get('childviewstates')[0].length;
      columns = (function() {
        var _i, _len, _ref, _results;
        _ref = _.range(num_cols);
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          n = _ref[_i];
          _results.push((function() {
            var _j, _len1, _ref1, _results1;
            _ref1 = this.get('childviewstates');
            _results1 = [];
            for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
              row = _ref1[_j];
              _results1.push(row[n]);
            }
            return _results1;
          }).call(this));
        }
        return _results;
      }).call(this);
      col_widths = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = columns.length; _i < _len; _i++) {
          col = columns[_i];
          _results.push(this.maxdim('outer_width', col));
        }
        return _results;
      }).call(this);
      return col_widths;
    };

    return GridViewState;

  })(ViewState);

  GridViewState.prototype.defaults = _.clone(GridViewState.prototype.defaults);

  _.extend(GridViewState.prototype.defaults, {
    childviewstates: [[]],
    border_space: 0
  });

  exports.GridViewState = GridViewState;

}).call(this);
}, "common/plot": function(exports, require, module) {(function() {
  var ActiveToolManager, Collections, ContinuumView, GridMapper, HasParent, LEVELS, LinearMapper, PNGView, Plot, PlotView, Plots, ViewState, base, build_views, delayAnimation, properties, safebind, text_properties, throttleAnimation,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../base');

  Collections = base.Collections;

  HasParent = base.HasParent;

  safebind = base.safebind;

  build_views = base.build_views;

  properties = require('../renderers/properties');

  text_properties = properties.text_properties;

  ContinuumView = require('./continuum_view').ContinuumView;

  LinearMapper = require('../mappers/1d/linear_mapper').LinearMapper;

  GridMapper = require('../mappers/2d/grid_mapper').GridMapper;

  ViewState = require('./view_state').ViewState;

  ActiveToolManager = require("../tools/active_tool_manager").ActiveToolManager;

  LEVELS = ['image', 'underlay', 'glyph', 'overlay', 'annotation', 'tool'];

  delayAnimation = function(f) {
    return f();
  };

  delayAnimation = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame || delayAnimation;

  throttleAnimation = function(func, wait) {
    var args, context, later, pending, previous, result, timeout, _ref;
    _ref = [null, null, null, null], context = _ref[0], args = _ref[1], timeout = _ref[2], result = _ref[3];
    previous = 0;
    pending = false;
    later = function() {
      previous = new Date;
      timeout = null;
      pending = false;
      return result = func.apply(context, args);
    };
    return function() {
      var now, remaining;
      now = new Date;
      remaining = wait - (now - previous);
      context = this;
      args = arguments;
      if (remaining <= 0 && !pending) {
        clearTimeout(timeout);
        pending = true;
        delayAnimation(later);
      } else if (!timeout) {
        timeout = setTimeout((function() {
          return delayAnimation(later);
        }), remaining);
      }
      return result;
    };
  };

  PlotView = (function(_super) {

    __extends(PlotView, _super);

    function PlotView() {
      this._mousemove = __bind(this._mousemove, this);

      this._mousedown = __bind(this._mousedown, this);
      return PlotView.__super__.constructor.apply(this, arguments);
    }

    PlotView.prototype.className = "bokeh plotview";

    PlotView.prototype.events = {
      "mousemove .bokeh_canvas_wrapper": "_mousemove",
      "mousedown .bokeh_canvas_wrapper": "_mousedown"
    };

    PlotView.prototype.view_options = function() {
      return _.extend({
        plot_model: this.model,
        plot_view: this
      }, this.options);
    };

    PlotView.prototype._mousedown = function(e) {
      var f, _i, _len, _ref, _results;
      _ref = this.mousedownCallbacks;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        f = _ref[_i];
        _results.push(f(e, e.layerX, e.layerY));
      }
      return _results;
    };

    PlotView.prototype._mousemove = function(e) {
      var f, _i, _len, _ref, _results;
      _ref = this.moveCallbacks;
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        f = _ref[_i];
        _results.push(f(e, e.layerX, e.layerY));
      }
      return _results;
    };

    PlotView.prototype.pause = function() {
      return this.is_paused = true;
    };

    PlotView.prototype.unpause = function(render_canvas) {
      if (render_canvas == null) {
        render_canvas = false;
      }
      this.is_paused = false;
      if (render_canvas) {
        return this.request_render_canvas(true);
      } else {
        return this.request_render();
      }
    };

    PlotView.prototype.request_render = function() {
      if (!this.is_paused) {
        this.throttled_render();
      }
    };

    PlotView.prototype.request_render_canvas = function(full_render) {
      if (!this.is_paused) {
        this.throttled_render_canvas(full_render);
      }
    };

    PlotView.prototype.initialize = function(options) {
      var level, _i, _len, _ref, _ref1, _ref10, _ref11, _ref12, _ref13, _ref14, _ref15, _ref16, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7, _ref8, _ref9;
      PlotView.__super__.initialize.call(this, _.defaults(options, this.default_options));
      this.throttled_render = throttleAnimation(this.render, 15);
      this.throttled_render_canvas = throttleAnimation(this.render_canvas, 15);
      this.title_props = new text_properties(this, {}, 'title_');
      this.view_state = new ViewState({
        canvas_width: (_ref = options.canvas_width) != null ? _ref : this.mget('canvas_width'),
        canvas_height: (_ref1 = options.canvas_height) != null ? _ref1 : this.mget('canvas_height'),
        x_offset: (_ref2 = options.x_offset) != null ? _ref2 : this.mget('x_offset'),
        y_offset: (_ref3 = options.y_offset) != null ? _ref3 : this.mget('y_offset'),
        outer_width: (_ref4 = options.outer_width) != null ? _ref4 : this.mget('outer_width'),
        outer_height: (_ref5 = options.outer_height) != null ? _ref5 : this.mget('outer_height'),
        min_border_top: (_ref6 = (_ref7 = options.min_border_top) != null ? _ref7 : this.mget('min_border_top')) != null ? _ref6 : this.mget('min_border'),
        min_border_bottom: (_ref8 = (_ref9 = options.min_border_bottom) != null ? _ref9 : this.mget('min_border_bottom')) != null ? _ref8 : this.mget('min_border'),
        min_border_left: (_ref10 = (_ref11 = options.min_border_left) != null ? _ref11 : this.mget('min_border_left')) != null ? _ref10 : this.mget('min_border'),
        min_border_right: (_ref12 = (_ref13 = options.min_border_right) != null ? _ref13 : this.mget('min_border_right')) != null ? _ref12 : this.mget('min_border'),
        requested_border_top: 0,
        requested_border_bottom: 0,
        requested_border_left: 0,
        requested_border_right: 0
      });
      this.hidpi = (_ref14 = options.hidpi) != null ? _ref14 : this.mget('hidpi');
      this.x_range = (_ref15 = options.x_range) != null ? _ref15 : this.mget_obj('x_range');
      this.y_range = (_ref16 = options.y_range) != null ? _ref16 : this.mget_obj('y_range');
      this.xmapper = new LinearMapper({
        source_range: this.x_range,
        target_range: this.view_state.get('inner_range_horizontal')
      });
      this.ymapper = new LinearMapper({
        source_range: this.y_range,
        target_range: this.view_state.get('inner_range_vertical')
      });
      this.mapper = new GridMapper({
        domain_mapper: this.xmapper,
        codomain_mapper: this.ymapper
      });
      this.requested_padding = {
        top: 0,
        bottom: 0,
        left: 0,
        right: 0
      };
      this.old_mapper_state = {
        x: null,
        y: null
      };
      this.am_rendering = false;
      this.renderers = {};
      this.tools = {};
      this.eventSink = _.extend({}, Backbone.Events);
      this.moveCallbacks = [];
      this.mousedownCallbacks = [];
      this.keydownCallbacks = [];
      this.render_init();
      this.render_canvas(false);
      this.atm = new ActiveToolManager(this.eventSink);
      this.levels = {};
      for (_i = 0, _len = LEVELS.length; _i < _len; _i++) {
        level = LEVELS[_i];
        this.levels[level] = {};
      }
      this.build_levels();
      this.request_render();
      this.atm.bind_bokeh_events();
      this.bind_bokeh_events();
      return this;
    };

    PlotView.prototype.map_to_screen = function(x, x_units, y, y_units, units) {
      var sx, sy, _ref;
      if (x_units === 'screen') {
        if (_.isArray(x)) {
          sx = x.slice(0);
        } else {
          sx = new Float32Array(x.length);
          sx.set(x);
        }
        if (_.isArray(y)) {
          sy = y.slice(0);
        } else {
          sy = new Float32Array(y.length);
          sy.set(y);
        }
      } else {
        _ref = this.mapper.v_map_to_target(x, y), sx = _ref[0], sy = _ref[1];
      }
      sx = this.view_state.v_sx_to_device(sx);
      sy = this.view_state.v_sy_to_device(sy);
      return [sx, sy];
    };

    PlotView.prototype.map_from_screen = function(sx, sy, units) {
      var dx, dy, x, y, _ref;
      if (_.isArray(sx)) {
        dx = x.slice(0);
      } else {
        dx = new Float32Array(sx.length);
        sd.set(x);
      }
      if (_.isArray(sy)) {
        dy = y.slice(0);
      } else {
        dy = new Float32Array(sy.length);
        dy.set(y);
      }
      sx = this.view_state.v_device_to_sx(dx);
      sy = this.view_state.v_device_to_sy(dy);
      if (units === 'screen') {
        x = sx;
        y = sy;
      } else {
        _ref = this.mapper.v_map_from_target(sx, sy), x = _ref[0], y = _ref[1];
      }
      return [x, y];
    };

    PlotView.prototype.update_range = function(range_info) {
      this.pause();
      this.x_range.set(range_info.xr);
      this.y_range.set(range_info.yr);
      return this.unpause();
    };

    PlotView.prototype.build_tools = function() {
      return build_views(this.tools, this.mget_obj('tools'), this.view_options());
    };

    PlotView.prototype.build_views = function() {
      return build_views(this.renderers, this.mget_obj('renderers'), this.view_options());
    };

    PlotView.prototype.build_levels = function() {
      var level, t, tools, v, views, _i, _j, _len, _len1;
      views = this.build_views();
      tools = this.build_tools();
      for (_i = 0, _len = views.length; _i < _len; _i++) {
        v = views[_i];
        level = v.mget('level');
        this.levels[level][v.model.id] = v;
        v.bind_bokeh_events();
      }
      for (_j = 0, _len1 = tools.length; _j < _len1; _j++) {
        t = tools[_j];
        level = t.mget('level');
        this.levels[level][t.model.id] = t;
        t.bind_bokeh_events();
      }
      return this;
    };

    PlotView.prototype.bind_bokeh_events = function() {
      var _this = this;
      safebind(this, this.view_state, 'change', function() {
        _this.request_render_canvas();
        return _this.request_render();
      });
      safebind(this, this.x_range, 'change', this.request_render);
      safebind(this, this.y_range, 'change', this.request_render);
      safebind(this, this.model, 'change:renderers', this.build_levels);
      safebind(this, this.model, 'change:tool', this.build_levels);
      safebind(this, this.model, 'change', this.request_render);
      return safebind(this, this.model, 'destroy', function() {
        return _this.remove();
      });
    };

    PlotView.prototype.render_init = function() {
      this.$el.append($("<div class='button_bar btn-group pull-top'/>\n<div class='plotarea'>\n<div class='bokeh_canvas_wrapper'>\n  <canvas class='bokeh_canvas'></canvas>\n</div>\n</div>"));
      this.button_bar = this.$el.find('.button_bar');
      this.canvas_wrapper = this.$el.find('.bokeh_canvas_wrapper');
      return this.canvas = this.$el.find('canvas.bokeh_canvas');
    };

    PlotView.prototype.render_canvas = function(full_render) {
      var backingStoreRatio, devicePixelRatio, oh, ow, ratio;
      if (full_render == null) {
        full_render = true;
      }
      this.ctx = this.canvas[0].getContext('2d');
      if (this.hidpi) {
        devicePixelRatio = window.devicePixelRatio || 1;
        backingStoreRatio = this.ctx.webkitBackingStorePixelRatio || this.ctx.mozBackingStorePixelRatio || this.ctx.msBackingStorePixelRatio || this.ctx.oBackingStorePixelRatio || this.ctx.backingStorePixelRatio || 1;
        ratio = devicePixelRatio / backingStoreRatio;
      } else {
        ratio = 1;
      }
      ow = this.view_state.get('outer_width');
      oh = this.view_state.get('outer_height');
      this.canvas.width = ow * ratio;
      this.canvas.height = oh * ratio;
      this.button_bar.attr('style', "width:" + ow + "px;");
      this.canvas_wrapper.attr('style', "width:" + ow + "px; height:" + oh + "px");
      this.canvas.attr('style', "width:" + ow + "px;");
      this.canvas.attr('style', "height:" + oh + "px;");
      this.canvas.attr('width', ow * ratio).attr('height', oh * ratio);
      this.$el.attr("width", ow).attr('height', oh);
      this.ctx.scale(ratio, ratio);
      this.ctx.translate(0.5, 0.5);
      if (full_render) {
        return this.render();
      }
    };

    PlotView.prototype.save_png = function() {
      var data_uri;
      this.render();
      data_uri = this.canvas[0].toDataURL();
      this.model.set('png', this.canvas[0].toDataURL());
      return base.Collections.bulksave([this.model]);
    };

    PlotView.prototype.render = function(force) {
      var have_new_mapper_state, hpadding, k, level, pr, renderers, sx, sy, sym, th, title, v, xms, yms, _i, _j, _k, _len, _len1, _len2, _ref, _ref1, _ref2, _ref3;
      PlotView.__super__.render.call(this);
      this.requested_padding = {
        top: 0,
        bottom: 0,
        left: 0,
        right: 0
      };
      _ref = ['image', 'underlay', 'glyph', 'overlay', 'annotation', 'tool'];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        level = _ref[_i];
        renderers = this.levels[level];
        for (k in renderers) {
          v = renderers[k];
          if (v.padding_request != null) {
            pr = v.padding_request();
            for (k in pr) {
              v = pr[k];
              this.requested_padding[k] += v;
            }
          }
        }
      }
      title = this.mget('title');
      if (title) {
        this.title_props.set(this.ctx, {});
        th = this.ctx.measureText(this.mget('title')).ascent;
        this.requested_padding['top'] += th + this.mget('title_standoff');
      }
      sym = this.mget('border_symmetry');
      if (sym.indexOf('h') >= 0 || sym.indexOf('H') >= 0) {
        hpadding = Math.max(this.requested_padding['left'], this.requested_padding['right']);
        this.requested_padding['left'] = hpadding;
        this.requested_padding['right'] = hpadding;
      }
      if (sym.indexOf('v') >= 0 || sym.indexOf('V') >= 0) {
        hpadding = Math.max(this.requested_padding['top'], this.requested_padding['bottom']);
        this.requested_padding['top'] = hpadding;
        this.requested_padding['bottom'] = hpadding;
      }
      this.is_paused = true;
      _ref1 = this.requested_padding;
      for (k in _ref1) {
        v = _ref1[k];
        this.view_state.set("requested_border_" + k, v);
      }
      this.is_paused = false;
      this.ctx.fillStyle = this.mget('border_fill');
      this.ctx.fillRect(0, 0, this.view_state.get('canvas_width'), this.view_state.get('canvas_height'));
      this.ctx.fillStyle = this.mget('background_fill');
      this.ctx.fillRect(this.view_state.get('border_left'), this.view_state.get('border_top'), this.view_state.get('inner_width'), this.view_state.get('inner_height'));
      have_new_mapper_state = false;
      xms = this.xmapper.get('mapper_state')[0];
      yms = this.ymapper.get('mapper_state')[0];
      if (Math.abs(this.old_mapper_state.x - xms) > 1e-8 || Math.abs(this.old_mapper_state.y - yms) > 1e-8) {
        this.old_mapper_state.x = xms;
        this.old_mapper_state.y = yms;
        have_new_mapper_state = true;
      }
      this.ctx.save();
      this.ctx.beginPath();
      this.ctx.rect(this.view_state.get('border_left'), this.view_state.get('border_top'), this.view_state.get('inner_width'), this.view_state.get('inner_height'));
      this.ctx.clip();
      this.ctx.beginPath();
      _ref2 = ['image', 'underlay', 'glyph'];
      for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
        level = _ref2[_j];
        renderers = this.levels[level];
        for (k in renderers) {
          v = renderers[k];
          v.render(have_new_mapper_state);
        }
      }
      this.ctx.restore();
      _ref3 = ['overlay', 'annotation', 'tool'];
      for (_k = 0, _len2 = _ref3.length; _k < _len2; _k++) {
        level = _ref3[_k];
        renderers = this.levels[level];
        for (k in renderers) {
          v = renderers[k];
          v.render(have_new_mapper_state);
        }
      }
      if (title) {
        sx = this.view_state.get('outer_width') / 2;
        sy = th;
        this.title_props.set(this.ctx, {});
        return this.ctx.fillText(title, sx, sy);
      }
    };

    return PlotView;

  })(ContinuumView);

  PNGView = (function(_super) {

    __extends(PNGView, _super);

    function PNGView() {
      return PNGView.__super__.constructor.apply(this, arguments);
    }

    PNGView.prototype.initialize = function(options) {
      PNGView.__super__.initialize.call(this, options);
      this.thumb_x = options.thumb_x || 40;
      this.thumb_y = options.thumb_y || 40;
      this.render();
      return this;
    };

    PNGView.prototype.render = function() {
      var png;
      this.$el.html('');
      png = this.model.get('png');
      this.$el.append($("<p> " + (this.model.get('title')) + " </p>"));
      return this.$el.append($("<img  modeltype='" + this.model.type + "' modelid='" + (this.model.get('id')) + "' class='pngview' width='" + this.thumb_x + "'  height='" + this.thumb_y + "'  src='" + png + "'/>"));
    };

    return PNGView;

  })(ContinuumView);

  Plot = (function(_super) {

    __extends(Plot, _super);

    function Plot() {
      return Plot.__super__.constructor.apply(this, arguments);
    }

    Plot.prototype.type = 'Plot';

    Plot.prototype.default_view = PlotView;

    Plot.prototype.add_renderers = function(new_renderers) {
      var renderers;
      renderers = this.get('renderers');
      renderers = renderers.concat(new_renderers);
      return this.set('renderers', renderers);
    };

    Plot.prototype.parent_properties = ['background_fill', 'border_fill', 'canvas_width', 'canvas_height', 'outer_width', 'outer_height', 'min_border', 'min_border_top', 'min_border_bottom', 'min_border_left', 'min_border_right'];

    return Plot;

  })(HasParent);

  Plot.prototype.defaults = _.clone(Plot.prototype.defaults);

  _.extend(Plot.prototype.defaults, {
    'data_sources': {},
    'renderers': [],
    'tools': [],
    'title': 'Plot'
  });

  Plot.prototype.display_defaults = _.clone(Plot.prototype.display_defaults);

  _.extend(Plot.prototype.display_defaults, {
    hidpi: true,
    background_fill: "#fff",
    border_fill: "#eee",
    border_symmetry: "h",
    min_border: 40,
    x_offset: 0,
    y_offset: 0,
    canvas_width: 300,
    canvas_height: 300,
    outer_width: 300,
    outer_height: 300,
    title_standoff: 8,
    title_text_font: "helvetica",
    title_text_font_size: "20pt",
    title_text_font_style: "normal",
    title_text_color: "#444444",
    title_text_alpha: 1.0,
    title_text_align: "center",
    title_text_baseline: "alphabetic"
  });

  Plots = (function(_super) {

    __extends(Plots, _super);

    function Plots() {
      return Plots.__super__.constructor.apply(this, arguments);
    }

    Plots.prototype.model = Plot;

    return Plots;

  })(Backbone.Collection);

  exports.Plot = Plot;

  exports.PlotView = PlotView;

  exports.PNGView = PNGView;

  exports.plots = new Plots;

  window.exercise_panning = function() {
    var end_time, start_time;
    start_time = new Date();
    _.delay((function() {
      return plot10.update_range({
        sdx: 1,
        sdy: 2,
        xr: {
          end: 10,
          start: 0
        },
        yr: {
          start: -3,
          end: 70
        }
      });
    }), 200);
    _.delay((function() {
      return plot10.update_range({
        sdx: 1,
        sdy: 2,
        xr: {
          end: 10,
          start: 0
        },
        yr: {
          start: -3,
          end: 30
        }
      });
    }), 400);
    _.delay((function() {
      return plot10.update_range({
        sdx: 1,
        sdy: 2,
        xr: {
          end: 20,
          start: 0
        },
        yr: {
          start: -3,
          end: 30
        }
      });
    }), 600);
    end_time = new Date();
    return console.log(end_time - start_time, "ms");
  };

}).call(this);
}, "common/plot_context": function(exports, require, module) {(function() {
  var ContinuumView, HasParent, HasProperties, PNGContextView, PNGView, PlotContext, PlotContextView, PlotContextViewState, PlotContextViewWithMaximized, PlotContexts, PlotList, PlotLists, PlotView, base, build_views, safebind,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require("../base");

  PNGView = require("./plot").PNGView;

  PlotView = require("./plot").PlotView;

  HasParent = base.HasParent;

  HasProperties = base.HasProperties;

  safebind = base.safebind;

  build_views = base.build_views;

  ContinuumView = require('./continuum_view').ContinuumView;

  PlotContextView = (function(_super) {

    __extends(PlotContextView, _super);

    function PlotContextView() {
      this.removeplot = __bind(this.removeplot, this);

      this.closeall = __bind(this.closeall, this);
      return PlotContextView.__super__.constructor.apply(this, arguments);
    }

    PlotContextView.prototype.initialize = function(options) {
      this.views = {};
      this.views_rendered = [false];
      this.child_models = [];
      PlotContextView.__super__.initialize.call(this, options);
      return this.render();
    };

    PlotContextView.prototype.delegateEvents = function() {
      safebind(this, this.model, 'destroy', this.remove);
      safebind(this, this.model, 'change', this.render);
      return PlotContextView.__super__.delegateEvents.call(this);
    };

    PlotContextView.prototype.build_children = function() {
      var created_views;
      created_views = build_views(this.views, this.mget_obj('children'), {});
      window.pc_created_views = created_views;
      window.pc_views = this.views;
      return null;
    };

    PlotContextView.prototype.events = {
      'click .plotclose': 'removeplot',
      'click .closeall': 'closeall'
    };

    PlotContextView.prototype.size_textarea = function(textarea) {
      var scrollHeight;
      scrollHeight = $(textarea).height(0).prop('scrollHeight');
      return $(textarea).height(scrollHeight);
    };

    PlotContextView.prototype.closeall = function(e) {
      this.mset('children', []);
      return this.model.save();
    };

    PlotContextView.prototype.removeplot = function(e) {
      var newchildren, plotnum, s_pc, view, x;
      plotnum = parseInt($(e.currentTarget).parent().attr('data-plot_num'));
      s_pc = this.model.resolve_ref(this.mget('children')[plotnum]);
      view = this.views[s_pc.get('id')];
      view.remove();
      newchildren = (function() {
        var _i, _len, _ref, _results;
        _ref = this.mget('children');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          x = _ref[_i];
          if (x.id !== view.model.id) {
            _results.push(x);
          }
        }
        return _results;
      }).call(this);
      this.mset('children', newchildren);
      this.model.save();
      return false;
    };

    PlotContextView.prototype.render = function() {
      var index, key, modelref, node, numplots, tab_names, to_render, val, view, _i, _len, _ref, _ref1,
        _this = this;
      PlotContextView.__super__.render.call(this);
      this.build_children();
      _ref = this.views;
      for (key in _ref) {
        if (!__hasProp.call(_ref, key)) continue;
        val = _ref[key];
        val.$el.detach();
      }
      this.$el.html('');
      numplots = _.keys(this.views).length;
      this.$el.append("<div>You have " + numplots + " plots</div>");
      this.$el.append("<div><a class='closeall' href='#'>Close All Plots</a></div>");
      this.$el.append("<br/>");
      to_render = [];
      tab_names = {};
      _ref1 = this.mget('children');
      for (index = _i = 0, _len = _ref1.length; _i < _len; index = ++_i) {
        modelref = _ref1[index];
        view = this.views[modelref.id];
        node = $("<div class='jsp' data-plot_num='" + index + "'></div>");
        this.$el.append(node);
        node.append($("<a class='plotclose'>[close]</a>"));
        node.append(view.el);
      }
      _.defer(function() {
        var textarea, _j, _len1, _ref2, _results;
        _ref2 = _this.$el.find('.plottitle');
        _results = [];
        for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
          textarea = _ref2[_j];
          _results.push(_this.size_textarea($(textarea)));
        }
        return _results;
      });
      return null;
    };

    return PlotContextView;

  })(ContinuumView);

  PNGContextView = (function(_super) {

    __extends(PNGContextView, _super);

    function PNGContextView() {
      this.pngclick = __bind(this.pngclick, this);
      return PNGContextView.__super__.constructor.apply(this, arguments);
    }

    PNGContextView.prototype.initialize = function(options) {
      this.thumb_x = options.thumb_x;
      this.thumb_y = options.thumb_y;
      this.views = {};
      this.views_rendered = [false];
      this.child_models = [];
      PNGContextView.__super__.initialize.call(this, options);
      return this.render();
    };

    PNGContextView.prototype.pngclick = function(e) {
      var modelid, modeltype;
      modeltype = $(e.currentTarget).attr('modeltype');
      modelid = $(e.currentTarget).attr('modelid');
      return this.trigger('showplot', {
        type: modeltype,
        id: modelid
      });
    };

    PNGContextView.prototype.delegateEvents = function() {
      safebind(this, this.model, 'destroy', this.remove);
      safebind(this, this.model, 'change', this.render);
      return PNGContextView.__super__.delegateEvents.call(this);
    };

    PNGContextView.prototype.build_children = function() {
      var created_views, pv, view_classes, view_model, _i, _len, _ref;
      view_classes = [];
      _ref = this.mget_obj('children');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        view_model = _ref[_i];
        if (!view_model.get('png')) {
          console.log("no png for " + view_model.id + " making one");
          pv = new view_model.default_view({
            model: view_model
          });
          pv.save_png();
        }
        view_classes.push(PNGView);
      }
      created_views = build_views(this.views, this.mget_obj('children'), {
        thumb_x: this.thumb_x,
        thumb_y: this.thumby
      }, view_classes);
      window.pc_created_views = created_views;
      window.pc_views = this.views;
      return null;
    };

    PNGContextView.prototype.events = {
      'click .plotclose': 'removeplot',
      'click .closeall': 'closeall',
      'click .pngview': 'pngclick'
    };

    return PNGContextView;

  })(PlotContextView);

  PlotContextViewState = (function(_super) {

    __extends(PlotContextViewState, _super);

    function PlotContextViewState() {
      return PlotContextViewState.__super__.constructor.apply(this, arguments);
    }

    PlotContextViewState.prototype.defaults = {
      maxheight: 600,
      maxwidth: 600,
      selected: 0
    };

    return PlotContextViewState;

  })(HasProperties);

  PlotContextViewWithMaximized = (function(_super) {

    __extends(PlotContextViewWithMaximized, _super);

    function PlotContextViewWithMaximized() {
      return PlotContextViewWithMaximized.__super__.constructor.apply(this, arguments);
    }

    PlotContextViewWithMaximized.prototype.initialize = function(options) {
      var _this = this;
      this.selected = 0;
      this.viewstate = new PlotContextViewState({
        maxheight: options.maxheight,
        maxwidth: options.maxwidth
      });
      PlotContextViewWithMaximized.__super__.initialize.call(this, options);
      safebind(this, this.viewstate, 'change', this.render);
      return safebind(this, this.model, 'change:children', function() {
        var selected;
        selected = _this.viewstate.get('selected');
        if (selected > _this.model.get('children') - 1) {
          return _this.viewstate.set('selected', 0);
        }
      });
    };

    PlotContextViewWithMaximized.prototype.events = {
      'click .maximize': 'maximize',
      'click .plotclose': 'removeplot',
      'click .closeall': 'closeall',
      'keydown .plottitle': 'savetitle'
    };

    PlotContextViewWithMaximized.prototype.maximize = function(e) {
      var plotnum;
      plotnum = parseInt($(e.currentTarget).parent().attr('data-plot_num'));
      return this.viewstate.set('selected', plotnum);
    };

    PlotContextViewWithMaximized.prototype.render = function() {
      var index, key, main, model, modelref, node, tab_names, title, to_render, val, view, _i, _len, _ref, _ref1,
        _this = this;
      PlotContextViewWithMaximized.__super__.render.call(this);
      this.build_children();
      _ref = this.views;
      for (key in _ref) {
        if (!__hasProp.call(_ref, key)) continue;
        val = _ref[key];
        val.$el.detach();
      }
      this.$el.html('');
      main = $("<div class='plotsidebar'><div>");
      this.$el.append(main);
      this.$el.append("<div class='maxplot'>");
      main.append("<div><a class='closeall' href='#'>Close All Plots</a></div>");
      main.append("<br/>");
      to_render = [];
      tab_names = {};
      _ref1 = this.mget('children');
      for (index = _i = 0, _len = _ref1.length; _i < _len; index = ++_i) {
        modelref = _ref1[index];
        view = this.views[modelref.id];
        node = $("<div class='jsp' data-plot_num='" + index + "'></div>");
        main.append(node);
        title = view.model.get('title');
        node.append($("<textarea class='plottitle'>" + title + "</textarea>"));
        node.append($("<a class='maximize'>[max]</a>"));
        node.append($("<a class='plotclose'>[close]</a>"));
        node.append(view.el);
      }
      if (this.mget('children').length > 0) {
        modelref = this.mget('children')[this.viewstate.get('selected')];
        model = this.model.resolve_ref(modelref);
        this.maxview = new model.default_view({
          model: model
        });
        this.$el.find('.maxplot').append(this.maxview.$el);
      } else {
        this.maxview = null;
      }
      _.defer(function() {
        var height, heightratio, maxheight, maxwidth, newheight, newwidth, ratio, textarea, width, widthratio, _j, _len1, _ref2;
        _ref2 = main.find('.plottitle');
        for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
          textarea = _ref2[_j];
          _this.size_textarea($(textarea));
        }
        if (_this.maxview) {
          width = model.get('width');
          height = model.get('height');
          maxwidth = _this.viewstate.get('maxwidth');
          maxheight = _this.viewstate.get('maxheight');
          widthratio = maxwidth / width;
          heightratio = maxheight / height;
          ratio = _.min([widthratio, heightratio]);
          newwidth = ratio * width;
          newheight = ratio * height;
          _this.maxview.viewstate.set('height', newheight);
          return _this.maxview.viewstate.set('width', newwidth);
        }
      });
      return null;
    };

    return PlotContextViewWithMaximized;

  })(PlotContextView);

  PlotContext = (function(_super) {

    __extends(PlotContext, _super);

    function PlotContext() {
      return PlotContext.__super__.constructor.apply(this, arguments);
    }

    PlotContext.prototype.type = 'PlotContext';

    PlotContext.prototype.default_view = PlotContextView;

    PlotContext.prototype.url = function() {
      return PlotContext.__super__.url.call(this);
    };

    PlotContext.prototype.defaults = {
      children: [],
      render_loop: true
    };

    return PlotContext;

  })(HasParent);

  PlotList = (function(_super) {

    __extends(PlotList, _super);

    function PlotList() {
      return PlotList.__super__.constructor.apply(this, arguments);
    }

    PlotList.prototype.type = 'PlotList';

    return PlotList;

  })(PlotContext);

  PlotContexts = (function(_super) {

    __extends(PlotContexts, _super);

    function PlotContexts() {
      return PlotContexts.__super__.constructor.apply(this, arguments);
    }

    PlotContexts.prototype.model = PlotContext;

    return PlotContexts;

  })(Backbone.Collection);

  PlotLists = (function(_super) {

    __extends(PlotLists, _super);

    function PlotLists() {
      return PlotLists.__super__.constructor.apply(this, arguments);
    }

    PlotLists.prototype.model = PlotList;

    return PlotLists;

  })(PlotContexts);

  exports.PlotContext = PlotContext;

  exports.PlotContexts = PlotContexts;

  exports.PlotContextView = PlotContextView;

  exports.PlotContextViewState = PlotContextViewState;

  exports.PlotContextViewWithMaximized = PlotContextViewWithMaximized;

  exports.plotlists = new PlotLists();

  exports.plotcontexts = new PlotContexts();

  exports.PNGContextView = PNGContextView;

}).call(this);
}, "common/plot_widget": function(exports, require, module) {(function() {
  var ContinuumView, PlotWidget, base, safebind,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../base');

  safebind = base.safebind;

  ContinuumView = require("./continuum_view").ContinuumView;

  PlotWidget = (function(_super) {

    __extends(PlotWidget, _super);

    function PlotWidget() {
      return PlotWidget.__super__.constructor.apply(this, arguments);
    }

    PlotWidget.prototype.tagName = 'div';

    PlotWidget.prototype.initialize = function(options) {
      this.plot_model = options.plot_model;
      this.plot_view = options.plot_view;
      this._fixup_line_dash(this.plot_view.ctx);
      this._fixup_line_dash_offset(this.plot_view.ctx);
      this._fixup_image_smoothing(this.plot_view.ctx);
      this._fixup_measure_text(this.plot_view.ctx);
      return PlotWidget.__super__.initialize.call(this, options);
    };

    PlotWidget.prototype._fixup_line_dash = function(ctx) {
      if (!ctx.setLineDash) {
        ctx.setLineDash = function(dash) {
          ctx.mozDash = dash;
          return ctx.webkitLineDash = dash;
        };
      }
      if (!ctx.getLineDash) {
        return ctx.getLineDash = function() {
          return ctx.mozDash;
        };
      }
    };

    PlotWidget.prototype._fixup_line_dash_offset = function(ctx) {
      return ctx.setLineDashOffset = function(dash_offset) {
        ctx.lineDashOffset = dash_offset;
        ctx.mozDashOffset = dash_offset;
        return ctx.webkitLineDashOffset = dash_offset;
      };
    };

    PlotWidget.prototype._fixup_image_smoothing = function(ctx) {
      ctx.setImageSmoothingEnabled = function(value) {
        ctx.imageSmoothingEnabled = value;
        ctx.mozImageSmoothingEnabled = value;
        ctx.oImageSmoothingEnabled = value;
        return ctx.webkitImageSmoothingEnabled = value;
      };
      return ctx.getImageSmoothingEnabled = function() {
        var _ref;
        return (_ref = ctx.imageSmoothingEnabled) != null ? _ref : true;
      };
    };

    PlotWidget.prototype._fixup_measure_text = function(ctx) {
      if (ctx.measureText && !(ctx.html5MeasureText != null)) {
        ctx.html5MeasureText = ctx.measureText;
        return ctx.measureText = memoize(function(text) {
          var textMetrics;
          textMetrics = ctx.html5MeasureText(text);
          textMetrics.ascent = ctx.html5MeasureText("m").width * 1.6;
          return textMetrics;
        });
      }
    };

    PlotWidget.prototype.bind_bokeh_events = function() {};

    PlotWidget.prototype.request_render = function() {
      return this.plot_view.request_render();
    };

    return PlotWidget;

  })(ContinuumView);

  exports.PlotWidget = PlotWidget;

}).call(this);
}, "common/random": function(exports, require, module) {(function() {
  var Rand;

  Rand = (function() {

    function Rand(seed) {
      this.seed = seed;
      this.multiplier = 1664525;
      this.modulo = 4294967296;
      this.offset = 1013904223;
      if (!((this.seed != null) && (0 <= seed && seed < this.modulo))) {
        this.seed = (new Date().valueOf() * new Date().getMilliseconds()) % this.modulo;
      }
    }

    Rand.prototype.seed = function(seed) {
      return this.seed = seed;
    };

    Rand.prototype.randn = function() {
      return this.seed = (this.multiplier * this.seed + this.offset) % this.modulo;
    };

    Rand.prototype.randf = function() {
      return this.randn() / this.modulo;
    };

    Rand.prototype.rand = function(n) {
      return Math.floor(this.randf() * n);
    };

    Rand.prototype.rand2 = function(min, max) {
      return min + this.rand(max - min);
    };

    return Rand;

  })();

  exports.Rand = Rand;

}).call(this);
}, "common/ranges": function(exports, require, module) {(function() {
  var DataFactorRange, DataFactorRanges, DataRange1d, DataRange1ds, FactorRange, FactorRanges, HasProperties, Range1d, Range1ds, base,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  base = require("../base");

  HasProperties = base.HasProperties;

  Range1d = (function(_super) {

    __extends(Range1d, _super);

    function Range1d() {
      return Range1d.__super__.constructor.apply(this, arguments);
    }

    Range1d.prototype.type = 'Range1d';

    Range1d.prototype.initialize = function(attrs, options) {
      Range1d.__super__.initialize.call(this, attrs, options);
      this.register_property('min', function() {
        return Math.min(this.get('start'), this.get('end'));
      }, true);
      this.add_dependencies('min', this, ['start', 'end']);
      this.register_property('max', function() {
        return Math.max(this.get('start'), this.get('end'));
      }, true);
      return this.add_dependencies('max', this, ['start', 'end']);
    };

    return Range1d;

  })(HasProperties);

  Range1d.prototype.defaults = _.clone(Range1d.prototype.defaults);

  _.extend(Range1d.prototype.defaults, {
    start: 0,
    end: 1
  });

  Range1ds = (function(_super) {

    __extends(Range1ds, _super);

    function Range1ds() {
      return Range1ds.__super__.constructor.apply(this, arguments);
    }

    Range1ds.prototype.model = Range1d;

    return Range1ds;

  })(Backbone.Collection);

  DataRange1d = (function(_super) {

    __extends(DataRange1d, _super);

    function DataRange1d() {
      return DataRange1d.__super__.constructor.apply(this, arguments);
    }

    DataRange1d.prototype.type = 'DataRange1d';

    DataRange1d.prototype._get_minmax = function() {
      var center, colname, columns, i, max, maxs, min, mins, source, sourceobj, span, _i, _j, _k, _len, _len1, _ref, _ref1, _ref2, _ref3, _ref4, _ref5;
      columns = [];
      _ref = this.get('sources');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        source = _ref[_i];
        sourceobj = this.resolve_ref(source['ref']);
        _ref1 = source['columns'];
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          colname = _ref1[_j];
          columns.push(sourceobj.getcolumn(colname));
        }
      }
      columns = _.reduce(columns, (function(x, y) {
        return x.concat(y);
      }), []);
      columns = _.filter(columns, function(x) {
        return typeof x !== "string";
      });
      if (!_.isArray(columns[0])) {
        columns = _.reject(columns, function(x) {
          return isNaN(x);
        });
        _ref2 = [_.min(columns), _.max(columns)], min = _ref2[0], max = _ref2[1];
      } else {
        maxs = Array(columns.length);
        mins = Array(columns.length);
        for (i = _k = 0, _ref3 = columns.length - 1; 0 <= _ref3 ? _k <= _ref3 : _k >= _ref3; i = 0 <= _ref3 ? ++_k : --_k) {
          columns[i] = _.reject(columns[i], function(x) {
            return isNaN(x);
          });
          maxs[i] = _.max(columns[i]);
          mins[i] = _.min(columns[i]);
        }
        _ref4 = [_.min(mins), _.max(maxs)], min = _ref4[0], max = _ref4[1];
      }
      if (max !== min) {
        span = (max - min) * (1 + this.get('rangepadding'));
      } else {
        span = max * (1 + this.get('rangepadding'));
      }
      center = (max + min) / 2.0;
      _ref5 = [center - span / 2.0, center + span / 2.0], min = _ref5[0], max = _ref5[1];
      return [min, max];
    };

    DataRange1d.prototype._get_start = function() {
      if (!_.isNullOrUndefined(this.get('_start'))) {
        return this.get('_start');
      } else {
        return this.get('minmax')[0];
      }
    };

    DataRange1d.prototype._set_start = function(start) {
      return this.set('_start', start);
    };

    DataRange1d.prototype._get_end = function() {
      if (!_.isNullOrUndefined(this.get('_end'))) {
        return this.get('_end');
      } else {
        return this.get('minmax')[1];
      }
    };

    DataRange1d.prototype._set_end = function(end) {
      return this.set('_end', end);
    };

    DataRange1d.prototype.dinitialize = function(attrs, options) {
      var source, _i, _len, _ref;
      this.register_property('minmax', this._get_minmax, true);
      this.add_dependencies('minmax', this, ['sources'], ['rangepadding']);
      _ref = this.get('sources');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        source = _ref[_i];
        source = this.resolve_ref(source.ref);
        this.add_dependencies('minmax', source, 'data');
      }
      this.register_property('start', this._get_start, true);
      this.register_setter('start', this._set_start);
      this.add_dependencies('start', this, ['minmax', '_start']);
      this.register_property('end', this._get_end, true);
      this.register_setter('end', this._set_end);
      this.add_dependencies('end', this, ['minmax', '_end']);
      return DataRange1d.__super__.dinitialize.call(this, attrs, options);
    };

    return DataRange1d;

  })(Range1d);

  DataRange1d.prototype.defaults = _.clone(DataRange1d.prototype.defaults);

  _.extend(DataRange1d.prototype.defaults, {
    sources: [],
    rangepadding: 0.1
  });

  DataRange1ds = (function(_super) {

    __extends(DataRange1ds, _super);

    function DataRange1ds() {
      return DataRange1ds.__super__.constructor.apply(this, arguments);
    }

    DataRange1ds.prototype.model = DataRange1d;

    return DataRange1ds;

  })(Backbone.Collection);

  Range1ds = (function(_super) {

    __extends(Range1ds, _super);

    function Range1ds() {
      return Range1ds.__super__.constructor.apply(this, arguments);
    }

    Range1ds.prototype.model = Range1d;

    return Range1ds;

  })(Backbone.Collection);

  FactorRange = (function(_super) {

    __extends(FactorRange, _super);

    function FactorRange() {
      return FactorRange.__super__.constructor.apply(this, arguments);
    }

    FactorRange.prototype.type = 'FactorRange';

    return FactorRange;

  })(HasProperties);

  FactorRange.prototype.defaults = _.clone(FactorRange.prototype.defaults);

  _.extend(FactorRange.prototype.defaults, {
    values: []
  });

  DataFactorRange = (function(_super) {

    __extends(DataFactorRange, _super);

    function DataFactorRange() {
      this._get_values = __bind(this._get_values, this);
      return DataFactorRange.__super__.constructor.apply(this, arguments);
    }

    DataFactorRange.prototype.type = 'DataFactorRange';

    DataFactorRange.prototype._get_values = function() {
      var columns, temp, uniques, val, x, _i, _len;
      columns = (function() {
        var _i, _len, _ref, _results;
        _ref = this.get('columns');
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          x = _ref[_i];
          _results.push(this.get_obj('data_source').getcolumn(x));
        }
        return _results;
      }).call(this);
      columns = _.reduce(columns, (function(x, y) {
        return x.concat(y);
      }), []);
      temp = {};
      for (_i = 0, _len = columns.length; _i < _len; _i++) {
        val = columns[_i];
        temp[val] = true;
      }
      uniques = _.keys(temp);
      uniques = _.sortBy(uniques, (function(x) {
        return x;
      }));
      return uniques;
    };

    DataFactorRange.prototype.dinitialize = function(attrs, options) {
      DataFactorRange.__super__.dinitialize.call(this, attrs, options);
      this.register_property;
      this.register_property('values', this._get_values, true);
      this.add_dependencies('values', this, ['data_source', 'columns']);
      return this.add_dependencies('values', this.get_obj('data_source'), ['data_source', 'columns']);
    };

    return DataFactorRange;

  })(FactorRange);

  DataFactorRange.prototype.defaults = _.clone(DataFactorRange.prototype.defaults);

  _.extend(DataFactorRange.prototype.defaults, {
    values: [],
    columns: [],
    data_source: null
  });

  DataFactorRanges = (function(_super) {

    __extends(DataFactorRanges, _super);

    function DataFactorRanges() {
      return DataFactorRanges.__super__.constructor.apply(this, arguments);
    }

    DataFactorRanges.prototype.model = DataFactorRange;

    return DataFactorRanges;

  })(Backbone.Collection);

  FactorRanges = (function(_super) {

    __extends(FactorRanges, _super);

    function FactorRanges() {
      return FactorRanges.__super__.constructor.apply(this, arguments);
    }

    FactorRanges.prototype.model = FactorRange;

    return FactorRanges;

  })(Backbone.Collection);

  exports.Range1d = Range1d;

  exports.range1ds = new Range1ds;

  exports.datarange1ds = new DataRange1ds;

  exports.datafactorranges = new DataFactorRanges;

}).call(this);
}, "common/svg_colors": function(exports, require, module) {(function() {
  var svg_colors;

  svg_colors = {
    indianred: "#CD5C5C",
    lightcoral: "#F08080",
    salmon: "#FA8072",
    darksalmon: "#E9967A",
    lightsalmon: "#FFA07A",
    crimson: "#DC143C",
    red: "#FF0000",
    firebrick: "#B22222",
    darkred: "#8B0000",
    pink: "#FFC0CB",
    lightpink: "#FFB6C1",
    hotpink: "#FF69B4",
    deeppink: "#FF1493",
    mediumvioletred: "#C71585",
    palevioletred: "#DB7093",
    lightsalmon: "#FFA07A",
    coral: "#FF7F50",
    tomato: "#FF6347",
    orangered: "#FF4500",
    darkorange: "#FF8C00",
    orange: "#FFA500",
    gold: "#FFD700",
    yellow: "#FFFF00",
    lightyellow: "#FFFFE0",
    lemonchiffon: "#FFFACD",
    lightgoldenrodyellow: "#FAFAD2",
    papayawhip: "#FFEFD5",
    moccasin: "#FFE4B5",
    peachpuff: "#FFDAB9",
    palegoldenrod: "#EEE8AA",
    khaki: "#F0E68C",
    darkkhaki: "#BDB76B",
    lavender: "#E6E6FA",
    thistle: "#D8BFD8",
    plum: "#DDA0DD",
    violet: "#EE82EE",
    orchid: "#DA70D6",
    fuchsia: "#FF00FF",
    magenta: "#FF00FF",
    mediumorchid: "#BA55D3",
    mediumpurple: "#9370DB",
    blueviolet: "#8A2BE2",
    darkviolet: "#9400D3",
    darkorchid: "#9932CC",
    darkmagenta: "#8B008B",
    purple: "#800080",
    indigo: "#4B0082",
    slateblue: "#6A5ACD",
    darkslateblue: "#483D8B",
    mediumslateblue: "#7B68EE",
    greenyellow: "#ADFF2F",
    chartreuse: "#7FFF00",
    lawngreen: "#7CFC00",
    lime: "#00FF00",
    limegreen: "#32CD32",
    palegreen: "#98FB98",
    lightgreen: "#90EE90",
    mediumspringgreen: "#00FA9A",
    springgreen: "#00FF7F",
    mediumseagreen: "#3CB371",
    seagreen: "#2E8B57",
    forestgreen: "#228B22",
    green: "#008000",
    darkgreen: "#006400",
    yellowgreen: "#9ACD32",
    olivedrab: "#6B8E23",
    olive: "#808000",
    darkolivegreen: "#556B2F",
    mediumaquamarine: "#66CDAA",
    darkseagreen: "#8FBC8F",
    lightseagreen: "#20B2AA",
    darkcyan: "#008B8B",
    teal: "#008080",
    aqua: "#00FFFF",
    cyan: "#00FFFF",
    lightcyan: "#E0FFFF",
    paleturquoise: "#AFEEEE",
    aquamarine: "#7FFFD4",
    turquoise: "#40E0D0",
    mediumturquoise: "#48D1CC",
    darkturquoise: "#00CED1",
    cadetblue: "#5F9EA0",
    steelblue: "#4682B4",
    lightsteelblue: "#B0C4DE",
    powderblue: "#B0E0E6",
    lightblue: "#ADD8E6",
    skyblue: "#87CEEB",
    lightskyblue: "#87CEFA",
    deepskyblue: "#00BFFF",
    dodgerblue: "#1E90FF",
    cornflowerblue: "#6495ED",
    mediumslateblue: "#7B68EE",
    royalblue: "#4169E1",
    blue: "#0000FF",
    mediumblue: "#0000CD",
    darkblue: "#00008B",
    navy: "#000080",
    midnightblue: "#191970",
    cornsilk: "#FFF8DC",
    blanchedalmond: "#FFEBCD",
    bisque: "#FFE4C4",
    navajowhite: "#FFDEAD",
    wheat: "#F5DEB3",
    burlywood: "#DEB887",
    tan: "#D2B48C",
    rosybrown: "#BC8F8F",
    sandybrown: "#F4A460",
    goldenrod: "#DAA520",
    darkgoldenrod: "#B8860B",
    peru: "#CD853F",
    chocolate: "#D2691E",
    saddlebrown: "#8B4513",
    sienna: "#A0522D",
    brown: "#A52A2A",
    maroon: "#800000",
    white: "#FFFFFF",
    snow: "#FFFAFA",
    honeydew: "#F0FFF0",
    mintcream: "#F5FFFA",
    azure: "#F0FFFF",
    aliceblue: "#F0F8FF",
    ghostwhite: "#F8F8FF",
    whitesmoke: "#F5F5F5",
    seashell: "#FFF5EE",
    beige: "#F5F5DC",
    oldlace: "#FDF5E6",
    floralwhite: "#FFFAF0",
    ivory: "#FFFFF0",
    antiquewhite: "#FAEBD7",
    linen: "#FAF0E6",
    lavenderblush: "#FFF0F5",
    mistyrose: "#FFE4E1",
    gainsboro: "#DCDCDC",
    lightgrey: "#D3D3D3",
    silver: "#C0C0C0",
    darkgray: "#A9A9A9",
    darkgrey: "#A9A9A9",
    gray: "#808080",
    grey: "#808080",
    dimgray: "#696969",
    dimgrey: "#696969",
    lightslategray: "#778899",
    lightslategrey: "#778899",
    slategray: "#708090",
    darkslategray: "#2F4F4F",
    darkslategrey: "#2F4F4F",
    black: "#000000"
  };

  exports.svg_colors = svg_colors;

}).call(this);
}, "common/textutils": function(exports, require, module) {(function() {
  var cache, getTextHeight;

  cache = {};

  getTextHeight = function(font) {
    var block, body, div, result, text;
    if (cache[font] != null) {
      return cache[font];
    }
    text = $('<span>Hg</span>').css({
      font: font
    });
    block = $('<div style="display: inline-block; width: 1px; height: 0px;"></div>');
    div = $('<div></div>');
    div.append(text, block);
    body = $('body');
    body.append(div);
    try {
      result = {};
      block.css({
        verticalAlign: 'baseline'
      });
      result.ascent = block.offset().top - text.offset().top;
      block.css({
        verticalAlign: 'bottom'
      });
      result.height = block.offset().top - text.offset().top;
      result.descent = result.height - result.ascent;
    } finally {
      div.remove();
    }
    cache[font] = result;
    return result;
  };

  exports.getTextHeight = getTextHeight;

}).call(this);
}, "common/ticking": function(exports, require, module) {(function() {
  var BasicTickFormatter, DatetimeFormatter, arange, argsort, arr_div2, arr_div3, auto_interval, auto_interval_temp, auto_ticks, float, heckbert_interval, is_base2, log10, log2, nice_10, nice_2_5_10, sprintf, tz, _array, _four_digit_year, _ms_dot_us, _strftime, _two_digit_year, _us;

  sprintf = window.sprintf;

  tz = window.tz;

  log10 = function(num) {
    "Returns the base 10 logarithm of a number.";
    if (num === 0.0) {
      num += 1.0e-16;
    }
    return Math.log(num) / Math.LN10;
  };

  log2 = function(num) {
    "Returns the base 2 logarithm of a number.";
    if (num === 0.0) {
      num += 1.0e-16;
    }
    return Math.log(num) / Math.LN2;
  };

  is_base2 = function(rng) {
    " Returns True if rng is a positive multiple of 2 ";

    var lg;
    if (rng <= 0) {
      return false;
    } else {
      lg = log2(rng);
      return (lg > 0.0) && (lg === Math.floor(lg));
    }
  };

  nice_2_5_10 = function(x, round) {
    var expv, f, nf;
    if (round == null) {
      round = false;
    }
    " if round is false, then use Math.ceil(range) ";

    expv = Math.floor(log10(x));
    f = x / Math.pow(10.0, expv);
    if (round) {
      if (f < 1.5) {
        nf = 1.0;
      } else if (f < 3.0) {
        nf = 2.0;
      } else if (f < 7.5) {
        nf = 5.0;
      } else {
        nf = 10.0;
      }
    } else {
      if (f <= 1.0) {
        nf = 1.0;
      } else if (f <= 2.0) {
        nf = 2.0;
      } else if (f <= 5.0) {
        nf = 5.0;
      } else {
        nf = 10.0;
      }
    }
    return nf * Math.pow(10, expv);
  };

  nice_10 = function(x, round) {
    var expv;
    if (round == null) {
      round = false;
    }
    expv = Math.floor(log10(x * 1.0001));
    return Math.pow(10.0, expv);
  };

  heckbert_interval = function(min, max, numticks, nice, loose) {
    var d, graphmax, graphmin, range;
    if (numticks == null) {
      numticks = 8;
    }
    if (nice == null) {
      nice = nice_2_5_10;
    }
    if (loose == null) {
      loose = false;
    }
    "Returns a \"nice\" range and interval for a given data range and a preferred\nnumber of ticks.  From Paul Heckbert's algorithm in Graphics Gems.";

    range = nice(max - min);
    d = nice(range / (numticks - 1), true);
    if (loose) {
      graphmin = Math.floor(min / d) * d;
      graphmax = Math.ceil(max / d) * d;
    } else {
      graphmin = Math.ceil(min / d) * d;
      graphmax = Math.floor(max / d) * d;
    }
    return [graphmin, graphmax, d];
  };

  arange = function(start, end, step) {
    var i, ret_arr;
    if (end == null) {
      end = false;
    }
    if (step == null) {
      step = false;
    }
    if (!end) {
      end = start;
      start = 0;
    }
    if (start > end) {
      if (step === false) {
        step = -1;
      } else if (step > 0) {
        "the loop will never terminate";

        1 / 0;
      }
    } else if (step < 0) {
      "the loop will never terminate";

      1 / 0;
    }
    if (!step) {
      step = 1;
    }
    ret_arr = [];
    i = start;
    if (start < end) {
      while (i < end) {
        ret_arr.push(i);
        i += step;
      }
    } else {
      while (i > end) {
        ret_arr.push(i);
        i += step;
      }
    }
    return ret_arr;
  };

  auto_ticks = function(data_low, data_high, bound_low, bound_high, tick_interval, use_endpoints, zero_always_nice) {
    var auto_lower, auto_upper, delta, end, i, intervals, is_auto_high, is_auto_low, lower, rng, start, tick, ticks, upper, _i, _ref, _ref1;
    if (use_endpoints == null) {
      use_endpoints = false;
    }
    if (zero_always_nice == null) {
      zero_always_nice = true;
    }
    " Finds locations for axis tick marks.\n\nCalculates the locations for tick marks on an axis. The *bound_low*,\n*bound_high*, and *tick_interval* parameters specify how the axis end\npoints and tick interval are calculated.\n\nParameters\n----------\n\ndata_low, data_high : number\n    The minimum and maximum values of the data along this axis.\n    If any of the bound settings are 'auto' or 'fit', the axis\n    bounds are calculated automatically from these values.\nbound_low, bound_high : 'auto', 'fit', or a number.\n    The lower and upper bounds of the axis. If the value is a number,\n    that value is used for the corresponding end point. If the value is\n    'auto', then the end point is calculated automatically. If the\n    value is 'fit', then the axis bound is set to the corresponding\n    *data_low* or *data_high* value.\ntick_interval : can be 'auto' or a number\n    If the value is a positive number, it specifies the length\n    of the tick interval; a negative integer specifies the\n    number of tick intervals; 'auto' specifies that the number and\n    length of the tick intervals are automatically calculated, based\n    on the range of the axis.\nuse_endpoints : Boolean\n    If True, the lower and upper bounds of the data are used as the\n    lower and upper end points of the axis. If False, the end points\n    might not fall exactly on the bounds.\nzero_always_nice : Boolean\n    If True, ticks much closer to zero than the tick interval will be\n    coerced to have a value of zero\n\nReturns\n-------\nAn array of tick mark locations. The first and last tick entries are the\naxis end points.";

    is_auto_low = bound_low === 'auto';
    is_auto_high = bound_high === 'auto';
    if (typeof bound_low === "string") {
      lower = data_low;
    } else {
      lower = bound_low;
    }
    if (typeof bound_high === "string") {
      upper = data_high;
    } else {
      upper = bound_high;
    }
    if ((tick_interval === 'auto') || (tick_interval === 0.0)) {
      rng = Math.abs(upper - lower);
      if (rng === 0.0) {
        tick_interval = 0.5;
        lower = data_low - 0.5;
        upper = data_high + 0.5;
      } else if (is_base2(rng) && is_base2(upper) && rng > 4) {
        if (rng === 2) {
          tick_interval = 1;
        } else if (rng === 4) {
          tick_interval = 4;
        } else {
          tick_interval = rng / 4;
        }
      } else {
        tick_interval = auto_interval(lower, upper);
      }
    } else if (tick_interval < 0) {
      intervals = -tick_interval;
      tick_interval = tick_intervals(lower, upper, intervals);
      if (is_auto_low && is_auto_high) {
        is_auto_low = is_auto_high = false;
        lower = tick_interval * Math.floor(lower / tick_interval);
        while ((Math.abs(lower) >= tick_interval) && ((lower + tick_interval * (intervals - 1)) >= upper)) {
          lower -= tick_interval;
        }
        upper = lower + tick_interval * intervals;
      }
    }
    if (is_auto_low || is_auto_high) {
      delta = 0.01 * tick_interval * (data_low === data_high);
      _ref = auto_bounds(data_low - delta, data_high + delta, tick_interval), auto_lower = _ref[0], auto_upper = _ref[1];
      if (is_auto_low) {
        lower = auto_lower;
      }
      if (is_auto_high) {
        upper = auto_upper;
      }
    }
    start = Math.floor(lower / tick_interval) * tick_interval;
    end = Math.floor(upper / tick_interval) * tick_interval;
    if (start === end) {
      lower = start = start - tick_interval;
      upper = end = start - tick_interval;
    }
    if (upper > end) {
      end += tick_interval;
    }
    ticks = arange(start, end + (tick_interval / 2.0), tick_interval);
    if (zero_always_nice) {
      for (i = _i = 0, _ref1 = ticks.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if (Math.abs(ticks[i]) < tick_interval / 1000) {
          ticks[i] = 0;
        }
      }
    }
    if ((!is_auto_low) && use_endpoints) {
      ticks[0] = lower;
    }
    if ((!is_auto_high) && use_endpoints) {
      ticks[ticks.length - 1] = upper;
    }
    return (function() {
      var _j, _len, _results;
      _results = [];
      for (_j = 0, _len = ticks.length; _j < _len; _j++) {
        tick = ticks[_j];
        if (tick >= bound_low && tick <= bound_high) {
          _results.push(tick);
        }
      }
      return _results;
    })();
  };

  arr_div2 = function(numerator, denominators) {
    var output_arr, val, _i, _len;
    output_arr = [];
    for (_i = 0, _len = denominators.length; _i < _len; _i++) {
      val = denominators[_i];
      output_arr.push(numerator / val);
    }
    return output_arr;
  };

  arr_div3 = function(numerators, denominators) {
    var i, output_arr, val, _i, _len;
    output_arr = [];
    for (i = _i = 0, _len = denominators.length; _i < _len; i = ++_i) {
      val = denominators[i];
      output_arr.push(numerators[i] / val);
    }
    return output_arr;
  };

  argsort = function(arr) {
    var i, ret_arr, sorted_arr, y, _i, _len;
    sorted_arr = _.sortBy(arr, _.identity);
    ret_arr = [];
    for (i = _i = 0, _len = sorted_arr.length; _i < _len; i = ++_i) {
      y = sorted_arr[i];
      ret_arr[i] = arr.indexOf(y);
    }
    return ret_arr;
  };

  float = function(x) {
    return x + 0.0;
  };

  auto_interval_temp = function(data_low, data_high) {
    " Calculates the tick interval for a range.\n\nThe boundaries for the data to be plotted on the axis are::\n\n    data_bounds = (data_low,data_high)\n\nThe function chooses the number of tick marks, which can be between\n3 and 9 marks (including end points), and chooses tick intervals at\n1, 2, 2.5, 5, 10, 20, ...\n\nReturns\n-------\ninterval : float\n    tick mark interval for axis";

    var best_magics, best_mantissas, candidate_intervals, diff_arr, divisions, interval, ma, magic_index, magic_intervals, magnitude, magnitudes, mantissa_index, mantissas, mi, range, result, _i, _j, _len, _len1;
    range = float(data_high) - float(data_low);
    divisions = [8.0, 7.0, 6.0, 5.0, 4.0, 3.0];
    candidate_intervals = arr_div2(range, divisions);
    magnitudes = candidate_intervals.map(function(candidate) {
      return Math.pow(10.0, Math.floor(log10(candidate)));
    });
    mantissas = arr_div3(candidate_intervals, magnitudes);
    magic_intervals = [1.0, 2.0, 2.5, 5.0, 10.0];
    best_mantissas = [];
    best_magics = [];
    for (_i = 0, _len = magic_intervals.length; _i < _len; _i++) {
      mi = magic_intervals[_i];
      diff_arr = mantissas.map(function(x) {
        return Math.abs(mi - x);
      });
      best_magics.push(_.min(diff_arr));
    }
    for (_j = 0, _len1 = mantissas.length; _j < _len1; _j++) {
      ma = mantissas[_j];
      diff_arr = magic_intervals.map(function(x) {
        return Math.abs(ma - x);
      });
      best_mantissas.push(_.min(diff_arr));
    }
    magic_index = argsort(best_magics)[0];
    mantissa_index = argsort(best_mantissas)[0];
    interval = magic_intervals[magic_index];
    magnitude = magnitudes[mantissa_index];
    result = interval * magnitude;
    return result;
  };

  auto_interval = memoize(auto_interval_temp);

  BasicTickFormatter = (function() {

    function BasicTickFormatter(precision, use_scientific, power_limit_high, power_limit_low) {
      this.precision = precision != null ? precision : 'auto';
      this.use_scientific = use_scientific != null ? use_scientific : true;
      this.power_limit_high = power_limit_high != null ? power_limit_high : 5;
      this.power_limit_low = power_limit_low != null ? power_limit_low : -3;
      this.scientific_limit_low = Math.pow(10.0, power_limit_low);
      this.scientific_limit_high = Math.pow(10.0, power_limit_high);
      this.last_precision = 3;
    }

    BasicTickFormatter.prototype.format = function(ticks) {
      var i, is_ok, labels, need_sci, tick, tick_abs, x, zero_eps, _i, _j, _k, _l, _len, _m, _n, _ref, _ref1, _ref2, _ref3, _ref4;
      if (ticks.length === 0) {
        return [];
      }
      zero_eps = 0;
      if (ticks.length >= 2) {
        zero_eps = Math.abs(ticks[1] - ticks[0]) / 10000;
      }
      need_sci = false;
      if (this.use_scientific) {
        for (_i = 0, _len = ticks.length; _i < _len; _i++) {
          tick = ticks[_i];
          tick_abs = Math.abs(tick);
          if (tick_abs > zero_eps && (tick_abs >= this.scientific_limit_high || tick_abs <= this.scientific_limit_low)) {
            need_sci = true;
            break;
          }
        }
      }
      if (_.isNumber(this.precision)) {
        labels = new Array(ticks.length);
        if (need_sci) {
          for (i = _j = 0, _ref = ticks.length - 1; 0 <= _ref ? _j <= _ref : _j >= _ref; i = 0 <= _ref ? ++_j : --_j) {
            labels[i] = ticks[i].toExponential(this.precision);
          }
        } else {
          for (i = _k = 0, _ref1 = ticks.length - 1; 0 <= _ref1 ? _k <= _ref1 : _k >= _ref1; i = 0 <= _ref1 ? ++_k : --_k) {
            labels[i] = ticks[i].toPrecision(this.precision).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
          }
        }
        return labels;
      } else if (this.precision === 'auto') {
        labels = new Array(ticks.length);
        for (x = _l = _ref2 = this.last_precision; _ref2 <= 15 ? _l <= 15 : _l >= 15; x = _ref2 <= 15 ? ++_l : --_l) {
          is_ok = true;
          if (need_sci) {
            for (i = _m = 0, _ref3 = ticks.length - 1; 0 <= _ref3 ? _m <= _ref3 : _m >= _ref3; i = 0 <= _ref3 ? ++_m : --_m) {
              labels[i] = ticks[i].toExponential(x);
              if (i > 0) {
                if (labels[i] === labels[i - 1]) {
                  is_ok = false;
                  break;
                }
              }
            }
            if (is_ok) {
              break;
            }
          } else {
            for (i = _n = 0, _ref4 = ticks.length - 1; 0 <= _ref4 ? _n <= _ref4 : _n >= _ref4; i = 0 <= _ref4 ? ++_n : --_n) {
              labels[i] = ticks[i].toPrecision(x).replace(/(\.[0-9]*?)0+$/, "$1").replace(/\.$/, "");
              if (i > 0) {
                if (labels[i] === labels[i - 1]) {
                  is_ok = false;
                  break;
                }
              }
            }
            if (is_ok) {
              break;
            }
          }
          if (is_ok) {
            this.last_precision = x;
            return labels;
          }
        }
      }
      return labels;
    };

    return BasicTickFormatter;

  })();

  _us = function(t) {
    return sprintf("%3dus", Math.floor((t % 1) * 1000));
  };

  _ms_dot_us = function(t) {
    var ms, us;
    ms = Math.floor(((t / 1000) % 1) * 1000);
    us = Math.floor((t % 1) * 1000);
    return sprintf("%3d.%3dms", ms, us);
  };

  _two_digit_year = function(t) {
    var dt, year;
    dt = new Date(t);
    year = dt.getFullYear();
    if (dt.getMonth() >= 7) {
      year += 1;
    }
    return sprintf("'%02d", year % 100);
  };

  _four_digit_year = function(t) {
    var dt, year;
    dt = new Date(t);
    year = dt.getFullYear();
    if (dt.getMonth() >= 7) {
      year += 1;
    }
    return sprintf("%d", year);
  };

  _array = function(t) {
    return tz(t, "%Y %m %d %H %M %S").split(/\s+/).map(function(e) {
      return parseInt(e, 10);
    });
  };

  _strftime = function(t, format) {
    if (_.isFunction(format)) {
      return format(t);
    } else {
      return tz(t, format);
    }
  };

  DatetimeFormatter = (function() {

    DatetimeFormatter.prototype.format_order = ['microseconds', 'milliseconds', 'seconds', 'minsec', 'minutes', 'hourmin', 'hours', 'days', 'months', 'years'];

    DatetimeFormatter.prototype.strip_leading_zeros = true;

    function DatetimeFormatter() {
      var fmt, fmt_name, fmt_strings, size, sizes, tmptime, _i, _len;
      this._formats = {
        'microseconds': [_us, _ms_dot_us],
        'milliseconds': ['%3Nms', '%S.%3Ns'],
        'seconds': [':%S', '%Ss'],
        'minsec': ['%M:%S'],
        'minutes': ['%Mm'],
        'hourmin': ['%H:%M'],
        'hours': ['%Hh', '%H:%M'],
        'days': ['%m/%d', '%a%d'],
        'months': ['%m/%Y', '%b%y'],
        'years': ['%Y', _two_digit_year, _four_digit_year]
      };
      this.formats = {};
      for (fmt_name in this._formats) {
        fmt_strings = this._formats[fmt_name];
        sizes = [];
        tmptime = tz(new Date());
        for (_i = 0, _len = fmt_strings.length; _i < _len; _i++) {
          fmt = fmt_strings[_i];
          size = (_strftime(tmptime, fmt)).length;
          sizes.push(size);
        }
        this.formats[fmt_name] = [sizes, fmt_strings];
      }
      return;
    }

    DatetimeFormatter.prototype._get_resolution = function(resolution, interval) {
      var r, resol, span;
      r = resolution;
      span = interval;
      if (r < 5e-4) {
        resol = "microseconds";
      } else if (r < 0.5) {
        resol = "milliseconds";
      } else if (r < 60) {
        if (span > 60) {
          resol = "minsec";
        } else {
          resol = "seconds";
        }
      } else if (r < 3600) {
        if (span > 3600) {
          resol = "hourmin";
        } else {
          resol = "minutes";
        }
      } else if (r < 24 * 3600) {
        resol = "hours";
      } else if (r < 30 * 24 * 3600) {
        resol = "days";
      } else if (r < 365 * 24 * 3600) {
        resol = "months";
      } else {
        resol = "years";
      }
      return resol;
    };

    DatetimeFormatter.prototype.format = function(ticks, num_labels, char_width, fill_ratio, ticker) {
      var dt, fmt, format, formats, good_formats, hybrid_handled, i, labels, next_format, next_ndx, r, resol, resol_ndx, s, span, ss, t, time_tuple_ndx_for_resol, tm, widths, _i, _j, _k, _len, _len1, _ref, _ref1, _ref2;
      if (num_labels == null) {
        num_labels = null;
      }
      if (char_width == null) {
        char_width = null;
      }
      if (fill_ratio == null) {
        fill_ratio = 0.3;
      }
      if (ticker == null) {
        ticker = null;
      }
      if (ticks.length === 0) {
        return [];
      }
      span = Math.abs(ticks[ticks.length - 1] - ticks[0]) / 1000.0;
      if (ticker) {
        r = ticker.resolution;
      } else {
        r = span / (ticks.length - 1);
      }
      resol = this._get_resolution(r, span);
      _ref = this.formats[resol], widths = _ref[0], formats = _ref[1];
      format = formats[0];
      if (char_width) {
        good_formats = [];
        for (i = _i = 0, _ref1 = widths.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
          if (widths[i] * ticks.length < fill_ratio * char_width) {
            good_formats.push(this.formats[i]);
          }
        }
        if (good_formats.length > 0) {
          format = good_formats[ticks.length - 1];
        }
      }
      labels = [];
      resol_ndx = this.format_order.indexOf(resol);
      time_tuple_ndx_for_resol = {};
      _ref2 = this.format_order;
      for (_j = 0, _len = _ref2.length; _j < _len; _j++) {
        fmt = _ref2[_j];
        time_tuple_ndx_for_resol[fmt] = 0;
      }
      time_tuple_ndx_for_resol["seconds"] = 5;
      time_tuple_ndx_for_resol["minsec"] = 4;
      time_tuple_ndx_for_resol["minutes"] = 4;
      time_tuple_ndx_for_resol["hourmin"] = 3;
      time_tuple_ndx_for_resol["hours"] = 3;
      for (_k = 0, _len1 = ticks.length; _k < _len1; _k++) {
        t = ticks[_k];
        try {
          dt = Date(t);
          tm = _array(t);
          s = _strftime(t, format);
        } catch (error) {
          console.log(error);
          console.log("Unable to convert tick for timestamp " + t);
          labels.push("ERR");
          continue;
        }
        hybrid_handled = false;
        next_ndx = resol_ndx;
        while (tm[time_tuple_ndx_for_resol[this.format_order[next_ndx]]] === 0) {
          next_ndx += 1;
          if (next_ndx === this.format_order.length) {
            break;
          }
          if ((resol === "minsec" || resol === "hourmin") && !hybrid_handled) {
            if ((resol === "minsec" && tm[4] === 0 && tm[5] !== 0) || (resol === "hourmin" && tm[3] === 0 && tm[4] !== 0)) {
              next_format = this.formats[this.format_order[resol_ndx - 1]][1][0];
              s = _strftime(t, next_format);
              break;
            } else {
              hybrid_handled = true;
            }
          }
          next_format = this.formats[this.format_order[next_ndx]][1][0];
          s = _strftime(t, next_format);
        }
        if (this.strip_leading_zeros) {
          ss = s.replace(/^0+/g, "");
          if (ss !== s && (ss === '' || !isFinite(ss[0]))) {
            ss = '0' + ss;
          }
          labels.push(ss);
        } else {
          labels.push(s);
        }
      }
      return labels;
    };

    return DatetimeFormatter;

  })();

  exports.nice_2_5_10 = nice_2_5_10;

  exports.nice_10 = nice_10;

  exports.heckbert_interval = heckbert_interval;

  exports.auto_ticks = auto_ticks;

  exports.auto_interval = auto_interval;

  exports.BasicTickFormatter = BasicTickFormatter;

  exports.DatetimeFormatter = DatetimeFormatter;

}).call(this);
}, "common/view_state": function(exports, require, module) {(function() {
  var Collections, HasProperties, Range1d, ViewState, base,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../base');

  Range1d = require('../common/ranges').Range1d;

  Collections = base.Collections;

  HasProperties = base.HasProperties;

  ViewState = (function(_super) {

    __extends(ViewState, _super);

    function ViewState() {
      return ViewState.__super__.constructor.apply(this, arguments);
    }

    ViewState.prototype.initialize = function(attrs, options) {
      var _inner_range_horizontal, _inner_range_vertical;
      ViewState.__super__.initialize.call(this, attrs, options);
      this.register_property('border_top', function() {
        return Math.max(this.get('min_border_top'), this.get('requested_border_top'));
      }, false);
      this.add_dependencies('border_top', this, ['min_border_top', 'requested_border_top']);
      this.register_property('border_bottom', function() {
        return Math.max(this.get('min_border_bottom'), this.get('requested_border_bottom'));
      }, false);
      this.add_dependencies('border_bottom', this, ['min_border_bottom', 'requested_border_bottom']);
      this.register_property('border_left', function() {
        return Math.max(this.get('min_border_left'), this.get('requested_border_left'));
      }, false);
      this.add_dependencies('border_left', this, ['min_border_left', 'requested_border_left']);
      this.register_property('border_right', function() {
        return Math.max(this.get('min_border_right'), this.get('requested_border_right'));
      }, false);
      this.add_dependencies('border_right', this, ['min_border_right', 'requested_border_right']);
      this.register_property('canvas_aspect', function() {
        return this.get('canvas_height') / this.get('canvas_width');
      }, true);
      this.add_dependencies('canvas_aspect', this, ['canvas_height', 'canvas_width']);
      this.register_property('outer_aspect', function() {
        return this.get('outer_height') / this.get('outer_width');
      }, true);
      this.add_dependencies('outer_aspect', this, ['outer_height', 'outer_width']);
      this.register_property('inner_width', function() {
        return this.get('outer_width') - this.get('border_left') - this.get('border_right');
      }, true);
      this.add_dependencies('inner_width', this, ['outer_width', 'border_left', 'border_right']);
      this.register_property('inner_height', function() {
        return this.get('outer_height') - this.get('border_top') - this.get('border_bottom');
      }, true);
      this.add_dependencies('inner_height', this, ['outer_height', 'border_top', 'border_bottom']);
      this.register_property('inner_aspect', function() {
        return this.get('inner_height') / this.get('inner_width');
      }, true);
      this.add_dependencies('inner_aspect', this, ['inner_height', 'inner_width']);
      _inner_range_horizontal = new Range1d({
        start: this.get('border_left'),
        end: this.get('border_left') + this.get('inner_width')
      });
      this.register_property('inner_range_horizontal', function() {
        _inner_range_horizontal.set('start', this.get('border_left'));
        _inner_range_horizontal.set('end', this.get('border_left') + this.get('inner_width'));
        return _inner_range_horizontal;
      }, true);
      this.add_dependencies('inner_range_horizontal', this, ['border_left', 'inner_width']);
      _inner_range_vertical = new Range1d({
        start: this.get('border_bottom'),
        end: this.get('border_bottom') + this.get('inner_height')
      });
      this.register_property('inner_range_vertical', function() {
        _inner_range_vertical.set('start', this.get('border_bottom'));
        _inner_range_vertical.set('end', this.get('border_bottom') + this.get('inner_height'));
        return _inner_range_vertical;
      }, true);
      return this.add_dependencies('inner_range_vertical', this, ['border_bottom', 'inner_height']);
    };

    ViewState.prototype.sx_to_device = function(x) {
      return x;
    };

    ViewState.prototype.sy_to_device = function(y) {
      return this.get('canvas_height') - y;
    };

    ViewState.prototype.v_sx_to_device = function(xx) {
      var idx, x, _i, _len;
      for (idx = _i = 0, _len = xx.length; _i < _len; idx = ++_i) {
        x = xx[idx];
        xx[idx] = x;
      }
      return xx;
    };

    ViewState.prototype.v_sy_to_device = function(yy) {
      var canvas_height, idx, y, _i, _len;
      canvas_height = this.get('canvas_height');
      for (idx = _i = 0, _len = yy.length; _i < _len; idx = ++_i) {
        y = yy[idx];
        yy[idx] = canvas_height - y;
      }
      return yy;
    };

    ViewState.prototype.device_to_sx = function(x) {
      return x;
    };

    ViewState.prototype.device_to_sy = function(y) {
      return this.get('canvas_height') - y;
    };

    ViewState.prototype.v_device_to_sx = function(xx) {
      var idx, x, _i, _len;
      for (idx = _i = 0, _len = xx.length; _i < _len; idx = ++_i) {
        x = xx[idx];
        xx[idx] = x;
      }
      return xx;
    };

    ViewState.prototype.v_device_to_sy = function(yy) {
      var canvas_height, idx, y, _i, _len;
      canvas_height = this.get('canvas_height');
      for (idx = _i = 0, _len = yy.length; _i < _len; idx = ++_i) {
        y = yy[idx];
        yy[idx] = y - canvas_height;
      }
      return yy;
    };

    return ViewState;

  })(HasProperties);

  exports.ViewState = ViewState;

}).call(this);
}, "mappers/1d/categorical_mapper": function(exports, require, module) {(function() {
  var CategoricalMapper, HasProperties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  CategoricalMapper = (function(_super) {

    __extends(CategoricalMapper, _super);

    function CategoricalMapper() {
      return CategoricalMapper.__super__.constructor.apply(this, arguments);
    }

    CategoricalMapper.prototype.initialize = function(attrs, options) {
      CategoricalMapper.__super__.initialize.call(this, attrs, options);
      this.register_property('mapper_state', this._scale, true);
      this.add_dependencies('mapper_state', this.get('source_range'), this.target_range);
      this.add_dependencies('mapper_state', this.get('source_range'), 'values');
      return this.add_dependencies('mapper_state', this.get('target_range'), ['start', 'end']);
    };

    CategoricalMapper.prototype.map_to_target = function(x) {
      var offset, scale_factor, values, _ref;
      _ref = this.get('mapper_state'), scale_factor = _ref[0], offset = _ref[1];
      values = this.get('source_range').get('values');
      return scale * _.indexOf(values, x) + offset;
    };

    CategoricalMapper.prototype.v_map_to_target = function(xs) {
      var idx, offset, result, scale, values, x, _i, _len, _ref;
      _ref = this.get('mapper_state'), scale = _ref[0], offset = _ref[1];
      values = this.get('source_range').get('values');
      result = new Float32Array(xs.length);
      for (idx = _i = 0, _len = xs.length; _i < _len; idx = ++_i) {
        x = xs[idx];
        result[idx] = scale * _.indexOf(values, x) + offset;
      }
      return result;
    };

    CategoricalMapper.prototype.map_from_target = function(xprime) {
      var offset, scale, values, _ref;
      _ref = this.get('mapper_state'), scale = _ref[0], offset = _ref[1];
      values = this.get('source_range').get('values');
      return values[Math.trunc((xprime + offset) / scale)];
    };

    CategoricalMapper.prototype.v_map_from_target = function(xprimes) {
      var idx, offset, result, scale, values, xprime, _i, _len, _ref;
      _ref = this.get('mapper_state'), scale = _ref[0], offset = _ref[1];
      values = this.get('source_range').get('values');
      result = new Float32Array(xprimes.length);
      for (idx = _i = 0, _len = xprimes.length; _i < _len; idx = ++_i) {
        xprime = xprimes[idx];
        result[idx] = values[Math.trunc((xprime + offset) / scale)];
      }
      return result;
    };

    CategoricalMapper.prototype.target_bin_width = function() {
      return this.get('mapper_state')[0];
    };

    CategoricalMapper.prototype._scale = function() {
      var length, offset, scale, target_end, target_start;
      target_start = this.get('target_range').get('start');
      target_end = this.get('target_range').get('end');
      length = this.get('source_range').get('values').length;
      scale = (target_end - target_start) / length;
      offset = scale / 2;
      return [scale, offset];
    };

    return CategoricalMapper;

  })(HasProperties);

  exports.CategoricalMapper = CategoricalMapper;

}).call(this);
}, "mappers/1d/linear_mapper": function(exports, require, module) {(function() {
  var HasProperties, LinearMapper,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  LinearMapper = (function(_super) {

    __extends(LinearMapper, _super);

    function LinearMapper() {
      return LinearMapper.__super__.constructor.apply(this, arguments);
    }

    LinearMapper.prototype.initialize = function(attrs, options) {
      LinearMapper.__super__.initialize.call(this, attrs, options);
      this.register_property('mapper_state', this._mapper_state, true);
      this.add_dependencies('mapper_state', this, ['source_range', 'target_range']);
      this.add_dependencies('mapper_state', this.get('source_range'), ['start', 'end']);
      return this.add_dependencies('mapper_state', this.get('target_range'), ['start', 'end']);
    };

    LinearMapper.prototype.map_to_target = function(x) {
      var offset, scale, _ref;
      _ref = this.get('mapper_state'), scale = _ref[0], offset = _ref[1];
      return scale * x + offset;
    };

    LinearMapper.prototype.v_map_to_target = function(xs) {
      var idx, offset, result, scale, x, _i, _len, _ref;
      _ref = this.get('mapper_state'), scale = _ref[0], offset = _ref[1];
      result = new Float32Array(xs.length);
      for (idx = _i = 0, _len = xs.length; _i < _len; idx = ++_i) {
        x = xs[idx];
        result[idx] = scale * x + offset;
      }
      return result;
    };

    LinearMapper.prototype.map_from_target = function(xprime) {
      var offset, scale, _ref;
      _ref = this.get('mapper_state'), scale = _ref[0], offset = _ref[1];
      return (xprime - offset) / scale;
    };

    LinearMapper.prototype.v_map_from_target = function(xprimes) {
      var idx, offset, result, scale, xprime, _i, _len, _ref;
      _ref = this.get('mapper_state'), scale = _ref[0], offset = _ref[1];
      result = new Float32Array(xprimes.length);
      for (idx = _i = 0, _len = xprimes.length; _i < _len; idx = ++_i) {
        xprime = xprimes[idx];
        result[idx] = (xprime - offset) / scale;
      }
      return result;
    };

    LinearMapper.prototype._mapper_state = function() {
      var offset, scale, source_end, source_start, target_end, target_start;
      source_start = this.get('source_range').get('start');
      source_end = this.get('source_range').get('end');
      target_start = this.get('target_range').get('start');
      target_end = this.get('target_range').get('end');
      scale = (target_end - target_start) / (source_end - source_start);
      offset = -(scale * source_start) + target_start;
      return [scale, offset];
    };

    return LinearMapper;

  })(HasProperties);

  exports.LinearMapper = LinearMapper;

}).call(this);
}, "mappers/1d/log_mapper": function(exports, require, module) {(function() {
  var HasProperties, LogMapper,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  LogMapper = (function(_super) {

    __extends(LogMapper, _super);

    function LogMapper() {
      return LogMapper.__super__.constructor.apply(this, arguments);
    }

    LogMapper.prototype.initialize = function(attrs, options) {
      return LogMapper.__super__.initialize.call(this, attrs, options);
    };

    LogMapper.prototype.map_to_target = function(x) {};

    LogMapper.prototype.v_map_to_target = function(xs) {
      var result;
      result = new Float32Array(xs.length);
      return result;
    };

    LogMapper.prototype.map_from_target = function(xprime) {};

    LogMapper.prototype.v_map_from_target = function(xprimes) {
      var result;
      result = new Float32Array(xprimes.length);
      return result;
    };

    return LogMapper;

  })(HasProperties);

  exports.LogMapper = LogMapper;

}).call(this);
}, "mappers/2d/barycentric_mapper": function(exports, require, module) {(function() {
  var BarycentricMapper, HasProperties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  BarycentricMapper = (function(_super) {

    __extends(BarycentricMapper, _super);

    function BarycentricMapper() {
      return BarycentricMapper.__super__.constructor.apply(this, arguments);
    }

    BarycentricMapper.prototype.initialize = function(attrs, options) {
      return BarycentricMapper.__super__.initialize.call(this, attrs, options);
    };

    BarycentricMapper.prototype.map_to_target = function(x, y) {};

    BarycentricMapper.prototype.v_map_to_target = function(xs, ys) {};

    BarycentricMapper.prototype.map_from_target = function(xprime, yprime) {};

    BarycentricMapper.prototype.v_map_from_target = function(xprimes, yprimes) {};

    return BarycentricMapper;

  })(HasProperties);

  exports.BarycentricMapper = PolarMapper;

}).call(this);
}, "mappers/2d/grid_mapper": function(exports, require, module) {(function() {
  var GridMapper, HasProperties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  GridMapper = (function(_super) {

    __extends(GridMapper, _super);

    function GridMapper() {
      return GridMapper.__super__.constructor.apply(this, arguments);
    }

    GridMapper.prototype.map_to_target = function(x, y) {
      var xprime, yprime;
      xprime = this.get('domain_mapper').map_to_target(x);
      yprime = this.get('codomain_mapper').map_to_target(y);
      return [xprime, yprime];
    };

    GridMapper.prototype.v_map_to_target = function(xs, ys) {
      var xprimes, yprimes;
      xprimes = this.get('domain_mapper').v_map_to_target(xs);
      yprimes = this.get('codomain_mapper').v_map_to_target(ys);
      return [xprimes, yprimes];
    };

    GridMapper.prototype.map_from_target = function(xprime, yprime) {
      var x, y;
      x = this.get('domain_mapper').map_from_target(xprime);
      y = this.get('codomain_mapper').map_from_target(yprime);
      return [x, y];
    };

    GridMapper.prototype.v_map_from_target = function(xprimes, yprimes) {
      var xs, ys;
      xs = this.get('domain_mapper').v_map_from_target(xprimes);
      ys = this.get('codomain_mapper').v_map_from_target(yprimes);
      return [xs, ys];
    };

    return GridMapper;

  })(HasProperties);

  exports.GridMapper = GridMapper;

}).call(this);
}, "mappers/2d/polar_mapper": function(exports, require, module) {(function() {
  var HasProperties, PolarMapper,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  PolarMapper = (function(_super) {

    __extends(PolarMapper, _super);

    function PolarMapper() {
      return PolarMapper.__super__.constructor.apply(this, arguments);
    }

    PolarMapper.prototype.initialize = function(attrs, options) {
      return PolarMapper.__super__.initialize.call(this, attrs, options);
    };

    PolarMapper.prototype.map_to_target = function(x, y) {};

    PolarMapper.prototype.v_map_to_target = function(xs, ys) {};

    PolarMapper.prototype.map_from_target = function(xprime, yprime) {};

    PolarMapper.prototype.v_map_from_target = function(xprimes, yprimes) {};

    return PolarMapper;

  })(HasProperties);

  exports.PolarMapper = PolarMapper;

}).call(this);
}, "mappers/2d/ternary_mapper": function(exports, require, module) {(function() {
  var HasProperties, TernaryMapper,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  TernaryMapper = (function(_super) {

    __extends(TernaryMapper, _super);

    function TernaryMapper() {
      return TernaryMapper.__super__.constructor.apply(this, arguments);
    }

    TernaryMapper.prototype.initialize = function(attrs, options) {
      return TernaryMapper.__super__.initialize.call(this, attrs, options);
    };

    TernaryMapper.prototype.map_to_target = function(x, y) {};

    TernaryMapper.prototype.v_map_to_target = function(xs, ys) {};

    TernaryMapper.prototype.map_from_target = function(xprime, yprime) {};

    TernaryMapper.prototype.v_map_from_target = function(xprimes, yprimes) {};

    return TernaryMapper;

  })(HasProperties);

  exports.TerneryMapper = PolarMapper;

}).call(this);
}, "mappers/color/linear_color_mapper": function(exports, require, module) {(function() {
  var HasProperties, LinearColorMapper,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  HasProperties = require('../../base').HasProperties;

  LinearColorMapper = (function(_super) {

    __extends(LinearColorMapper, _super);

    function LinearColorMapper() {
      return LinearColorMapper.__super__.constructor.apply(this, arguments);
    }

    LinearColorMapper.prototype.initialize = function(attrs, options) {
      LinearColorMapper.__super__.initialize.call(this, attrs, options);
      this.low = options.low;
      this.high = options.high;
      this.palette = this._build_palette(options.palette);
      return this.little_endian = this._is_little_endian();
    };

    LinearColorMapper.prototype.v_map_screen = function(data) {
      var N, buf, color, d, high, i, low, max, min, offset, scale, value, _i, _j, _k, _ref, _ref1, _ref2;
      buf = new ArrayBuffer(data.length * 4);
      color = new Uint32Array(buf);
      max = -Infinity;
      min = Infinity;
      value = 0;
      for (i = _i = 0, _ref = data.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        value = data[i];
        if (value > max) {
          max = value;
        }
        if (value < min) {
          min = value;
        }
      }
      if (this.low != null) {
        low = this.low;
      } else {
        low = min;
      }
      if (this.high != null) {
        high = this.high;
      } else {
        high = max;
      }
      N = this.palette.length - 1;
      scale = N / (high - low);
      offset = -scale * low;
      if (this.little_endian) {
        for (i = _j = 0, _ref1 = data.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          d = data[i];
          if (d > high) {
            d = high;
          }
          if (d < low) {
            d = low;
          }
          value = this.palette[Math.floor(d * scale + offset)];
          color[i] = (0xff << 24) | ((value & 0xff0000) >> 16) | (value & 0xff00) | ((value & 0xff) << 16);
        }
      } else {
        for (i = _k = 0, _ref2 = data.length - 1; 0 <= _ref2 ? _k <= _ref2 : _k >= _ref2; i = 0 <= _ref2 ? ++_k : --_k) {
          d = data[i];
          if (d > high) {
            d = high;
          }
          if (d < low) {
            d = low;
          }
          value = this.palette[Math.floor(d * scale + offset)];
          color[i] = (value << 8) | 0xff;
        }
      }
      return buf;
    };

    LinearColorMapper.prototype._is_little_endian = function() {
      var buf, buf32, buf8, little_endian;
      buf = new ArrayBuffer(4);
      buf8 = new Uint8ClampedArray(buf);
      buf32 = new Uint32Array(buf);
      buf32[1] = 0x0a0b0c0d;
      little_endian = true;
      if (buf8[4] === 0x0a && buf8[5] === 0x0b && buf8[6] === 0x0c && buf8[7] === 0x0d) {
        little_endian = false;
      }
      return little_endian;
    };

    LinearColorMapper.prototype._build_palette = function(palette) {
      var i, new_palette, _i, _ref;
      new_palette = new Uint32Array(palette.length + 1);
      for (i = _i = 0, _ref = palette.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        new_palette[i] = palette[i];
      }
      new_palette[new_palette.length - 1] = palette[palette.length - 1];
      return new_palette;
    };

    return LinearColorMapper;

  })(HasProperties);

  exports.LinearColorMapper = LinearColorMapper;

}).call(this);
}, "mappers/color/log_color_mapper": function(exports, require, module) {(function() {



}).call(this);
}, "mappers/color/segment_color_mapper": function(exports, require, module) {(function() {



}).call(this);
}, "overlays/boxselectionoverlay": function(exports, require, module) {(function() {
  var BoxSelectionOverlay, BoxSelectionOverlayView, BoxSelectionOverlays, HasParent, PlotWidget, base,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require("../base");

  PlotWidget = require("../common/plot_widget").PlotWidget;

  HasParent = base.HasParent;

  BoxSelectionOverlayView = (function(_super) {

    __extends(BoxSelectionOverlayView, _super);

    function BoxSelectionOverlayView() {
      return BoxSelectionOverlayView.__super__.constructor.apply(this, arguments);
    }

    BoxSelectionOverlayView.prototype.initialize = function(options) {
      this.selecting = false;
      this.xrange = [null, null];
      this.yrange = [null, null];
      BoxSelectionOverlayView.__super__.initialize.call(this, options);
      return this.plot_view.$el.find('.bokeh_canvas_wrapper').append(this.$el);
    };

    BoxSelectionOverlayView.prototype.boxselect = function(xrange, yrange) {
      this.xrange = xrange;
      this.yrange = yrange;
      return this.request_render();
    };

    BoxSelectionOverlayView.prototype.startselect = function() {
      this.selecting = true;
      this.xrange = [null, null];
      this.yrange = [null, null];
      return this.request_render();
    };

    BoxSelectionOverlayView.prototype.stopselect = function() {
      this.selecting = false;
      this.xrange = [null, null];
      this.yrange = [null, null];
      return this.request_render();
    };

    BoxSelectionOverlayView.prototype.bind_bokeh_events = function(options) {
      this.toolview = this.plot_view.tools[this.mget('tool').id];
      this.listenTo(this.toolview, 'boxselect', this.boxselect);
      this.listenTo(this.toolview, 'startselect', this.startselect);
      return this.listenTo(this.toolview, 'stopselect', this.stopselect);
    };

    BoxSelectionOverlayView.prototype.render = function() {
      var height, style_string, width, xpos, xrange, ypos, yrange;
      if (!this.selecting) {
        this.$el.removeClass('shading');
        return;
      }
      xrange = this.xrange;
      yrange = this.yrange;
      if (_.any(_.map(xrange, _.isNullOrUndefined)) || _.any(_.map(yrange, _.isNullOrUndefined))) {
        this.$el.removeClass('shading');
        return;
      }
      style_string = "";
      xpos = this.plot_view.view_state.sx_to_device(Math.min(xrange[0], xrange[1]));
      if (xrange) {
        width = Math.abs(xrange[1] - xrange[0]);
      } else {
        width = this.plot_view.view_state.get('width');
      }
      style_string += "; left:" + xpos + "px; width:" + width + "px; ";
      ypos = this.plot_view.view_state.sy_to_device(Math.max(yrange[0], yrange[1]));
      if (yrange) {
        height = yrange[1] - yrange[0];
      } else {
        height = this.plot_view.view_state.get('height');
      }
      this.$el.addClass('shading');
      style_string += "top:" + ypos + "px; height:" + height + "px";
      return this.$el.attr('style', style_string);
    };

    return BoxSelectionOverlayView;

  })(PlotWidget);

  BoxSelectionOverlay = (function(_super) {

    __extends(BoxSelectionOverlay, _super);

    function BoxSelectionOverlay() {
      return BoxSelectionOverlay.__super__.constructor.apply(this, arguments);
    }

    BoxSelectionOverlay.prototype.type = 'BoxSelectionOverlay';

    BoxSelectionOverlay.prototype.default_view = BoxSelectionOverlayView;

    return BoxSelectionOverlay;

  })(HasParent);

  BoxSelectionOverlay.prototype.defaults = _.clone(BoxSelectionOverlay.prototype.defaults);

  _.extend(BoxSelectionOverlay.prototype.defaults, {
    tool: null,
    level: 'overlay'
  });

  BoxSelectionOverlays = (function(_super) {

    __extends(BoxSelectionOverlays, _super);

    function BoxSelectionOverlays() {
      return BoxSelectionOverlays.__super__.constructor.apply(this, arguments);
    }

    BoxSelectionOverlays.prototype.model = BoxSelectionOverlay;

    return BoxSelectionOverlays;

  })(Backbone.Collection);

  exports.boxselectionoverlays = new BoxSelectionOverlays;

  exports.BoxSelectionOverlayView = BoxSelectionOverlayView;

  exports.BoxSelectionOverlay = BoxSelectionOverlay;

}).call(this);
}, "palettes/colorbrewer": function(exports, require, module) {(function() {
  var colorbrewer;

  colorbrewer = {
    YlGn: {
      3: [0xf7fcb9, 0xaddd8e, 0x31a354],
      4: [0xffffcc, 0xc2e699, 0x78c679, 0x238443],
      5: [0xffffcc, 0xc2e699, 0x78c679, 0x31a354, 0x006837],
      6: [0xffffcc, 0xd9f0a3, 0xaddd8e, 0x78c679, 0x31a354, 0x006837],
      7: [0xffffcc, 0xd9f0a3, 0xaddd8e, 0x78c679, 0x41ab5d, 0x238443, 0x005a32],
      8: [0xffffe5, 0xf7fcb9, 0xd9f0a3, 0xaddd8e, 0x78c679, 0x41ab5d, 0x238443, 0x005a32],
      9: [0xffffe5, 0xf7fcb9, 0xd9f0a3, 0xaddd8e, 0x78c679, 0x41ab5d, 0x238443, 0x006837, 0x004529]
    },
    YlGnBu: {
      3: [0xedf8b1, 0x7fcdbb, 0x2c7fb8],
      4: [0xffffcc, 0xa1dab4, 0x41b6c4, 0x225ea8],
      5: [0xffffcc, 0xa1dab4, 0x41b6c4, 0x2c7fb8, 0x253494],
      6: [0xffffcc, 0xc7e9b4, 0x7fcdbb, 0x41b6c4, 0x2c7fb8, 0x253494],
      7: [0xffffcc, 0xc7e9b4, 0x7fcdbb, 0x41b6c4, 0x1d91c0, 0x225ea8, 0x0c2c84],
      8: [0xffffd9, 0xedf8b1, 0xc7e9b4, 0x7fcdbb, 0x41b6c4, 0x1d91c0, 0x225ea8, 0x0c2c84],
      9: [0xffffd9, 0xedf8b1, 0xc7e9b4, 0x7fcdbb, 0x41b6c4, 0x1d91c0, 0x225ea8, 0x253494, 0x081d58]
    },
    GnBu: {
      3: [0xe0f3db, 0xa8ddb5, 0x43a2ca],
      4: [0xf0f9e8, 0xbae4bc, 0x7bccc4, 0x2b8cbe],
      5: [0xf0f9e8, 0xbae4bc, 0x7bccc4, 0x43a2ca, 0x0868ac],
      6: [0xf0f9e8, 0xccebc5, 0xa8ddb5, 0x7bccc4, 0x43a2ca, 0x0868ac],
      7: [0xf0f9e8, 0xccebc5, 0xa8ddb5, 0x7bccc4, 0x4eb3d3, 0x2b8cbe, 0x08589e],
      8: [0xf7fcf0, 0xe0f3db, 0xccebc5, 0xa8ddb5, 0x7bccc4, 0x4eb3d3, 0x2b8cbe, 0x08589e],
      9: [0xf7fcf0, 0xe0f3db, 0xccebc5, 0xa8ddb5, 0x7bccc4, 0x4eb3d3, 0x2b8cbe, 0x0868ac, 0x084081]
    },
    BuGn: {
      3: [0xe5f5f9, 0x99d8c9, 0x2ca25f],
      4: [0xedf8fb, 0xb2e2e2, 0x66c2a4, 0x238b45],
      5: [0xedf8fb, 0xb2e2e2, 0x66c2a4, 0x2ca25f, 0x006d2c],
      6: [0xedf8fb, 0xccece6, 0x99d8c9, 0x66c2a4, 0x2ca25f, 0x006d2c],
      7: [0xedf8fb, 0xccece6, 0x99d8c9, 0x66c2a4, 0x41ae76, 0x238b45, 0x005824],
      8: [0xf7fcfd, 0xe5f5f9, 0xccece6, 0x99d8c9, 0x66c2a4, 0x41ae76, 0x238b45, 0x005824],
      9: [0xf7fcfd, 0xe5f5f9, 0xccece6, 0x99d8c9, 0x66c2a4, 0x41ae76, 0x238b45, 0x006d2c, 0x00441b]
    },
    PuBuGn: {
      3: [0xece2f0, 0xa6bddb, 0x1c9099],
      4: [0xf6eff7, 0xbdc9e1, 0x67a9cf, 0x02818a],
      5: [0xf6eff7, 0xbdc9e1, 0x67a9cf, 0x1c9099, 0x016c59],
      6: [0xf6eff7, 0xd0d1e6, 0xa6bddb, 0x67a9cf, 0x1c9099, 0x016c59],
      7: [0xf6eff7, 0xd0d1e6, 0xa6bddb, 0x67a9cf, 0x3690c0, 0x02818a, 0x016450],
      8: [0xfff7fb, 0xece2f0, 0xd0d1e6, 0xa6bddb, 0x67a9cf, 0x3690c0, 0x02818a, 0x016450],
      9: [0xfff7fb, 0xece2f0, 0xd0d1e6, 0xa6bddb, 0x67a9cf, 0x3690c0, 0x02818a, 0x016c59, 0x014636]
    },
    PuBu: {
      3: [0xece7f2, 0xa6bddb, 0x2b8cbe],
      4: [0xf1eef6, 0xbdc9e1, 0x74a9cf, 0x0570b0],
      5: [0xf1eef6, 0xbdc9e1, 0x74a9cf, 0x2b8cbe, 0x045a8d],
      6: [0xf1eef6, 0xd0d1e6, 0xa6bddb, 0x74a9cf, 0x2b8cbe, 0x045a8d],
      7: [0xf1eef6, 0xd0d1e6, 0xa6bddb, 0x74a9cf, 0x3690c0, 0x0570b0, 0x034e7b],
      8: [0xfff7fb, 0xece7f2, 0xd0d1e6, 0xa6bddb, 0x74a9cf, 0x3690c0, 0x0570b0, 0x034e7b],
      9: [0xfff7fb, 0xece7f2, 0xd0d1e6, 0xa6bddb, 0x74a9cf, 0x3690c0, 0x0570b0, 0x045a8d, 0x023858]
    },
    BuPu: {
      3: [0xe0ecf4, 0x9ebcda, 0x8856a7],
      4: [0xedf8fb, 0xb3cde3, 0x8c96c6, 0x88419d],
      5: [0xedf8fb, 0xb3cde3, 0x8c96c6, 0x8856a7, 0x810f7c],
      6: [0xedf8fb, 0xbfd3e6, 0x9ebcda, 0x8c96c6, 0x8856a7, 0x810f7c],
      7: [0xedf8fb, 0xbfd3e6, 0x9ebcda, 0x8c96c6, 0x8c6bb1, 0x88419d, 0x6e016b],
      8: [0xf7fcfd, 0xe0ecf4, 0xbfd3e6, 0x9ebcda, 0x8c96c6, 0x8c6bb1, 0x88419d, 0x6e016b],
      9: [0xf7fcfd, 0xe0ecf4, 0xbfd3e6, 0x9ebcda, 0x8c96c6, 0x8c6bb1, 0x88419d, 0x810f7c, 0x4d004b]
    },
    RdPu: {
      3: [0xfde0dd, 0xfa9fb5, 0xc51b8a],
      4: [0xfeebe2, 0xfbb4b9, 0xf768a1, 0xae017e],
      5: [0xfeebe2, 0xfbb4b9, 0xf768a1, 0xc51b8a, 0x7a0177],
      6: [0xfeebe2, 0xfcc5c0, 0xfa9fb5, 0xf768a1, 0xc51b8a, 0x7a0177],
      7: [0xfeebe2, 0xfcc5c0, 0xfa9fb5, 0xf768a1, 0xdd3497, 0xae017e, 0x7a0177],
      8: [0xfff7f3, 0xfde0dd, 0xfcc5c0, 0xfa9fb5, 0xf768a1, 0xdd3497, 0xae017e, 0x7a0177],
      9: [0xfff7f3, 0xfde0dd, 0xfcc5c0, 0xfa9fb5, 0xf768a1, 0xdd3497, 0xae017e, 0x7a0177, 0x49006a]
    },
    PuRd: {
      3: [0xe7e1ef, 0xc994c7, 0xdd1c77],
      4: [0xf1eef6, 0xd7b5d8, 0xdf65b0, 0xce1256],
      5: [0xf1eef6, 0xd7b5d8, 0xdf65b0, 0xdd1c77, 0x980043],
      6: [0xf1eef6, 0xd4b9da, 0xc994c7, 0xdf65b0, 0xdd1c77, 0x980043],
      7: [0xf1eef6, 0xd4b9da, 0xc994c7, 0xdf65b0, 0xe7298a, 0xce1256, 0x91003f],
      8: [0xf7f4f9, 0xe7e1ef, 0xd4b9da, 0xc994c7, 0xdf65b0, 0xe7298a, 0xce1256, 0x91003f],
      9: [0xf7f4f9, 0xe7e1ef, 0xd4b9da, 0xc994c7, 0xdf65b0, 0xe7298a, 0xce1256, 0x980043, 0x67001f]
    },
    OrRd: {
      3: [0xfee8c8, 0xfdbb84, 0xe34a33],
      4: [0xfef0d9, 0xfdcc8a, 0xfc8d59, 0xd7301f],
      5: [0xfef0d9, 0xfdcc8a, 0xfc8d59, 0xe34a33, 0xb30000],
      6: [0xfef0d9, 0xfdd49e, 0xfdbb84, 0xfc8d59, 0xe34a33, 0xb30000],
      7: [0xfef0d9, 0xfdd49e, 0xfdbb84, 0xfc8d59, 0xef6548, 0xd7301f, 0x990000],
      8: [0xfff7ec, 0xfee8c8, 0xfdd49e, 0xfdbb84, 0xfc8d59, 0xef6548, 0xd7301f, 0x990000],
      9: [0xfff7ec, 0xfee8c8, 0xfdd49e, 0xfdbb84, 0xfc8d59, 0xef6548, 0xd7301f, 0xb30000, 0x7f0000]
    },
    YlOrRd: {
      3: [0xffeda0, 0xfeb24c, 0xf03b20],
      4: [0xffffb2, 0xfecc5c, 0xfd8d3c, 0xe31a1c],
      5: [0xffffb2, 0xfecc5c, 0xfd8d3c, 0xf03b20, 0xbd0026],
      6: [0xffffb2, 0xfed976, 0xfeb24c, 0xfd8d3c, 0xf03b20, 0xbd0026],
      7: [0xffffb2, 0xfed976, 0xfeb24c, 0xfd8d3c, 0xfc4e2a, 0xe31a1c, 0xb10026],
      8: [0xffffcc, 0xffeda0, 0xfed976, 0xfeb24c, 0xfd8d3c, 0xfc4e2a, 0xe31a1c, 0xb10026],
      9: [0xffffcc, 0xffeda0, 0xfed976, 0xfeb24c, 0xfd8d3c, 0xfc4e2a, 0xe31a1c, 0xbd0026, 0x800026]
    },
    YlOrBr: {
      3: [0xfff7bc, 0xfec44f, 0xd95f0e],
      4: [0xffffd4, 0xfed98e, 0xfe9929, 0xcc4c02],
      5: [0xffffd4, 0xfed98e, 0xfe9929, 0xd95f0e, 0x993404],
      6: [0xffffd4, 0xfee391, 0xfec44f, 0xfe9929, 0xd95f0e, 0x993404],
      7: [0xffffd4, 0xfee391, 0xfec44f, 0xfe9929, 0xec7014, 0xcc4c02, 0x8c2d04],
      8: [0xffffe5, 0xfff7bc, 0xfee391, 0xfec44f, 0xfe9929, 0xec7014, 0xcc4c02, 0x8c2d04],
      9: [0xffffe5, 0xfff7bc, 0xfee391, 0xfec44f, 0xfe9929, 0xec7014, 0xcc4c02, 0x993404, 0x662506]
    },
    Purples: {
      3: [0xefedf5, 0xbcbddc, 0x756bb1],
      4: [0xf2f0f7, 0xcbc9e2, 0x9e9ac8, 0x6a51a3],
      5: [0xf2f0f7, 0xcbc9e2, 0x9e9ac8, 0x756bb1, 0x54278f],
      6: [0xf2f0f7, 0xdadaeb, 0xbcbddc, 0x9e9ac8, 0x756bb1, 0x54278f],
      7: [0xf2f0f7, 0xdadaeb, 0xbcbddc, 0x9e9ac8, 0x807dba, 0x6a51a3, 0x4a1486],
      8: [0xfcfbfd, 0xefedf5, 0xdadaeb, 0xbcbddc, 0x9e9ac8, 0x807dba, 0x6a51a3, 0x4a1486],
      9: [0xfcfbfd, 0xefedf5, 0xdadaeb, 0xbcbddc, 0x9e9ac8, 0x807dba, 0x6a51a3, 0x54278f, 0x3f007d]
    },
    Blues: {
      3: [0xdeebf7, 0x9ecae1, 0x3182bd],
      4: [0xeff3ff, 0xbdd7e7, 0x6baed6, 0x2171b5],
      5: [0xeff3ff, 0xbdd7e7, 0x6baed6, 0x3182bd, 0x08519c],
      6: [0xeff3ff, 0xc6dbef, 0x9ecae1, 0x6baed6, 0x3182bd, 0x08519c],
      7: [0xeff3ff, 0xc6dbef, 0x9ecae1, 0x6baed6, 0x4292c6, 0x2171b5, 0x084594],
      8: [0xf7fbff, 0xdeebf7, 0xc6dbef, 0x9ecae1, 0x6baed6, 0x4292c6, 0x2171b5, 0x084594],
      9: [0xf7fbff, 0xdeebf7, 0xc6dbef, 0x9ecae1, 0x6baed6, 0x4292c6, 0x2171b5, 0x08519c, 0x08306b]
    },
    Greens: {
      3: [0xe5f5e0, 0xa1d99b, 0x31a354],
      4: [0xedf8e9, 0xbae4b3, 0x74c476, 0x238b45],
      5: [0xedf8e9, 0xbae4b3, 0x74c476, 0x31a354, 0x006d2c],
      6: [0xedf8e9, 0xc7e9c0, 0xa1d99b, 0x74c476, 0x31a354, 0x006d2c],
      7: [0xedf8e9, 0xc7e9c0, 0xa1d99b, 0x74c476, 0x41ab5d, 0x238b45, 0x005a32],
      8: [0xf7fcf5, 0xe5f5e0, 0xc7e9c0, 0xa1d99b, 0x74c476, 0x41ab5d, 0x238b45, 0x005a32],
      9: [0xf7fcf5, 0xe5f5e0, 0xc7e9c0, 0xa1d99b, 0x74c476, 0x41ab5d, 0x238b45, 0x006d2c, 0x00441b]
    },
    Oranges: {
      3: [0xfee6ce, 0xfdae6b, 0xe6550d],
      4: [0xfeedde, 0xfdbe85, 0xfd8d3c, 0xd94701],
      5: [0xfeedde, 0xfdbe85, 0xfd8d3c, 0xe6550d, 0xa63603],
      6: [0xfeedde, 0xfdd0a2, 0xfdae6b, 0xfd8d3c, 0xe6550d, 0xa63603],
      7: [0xfeedde, 0xfdd0a2, 0xfdae6b, 0xfd8d3c, 0xf16913, 0xd94801, 0x8c2d04],
      8: [0xfff5eb, 0xfee6ce, 0xfdd0a2, 0xfdae6b, 0xfd8d3c, 0xf16913, 0xd94801, 0x8c2d04],
      9: [0xfff5eb, 0xfee6ce, 0xfdd0a2, 0xfdae6b, 0xfd8d3c, 0xf16913, 0xd94801, 0xa63603, 0x7f2704]
    },
    Reds: {
      3: [0xfee0d2, 0xfc9272, 0xde2d26],
      4: [0xfee5d9, 0xfcae91, 0xfb6a4a, 0xcb181d],
      5: [0xfee5d9, 0xfcae91, 0xfb6a4a, 0xde2d26, 0xa50f15],
      6: [0xfee5d9, 0xfcbba1, 0xfc9272, 0xfb6a4a, 0xde2d26, 0xa50f15],
      7: [0xfee5d9, 0xfcbba1, 0xfc9272, 0xfb6a4a, 0xef3b2c, 0xcb181d, 0x99000d],
      8: [0xfff5f0, 0xfee0d2, 0xfcbba1, 0xfc9272, 0xfb6a4a, 0xef3b2c, 0xcb181d, 0x99000d],
      9: [0xfff5f0, 0xfee0d2, 0xfcbba1, 0xfc9272, 0xfb6a4a, 0xef3b2c, 0xcb181d, 0xa50f15, 0x67000d]
    },
    Greys: {
      3: [0xf0f0f0, 0xbdbdbd, 0x636363],
      4: [0xf7f7f7, 0xcccccc, 0x969696, 0x525252],
      5: [0xf7f7f7, 0xcccccc, 0x969696, 0x636363, 0x252525],
      6: [0xf7f7f7, 0xd9d9d9, 0xbdbdbd, 0x969696, 0x636363, 0x252525],
      7: [0xf7f7f7, 0xd9d9d9, 0xbdbdbd, 0x969696, 0x737373, 0x525252, 0x252525],
      8: [0xffffff, 0xf0f0f0, 0xd9d9d9, 0xbdbdbd, 0x969696, 0x737373, 0x525252, 0x252525],
      9: [0xffffff, 0xf0f0f0, 0xd9d9d9, 0xbdbdbd, 0x969696, 0x737373, 0x525252, 0x252525, 0x000000]
    },
    PuOr: {
      3: [0xf1a340, 0xf7f7f7, 0x998ec3],
      4: [0xe66101, 0xfdb863, 0xb2abd2, 0x5e3c99],
      5: [0xe66101, 0xfdb863, 0xf7f7f7, 0xb2abd2, 0x5e3c99],
      6: [0xb35806, 0xf1a340, 0xfee0b6, 0xd8daeb, 0x998ec3, 0x542788],
      7: [0xb35806, 0xf1a340, 0xfee0b6, 0xf7f7f7, 0xd8daeb, 0x998ec3, 0x542788],
      8: [0xb35806, 0xe08214, 0xfdb863, 0xfee0b6, 0xd8daeb, 0xb2abd2, 0x8073ac, 0x542788],
      9: [0xb35806, 0xe08214, 0xfdb863, 0xfee0b6, 0xf7f7f7, 0xd8daeb, 0xb2abd2, 0x8073ac, 0x542788],
      10: [0x7f3b08, 0xb35806, 0xe08214, 0xfdb863, 0xfee0b6, 0xd8daeb, 0xb2abd2, 0x8073ac, 0x542788, 0x2d004b],
      11: [0x7f3b08, 0xb35806, 0xe08214, 0xfdb863, 0xfee0b6, 0xf7f7f7, 0xd8daeb, 0xb2abd2, 0x8073ac, 0x542788, 0x2d004b]
    },
    BrBG: {
      3: [0xd8b365, 0xf5f5f5, 0x5ab4ac],
      4: [0xa6611a, 0xdfc27d, 0x80cdc1, 0x018571],
      5: [0xa6611a, 0xdfc27d, 0xf5f5f5, 0x80cdc1, 0x018571],
      6: [0x8c510a, 0xd8b365, 0xf6e8c3, 0xc7eae5, 0x5ab4ac, 0x01665e],
      7: [0x8c510a, 0xd8b365, 0xf6e8c3, 0xf5f5f5, 0xc7eae5, 0x5ab4ac, 0x01665e],
      8: [0x8c510a, 0xbf812d, 0xdfc27d, 0xf6e8c3, 0xc7eae5, 0x80cdc1, 0x35978f, 0x01665e],
      9: [0x8c510a, 0xbf812d, 0xdfc27d, 0xf6e8c3, 0xf5f5f5, 0xc7eae5, 0x80cdc1, 0x35978f, 0x01665e],
      10: [0x543005, 0x8c510a, 0xbf812d, 0xdfc27d, 0xf6e8c3, 0xc7eae5, 0x80cdc1, 0x35978f, 0x01665e, 0x003c30],
      11: [0x543005, 0x8c510a, 0xbf812d, 0xdfc27d, 0xf6e8c3, 0xf5f5f5, 0xc7eae5, 0x80cdc1, 0x35978f, 0x01665e, 0x003c30]
    },
    PRGn: {
      3: [0xaf8dc3, 0xf7f7f7, 0x7fbf7b],
      4: [0x7b3294, 0xc2a5cf, 0xa6dba0, 0x008837],
      5: [0x7b3294, 0xc2a5cf, 0xf7f7f7, 0xa6dba0, 0x008837],
      6: [0x762a83, 0xaf8dc3, 0xe7d4e8, 0xd9f0d3, 0x7fbf7b, 0x1b7837],
      7: [0x762a83, 0xaf8dc3, 0xe7d4e8, 0xf7f7f7, 0xd9f0d3, 0x7fbf7b, 0x1b7837],
      8: [0x762a83, 0x9970ab, 0xc2a5cf, 0xe7d4e8, 0xd9f0d3, 0xa6dba0, 0x5aae61, 0x1b7837],
      9: [0x762a83, 0x9970ab, 0xc2a5cf, 0xe7d4e8, 0xf7f7f7, 0xd9f0d3, 0xa6dba0, 0x5aae61, 0x1b7837],
      10: [0x40004b, 0x762a83, 0x9970ab, 0xc2a5cf, 0xe7d4e8, 0xd9f0d3, 0xa6dba0, 0x5aae61, 0x1b7837, 0x00441b],
      11: [0x40004b, 0x762a83, 0x9970ab, 0xc2a5cf, 0xe7d4e8, 0xf7f7f7, 0xd9f0d3, 0xa6dba0, 0x5aae61, 0x1b7837, 0x00441b]
    },
    PiYG: {
      3: [0xe9a3c9, 0xf7f7f7, 0xa1d76a],
      4: [0xd01c8b, 0xf1b6da, 0xb8e186, 0x4dac26],
      5: [0xd01c8b, 0xf1b6da, 0xf7f7f7, 0xb8e186, 0x4dac26],
      6: [0xc51b7d, 0xe9a3c9, 0xfde0ef, 0xe6f5d0, 0xa1d76a, 0x4d9221],
      7: [0xc51b7d, 0xe9a3c9, 0xfde0ef, 0xf7f7f7, 0xe6f5d0, 0xa1d76a, 0x4d9221],
      8: [0xc51b7d, 0xde77ae, 0xf1b6da, 0xfde0ef, 0xe6f5d0, 0xb8e186, 0x7fbc41, 0x4d9221],
      9: [0xc51b7d, 0xde77ae, 0xf1b6da, 0xfde0ef, 0xf7f7f7, 0xe6f5d0, 0xb8e186, 0x7fbc41, 0x4d9221],
      10: [0x8e0152, 0xc51b7d, 0xde77ae, 0xf1b6da, 0xfde0ef, 0xe6f5d0, 0xb8e186, 0x7fbc41, 0x4d9221, 0x276419],
      11: [0x8e0152, 0xc51b7d, 0xde77ae, 0xf1b6da, 0xfde0ef, 0xf7f7f7, 0xe6f5d0, 0xb8e186, 0x7fbc41, 0x4d9221, 0x276419]
    },
    RdBu: {
      3: [0xef8a62, 0xf7f7f7, 0x67a9cf],
      4: [0xca0020, 0xf4a582, 0x92c5de, 0x0571b0],
      5: [0xca0020, 0xf4a582, 0xf7f7f7, 0x92c5de, 0x0571b0],
      6: [0xb2182b, 0xef8a62, 0xfddbc7, 0xd1e5f0, 0x67a9cf, 0x2166ac],
      7: [0xb2182b, 0xef8a62, 0xfddbc7, 0xf7f7f7, 0xd1e5f0, 0x67a9cf, 0x2166ac],
      8: [0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xd1e5f0, 0x92c5de, 0x4393c3, 0x2166ac],
      9: [0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xf7f7f7, 0xd1e5f0, 0x92c5de, 0x4393c3, 0x2166ac],
      10: [0x67001f, 0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xd1e5f0, 0x92c5de, 0x4393c3, 0x2166ac, 0x053061],
      11: [0x67001f, 0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xf7f7f7, 0xd1e5f0, 0x92c5de, 0x4393c3, 0x2166ac, 0x053061]
    },
    RdGy: {
      3: [0xef8a62, 0xffffff, 0x999999],
      4: [0xca0020, 0xf4a582, 0xbababa, 0x404040],
      5: [0xca0020, 0xf4a582, 0xffffff, 0xbababa, 0x404040],
      6: [0xb2182b, 0xef8a62, 0xfddbc7, 0xe0e0e0, 0x999999, 0x4d4d4d],
      7: [0xb2182b, 0xef8a62, 0xfddbc7, 0xffffff, 0xe0e0e0, 0x999999, 0x4d4d4d],
      8: [0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xe0e0e0, 0xbababa, 0x878787, 0x4d4d4d],
      9: [0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xffffff, 0xe0e0e0, 0xbababa, 0x878787, 0x4d4d4d],
      10: [0x67001f, 0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xe0e0e0, 0xbababa, 0x878787, 0x4d4d4d, 0x1a1a1a],
      11: [0x67001f, 0xb2182b, 0xd6604d, 0xf4a582, 0xfddbc7, 0xffffff, 0xe0e0e0, 0xbababa, 0x878787, 0x4d4d4d, 0x1a1a1a]
    },
    RdYlBu: {
      3: [0xfc8d59, 0xffffbf, 0x91bfdb],
      4: [0xd7191c, 0xfdae61, 0xabd9e9, 0x2c7bb6],
      5: [0xd7191c, 0xfdae61, 0xffffbf, 0xabd9e9, 0x2c7bb6],
      6: [0xd73027, 0xfc8d59, 0xfee090, 0xe0f3f8, 0x91bfdb, 0x4575b4],
      7: [0xd73027, 0xfc8d59, 0xfee090, 0xffffbf, 0xe0f3f8, 0x91bfdb, 0x4575b4],
      8: [0xd73027, 0xf46d43, 0xfdae61, 0xfee090, 0xe0f3f8, 0xabd9e9, 0x74add1, 0x4575b4],
      9: [0xd73027, 0xf46d43, 0xfdae61, 0xfee090, 0xffffbf, 0xe0f3f8, 0xabd9e9, 0x74add1, 0x4575b4],
      10: [0xa50026, 0xd73027, 0xf46d43, 0xfdae61, 0xfee090, 0xe0f3f8, 0xabd9e9, 0x74add1, 0x4575b4, 0x313695],
      11: [0xa50026, 0xd73027, 0xf46d43, 0xfdae61, 0xfee090, 0xffffbf, 0xe0f3f8, 0xabd9e9, 0x74add1, 0x4575b4, 0x313695]
    },
    Spectral: {
      3: [0xfc8d59, 0xffffbf, 0x99d594],
      4: [0xd7191c, 0xfdae61, 0xabdda4, 0x2b83ba],
      5: [0xd7191c, 0xfdae61, 0xffffbf, 0xabdda4, 0x2b83ba],
      6: [0xd53e4f, 0xfc8d59, 0xfee08b, 0xe6f598, 0x99d594, 0x3288bd],
      7: [0xd53e4f, 0xfc8d59, 0xfee08b, 0xffffbf, 0xe6f598, 0x99d594, 0x3288bd],
      8: [0xd53e4f, 0xf46d43, 0xfdae61, 0xfee08b, 0xe6f598, 0xabdda4, 0x66c2a5, 0x3288bd],
      9: [0xd53e4f, 0xf46d43, 0xfdae61, 0xfee08b, 0xffffbf, 0xe6f598, 0xabdda4, 0x66c2a5, 0x3288bd],
      10: [0x9e0142, 0xd53e4f, 0xf46d43, 0xfdae61, 0xfee08b, 0xe6f598, 0xabdda4, 0x66c2a5, 0x3288bd, 0x5e4fa2],
      11: [0x9e0142, 0xd53e4f, 0xf46d43, 0xfdae61, 0xfee08b, 0xffffbf, 0xe6f598, 0xabdda4, 0x66c2a5, 0x3288bd, 0x5e4fa2]
    },
    RdYlGn: {
      3: [0xfc8d59, 0xffffbf, 0x91cf60],
      4: [0xd7191c, 0xfdae61, 0xa6d96a, 0x1a9641],
      5: [0xd7191c, 0xfdae61, 0xffffbf, 0xa6d96a, 0x1a9641],
      6: [0xd73027, 0xfc8d59, 0xfee08b, 0xd9ef8b, 0x91cf60, 0x1a9850],
      7: [0xd73027, 0xfc8d59, 0xfee08b, 0xffffbf, 0xd9ef8b, 0x91cf60, 0x1a9850],
      8: [0xd73027, 0xf46d43, 0xfdae61, 0xfee08b, 0xd9ef8b, 0xa6d96a, 0x66bd63, 0x1a9850],
      9: [0xd73027, 0xf46d43, 0xfdae61, 0xfee08b, 0xffffbf, 0xd9ef8b, 0xa6d96a, 0x66bd63, 0x1a9850],
      10: [0xa50026, 0xd73027, 0xf46d43, 0xfdae61, 0xfee08b, 0xd9ef8b, 0xa6d96a, 0x66bd63, 0x1a9850, 0x006837],
      11: [0xa50026, 0xd73027, 0xf46d43, 0xfdae61, 0xfee08b, 0xffffbf, 0xd9ef8b, 0xa6d96a, 0x66bd63, 0x1a9850, 0x006837]
    }
  };

  exports.colorbrewer = colorbrewer;

}).call(this);
}, "palettes/palettes": function(exports, require, module) {(function() {
  var all_palettes, colorbrewer, items, name, num, pal;

  colorbrewer = require('./colorbrewer').colorbrewer;

  all_palettes = {};

  for (name in colorbrewer) {
    items = colorbrewer[name];
    for (num in items) {
      pal = items[num];
      all_palettes["" + name + "-" + num] = pal.reverse();
    }
  }

  exports.all_palettes = all_palettes;

}).call(this);
}, "pandas/pandas": function(exports, require, module) {(function() {
  var Collection, ContinuumView, ENTER, HasParent, HasProperties, IPythonRemoteData, PandasPivotTable, PandasPivotView, PandasPlotSource, PandasPlotSources, base, coll, datasource,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; },
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  base = require("../base");

  datasource = require("../common/datasource");

  ContinuumView = require("../common/continuum_view").ContinuumView;

  HasParent = base.HasParent;

  HasProperties = base.HasProperties;

  Collection = Backbone.Collection;

  IPythonRemoteData = (function(_super) {

    __extends(IPythonRemoteData, _super);

    function IPythonRemoteData() {
      return IPythonRemoteData.__super__.constructor.apply(this, arguments);
    }

    IPythonRemoteData.prototype.type = 'IPythonRemoteData';

    IPythonRemoteData.prototype.defaults = {
      computed_columns: []
    };

    return IPythonRemoteData;

  })(HasProperties);

  coll = Collection.extend({
    model: IPythonRemoteData
  });

  exports.ipythonremotedatas = new coll();

  ENTER = 13;

  PandasPlotSource = (function(_super) {

    __extends(PandasPlotSource, _super);

    function PandasPlotSource() {
      return PandasPlotSource.__super__.constructor.apply(this, arguments);
    }

    PandasPlotSource.prototype.type = 'PandasPlotSource';

    return PandasPlotSource;

  })(datasource.ColumnDataSource);

  coll = Collection.extend({
    model: PandasPlotSource
  });

  exports.pandasplotsources = new coll();

  PandasPlotSources = (function(_super) {

    __extends(PandasPlotSources, _super);

    function PandasPlotSources() {
      return PandasPlotSources.__super__.constructor.apply(this, arguments);
    }

    PandasPlotSources.prototype.model = PandasPlotSource;

    return PandasPlotSources;

  })(Backbone.Collection);

  PandasPivotView = (function(_super) {

    __extends(PandasPivotView, _super);

    function PandasPivotView() {
      this.colors = __bind(this.colors, this);

      this.pandasend = __bind(this.pandasend, this);

      this.pandasnext = __bind(this.pandasnext, this);

      this.pandasback = __bind(this.pandasback, this);

      this.pandasbeginning = __bind(this.pandasbeginning, this);

      this.toggle_more_controls = __bind(this.toggle_more_controls, this);

      this.sort = __bind(this.sort, this);

      this.rowclick = __bind(this.rowclick, this);

      this.toggle_filterselected = __bind(this.toggle_filterselected, this);

      this.clearselected = __bind(this.clearselected, this);

      this.computedtxtbox = __bind(this.computedtxtbox, this);

      this.column_del = __bind(this.column_del, this);

      this.search = __bind(this.search, this);
      return PandasPivotView.__super__.constructor.apply(this, arguments);
    }

    PandasPivotView.prototype.template = require("./pandaspivot");

    PandasPivotView.prototype.initialize = function(options) {
      PandasPivotView.__super__.initialize.call(this, options);
      this.listenTo(this.model, 'destroy', this.remove);
      this.listenTo(this.model, 'change', this.render);
      return this.render();
    };

    PandasPivotView.prototype.events = {
      "keyup .pandasgroup": 'pandasgroup',
      "keyup .pandasoffset": 'pandasoffset',
      "keyup .pandassize": 'pandassize',
      "change .pandasagg": 'pandasagg',
      "change .tablecontrolstate": 'tablecontrolstate',
      "click .pandasbeginning": 'pandasbeginning',
      "click .pandasback": 'pandasback',
      "click .pandasnext": 'pandasnext',
      "click .pandasend": 'pandasend',
      "click .controlsmore": 'toggle_more_controls',
      "click .pandascolumn": 'sort',
      "click .pandasrow": 'rowclick',
      "click .filterselected": 'toggle_filterselected',
      "click .clearselected": 'clearselected',
      "keyup .computedtxtbox": 'computedtxtbox',
      "click .column_del": "column_del",
      "keyup .search": 'search'
    };

    PandasPivotView.prototype.search = function(e) {
      var code, source;
      if (e.keyCode === ENTER) {
        code = $(e.currentTarget).val();
        source = this.model.get_obj('source');
        source.rpc('search', [code]);
        return e.preventDefault();
      }
    };

    PandasPivotView.prototype.column_del = function(e) {
      var computed_columns, name, old, source;
      source = this.model.get_obj('source');
      old = source.get('computed_columns');
      name = $(e.currentTarget).attr('name');
      computed_columns = _.filter(old, function(x) {
        return x.name !== name;
      });
      return source.rpc('set_computed_columns', [computed_columns]);
    };

    PandasPivotView.prototype.computedtxtbox = function(e) {
      var code, name, old, source;
      if (e.keyCode === ENTER) {
        name = this.$('.computedname').val();
        code = this.$('.computedtxtbox').val();
        source = this.model.get_obj('source');
        old = source.get('computed_columns');
        old.push({
          name: name,
          code: code
        });
        source.rpc('set_computed_columns', [old]);
        return e.preventDefault();
      }
    };

    PandasPivotView.prototype.clearselected = function(e) {
      return this.model.rpc('setselect', [[]]);
    };

    PandasPivotView.prototype.toggle_filterselected = function(e) {
      var checked;
      checked = this.$('.filterselected').is(":checked");
      this.mset('filterselected', checked);
      return this.model.save();
    };

    PandasPivotView.prototype.rowclick = function(e) {
      var count, counts, idx, index, ratio, ratios, resp, rownum, select, selected;
      counts = this.counts();
      selected = this.selected();
      ratios = (function() {
        var _i, _len, _ref, _ref1, _results;
        _ref = _.zip(selected, counts);
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          _ref1 = _ref[_i], select = _ref1[0], count = _ref1[1];
          _results.push(select / count);
        }
        return _results;
      })();
      selected = (function() {
        var _i, _len, _results;
        _results = [];
        for (idx = _i = 0, _len = ratios.length; _i < _len; idx = ++_i) {
          ratio = ratios[idx];
          if (ratio > 0.5) {
            _results.push(idx);
          }
        }
        return _results;
      })();
      rownum = Number($(e.currentTarget).attr('rownum'));
      index = selected.indexOf(rownum);
      if (index === -1) {
        resp = this.model.rpc('select', [[rownum]]);
      } else {
        resp = this.model.rpc('deselect', [[rownum]]);
      }
      return null;
    };

    PandasPivotView.prototype.sort = function(e) {
      var colname;
      colname = $(e.currentTarget).text();
      return this.model.toggle_column_sort(colname);
    };

    PandasPivotView.prototype.toggle_more_controls = function() {
      if (this.controls_hide) {
        this.controls_hide = false;
      } else {
        this.controls_hide = true;
      }
      return this.render();
    };

    PandasPivotView.prototype.pandasbeginning = function() {
      return this.model.go_beginning();
    };

    PandasPivotView.prototype.pandasback = function() {
      return this.model.go_back();
    };

    PandasPivotView.prototype.pandasnext = function() {
      return this.model.go_forward();
    };

    PandasPivotView.prototype.pandasend = function() {
      return this.model.go_end();
    };

    PandasPivotView.prototype.pandasoffset = function(e) {
      var offset;
      if (e.keyCode === ENTER) {
        offset = this.$el.find('.pandasoffset').val();
        offset = Number(offset);
        if (_.isNaN(offset)) {
          offset = this.model.defaults.offset;
        }
        this.model.save('offset', offset, {
          wait: true
        });
        return e.preventDefault();
      }
    };

    PandasPivotView.prototype.pandassize = function(e) {
      var size, sizetxt;
      if (e.keyCode === ENTER) {
        sizetxt = this.$el.find('.pandassize').val();
        size = Number(sizetxt);
        if (_.isNaN(size) || sizetxt === "") {
          size = this.model.defaults.length;
        }
        if (size + this.mget('offset') > this.mget('maxlength')) {
          size = this.mget('maxlength') - this.mget('offset');
        }
        this.model.save('length', size, {
          wait: true
        });
        return e.preventDefault();
      }
    };

    PandasPivotView.prototype.tablecontrolstate = function() {
      return this.mset('tablecontrolstate', this.$('.tablecontrolstate').val());
    };

    PandasPivotView.prototype.pandasagg = function() {
      return this.model.save('agg', this.$el.find('.pandasagg').val(), {
        'wait': true
      });
    };

    PandasPivotView.prototype.fromcsv = function(str) {
      if (!str) {
        return [];
      }
      return _.map(str.split(","), function(x) {
        return x.trim();
      });
    };

    PandasPivotView.prototype.pandasgroup = function(e) {
      if (e.keyCode === ENTER) {
        this.model.set({
          group: this.fromcsv(this.$el.find(".pandasgroup").val()),
          offset: 0
        });
        this.model.save();
        e.preventDefault();
        return false;
      }
    };

    PandasPivotView.prototype.counts = function() {
      return this.mget('tabledata').data._counts;
    };

    PandasPivotView.prototype.selected = function() {
      return this.mget('tabledata').data._selected;
    };

    PandasPivotView.prototype.colors = function() {
      var counts, selected;
      counts = this.counts();
      selected = this.selected();
      if (counts && selected) {
        return _.map(_.zip(counts, selected), function(temp) {
          var alpha, count;
          count = temp[0], selected = temp[1];
          alpha = 0.3 * selected / count;
          return "rgba(0,0,255," + alpha + ")";
        });
      } else {
        return null;
      }
    };

    PandasPivotView.prototype.render = function() {
      var colors, group, html, obj, sort, sort_ascendings, source, template_data, _i, _len, _ref;
      group = this.mget('group');
      if (_.isArray(group)) {
        group = group.join(",");
      }
      sort = this.mget('sort');
      if (_.isArray(sort)) {
        sort = sort.join(",");
      }
      colors = this.colors();
      sort_ascendings = {};
      _ref = this.mget('sort');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        obj = _ref[_i];
        sort_ascendings[obj['column']] = obj['ascending'];
      }
      source = this.mget_obj('source');
      template_data = {
        skip: {
          _counts: true,
          _selected: true,
          index: true
        },
        tablecontrolstate: this.mget('tablecontrolstate'),
        computed_columns: this.mget_obj('source').get('computed_columns'),
        columns: this.mget('tabledata').column_names,
        data: this.mget('tabledata').data,
        group: group,
        sort_ascendings: sort_ascendings,
        height: this.mget('height'),
        width: this.mget('width'),
        offset: this.mget('offset'),
        length: this.model.length(),
        filterselected: this.mget('filterselected'),
        totallength: this.mget('totallength'),
        counts: this.mget('tabledata').data._counts,
        selected: this.mget('tabledata').data._selected,
        controls_hide: this.controls_hide,
        colors: colors,
        index: this.mget('tabledata').data.index
      };
      this.$el.empty();
      html = this.template(template_data);
      this.$el.html(html);
      this.$(".pandasagg").find("option[value=\"" + (this.mget('agg')) + "\"]").attr('selected', 'selected');
      this.$(".tablecontrolstate").find("option[value=\"" + (this.mget('tablecontrolstate')) + "\"]").attr('selected', 'selected');
      return this.$el.addClass("bokehtable");
    };

    return PandasPivotView;

  })(ContinuumView);

  PandasPivotTable = (function(_super) {

    __extends(PandasPivotTable, _super);

    function PandasPivotTable() {
      this.toggle_column_sort = __bind(this.toggle_column_sort, this);

      this.dinitialize = __bind(this.dinitialize, this);
      return PandasPivotTable.__super__.constructor.apply(this, arguments);
    }

    PandasPivotTable.prototype.type = 'PandasPivotTable';

    PandasPivotTable.prototype.initialize = function(attrs, options) {
      var _this = this;
      PandasPivotTable.__super__.initialize.call(this, attrs, options);
      return this.throttled_fetch = _.throttle((function() {
        return _this.fetch();
      }), 500);
    };

    PandasPivotTable.prototype.dinitialize = function(attrs, options) {
      return PandasPivotTable.__super__.dinitialize.call(this, attrs, options);
    };

    PandasPivotTable.prototype.fetch = function(options) {
      return PandasPivotTable.__super__.fetch.call(this, options);
    };

    PandasPivotTable.prototype.length = function() {
      return _.values(this.get('tabledata').data)[0].length;
    };

    PandasPivotTable.prototype.toggle_column_sort = function(colname) {
      var sort, sorting;
      sorting = this.get('sort');
      this.unset('sort', {
        'silent': true
      });
      sort = _.filter(sorting, function(x) {
        return x['column'] === colname;
      });
      if (sort.length > 0) {
        sort = sort[0];
      } else {
        sorting = _.clone(sorting);
        sorting.push({
          column: colname,
          ascending: true
        });
        this.save('sort', sorting, {
          'wait': true
        });
        return;
      }
      if (sort['ascending']) {
        sort['ascending'] = false;
        this.save('sort', sorting, {
          'wait': true
        });
      } else {
        sorting = _.filter(sorting, function(x) {
          return x['column'] !== colname;
        });
        this.save('sort', sorting, {
          'wait': true
        });
      }
    };

    PandasPivotTable.prototype.go_beginning = function() {
      this.set('offset', 0);
      return this.save();
    };

    PandasPivotTable.prototype.go_back = function() {
      var offset;
      offset = this.get('offset');
      offset = offset - this.length();
      if (offset < 0) {
        offset = 0;
      }
      this.set('offset', offset);
      return this.save();
    };

    PandasPivotTable.prototype.go_forward = function() {
      var maxoffset, offset;
      offset = this.get('offset');
      offset = offset + this.length();
      maxoffset = this.get('maxlength') - this.length();
      if (offset > maxoffset) {
        offset = maxoffset;
      }
      this.set('offset', offset);
      return this.save();
    };

    PandasPivotTable.prototype.go_end = function() {
      var maxoffset;
      maxoffset = this.get('maxlength') - this.length();
      this.set('offset', maxoffset);
      return this.save();
    };

    PandasPivotTable.prototype.defaults = {
      sort: [],
      group: [],
      agg: 'sum',
      offset: 0,
      length: 100,
      maxlength: 1000,
      tabledata: null,
      columns_names: [],
      width: null,
      tablecontrolstate: 'groupby'
    };

    PandasPivotTable.prototype.default_view = PandasPivotView;

    return PandasPivotTable;

  })(HasParent);

  coll = Collection.extend({
    model: PandasPivotTable
  });

  exports.pandaspivottables = new coll();

}).call(this);
}, "pandas/pandaspivot": function(exports, require, module) {module.exports = function(__obj) {
  if (!__obj) __obj = {};
  var __out = [], __capture = function(callback) {
    var out = __out, result;
    __out = [];
    callback.call(this);
    result = __out.join('');
    __out = out;
    return __safe(result);
  }, __sanitize = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else if (typeof value !== 'undefined' && value != null) {
      return __escape(value);
    } else {
      return '';
    }
  }, __safe, __objSafe = __obj.safe, __escape = __obj.escape;
  __safe = __obj.safe = function(value) {
    if (value && value.ecoSafe) {
      return value;
    } else {
      if (!(typeof value !== 'undefined' && value != null)) value = '';
      var result = new String(value);
      result.ecoSafe = true;
      return result;
    }
  };
  if (!__escape) {
    __escape = __obj.escape = function(value) {
      return ('' + value)
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;');
    };
  }
  (function() {
    (function() {
      var column, computed_column, idx, _i, _j, _k, _l, _len, _len1, _len2, _len3, _ref, _ref1, _ref2, _ref3;
    
      __out.push('<form class="form-inline tablecontrolform">\n<label>Transform </label>:  <select class="tablecontrolstate">\n    <option value="groupby" selected="selected">Group By</option>\n    <option value="filtering">Filtering</option>\n    <option value="computed">Computed Columns</option>\n  </select>\n  <br/>\n  ');
    
      if (this.tablecontrolstate === 'groupby') {
        __out.push('\n  <label>GroupBy </label>\n  <input type="text" class="pandasgroup" value="');
        __out.push(__sanitize(this.group));
        __out.push('"/>\n  <label>Aggregation</label>\n  <select class="pandasagg">\n    <option value="sum">sum</option>\n    <option value="mean">mean</option>\n    <option value="std">std</option>\n    <option value="max">max</option>\n    <option value="min">min</option>\n  </select>\n  ');
      }
    
      __out.push('\n  ');
    
      if (this.tablecontrolstate === 'filtering') {
        __out.push('\n  <label class="checkbox" >\n    ');
        if (this.filterselected) {
          __out.push('\n    <input type="checkbox" class="filterselected" checked="checked"/>\n    ');
        } else {
          __out.push('\n    <input type="checkbox" class="filterselected"/>\n    ');
        }
        __out.push('\n    Filter Selection\n  </label>\n  <input type="button" class="clearselected btn btn-mini" value="Clear Selection"/>\n  <label>\n    Search\n  </label>\n  <input type="text" class="search input-large"/>\n  ');
      }
    
      __out.push('\n  \n  ');
    
      if (this.tablecontrolstate === 'computed') {
        __out.push('\n  <table class="table">\n    <thead>\n      <th>\n        Name\n      </th>\n      <th>\n        Value\n      </th>\n      <th>\n      </th>\n    </thead>\n    ');
        _ref = this.computed_columns;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          computed_column = _ref[_i];
          __out.push('\n    <tr>\n      <td>\n        ');
          __out.push(__sanitize(computed_column.name));
          __out.push('\n      </td>\n      <td>\n        ');
          __out.push(__sanitize(computed_column.code));
          __out.push('\n      </td>\n      <td>\n        <a class="column_del" \n           name="');
          __out.push(__sanitize(computed_column.name));
          __out.push('" href="#">[delete]</a>\n      </td>\n    </tr>\n    ');
        }
        __out.push('\n    <tr>\n      <td>\n        <input type="text" class="computedname input-mini"/>\n      </td>\n      <td>\n        <input type="text" class="computedtxtbox input-medium"/>\n      </td>\n      <td>\n      </td>\n    </tr>\n  </table>\n  ');
      }
    
      __out.push('\n  \n</form>\n\n<table class="bokehdatatable table table-bordered"\n');
    
      if (this.width) {
        __out.push('\n       style="max-height:');
        __out.push(__sanitize(this.height));
        __out.push('px;max-width:');
        __out.push(__sanitize(this.width));
        __out.push('px"\n');
      } else {
        __out.push('\n       style="max-height:');
        __out.push(__sanitize(this.height));
        __out.push('px"\n');
      }
    
      __out.push('\n       >\n  <thead>\n    ');
    
      if (this.counts) {
        __out.push('\n    <th>counts</th>\n    ');
      }
    
      __out.push('\n    <th>index</th>\n    ');
    
      _ref1 = this.columns;
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        column = _ref1[_j];
        __out.push('\n    ');
        if (!this.skip[column]) {
          __out.push('\n    <th><a class="pandascolumn">');
          __out.push(__sanitize(column));
          __out.push('</a>\n      \n      ');
          if (this.sort_ascendings[column] === true) {
            __out.push('\n      <i class="icon-caret-up"></i>\n      ');
          } else if (this.sort_ascendings[column] === false) {
            __out.push('\n      <i class="icon-caret-down"></i>\n      ');
          }
          __out.push('\n      \n      ');
        }
        __out.push('\n    </th>\n    ');
      }
    
      __out.push('\n  </thead>\n  ');
    
      _ref2 = _.range(this.length);
      for (_k = 0, _len2 = _ref2.length; _k < _len2; _k++) {
        idx = _ref2[_k];
        __out.push('\n  <tr class="pandasrow" rownum="');
        __out.push(__sanitize(idx));
        __out.push('">\n    ');
        if (this.selected && this.selected[idx]) {
          __out.push('\n      <td style="background-color:');
          __out.push(__sanitize(this.colors[idx]));
          __out.push('"> \n        ');
          __out.push(__sanitize(this.selected[idx]));
          __out.push('/');
          __out.push(__sanitize(this.counts[idx]));
          __out.push('\n      </td>      \n    ');
        } else {
          __out.push('\n      <td> ');
          __out.push(__sanitize(this.counts[idx]));
          __out.push(' </td>\n    ');
        }
        __out.push('\n    <td> ');
        __out.push(__sanitize(this.index[idx]));
        __out.push(' </td>\n    ');
        _ref3 = this.columns;
        for (_l = 0, _len3 = _ref3.length; _l < _len3; _l++) {
          column = _ref3[_l];
          __out.push('\n      ');
          if (!this.skip[column]) {
            __out.push('    \n      <td> ');
            __out.push(__sanitize(this.data[column][idx]));
            __out.push(' </td>\n      ');
          }
          __out.push('\n    ');
        }
        __out.push('\n  </tr>\n  ');
      }
    
      __out.push('\n</table>\n<form>\n  <center>\n    <div class="btn-group pagination">\n      <button class="btn btn-mini">First</button>\n      <button class="btn btn-mini">Previous</button>\n      <button class="btn btn-mini">Next</button>\n      <button class="btn btn-mini">Last</button>  \n    </div>\n    <div class="paginatedisplay">\n      Show <input type="text" class="pandassize" value="');
    
      __out.push(__sanitize(this.length));
    
      __out.push('"> records\n      From <input type="text" class="pandasoffset" value="');
    
      __out.push(__sanitize(this.offset));
    
      __out.push('">\n      to ');
    
      __out.push(__sanitize(this.length + this.offset));
    
      __out.push(' - \n      Total : ');
    
      __out.push(__sanitize(this.totallength));
    
      __out.push('\n    </div>\n  </center>\n</form>\n');
    
    }).call(this);
    
  }).call(__obj);
  __obj.safe = __objSafe, __obj.escape = __escape;
  return __out.join('');
}}, "renderers/annotation/legend": function(exports, require, module) {(function() {
  var HasParent, Legend, LegendView, PlotWidget, base, line_properties, properties, text_properties, textutils,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../../base');

  HasParent = base.HasParent;

  PlotWidget = require('../../common/plot_widget').PlotWidget;

  properties = require('../properties');

  textutils = require('../../common/textutils');

  line_properties = properties.line_properties;

  text_properties = properties.text_properties;

  "Legends:\n\nlegend_padding is the boundary between the legend and the edge of the plot\nlegend_spacing goes between each legend entry and the edge of the legend,\nas well as between 2 adjacent legend entries.  It is also the space between\nthe legend label, and the legend glyph.\n\nA legend in the top right corner looks like this\n\nplotborder\npadding\nlegendborder\nspacing\nlegendborder|spacing|label|spacing|glyph|spacing|legendborder|padding|plotborder\nspacing\nlegendborder|spacing|label|spacing|glyph|spacing|legendborder|padding|plotborder\nspacing\nborder\n";


  LegendView = (function(_super) {

    __extends(LegendView, _super);

    function LegendView() {
      return LegendView.__super__.constructor.apply(this, arguments);
    }

    LegendView.prototype.initialize = function(options) {
      LegendView.__super__.initialize.call(this, options);
      return this.change_annotationspec();
    };

    LegendView.prototype.delegateEvents = function(events) {
      LegendView.__super__.delegateEvents.call(this, events);
      this.listenTo(this.model, 'change:annotationspec', this.change_annotationspec);
      return this.listenTo(this.plot_view.view_state, 'change', this.calc_dims);
    };

    LegendView.prototype.change_annotationspec = function() {
      this.annotationspec = this.mget('annotationspec');
      this.label_props = new text_properties(this, this.annotationspec, 'label_');
      this.border_props = new line_properties(this, this.annotationspec, 'border_');
      if (this.annotationspec.legend_names) {
        this.legend_names = this.annotationspec.legend_names;
      } else {
        this.legend_names = _.keys(this.annotationspec.legends);
      }
      return this.calc_dims();
    };

    LegendView.prototype.calc_dims = function(options) {
      var ctx, h_range, label_height, label_width, legend_padding, legend_spacing, orientation, text_width, text_widths, v_range, x, y, _ref, _ref1, _ref2, _ref3, _ref4, _ref5, _ref6, _ref7;
      label_height = (_ref = this.annotationspec.label_height) != null ? _ref : this.mget('label_height');
      this.glyph_height = (_ref1 = this.annotationspec.glyph_height) != null ? _ref1 : this.mget('glyph_height');
      label_width = (_ref2 = this.annotationspec.label_width) != null ? _ref2 : this.mget('label_width');
      this.glyph_width = (_ref3 = this.annotationspec.glyph_width) != null ? _ref3 : this.mget('glyph_width');
      legend_spacing = (_ref4 = this.annotationspec.legend_spacing) != null ? _ref4 : this.mget('legend_spacing');
      this.label_height = _.max([textutils.getTextHeight(this.label_props.font(this)), label_height, this.glyph_height]);
      this.legend_height = this.label_height;
      this.legend_height = this.legend_names.length * this.legend_height + (1 + this.legend_names.length) * legend_spacing;
      ctx = this.plot_view.ctx;
      ctx.save();
      this.label_props.set(ctx, this);
      text_widths = _.map(this.legend_names, function(txt) {
        return ctx.measureText(txt).width;
      });
      ctx.restore();
      text_width = _.max(text_widths);
      this.label_width = _.max([text_width, label_width]);
      this.legend_width = this.label_width + this.glyph_width + 3 * legend_spacing;
      orientation = (_ref5 = this.annotationspec.orientation) != null ? _ref5 : this.mget('orientation');
      legend_padding = (_ref6 = this.annotationspec.legend_padding) != null ? _ref6 : this.mget('legend_padding');
      h_range = this.plot_view.view_state.get('inner_range_horizontal');
      v_range = this.plot_view.view_state.get('inner_range_vertical');
      if (orientation === "top_right") {
        x = h_range.get('end') - legend_padding - this.legend_width;
        y = v_range.get('end') - legend_padding;
      } else if (orientation === "top_left") {
        x = h_range.get('start') + legend_padding;
        y = v_range.get('end') - legend_padding;
      } else if (orientation === "bottom_left") {
        x = h_range.get('start') + legend_padding;
        y = v_range.get('start') + legend_padding + this.legend_height;
      } else if (orientation === "bottom_right") {
        x = h_range.get('end') - legend_padding - this.legend_width;
        y = v_range.get('start') + legend_padding + this.legend_height;
      } else if (orientation === "absolute") {
        _ref7 = this.annotationspec.absolute_coords, x = _ref7[0], y = _ref7[1];
      }
      x = this.plot_view.view_state.sx_to_device(x);
      y = this.plot_view.view_state.sy_to_device(y);
      return this.box_coords = [x, y];
    };

    LegendView.prototype.render = function() {
      var ctx, idx, legend_name, legend_spacing, renderer, view, x, x1, x2, y, y1, y2, yoffset, yspacing, _i, _j, _len, _len1, _ref, _ref1, _ref2;
      ctx = this.plot_view.ctx;
      ctx.save();
      ctx.fillStyle = this.plot_model.get('background_fill');
      this.border_props.set(ctx, this);
      ctx.beginPath();
      ctx.rect(this.box_coords[0], this.box_coords[1], this.legend_width, this.legend_height);
      ctx.fill();
      ctx.stroke();
      this.label_props.set(ctx, this);
      legend_spacing = (_ref = this.annotationspec.legend_spacing) != null ? _ref : this.mget('legend_spacing');
      _ref1 = this.legend_names;
      for (idx = _i = 0, _len = _ref1.length; _i < _len; idx = ++_i) {
        legend_name = _ref1[idx];
        yoffset = idx * this.label_height;
        yspacing = (1 + idx) * legend_spacing;
        y = this.box_coords[1] + this.label_height / 2.0 + yoffset + yspacing;
        x = this.box_coords[0] + legend_spacing;
        x1 = this.box_coords[0] + 2 * legend_spacing + this.label_width;
        x2 = x1 + this.glyph_width;
        y1 = this.box_coords[1] + yoffset + yspacing;
        y2 = y1 + this.glyph_height;
        ctx.fillText(legend_name, x, y);
        _ref2 = this.model.resolve_ref(this.annotationspec.legends[legend_name]);
        for (_j = 0, _len1 = _ref2.length; _j < _len1; _j++) {
          renderer = _ref2[_j];
          view = this.plot_view.renderers[renderer.id];
          view.draw_legend(ctx, x1, x2, y1, y2);
        }
      }
      return ctx.restore();
    };

    return LegendView;

  })(PlotWidget);

  Legend = (function(_super) {

    __extends(Legend, _super);

    function Legend() {
      return Legend.__super__.constructor.apply(this, arguments);
    }

    Legend.prototype.default_view = LegendView;

    Legend.prototype.type = 'AnnotationRenderer';

    return Legend;

  })(HasParent);

  Legend.prototype.defaults = _.clone(Legend.prototype.defaults);

  Legend.prototype.display_defaults = _.clone(Legend.prototype.display_defaults);

  _.extend(Legend.prototype.display_defaults, {
    level: 'overlay',
    border_line_color: 'black',
    border_line_width: 1,
    border_line_alpha: 1.0,
    border_line_join: 'miter',
    border_line_cap: 'butt',
    border_line_dash: [],
    border_line_dash_offset: 0,
    label_standoff: 15,
    label_text_font: "helvetica",
    label_text_font_size: "10pt",
    label_text_font_style: "normal",
    label_text_color: "#444444",
    label_text_alpha: 1.0,
    label_text_align: "center",
    label_text_baseline: "middle",
    glyph_height: 20,
    glyph_width: 20,
    label_height: 20,
    label_width: 50,
    legend_padding: 10,
    legend_spacing: 3,
    orientation: "top_right",
    label_text_align: "left",
    label_text_baseline: "middle",
    datapoint: null
  });

  exports.Legend = Legend;

}).call(this);
}, "renderers/annotation/title": function(exports, require, module) {(function() {



}).call(this);
}, "renderers/annotation_renderer": function(exports, require, module) {(function() {
  var AnnotationRenderers, Collections, annotations, base,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../base');

  Collections = base.Collections;

  annotations = require('./annotations');

  AnnotationRenderers = (function(_super) {

    __extends(AnnotationRenderers, _super);

    function AnnotationRenderers() {
      return AnnotationRenderers.__super__.constructor.apply(this, arguments);
    }

    AnnotationRenderers.prototype.model = function(attrs, options) {
      var model, type, _ref;
      if (!(((_ref = attrs.annotationspec) != null ? _ref.type : void 0) != null)) {
        console.log("missing annotation type");
        return;
      }
      type = attrs.annotationspec.type;
      if (!(type in annotations)) {
        console.log("unknown annotation type '" + type + "'");
        return;
      }
      model = annotations[type];
      return new model(attrs, options);
    };

    return AnnotationRenderers;

  })(Backbone.Collection);

  exports.annotationrenderers = new AnnotationRenderers;

}).call(this);
}, "renderers/annotations": function(exports, require, module) {(function() {
  var legend;

  legend = require("./annotation/legend");

  exports.legend = legend.Legend;

}).call(this);
}, "renderers/glyph/annular_wedge": function(exports, require, module) {(function() {
  var AnnularWedge, AnnularWedgeView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  AnnularWedgeView = (function(_super) {

    __extends(AnnularWedgeView, _super);

    function AnnularWedgeView() {
      return AnnularWedgeView.__super__.constructor.apply(this, arguments);
    }

    AnnularWedgeView.prototype.initialize = function(options) {
      var spec;
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return AnnularWedgeView.__super__.initialize.call(this, options);
    };

    AnnularWedgeView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'inner_radius', 'outer_radius', 'start_angle', 'end_angle', 'direction:string'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    AnnularWedgeView.prototype._set_data = function(data) {
      var angle, dir, end_angle, i, start_angle, _i, _j, _k, _ref, _ref1, _ref2, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      start_angle = this.glyph_props.v_select('start_angle', data);
      this.start_angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = start_angle.length; _i < _len; _i++) {
          angle = start_angle[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      end_angle = this.glyph_props.v_select('end_angle', data);
      this.end_angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = end_angle.length; _i < _len; _i++) {
          angle = end_angle[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      this.angle = new Float32Array(this.start_angle.length);
      for (i = _i = 0, _ref = this.start_angle.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.angle[i] = this.end_angle[i] - this.start_angle[i];
      }
      this.direction = new Uint8Array(this.data.length);
      for (i = _j = 0, _ref1 = this.data.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
        dir = this.glyph_props.select('direction', data[i]);
        if (dir === 'clock') {
          this.direction[i] = false;
        } else if (dir === 'anticlock') {
          this.direction[i] = true;
        } else {
          this.direction[i] = NaN;
        }
      }
      this.selected_mask = new Uint8Array(data.length);
      _results = [];
      for (i = _k = 0, _ref2 = this.selected_mask.length - 1; 0 <= _ref2 ? _k <= _ref2 : _k >= _ref2; i = 0 <= _ref2 ? ++_k : --_k) {
        _results.push(this.selected_mask[i] = false);
      }
      return _results;
    };

    AnnularWedgeView.prototype._render = function() {
      var ctx, idx, props, selected, _i, _len, _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.inner_radius = this.distance(this.data, 'x', 'inner_radius', 'edge');
      this.outer_radius = this.distance(this.data, 'x', 'outer_radius', 'edge');
      ctx = this.plot_view.ctx;
      ctx.save();
      selected = this.mget_obj('data_source').get('selected');
      for (_i = 0, _len = selected.length; _i < _len; _i++) {
        idx = selected[_i];
        this.selected_mask[idx] = true;
      }
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, 'selected');
          this._full_path(ctx, this.nonselection_glyphprops, 'unselected');
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    AnnularWedgeView.prototype._fast_path = function(ctx) {
      var i, _i, _j, _ref, _ref1;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.inner_radius[i] + this.outer_radius[i] + this.start_angle[i] + this.end_angle[i])) {
            continue;
          }
          ctx.translate(this.sx[i], this.sy[i]);
          ctx.rotate(this.start_angle[i]);
          ctx.moveTo(this.outer_radius[i], 0);
          ctx.beginPath();
          ctx.arc(0, 0, this.outer_radius[i], 0, this.angle[i], this.direction[i]);
          ctx.rotate(this.angle[i]);
          ctx.lineTo(this.inner_radius[i], 0);
          ctx.arc(0, 0, this.inner_radius[i], 0, -this.angle[i], !this.direction[i]);
          ctx.closePath();
          ctx.fill();
          ctx.rotate(-this.angle[i] - this.start_angle[i]);
          ctx.translate(-this.sx[i], -this.sy[i]);
        }
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.inner_radius[i] + this.outer_radius[i] + this.start_angle[i] + this.end_angle[i])) {
            continue;
          }
          ctx.translate(this.sx[i], this.sy[i]);
          ctx.rotate(this.start_angle[i]);
          ctx.moveTo(this.outer_radius[i], 0);
          ctx.arc(0, 0, this.outer_radius[i], 0, this.angle[i], this.direction[i]);
          ctx.rotate(this.angle[i]);
          ctx.lineTo(this.inner_radius[i], 0);
          ctx.arc(0, 0, this.inner_radius[i], 0, -this.angle[i], !this.direction[i]);
          ctx.closePath();
          ctx.rotate(-this.angle[i] - this.start_angle[i]);
          ctx.translate(-this.sx[i], -this.sy[i]);
        }
        return ctx.stroke();
      }
    };

    AnnularWedgeView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.inner_radius[i] + this.outer_radius[i] + this.start_angle[i] + this.end_angle[i])) {
          continue;
        }
        if (use_selection === 'selected' && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === 'unselected' && this.selected_mask[i]) {
          continue;
        }
        ctx.translate(this.sx[i], this.sy[i]);
        ctx.rotate(this.start_angle[i]);
        ctx.moveTo(this.outer_radius[i], 0);
        ctx.beginPath();
        ctx.arc(0, 0, this.outer_radius[i], 0, this.angle[i], this.direction[i]);
        ctx.rotate(this.angle[i]);
        ctx.lineTo(this.inner_radius[i], 0);
        ctx.arc(0, 0, this.inner_radius[i], 0, -this.angle[i], !this.direction[i]);
        ctx.closePath();
        ctx.rotate(-this.angle[i] - this.start_angle[i]);
        ctx.translate(-this.sx[i], -this.sy[i]);
        if (this.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    AnnularWedgeView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var angle, border, d, direction, end_angle, fill_props, glyph_props, glyph_settings, inner_radius, line_props, outer_radius, r, ratio, reference_point, start_angle, sx, sy;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        outer_radius = this.distance([reference_point], 'x', 'outer_radius', 'edge');
        outer_radius = outer_radius[0];
        inner_radius = this.distance([reference_point], 'x', 'inner_radius', 'edge');
        inner_radius = inner_radius[0];
        start_angle = -this.glyph_props.select('start_angle', reference_point);
        end_angle = -this.glyph_props.select('end_angle', reference_point);
      } else {
        glyph_settings = glyph_props;
        start_angle = -0.1;
        end_angle = -3.9;
      }
      angle = end_angle - start_angle;
      direction = this.glyph_props.select('direction', glyph_settings);
      direction = direction === "clock" ? false : true;
      border = line_props.select(line_props.line_width_name, glyph_settings);
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if ((outer_radius != null) || (inner_radius != null)) {
        ratio = r / outer_radius;
        outer_radius = r;
        inner_radius = inner_radius * ratio;
      } else {
        outer_radius = r;
        inner_radius = r / 2;
      }
      sx = (x1 + x2) / 2.0;
      sy = (y1 + y2) / 2.0;
      ctx.translate(sx, sy);
      ctx.rotate(start_angle);
      ctx.moveTo(outer_radius, 0);
      ctx.beginPath();
      ctx.arc(0, 0, outer_radius, 0, angle, direction);
      ctx.rotate(angle);
      ctx.lineTo(inner_radius, 0);
      ctx.arc(0, 0, inner_radius, 0, -angle, !direction);
      ctx.closePath();
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    AnnularWedgeView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    return AnnularWedgeView;

  })(GlyphView);

  AnnularWedge = (function(_super) {

    __extends(AnnularWedge, _super);

    function AnnularWedge() {
      return AnnularWedge.__super__.constructor.apply(this, arguments);
    }

    AnnularWedge.prototype.default_view = AnnularWedgeView;

    AnnularWedge.prototype.type = 'GlyphRenderer';

    return AnnularWedge;

  })(Glyph);

  AnnularWedge.prototype.display_defaults = _.clone(AnnularWedge.prototype.display_defaults);

  _.extend(AnnularWedge.prototype.display_defaults, {
    direction: 'anticlock',
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.AnnularWedge = AnnularWedge;

  exports.AnnularWedgeView = AnnularWedgeView;

}).call(this);
}, "renderers/glyph/annulus": function(exports, require, module) {(function() {
  var Annulus, AnnulusView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  AnnulusView = (function(_super) {

    __extends(AnnulusView, _super);

    function AnnulusView() {
      return AnnulusView.__super__.constructor.apply(this, arguments);
    }

    AnnulusView.prototype.initialize = function(options) {
      var spec;
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return AnnulusView.__super__.initialize.call(this, options);
    };

    AnnulusView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'inner_radius', 'outer_radius'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    AnnulusView.prototype._set_data = function(data) {
      var i, _i, _ref, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.selected_mask = new Uint8Array(data.length);
      _results = [];
      for (i = _i = 0, _ref = this.selected_mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        _results.push(this.selected_mask[i] = false);
      }
      return _results;
    };

    AnnulusView.prototype._render = function() {
      var ctx, idx, props, selected, _i, _len, _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.inner_radius = this.distance(this.data, 'x', 'inner_radius', 'edge');
      this.outer_radius = this.distance(this.data, 'x', 'outer_radius', 'edge');
      ctx = this.plot_view.ctx;
      ctx.save();
      selected = this.mget_obj('data_source').get('selected');
      for (_i = 0, _len = selected.length; _i < _len; _i++) {
        idx = selected[_i];
        this.selected_mask[idx] = true;
      }
      if (this.glyph_props.fast_path) {
        return this._fast_path(ctx);
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, 'selected');
          this._full_path(ctx, this.nonselection_glyphprops, 'unselected');
        } else {
          this._full_path(ctx);
        }
        return ctx.restore();
      }
    };

    AnnulusView.prototype._fast_path = function(ctx) {
      var i, _i, _j, _ref, _ref1, _results;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.inner_radius[i] + this.outer_radius[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.inner_radius[i], 0, 2 * Math.PI * 2, false);
          ctx.arc(this.sx[i], this.sy[i], this.outer_radius[i], 0, 2 * Math.PI * 2, true);
          ctx.fill();
        }
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.inner_radius[i] + this.outer_radius[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.inner_radius[i], 0, 2 * Math.PI * 2, false);
          ctx.stroke();
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.outer_radius[i], 0, 2 * Math.PI * 2, true);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    AnnulusView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.inner_radius[i] + this.outer_radius[i])) {
          continue;
        }
        if (use_selection === 'selected' && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === 'unselected' && this.selected_mask[i]) {
          continue;
        }
        ctx.beginPath();
        ctx.arc(this.sx[i], this.sy[i], this.inner_radius[i], 0, 2 * Math.PI * 2, false);
        ctx.moveTo(this.sx[i] + this.outer_radius[i], this.sy[i]);
        ctx.arc(this.sx[i], this.sy[i], this.outer_radius[i], 0, 2 * Math.PI * 2, true);
        if (this.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    AnnulusView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, fill_props, glyph_props, glyph_settings, inner_radius, line_props, outer_radius, r, ratio, reference_point, sx, sy;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        outer_radius = this.distance([reference_point], 'x', 'outer_radius', 'edge');
        outer_radius = outer_radius[0];
        inner_radius = this.distance([reference_point], 'x', 'inner_radius', 'edge');
        inner_radius = inner_radius[0];
      } else {
        glyph_settings = glyph_props;
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if ((outer_radius != null) || (inner_radius != null)) {
        ratio = r / outer_radius;
        outer_radius = r;
        inner_radius = inner_radius * ratio;
      } else {
        outer_radius = r;
        inner_radius = r / 2;
      }
      sx = (x1 + x2) / 2.0;
      sy = (y1 + y2) / 2.0;
      ctx.beginPath();
      ctx.arc(sx, sy, inner_radius, 0, 2 * Math.PI * 2, false);
      ctx.moveTo(sx + outer_radius, sy);
      ctx.arc(sx, sy, outer_radius, 0, 2 * Math.PI * 2, true);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    AnnulusView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    return AnnulusView;

  })(GlyphView);

  Annulus = (function(_super) {

    __extends(Annulus, _super);

    function Annulus() {
      return Annulus.__super__.constructor.apply(this, arguments);
    }

    Annulus.prototype.default_view = AnnulusView;

    Annulus.prototype.type = 'GlyphRenderer';

    return Annulus;

  })(Glyph);

  Annulus.prototype.display_defaults = _.clone(Annulus.prototype.display_defaults);

  _.extend(Annulus.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Annulus = Annulus;

  exports.AnnulusView = AnnulusView;

}).call(this);
}, "renderers/glyph/arc": function(exports, require, module) {(function() {
  var Arc, ArcView, Glyph, GlyphView, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  ArcView = (function(_super) {

    __extends(ArcView, _super);

    function ArcView() {
      return ArcView.__super__.constructor.apply(this, arguments);
    }

    ArcView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'radius', 'start_angle', 'end_angle', 'direction:string'], [new line_properties(this, glyphspec)]);
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return ArcView.__super__.initialize.call(this, options);
    };

    ArcView.prototype._set_data = function(data) {
      var angle, dir, end_angle, i, start_angle, _i, _ref, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      start_angle = this.glyph_props.v_select('start_angle', data);
      this.start_angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = start_angle.length; _i < _len; _i++) {
          angle = start_angle[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      end_angle = this.glyph_props.v_select('end_angle', data);
      this.end_angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = end_angle.length; _i < _len; _i++) {
          angle = end_angle[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      this.direction = new Uint8Array(this.data.length);
      _results = [];
      for (i = _i = 0, _ref = this.data.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        dir = this.glyph_props.select('direction', data[i]);
        if (dir === 'clock') {
          _results.push(this.direction[i] = false);
        } else if (dir === 'anticlock') {
          _results.push(this.direction[i] = true);
        } else {
          _results.push(this.direction[i] = NaN);
        }
      }
      return _results;
    };

    ArcView.prototype._render = function() {
      var ctx, _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.radius = this.distance(this.data, 'x', 'radius', 'edge');
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    ArcView.prototype._fast_path = function(ctx) {
      var i, _i, _ref, _results;
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.radius[i] + this.start_angle[i] + this.end_angle[i] + this.direction[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.radius[i], this.start_angle[i], this.end_angle[i], this.direction[i]);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    ArcView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      if (this.do_stroke) {
        _results = [];
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.radius[i] + this.start_angle[i] + this.end_angle[i] + this.direction[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.radius[i], this.start_angle[i], this.end_angle[i], this.direction[i]);
          this.glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    ArcView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, direction, end_angle, glyph_props, glyph_settings, line_props, r, reference_point, start_angle;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'radius', 'edge')[0];
        start_angle = -this.glyph_props.select('start_angle', reference_point);
        end_angle = -this.glyph_props.select('end_angle', reference_point);
      } else {
        glyph_settings = glyph_props;
        start_angle = -0.1;
        end_angle = -3.9;
      }
      direction = this.glyph_props.select('direction', glyph_settings);
      direction = direction === "clock" ? false : true;
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      ctx.arc((x1 + x2) / 2.0, (y1 + y2) / 2.0, r, start_angle, end_angle, direction);
      line_props.set(ctx, glyph_settings);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return ArcView;

  })(GlyphView);

  Arc = (function(_super) {

    __extends(Arc, _super);

    function Arc() {
      return Arc.__super__.constructor.apply(this, arguments);
    }

    Arc.prototype.default_view = ArcView;

    Arc.prototype.type = 'GlyphRenderer';

    return Arc;

  })(Glyph);

  Arc.prototype.display_defaults = _.clone(Arc.prototype.display_defaults);

  _.extend(Arc.prototype.display_defaults, {
    direction: 'anticlock',
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Arc = Arc;

  exports.ArcView = ArcView;

}).call(this);
}, "renderers/glyph/asterisk": function(exports, require, module) {(function() {
  var Asterisk, AsteriskView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  AsteriskView = (function(_super) {

    __extends(AsteriskView, _super);

    function AsteriskView() {
      return AsteriskView.__super__.constructor.apply(this, arguments);
    }

    AsteriskView.prototype.initialize = function(options) {
      var spec;
      AsteriskView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    AsteriskView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    AsteriskView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    AsteriskView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    AsteriskView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, r, r2, _i, _ref, _results;
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          r = this.size[i] / 2;
          r2 = r * 0.65;
          ctx.beginPath();
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i]);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          ctx.moveTo(this.sx[i] - r2, this.sy[i] + r2);
          ctx.lineTo(this.sx[i] + r2, this.sy[i] - r2);
          ctx.moveTo(this.sx[i] - r2, this.sy[i] - r2);
          ctx.lineTo(this.sx[i] + r2, this.sy[i] + r2);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    AsteriskView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, r2, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        r = this.size[i] / 2;
        r2 = r * 0.65;
        ctx.beginPath();
        ctx.moveTo(this.sx[i], this.sy[i] + r);
        ctx.lineTo(this.sx[i], this.sy[i] - r);
        ctx.moveTo(this.sx[i] - r, this.sy[i]);
        ctx.lineTo(this.sx[i] + r, this.sy[i]);
        ctx.moveTo(this.sx[i] - r2, this.sy[i] + r2);
        ctx.lineTo(this.sx[i] + r2, this.sy[i] - r2);
        ctx.moveTo(this.sx[i] - r2, this.sy[i] - r2);
        ctx.lineTo(this.sx[i] + r2, this.sy[i] + r2);
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    AsteriskView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    AsteriskView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      r = r * 0.65;
      x = (x1 + x2) / 2.0;
      y = (y1 + y2) / 2.0;
      ctx.moveTo(x, y + r);
      ctx.lineTo(x, y - r);
      ctx.moveTo(x - r, y);
      ctx.lineTo(x + r, y);
      ctx.moveTo(x - r2, y + r2);
      ctx.lineTo(x + r2, y - r2);
      ctx.moveTo(x - r2, y - r2);
      ctx.lineTo(x + r2, y + r2);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return AsteriskView;

  })(GlyphView);

  Asterisk = (function(_super) {

    __extends(Asterisk, _super);

    function Asterisk() {
      return Asterisk.__super__.constructor.apply(this, arguments);
    }

    Asterisk.prototype.default_view = AsteriskView;

    Asterisk.prototype.type = 'GlyphRenderer';

    return Asterisk;

  })(Glyph);

  Asterisk.prototype.display_defaults = _.clone(Asterisk.prototype.display_defaults);

  _.extend(Asterisk.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Asterisk = Asterisk;

  exports.AsteriskView = AsteriskView;

}).call(this);
}, "renderers/glyph/bezier": function(exports, require, module) {(function() {
  var Bezier, BezierView, Glyph, GlyphView, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  BezierView = (function(_super) {

    __extends(BezierView, _super);

    function BezierView() {
      return BezierView.__super__.constructor.apply(this, arguments);
    }

    BezierView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x0', 'y0', 'x1', 'y1', 'cx0', 'cy0', 'cx1', 'cy1'], [new line_properties(this, glyphspec)]);
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return BezierView.__super__.initialize.call(this, options);
    };

    BezierView.prototype._set_data = function(data) {
      this.data = data;
      this.x0 = this.glyph_props.v_select('x0', data);
      this.y0 = this.glyph_props.v_select('y0', data);
      this.x1 = this.glyph_props.v_select('x1', data);
      this.y1 = this.glyph_props.v_select('y1', data);
      this.cx0 = this.glyph_props.v_select('cx0', data);
      this.cy0 = this.glyph_props.v_select('cy0', data);
      this.cx1 = this.glyph_props.v_select('cx1', data);
      return this.cy1 = this.glyph_props.v_select('cy1', data);
    };

    BezierView.prototype._render = function() {
      var ctx, _ref, _ref1, _ref2, _ref3;
      _ref = this.plot_view.map_to_screen(this.x0, this.glyph_props.x0.units, this.y0, this.glyph_props.y0.units), this.sx0 = _ref[0], this.sy0 = _ref[1];
      _ref1 = this.plot_view.map_to_screen(this.x1, this.glyph_props.x1.units, this.y1, this.glyph_props.y1.units), this.sx1 = _ref1[0], this.sy1 = _ref1[1];
      _ref2 = this.plot_view.map_to_screen(this.cx0, this.glyph_props.cx0.units, this.cy0, this.glyph_props.cy0.units), this.scx0 = _ref2[0], this.scy0 = _ref2[1];
      _ref3 = this.plot_view.map_to_screen(this.cx1, this.glyph_props.cx1.units, this.cy1, this.glyph_props.cy1.units), this.scx1 = _ref3[0], this.scy1 = _ref3[1];
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    BezierView.prototype._fast_path = function(ctx) {
      var i, _i, _ref;
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i] + this.scx0[i] + this.scy0[i] + this.scx1[i] + this.scy1[i])) {
            continue;
          }
          ctx.moveTo(this.sx0[i], this.sy0[i]);
          ctx.bezierCurveTo(this.scx0[i], this.scy0[i], this.scx1[i], this.scy1[i], this.sx1[i], this.sy1[i]);
        }
        return ctx.stroke();
      }
    };

    BezierView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      if (this.do_stroke) {
        _results = [];
        for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i] + this.scx0[i] + this.scy0[i] + this.scx1[i] + this.scy1[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.moveTo(this.sx0[i], this.sy0[i]);
          ctx.bezierCurveTo(this.scx0[i], this.scy0[i], this.scx1[i], this.scy1[i], this.sx1[i], this.sy1[i]);
          this.glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    return BezierView;

  })(GlyphView);

  Bezier = (function(_super) {

    __extends(Bezier, _super);

    function Bezier() {
      return Bezier.__super__.constructor.apply(this, arguments);
    }

    Bezier.prototype.default_view = BezierView;

    Bezier.prototype.type = 'GlyphRenderer';

    return Bezier;

  })(Glyph);

  Bezier.prototype.display_defaults = _.clone(Bezier.prototype.display_defaults);

  _.extend(Bezier.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Bezier = Bezier;

  exports.BezierView = BezierView;

}).call(this);
}, "renderers/glyph/circle": function(exports, require, module) {(function() {
  var Circle, CircleView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  CircleView = (function(_super) {

    __extends(CircleView, _super);

    function CircleView() {
      return CircleView.__super__.constructor.apply(this, arguments);
    }

    CircleView.prototype.initialize = function(options) {
      var spec;
      CircleView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    CircleView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'radius'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    CircleView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    CircleView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.radius = this.distance(this.data, 'x', 'radius', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.radius[i]) < 0 || (this.sx[i] - this.radius[i]) > ow || (this.sy[i] + this.radius[i]) < 0 || (this.sy[i] - this.radius[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    CircleView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, _i, _j, _ref, _ref1, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      if (glyph_props.fill_properties.do_fill) {
        glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.radius[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          ctx.moveTo(this.sx[i], this.sy[i]);
          ctx.arc(this.sx[i], this.sy[i], this.radius[i], 0, 2 * Math.PI, false);
        }
        ctx.fill();
      }
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.radius[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          ctx.moveTo(this.sx[i], this.sy[i]);
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.radius[i], 0, 2 * Math.PI, false);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    CircleView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.radius[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        ctx.beginPath();
        ctx.arc(this.sx[i], this.sy[i], this.radius[i], 0, 2 * Math.PI, false);
        if (glyph_props.fill_properties.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    CircleView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    CircleView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'radius', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('radius', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      ctx.arc((x1 + x2) / 2.0, (y1 + y2) / 2.0, r, 2 * Math.PI, false);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return CircleView;

  })(GlyphView);

  Circle = (function(_super) {

    __extends(Circle, _super);

    function Circle() {
      return Circle.__super__.constructor.apply(this, arguments);
    }

    Circle.prototype.default_view = CircleView;

    Circle.prototype.type = 'GlyphRenderer';

    return Circle;

  })(Glyph);

  Circle.prototype.display_defaults = _.clone(Circle.prototype.display_defaults);

  _.extend(Circle.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Circle = Circle;

  exports.CircleView = CircleView;

}).call(this);
}, "renderers/glyph/circle_cross": function(exports, require, module) {(function() {
  var CircleCross, CircleCrossView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  CircleCrossView = (function(_super) {

    __extends(CircleCrossView, _super);

    function CircleCrossView() {
      return CircleCrossView.__super__.constructor.apply(this, arguments);
    }

    CircleCrossView.prototype.initialize = function(options) {
      var spec;
      CircleCrossView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    CircleCrossView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    CircleCrossView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    CircleCrossView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    CircleCrossView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _j, _ref, _ref1, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      if (glyph_props.fill_properties.do_fill) {
        glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          ctx.moveTo(this.sx[i], this.sy[i]);
          ctx.arc(this.sx[i], this.sy[i], this.size[i], 0, 2 * Math.PI, false);
        }
        ctx.fill();
      }
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          ctx.moveTo(this.sx[i], this.sy[i]);
          ctx.beginPath();
          r = this.size[i] / 2;
          ctx.arc(this.sx[i], this.sy[i], r, 0, 2 * Math.PI, false);
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i]);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    CircleCrossView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        ctx.beginPath();
        r = this.size[i] / 2;
        ctx.arc(this.sx[i], this.sy[i], r, 0, 2 * Math.PI, false);
        if (glyph_props.fill_properties.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i]);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    CircleCrossView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    CircleCrossView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      ctx.arc((x1 + x2) / 2.0, (y1 + y2) / 2.0, r, 2 * Math.PI, false);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.moveTo(x, y + r);
        ctx.lineTo(x, y - r);
        ctx.moveTo(x - r, y);
        ctx.lineTo(x + r, y);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return CircleCrossView;

  })(GlyphView);

  CircleCross = (function(_super) {

    __extends(CircleCross, _super);

    function CircleCross() {
      return CircleCross.__super__.constructor.apply(this, arguments);
    }

    CircleCross.prototype.default_view = CircleCrossView;

    CircleCross.prototype.type = 'GlyphRenderer';

    return CircleCross;

  })(Glyph);

  CircleCross.prototype.display_defaults = _.clone(CircleCross.prototype.display_defaults);

  _.extend(CircleCross.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.CircleCross = CircleCross;

  exports.CircleCrossView = CircleCrossView;

}).call(this);
}, "renderers/glyph/circle_x": function(exports, require, module) {(function() {
  var CircleX, CircleXView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  CircleXView = (function(_super) {

    __extends(CircleXView, _super);

    function CircleXView() {
      return CircleXView.__super__.constructor.apply(this, arguments);
    }

    CircleXView.prototype.initialize = function(options) {
      var spec;
      CircleXView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    CircleXView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    CircleXView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    CircleXView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    CircleXView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _j, _ref, _ref1, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      if (glyph_props.fill_properties.do_fill) {
        glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          ctx.moveTo(this.sx[i], this.sy[i]);
          ctx.arc(this.sx[i], this.sy[i], this.size[i], 0, 2 * Math.PI, false);
        }
        ctx.fill();
      }
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          ctx.moveTo(this.sx[i], this.sy[i]);
          ctx.beginPath();
          r = this.size[i] / 2;
          ctx.arc(this.sx[i], this.sy[i], r, 0, 2 * Math.PI, false);
          ctx.moveTo(this.sx[i] - r, this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i] - r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] + r);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    CircleXView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        ctx.beginPath();
        r = this.size[i] / 2;
        ctx.arc(this.sx[i], this.sy[i], r, 0, 2 * Math.PI, false);
        if (glyph_props.fill_properties.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          ctx.moveTo(this.sx[i] - r, this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i] - r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] + r);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    CircleXView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    CircleXView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      ctx.arc((x1 + x2) / 2.0, (y1 + y2) / 2.0, r, 2 * Math.PI, false);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.moveTo(x - r, y + r);
        ctx.lineTo(x + r, y - r);
        ctx.moveTo(x - r, y - r);
        ctx.lineTo(x + r, y + r);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return CircleXView;

  })(GlyphView);

  CircleX = (function(_super) {

    __extends(CircleX, _super);

    function CircleX() {
      return CircleX.__super__.constructor.apply(this, arguments);
    }

    CircleX.prototype.default_view = CircleXView;

    CircleX.prototype.type = 'GlyphRenderer';

    return CircleX;

  })(Glyph);

  CircleX.prototype.display_defaults = _.clone(CircleX.prototype.display_defaults);

  _.extend(CircleX.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.CircleX = CircleX;

  exports.CircleXView = CircleXView;

}).call(this);
}, "renderers/glyph/cross": function(exports, require, module) {(function() {
  var Cross, CrossView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  CrossView = (function(_super) {

    __extends(CrossView, _super);

    function CrossView() {
      return CrossView.__super__.constructor.apply(this, arguments);
    }

    CrossView.prototype.initialize = function(options) {
      var spec;
      CrossView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    CrossView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    CrossView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    CrossView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    CrossView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          r = this.size[i] / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i]);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    CrossView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        r = this.size[i] / 2;
        ctx.beginPath();
        ctx.moveTo(this.sx[i], this.sy[i] + r);
        ctx.lineTo(this.sx[i], this.sy[i] - r);
        ctx.moveTo(this.sx[i] - r, this.sy[i]);
        ctx.lineTo(this.sx[i] + r, this.sy[i]);
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    CrossView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    CrossView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      x = (x1 + x2) / 2.0;
      y = (y1 + y2) / 2.0;
      ctx.moveTo(x, y + r);
      ctx.lineTo(x, y - r);
      ctx.moveTo(x - r, y);
      ctx.lineTo(x + r, y);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return CrossView;

  })(GlyphView);

  Cross = (function(_super) {

    __extends(Cross, _super);

    function Cross() {
      return Cross.__super__.constructor.apply(this, arguments);
    }

    Cross.prototype.default_view = CrossView;

    Cross.prototype.type = 'GlyphRenderer';

    return Cross;

  })(Glyph);

  Cross.prototype.display_defaults = _.clone(Cross.prototype.display_defaults);

  _.extend(Cross.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Cross = Cross;

  exports.CrossView = CrossView;

}).call(this);
}, "renderers/glyph/diamond": function(exports, require, module) {(function() {
  var Diamond, DiamondView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  DiamondView = (function(_super) {

    __extends(DiamondView, _super);

    function DiamondView() {
      return DiamondView.__super__.constructor.apply(this, arguments);
    }

    DiamondView.prototype.initialize = function(options) {
      var spec;
      DiamondView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    DiamondView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    DiamondView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    DiamondView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    DiamondView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _j, _ref, _ref1, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      if (glyph_props.fill_properties.do_fill) {
        glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          r = this.size[i] / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.lineTo(this.sx[i] - r, this.sy[i]);
          ctx.closePath();
        }
        ctx.fill();
      }
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          r = this.size[i] / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.lineTo(this.sx[i] - r, this.sy[i]);
          ctx.closePath();
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    DiamondView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        r = this.size[i] / 2;
        ctx.beginPath();
        ctx.moveTo(this.sx[i], this.sy[i] + r);
        ctx.lineTo(this.sx[i] + r, this.sy[i]);
        ctx.lineTo(this.sx[i], this.sy[i] - r);
        ctx.lineTo(this.sx[i] - r, this.sy[i]);
        ctx.closePath();
        if (glyph_props.fill_properties.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    DiamondView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    DiamondView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      r = this.size[i] / 2;
      x = (x1 + x2) / 2.0;
      y = (y1 + y2) / 2.0;
      ctx.beginPath();
      ctx.moveTo(x, y + r);
      ctx.lineTo(x + r, y);
      ctx.lineTo(x, y - r);
      ctx.lineTo(x - r, y);
      ctx.closePath();
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return DiamondView;

  })(GlyphView);

  Diamond = (function(_super) {

    __extends(Diamond, _super);

    function Diamond() {
      return Diamond.__super__.constructor.apply(this, arguments);
    }

    Diamond.prototype.default_view = DiamondView;

    Diamond.prototype.type = 'GlyphRenderer';

    return Diamond;

  })(Glyph);

  Diamond.prototype.display_defaults = _.clone(Diamond.prototype.display_defaults);

  _.extend(Diamond.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Diamond = Diamond;

  exports.DiamondView = DiamondView;

}).call(this);
}, "renderers/glyph/diamond_cross": function(exports, require, module) {(function() {
  var DiamondCross, DiamondCrossView, Glyph, GlyphView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  DiamondCrossView = (function(_super) {

    __extends(DiamondCrossView, _super);

    function DiamondCrossView() {
      return DiamondCrossView.__super__.constructor.apply(this, arguments);
    }

    DiamondCrossView.prototype.initialize = function(options) {
      var spec;
      DiamondCrossView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    DiamondCrossView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    DiamondCrossView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    DiamondCrossView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    DiamondCrossView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _j, _ref, _ref1, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      if (glyph_props.fill_properties.do_fill) {
        glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          r = this.size[i] / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.lineTo(this.sx[i] - r, this.sy[i]);
          ctx.closePath();
        }
        ctx.fill();
      }
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          r = this.size[i] / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.lineTo(this.sx[i] - r, this.sy[i]);
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i]);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          ctx.closePath();
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    DiamondCrossView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        r = this.size[i] / 2;
        ctx.beginPath();
        ctx.moveTo(this.sx[i], this.sy[i] + r);
        ctx.lineTo(this.sx[i] + r, this.sy[i]);
        ctx.lineTo(this.sx[i], this.sy[i] - r);
        ctx.lineTo(this.sx[i] - r, this.sy[i]);
        ctx.closePath();
        if (glyph_props.fill_properties.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i]);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    DiamondCrossView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    DiamondCrossView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      r = this.size[i] / 2;
      x = (x1 + x2) / 2.0;
      y = (y1 + y2) / 2.0;
      ctx.beginPath();
      ctx.moveTo(x, y + r);
      ctx.lineTo(x + r, y);
      ctx.lineTo(x, y - r);
      ctx.lineTo(x - r, y);
      ctx.closePath();
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.moveTo(x, y + r);
        ctx.lineTo(x, y - r);
        ctx.moveTo(x - r, y);
        ctx.lineTo(x + r, y);
      }
      ctx.stroke();
      return ctx.restore();
    };

    return DiamondCrossView;

  })(GlyphView);

  DiamondCross = (function(_super) {

    __extends(DiamondCross, _super);

    function DiamondCross() {
      return DiamondCross.__super__.constructor.apply(this, arguments);
    }

    DiamondCross.prototype.default_view = DiamondCrossView;

    DiamondCross.prototype.type = 'GlyphRenderer';

    return DiamondCross;

  })(Glyph);

  DiamondCross.prototype.display_defaults = _.clone(DiamondCross.prototype.display_defaults);

  _.extend(DiamondCross.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.DiamondCross = DiamondCross;

  exports.DiamondCrossView = DiamondCrossView;

}).call(this);
}, "renderers/glyph/glyph": function(exports, require, module) {(function() {
  var Glyph, GlyphView, HasParent, PlotWidget, base, safebind,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../../base');

  HasParent = base.HasParent;

  safebind = base.safebind;

  PlotWidget = require('../../common/plot_widget').PlotWidget;

  GlyphView = (function(_super) {

    __extends(GlyphView, _super);

    function GlyphView() {
      return GlyphView.__super__.constructor.apply(this, arguments);
    }

    GlyphView.prototype.initialize = function(options) {
      GlyphView.__super__.initialize.call(this, options);
      return this.need_set_data = true;
    };

    GlyphView.prototype.set_data = function(request_render) {
      var data, source;
      if (request_render == null) {
        request_render = true;
      }
      source = this.mget_obj('data_source');
      if (source.type === 'ObjectArrayDataSource') {
        data = source.get('data');
      } else if (source.type === 'ColumnDataSource') {
        data = source.datapoints();
      } else if (source.type === 'PandasPlotSource') {
        data = source.datapoints();
      } else {
        console.log('Unknown data source type: ' + source.type);
      }
      this._set_data(data);
      if (request_render) {
        return this.request_render();
      }
    };

    GlyphView.prototype.render = function(have_new_mapper_state) {
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      if (this.need_set_data) {
        this.set_data(false);
        this.need_set_data = false;
      }
      return this._render(this.plot_view, have_new_mapper_state);
    };

    GlyphView.prototype.select = function() {
      return 'pass';
    };

    GlyphView.prototype.xrange = function() {
      return this.plot_view.x_range;
    };

    GlyphView.prototype.yrange = function() {
      return this.plot_view.y_range;
    };

    GlyphView.prototype.bind_bokeh_events = function() {
      this.listenTo(this.model, 'change', this.request_render);
      return this.listenTo(this.mget_obj('data_source'), 'change', this.set_data);
    };

    GlyphView.prototype.distance = function(data, pt, span, position) {
      var d, halfspan, i, mapper, pt0, pt1, pt_units, ptc, span_units, spt0, spt1;
      pt_units = this.glyph_props[pt].units;
      span_units = this.glyph_props[span].units;
      if (pt === 'x') {
        mapper = this.plot_view.xmapper;
      } else if (pt === 'y') {
        mapper = this.plot_view.ymapper;
      }
      span = this.glyph_props.v_select(span, data);
      if (span_units === 'screen') {
        return span;
      }
      if (position === 'center') {
        halfspan = (function() {
          var _i, _len, _results;
          _results = [];
          for (_i = 0, _len = span.length; _i < _len; _i++) {
            d = span[_i];
            _results.push(d / 2);
          }
          return _results;
        })();
        ptc = this.glyph_props.v_select(pt, data);
        if (pt_units === 'screen') {
          ptc = mapper.v_map_from_target(ptc);
        }
        pt0 = (function() {
          var _i, _ref, _results;
          _results = [];
          for (i = _i = 0, _ref = ptc.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
            _results.push(ptc[i] - halfspan[i]);
          }
          return _results;
        })();
        pt1 = (function() {
          var _i, _ref, _results;
          _results = [];
          for (i = _i = 0, _ref = ptc.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
            _results.push(ptc[i] + halfspan[i]);
          }
          return _results;
        })();
      } else {
        pt0 = this.glyph_props.v_select(pt, data);
        if (pt_units === 'screen') {
          pt0 = mapper.v_map_from_target(pt0);
        }
        pt1 = (function() {
          var _i, _ref, _results;
          _results = [];
          for (i = _i = 0, _ref = pt0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
            _results.push(pt0[i] + span[i]);
          }
          return _results;
        })();
      }
      spt0 = mapper.v_map_to_target(pt0);
      spt1 = mapper.v_map_to_target(pt1);
      return (function() {
        var _i, _ref, _results;
        _results = [];
        for (i = _i = 0, _ref = spt0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          _results.push(spt1[i] - spt0[i]);
        }
        return _results;
      })();
    };

    GlyphView.prototype.get_reference_point = function() {
      var reference_point;
      reference_point = this.mget('reference_point');
      if (_.isNumber(reference_point)) {
        return this.data[reference_point];
      } else {
        return reference_point;
      }
    };

    GlyphView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {};

    return GlyphView;

  })(PlotWidget);

  Glyph = (function(_super) {

    __extends(Glyph, _super);

    function Glyph() {
      return Glyph.__super__.constructor.apply(this, arguments);
    }

    return Glyph;

  })(HasParent);

  Glyph.prototype.defaults = _.clone(Glyph.prototype.defaults);

  _.extend(Glyph.prototype.defaults, {
    data_source: null
  });

  Glyph.prototype.display_defaults = _.clone(Glyph.prototype.display_defaults);

  _.extend(Glyph.prototype.display_defaults, {
    level: 'glyph',
    radius_units: 'screen',
    length_units: 'screen',
    angle_units: 'deg',
    start_angle_units: 'deg',
    end_angle_units: 'deg'
  });

  exports.GlyphView = GlyphView;

  exports.Glyph = Glyph;

}).call(this);
}, "renderers/glyph/image": function(exports, require, module) {(function() {
  var ColorMapper, Glyph, GlyphView, ImageGlyph, ImageView, all_palettes, glyph, glyph_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  all_palettes = require('../../palettes/palettes').all_palettes;

  ColorMapper = require('../../mappers/color/linear_color_mapper').LinearColorMapper;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  ImageView = (function(_super) {

    __extends(ImageView, _super);

    function ImageView() {
      return ImageView.__super__.constructor.apply(this, arguments);
    }

    ImageView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['image:array', 'width', 'height', 'x', 'y', 'dw', 'dh', 'palette:string'], []);
      return ImageView.__super__.initialize.call(this, options);
    };

    ImageView.prototype._set_data = function(data) {
      var buf, buf8, canvas, cmap, ctx, h, height, i, image_data, img, obj, width, _i, _j, _ref, _ref1, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      h = this.glyph_props.v_select('dh', data);
      for (i = _i = 0, _ref = this.y.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.y[i] += h[i];
      }
      this.pal = this.glyph_props.v_select('palette', data);
      width = this.glyph_props.v_select('width', data);
      height = this.glyph_props.v_select('height', data);
      img = (function() {
        var _j, _len, _results;
        _results = [];
        for (_j = 0, _len = data.length; _j < _len; _j++) {
          obj = data[_j];
          _results.push(this.glyph_props.select('image', obj));
        }
        return _results;
      }).call(this);
      this.image_data = new Array(data.length);
      _results = [];
      for (i = _j = 0, _ref1 = data.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
        canvas = document.createElement('canvas');
        canvas.width = width[i];
        canvas.height = height[i];
        ctx = canvas.getContext('2d');
        image_data = ctx.getImageData(0, 0, width[i], height[i]);
        cmap = new ColorMapper({}, {
          palette: all_palettes[this.pal[i]]
        });
        buf = cmap.v_map_screen(img[i]);
        buf8 = new Uint8ClampedArray(buf);
        image_data.data.set(buf8);
        ctx.putImageData(image_data, 0, 0);
        _results.push(this.image_data[i] = canvas);
      }
      return _results;
    };

    ImageView.prototype._render = function() {
      var ctx, i, old_smoothing, y_offset, _i, _ref, _ref1;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.sw = this.distance(this.data, 'x', 'dw', 'edge');
      this.sh = this.distance(this.data, 'y', 'dh', 'edge');
      ctx = this.plot_view.ctx;
      ctx.save();
      old_smoothing = ctx.getImageSmoothingEnabled();
      ctx.setImageSmoothingEnabled(false);
      for (i = _i = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
          continue;
        }
        y_offset = this.sy[i] + this.sh[i] / 2;
        ctx.translate(0, y_offset);
        ctx.scale(1, -1);
        ctx.translate(0, -y_offset);
        ctx.drawImage(this.image_data[i], this.sx[i] | 0, this.sy[i] | 0, this.sw[i], this.sh[i]);
        ctx.translate(0, y_offset);
        ctx.scale(1, -1);
        ctx.translate(0, -y_offset);
      }
      ctx.setImageSmoothingEnabled(old_smoothing);
      return ctx.restore();
    };

    return ImageView;

  })(GlyphView);

  ImageGlyph = (function(_super) {

    __extends(ImageGlyph, _super);

    function ImageGlyph() {
      return ImageGlyph.__super__.constructor.apply(this, arguments);
    }

    ImageGlyph.prototype.default_view = ImageView;

    ImageGlyph.prototype.type = 'GlyphRenderer';

    return ImageGlyph;

  })(Glyph);

  ImageGlyph.prototype.display_defaults = _.clone(ImageGlyph.prototype.display_defaults);

  _.extend(ImageGlyph.prototype.display_defaults, {
    level: 'underlay'
  });

  exports.Image = ImageGlyph;

  exports.ImageView = ImageView;

}).call(this);
}, "renderers/glyph/image_rgba": function(exports, require, module) {(function() {
  var Glyph, GlyphView, ImageRGBAGlyph, ImageRGBAView, glyph, glyph_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  ImageRGBAView = (function(_super) {

    __extends(ImageRGBAView, _super);

    function ImageRGBAView() {
      return ImageRGBAView.__super__.constructor.apply(this, arguments);
    }

    ImageRGBAView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['image:array', 'width', 'height', 'x', 'y', 'dw', 'dh'], []);
      return ImageRGBAView.__super__.initialize.call(this, options);
    };

    ImageRGBAView.prototype._set_data = function(data) {
      var ctx, h, height, i, img, obj, width, _i, _j, _ref, _ref1, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      h = this.glyph_props.v_select('dh', data);
      for (i = _i = 0, _ref = this.y.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.y[i] += h[i];
      }
      width = this.glyph_props.v_select('width', data);
      height = this.glyph_props.v_select('height', data);
      img = (function() {
        var _j, _len, _results;
        _results = [];
        for (_j = 0, _len = data.length; _j < _len; _j++) {
          obj = data[_j];
          _results.push(this.glyph_props.select('image', obj));
        }
        return _results;
      }).call(this);
      if (!(this.image_data != null) || this.image_data.length !== data.length) {
        this.image_data = new Array(data.length);
      }
      if (!(this.image_canvas != null) || this.image_canvas.length !== data.length) {
        this.image_canvas = new Array(data.length);
      }
      _results = [];
      for (i = _j = 0, _ref1 = data.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
        if (!(this.image_canvas[i] != null) || (this.image_canvas[i].width !== width[i] || this.image_canvas[i].height !== height[i])) {
          this.image_canvas[i] = document.createElement('canvas');
          this.image_canvas[i].width = width[i];
          this.image_canvas[i].height = height[i];
          ctx = this.image_canvas[i].getContext('2d');
          this.image_data[i] = ctx.createImageData(width[i], height[i]);
        }
        ctx = this.image_canvas[i].getContext('2d');
        this.image_data[i].data.set(new Uint8ClampedArray(img[i]));
        _results.push(ctx.putImageData(this.image_data[i], 0, 0));
      }
      return _results;
    };

    ImageRGBAView.prototype._render = function() {
      var ctx, i, old_smoothing, y_offset, _i, _ref, _ref1;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.sw = this.distance(this.data, 'x', 'dw', 'edge');
      this.sh = this.distance(this.data, 'y', 'dh', 'edge');
      ctx = this.plot_view.ctx;
      ctx.save();
      old_smoothing = ctx.getImageSmoothingEnabled();
      ctx.setImageSmoothingEnabled(false);
      for (i = _i = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
          continue;
        }
        y_offset = this.sy[i] + this.sh[i] / 2;
        ctx.translate(0, y_offset);
        ctx.scale(1, -1);
        ctx.translate(0, -y_offset);
        ctx.drawImage(this.image_canvas[i], this.sx[i] | 0, this.sy[i] | 0, this.sw[i], this.sh[i]);
        ctx.translate(0, y_offset);
        ctx.scale(1, -1);
        ctx.translate(0, -y_offset);
      }
      ctx.setImageSmoothingEnabled(old_smoothing);
      return ctx.restore();
    };

    return ImageRGBAView;

  })(GlyphView);

  ImageRGBAGlyph = (function(_super) {

    __extends(ImageRGBAGlyph, _super);

    function ImageRGBAGlyph() {
      return ImageRGBAGlyph.__super__.constructor.apply(this, arguments);
    }

    ImageRGBAGlyph.prototype.default_view = ImageRGBAView;

    ImageRGBAGlyph.prototype.type = 'GlyphRenderer';

    return ImageRGBAGlyph;

  })(Glyph);

  ImageRGBAGlyph.prototype.display_defaults = _.clone(ImageRGBAGlyph.prototype.display_defaults);

  _.extend(ImageRGBAGlyph.prototype.display_defaults, {
    level: 'underlay'
  });

  exports.ImageRGBA = ImageRGBAGlyph;

  exports.ImageRGBAView = ImageRGBAView;

}).call(this);
}, "renderers/glyph/image_uri": function(exports, require, module) {(function() {
  var Glyph, GlyphView, ImageURIGlyph, ImageURIView, glyph, glyph_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  ImageURIView = (function(_super) {

    __extends(ImageURIView, _super);

    function ImageURIView() {
      return ImageURIView.__super__.constructor.apply(this, arguments);
    }

    ImageURIView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['url:string', 'x', 'y', 'angle'], []);
      return ImageURIView.__super__.initialize.call(this, options);
    };

    ImageURIView.prototype._set_data = function(data) {
      var angle, angles, img, obj;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.url = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = data.length; _i < _len; _i++) {
          obj = data[_i];
          _results.push(this.glyph_props.select('url', obj));
        }
        return _results;
      }).call(this);
      angles = this.glyph_props.v_select('angle', data);
      this.angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = angles.length; _i < _len; _i++) {
          angle = angles[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      this.image = (function() {
        var _i, _len, _ref, _results;
        _ref = this.url;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          img = _ref[_i];
          _results.push(null);
        }
        return _results;
      }).call(this);
      this.need_load = (function() {
        var _i, _len, _ref, _results;
        _ref = this.url;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          img = _ref[_i];
          _results.push(true);
        }
        return _results;
      }).call(this);
      return this.loaded = (function() {
        var _i, _len, _ref, _results;
        _ref = this.url;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          img = _ref[_i];
          _results.push(false);
        }
        return _results;
      }).call(this);
    };

    ImageURIView.prototype._render = function() {
      var ctx, i, img, vs, _i, _ref, _ref1,
        _this = this;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ctx = this.plot_view.ctx;
      vs = this.plot_view.view_state;
      ctx.save();
      for (i = _i = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.angle[i])) {
          continue;
        }
        if (this.need_load[i]) {
          img = new Image();
          img.onload = (function(img, i) {
            return function() {
              _this.loaded[i] = true;
              _this.image[i] = img;
              ctx.save();
              ctx.beginPath();
              ctx.rect(vs.get('border_left') + 1, vs.get('border_top') + 1, vs.get('inner_width') - 2, vs.get('inner_height') - 2);
              ctx.clip();
              _this._render_image(ctx, vs, i, img);
              return ctx.restore();
            };
          })(img, i);
          img.src = this.url[i];
          this.need_load[i] = false;
        } else if (this.loaded[i]) {
          this._render_image(ctx, vs, i, this.image[i]);
        }
      }
      return ctx.restore();
    };

    ImageURIView.prototype._render_image = function(ctx, vs, i, img) {
      if (this.angle[i]) {
        ctx.translate(this.sx[i], this.sy[i]);
        ctx.rotate(this.angle[i]);
        ctx.drawImage(img, 0, 0);
        ctx.rotate(-this.angle[i]);
        return ctx.translate(-this.sx[i], -this.sy[i]);
      } else {
        return ctx.drawImage(img, this.sx[i], this.sy[i]);
      }
    };

    return ImageURIView;

  })(GlyphView);

  ImageURIGlyph = (function(_super) {

    __extends(ImageURIGlyph, _super);

    function ImageURIGlyph() {
      return ImageURIGlyph.__super__.constructor.apply(this, arguments);
    }

    ImageURIGlyph.prototype.default_view = ImageURIView;

    ImageURIGlyph.prototype.type = 'GlyphRenderer';

    return ImageURIGlyph;

  })(Glyph);

  ImageURIGlyph.prototype.display_defaults = _.clone(ImageURIGlyph.prototype.display_defaults);

  _.extend(ImageURIGlyph.prototype.display_defaults, {
    level: 'underlay'
  });

  exports.ImageURI = ImageURIGlyph;

  exports.ImageURIView = ImageURIView;

}).call(this);
}, "renderers/glyph/inverted_triangle": function(exports, require, module) {(function() {
  var Glyph, GlyphView, InvertedTriangle, InvertedTriangleView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  InvertedTriangleView = (function(_super) {

    __extends(InvertedTriangleView, _super);

    function InvertedTriangleView() {
      return InvertedTriangleView.__super__.constructor.apply(this, arguments);
    }

    InvertedTriangleView.prototype.initialize = function(options) {
      var spec;
      InvertedTriangleView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    InvertedTriangleView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    InvertedTriangleView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    InvertedTriangleView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    InvertedTriangleView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var a, h, i, r, _i, _j, _ref, _ref1, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      if (glyph_props.fill_properties.do_fill) {
        glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          a = this.size[i] * Math.sqrt(3) / 6;
          r = this.size[i] / 2;
          h = this.size[i] * Math.sqrt(3) / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i] - r, this.sy[i] - a);
          ctx.lineTo(this.sx[i] + r, this.sy[i] - a);
          ctx.lineTo(this.sx[i], this.sy[i] - a + h);
          ctx.closePath();
        }
        ctx.fill();
      }
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          a = this.size[i] * Math.sqrt(3) / 6;
          r = this.size[i] / 2;
          h = this.size[i] * Math.sqrt(3) / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i] - r, this.sy[i] - a);
          ctx.lineTo(this.sx[i] + r, this.sy[i] - a);
          ctx.lineTo(this.sx[i], this.sy[i] - a + h);
          ctx.closePath();
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    InvertedTriangleView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var a, h, i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        a = this.size[i] * Math.sqrt(3) / 6;
        r = this.size[i] / 2;
        h = this.size[i] * Math.sqrt(3) / 2;
        console.log(a, r, h);
        ctx.beginPath();
        ctx.moveTo(this.sx[i] - r, this.sy[i] - a);
        ctx.lineTo(this.sx[i] + r, this.sy[i] - a);
        ctx.lineTo(this.sx[i], this.sy[i] - a + h);
        ctx.closePath();
        if (glyph_props.fill_properties.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    InvertedTriangleView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    InvertedTriangleView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var a, border, d, data_r, fill_props, glyph_props, glyph_settings, h, line_props, r, reference_point, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      x = (x1 + x2) / 2.0;
      y = (y1 + y2) / 2.0;
      a = this.size[i] * Math.sqrt(3) / 6;
      r = this.size[i] / 2;
      h = this.size[i] * Math.sqrt(3) / 2;
      ctx.beginPath();
      ctx.moveTo(this.sx[i] - r, this.sy[i] - a);
      ctx.lineTo(this.sx[i] + r, this.sy[i] - a);
      ctx.lineTo(this.sx[i], this.sy[i] - a + h);
      ctx.closePath();
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return InvertedTriangleView;

  })(GlyphView);

  InvertedTriangle = (function(_super) {

    __extends(InvertedTriangle, _super);

    function InvertedTriangle() {
      return InvertedTriangle.__super__.constructor.apply(this, arguments);
    }

    InvertedTriangle.prototype.default_view = InvertedTriangleView;

    InvertedTriangle.prototype.type = 'GlyphRenderer';

    return InvertedTriangle;

  })(Glyph);

  InvertedTriangle.prototype.display_defaults = _.clone(InvertedTriangle.prototype.display_defaults);

  _.extend(InvertedTriangle.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.InvertedTriangle = InvertedTriangle;

  exports.InvertedTriangleView = InvertedTriangleView;

}).call(this);
}, "renderers/glyph/line": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Line, LineView, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  LineView = (function(_super) {

    __extends(LineView, _super);

    function LineView() {
      return LineView.__super__.constructor.apply(this, arguments);
    }

    LineView.prototype.initialize = function(options) {
      var spec;
      LineView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.do_stroke = this.glyph_props.line_properties.do_stroke;
    };

    LineView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x:number', 'y:number'], [new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    LineView.prototype._set_data = function(data) {
      var i, _i, _ref, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.selected_mask = new Uint8Array(data.length);
      _results = [];
      for (i = _i = 0, _ref = this.selected_mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        _results.push(this.selected_mask[i] = false);
      }
      return _results;
    };

    LineView.prototype._map_data = function() {
      var _ref;
      return _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1], _ref;
    };

    LineView.prototype._render = function() {
      var ctx, idx, props, selected, _i, _len;
      if (!this.do_stroke) {
        return;
      }
      this._map_data();
      ctx = this.plot_view.ctx;
      ctx.save();
      selected = this.mget_obj('data_source').get('selected');
      for (_i = 0, _len = selected.length; _i < _len; _i++) {
        idx = selected[_i];
        this.selected_mask[idx] = true;
      }
      if (selected && selected.length && this.nonselection_glyphprops) {
        if (this.selection_glyphprops) {
          props = this.selection_glyphprops;
        } else {
          props = this.glyph_props;
        }
        this._draw_path(ctx, this.nonselection_glyphprops, false);
        this._draw_path(ctx, props, true);
      } else {
        this._draw_path(ctx);
      }
      return ctx.restore();
    };

    LineView.prototype._draw_path = function(ctx, glyph_props, draw_selected) {
      var drawing, i, selected_mask, sx, sy, _i, _ref;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      glyph_props.line_properties.set(ctx, glyph_props);
      sx = this.sx;
      sy = this.sy;
      selected_mask = this.selected_mask;
      drawing = false;
      for (i = _i = 0, _ref = sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(sx[i] + sy[i]) || (draw_selected && !selected_mask[i]) || (!draw_selected && selected_mask[i])) {
          if (drawing) {
            ctx.stroke();
          }
          drawing = false;
          continue;
        }
        if (!drawing) {
          ctx.beginPath();
          ctx.moveTo(sx[i], sy[i]);
          drawing = true;
        } else {
          ctx.lineTo(sx[i], sy[i]);
        }
      }
      if (drawing) {
        return ctx.stroke();
      }
    };

    LineView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var glyph_props, glyph_settings, line_props, reference_point;
      ctx.save();
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
      } else {
        glyph_settings = glyph_props;
      }
      line_props.set(ctx, glyph_settings);
      ctx.beginPath();
      ctx.moveTo(x1, (y1 + y2) / 2);
      ctx.lineTo(x2, (y1 + y2) / 2);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    LineView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    return LineView;

  })(GlyphView);

  Line = (function(_super) {

    __extends(Line, _super);

    function Line() {
      return Line.__super__.constructor.apply(this, arguments);
    }

    Line.prototype.default_view = LineView;

    Line.prototype.type = 'GlyphRenderer';

    return Line;

  })(Glyph);

  Line.prototype.display_defaults = _.clone(Line.prototype.display_defaults);

  _.extend(Line.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Line = Line;

  exports.LineView = LineView;

}).call(this);
}, "renderers/glyph/multi_line": function(exports, require, module) {(function() {
  var Glyph, GlyphView, MultiLine, MultiLineView, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  MultiLineView = (function(_super) {

    __extends(MultiLineView, _super);

    function MultiLineView() {
      return MultiLineView.__super__.constructor.apply(this, arguments);
    }

    MultiLineView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['xs:array', 'ys:array'], [new line_properties(this, glyphspec)]);
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return MultiLineView.__super__.initialize.call(this, options);
    };

    MultiLineView.prototype._set_data = function(data) {
      this.data = data;
    };

    MultiLineView.prototype._render = function() {
      var ctx;
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    MultiLineView.prototype._fast_path = function(ctx) {
      var i, pt, sx, sy, x, y, _i, _j, _len, _ref, _ref1, _ref2, _results;
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        _ref = this.data;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          pt = _ref[_i];
          x = this.glyph_props.select('xs', pt);
          y = this.glyph_props.select('ys', pt);
          _ref1 = this.plot_view.map_to_screen(x, this.glyph_props.xs.units, y, this.glyph_props.ys.units), sx = _ref1[0], sy = _ref1[1];
          for (i = _j = 0, _ref2 = sx.length - 1; 0 <= _ref2 ? _j <= _ref2 : _j >= _ref2; i = 0 <= _ref2 ? ++_j : --_j) {
            if (i === 0) {
              ctx.beginPath();
              ctx.moveTo(sx[i], sy[i]);
              continue;
            } else if (isNaN(sx[i]) || isNaN(sy[i])) {
              ctx.stroke();
              ctx.beginPath();
              continue;
            } else {
              ctx.lineTo(sx[i], sy[i]);
            }
          }
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    MultiLineView.prototype._full_path = function(ctx) {
      var i, pt, sx, sy, x, y, _i, _j, _len, _ref, _ref1, _ref2, _results;
      if (this.do_stroke) {
        _ref = this.data;
        _results = [];
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          pt = _ref[_i];
          x = this.glyph_props.select('xs', pt);
          y = this.glyph_props.select('ys', pt);
          _ref1 = this.plot_view.map_to_screen(x, this.glyph_props.xs.units, y, this.glyph_props.ys.units), sx = _ref1[0], sy = _ref1[1];
          this.glyph_props.line_properties.set(ctx, pt);
          for (i = _j = 0, _ref2 = sx.length - 1; 0 <= _ref2 ? _j <= _ref2 : _j >= _ref2; i = 0 <= _ref2 ? ++_j : --_j) {
            if (i === 0) {
              ctx.beginPath();
              ctx.moveTo(sx[i], sy[i]);
              continue;
            } else if (isNaN(sx[i]) || isNaN(sy[i])) {
              ctx.stroke();
              ctx.beginPath();
              continue;
            } else {
              ctx.lineTo(sx[i], sy[i]);
            }
          }
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    MultiLineView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var glyph_props, glyph_settings, line_props, reference_point;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
      } else {
        glyph_settings = glyph_props;
      }
      ctx.beginPath();
      ctx.moveTo(x1, (y1 + y2) / 2);
      ctx.lineTo(x2, (y1 + y2) / 2);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return MultiLineView;

  })(GlyphView);

  MultiLine = (function(_super) {

    __extends(MultiLine, _super);

    function MultiLine() {
      return MultiLine.__super__.constructor.apply(this, arguments);
    }

    MultiLine.prototype.default_view = MultiLineView;

    MultiLine.prototype.type = 'GlyphRenderer';

    return MultiLine;

  })(Glyph);

  MultiLine.prototype.display_defaults = _.clone(MultiLine.prototype.display_defaults);

  _.extend(MultiLine.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.MultiLine = MultiLine;

  exports.MultiLineView = MultiLineView;

}).call(this);
}, "renderers/glyph/oval": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Oval, OvalView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  OvalView = (function(_super) {

    __extends(OvalView, _super);

    function OvalView() {
      return OvalView.__super__.constructor.apply(this, arguments);
    }

    OvalView.prototype.initialize = function(options) {
      var spec;
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return OvalView.__super__.initialize.call(this, options);
    };

    OvalView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'width', 'height', 'angle'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    OvalView.prototype._set_data = function(data) {
      var angle, angles, i, _i, _ref, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      angles = this.glyph_props.v_select('angle', data);
      this.angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = angles.length; _i < _len; _i++) {
          angle = angles[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      this.selected_mask = new Uint8Array(data.length);
      _results = [];
      for (i = _i = 0, _ref = this.selected_mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        _results.push(this.selected_mask[i] = false);
      }
      return _results;
    };

    OvalView.prototype._render = function() {
      var ctx, idx, props, selected, _i, _len, _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.sw = this.distance(this.data, 'x', 'width', 'center');
      this.sh = this.distance(this.data, 'y', 'height', 'center');
      ctx = this.plot_view.ctx;
      ctx.save();
      selected = this.mget_obj('data_source').get('selected');
      for (_i = 0, _len = selected.length; _i < _len; _i++) {
        idx = selected[_i];
        this.selected_mask[idx] = true;
      }
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, 'selected');
          this._full_path(ctx, this.nonselection_glyphprops, 'unselected');
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    OvalView.prototype._fast_path = function(ctx) {
      var i, _i, _j, _ref, _ref1;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i] + this.angle[i])) {
            continue;
          }
          ctx.translate(this.sx[i], this.sy[i]);
          ctx.rotate(this.angle[i]);
          ctx.beginPath();
          ctx.moveTo(0, -this.sh[i] / 2);
          ctx.bezierCurveTo(this.sw[i] / 2, -this.sh[i] / 2, this.sw[i] / 2, this.sh[i] / 2, 0, this.sh[i] / 2);
          ctx.bezierCurveTo(-this.sw[i] / 2, this.sh[i] / 2, -this.sw[i] / 2, -this.sh[i] / 2, 0, -this.sh[i] / 2);
          ctx.closePath();
          ctx.fill();
          ctx.rotate(-this.angle[i]);
          ctx.translate(-this.sx[i], -this.sy[i]);
        }
      }
      if (this.do_fill) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i] + this.angle[i])) {
            continue;
          }
          ctx.translate(this.sx[i], this.sy[i]);
          ctx.rotate(this.angle[i]);
          ctx.moveTo(0, -this.sh[i] / 2);
          ctx.bezierCurveTo(this.sw[i] / 2, -this.sh[i] / 2, this.sw[i] / 2, this.sh[i] / 2, 0, this.sh[i] / 2);
          ctx.bezierCurveTo(-this.sw[i] / 2, this.sh[i] / 2, -this.sw[i] / 2, -this.sh[i] / 2, 0, -this.sh[i] / 2);
          ctx.rotate(-this.angle[i]);
          ctx.translate(-this.sx[i], -this.sy[i]);
        }
        return ctx.stroke();
      }
    };

    OvalView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i] + this.angle[i])) {
          continue;
        }
        if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i] + this.angle[i])) {
          continue;
        }
        if (use_selection === 'selected' && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === 'unselected' && this.selected_mask[i]) {
          continue;
        }
        ctx.translate(this.sx[i], this.sy[i]);
        ctx.rotate(this.angle[i]);
        ctx.beginPath();
        ctx.moveTo(0, -this.sh[i] / 2);
        ctx.bezierCurveTo(this.sw[i] / 2, -this.sh[i] / 2, this.sw[i] / 2, this.sh[i] / 2, 0, this.sh[i] / 2);
        ctx.bezierCurveTo(-this.sw[i] / 2, this.sh[i] / 2, -this.sw[i] / 2, -this.sh[i] / 2, 0, -this.sh[i] / 2);
        ctx.closePath();
        if (this.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          ctx.stroke();
        }
        ctx.rotate(-this.angle[i]);
        _results.push(ctx.translate(-this.sx[i], -this.sy[i]));
      }
      return _results;
    };

    OvalView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, fill_props, glyph_props, glyph_settings, h, line_props, ratio, ratio1, ratio2, reference_point, sh, sw, w;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        sw = this.distance([reference_point], 'x', 'width', 'center')[0];
        sh = this.distance([refrence_point], 'y', 'height', 'center')[0];
      } else {
        glyph_settings = glyph_props;
        sw = 1.0;
        sh = 2.0;
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      w = Math.abs(x2 - x1);
      h = Math.abs(y2 - y1);
      w = w - 2 * border;
      h = h - 2 * border;
      ratio1 = h / sh;
      ratio2 = w / sw;
      ratio = _.min([ratio1, ratio2]);
      h = sh * ratio;
      w = sw * ratio;
      ctx.translate((x1 + x2) / 2, (y1 + y2) / 2);
      ctx.beginPath();
      ctx.moveTo(0, -h / 2);
      ctx.bezierCurveTo(w / 2, -h / 2, w / 2, h / 2, 0, h / 2);
      ctx.bezierCurveTo(-w / 2, h / 2, -w / 2, -h / 2, 0, -h / 2);
      ctx.closePath();
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    OvalView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    return OvalView;

  })(GlyphView);

  Oval = (function(_super) {

    __extends(Oval, _super);

    function Oval() {
      return Oval.__super__.constructor.apply(this, arguments);
    }

    Oval.prototype.default_view = OvalView;

    Oval.prototype.type = 'GlyphRenderer';

    return Oval;

  })(Glyph);

  Oval.prototype.display_defaults = _.clone(Oval.prototype.display_defaults);

  _.extend(Oval.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0,
    angle: 0.0
  });

  exports.Oval = Oval;

  exports.OvalView = OvalView;

}).call(this);
}, "renderers/glyph/patch": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Patch, PatchView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  PatchView = (function(_super) {

    __extends(PatchView, _super);

    function PatchView() {
      return PatchView.__super__.constructor.apply(this, arguments);
    }

    PatchView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x:number', 'y:number'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return PatchView.__super__.initialize.call(this, options);
    };

    PatchView.prototype._set_data = function(data) {
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      return this.y = this.glyph_props.v_select('y', data);
    };

    PatchView.prototype._render = function() {
      var ctx, i, sx, sy, _i, _j, _ref, _ref1, _ref2;
      ctx = this.plot_view.ctx;
      ctx.save();
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), sx = _ref[0], sy = _ref[1];
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        for (i = _i = 0, _ref1 = sx.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
          if (i === 0) {
            ctx.beginPath();
            ctx.moveTo(sx[i], sy[i]);
            continue;
          } else if (isNaN(sx[i] + sy[i])) {
            ctx.closePath();
            ctx.fill();
            ctx.beginPath();
            continue;
          } else {
            ctx.lineTo(sx[i], sy[i]);
          }
        }
        ctx.closePath();
        ctx.fill();
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        for (i = _j = 0, _ref2 = sx.length - 1; 0 <= _ref2 ? _j <= _ref2 : _j >= _ref2; i = 0 <= _ref2 ? ++_j : --_j) {
          if (i === 0) {
            ctx.beginPath();
            ctx.moveTo(sx[i], sy[i]);
            continue;
          } else if (isNaN(sx[i] + sy[i])) {
            ctx.closePath();
            ctx.stroke();
            ctx.beginPath();
            continue;
          } else {
            ctx.lineTo(sx[i], sy[i]);
          }
        }
        ctx.closePath();
        ctx.stroke();
      }
      return ctx.restore();
    };

    return PatchView;

  })(GlyphView);

  Patch = (function(_super) {

    __extends(Patch, _super);

    function Patch() {
      return Patch.__super__.constructor.apply(this, arguments);
    }

    Patch.prototype.default_view = PatchView;

    Patch.prototype.type = 'GlyphRenderer';

    return Patch;

  })(Glyph);

  Patch.prototype.display_defaults = _.clone(Patch.prototype.display_defaults);

  _.extend(Patch.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Patch = Patch;

  exports.PatchView = PatchView;

}).call(this);
}, "renderers/glyph/patches": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Patches, PatchesView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  PatchesView = (function(_super) {

    __extends(PatchesView, _super);

    function PatchesView() {
      return PatchesView.__super__.constructor.apply(this, arguments);
    }

    PatchesView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['xs:array', 'ys:array'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return PatchesView.__super__.initialize.call(this, options);
    };

    PatchesView.prototype._set_data = function(data) {
      this.data = data;
    };

    PatchesView.prototype._render = function() {
      var ctx, i, pt, sx, sy, x, y, _i, _j, _k, _len, _ref, _ref1, _ref2, _ref3;
      ctx = this.plot_view.ctx;
      ctx.save();
      _ref = this.data;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        pt = _ref[_i];
        x = this.glyph_props.select('xs', pt);
        y = this.glyph_props.select('ys', pt);
        _ref1 = this.plot_view.map_to_screen(x, this.glyph_props.xs.units, y, this.glyph_props.ys.units), sx = _ref1[0], sy = _ref1[1];
        if (this.do_fill) {
          this.glyph_props.fill_properties.set(ctx, pt);
          for (i = _j = 0, _ref2 = sx.length - 1; 0 <= _ref2 ? _j <= _ref2 : _j >= _ref2; i = 0 <= _ref2 ? ++_j : --_j) {
            if (i === 0) {
              ctx.beginPath();
              ctx.moveTo(sx[i], sy[i]);
              continue;
            } else if (isNaN(sx[i] + sy[i])) {
              ctx.closePath();
              ctx.fill();
              ctx.beginPath();
              continue;
            } else {
              ctx.lineTo(sx[i], sy[i]);
            }
          }
          ctx.closePath();
          ctx.fill();
        }
        if (this.do_stroke) {
          this.glyph_props.line_properties.set(ctx, pt);
          for (i = _k = 0, _ref3 = sx.length - 1; 0 <= _ref3 ? _k <= _ref3 : _k >= _ref3; i = 0 <= _ref3 ? ++_k : --_k) {
            if (i === 0) {
              ctx.beginPath();
              ctx.moveTo(sx[i], sy[i]);
              continue;
            } else if (isNaN(sx[i] + sy[i])) {
              ctx.closePath();
              ctx.stroke();
              ctx.beginPath();
              continue;
            } else {
              ctx.lineTo(sx[i], sy[i]);
            }
          }
          ctx.closePath();
          ctx.stroke();
        }
      }
      return ctx.restore();
    };

    return PatchesView;

  })(GlyphView);

  Patches = (function(_super) {

    __extends(Patches, _super);

    function Patches() {
      return Patches.__super__.constructor.apply(this, arguments);
    }

    Patches.prototype.default_view = PatchesView;

    Patches.prototype.type = 'GlyphRenderer';

    return Patches;

  })(Glyph);

  Patches.prototype.display_defaults = _.clone(Patches.prototype.display_defaults);

  _.extend(Patches.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Patches = Patches;

  exports.PatchesView = PatchesView;

}).call(this);
}, "renderers/glyph/quad": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Quad, QuadView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  QuadView = (function(_super) {

    __extends(QuadView, _super);

    function QuadView() {
      return QuadView.__super__.constructor.apply(this, arguments);
    }

    QuadView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['right', 'left', 'bottom', 'top'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return QuadView.__super__.initialize.call(this, options);
    };

    QuadView.prototype._set_data = function(data) {
      var i, _i, _ref, _results;
      this.data = data;
      this.left = this.glyph_props.v_select('left', data);
      this.top = this.glyph_props.v_select('top', data);
      this.right = this.glyph_props.v_select('right', data);
      this.bottom = this.glyph_props.v_select('bottom', data);
      this.mask = new Uint8Array(data.length);
      _results = [];
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        _results.push(this.mask[i] = true);
      }
      return _results;
    };

    QuadView.prototype._render = function() {
      var ctx, i, oh, ow, _i, _ref, _ref1, _ref2;
      _ref = this.plot_view.map_to_screen(this.left, this.glyph_props.left.units, this.top, this.glyph_props.top.units), this.sx0 = _ref[0], this.sy0 = _ref[1];
      _ref1 = this.plot_view.map_to_screen(this.right, this.glyph_props.right.units, this.bottom, this.glyph_props.bottom.units), this.sx1 = _ref1[0], this.sy1 = _ref1[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref2 = this.mask.length - 1; 0 <= _ref2 ? _i <= _ref2 : _i >= _ref2; i = 0 <= _ref2 ? ++_i : --_i) {
        if ((this.sx0[i] < 0 && this.sx1[i] < 0) || (this.sx0[i] > ow && this.sx1[i] > ow) || (this.sy0[i] < 0 && this.sy1[i] < 0) || (this.sy0[i] > oh && this.sy1[i] > oh)) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    QuadView.prototype._fast_path = function(ctx) {
      var i, _i, _j, _ref, _ref1;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i]) || !this.mask[i]) {
            continue;
          }
          ctx.rect(this.sx0[i], this.sy0[i], this.sx1[i] - this.sx0[i], this.sy1[i] - this.sy0[i]);
        }
        ctx.fill();
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _j = 0, _ref1 = this.sx0.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i]) || !this.mask[i]) {
            continue;
          }
          ctx.rect(this.sx0[i], this.sy0[i], this.sx1[i] - this.sx0[i], this.sy1[i] - this.sy0[i]);
        }
        return ctx.stroke();
      }
    };

    QuadView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      _results = [];
      for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i]) || !this.mask[i]) {
          continue;
        }
        ctx.beginPath();
        ctx.rect(this.sx0[i], this.sy0[i], this.sx1[i] - this.sx0[i], this.sy1[i] - this.sy0[i]);
        if (this.do_fill) {
          this.glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          this.glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    QuadView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, bottom, data_h, data_w, fill_props, glyph_props, glyph_settings, h, left, line_props, ratio, ratio1, ratio2, reference_point, right, sx0, sx1, sy0, sy1, top, w, x, y, _ref, _ref1;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        left = this.glyph_props.select('left', glyph_settings);
        top = this.glyph_props.select('top', glyph_settings);
        right = this.glyph_props.select('right', glyph_settings);
        bottom = this.glyph_props.select('bottom', glyph_settings);
        _ref = this.plot_view.map_to_screen([left], this.glyph_props.left.units, [top], this.glyph_props.top.units), sx0 = _ref[0], sy0 = _ref[1];
        _ref1 = this.plot_view.map_to_screen([right], this.glyph_props.right.units, [bottom], this.glyph_props.bottom.units), sx1 = _ref1[0], sy1 = _ref1[1];
        data_w = sx1[0] - sx0[0];
        data_h = sy1[0] - sy0[0];
      } else {
        glyph_settings = glyph_props;
        data_w = 1;
        data_h = 1;
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      data_w = data_w - 2 * border;
      data_h = data_h - 2 * border;
      w = Math.abs(x2 - x1);
      h = Math.abs(y2 - y1);
      ratio1 = w / data_w;
      ratio2 = h / data_h;
      ratio = _.min([ratio1, ratio2]);
      w = ratio * data_w;
      h = ratio * data_h;
      x = (x1 + x2) / 2 - (w / 2);
      y = (y1 + y2) / 2 - (h / 2);
      ctx.beginPath();
      ctx.rect(x, y, w, h);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return QuadView;

  })(GlyphView);

  Quad = (function(_super) {

    __extends(Quad, _super);

    function Quad() {
      return Quad.__super__.constructor.apply(this, arguments);
    }

    Quad.prototype.default_view = QuadView;

    Quad.prototype.type = 'GlyphRenderer';

    return Quad;

  })(Glyph);

  Quad.prototype.display_defaults = _.clone(Quad.prototype.display_defaults);

  _.extend(Quad.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Quad = Quad;

  exports.QuadView = QuadView;

}).call(this);
}, "renderers/glyph/quadratic": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Quadratic, QuadraticView, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  QuadraticView = (function(_super) {

    __extends(QuadraticView, _super);

    function QuadraticView() {
      return QuadraticView.__super__.constructor.apply(this, arguments);
    }

    QuadraticView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x0', 'y0', 'x1', 'y1', 'cx', 'cy'], [new line_properties(this, glyphspec)]);
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return QuadraticView.__super__.initialize.call(this, options);
    };

    QuadraticView.prototype._set_data = function(data) {
      this.data = data;
      this.x0 = this.glyph_props.v_select('x0', data);
      this.y0 = this.glyph_props.v_select('y0', data);
      this.x1 = this.glyph_props.v_select('x1', data);
      this.y1 = this.glyph_props.v_select('y1', data);
      this.cx = this.glyph_props.v_select('cx', data);
      return this.cy = this.glyph_props.v_select('cy', data);
    };

    QuadraticView.prototype._render = function() {
      var ctx, _ref, _ref1, _ref2;
      _ref = this.plot_view.map_to_screen(this.x0, this.glyph_props.x0.units, this.y0, this.glyph_props.y0.units), this.sx0 = _ref[0], this.sy0 = _ref[1];
      _ref1 = this.plot_view.map_to_screen(this.x1, this.glyph_props.x1.units, this.y1, this.glyph_props.y1.units), this.sx1 = _ref1[0], this.sy1 = _ref1[1];
      _ref2 = this.plot_view.map_to_screen(this.cx, this.glyph_props.cx.units, this.cy, this.glyph_props.cy.units), this.scx = _ref2[0], this.scy = _ref2[1];
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    QuadraticView.prototype._fast_path = function(ctx) {
      var i, _i, _ref;
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i] + this.scx[i] + this.scy[i])) {
            continue;
          }
          ctx.moveTo(this.sx0[i], this.sy0[i]);
          ctx.quadraticCurveTo(this.scx[i], this.scy[i], this.sx1[i], this.sy1[i]);
        }
        return ctx.stroke();
      }
    };

    QuadraticView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      if (this.do_stroke) {
        _results = [];
        for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i] + this.scx[i] + this.scy[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.moveTo(this.sx0[i], this.sy0[i]);
          ctx.quadraticCurveTo(this.scx[i], this.scy[i], this.sx1[i], this.sy1[i]);
          this.glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    return QuadraticView;

  })(GlyphView);

  Quadratic = (function(_super) {

    __extends(Quadratic, _super);

    function Quadratic() {
      return Quadratic.__super__.constructor.apply(this, arguments);
    }

    Quadratic.prototype.default_view = QuadraticView;

    Quadratic.prototype.type = 'GlyphRenderer';

    return Quadratic;

  })(Glyph);

  Quadratic.prototype.display_defaults = _.clone(Quadratic.prototype.display_defaults);

  _.extend(Quadratic.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Quadratic = Quadratic;

  exports.QuadraticView = QuadraticView;

}).call(this);
}, "renderers/glyph/ray": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Ray, RayView, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  RayView = (function(_super) {

    __extends(RayView, _super);

    function RayView() {
      return RayView.__super__.constructor.apply(this, arguments);
    }

    RayView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'angle', 'length'], [new line_properties(this, glyphspec)]);
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return RayView.__super__.initialize.call(this, options);
    };

    RayView.prototype._set_data = function(data) {
      var angle, angles, obj;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      angles = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = data.length; _i < _len; _i++) {
          obj = data[_i];
          _results.push(this.glyph_props.select('angle', obj));
        }
        return _results;
      }).call(this);
      this.angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = angles.length; _i < _len; _i++) {
          angle = angles[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      return this.length = this.glyph_props.v_select('length', data);
    };

    RayView.prototype._render = function() {
      var ctx, height, i, inf_len, width, _i, _ref, _ref1;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      width = this.plot_view.view_state.get('width');
      height = this.plot_view.view_state.get('height');
      inf_len = 2 * (width + height);
      for (i = _i = 0, _ref1 = this.length.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if (this.length[i] === 0) {
          this.length[i] = inf_len;
        }
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    RayView.prototype._fast_path = function(ctx) {
      var i, _i, _ref;
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.angle[i] + this.length[i])) {
            continue;
          }
          ctx.translate(this.sx[i], this.sy[i]);
          ctx.rotate(this.angle[i]);
          ctx.moveTo(0, 0);
          ctx.lineTo(this.length[i], 0);
          ctx.rotate(-this.angle[i]);
          ctx.translate(-this.sx[i], -this.sy[i]);
        }
        return ctx.stroke();
      }
    };

    RayView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      if (this.do_stroke) {
        _results = [];
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.angle[i] + this.length[i])) {
            continue;
          }
          ctx.translate(this.sx[i], this.sy[i]);
          ctx.rotate(this.angle[i]);
          ctx.beginPath();
          ctx.moveTo(0, 0);
          ctx.lineTo(this.length[i], 0);
          this.glyph_props.line_properties.set(ctx, this.data[i]);
          ctx.stroke();
          ctx.rotate(-this.angle[i]);
          _results.push(ctx.translate(-this.sx[i], -this.sy[i]));
        }
        return _results;
      }
    };

    RayView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var angle, glyph_props, glyph_settings, line_props, r, reference_point, sx, sy;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
      } else {
        glyph_settings = glyph_props;
      }
      angle = -this.glyph_props.select('angle', glyph_settings);
      r = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]) / 2;
      sx = (x1 + x2) / 2;
      sy = (y1 + y2) / 2;
      ctx.beginPath();
      ctx.translate(sx, sy);
      ctx.rotate(angle);
      ctx.moveTo(0, 0);
      ctx.lineTo(r, 0);
      ctx.rotate(-angle);
      ctx.translate(-sx, -sy);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return RayView;

  })(GlyphView);

  Ray = (function(_super) {

    __extends(Ray, _super);

    function Ray() {
      return Ray.__super__.constructor.apply(this, arguments);
    }

    Ray.prototype.default_view = RayView;

    Ray.prototype.type = 'GlyphRenderer';

    return Ray;

  })(Glyph);

  Ray.prototype.display_defaults = _.clone(Ray.prototype.display_defaults);

  _.extend(Ray.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Ray = Ray;

  exports.RayView = RayView;

}).call(this);
}, "renderers/glyph/rect": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Rect, RectView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  RectView = (function(_super) {

    __extends(RectView, _super);

    function RectView() {
      return RectView.__super__.constructor.apply(this, arguments);
    }

    RectView.prototype.initialize = function(options) {
      var spec;
      RectView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      return this.do_stroke = this.glyph_props.line_properties.do_stroke;
    };

    RectView.prototype.init_glyph = function(glyphspec) {
      var fill_props, glyph_props, line_props;
      fill_props = new fill_properties(this, glyphspec);
      line_props = new line_properties(this, glyphspec);
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'width', 'height', 'angle'], [line_props, fill_props]);
      return glyph_props;
    };

    RectView.prototype._set_data = function(data) {
      var angle, angles, i, _i, _ref, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      angles = this.glyph_props.v_select('angle', data);
      this.angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = angles.length; _i < _len; _i++) {
          angle = angles[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      this.selected_mask = new Uint8Array(data.length);
      _results = [];
      for (i = _i = 0, _ref = this.selected_mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        _results.push(this.selected_mask[i] = false);
      }
      return _results;
    };

    RectView.prototype._map_data = function() {
      var i, sxi, syi, _i, _ref, _ref1, _results;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), sxi = _ref[0], syi = _ref[1];
      this.sw = this.distance(this.data, 'x', 'width', 'center');
      this.sh = this.distance(this.data, 'y', 'height', 'center');
      this.sx = new Array(sxi.length);
      this.sy = new Array(sxi.length);
      _results = [];
      for (i = _i = 0, _ref1 = sxi.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if (Math.abs(sxi[i] - this.sw[i]) < 2) {
          this.sx[i] = Math.round(sxi[i]);
        } else {
          this.sx[i] = sxi[i];
        }
        if (Math.abs(syi[i] - this.sh[i]) < 2) {
          _results.push(this.sy[i] = Math.round(syi[i]));
        } else {
          _results.push(this.sy[i] = syi[i]);
        }
      }
      return _results;
    };

    RectView.prototype._render = function() {
      var ctx, idx, props, selected, _i, _len;
      this._map_data();
      ctx = this.plot_view.ctx;
      selected = this.mget_obj('data_source').get('selected');
      for (_i = 0, _len = selected.length; _i < _len; _i++) {
        idx = selected[_i];
        this.selected_mask[idx] = true;
      }
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, 'selected');
          this._full_path(ctx, this.nonselection_glyphprops, 'unselected');
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    RectView.prototype._fast_path = function(ctx) {
      var i, _i, _j, _ref, _ref1;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i] + this.angle[i])) {
            continue;
          }
          if (this.angle[i]) {
            ctx.translate(this.sx[i], this.sy[i]);
            ctx.rotate(this.angle[i]);
            ctx.rect(-this.sw[i] / 2, -this.sh[i] / 2, this.sw[i], this.sh[i]);
            ctx.rotate(-this.angle[i]);
            ctx.translate(-this.sx[i], -this.sy[i]);
          } else {
            ctx.rect(this.sx[i] - this.sw[i] / 2, this.sy[i] - this.sh[i] / 2, this.sw[i], this.sh[i]);
          }
        }
        ctx.fill();
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i] + this.angle[i])) {
            continue;
          }
          if (this.angle[i]) {
            ctx.translate(this.sx[i], this.sy[i]);
            ctx.rotate(this.angle[i]);
            ctx.rect(-this.sw[i] / 2, -this.sh[i] / 2, this.sw[i], this.sh[i]);
            ctx.rotate(-this.angle[i]);
            ctx.translate(-this.sx[i], -this.sy[i]);
          } else {
            ctx.rect(this.sx[i] - this.sw[i] / 2, this.sy[i] - this.sh[i] / 2, this.sw[i], this.sh[i]);
          }
        }
        return ctx.stroke();
      }
    };

    RectView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, data_h, data_w, fill_props, glyph_props, glyph_settings, h, line_props, reference_point, w, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_w = this.distance([reference_point], 'x', 'width', 'center')[0];
        data_h = this.distance([reference_point], 'y', 'height', 'center')[0];
      } else {
        glyph_settings = glyph_props;
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      w = Math.abs(x2 - x1);
      h = Math.abs(y2 - y1);
      w = w - 2 * border;
      h = h - 2 * border;
      if (data_w != null) {
        w = data_w > w ? w : data_w;
      }
      if (data_h != null) {
        h = data_h > h ? h : data_h;
      }
      x = (x1 + x2) / 2 - (w / 2);
      y = (y1 + y2) / 2 - (h / 2);
      ctx.rect(x, y, w, h);
      fill_props.set(ctx, glyph_settings);
      ctx.fill();
      line_props.set(ctx, glyph_settings);
      ctx.stroke();
      return ctx.restore();
    };

    RectView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i] + this.angle[i])) {
          continue;
        }
        if (use_selection === 'selected' && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === 'unselected' && this.selected_mask[i]) {
          continue;
        }
        ctx.translate(this.sx[i], this.sy[i]);
        ctx.rotate(this.angle[i]);
        ctx.beginPath();
        ctx.rect(-this.sw[i] / 2, -this.sh[i] / 2, this.sw[i], this.sh[i]);
        if (this.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          ctx.stroke();
        }
        ctx.rotate(-this.angle[i]);
        _results.push(ctx.translate(-this.sx[i], -this.sy[i]));
      }
      return _results;
    };

    RectView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    return RectView;

  })(GlyphView);

  Rect = (function(_super) {

    __extends(Rect, _super);

    function Rect() {
      return Rect.__super__.constructor.apply(this, arguments);
    }

    Rect.prototype.default_view = RectView;

    Rect.prototype.type = 'GlyphRenderer';

    return Rect;

  })(Glyph);

  Rect.prototype.display_defaults = _.clone(Rect.prototype.display_defaults);

  _.extend(Rect.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0,
    angle: 0.0
  });

  exports.Rect = Rect;

  exports.RectView = RectView;

}).call(this);
}, "renderers/glyph/segment": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Segment, SegmentView, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  SegmentView = (function(_super) {

    __extends(SegmentView, _super);

    function SegmentView() {
      return SegmentView.__super__.constructor.apply(this, arguments);
    }

    SegmentView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x0', 'y0', 'x1', 'y1'], [new line_properties(this, glyphspec)]);
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return SegmentView.__super__.initialize.call(this, options);
    };

    SegmentView.prototype._set_data = function(data) {
      this.data = data;
      this.x0 = this.glyph_props.v_select('x0', data);
      this.y0 = this.glyph_props.v_select('y0', data);
      this.x1 = this.glyph_props.v_select('x1', data);
      return this.y1 = this.glyph_props.v_select('y1', data);
    };

    SegmentView.prototype._render = function() {
      var ctx, _ref, _ref1;
      _ref = this.plot_view.map_to_screen(this.x0, this.glyph_props.x0.units, this.y0, this.glyph_props.y0.units), this.sx0 = _ref[0], this.sy0 = _ref[1];
      _ref1 = this.plot_view.map_to_screen(this.x1, this.glyph_props.x1.units, this.y1, this.glyph_props.y1.units), this.sx1 = _ref1[0], this.sy1 = _ref1[1];
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    SegmentView.prototype._fast_path = function(ctx) {
      var i, _i, _ref;
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i])) {
            continue;
          }
          ctx.moveTo(this.sx0[i], this.sy0[i]);
          ctx.lineTo(this.sx1[i], this.sy1[i]);
        }
        return ctx.stroke();
      }
    };

    SegmentView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      if (this.do_stroke) {
        _results = [];
        for (i = _i = 0, _ref = this.sx0.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx0[i] + this.sy0[i] + this.sx1[i] + this.sy1[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.moveTo(this.sx0[i], this.sy0[i]);
          ctx.lineTo(this.sx1[i], this.sy1[i]);
          this.glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    SegmentView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var glyph_props, glyph_settings, line_props, reference_point;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
      } else {
        glyph_settings = glyph_props;
      }
      line_props.set(ctx, glyph_settings);
      ctx.beginPath();
      ctx.moveTo(x1, (y1 + y2) / 2);
      ctx.lineTo(x2, (y1 + y2) / 2);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return SegmentView;

  })(GlyphView);

  Segment = (function(_super) {

    __extends(Segment, _super);

    function Segment() {
      return Segment.__super__.constructor.apply(this, arguments);
    }

    Segment.prototype.default_view = SegmentView;

    Segment.prototype.type = 'GlyphRenderer';

    return Segment;

  })(Glyph);

  Segment.prototype.display_defaults = _.clone(Segment.prototype.display_defaults);

  _.extend(Segment.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Segment = Segment;

  exports.SegmentView = SegmentView;

}).call(this);
}, "renderers/glyph/square": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Square, SquareView, fill_properties, glyph, glyph_properties, line_properties, properties, rect,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  rect = require("./rect");

  SquareView = (function(_super) {

    __extends(SquareView, _super);

    function SquareView() {
      return SquareView.__super__.constructor.apply(this, arguments);
    }

    SquareView.prototype.initialize = function(options) {
      var spec;
      SquareView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      return this.do_stroke = this.glyph_props.line_properties.do_stroke;
    };

    SquareView.prototype.init_glyph = function(glyphspec) {
      var fill_props, glyph_props, line_props;
      fill_props = new fill_properties(this, glyphspec);
      line_props = new line_properties(this, glyphspec);
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size', 'angle'], [line_props, fill_props]);
      return glyph_props;
    };

    SquareView.prototype._map_data = function() {
      var _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.sw = this.distance(this.data, 'x', 'size', 'center');
      return this.sh = this.sw;
    };

    SquareView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, data_h, data_w, fill_props, glyph_props, glyph_settings, h, line_props, reference_point, w, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_w = this.distance([reference_point], 'x', 'size', 'center')[0];
        data_h = data_w;
      } else {
        glyph_settings = glyph_props;
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      w = Math.abs(x2 - x1);
      h = Math.abs(y2 - y1);
      w = w - 2 * border;
      h = h - 2 * border;
      if (data_w != null) {
        w = data_w > w ? w : data_w;
      }
      if (data_h != null) {
        h = data_h > h ? h : data_h;
      }
      x = (x1 + x2) / 2 - (w / 2);
      y = (y1 + y2) / 2 - (h / 2);
      ctx.rect(x, y, w, h);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return SquareView;

  })(rect.RectView);

  Square = (function(_super) {

    __extends(Square, _super);

    function Square() {
      return Square.__super__.constructor.apply(this, arguments);
    }

    Square.prototype.default_view = SquareView;

    Square.prototype.type = 'GlyphRenderer';

    return Square;

  })(rect.Rect);

  exports.Square = Square;

  exports.SquareView = SquareView;

}).call(this);
}, "renderers/glyph/square_cross": function(exports, require, module) {(function() {
  var Glyph, GlyphView, SquareCross, SquareCrossView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  SquareCrossView = (function(_super) {

    __extends(SquareCrossView, _super);

    function SquareCrossView() {
      return SquareCrossView.__super__.constructor.apply(this, arguments);
    }

    SquareCrossView.prototype.initialize = function(options) {
      var spec;
      SquareCrossView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      return this.do_stroke = this.glyph_props.line_properties.do_stroke;
    };

    SquareCrossView.prototype.init_glyph = function(glyphspec) {
      var fill_props, glyph_props, line_props;
      fill_props = new fill_properties(this, glyphspec);
      line_props = new line_properties(this, glyphspec);
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [line_props, fill_props]);
      return glyph_props;
    };

    SquareCrossView.prototype._set_data = function(data) {
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      return this.y = this.glyph_props.v_select('y', data);
    };

    SquareCrossView.prototype._map_data = function() {
      var _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.sw = this.distance(this.data, 'x', 'size', 'center');
      return this.sh = this.sw;
    };

    SquareCrossView.prototype._render = function() {
      var ctx, idx, props, selected, _i, _len;
      this._map_data();
      ctx = this.plot_view.ctx;
      selected = this.mget_obj('data_source').get('selected');
      for (_i = 0, _len = selected.length; _i < _len; _i++) {
        idx = selected[_i];
        this.selected_mask[idx] = true;
      }
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, 'selected');
          this._full_path(ctx, this.nonselection_glyphprops, 'unselected');
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    SquareCrossView.prototype._fast_path = function(ctx) {
      var i, r, _i, _j, _ref, _ref1;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
            continue;
          }
          ctx.rect(this.sx[i] - this.sw[i] / 2, this.sy[i] - this.sh[i] / 2, this.sw[i], this.sh[i]);
        }
        ctx.fill();
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
            continue;
          }
          ctx.rect(this.sx[i] - this.sw[i] / 2, this.sy[i] - this.sh[i] / 2, this.sw[i], this.sh[i]);
          r = this.sw[i] / 2;
          ctx.moveTo(this.sx[i], this.sy[i] + r);
          ctx.lineTo(this.sx[i], this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i]);
          ctx.lineTo(this.sx[i] + r, this.sy[i]);
        }
        return ctx.stroke();
      }
    };

    SquareCrossView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
          continue;
        }
        if (use_selection === 'selected' && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === 'unselected' && this.selected_mask[i]) {
          continue;
        }
        ctx.translate(this.sx[i], this.sy[i]);
        ctx.beginPath();
        ctx.rect(-this.sw[i] / 2, -this.sh[i] / 2, this.sw[i], this.sh[i]);
        if (this.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          r = this.sw[i] / 2;
          ctx.moveTo(0, +r);
          ctx.lineTo(0, -r);
          ctx.moveTo(-r, 0);
          ctx.lineTo(+r, 0);
          ctx.stroke();
        }
        _results.push(ctx.translate(-this.sx[i], -this.sy[i]));
      }
      return _results;
    };

    SquareCrossView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, data_h, data_w, fill_props, glyph_props, glyph_settings, h, line_props, reference_point, w, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_w = this.distance([reference_point], 'x', 'size', 'center')[0];
        data_h = data_w;
      } else {
        glyph_settings = glyph_props;
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      w = Math.abs(x2 - x1);
      h = Math.abs(y2 - y1);
      w = w - 2 * border;
      h = h - 2 * border;
      if (data_w != null) {
        w = data_w > w ? w : data_w;
      }
      if (data_h != null) {
        h = data_h > h ? h : data_h;
      }
      x = (x1 + x2) / 2 - (w / 2);
      y = (y1 + y2) / 2 - (h / 2);
      ctx.rect(x, y, w, h);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.moveTo(x, y + r);
        ctx.lineTo(x, y - r);
        ctx.moveTo(x - r, y);
        ctx.lineTo(x + r, y);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return SquareCrossView;

  })(GlyphView);

  SquareCross = (function(_super) {

    __extends(SquareCross, _super);

    function SquareCross() {
      return SquareCross.__super__.constructor.apply(this, arguments);
    }

    SquareCross.prototype.default_view = SquareCrossView;

    SquareCross.prototype.type = 'GlyphRenderer';

    return SquareCross;

  })(Glyph);

  exports.SquareCross = SquareCross;

  exports.SquareCrossView = SquareCrossView;

}).call(this);
}, "renderers/glyph/square_x": function(exports, require, module) {(function() {
  var Glyph, GlyphView, SquareX, SquareXView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  SquareXView = (function(_super) {

    __extends(SquareXView, _super);

    function SquareXView() {
      return SquareXView.__super__.constructor.apply(this, arguments);
    }

    SquareXView.prototype.initialize = function(options) {
      var spec;
      SquareXView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      return this.do_stroke = this.glyph_props.line_properties.do_stroke;
    };

    SquareXView.prototype.init_glyph = function(glyphspec) {
      var fill_props, glyph_props, line_props;
      fill_props = new fill_properties(this, glyphspec);
      line_props = new line_properties(this, glyphspec);
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [line_props, fill_props]);
      return glyph_props;
    };

    SquareXView.prototype._set_data = function(data) {
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      return this.y = this.glyph_props.v_select('y', data);
    };

    SquareXView.prototype._map_data = function() {
      var _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.sw = this.distance(this.data, 'x', 'size', 'center');
      return this.sh = this.sw;
    };

    SquareXView.prototype._render = function() {
      var ctx, idx, props, selected, _i, _len;
      this._map_data();
      ctx = this.plot_view.ctx;
      selected = this.mget_obj('data_source').get('selected');
      for (_i = 0, _len = selected.length; _i < _len; _i++) {
        idx = selected[_i];
        this.selected_mask[idx] = true;
      }
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, 'selected');
          this._full_path(ctx, this.nonselection_glyphprops, 'unselected');
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    SquareXView.prototype._fast_path = function(ctx) {
      var i, r, _i, _j, _ref, _ref1;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
            continue;
          }
          ctx.rect(this.sx[i] - this.sw[i] / 2, this.sy[i] - this.sh[i] / 2, this.sw[i], this.sh[i]);
        }
        ctx.fill();
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
            continue;
          }
          ctx.rect(this.sx[i] - this.sw[i] / 2, this.sy[i] - this.sh[i] / 2, this.sw[i], this.sh[i]);
          r = this.sw[i] / 2;
          ctx.moveTo(this.sx[i] - r, this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i] - r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] + r);
        }
        return ctx.stroke();
      }
    };

    SquareXView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.sw[i] + this.sh[i])) {
          continue;
        }
        if (use_selection === 'selected' && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === 'unselected' && this.selected_mask[i]) {
          continue;
        }
        ctx.translate(this.sx[i], this.sy[i]);
        ctx.beginPath();
        ctx.rect(-this.sw[i] / 2, -this.sh[i] / 2, this.sw[i], this.sh[i]);
        if (this.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          r = this.sw[i] / 2;
          ctx.moveTo(-r, +r);
          ctx.lineTo(+r, -r);
          ctx.moveTo(-r, -r);
          ctx.lineTo(+r, +r);
          ctx.stroke();
        }
        _results.push(ctx.translate(-this.sx[i], -this.sy[i]));
      }
      return _results;
    };

    SquareXView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, data_h, data_w, fill_props, glyph_props, glyph_settings, h, line_props, reference_point, w, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_w = this.distance([reference_point], 'x', 'size', 'center')[0];
        data_h = data_w;
      } else {
        glyph_settings = glyph_props;
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      w = Math.abs(x2 - x1);
      h = Math.abs(y2 - y1);
      w = w - 2 * border;
      h = h - 2 * border;
      if (data_w != null) {
        w = data_w > w ? w : data_w;
      }
      if (data_h != null) {
        h = data_h > h ? h : data_h;
      }
      x = (x1 + x2) / 2 - (w / 2);
      y = (y1 + y2) / 2 - (h / 2);
      ctx.rect(x, y, w, h);
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.moveTo(x - r, y + r);
        ctx.lineTo(x + r, y - r);
        ctx.moveTo(x - r, y - r);
        ctx.lineTo(x + r, y + r);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return SquareXView;

  })(GlyphView);

  SquareX = (function(_super) {

    __extends(SquareX, _super);

    function SquareX() {
      return SquareX.__super__.constructor.apply(this, arguments);
    }

    SquareX.prototype.default_view = SquareXView;

    SquareX.prototype.type = 'GlyphRenderer';

    return SquareX;

  })(Glyph);

  exports.SquareX = SquareX;

  exports.SquareXView = SquareXView;

}).call(this);
}, "renderers/glyph/text": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Text, TextView, glyph, glyph_properties, properties, text_properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  text_properties = properties.text_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  TextView = (function(_super) {

    __extends(TextView, _super);

    function TextView() {
      return TextView.__super__.constructor.apply(this, arguments);
    }

    TextView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'angle', 'text:string'], [new text_properties(this, glyphspec)]);
      return TextView.__super__.initialize.call(this, options);
    };

    TextView.prototype._set_data = function(data) {
      var angle, angles, obj;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      angles = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = data.length; _i < _len; _i++) {
          obj = data[_i];
          _results.push(this.glyph_props.select("angle", obj));
        }
        return _results;
      }).call(this);
      this.angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = angles.length; _i < _len; _i++) {
          angle = angles[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      return this.text = this.glyph_props.v_select("text", data);
    };

    TextView.prototype._render = function() {
      var ctx, _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    TextView.prototype._fast_path = function(ctx) {
      var i, _i, _ref, _results;
      this.glyph_props.text_properties.set(ctx, this.glyph_props);
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.angle[i])) {
          continue;
        }
        if (angle[i]) {
          ctx.translate(this.sx[i], this.sy[i]);
          ctx.rotate(this.angle[i]);
          ctx.fillText(this.text[i], 0, 0);
          ctx.rotate(-this.angle[i]);
          _results.push(ctx.translate(-this.sx[i], -this.sy[i]));
        } else {
          _results.push(ctx.fillText(text[i], this.sx[i], this.sy[i]));
        }
      }
      return _results;
    };

    TextView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.angle[i])) {
          continue;
        }
        ctx.translate(this.sx[i], this.sy[i]);
        ctx.rotate(this.angle[i]);
        this.glyph_props.text_properties.set(ctx, this.data[i]);
        ctx.fillText(this.text[i], 0, 0);
        ctx.rotate(-this.angle[i]);
        _results.push(ctx.translate(-this.sx[i], -this.sy[i]));
      }
      return _results;
    };

    TextView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var glyph_props, glyph_settings, reference_point, text_props;
      glyph_props = this.glyph_props;
      text_props = glyph_props.text_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
      } else {
        glyph_settings = glyph_props;
      }
      text_props.set(ctx, glyph_settings);
      ctx.font = text_props.font(12);
      ctx.textAlign = "right";
      ctx.textBaseline = "middle";
      ctx.fillText("txt", x2, (y1 + y2) / 2);
      return ctx.restore();
    };

    return TextView;

  })(GlyphView);

  Text = (function(_super) {

    __extends(Text, _super);

    function Text() {
      return Text.__super__.constructor.apply(this, arguments);
    }

    Text.prototype.default_view = TextView;

    Text.prototype.type = 'GlyphRenderer';

    return Text;

  })(Glyph);

  Text.prototype.display_defaults = _.clone(Text.prototype.display_defaults);

  _.extend(Text.prototype.display_defaults, {
    text_font: "helvetica",
    text_font_size: "12pt",
    text_font_style: "normal",
    text_color: "#444444",
    text_alpha: 1.0,
    text_align: "left",
    text_baseline: "bottom"
  });

  exports.Text = Text;

  exports.TextView = TextView;

}).call(this);
}, "renderers/glyph/triangle": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Triangle, TriangleView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  TriangleView = (function(_super) {

    __extends(TriangleView, _super);

    function TriangleView() {
      return TriangleView.__super__.constructor.apply(this, arguments);
    }

    TriangleView.prototype.initialize = function(options) {
      var spec;
      TriangleView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    TriangleView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    TriangleView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    TriangleView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    TriangleView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var a, h, i, r, _i, _j, _ref, _ref1, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      if (glyph_props.fill_properties.do_fill) {
        glyph_props.fill_properties.set(ctx, this.glyph_props);
        ctx.beginPath();
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          a = this.size[i] * Math.sqrt(3) / 6;
          r = this.size[i] / 2;
          h = this.size[i] * Math.sqrt(3) / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i] - r, this.sy[i] + a);
          ctx.lineTo(this.sx[i] + r, this.sy[i] + a);
          ctx.lineTo(this.sx[i], this.sy[i] + a - h);
          ctx.closePath();
        }
        ctx.fill();
      }
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          a = this.size[i] * Math.sqrt(3) / 6;
          r = this.size[i] / 2;
          h = this.size[i] * Math.sqrt(3) / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i] - r, this.sy[i] + a);
          ctx.lineTo(this.sx[i] + r, this.sy[i] + a);
          ctx.lineTo(this.sx[i], this.sy[i] + a - h);
          ctx.closePath();
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    TriangleView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var a, h, i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        a = this.size[i] * Math.sqrt(3) / 6;
        r = this.size[i] / 2;
        h = this.size[i] * Math.sqrt(3) / 2;
        console.log(a, r, h);
        ctx.beginPath();
        ctx.moveTo(this.sx[i] - r, this.sy[i] + a);
        ctx.lineTo(this.sx[i] + r, this.sy[i] + a);
        ctx.lineTo(this.sx[i], this.sy[i] + a - h);
        ctx.closePath();
        if (glyph_props.fill_properties.do_fill) {
          glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    TriangleView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    TriangleView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var a, border, d, data_r, fill_props, glyph_props, glyph_settings, h, line_props, r, reference_point, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      x = (x1 + x2) / 2.0;
      y = (y1 + y2) / 2.0;
      a = this.size[i] * Math.sqrt(3) / 6;
      r = this.size[i] / 2;
      h = this.size[i] * Math.sqrt(3) / 2;
      ctx.beginPath();
      ctx.moveTo(this.sx[i] - r, this.sy[i] + a);
      ctx.lineTo(this.sx[i] + r, this.sy[i] + a);
      ctx.lineTo(this.sx[i], this.sy[i] + a - h);
      ctx.closePath();
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return TriangleView;

  })(GlyphView);

  Triangle = (function(_super) {

    __extends(Triangle, _super);

    function Triangle() {
      return Triangle.__super__.constructor.apply(this, arguments);
    }

    Triangle.prototype.default_view = TriangleView;

    Triangle.prototype.type = 'GlyphRenderer';

    return Triangle;

  })(Glyph);

  Triangle.prototype.display_defaults = _.clone(Triangle.prototype.display_defaults);

  _.extend(Triangle.prototype.display_defaults, {
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Triangle = Triangle;

  exports.TriangleView = TriangleView;

}).call(this);
}, "renderers/glyph/wedge": function(exports, require, module) {(function() {
  var Glyph, GlyphView, Wedge, WedgeView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  WedgeView = (function(_super) {

    __extends(WedgeView, _super);

    function WedgeView() {
      return WedgeView.__super__.constructor.apply(this, arguments);
    }

    WedgeView.prototype.initialize = function(options) {
      var glyphspec;
      glyphspec = this.mget('glyphspec');
      this.glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'radius', 'start_angle', 'end_angle', 'direction:string'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      this.do_fill = this.glyph_props.fill_properties.do_fill;
      this.do_stroke = this.glyph_props.line_properties.do_stroke;
      return WedgeView.__super__.initialize.call(this, options);
    };

    WedgeView.prototype._set_data = function(data) {
      var angle, dir, end_angle, i, start_angle, _i, _ref, _results;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      start_angle = this.glyph_props.v_select('start_angle', data);
      this.start_angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = start_angle.length; _i < _len; _i++) {
          angle = start_angle[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      end_angle = this.glyph_props.v_select('end_angle', data);
      this.end_angle = (function() {
        var _i, _len, _results;
        _results = [];
        for (_i = 0, _len = end_angle.length; _i < _len; _i++) {
          angle = end_angle[_i];
          _results.push(-angle);
        }
        return _results;
      })();
      this.direction = new Uint8Array(this.data.length);
      _results = [];
      for (i = _i = 0, _ref = this.data.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        dir = this.glyph_props.select('direction', data[i]);
        if (dir === 'clock') {
          _results.push(this.direction[i] = false);
        } else if (dir === 'anticlock') {
          _results.push(this.direction[i] = true);
        } else {
          _results.push(this.direction[i] = NaN);
        }
      }
      return _results;
    };

    WedgeView.prototype._render = function() {
      var ctx, _ref;
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      this.radius = this.distance(this.data, 'x', 'radius', 'edge');
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        this._fast_path(ctx);
      } else {
        this._full_path(ctx);
      }
      return ctx.restore();
    };

    WedgeView.prototype._fast_path = function(ctx) {
      var i, _i, _j, _ref, _ref1, _results;
      if (this.do_fill) {
        this.glyph_props.fill_properties.set(ctx, this.glyph_props);
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.radius[i] + this.start_angle[i] + this.end_angle[i] + this.direction[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.radius[i], this.start_angle[i], this.end_angle[i], this.direction[i]);
          ctx.lineTo(this.sx[i], this.sy[i]);
          ctx.closePath();
          ctx.fill();
        }
      }
      if (this.do_stroke) {
        this.glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _j = 0, _ref1 = this.sx.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (isNaN(this.sx[i] + this.sy[i] + this.radius[i] + this.start_angle[i] + this.end_angle[i] + this.direction[i])) {
            continue;
          }
          ctx.beginPath();
          ctx.arc(this.sx[i], this.sy[i], this.radius[i], this.start_angle[i], this.end_angle[i], this.direction[i]);
          ctx.lineTo(this.sx[i], this.sy[i]);
          ctx.closePath();
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    WedgeView.prototype._full_path = function(ctx) {
      var i, _i, _ref, _results;
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.radius[i] + this.start_angle[i] + this.end_angle[i] + this.direction[i])) {
          continue;
        }
        ctx.beginPath();
        ctx.arc(this.sx[i], this.sy[i], this.radius[i], this.start_angle[i], this.end_angle[i], this.direction[i]);
        ctx.lineTo(this.sx[i], this.sy[i]);
        ctx.closePath();
        if (this.do_fill) {
          this.glyph_props.fill_properties.set(ctx, this.data[i]);
          ctx.fill();
        }
        if (this.do_stroke) {
          this.glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    WedgeView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var angle, border, d, data_r, direction, end_angle, fill_props, glyph_props, glyph_settings, line_props, r, reference_point, start_angle, sx, sy;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'radius', 'edge')[0];
        start_angle = -this.glyph_props.select('start_angle', reference_point);
        end_angle = -this.glyph_props.select('end_angle', reference_point);
      } else {
        glyph_settings = glyph_props;
        start_angle = -0.1;
        end_angle = -3.9;
      }
      angle = end_angle - start_angle;
      direction = this.glyph_props.select('direction', glyph_settings);
      direction = direction === "clock" ? false : true;
      border = line_props.select(line_props.line_width_name, glyph_settings);
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      ctx.beginPath();
      sx = (x1 + x2) / 2.0;
      sy = (y1 + y2) / 2.0;
      ctx.arc(sx, sy, r, start_angle, end_angle, direction);
      ctx.lineTo(sx, sy);
      ctx.closePath();
      if (fill_props.do_fill) {
        fill_props.set(ctx, glyph_settings);
        ctx.fill();
      }
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return WedgeView;

  })(GlyphView);

  Wedge = (function(_super) {

    __extends(Wedge, _super);

    function Wedge() {
      return Wedge.__super__.constructor.apply(this, arguments);
    }

    Wedge.prototype.default_view = WedgeView;

    Wedge.prototype.type = 'GlyphRenderer';

    return Wedge;

  })(Glyph);

  Wedge.prototype.display_defaults = _.clone(Wedge.prototype.display_defaults);

  _.extend(Wedge.prototype.display_defaults, {
    direction: 'anticlock',
    fill_color: 'gray',
    fill_alpha: 1.0,
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.Wedge = Wedge;

  exports.WedgeView = WedgeView;

}).call(this);
}, "renderers/glyph/x": function(exports, require, module) {(function() {
  var Glyph, GlyphView, X, XView, fill_properties, glyph, glyph_properties, line_properties, properties,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  properties = require('../properties');

  glyph_properties = properties.glyph_properties;

  line_properties = properties.line_properties;

  fill_properties = properties.fill_properties;

  glyph = require('./glyph');

  Glyph = glyph.Glyph;

  GlyphView = glyph.GlyphView;

  XView = (function(_super) {

    __extends(XView, _super);

    function XView() {
      return XView.__super__.constructor.apply(this, arguments);
    }

    XView.prototype.initialize = function(options) {
      var spec;
      XView.__super__.initialize.call(this, options);
      this.glyph_props = this.init_glyph(this.mget('glyphspec'));
      if (this.mget('selection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('selection_glyphspec'));
        this.selection_glyphprops = this.init_glyph(spec);
      }
      if (this.mget('nonselection_glyphspec')) {
        spec = _.extend({}, this.mget('glyphspec'), this.mget('nonselection_glyphspec'));
        this.nonselection_glyphprops = this.init_glyph(spec);
      }
      return this.have_new_data = false;
    };

    XView.prototype.init_glyph = function(glyphspec) {
      var glyph_props;
      glyph_props = new glyph_properties(this, glyphspec, ['x', 'y', 'size'], [new fill_properties(this, glyphspec), new line_properties(this, glyphspec)]);
      return glyph_props;
    };

    XView.prototype._set_data = function(data) {
      var i, _i, _ref;
      this.data = data;
      this.x = this.glyph_props.v_select('x', data);
      this.y = this.glyph_props.v_select('y', data);
      this.mask = new Uint8Array(data.length);
      this.selected_mask = new Uint8Array(data.length);
      for (i = _i = 0, _ref = this.mask.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        this.mask[i] = true;
        this.selected_mask[i] = false;
      }
      return this.have_new_data = true;
    };

    XView.prototype._render = function(plot_view, have_new_mapper_state) {
      var ctx, i, idx, oh, ow, props, selected, _i, _j, _len, _ref, _ref1;
      if (have_new_mapper_state == null) {
        have_new_mapper_state = true;
      }
      _ref = this.plot_view.map_to_screen(this.x, this.glyph_props.x.units, this.y, this.glyph_props.y.units), this.sx = _ref[0], this.sy = _ref[1];
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      if (this.have_new_data || have_new_mapper_state) {
        this.size = this.distance(this.data, 'x', 'size', 'edge');
        this.have_new_data = false;
      }
      ow = this.plot_view.view_state.get('outer_width');
      oh = this.plot_view.view_state.get('outer_height');
      for (i = _i = 0, _ref1 = this.mask.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        if ((this.sx[i] + this.size[i]) < 0 || (this.sx[i] - this.size[i]) > ow || (this.sy[i] + this.size[i]) < 0 || (this.sy[i] - this.size[i]) > oh) {
          this.mask[i] = false;
        } else {
          this.mask[i] = true;
        }
      }
      selected = this.mget_obj('data_source').get('selected');
      for (_j = 0, _len = selected.length; _j < _len; _j++) {
        idx = selected[_j];
        this.selected_mask[idx] = true;
      }
      ctx = this.plot_view.ctx;
      ctx.save();
      if (this.glyph_props.fast_path) {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._fast_path(ctx, props, true);
          this._fast_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._fast_path(ctx);
        }
      } else {
        if (selected && selected.length && this.nonselection_glyphprops) {
          if (this.selection_glyphprops) {
            props = this.selection_glyphprops;
          } else {
            props = this.glyph_props;
          }
          this._full_path(ctx, props, true);
          this._full_path(ctx, this.nonselection_glyphprops, false);
        } else {
          this._full_path(ctx);
        }
      }
      return ctx.restore();
    };

    XView.prototype._fast_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (glyph_props.line_properties.do_stroke) {
        glyph_props.line_properties.set(ctx, this.glyph_props);
        _results = [];
        for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
            continue;
          }
          if (use_selection && !this.selected_mask[i]) {
            continue;
          }
          if (use_selection === false && this.selected_mask[i]) {
            continue;
          }
          r = this.size[i] / 2;
          ctx.beginPath();
          ctx.moveTo(this.sx[i] - r, this.sy[i] + r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] - r);
          ctx.moveTo(this.sx[i] - r, this.sy[i] - r);
          ctx.lineTo(this.sx[i] + r, this.sy[i] + r);
          _results.push(ctx.stroke());
        }
        return _results;
      }
    };

    XView.prototype._full_path = function(ctx, glyph_props, use_selection) {
      var i, r, _i, _ref, _results;
      if (!glyph_props) {
        glyph_props = this.glyph_props;
      }
      _results = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (isNaN(this.sx[i] + this.sy[i] + this.size[i]) || !this.mask[i]) {
          continue;
        }
        if (use_selection && !this.selected_mask[i]) {
          continue;
        }
        if (use_selection === false && this.selected_mask[i]) {
          continue;
        }
        r = this.size[i] / 2;
        ctx.beginPath();
        ctx.moveTo(this.sx[i] - r, this.sy[i] + r);
        ctx.lineTo(this.sx[i] + r, this.sy[i] - r);
        ctx.moveTo(this.sx[i] - r, this.sy[i] - r);
        ctx.lineTo(this.sx[i] + r, this.sy[i] + r);
        if (glyph_props.line_properties.do_stroke) {
          glyph_props.line_properties.set(ctx, this.data[i]);
          _results.push(ctx.stroke());
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };

    XView.prototype.select = function(xscreenbounds, yscreenbounds) {
      var i, selected, _i, _ref;
      xscreenbounds = [this.plot_view.view_state.sx_to_device(xscreenbounds[0]), this.plot_view.view_state.sx_to_device(xscreenbounds[1])];
      yscreenbounds = [this.plot_view.view_state.sy_to_device(yscreenbounds[0]), this.plot_view.view_state.sy_to_device(yscreenbounds[1])];
      xscreenbounds = [_.min(xscreenbounds), _.max(xscreenbounds)];
      yscreenbounds = [_.min(yscreenbounds), _.max(yscreenbounds)];
      selected = [];
      for (i = _i = 0, _ref = this.sx.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        if (xscreenbounds) {
          if (this.sx[i] < xscreenbounds[0] || this.sx[i] > xscreenbounds[1]) {
            continue;
          }
        }
        if (yscreenbounds) {
          if (this.sy[i] < yscreenbounds[0] || this.sy[i] > yscreenbounds[1]) {
            continue;
          }
        }
        selected.push(i);
      }
      return selected;
    };

    XView.prototype.draw_legend = function(ctx, x1, x2, y1, y2) {
      var border, d, data_r, fill_props, glyph_props, glyph_settings, line_props, r, reference_point, x, y;
      glyph_props = this.glyph_props;
      line_props = glyph_props.line_properties;
      fill_props = glyph_props.fill_properties;
      ctx.save();
      reference_point = this.get_reference_point();
      if (reference_point != null) {
        glyph_settings = reference_point;
        data_r = this.distance([reference_point], 'x', 'size', 'edge')[0];
      } else {
        glyph_settings = glyph_props;
        data_r = glyph_props.select('size', glyph_props)["default"];
      }
      border = line_props.select(line_props.line_width_name, glyph_settings);
      ctx.beginPath();
      d = _.min([Math.abs(x2 - x1), Math.abs(y2 - y1)]);
      d = d - 2 * border;
      r = d / 2;
      if (data_r != null) {
        r = data_r > r ? r : data_r;
      }
      x = (x1 + x2) / 2.0;
      y = (y1 + y2) / 2.0;
      ctx.moveTo(x - r, y + r);
      ctx.lineTo(x + r, y - r);
      ctx.moveTo(x - r, y - r);
      ctx.lineTo(x + r, y + r);
      if (line_props.do_stroke) {
        line_props.set(ctx, glyph_settings);
        ctx.stroke();
      }
      return ctx.restore();
    };

    return XView;

  })(GlyphView);

  X = (function(_super) {

    __extends(X, _super);

    function X() {
      return X.__super__.constructor.apply(this, arguments);
    }

    X.prototype.default_view = XView;

    X.prototype.type = 'GlyphRenderer';

    return X;

  })(Glyph);

  X.prototype.display_defaults = _.clone(X.prototype.display_defaults);

  _.extend(X.prototype.display_defaults, {
    line_color: 'red',
    line_width: 1,
    line_alpha: 1.0,
    line_join: 'miter',
    line_cap: 'butt',
    line_dash: [],
    line_dash_offset: 0
  });

  exports.X = X;

  exports.XView = XView;

}).call(this);
}, "renderers/glyph_renderer": function(exports, require, module) {(function() {
  var Collections, GlyphRenderers, base, glyphs,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../base');

  Collections = base.Collections;

  glyphs = require('./glyphs');

  GlyphRenderers = (function(_super) {

    __extends(GlyphRenderers, _super);

    function GlyphRenderers() {
      return GlyphRenderers.__super__.constructor.apply(this, arguments);
    }

    GlyphRenderers.prototype.model = function(attrs, options) {
      var model, type, _ref;
      if (!(((_ref = attrs.glyphspec) != null ? _ref.type : void 0) != null)) {
        console.log("missing glyph type");
        return;
      }
      type = attrs.glyphspec.type;
      if (!(type in glyphs)) {
        console.log("unknown glyph type '" + type + "'");
        return;
      }
      model = glyphs[type];
      return new model(attrs, options);
    };

    return GlyphRenderers;

  })(Backbone.Collection);

  exports.glyphrenderers = new GlyphRenderers;

}).call(this);
}, "renderers/glyphs": function(exports, require, module) {(function() {
  var annular_wedge, annulus, arc, asterisk, bezier, circle, circle_cross, circle_x, cross, diamond, diamond_cross, image, image_rgba, image_uri, inverted_triangle, line, multi_line, oval, patch, patches, quad, quadratic, ray, rect, segment, square, square_cross, square_x, text, triangle, wedge, x;

  annular_wedge = require("./glyph/annular_wedge");

  annulus = require("./glyph/annulus");

  arc = require("./glyph/arc");

  asterisk = require("./glyph/asterisk");

  bezier = require("./glyph/bezier");

  circle = require("./glyph/circle");

  circle_x = require("./glyph/circle_x");

  circle_cross = require("./glyph/circle_cross");

  diamond = require("./glyph/diamond");

  diamond_cross = require("./glyph/diamond_cross");

  image = require("./glyph/image");

  image_rgba = require("./glyph/image_rgba");

  image_uri = require("./glyph/image_uri");

  inverted_triangle = require("./glyph/inverted_triangle");

  line = require("./glyph/line");

  multi_line = require("./glyph/multi_line");

  oval = require("./glyph/oval");

  patch = require("./glyph/patch");

  patches = require("./glyph/patches");

  cross = require("./glyph/cross");

  quad = require("./glyph/quad");

  quadratic = require("./glyph/quadratic");

  ray = require("./glyph/ray");

  rect = require("./glyph/rect");

  square = require("./glyph/square");

  square_x = require("./glyph/square_x");

  square_cross = require("./glyph/square_cross");

  segment = require("./glyph/segment");

  text = require("./glyph/text");

  triangle = require("./glyph/triangle");

  wedge = require("./glyph/wedge");

  x = require("./glyph/x");

  exports.annular_wedge = annular_wedge.AnnularWedge;

  exports.annulus = annulus.Annulus;

  exports.arc = arc.Arc;

  exports.asterisk = asterisk.Asterisk;

  exports.bezier = bezier.Bezier;

  exports.circle = circle.Circle;

  exports.circle_x = circle_x.CircleX;

  exports.circle_cross = circle_cross.CircleCross;

  exports.diamond = diamond.Diamond;

  exports.diamond_cross = diamond_cross.DiamondCross;

  exports.image = image.Image;

  exports.image_rgba = image_rgba.ImageRGBA;

  exports.image_uri = image_uri.ImageURI;

  exports.inverted_triangle = inverted_triangle.InvertedTriangle;

  exports.line = line.Line;

  exports.multi_line = multi_line.MultiLine;

  exports.oval = oval.Oval;

  exports.patch = patch.Patch;

  exports.patches = patches.Patches;

  exports.cross = cross.Cross;

  exports.quad = quad.Quad;

  exports.quadratic = quadratic.Quadratic;

  exports.ray = ray.Ray;

  exports.square = square.Square;

  exports.square_x = square_x.SquareX;

  exports.square_cross = square_cross.SquareCross;

  exports.rect = rect.Rect;

  exports.segment = segment.Segment;

  exports.text = text.Text;

  exports.triangle = triangle.Triangle;

  exports.wedge = wedge.Wedge;

  exports.x = x.X;

}).call(this);
}, "renderers/guide/datetime_axis": function(exports, require, module) {(function() {
  var DatetimeAxes, DatetimeAxis, DatetimeAxisView, linear_axis, ticking,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  linear_axis = require('./linear_axis');

  ticking = require('../../common/ticking');

  DatetimeAxisView = (function(_super) {

    __extends(DatetimeAxisView, _super);

    function DatetimeAxisView() {
      return DatetimeAxisView.__super__.constructor.apply(this, arguments);
    }

    DatetimeAxisView.prototype.initialize = function(attrs, options) {
      DatetimeAxisView.__super__.initialize.call(this, attrs, options);
      return this.formatter = new ticking.DatetimeFormatter();
    };

    return DatetimeAxisView;

  })(linear_axis.LinearAxisView);

  DatetimeAxis = (function(_super) {

    __extends(DatetimeAxis, _super);

    function DatetimeAxis() {
      return DatetimeAxis.__super__.constructor.apply(this, arguments);
    }

    DatetimeAxis.prototype.default_view = DatetimeAxisView;

    DatetimeAxis.prototype.type = 'GuideRenderer';

    DatetimeAxis.prototype.initialize = function(attrs, options) {
      return DatetimeAxis.__super__.initialize.call(this, attrs, options);
    };

    return DatetimeAxis;

  })(linear_axis.LinearAxis);

  DatetimeAxes = (function(_super) {

    __extends(DatetimeAxes, _super);

    function DatetimeAxes() {
      return DatetimeAxes.__super__.constructor.apply(this, arguments);
    }

    DatetimeAxes.prototype.model = DatetimeAxis;

    return DatetimeAxes;

  })(Backbone.Collection);

  exports.datetimeaxes = new DatetimeAxes();

  exports.DatetimeAxis = DatetimeAxis;

  exports.DatetimeAxisView = DatetimeAxisView;

}).call(this);
}, "renderers/guide/grid": function(exports, require, module) {(function() {
  var Grid, GridView, Grids, HasParent, PlotWidget, base, line_properties, properties, safebind, ticking,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../../base');

  HasParent = base.HasParent;

  safebind = base.safebind;

  properties = require('../properties');

  line_properties = properties.line_properties;

  PlotWidget = require('../../common/plot_widget').PlotWidget;

  ticking = require('../../common/ticking');

  GridView = (function(_super) {

    __extends(GridView, _super);

    function GridView() {
      return GridView.__super__.constructor.apply(this, arguments);
    }

    GridView.prototype.initialize = function(attrs, options) {
      GridView.__super__.initialize.call(this, attrs, options);
      return this.grid_props = new line_properties(this, null, 'grid_');
    };

    GridView.prototype.render = function() {
      var ctx;
      ctx = this.plot_view.ctx;
      ctx.save();
      this._draw_grids(ctx);
      return ctx.restore();
    };

    GridView.prototype.bind_bokeh_events = function() {
      return safebind(this, this.model, 'change', this.request_render);
    };

    GridView.prototype._draw_grids = function(ctx) {
      var i, sx, sy, xs, ys, _i, _j, _ref, _ref1, _ref2, _ref3;
      if (!this.grid_props.do_stroke) {
        return;
      }
      _ref = this.mget('grid_coords'), xs = _ref[0], ys = _ref[1];
      this.grid_props.set(ctx, this);
      for (i = _i = 0, _ref1 = xs.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; i = 0 <= _ref1 ? ++_i : --_i) {
        _ref2 = this.plot_view.map_to_screen(xs[i], "data", ys[i], "data"), sx = _ref2[0], sy = _ref2[1];
        ctx.beginPath();
        ctx.moveTo(Math.round(sx[0]), Math.round(sy[0]));
        for (i = _j = 1, _ref3 = sx.length - 1; 1 <= _ref3 ? _j <= _ref3 : _j >= _ref3; i = 1 <= _ref3 ? ++_j : --_j) {
          ctx.lineTo(Math.round(sx[i]), Math.round(sy[i]));
        }
        ctx.stroke();
      }
    };

    return GridView;

  })(PlotWidget);

  Grid = (function(_super) {

    __extends(Grid, _super);

    function Grid() {
      return Grid.__super__.constructor.apply(this, arguments);
    }

    Grid.prototype.default_view = GridView;

    Grid.prototype.type = 'GuideRenderer';

    Grid.prototype.initialize = function(attrs, options) {
      Grid.__super__.initialize.call(this, attrs, options);
      this.register_property('computed_bounds', this._bounds, false);
      this.add_dependencies('computed_bounds', this, ['bounds']);
      this.register_property('grid_coords', this._grid_coords, false);
      return this.add_dependencies('grid_coords', this, ['computed_bounds', 'dimension']);
    };

    Grid.prototype._bounds = function() {
      var end, i, j, range_bounds, ranges, start, user_bounds, _ref;
      i = this.get('dimension');
      j = (i + 1) % 2;
      ranges = [this.get_obj('plot').get_obj('x_range'), this.get_obj('plot').get_obj('y_range')];
      user_bounds = (_ref = this.get('bounds')) != null ? _ref : 'auto';
      range_bounds = [ranges[i].get('min'), ranges[i].get('max')];
      if (_.isArray(user_bounds)) {
        start = Math.min(user_bounds[0], user_bounds[1]);
        end = Math.max(user_bounds[0], user_bounds[1]);
        if (start < range_bounds[0]) {
          start = range_bounds[0];
        } else if (start > range_bounds[1]) {
          start = null;
        }
        if (end > range_bounds[1]) {
          end = range_bounds[1];
        } else if (end < range_bounds[0]) {
          end = null;
        }
      } else {
        start = range_bounds[0], end = range_bounds[1];
      }
      return [start, end];
    };

    Grid.prototype._grid_coords = function() {
      var N, cmax, cmin, coords, cross_range, dim_i, dim_j, end, i, ii, interval, j, loc, max, min, n, range, ranges, start, ticks, tmp, _i, _j, _ref, _ref1, _ref2;
      i = this.get('dimension');
      j = (i + 1) % 2;
      ranges = [this.get_obj('plot').get_obj('x_range'), this.get_obj('plot').get_obj('y_range')];
      range = ranges[i];
      cross_range = ranges[j];
      _ref = this.get('computed_bounds'), start = _ref[0], end = _ref[1];
      tmp = Math.min(start, end);
      end = Math.max(start, end);
      start = tmp;
      interval = ticking.auto_interval(start, end);
      ticks = ticking.auto_ticks(null, null, start, end, interval);
      min = range.get('min');
      max = range.get('max');
      cmin = cross_range.get('min');
      cmax = cross_range.get('max');
      coords = [[], []];
      for (ii = _i = 0, _ref1 = ticks.length - 1; 0 <= _ref1 ? _i <= _ref1 : _i >= _ref1; ii = 0 <= _ref1 ? ++_i : --_i) {
        if (ticks[ii] === min || ticks[ii] === max) {
          continue;
        }
        dim_i = [];
        dim_j = [];
        N = 2;
        for (n = _j = 0, _ref2 = N - 1; 0 <= _ref2 ? _j <= _ref2 : _j >= _ref2; n = 0 <= _ref2 ? ++_j : --_j) {
          loc = cmin + (cmax - cmin) / (N - 1) * n;
          dim_i.push(ticks[ii]);
          dim_j.push(loc);
        }
        coords[i].push(dim_i);
        coords[j].push(dim_j);
      }
      return coords;
    };

    return Grid;

  })(HasParent);

  Grid.prototype.defaults = _.clone(Grid.prototype.defaults);

  Grid.prototype.display_defaults = _.clone(Grid.prototype.display_defaults);

  _.extend(Grid.prototype.display_defaults, {
    level: 'underlay',
    grid_line_color: '#aaaaaa',
    grid_line_width: 1,
    grid_line_alpha: 1.0,
    grid_line_join: 'miter',
    grid_line_cap: 'butt',
    grid_line_dash: [4, 6],
    grid_line_dash_offset: 0
  });

  Grids = (function(_super) {

    __extends(Grids, _super);

    function Grids() {
      return Grids.__super__.constructor.apply(this, arguments);
    }

    Grids.prototype.model = Grid;

    return Grids;

  })(Backbone.Collection);

  exports.grids = new Grids();

  exports.Grid = Grid;

  exports.GridView = GridView;

}).call(this);
}, "renderers/guide/linear_axis": function(exports, require, module) {(function() {
  var HasParent, LinearAxes, LinearAxis, LinearAxisView, PlotWidget, base, line_properties, properties, safebind, signum, text_properties, ticking, _align_lookup, _angle_lookup, _baseline_lookup,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../../base');

  HasParent = base.HasParent;

  safebind = base.safebind;

  properties = require('../properties');

  line_properties = properties.line_properties;

  text_properties = properties.text_properties;

  PlotWidget = require('../../common/plot_widget').PlotWidget;

  ticking = require('../../common/ticking');

  signum = function(x) {
    var _ref;
    return (_ref = x != null ? x : x < 0) != null ? _ref : -{
      1: {
        1: 0
      }
    };
  };

  _angle_lookup = {
    top: {
      parallel: 0,
      normal: -Math.PI / 2,
      horizontal: 0,
      vertical: -Math.PI / 2
    },
    bottom: {
      parallel: 0,
      normal: Math.PI / 2,
      horizontal: 0,
      vertical: Math.PI / 2
    },
    left: {
      parallel: -Math.PI / 2,
      normal: 0,
      horizontal: 0,
      vertical: -Math.PI / 2
    },
    right: {
      parallel: Math.PI / 2,
      normal: 0,
      horizontal: 0,
      vertical: Math.PI / 2
    }
  };

  _baseline_lookup = {
    top: {
      parallel: 'alphabetic',
      normal: 'middle',
      horizontal: 'alphabetic',
      vertical: 'middle'
    },
    bottom: {
      parallel: 'hanging',
      normal: 'middle',
      horizontal: 'hanging',
      vertical: 'middle'
    },
    left: {
      parallel: 'alphabetic',
      normal: 'middle',
      horizontal: 'middle',
      vertical: 'alphabetic'
    },
    right: {
      parallel: 'alphabetic',
      normal: 'middle',
      horizontal: 'middle',
      vertical: 'alphabetic'
    }
  };

  _align_lookup = {
    top: {
      parallel: 'center',
      normal: 'left',
      horizontal: 'center',
      vertical: 'left'
    },
    bottom: {
      parallel: 'center',
      normal: 'left',
      horizontal: 'center',
      vertical: 'right'
    },
    left: {
      parallel: 'center',
      normal: 'right',
      horizontal: 'right',
      vertical: 'center'
    },
    right: {
      parallel: 'center',
      normal: 'left',
      horizontal: 'left',
      vertical: 'center'
    }
  };

  LinearAxisView = (function(_super) {

    __extends(LinearAxisView, _super);

    function LinearAxisView() {
      return LinearAxisView.__super__.constructor.apply(this, arguments);
    }

    LinearAxisView.prototype.initialize = function(attrs, options) {
      LinearAxisView.__super__.initialize.call(this, attrs, options);
      this.rule_props = new line_properties(this, null, 'axis_');
      this.major_tick_props = new line_properties(this, null, 'major_tick_');
      this.major_label_props = new text_properties(this, null, 'major_label_');
      this.axis_label_props = new text_properties(this, null, 'axis_label_');
      return this.formatter = new ticking.BasicTickFormatter();
    };

    LinearAxisView.prototype.render = function() {
      var ctx;
      ctx = this.plot_view.ctx;
      ctx.save();
      this._draw_rule(ctx);
      this._draw_major_ticks(ctx);
      this._draw_major_labels(ctx);
      this._draw_axis_label(ctx);
      return ctx.restore();
    };

    LinearAxisView.prototype.bind_bokeh_events = function() {
      return safebind(this, this.model, 'change', this.request_render);
    };

    LinearAxisView.prototype.padding_request = function() {
      return this._padding_request();
    };

    LinearAxisView.prototype._draw_rule = function(ctx) {
      var coords, i, sx, sy, x, y, _i, _ref, _ref1, _ref2;
      _ref = coords = this.mget('rule_coords'), x = _ref[0], y = _ref[1];
      _ref1 = this.plot_view.map_to_screen(x, "data", y, "data"), sx = _ref1[0], sy = _ref1[1];
      this.rule_props.set(ctx, this);
      ctx.beginPath();
      ctx.moveTo(Math.round(sx[0]), Math.round(sy[0]));
      for (i = _i = 1, _ref2 = sx.length - 1; 1 <= _ref2 ? _i <= _ref2 : _i >= _ref2; i = 1 <= _ref2 ? ++_i : --_i) {
        ctx.lineTo(Math.round(sx[i]), Math.round(sy[i]));
      }
      ctx.stroke();
    };

    LinearAxisView.prototype._draw_major_ticks = function(ctx) {
      var coords, i, nx, ny, sx, sy, tin, tout, x, y, _i, _ref, _ref1, _ref2, _ref3;
      _ref = coords = this.mget('major_coords'), x = _ref[0], y = _ref[1];
      _ref1 = this.plot_view.map_to_screen(x, "data", y, "data"), sx = _ref1[0], sy = _ref1[1];
      _ref2 = this.mget('normals'), nx = _ref2[0], ny = _ref2[1];
      tin = this.mget('major_tick_in');
      tout = this.mget('major_tick_out');
      this.major_tick_props.set(ctx, this);
      for (i = _i = 0, _ref3 = sx.length - 1; 0 <= _ref3 ? _i <= _ref3 : _i >= _ref3; i = 0 <= _ref3 ? ++_i : --_i) {
        ctx.beginPath();
        ctx.moveTo(Math.round(sx[i] + nx * tout), Math.round(sy[i] + ny * tout));
        ctx.lineTo(Math.round(sx[i] - nx * tin), Math.round(sy[i] - ny * tin));
        ctx.stroke();
      }
    };

    LinearAxisView.prototype._draw_major_labels = function(ctx) {
      var angle, coords, dim, i, labels, nx, ny, orient, side, standoff, sx, sy, x, y, _i, _ref, _ref1, _ref2, _ref3;
      _ref = coords = this.mget('major_coords'), x = _ref[0], y = _ref[1];
      _ref1 = this.plot_view.map_to_screen(x, "data", y, "data"), sx = _ref1[0], sy = _ref1[1];
      _ref2 = this.mget('normals'), nx = _ref2[0], ny = _ref2[1];
      dim = this.mget('dimension');
      side = this.mget('side');
      orient = this.mget('major_label_orientation');
      if (_.isString(orient)) {
        angle = _angle_lookup[side][orient];
      } else {
        angle = -orient;
      }
      standoff = this._tick_extent() + this.mget('major_label_standoff');
      labels = this.formatter.format(coords[dim]);
      this.major_label_props.set(ctx, this);
      this._apply_location_heuristics(ctx, side, orient);
      for (i = _i = 0, _ref3 = sx.length - 1; 0 <= _ref3 ? _i <= _ref3 : _i >= _ref3; i = 0 <= _ref3 ? ++_i : --_i) {
        if (angle) {
          ctx.translate(sx[i] + nx * standoff, sy[i] + ny * standoff);
          ctx.rotate(angle);
          ctx.fillText(labels[i], 0, 0);
          ctx.rotate(-angle);
          ctx.translate(-sx[i] - nx * standoff, -sy[i] - ny * standoff);
        } else {
          ctx.fillText(labels[i], Math.round(sx[i] + nx * standoff), Math.round(sy[i] + ny * standoff));
        }
      }
    };

    LinearAxisView.prototype._draw_axis_label = function(ctx) {
      var angle, label, nx, ny, orient, side, standoff, sx, sy, x, y, _ref, _ref1, _ref2;
      label = this.mget('axis_label');
      if (!(label != null)) {
        return;
      }
      _ref = this.mget('rule_coords'), x = _ref[0], y = _ref[1];
      _ref1 = this.plot_view.map_to_screen(x, "data", y, "data"), sx = _ref1[0], sy = _ref1[1];
      _ref2 = this.mget('normals'), nx = _ref2[0], ny = _ref2[1];
      side = this.mget('side');
      orient = 'parallel';
      angle = _angle_lookup[side][orient];
      standoff = this._tick_extent() + this._tick_label_extent() + this.mget('axis_label_standoff');
      sx = (sx[0] + sx[sx.length - 1]) / 2;
      sy = (sy[0] + sy[sy.length - 1]) / 2;
      this.axis_label_props.set(ctx, this);
      this._apply_location_heuristics(ctx, side, orient);
      if (angle) {
        ctx.translate(sx + nx * standoff, sy + ny * standoff);
        ctx.rotate(angle);
        ctx.fillText(label, 0, 0);
        ctx.rotate(-angle);
        ctx.translate(-sx - nx * standoff, -sy - ny * standoff);
      } else {
        ctx.fillText(label, sx + nx * standoff, sy + ny * standoff);
      }
    };

    LinearAxisView.prototype._apply_location_heuristics = function(ctx, side, orient) {
      var align, baseline;
      if (_.isString(orient)) {
        baseline = _baseline_lookup[side][orient];
        align = _align_lookup[side][orient];
      } else if (orient === 0) {
        baseline = _baseline_lookup[side][orient];
        align = _align_lookup[side][orient];
      } else if (orient < 0) {
        baseline = 'middle';
        if (side === 'top') {
          align = 'right';
        } else if (side === 'bottom') {
          align = 'left';
        } else if (side === 'left') {
          align = 'right';
        } else if (side === 'right') {
          align = 'left';
        }
      } else if (orient > 0) {
        baseline = 'middle';
        if (side === 'top') {
          align = 'left';
        } else if (side === 'bottom') {
          align = 'right';
        } else if (side === 'left') {
          align = 'right';
        } else if (side === 'right') {
          align = 'left';
        }
      }
      ctx.textBaseline = baseline;
      return ctx.textAlign = align;
    };

    LinearAxisView.prototype._tick_extent = function() {
      return this.mget('major_tick_out');
    };

    LinearAxisView.prototype._tick_label_extent = function() {
      var angle, c, coords, dim, extent, factor, h, i, labels, orient, s, side, val, w, _i, _j, _ref, _ref1;
      extent = 0;
      dim = this.mget('dimension');
      coords = this.mget('major_coords');
      side = this.mget('side');
      orient = this.mget('major_label_orientation');
      labels = this.formatter.format(coords[dim]);
      this.major_label_props.set(this.plot_view.ctx, this);
      if (_.isString(orient)) {
        factor = 1;
        angle = _angle_lookup[side][orient];
      } else {
        factor = 2;
        angle = -orient;
      }
      angle = Math.abs(angle);
      c = Math.cos(angle);
      s = Math.sin(angle);
      if (side === "top" || side === "bottom") {
        for (i = _i = 0, _ref = labels.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
          if (!(labels[i] != null)) {
            continue;
          }
          w = this.plot_view.ctx.measureText(labels[i]).width * 1.1;
          h = this.plot_view.ctx.measureText(labels[i]).ascent * 0.9;
          val = w * s + (h / factor) * c;
          if (val > extent) {
            extent = val;
          }
        }
      } else {
        for (i = _j = 0, _ref1 = labels.length - 1; 0 <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = 0 <= _ref1 ? ++_j : --_j) {
          if (!(labels[i] != null)) {
            continue;
          }
          w = this.plot_view.ctx.measureText(labels[i]).width * 1.1;
          h = this.plot_view.ctx.measureText(labels[i]).ascent * 0.9;
          val = w * c + (h / factor) * s;
          if (val > extent) {
            extent = val;
          }
        }
      }
      if (extent > 0) {
        extent += this.mget('major_label_standoff');
      }
      return extent;
    };

    LinearAxisView.prototype._axis_label_extent = function() {
      var angle, c, extent, h, orient, s, side, w;
      extent = 0;
      side = this.mget('side');
      orient = 'parallel';
      this.major_label_props.set(this.plot_view.ctx, this);
      angle = Math.abs(_angle_lookup[side][orient]);
      c = Math.cos(angle);
      s = Math.sin(angle);
      if (this.mget('axis_label')) {
        extent += this.mget('axis_label_standoff');
        this.axis_label_props.set(this.plot_view.ctx, this);
        w = this.plot_view.ctx.measureText(this.mget('axis_label')).width * 1.1;
        h = this.plot_view.ctx.measureText(this.mget('axis_label')).ascent * 0.9;
        if (side === "top" || side === "bottom") {
          extent += w * s + h * c;
        } else {
          extent += w * c + h * s;
        }
      }
      return extent;
    };

    LinearAxisView.prototype._padding_request = function() {
      var loc, padding, req, side, _ref;
      req = {};
      side = this.mget('side');
      loc = (_ref = this.mget('location')) != null ? _ref : 'min';
      if (!_.isString(loc)) {
        return req;
      }
      padding = 0;
      padding += this._tick_extent();
      padding += this._tick_label_extent();
      padding += this._axis_label_extent();
      req[side] = padding;
      return req;
    };

    return LinearAxisView;

  })(PlotWidget);

  LinearAxis = (function(_super) {

    __extends(LinearAxis, _super);

    function LinearAxis() {
      return LinearAxis.__super__.constructor.apply(this, arguments);
    }

    LinearAxis.prototype.default_view = LinearAxisView;

    LinearAxis.prototype.type = 'GuideRenderer';

    LinearAxis.prototype.initialize = function(attrs, options) {
      LinearAxis.__super__.initialize.call(this, attrs, options);
      this.register_property('computed_bounds', this._bounds, false);
      this.add_dependencies('computed_bounds', this, ['bounds']);
      this.register_property('rule_coords', this._rule_coords, false);
      this.add_dependencies('rule_coords', this, ['computed_bounds', 'dimension', 'location']);
      this.register_property('major_coords', this._major_coords, false);
      this.add_dependencies('major_coords', this, ['computed_bounds', 'dimension', 'location']);
      this.register_property('normals', this._normals, false);
      this.add_dependencies('normals', this, ['computed_bounds', 'dimension', 'location']);
      this.register_property('side', this._side, false);
      this.add_dependencies('side', this, ['normals']);
      return this.register_property('padding_request', this._padding_request, false);
    };

    LinearAxis.prototype.dinitialize = function(attrs, options) {
      return this.add_dependencies('computed_bounds', this.get_obj('plot'), ['x_range', 'y_range']);
    };

    LinearAxis.prototype._bounds = function() {
      var end, i, j, range_bounds, ranges, start, user_bounds, _ref;
      i = this.get('dimension');
      j = (i + 1) % 2;
      ranges = [this.get_obj('plot').get_obj('x_range'), this.get_obj('plot').get_obj('y_range')];
      user_bounds = (_ref = this.get('bounds')) != null ? _ref : 'auto';
      range_bounds = [ranges[i].get('min'), ranges[i].get('max')];
      if (_.isArray(user_bounds)) {
        if (Math.abs(user_bounds[0] - user_bounds[1]) > Math.abs(range_bounds[0] - range_bounds[1])) {
          start = Math.max(Math.min(user_bounds[0], user_bounds[1]), range_bounds[0]);
          end = Math.min(Math.max(user_bounds[0], user_bounds[1]), range_bounds[1]);
        } else {
          start = Math.min(user_bounds[0], user_bounds[1]);
          end = Math.max(user_bounds[0], user_bounds[1]);
        }
      } else {
        start = range_bounds[0], end = range_bounds[1];
      }
      return [start, end];
    };

    LinearAxis.prototype._rule_coords = function() {
      var coords, cross_range, end, i, j, loc, range, range_max, range_min, ranges, start, xs, ys, _ref, _ref1, _ref2;
      i = this.get('dimension');
      j = (i + 1) % 2;
      ranges = [this.get_obj('plot').get_obj('x_range'), this.get_obj('plot').get_obj('y_range')];
      range = ranges[i];
      cross_range = ranges[j];
      _ref = this.get('computed_bounds'), start = _ref[0], end = _ref[1];
      xs = new Float64Array(2);
      ys = new Float64Array(2);
      coords = [xs, ys];
      loc = (_ref1 = this.get('location')) != null ? _ref1 : 'min';
      if (_.isString(loc)) {
        if (loc === 'left' || loc === 'bottom') {
          loc = 'start';
        } else if (loc === 'right' || loc === 'top') {
          loc = 'end';
        }
        loc = cross_range.get(loc);
      }
      _ref2 = [range.get('min'), range.get('max')], range_min = _ref2[0], range_max = _ref2[1];
      coords[i][0] = Math.max(start, range_min);
      coords[i][1] = Math.min(end, range_max);
      coords[j][0] = loc;
      coords[j][1] = loc;
      if (coords[i][0] > coords[i][1]) {
        coords[i][0] = coords[i][1] = NaN;
      }
      return coords;
    };

    LinearAxis.prototype._major_coords = function() {
      var coords, cross_range, end, i, ii, interval, j, loc, range, range_max, range_min, ranges, start, ticks, xs, ys, _i, _ref, _ref1, _ref2, _ref3;
      i = this.get('dimension');
      j = (i + 1) % 2;
      ranges = [this.get_obj('plot').get_obj('x_range'), this.get_obj('plot').get_obj('y_range')];
      range = ranges[i];
      cross_range = ranges[j];
      _ref = this.get('computed_bounds'), start = _ref[0], end = _ref[1];
      interval = ticking.auto_interval(start, end);
      ticks = ticking.auto_ticks(null, null, start, end, interval);
      loc = (_ref1 = this.get('location')) != null ? _ref1 : 'min';
      if (_.isString(loc)) {
        if (loc === 'left' || loc === 'bottom') {
          loc = 'start';
        } else if (loc === 'right' || loc === 'top') {
          loc = 'end';
        }
        loc = cross_range.get(loc);
      }
      xs = [];
      ys = [];
      coords = [xs, ys];
      _ref2 = [range.get('min'), range.get('max')], range_min = _ref2[0], range_max = _ref2[1];
      for (ii = _i = 0, _ref3 = ticks.length - 1; 0 <= _ref3 ? _i <= _ref3 : _i >= _ref3; ii = 0 <= _ref3 ? ++_i : --_i) {
        if (ticks[ii] < range_min || ticks[ii] > range_max) {
          continue;
        }
        coords[i].push(ticks[ii]);
        coords[j].push(loc);
      }
      return coords;
    };

    LinearAxis.prototype._normals = function() {
      var cend, cross_range, cstart, end, i, j, loc, normals, range, ranges, start, _ref, _ref1;
      i = this.get('dimension');
      j = (i + 1) % 2;
      ranges = [this.get_obj('plot').get_obj('x_range'), this.get_obj('plot').get_obj('y_range')];
      range = ranges[i];
      cross_range = ranges[j];
      _ref = this.get('computed_bounds'), start = _ref[0], end = _ref[1];
      loc = (_ref1 = this.get('location')) != null ? _ref1 : 'min';
      cstart = cross_range.get('start');
      cend = cross_range.get('end');
      normals = [0, 0];
      if (_.isString(loc)) {
        normals[j] = (end - start) < 0 ? -1 : 1;
        if (i === 0) {
          if ((loc === 'max' && (cstart < cend)) || (loc === 'min' && (cstart > cend)) || loc === 'right' || loc === 'top') {
            normals[j] *= -1;
          }
        } else if (i === 1) {
          if ((loc === 'min' && (cstart < cend)) || (loc === 'max' && (cstart > cend)) || loc === 'left' || loc === 'bottom') {
            normals[j] *= -1;
          }
        }
      } else {
        if (i === 0) {
          if (Math.abs(loc - cstart) <= Math.abs(loc - cend)) {
            normals[j] = 1;
          } else {
            normals[j] = -1;
          }
        } else {
          if (Math.abs(loc - cstart) <= Math.abs(loc - cend)) {
            normals[j] = -1;
          } else {
            normals[j] = 1;
          }
        }
      }
      return normals;
    };

    LinearAxis.prototype._side = function() {
      var n, side;
      n = this.get('normals');
      if (n[1] === -1) {
        side = 'top';
      } else if (n[1] === 1) {
        side = 'bottom';
      } else if (n[0] === -1) {
        side = 'left';
      } else if (n[0] === 1) {
        side = 'right';
      }
      return side;
    };

    return LinearAxis;

  })(HasParent);

  LinearAxis.prototype.defaults = _.clone(LinearAxis.prototype.defaults);

  LinearAxis.prototype.display_defaults = _.clone(LinearAxis.prototype.display_defaults);

  _.extend(LinearAxis.prototype.display_defaults, {
    level: 'overlay',
    axis_line_color: 'black',
    axis_line_width: 1,
    axis_line_alpha: 1.0,
    axis_line_join: 'miter',
    axis_line_cap: 'butt',
    axis_line_dash: [],
    axis_line_dash_offset: 0,
    major_tick_in: 2,
    major_tick_out: 6,
    major_tick_line_color: 'black',
    major_tick_line_width: 1,
    major_tick_line_alpha: 1.0,
    major_tick_line_join: 'miter',
    major_tick_line_cap: 'butt',
    major_tick_line_dash: [],
    major_tick_line_dash_offset: 0,
    major_label_standoff: 5,
    major_label_orientation: "horizontal",
    major_label_text_font: "helvetica",
    major_label_text_font_size: "10pt",
    major_label_text_font_style: "normal",
    major_label_text_color: "#444444",
    major_label_text_alpha: 1.0,
    major_label_text_align: "center",
    major_label_text_baseline: "alphabetic",
    axis_label: "",
    axis_label_standoff: 5,
    axis_label_text_font: "helvetica",
    axis_label_text_font_size: "16pt",
    axis_label_text_font_style: "normal",
    axis_label_text_color: "#444444",
    axis_label_text_alpha: 1.0,
    axis_label_text_align: "center",
    axis_label_text_baseline: "alphabetic",
    rounding_value: 20
  });

  LinearAxes = (function(_super) {

    __extends(LinearAxes, _super);

    function LinearAxes() {
      return LinearAxes.__super__.constructor.apply(this, arguments);
    }

    LinearAxes.prototype.model = LinearAxis;

    return LinearAxes;

  })(Backbone.Collection);

  exports.linearaxes = new LinearAxes();

  exports.LinearAxis = LinearAxis;

  exports.LinearAxisView = LinearAxisView;

}).call(this);
}, "renderers/guide_renderer": function(exports, require, module) {(function() {
  var Collections, GuideRenderers, base, guides,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  base = require('../base');

  Collections = base.Collections;

  guides = require('./guides');

  GuideRenderers = (function(_super) {

    __extends(GuideRenderers, _super);

    function GuideRenderers() {
      return GuideRenderers.__super__.constructor.apply(this, arguments);
    }

    GuideRenderers.prototype.model = function(attrs, options) {
      var model, type;
      if (!(attrs.type != null)) {
        console.log("missing guide type");
        return;
      }
      type = attrs.type;
      if (!(type in guides)) {
        console.log("unknown guide type '" + type + "'");
        return;
      }
      model = guides[type];
      return new model(attrs, options);
    };

    return GuideRenderers;

  })(Backbone.Collection);

  exports.guiderenderers = new GuideRenderers;

}).call(this);
}, "renderers/guides": function(exports, require, module) {(function() {
  var datetime_axis, grid, linear_axis;

  linear_axis = require("./guide/linear_axis");

  datetime_axis = require("./guide/datetime_axis");

  grid = require("./guide/grid");

  exports.linear_axis = linear_axis.LinearAxis;

  exports.datetime_axis = datetime_axis.DatetimeAxis;

  exports.grid = grid.Grid;

}).call(this);
}, "renderers/properties": function(exports, require, module) {(function() {
  var fill_properties, glyph_properties, line_properties, properties, svg_colors, text_properties,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; },
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  svg_colors = require('../common/svg_colors').svg_colors;

  properties = (function() {

    function properties() {}

    properties.prototype.string = function(styleprovider, glyphspec, attrname) {
      var default_value, glyph_value;
      this[attrname] = {};
      default_value = styleprovider.mget(attrname);
      if (!(default_value != null)) {

      } else if (_.isString(default_value)) {
        this[attrname]["default"] = default_value;
      } else {
        console.log(("string property '" + attrname + "' given invalid default value: ") + default_value);
      }
      if (!(glyphspec != null) || !(attrname in glyphspec)) {
        return;
      }
      glyph_value = glyphspec[attrname];
      if (_.isString(glyph_value)) {
        return this[attrname].value = glyph_value;
      } else if (_.isObject(glyph_value)) {
        return this[attrname] = _.extend(this[attrname], glyph_value);
      } else {
        return console.log(("string property '" + attrname + "' given invalid glyph value: ") + glyph_value);
      }
    };

    properties.prototype.number = function(styleprovider, glyphspec, attrname) {
      var default_value, glyph_value, units_value, _ref;
      this[attrname] = {
        typed: true
      };
      default_value = styleprovider.mget(attrname);
      if (!(default_value != null)) {

      } else if (_.isNumber(default_value)) {
        this[attrname]["default"] = default_value;
      } else {
        console.log(("number property '" + attrname + "' given invalid default value: ") + default_value);
      }
      units_value = (_ref = styleprovider.mget(attrname + '_units')) != null ? _ref : 'data';
      if ((glyphspec != null) && (attrname + '_units' in glyphspec)) {
        units_value = glyphspec[attrname + '_units'];
      }
      this[attrname].units = units_value;
      if (!(glyphspec != null) || !(attrname in glyphspec)) {
        return;
      }
      glyph_value = glyphspec[attrname];
      if (_.isString(glyph_value)) {
        return this[attrname].field = glyph_value;
      } else if (_.isNumber(glyph_value)) {
        return this[attrname].value = glyph_value;
      } else if (_.isObject(glyph_value)) {
        return this[attrname] = _.extend(this[attrname], glyph_value);
      } else {
        return console.log(("number property '" + attrname + "' given invalid glyph value: ") + glyph_value);
      }
    };

    properties.prototype.color = function(styleprovider, glyphspec, attrname) {
      var default_value, glyph_value;
      this[attrname] = {};
      default_value = styleprovider.mget(attrname);
      if (_.isUndefined(default_value)) {
        this[attrname]["default"] = null;
      } else if (_.isString(default_value) && ((svg_colors[default_value] != null) || default_value.substring(0, 1) === "#") || _.isNull(default_value)) {
        this[attrname]["default"] = default_value;
      } else {
        console.log(("color property '" + attrname + "' given invalid default value: ") + default_value);
      }
      if (!(glyphspec != null) || !(attrname in glyphspec)) {
        return;
      }
      glyph_value = glyphspec[attrname];
      if (_.isNull(glyph_value)) {
        return this[attrname].value = null;
      } else if (_.isString(glyph_value)) {
        if ((svg_colors[glyph_value] != null) || glyph_value.substring(0, 1) === "#") {
          return this[attrname].value = glyph_value;
        } else {
          return this[attrname].field = glyph_value;
        }
      } else if (_.isObject(glyph_value)) {
        return this[attrname] = _.extend(this[attrname], glyph_value);
      } else {
        return console.log(("color property '" + attrname + "' given invalid glyph value: ") + glyph_value);
      }
    };

    properties.prototype.array = function(styleprovider, glyphspec, attrname) {
      var default_value, glyph_value, units_value, _ref;
      this[attrname] = {};
      default_value = styleprovider.mget(attrname);
      if (!(default_value != null)) {

      } else if (_.isArray(default_value)) {
        this[attrname]["default"] = default_value;
      } else {
        console.log(("array property '" + attrname + "' given invalid default value: ") + default_value);
      }
      units_value = (_ref = styleprovider.mget(attrname + "_units")) != null ? _ref : 'data';
      if ((glyphspec != null) && (attrname + '_units' in glyphspec)) {
        units_value = glyphspec[attrname + '_units'];
      }
      this[attrname].units = units_value;
      if (!(glyphspec != null) || !(attrname in glyphspec)) {
        return;
      }
      glyph_value = glyphspec[attrname];
      if (_.isString(glyph_value)) {
        return this[attrname].field = glyph_value;
      } else if (_.isArray(glyph_value)) {
        return this[attrname].value = glyph_value;
      } else if (_.isObject(glyph_value)) {
        return this[attrname] = _.extend(this[attrname], glyph_value);
      } else {
        return console.log(("array property '" + attrname + "' given invalid glyph value: ") + glyph_value);
      }
    };

    properties.prototype["enum"] = function(styleprovider, glyphspec, attrname, vals) {
      var default_value, glyph_value, levels;
      this[attrname] = {};
      levels = vals.split(" ");
      default_value = styleprovider.mget(attrname);
      if (_.isNull(default_value)) {

      } else if (_.isString(default_value) && __indexOf.call(levels, default_value) >= 0) {
        this[attrname] = {
          "default": default_value
        };
      } else {
        console.log(("enum property '" + attrname + "' given invalid default value: ") + default_value);
        console.log("    acceptable values:" + levels);
      }
      if (!(glyphspec != null) || !(attrname in glyphspec)) {
        return;
      }
      glyph_value = glyphspec[attrname];
      if (_.isString(glyph_value)) {
        if (__indexOf.call(levels, glyph_value) >= 0) {
          return this[attrname].value = glyph_value;
        } else {
          return this[attrname].field = glyph_value;
        }
      } else if (_.isObject(glyph_value)) {
        return this[attrname] = _.extend(this[attrname], glyph_value);
      } else {
        console.log(("enum property '" + attrname + "' given invalid glyph value: ") + glyph_value);
        return console.log("    acceptable values:" + levels);
      }
    };

    properties.prototype.setattr = function(styleprovider, glyphspec, attrname, attrtype) {
      var values, _ref;
      values = null;
      if (attrtype.indexOf(":") > -1) {
        _ref = attrtype.split(":"), attrtype = _ref[0], values = _ref[1];
      }
      if (attrtype === "string") {
        return this.string(styleprovider, glyphspec, attrname);
      } else if (attrtype === "number") {
        return this.number(styleprovider, glyphspec, attrname);
      } else if (attrtype === "color") {
        return this.color(styleprovider, glyphspec, attrname);
      } else if (attrtype === "array") {
        return this.array(styleprovider, glyphspec, attrname);
      } else if (attrtype === "enum" && values) {
        return this["enum"](styleprovider, glyphspec, attrname, values);
      } else {
        return console.log(("Unknown type '" + attrtype + "' for glyph property: ") + attrname);
      }
    };

    properties.prototype.select = function(attrname, obj) {
      if (!(attrname in this)) {
        console.log(("requested selection of unknown property '" + attrname + "' on object: ") + obj);
        return;
      }
      if ((this[attrname].field != null) && (this[attrname].field in obj)) {
        return obj[this[attrname].field];
      }
      if (this[attrname].value != null) {
        return this[attrname].value;
      }
      if (obj[attrname] != null) {
        return obj[attrname];
      }
      if (this[attrname]["default"] != null) {
        return this[attrname]["default"];
      } else {
        return console.log("selection for attribute '" + attrname + "' failed on object: " + obj);
      }
    };

    properties.prototype.v_select = function(attrname, objs) {
      var i, obj, result, _i, _ref;
      if (!(attrname in this)) {
        console.log("requested vector selection of unknown property '" + attrname + "' on objects");
        return;
      }
      if (this[attrname].typed != null) {
        result = new Float32Array(objs.length);
      } else {
        result = new Array(objs.length);
      }
      for (i = _i = 0, _ref = objs.length - 1; 0 <= _ref ? _i <= _ref : _i >= _ref; i = 0 <= _ref ? ++_i : --_i) {
        obj = objs[i];
        if ((this[attrname].field != null) && (this[attrname].field in obj)) {
          result[i] = obj[this[attrname].field];
        } else if (this[attrname].value != null) {
          result[i] = this[attrname].value;
        } else if (obj[attrname] != null) {
          result[i] = obj[attrname];
        } else if (this[attrname]["default"] != null) {
          result[i] = this[attrname]["default"];
        } else {
          console.log("vector selection for attribute '" + attrname + "' failed on object: " + obj);
          return;
        }
      }
      return result;
    };

    return properties;

  })();

  line_properties = (function(_super) {

    __extends(line_properties, _super);

    function line_properties(styleprovider, glyphspec, prefix) {
      if (prefix == null) {
        prefix = "";
      }
      this.line_color_name = "" + prefix + "line_color";
      this.line_width_name = "" + prefix + "line_width";
      this.line_alpha_name = "" + prefix + "line_alpha";
      this.line_join_name = "" + prefix + "line_join";
      this.line_cap_name = "" + prefix + "line_cap";
      this.line_dash_name = "" + prefix + "line_dash";
      this.line_dash_offset_name = "" + prefix + "line_dash_offset";
      this.color(styleprovider, glyphspec, this.line_color_name);
      this.number(styleprovider, glyphspec, this.line_width_name);
      this.number(styleprovider, glyphspec, this.line_alpha_name);
      this["enum"](styleprovider, glyphspec, this.line_join_name, "miter round bevel");
      this["enum"](styleprovider, glyphspec, this.line_cap_name, "butt round square");
      this.array(styleprovider, glyphspec, this.line_dash_name);
      this.number(styleprovider, glyphspec, this.line_dash_offset_name);
      this.do_stroke = true;
      if (!_.isUndefined(this[this.line_color_name].value)) {
        if (_.isNull(this[this.line_color_name].value)) {
          this.do_stroke = false;
        }
      } else if (_.isNull(this[this.line_color_name]["default"])) {
        this.do_stroke = false;
      }
    }

    line_properties.prototype.set = function(ctx, obj) {
      ctx.strokeStyle = this.select(this.line_color_name, obj);
      ctx.globalAlpha = this.select(this.line_alpha_name, obj);
      ctx.lineWidth = this.select(this.line_width_name, obj);
      ctx.lineJoin = this.select(this.line_join_name, obj);
      ctx.lineCap = this.select(this.line_cap_name, obj);
      ctx.setLineDash(this.select(this.line_dash_name, obj));
      return ctx.setLineDashOffset(this.select(this.line_dash_offset_name, obj));
    };

    return line_properties;

  })(properties);

  fill_properties = (function(_super) {

    __extends(fill_properties, _super);

    function fill_properties(styleprovider, glyphspec, prefix) {
      if (prefix == null) {
        prefix = "";
      }
      this.fill_color_name = "" + prefix + "fill_color";
      this.fill_alpha_name = "" + prefix + "fill_alpha";
      this.color(styleprovider, glyphspec, this.fill_color_name);
      this.number(styleprovider, glyphspec, this.fill_alpha_name);
      this.do_fill = true;
      if (!_.isUndefined(this[this.fill_color_name].value)) {
        if (_.isNull(this[this.fill_color_name].value)) {
          this.do_fill = false;
        }
      } else if (_.isNull(this[this.fill_color_name]["default"])) {
        this.do_fill = false;
      }
    }

    fill_properties.prototype.set = function(ctx, obj) {
      ctx.fillStyle = this.select(this.fill_color_name, obj);
      return ctx.globalAlpha = this.select(this.fill_alpha_name, obj);
    };

    return fill_properties;

  })(properties);

  text_properties = (function(_super) {

    __extends(text_properties, _super);

    function text_properties(styleprovider, glyphspec, prefix) {
      if (prefix == null) {
        prefix = "";
      }
      this.text_font_name = "" + prefix + "text_font";
      this.text_font_size_name = "" + prefix + "text_font_size";
      this.text_font_style_name = "" + prefix + "text_font_style";
      this.text_color_name = "" + prefix + "text_color";
      this.text_alpha_name = "" + prefix + "text_alpha";
      this.text_align_name = "" + prefix + "text_align";
      this.text_baseline_name = "" + prefix + "text_baseline";
      this.string(styleprovider, glyphspec, this.text_font_name);
      this.string(styleprovider, glyphspec, this.text_font_size_name);
      this["enum"](styleprovider, glyphspec, this.text_font_style_name, "normal italic bold");
      this.color(styleprovider, glyphspec, this.text_color_name);
      this.number(styleprovider, glyphspec, this.text_alpha_name);
      this["enum"](styleprovider, glyphspec, this.text_align_name, "left right center");
      this["enum"](styleprovider, glyphspec, this.text_baseline_name, "top middle bottom alphabetic hanging");
    }

    text_properties.prototype.font = function(obj, font_size) {
      var font, font_style;
      if (!(font_size != null)) {
        font_size = this.select(this.text_font_size_name, obj);
      }
      font = this.select(this.text_font_name, obj);
      font_style = this.select(this.text_font_style_name, obj);
      font = font_style + " " + font_size + " " + font;
      return font;
    };

    text_properties.prototype.set = function(ctx, obj) {
      ctx.font = this.font(obj);
      ctx.fillStyle = this.select(this.text_color_name, obj);
      ctx.globalAlpha = this.select(this.text_alpha_name, obj);
      ctx.textAlign = this.select(this.text_align_name, obj);
      return ctx.textBaseline = this.select(this.text_baseline_name, obj);
    };

    return text_properties;

  })(properties);

  glyph_properties = (function(_super) {

    __extends(glyph_properties, _super);

    function glyph_properties(styleprovider, glyphspec, attrnames, properties) {
      var attrname, attrtype, prop, _i, _j, _len, _len1, _ref;
      for (_i = 0, _len = attrnames.length; _i < _len; _i++) {
        attrname = attrnames[_i];
        attrtype = "number";
        if (attrname.indexOf(":") > -1) {
          _ref = attrname.split(":"), attrname = _ref[0], attrtype = _ref[1];
        }
        this.setattr(styleprovider, glyphspec, attrname, attrtype);
      }
      for (_j = 0, _len1 = properties.length; _j < _len1; _j++) {
        prop = properties[_j];
        this[prop.constructor.name] = prop;
      }
      this.fast_path = false;
      if ('fast_path' in glyphspec) {
        this.fast_path = glyphspec.fast_path;
      }
    }

    return glyph_properties;

  })(properties);

  exports.glyph_properties = glyph_properties;

  exports.fill_properties = fill_properties;

  exports.line_properties = line_properties;

  exports.text_properties = text_properties;

}).call(this);
}, "testutils": function(exports, require, module) {(function() {
  var Collections, bar_plot, base, data_table, glyph_plot, line_plot, make_glyph_plot, make_glyph_test, make_range_and_mapper, scatter_plot, zip,
    __hasProp = {}.hasOwnProperty;

  base = require("./base");

  Collections = base.Collections;

  zip = function() {
    var arr, i, length, lengthArray, _i, _results;
    lengthArray = (function() {
      var _i, _len, _results;
      _results = [];
      for (_i = 0, _len = arguments.length; _i < _len; _i++) {
        arr = arguments[_i];
        _results.push(arr.length);
      }
      return _results;
    }).apply(this, arguments);
    length = Math.min.apply(Math, lengthArray);
    _results = [];
    for (i = _i = 0; 0 <= length ? _i < length : _i > length; i = 0 <= length ? ++_i : --_i) {
      _results.push((function() {
        var _j, _len, _results1;
        _results1 = [];
        for (_j = 0, _len = arguments.length; _j < _len; _j++) {
          arr = arguments[_j];
          _results1.push(arr[i]);
        }
        return _results1;
      }).apply(this, arguments));
    }
    return _results;
  };

  scatter_plot = function(parent, data_source, xfield, yfield, color_field, mark, colormapper, local) {
    var color_mapper, options, plot_model, source_name, xaxis, xdr, yaxis, ydr;
    if (_.isUndefined(local)) {
      local = true;
    }
    options = {
      'local': local
    };
    if (_.isUndefined(mark)) {
      mark = 'circle';
    }
    if (_.isUndefined(color_field)) {
      color_field = null;
    }
    if (_.isUndefined(color_mapper) && color_field) {
      color_mapper = Collections('DiscreteColorMapper').create({
        data_range: Collections('DataFactorRange').create({
          data_source: data_source.ref(),
          columns: ['x']
        }, options)
      }, options);
    }
    source_name = data_source.get('name');
    plot_model = Collections('Plot').create({
      data_sources: {
        source_name: data_source.ref()
      },
      parent: parent
    }, options);
    xdr = Collections('DataRange1d').create({
      'sources': [
        {
          'ref': data_source.ref(),
          'columns': [xfield]
        }
      ]
    }, options);
    ydr = Collections('DataRange1d').create({
      'sources': [
        {
          'ref': data_source.ref(),
          'columns': [yfield]
        }
      ]
    }, options);
    scatter_plot = Collections("ScatterRenderer").create({
      data_source: data_source.ref(),
      xdata_range: xdr.ref(),
      ydata_range: ydr.ref(),
      xfield: xfield,
      yfield: yfield,
      color_field: color_field,
      color_mapper: color_mapper,
      mark: mark,
      parent: plot_model.ref()
    }, options);
    xaxis = Collections('LinearAxis').create({
      'orientation': 'bottom',
      'parent': plot_model.ref(),
      'data_range': xdr.ref()
    }, options);
    yaxis = Collections('LinearAxis').create({
      'orientation': 'left',
      'parent': plot_model.ref(),
      'data_range': ydr.ref()
    }, options);
    plot_model.set({
      'renderers': [scatter_plot.ref()],
      'axes': [xaxis.ref(), yaxis.ref()]
    }, options);
    return plot_model;
  };

  data_table = function(parent, data_source, xfield, yfield, color_field, mark, colormapper, local) {
    var color_mapper, options, source_name, table_model, xdr, xmapper, ydr, ymapper;
    if (_.isUndefined(local)) {
      local = true;
    }
    options = {
      'local': local
    };
    if (_.isUndefined(mark)) {
      mark = 'circle';
    }
    if (_.isUndefined(color_field)) {
      color_field = null;
    }
    if (_.isUndefined(color_mapper) && color_field) {
      color_mapper = Collections('DiscreteColorMapper').create({
        data_range: Collections('DataFactorRange').create({
          data_source: data_source.ref(),
          columns: ['x']
        }, options)
      }, options);
    }
    source_name = data_source.get('name');
    table_model = Collections('Table').create({
      data_sources: {
        source_name: data_source.ref()
      },
      parent: parent
    }, options);
    xdr = Collections('DataRange1d').create({
      'sources': [
        {
          'ref': data_source.ref(),
          'columns': [xfield]
        }
      ]
    }, options);
    ydr = Collections('DataRange1d').create({
      'sources': [
        {
          'ref': data_source.ref(),
          'columns': [yfield]
        }
      ]
    }, options);
    xmapper = Collections('LinearMapper').create({
      data_range: xdr.ref(),
      screen_range: table_model.get('xrange')
    }, options);
    ymapper = Collections('LinearMapper').create({
      data_range: ydr.ref(),
      screen_range: table_model.get('yrange')
    }, options);
    scatter_plot = Collections("TableRenderer").create({
      data_source: data_source.ref(),
      xfield: xfield,
      yfield: yfield,
      color_field: color_field,
      color_mapper: color_mapper,
      mark: mark,
      xmapper: xmapper.ref(),
      ymapper: ymapper.ref(),
      parent: table_model.ref()
    }, options);
    return table_model.set({
      'renderers': [scatter_plot.ref()]
    }, options);
  };

  make_range_and_mapper = function(data_source, datafields, padding, screen_range, ordinal, options) {
    var mapper, range;
    if (!ordinal) {
      range = Collections('DataRange1d').create({
        sources: [
          {
            ref: data_source.ref(),
            columns: datafields
          }
        ],
        rangepadding: padding
      }, options);
      mapper = Collections('LinearMapper').create({
        data_range: range.ref(),
        screen_range: screen_range.ref()
      }, options);
    } else {
      range = Collections('DataFactorRange').create({
        data_source: data_source.ref(),
        columns: [field]
      }, options);
      mapper = Collections('FactorMapper').create({
        data_range: range.ref(),
        screen_range: screen_range.ref()
      }, options);
    }
    return [range, mapper];
  };

  bar_plot = function(parent, data_source, xfield, yfield, orientation, local) {
    var options, plot_model, xaxis, xdr, xmapper, yaxis, ydr, ymapper, _ref, _ref1;
    if (_.isUndefined(local)) {
      local = true;
    }
    options = {
      'local': local
    };
    plot_model = Collections('Plot').create({
      data_sources: {
        source_name: data_source.ref()
      },
      parent: parent
    }, options);
    _ref = make_range_and_mapper(data_source, [xfield], Math.max([1 / (data_source.get('data').length - 1), 0.1]), plot_model.get_obj('xrange'), false, options), xdr = _ref[0], xmapper = _ref[1];
    _ref1 = make_range_and_mapper(data_source, [yfield], Math.max([1 / (data_source.get('data').length - 1), 0.1]), plot_model.get_obj('yrange'), false, options), ydr = _ref1[0], ymapper = _ref1[1];
    bar_plot = Collections("BarRenderer").create({
      data_source: data_source.ref(),
      xfield: xfield,
      yfield: yfield,
      xmapper: xmapper.ref(),
      ymapper: ymapper.ref(),
      parent: plot_model.ref(),
      orientation: orientation
    }, options);
    xaxis = Collections('LinearAxis').create({
      orientation: 'bottom',
      mapper: xmapper.ref(),
      parent: plot_model.ref()
    }, options);
    yaxis = Collections('LinearAxis').create({
      orientation: 'left',
      mapper: ymapper.ref(),
      parent: plot_model.ref()
    }, options);
    return plot_model.set({
      renderers: [bar_plot.ref()],
      axes: [xaxis.ref(), yaxis.ref()]
    }, options);
  };

  line_plot = function(parent, data_source, xfield, yfield, local) {
    var options, plot_model, source_name, xaxis, xdr, yaxis, ydr;
    if (_.isUndefined(local)) {
      local = true;
    }
    options = {
      'local': local
    };
    source_name = data_source.get('name');
    plot_model = Collections('Plot').create({
      data_sources: {
        source_name: data_source.ref()
      },
      parent: parent
    }, options);
    xdr = Collections('DataRange1d').create({
      'sources': [
        {
          'ref': data_source.ref(),
          'columns': [xfield]
        }
      ]
    }, options);
    ydr = Collections('DataRange1d').create({
      'sources': [
        {
          'ref': data_source.ref(),
          'columns': [yfield]
        }
      ]
    }, options);
    line_plot = Collections("LineRenderer").create({
      data_source: data_source.ref(),
      xfield: xfield,
      yfield: yfield,
      xdata_range: xdr.ref(),
      ydata_range: ydr.ref(),
      parent: plot_model.ref()
    }, options);
    xaxis = Collections('LinearAxis').create({
      'orientation': 'bottom',
      'data_range': xdr.ref(),
      'mapper': 'linear',
      'parent': plot_model.ref()
    }, options);
    yaxis = Collections('LinearAxis').create({
      'orientation': 'left',
      'data_range': ydr.ref(),
      'mapper': 'linear',
      'parent': plot_model.ref()
    }, options);
    return plot_model.set({
      'renderers': [line_plot.ref()],
      'axes': [xaxis.ref(), yaxis.ref()]
    }, options);
  };

  glyph_plot = function(data_source, renderer, dom_element, xdatanames, ydatanames) {
    var plot_model, xaxis, xdr, yaxis, ydr;
    if (xdatanames == null) {
      xdatanames = ['x'];
    }
    if (ydatanames == null) {
      ydatanames = ['y'];
    }
    plot_model = Collections('Plot').create();
    xdr = Collections('DataRange1d').create({
      sources: [
        {
          ref: data_source.ref(),
          columns: ['x']
        }
      ]
    });
    ydr = Collections('DataRange1d').create({
      sources: [
        {
          ref: data_source.ref(),
          columns: ['y']
        }
      ]
    });
    renderer.set('xdata_range', xdr.ref());
    renderer.set('ydata_range', ydr.ref());
    xaxis = Collections('LinearAxis').create({
      orientation: 'bottom',
      parent: plot_model.ref(),
      data_range: xdr.ref()
    });
    yaxis = Collections('LinearAxis').create({
      orientation: 'left',
      parent: plot_model.ref(),
      data_range: ydr.ref()
    });
    plot_model.set({
      renderers: [renderer.ref()],
      axes: [xaxis.ref(), yaxis.ref()]
    });
    return plot_model;
  };

  make_glyph_plot = function(data_source, defaults, glyphspecs, xrange, yrange, _arg) {
    var axes, boxselectionoverlay, dims, ds, g, glyph, glyphs, glyphspec, idx, legend, legend_name, legend_renderer, legends, pantool, plot_model, plot_title, plot_tools, pstool, reference_point, resizetool, selecttool, tools, val, x, xaxis1, xaxis2, xgrid, yaxis1, yaxis2, ygrid, zoomtool, _i, _j, _k, _len, _len1, _len2, _ref;
    dims = _arg.dims, tools = _arg.tools, axes = _arg.axes, legend = _arg.legend, legend_name = _arg.legend_name, plot_title = _arg.plot_title, reference_point = _arg.reference_point;
    if (dims == null) {
      dims = [400, 400];
    }
    if (tools == null) {
      tools = true;
    }
    if (axes == null) {
      axes = true;
    }
    if (legend == null) {
      legend = true;
    }
    if (legend_name == null) {
      legend_name = "glyph";
    }
    if (plot_title == null) {
      plot_title = "";
    }
    glyphs = [];
    if (!_.isArray(glyphspecs)) {
      glyphspecs = [glyphspecs];
    }
    if (!_.isArray(data_source)) {
      for (_i = 0, _len = glyphspecs.length; _i < _len; _i++) {
        glyphspec = glyphspecs[_i];
        glyph = Collections('GlyphRenderer').create({
          data_source: data_source.ref(),
          glyphspec: glyphspec,
          nonselection_glyphspec: {
            fill_alpha: 0.1,
            line_alpha: 0.1
          },
          reference_point: reference_point
        });
        glyph.set(defaults);
        glyphs.push(glyph);
      }
    } else {
      _ref = zip(glyphspecs, data_source);
      for (_j = 0, _len1 = _ref.length; _j < _len1; _j++) {
        val = _ref[_j];
        glyphspec = val[0], ds = val[1];
        glyph = Collections('GlyphRenderer').create({
          xdata_range: xrange.ref(),
          ydata_range: yrange.ref(),
          data_source: ds.ref(),
          glyphspec: glyphspec
        });
        glyph.set(defaults);
        glyphs.push(glyph);
      }
    }
    plot_model = Collections('Plot').create({
      x_range: xrange.ref(),
      y_range: yrange.ref(),
      canvas_width: dims[0],
      canvas_height: dims[1],
      outer_width: dims[0],
      outer_height: dims[1],
      title: plot_title
    });
    plot_model.set(defaults);
    plot_model.add_renderers((function() {
      var _k, _len2, _results;
      _results = [];
      for (_k = 0, _len2 = glyphs.length; _k < _len2; _k++) {
        g = glyphs[_k];
        _results.push(g.ref());
      }
      return _results;
    })());
    if (axes) {
      xaxis1 = Collections('GuideRenderer').create({
        type: 'linear_axis',
        dimension: 0,
        axis_label: 'x',
        plot: plot_model.ref()
      });
      yaxis1 = Collections('GuideRenderer').create({
        type: 'linear_axis',
        dimension: 1,
        axis_label: 'y',
        plot: plot_model.ref()
      });
      xaxis2 = Collections('GuideRenderer').create({
        type: 'linear_axis',
        dimension: 0,
        location: 'max',
        plot: plot_model.ref()
      });
      yaxis2 = Collections('GuideRenderer').create({
        type: 'linear_axis',
        dimension: 1,
        location: 'max',
        plot: plot_model.ref()
      });
      xgrid = Collections('GuideRenderer').create({
        type: 'grid',
        dimension: 0,
        plot: plot_model.ref()
      });
      ygrid = Collections('GuideRenderer').create({
        type: 'grid',
        dimension: 1,
        plot: plot_model.ref()
      });
      plot_model.add_renderers([xgrid.ref(), ygrid.ref(), xaxis1.ref(), yaxis1.ref(), xaxis2.ref(), yaxis2.ref()]);
    }
    if (tools) {
      pantool = Collections('PanTool').create({
        dataranges: [xrange.ref(), yrange.ref()],
        dimensions: ['width', 'height']
      });
      zoomtool = Collections('ZoomTool').create({
        dataranges: [xrange.ref(), yrange.ref()],
        dimensions: ['width', 'height']
      });
      selecttool = Collections('SelectionTool').create({
        renderers: (function() {
          var _k, _len2, _results;
          _results = [];
          for (_k = 0, _len2 = glyphs.length; _k < _len2; _k++) {
            x = glyphs[_k];
            _results.push(x.ref());
          }
          return _results;
        })()
      });
      boxselectionoverlay = Collections('BoxSelectionOverlay').create({
        tool: selecttool.ref()
      });
      resizetool = Collections('ResizeTool').create();
      pstool = Collections('PreviewSaveTool').create();
      plot_tools = [pantool, zoomtool, pstool, resizetool, selecttool];
      plot_model.set_obj('tools', plot_tools);
      plot_model.add_renderers([boxselectionoverlay.ref()]);
    }
    if (legend) {
      legends = {};
      legend_renderer = Collections("AnnotationRenderer").create({
        plot: plot_model.ref(),
        annotationspec: {
          type: "legend",
          orientation: "top_right",
          legends: legends
        }
      });
      for (idx = _k = 0, _len2 = glyphs.length; _k < _len2; idx = ++_k) {
        g = glyphs[idx];
        legends[legend_name + String(idx)] = [g.ref()];
      }
      plot_model.add_renderers([legend_renderer.ref()]);
    }
    return plot_model;
  };

  make_glyph_test = function(test_name, data_source, defaults, glyphspecs, xrange, yrange, _arg) {
    var axes, dims, legend, legend_name, plot_title, reference_point, tools;
    dims = _arg.dims, tools = _arg.tools, axes = _arg.axes, legend = _arg.legend, legend_name = _arg.legend_name, plot_title = _arg.plot_title, reference_point = _arg.reference_point;
    if (dims == null) {
      dims = [400, 400];
    }
    if (tools == null) {
      tools = true;
    }
    if (axes == null) {
      axes = true;
    }
    if (legend == null) {
      legend = true;
    }
    if (legend_name == null) {
      legend_name = "glyph";
    }
    if (plot_title == null) {
      plot_title = "";
    }
    return function() {
      var div, myrender, opts, plot_model;
      expect(0);
      opts = {
        dims: dims,
        tools: tools,
        axes: axes,
        legend: legend,
        legend_name: legend_name,
        plot_title: plot_title,
        reference_point: reference_point
      };
      plot_model = make_glyph_plot(data_source, defaults, glyphspecs, xrange, yrange, opts);
      div = $('<div class="plotdiv"></div>');
      $('body').append(div);
      myrender = function() {
        var view;
        view = new plot_model.default_view({
          model: plot_model
        });
        div.append(view.$el);
        return console.log('Test ' + test_name);
      };
      return _.defer(myrender);
    };
  };

  window.bokehprettyprint = function(obj) {
    var key, val, _results;
    _results = [];
    for (key in obj) {
      if (!__hasProp.call(obj, key)) continue;
      val = obj[key];
      _results.push(console.log(key, val));
    }
    return _results;
  };

  exports.scatter_plot = scatter_plot;

  exports.data_table = data_table;

  exports.make_range_and_mapper = make_range_and_mapper;

  exports.bar_plot = bar_plot;

  exports.line_plot = line_plot;

  exports.glyph_plot = glyph_plot;

  exports.make_glyph_test = make_glyph_test;

  exports.make_glyph_plot = make_glyph_plot;

}).call(this);
}, "tools/active_tool_manager": function(exports, require, module) {(function() {
  var ActiveToolManager;

  ActiveToolManager = (function() {
    " This makes sure that only one tool is active at a time ";

    function ActiveToolManager(event_sink) {
      this.event_sink = event_sink;
      this.event_sink.active = null;
    }

    ActiveToolManager.prototype.bind_bokeh_events = function() {
      var _this = this;
      this.event_sink.on("clear_active_tool", function() {
        _this.event_sink.trigger("" + _this.event_sink.active + ":deactivated");
        return _this.event_sink.active = null;
      });
      this.event_sink.on("active_tool", function(toolName) {
        if (toolName !== _this.event_sink.active) {
          _this.event_sink.trigger("" + toolName + ":activated");
          _this.event_sink.trigger("" + _this.event_sink.active + ":deactivated");
          return _this.event_sink.active = toolName;
        }
      });
      return this.event_sink.on("try_active_tool", function(toolName) {
        if (!(_this.event_sink.active != null)) {
          _this.event_sink.trigger("" + toolName + ":activated");
          _this.event_sink.trigger("" + _this.event_sink.active + ":deactivated");
          return _this.event_sink.active = toolName;
        }
      });
    };

    return ActiveToolManager;

  })();

  exports.ActiveToolManager = ActiveToolManager;

}).call(this);
}, "tools/embed_tool": function(exports, require, module) {(function() {
  var ButtonEventGenerator, EmbedTool, EmbedToolView, EmbedTools, HasParent, base, tool,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  tool = require("./tool");

  ButtonEventGenerator = require("./eventgenerators").ButtonEventGenerator;

  base = require("../base");

  HasParent = base.HasParent;

  EmbedToolView = (function(_super) {

    __extends(EmbedToolView, _super);

    function EmbedToolView() {
      return EmbedToolView.__super__.constructor.apply(this, arguments);
    }

    EmbedToolView.prototype.initialize = function(options) {
      return EmbedToolView.__super__.initialize.call(this, options);
    };

    EmbedToolView.prototype.eventGeneratorClass = ButtonEventGenerator;

    EmbedToolView.prototype.evgen_options = {
      buttonText: "Embed Html"
    };

    EmbedToolView.prototype.tool_events = {
      activated: "_activated"
    };

    EmbedToolView.prototype._activated = function(e) {
      var baseurl, doc_apikey, doc_id, modal, model_id, script_inject_escaped,
        _this = this;
      console.log("EmbedToolView._activated");
      window.tool_view = this;
      model_id = this.plot_model.get('id');
      doc_id = this.plot_model.get('doc');
      doc_apikey = this.plot_model.get('docapikey');
      baseurl = this.plot_model.get('baseurl');
      script_inject_escaped = this.plot_model.get('script_inject_escaped');
      modal = "<div id=\"embedModal\" class=\"bokeh\">\n  <div  class=\"modal\" role=\"dialog\" aria-labelledby=\"embedLabel\" aria-hidden=\"true\">\n    <div class=\"modal-header\">\n      <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\">×</button>\n      <h3 id=\"dataConfirmLabel\"> HTML Embed code</h3></div><div class=\"modal-body\">\n      <div class=\"modal-body\">\n        " + script_inject_escaped + "\n      </div>\n    </div>\n    <div class=\"modal-footer\">\n      <button class=\"btn\" data-dismiss=\"modal\" aria-hidden=\"true\">Close</button>\n    </div>\n  </div>\n</div>";
      $('body').append(modal);
      $('#embedModal > .modal').on('hidden', function() {
        return $('#embedModal').remove();
      });
      return $('#embedModal > .modal').modal({
        show: true
      });
    };

    return EmbedToolView;

  })(tool.ToolView);

  EmbedTool = (function(_super) {

    __extends(EmbedTool, _super);

    function EmbedTool() {
      return EmbedTool.__super__.constructor.apply(this, arguments);
    }

    EmbedTool.prototype.type = "EmbedTool";

    EmbedTool.prototype.default_view = EmbedToolView;

    return EmbedTool;

  })(tool.Tool);

  EmbedTool.prototype.defaults = _.clone(EmbedTool.prototype.defaults);

  _.extend(EmbedTool.prototype.defaults);

  EmbedTools = (function(_super) {

    __extends(EmbedTools, _super);

    function EmbedTools() {
      return EmbedTools.__super__.constructor.apply(this, arguments);
    }

    EmbedTools.prototype.model = EmbedTool;

    return EmbedTools;

  })(Backbone.Collection);

  exports.EmbedToolView = EmbedToolView;

  exports.embedtools = new EmbedTools;

}).call(this);
}, "tools/eventgenerators": function(exports, require, module) {(function() {
  var ButtonEventGenerator, OnePointWheelEventGenerator, TwoPointEventGenerator;

  TwoPointEventGenerator = (function() {

    function TwoPointEventGenerator(options) {
      this.restrict_to_innercanvas = options.restrict_to_innercanvas;
      this.options = options;
      this.toolName = this.options.eventBasename;
      this.dragging = false;
      this.basepoint_set = false;
      this.button_activated = false;
      this.tool_active = false;
    }

    TwoPointEventGenerator.prototype.bind_bokeh_events = function(plotview, eventSink) {
      var toolName,
        _this = this;
      toolName = this.toolName;
      this.plotview = plotview;
      this.eventSink = eventSink;
      this.plotview.moveCallbacks.push(function(e, x, y) {
        var offset;
        if (!_this.dragging) {
          return;
        }
        if (!_this.tool_active) {
          return;
        }
        offset = $(e.currentTarget).offset();
        e.bokehX = e.pageX - offset.left;
        e.bokehY = e.pageY - offset.top;
        if (!_this.basepoint_set) {
          _this.dragging = true;
          _this.basepoint_set = true;
          return eventSink.trigger("" + toolName + ":SetBasepoint", e);
        } else {
          eventSink.trigger("" + toolName + ":UpdatingMouseMove", e);
          e.preventDefault();
          return e.stopPropagation();
        }
      });
      this.plotview.moveCallbacks.push(function(e, x, y) {
        var inner_range_horizontal, inner_range_vertical, offset, xend, xstart, yend, ystart;
        if (_this.dragging) {
          offset = $(e.currentTarget).offset();
          e.bokehX = e.pageX - offset.left;
          e.bokehY = e.pageY - offset.top;
          inner_range_horizontal = _this.plotview.view_state.get('inner_range_horizontal');
          inner_range_vertical = _this.plotview.view_state.get('inner_range_vertical');
          x = _this.plotview.view_state.device_to_sx(e.bokehX);
          y = _this.plotview.view_state.device_to_sy(e.bokehY);
          if (_this.restrict_to_innercanvas) {
            xstart = inner_range_horizontal.get('start');
            xend = inner_range_horizontal.get('end');
            ystart = inner_range_vertical.get('start');
            yend = inner_range_vertical.get('end');
          } else {
            xstart = 0;
            xend = _this.plotview.view_state.get('outer_width');
            ystart = 0;
            yend = _this.plotview.view_state.get('outer_height');
          }
          if (x < xstart || x > xend) {
            _this._stop_drag(e);
            return false;
          }
          if (y < ystart || y > yend) {
            _this._stop_drag(e);
            return false;
          }
        }
      });
      $(document).bind('keydown', function(e) {
        if (e[_this.options.keyName]) {
          _this._start_drag();
        }
        if (e.keyCode === 27) {
          return eventSink.trigger("clear_active_tool");
        }
      });
      $(document).bind('keyup', function(e) {
        if (!e[_this.options.keyName]) {
          return _this._stop_drag(e);
        }
      });
      this.plotview.canvas_wrapper.bind('mousedown', function(e) {
        if (_this.button_activated) {
          _this._start_drag();
          return false;
        }
      });
      this.plotview.canvas_wrapper.bind('mouseup', function(e) {
        if (_this.button_activated) {
          _this._stop_drag(e);
          return false;
        }
      });
      this.plotview.canvas_wrapper.bind('mouseleave', function(e) {
        if (_this.button_activated) {
          _this._stop_drag(e);
          return false;
        }
      });
      this.$tool_button = $("<button class='btn btn-small'> " + this.options.buttonText + " </button>");
      this.plotview;
      this.plotview.$el.find('.button_bar').append(this.$tool_button);
      this.$tool_button.click(function() {
        if (_this.button_activated) {
          return eventSink.trigger("clear_active_tool");
        } else {
          return eventSink.trigger("active_tool", toolName);
        }
      });
      eventSink.on("" + toolName + ":deactivated", function() {
        _this.tool_active = false;
        _this.button_activated = false;
        return _this.$tool_button.removeClass('active');
      });
      eventSink.on("" + toolName + ":activated", function() {
        _this.tool_active = true;
        _this.$tool_button.addClass('active');
        return _this.button_activated = true;
      });
      return eventSink;
    };

    TwoPointEventGenerator.prototype.hide_button = function() {
      return this.$tool_button.hide();
    };

    TwoPointEventGenerator.prototype._start_drag = function() {
      this.eventSink.trigger("active_tool", this.toolName);
      if (!this.dragging) {
        this.dragging = true;
        if (!this.button_activated) {
          return this.$tool_button.addClass('active');
        }
      }
    };

    TwoPointEventGenerator.prototype._stop_drag = function(e) {
      var offset;
      this.basepoint_set = false;
      if (this.dragging) {
        this.dragging = false;
        if (!this.button_activated) {
          this.$tool_button.removeClass('active');
        }
        offset = $(e.currentTarget).offset();
        e.bokehX = e.pageX;
        e.bokehY = e.pageY;
        return this.eventSink.trigger("" + this.options.eventBasename + ":DragEnd", e);
      }
    };

    return TwoPointEventGenerator;

  })();

  OnePointWheelEventGenerator = (function() {

    function OnePointWheelEventGenerator(options) {
      this.options = options;
      this.toolName = this.options.eventBasename;
      this.dragging = false;
      this.basepoint_set = false;
      this.button_activated = false;
      this.tool_active = false;
    }

    OnePointWheelEventGenerator.prototype.bind_bokeh_events = function(plotview, eventSink) {
      var no_scroll, restore_scroll, toolName,
        _this = this;
      toolName = this.toolName;
      this.plotview = plotview;
      this.eventSink = eventSink;
      this.plotview.canvas_wrapper.bind("mousewheel", function(e, delta, dX, dY) {
        var offset;
        if (!_this.tool_active) {
          return;
        }
        offset = $(e.currentTarget).offset();
        e.bokehX = e.pageX - offset.left;
        e.bokehY = e.pageY - offset.top;
        e.delta = delta;
        eventSink.trigger("" + toolName + ":zoom", e);
        e.preventDefault();
        return e.stopPropagation();
      });
      $(document).bind('keydown', function(e) {
        if (e.keyCode === 27) {
          return eventSink.trigger("clear_active_tool");
        }
      });
      this.plotview.$el.bind("mousein", function(e) {
        return eventSink.trigger("clear_active_tool");
      });
      this.plotview.$el.bind("mouseover", function(e) {
        return _this.mouseover_count += 1;
      });
      this.$tool_button = $("<button class='btn btn-small'> " + this.options.buttonText + " </button>");
      this.plotview.$el.find('.button_bar').append(this.$tool_button);
      this.$tool_button.click(function() {
        if (_this.button_activated) {
          return eventSink.trigger("clear_active_tool");
        } else {
          eventSink.trigger("active_tool", toolName);
          return _this.button_activated = true;
        }
      });
      no_scroll = function(el) {
        el.setAttribute("old_overflow", el.style.overflow);
        el.style.overflow = "hidden";
        if (el === document.body) {

        } else {
          return no_scroll(el.parentNode);
        }
      };
      restore_scroll = function(el) {
        el.style.overflow = el.getAttribute("old_overflow");
        if (el === document.body) {

        } else {
          return restore_scroll(el.parentNode);
        }
      };
      eventSink.on("" + toolName + ":deactivated", function() {
        _this.tool_active = false;
        _this.button_activated = false;
        _this.$tool_button.removeClass('active');
        return document.body.style.overflow = _this.old_overflow;
      });
      eventSink.on("" + toolName + ":activated", function() {
        _this.tool_active = true;
        return _this.$tool_button.addClass('active');
      });
      return eventSink;
    };

    OnePointWheelEventGenerator.prototype.hide_button = function() {
      return this.$tool_button.hide();
    };

    return OnePointWheelEventGenerator;

  })();

  ButtonEventGenerator = (function() {

    function ButtonEventGenerator(options) {
      this.options = options;
      this.toolName = this.options.eventBasename;
      this.button_activated = false;
      this.tool_active = false;
    }

    ButtonEventGenerator.prototype.bind_bokeh_events = function(plotview, eventSink) {
      var no_scroll, restore_scroll, toolName,
        _this = this;
      toolName = this.toolName;
      this.plotview = plotview;
      this.eventSink = eventSink;
      $(document).bind('keydown', function(e) {
        if (e.keyCode === 27) {
          return eventSink.trigger("clear_active_tool");
        }
      });
      this.plotview.$el.bind("mouseover", function(e) {
        return _this.mouseover_count += 1;
      });
      this.$tool_button = $("<button class='btn btn-small'> " + this.options.buttonText + " </button>");
      this.plotview.$el.find('.button_bar').append(this.$tool_button);
      this.$tool_button.click(function() {
        if (_this.button_activated) {
          return eventSink.trigger("clear_active_tool");
        } else {
          eventSink.trigger("active_tool", toolName);
          return _this.button_activated = true;
        }
      });
      no_scroll = function(el) {
        el.setAttribute("old_overflow", el.style.overflow);
        el.style.overflow = "hidden";
        if (el === document.body) {

        } else {
          return no_scroll(el.parentNode);
        }
      };
      restore_scroll = function(el) {
        el.style.overflow = el.getAttribute("old_overflow");
        if (el === document.body) {

        } else {
          return restore_scroll(el.parentNode);
        }
      };
      eventSink.on("" + toolName + ":deactivated", function() {
        _this.tool_active = false;
        _this.button_activated = false;
        _this.$tool_button.removeClass('active');
        return document.body.style.overflow = _this.old_overflow;
      });
      eventSink.on("" + toolName + ":activated", function() {
        _this.tool_active = true;
        return _this.$tool_button.addClass('active');
      });
      return eventSink;
    };

    ButtonEventGenerator.prototype.hide_button = function() {
      return this.$tool_button.hide();
    };

    return ButtonEventGenerator;

  })();

  exports.TwoPointEventGenerator = TwoPointEventGenerator;

  exports.OnePointWheelEventGenerator = OnePointWheelEventGenerator;

  exports.ButtonEventGenerator = ButtonEventGenerator;

}).call(this);
}, "tools/pan_tool": function(exports, require, module) {(function() {
  var LinearMapper, PanTool, PanToolView, PanTools, TwoPointEventGenerator, base, eventgenerators, safebind, tool,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  tool = require("./tool");

  eventgenerators = require("./eventgenerators");

  TwoPointEventGenerator = eventgenerators.TwoPointEventGenerator;

  LinearMapper = require("../mappers/1d/linear_mapper").LinearMapper;

  base = require("../base");

  safebind = base.safebind;

  window.render_count = 0;

  PanToolView = (function(_super) {

    __extends(PanToolView, _super);

    function PanToolView() {
      return PanToolView.__super__.constructor.apply(this, arguments);
    }

    PanToolView.prototype.initialize = function(options) {
      return PanToolView.__super__.initialize.call(this, options);
    };

    PanToolView.prototype.bind_bokeh_events = function() {
      return PanToolView.__super__.bind_bokeh_events.call(this);
    };

    PanToolView.prototype.toolType = "PanTool";

    PanToolView.prototype.eventGeneratorClass = TwoPointEventGenerator;

    PanToolView.prototype.evgen_options = {
      keyName: "shiftKey",
      buttonText: "Pan",
      restrict_to_innercanvas: true
    };

    PanToolView.prototype.tool_events = {
      UpdatingMouseMove: "_drag",
      SetBasepoint: "_set_base_point"
    };

    PanToolView.prototype.mouse_coords = function(e, x, y) {
      var x_, y_, _ref;
      _ref = [this.plot_view.view_state.device_to_sx(x), this.plot_view.view_state.device_to_sy(y)], x_ = _ref[0], y_ = _ref[1];
      return [x_, y_];
    };

    PanToolView.prototype._set_base_point = function(e) {
      var _ref;
      _ref = this.mouse_coords(e, e.bokehX, e.bokehY), this.x = _ref[0], this.y = _ref[1];
      return null;
    };

    PanToolView.prototype._drag = function(e) {
      var pan_info, sx_high, sx_low, sy_high, sy_low, x, xdiff, xend, xr, xstart, y, ydiff, yend, yr, ystart, _ref, _ref1;
      _ref = this.mouse_coords(e, e.bokehX, e.bokehY), x = _ref[0], y = _ref[1];
      xdiff = x - this.x;
      ydiff = y - this.y;
      _ref1 = [x, y], this.x = _ref1[0], this.y = _ref1[1];
      xr = this.plot_view.view_state.get('inner_range_horizontal');
      sx_low = xr.get('start') - xdiff;
      sx_high = xr.get('end') - xdiff;
      yr = this.plot_view.view_state.get('inner_range_vertical');
      sy_low = yr.get('start') - ydiff;
      sy_high = yr.get('end') - ydiff;
      xstart = this.plot_view.xmapper.map_from_target(sx_low);
      xend = this.plot_view.xmapper.map_from_target(sx_high);
      ystart = this.plot_view.ymapper.map_from_target(sy_low);
      yend = this.plot_view.ymapper.map_from_target(sy_high);
      pan_info = {
        xr: {
          start: xstart,
          end: xend
        },
        yr: {
          start: ystart,
          end: yend
        },
        sdx: -xdiff,
        sdy: ydiff
      };
      this.plot_view.update_range(pan_info);
      return null;
    };

    return PanToolView;

  })(tool.ToolView);

  PanTool = (function(_super) {

    __extends(PanTool, _super);

    function PanTool() {
      return PanTool.__super__.constructor.apply(this, arguments);
    }

    PanTool.prototype.type = "PanTool";

    PanTool.prototype.default_view = PanToolView;

    return PanTool;

  })(tool.Tool);

  PanTool.prototype.defaults = _.clone(PanTool.prototype.defaults);

  _.extend(PanTool.prototype.defaults, {
    dimensions: [],
    dataranges: []
  });

  PanTools = (function(_super) {

    __extends(PanTools, _super);

    function PanTools() {
      return PanTools.__super__.constructor.apply(this, arguments);
    }

    PanTools.prototype.model = PanTool;

    return PanTools;

  })(Backbone.Collection);

  exports.PanToolView = PanToolView;

  exports.pantools = new PanTools;

}).call(this);
}, "tools/preview_save_tool": function(exports, require, module) {(function() {
  var ButtonEventGenerator, PreviewSaveTool, PreviewSaveToolView, PreviewSaveTools, base, tool,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  tool = require("./tool");

  ButtonEventGenerator = require("./eventgenerators").ButtonEventGenerator;

  base = require("../base");

  PreviewSaveToolView = (function(_super) {

    __extends(PreviewSaveToolView, _super);

    function PreviewSaveToolView() {
      return PreviewSaveToolView.__super__.constructor.apply(this, arguments);
    }

    PreviewSaveToolView.prototype.initialize = function(options) {
      return PreviewSaveToolView.__super__.initialize.call(this, options);
    };

    PreviewSaveToolView.prototype.eventGeneratorClass = ButtonEventGenerator;

    PreviewSaveToolView.prototype.evgen_options = {
      buttonText: "Preview/Save"
    };

    PreviewSaveToolView.prototype.tool_events = {
      activated: "_activated"
    };

    PreviewSaveToolView.prototype._activated = function(e) {
      var data_uri, modal,
        _this = this;
      data_uri = this.plot_view.canvas[0].toDataURL();
      this.plot_model.set('png', this.plot_view.canvas[0].toDataURL());
      base.Collections.bulksave([this.plot_model]);
      modal = "<div id='previewModal' class='bokeh'>\n  <div class=\"modal\" role=\"dialog\" aria-labelledby=\"previewLabel\" aria-hidden=\"true\">\n    <div class=\"modal-header\">\n      <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\">×</button>\n      <h3 id=\"dataConfirmLabel\">Image Preview (right click to save)</h3></div><div class=\"modal-body\">\n    <div class=\"modal-body\">\n      <img src=\"" + data_uri + "\" style=\"max-height: 300px; max-width: 400px\">\n    </div>\n    </div><div class=\"modal-footer\">\n      <button class=\"btn\" data-dismiss=\"modal\" aria-hidden=\"true\">Close</button>\n    </div>\n  </div>\n</div>";
      $('body').append(modal);
      $('#previewModal .modal').on('hidden', function() {
        $('#previewModal').remove();
        return $('#previewModal > .modal').remove();
      });
      return $('#previewModal > .modal').modal({
        show: true
      });
    };

    return PreviewSaveToolView;

  })(tool.ToolView);

  PreviewSaveTool = (function(_super) {

    __extends(PreviewSaveTool, _super);

    function PreviewSaveTool() {
      return PreviewSaveTool.__super__.constructor.apply(this, arguments);
    }

    PreviewSaveTool.prototype.type = "PreviewSaveTool";

    PreviewSaveTool.prototype.default_view = PreviewSaveToolView;

    return PreviewSaveTool;

  })(tool.Tool);

  PreviewSaveTool.prototype.defaults = _.clone(PreviewSaveTool.prototype.defaults);

  _.extend(PreviewSaveTool.prototype.defaults);

  PreviewSaveTools = (function(_super) {

    __extends(PreviewSaveTools, _super);

    function PreviewSaveTools() {
      return PreviewSaveTools.__super__.constructor.apply(this, arguments);
    }

    PreviewSaveTools.prototype.model = PreviewSaveTool;

    return PreviewSaveTools;

  })(Backbone.Collection);

  exports.PreviewSaveToolView = PreviewSaveToolView;

  exports.previewsavetools = new PreviewSaveTools;

}).call(this);
}, "tools/resize_tool": function(exports, require, module) {(function() {
  var LinearMapper, ResizeTool, ResizeToolView, ResizeTools, TwoPointEventGenerator, base, eventgenerators, tool,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  tool = require("./tool");

  eventgenerators = require("./eventgenerators");

  TwoPointEventGenerator = eventgenerators.TwoPointEventGenerator;

  LinearMapper = require("../mappers/1d/linear_mapper").LinearMapper;

  base = require("../base");

  ResizeToolView = (function(_super) {

    __extends(ResizeToolView, _super);

    function ResizeToolView() {
      return ResizeToolView.__super__.constructor.apply(this, arguments);
    }

    ResizeToolView.prototype.initialize = function(options) {
      ResizeToolView.__super__.initialize.call(this, options);
      return this.active = false;
    };

    ResizeToolView.prototype.bind_events = function(plotview) {
      return ResizeToolView.__super__.bind_events.call(this, plotview);
    };

    ResizeToolView.prototype.eventGeneratorClass = TwoPointEventGenerator;

    ResizeToolView.prototype.evgen_options = {
      keyName: "",
      buttonText: "Resize"
    };

    ResizeToolView.prototype.tool_events = {
      activated: "_activate",
      deactivated: "_deactivate",
      UpdatingMouseMove: "_drag",
      SetBasepoint: "_set_base_point"
    };

    ResizeToolView.prototype.render = function() {
      var ch, ctx, cw, line_width;
      if (!this.active) {
        return;
      }
      ctx = this.plot_view.ctx;
      cw = this.plot_view.view_state.get('canvas_width');
      ch = this.plot_view.view_state.get('canvas_height');
      line_width = 8;
      ctx.save();
      ctx.strokeStyle = 'grey';
      ctx.globalAlpha = 0.7;
      ctx.lineWidth = line_width;
      ctx.setLineDash([]);
      ctx.beginPath();
      ctx.rect(line_width, line_width, cw - line_width * 2, ch - line_width * 2);
      ctx.moveTo(line_width, line_width);
      ctx.lineTo(cw - line_width, ch - line_width);
      ctx.moveTo(line_width, ch - line_width);
      ctx.lineTo(cw - line_width, line_width);
      ctx.stroke();
      return ctx.restore();
    };

    ResizeToolView.prototype.mouse_coords = function(e, x, y) {
      return [x, y];
    };

    ResizeToolView.prototype._activate = function(e) {
      var bbar, ch, cw;
      this.active = true;
      this.popup = $('<div class="resize_popup pull-right" style="border-radius: 10px; background-color: lightgrey; padding:3px 8px; font-size: 14px"></div>');
      bbar = this.plot_view.$el.find('.button_bar');
      this.popup.appendTo(bbar);
      ch = this.plot_view.view_state.get('outer_height');
      cw = this.plot_view.view_state.get('outer_width');
      this.popup.text("width: " + cw + " height: " + ch);
      this.plot_view.request_render();
      return null;
    };

    ResizeToolView.prototype._deactivate = function(e) {
      this.active = false;
      this.popup.remove();
      this.plot_view.request_render();
      return null;
    };

    ResizeToolView.prototype._set_base_point = function(e) {
      var _ref;
      _ref = this.mouse_coords(e, e.bokehX, e.bokehY), this.x = _ref[0], this.y = _ref[1];
      return null;
    };

    ResizeToolView.prototype._drag = function(e) {
      var ch, cw, x, xdiff, y, ydiff, _ref, _ref1;
      this.plot_view.pause();
      _ref = this.mouse_coords(e, e.bokehX, e.bokehY), x = _ref[0], y = _ref[1];
      xdiff = x - this.x;
      ydiff = y - this.y;
      _ref1 = [x, y], this.x = _ref1[0], this.y = _ref1[1];
      ch = this.plot_view.view_state.get('outer_height');
      cw = this.plot_view.view_state.get('outer_width');
      this.popup.text("width: " + cw + " height: " + ch);
      this.plot_view.view_state.set('outer_height', ch + ydiff, {
        'silent': true
      });
      this.plot_view.view_state.set('outer_width', cw + xdiff, {
        'silent': true
      });
      this.plot_view.view_state.set('canvas_height', ch + ydiff, {
        'silent': true
      });
      this.plot_view.view_state.set('canvas_width', cw + xdiff, {
        'silent': true
      });
      this.plot_view.view_state.trigger('change:outer_height', ch + ydiff);
      this.plot_view.view_state.trigger('change:outer_width', cw + xdiff);
      this.plot_view.view_state.trigger('change:canvas_height', ch + ydiff);
      this.plot_view.view_state.trigger('change:canvas_width', cw + xdiff);
      this.plot_view.view_state.trigger('change', this.plot_view.view_state);
      this.plot_view.unpause(true);
      return null;
    };

    return ResizeToolView;

  })(tool.ToolView);

  ResizeTool = (function(_super) {

    __extends(ResizeTool, _super);

    function ResizeTool() {
      return ResizeTool.__super__.constructor.apply(this, arguments);
    }

    ResizeTool.prototype.type = "ResizeTool";

    ResizeTool.prototype.default_view = ResizeToolView;

    return ResizeTool;

  })(tool.Tool);

  ResizeTool.prototype.defaults = _.clone(ResizeTool.prototype.defaults);

  _.extend(ResizeTool.prototype.defaults);

  ResizeTool.prototype.display_defaults = _.clone(ResizeTool.prototype.display_defaults);

  _.extend(ResizeTool.prototype.display_defaults);

  ResizeTools = (function(_super) {

    __extends(ResizeTools, _super);

    function ResizeTools() {
      return ResizeTools.__super__.constructor.apply(this, arguments);
    }

    ResizeTools.prototype.model = ResizeTool;

    return ResizeTools;

  })(Backbone.Collection);

  exports.ResizeToolView = ResizeToolView;

  exports.resizetools = new ResizeTools;

}).call(this);
}, "tools/select_tool": function(exports, require, module) {(function() {
  var DataRangeBoxSelectionTool, DataRangeBoxSelectionToolView, LinearMapper, SelectionTool, SelectionToolView, SelectionTools, TwoPointEventGenerator, base, coll, eventgenerators, safebind, tool,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  tool = require("./tool");

  eventgenerators = require("./eventgenerators");

  TwoPointEventGenerator = eventgenerators.TwoPointEventGenerator;

  LinearMapper = require("../mappers/1d/linear_mapper").LinearMapper;

  base = require("../base");

  safebind = base.safebind;

  SelectionToolView = (function(_super) {

    __extends(SelectionToolView, _super);

    function SelectionToolView() {
      return SelectionToolView.__super__.constructor.apply(this, arguments);
    }

    SelectionToolView.prototype.initialize = function(options) {
      var _this = this;
      SelectionToolView.__super__.initialize.call(this, options);
      this.select_callback = _.debounce((function() {
        return _this._select_data();
      }), 50);
      return this.listenTo(this.model, 'change', this.select_callback);
    };

    SelectionToolView.prototype.bind_bokeh_events = function() {
      var renderer, rendererview, _i, _len, _ref, _results;
      SelectionToolView.__super__.bind_bokeh_events.call(this);
      _ref = this.mget_obj('renderers');
      _results = [];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        renderer = _ref[_i];
        rendererview = this.plot_view.renderers[renderer.id];
        this.listenTo(rendererview.xrange(), 'change', this.select_callback);
        this.listenTo(rendererview.yrange(), 'change', this.select_callback);
        this.listenTo(renderer, 'change', this.select_callback);
        _results.push(this.listenTo(renderer, 'change', this.select_callback));
      }
      return _results;
    };

    SelectionToolView.prototype.eventGeneratorClass = TwoPointEventGenerator;

    SelectionToolView.prototype.evgen_options = {
      keyName: "ctrlKey",
      buttonText: "Select",
      restrict_to_innercanvas: true
    };

    SelectionToolView.prototype.tool_events = {
      SetBasepoint: "_start_selecting",
      UpdatingMouseMove: "_selecting",
      deactivated: "_stop_selecting"
    };

    SelectionToolView.prototype.pause = function() {
      return "";
    };

    SelectionToolView.prototype.mouse_coords = function(e, x, y) {
      var _ref;
      _ref = [this.plot_view.view_state.device_to_sx(x), this.plot_view.view_state.device_to_sy(y)], x = _ref[0], y = _ref[1];
      return [x, y];
    };

    SelectionToolView.prototype._stop_selecting = function() {
      this.trigger('stopselect');
      return this.basepoint_set = false;
    };

    SelectionToolView.prototype._start_selecting = function(e) {
      var x, y, _ref;
      this.trigger('startselect');
      _ref = this.mouse_coords(e, e.bokehX, e.bokehY), x = _ref[0], y = _ref[1];
      this.mset({
        'start_x': x,
        'start_y': y,
        'current_x': null,
        'current_y': null
      });
      return this.basepoint_set = true;
    };

    SelectionToolView.prototype._get_selection_range = function() {
      var xrange, yrange;
      xrange = [this.mget('start_x'), this.mget('current_x')];
      yrange = [this.mget('start_y'), this.mget('current_y')];
      if (this.mget('select_x')) {
        xrange = [_.min(xrange), _.max(xrange)];
      } else {
        xrange = null;
      }
      if (this.mget('select_y')) {
        yrange = [_.min(yrange), _.max(yrange)];
      } else {
        yrange = null;
      }
      return [xrange, yrange];
    };

    SelectionToolView.prototype._get_selection_range_fast = function(current_x, current_y) {
      var xrange, yrange;
      xrange = [this.mget('start_x'), current_x];
      yrange = [this.mget('start_y'), current_y];
      if (this.mget('select_x')) {
        xrange = [_.min(xrange), _.max(xrange)];
      } else {
        xrange = null;
      }
      if (this.mget('select_y')) {
        yrange = [_.min(yrange), _.max(yrange)];
      } else {
        yrange = null;
      }
      return [xrange, yrange];
    };

    SelectionToolView.prototype._selecting = function(e, x_, y_) {
      var x, y, _ref, _ref1;
      _ref = this.mouse_coords(e, e.bokehX, e.bokehY), x = _ref[0], y = _ref[1];
      this.mset({
        'current_x': x,
        'current_y': y
      });
      _ref1 = this._get_selection_range(x, y), this.xrange = _ref1[0], this.yrange = _ref1[1];
      this.trigger('boxselect', this.xrange, this.yrange);
      return null;
    };

    SelectionToolView.prototype.box_selecting = function(e, x_, y_) {
      var x, y, _ref, _ref1;
      _ref = this.mouse_coords(e, e.bokehX, e.bokehY), x = _ref[0], y = _ref[1];
      _ref1 = this._get_selection_range_fast(x, y), this.xrange = _ref1[0], this.yrange = _ref1[1];
      this.trigger('boxselect', this.xrange, this.yrange);
      return null;
    };

    SelectionToolView.prototype._select_data = function() {
      var datasource, datasource_id, datasource_selections, datasources, ds, k, renderer, selected, v, _i, _j, _len, _len1, _ref, _ref1;
      if (!this.basepoint_set) {
        return;
      }
      datasources = {};
      datasource_selections = {};
      _ref = this.mget_obj('renderers');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        renderer = _ref[_i];
        datasource = renderer.get_obj('data_source');
        datasources[datasource.id] = datasource;
      }
      _ref1 = this.mget_obj('renderers');
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        renderer = _ref1[_j];
        datasource_id = renderer.get_obj('data_source').id;
        _.setdefault(datasource_selections, datasource_id, []);
        selected = this.plot_view.renderers[renderer.id].select(this.xrange, this.yrange);
        datasource_selections[datasource_id].push(selected);
      }
      for (k in datasource_selections) {
        if (!__hasProp.call(datasource_selections, k)) continue;
        v = datasource_selections[k];
        selected = _.intersection.apply(_, v);
        ds = datasources[k];
        ds.save({
          selected: selected
        }, {
          patch: true
        });
      }
      return null;
    };

    return SelectionToolView;

  })(tool.ToolView);

  SelectionTool = (function(_super) {

    __extends(SelectionTool, _super);

    function SelectionTool() {
      return SelectionTool.__super__.constructor.apply(this, arguments);
    }

    SelectionTool.prototype.type = "SelectionTool";

    SelectionTool.prototype.default_view = SelectionToolView;

    return SelectionTool;

  })(tool.Tool);

  SelectionTool.prototype.defaults = _.clone(SelectionTool.prototype.defaults);

  _.extend(SelectionTool.prototype.defaults, {
    renderers: [],
    select_x: true,
    select_y: true,
    data_source_options: {}
  });

  SelectionTools = (function(_super) {

    __extends(SelectionTools, _super);

    function SelectionTools() {
      return SelectionTools.__super__.constructor.apply(this, arguments);
    }

    SelectionTools.prototype.model = SelectionTool;

    return SelectionTools;

  })(Backbone.Collection);

  exports.SelectionToolView = SelectionToolView;

  exports.selectiontools = new SelectionTools;

  DataRangeBoxSelectionToolView = (function(_super) {

    __extends(DataRangeBoxSelectionToolView, _super);

    function DataRangeBoxSelectionToolView() {
      return DataRangeBoxSelectionToolView.__super__.constructor.apply(this, arguments);
    }

    DataRangeBoxSelectionToolView.prototype.bind_bokeh_events = function() {
      return tool.ToolView.prototype.bind_bokeh_events.call(this);
    };

    DataRangeBoxSelectionToolView.prototype._select_data = function() {
      var xend, xstart, yend, ystart, _ref, _ref1;
      _ref = this.plot_view.mapper.map_from_target(this.xrange[0], this.yrange[0]), xstart = _ref[0], ystart = _ref[1];
      _ref1 = this.plot_view.mapper.map_from_target(this.xrange[1], this.yrange[1]), xend = _ref1[0], yend = _ref1[1];
      this.mset('xselect', [xstart, xend]);
      this.mset('yselect', [ystart, yend]);
      return this.model.save();
    };

    return DataRangeBoxSelectionToolView;

  })(SelectionToolView);

  DataRangeBoxSelectionTool = (function(_super) {

    __extends(DataRangeBoxSelectionTool, _super);

    function DataRangeBoxSelectionTool() {
      return DataRangeBoxSelectionTool.__super__.constructor.apply(this, arguments);
    }

    DataRangeBoxSelectionTool.prototype.type = "DataRangeBoxSelectionTool";

    DataRangeBoxSelectionTool.prototype.default_view = DataRangeBoxSelectionToolView;

    return DataRangeBoxSelectionTool;

  })(SelectionTool);

  DataRangeBoxSelectionTool.prototype.defaults = _.clone(DataRangeBoxSelectionTool.prototype.defaults);

  coll = Backbone.Collection.extend({
    model: DataRangeBoxSelectionTool
  });

  exports.datarangeboxselectiontools = new coll();

}).call(this);
}, "tools/slider": function(exports, require, module) {(function() {
  var DataSlider, DataSliderView, HasParent, PlotWidget, coll,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  PlotWidget = require('../common/plot_widget').PlotWidget;

  HasParent = require("../base").HasParent;

  DataSliderView = (function(_super) {

    __extends(DataSliderView, _super);

    function DataSliderView() {
      return DataSliderView.__super__.constructor.apply(this, arguments);
    }

    DataSliderView.prototype.attributes = {
      "class": "dataslider pull-left"
    };

    DataSliderView.prototype.initialize = function(options) {
      DataSliderView.__super__.initialize.call(this, options);
      this.render_init();
      return this.select = _.throttle(this._select, 50);
    };

    DataSliderView.prototype.delegateEvents = function(events) {
      DataSliderView.__super__.delegateEvents.call(this, events);
      return "pass";
    };

    DataSliderView.prototype.label = function(min, max) {
      this.$(".minlabel").text(min);
      return this.$(".maxlabel").text(max);
    };

    DataSliderView.prototype.render_init = function() {
      var column, max, min, _ref,
        _this = this;
      this.$el.html("");
      this.$el.append("<div class='maxlabel'></div>");
      this.$el.append("<div class='slider'></div>");
      this.$el.append("<div class='minlabel'></div>");
      this.plot_view.$(".plotarea").append(this.$el);
      column = this.mget_obj('data_source').getcolumn(this.mget('field'));
      _ref = [_.min(column), _.max(column)], min = _ref[0], max = _ref[1];
      this.$el.find(".slider").slider({
        orientation: "vertical",
        animate: "fast",
        step: (max - min) / 50.0,
        min: min,
        max: max,
        values: [min, max],
        slide: function(event, ui) {
          _this.set_selection_range(event, ui);
          return _this.select(event, ui);
        }
      });
      this.label(min, max);
      return this.$el.find(".slider").height(this.plot_view.view_state.get('inner_height'));
    };

    DataSliderView.prototype.set_selection_range = function(event, ui) {
      var data_source, field, max, min;
      min = _.min(ui.values);
      max = _.max(ui.values);
      this.label(min, max);
      data_source = this.mget_obj('data_source');
      field = this.mget('field');
      if (!(data_source.range_selections != null)) {
        data_source.range_selections = {};
      }
      return data_source.range_selections[field] = [min, max];
    };

    DataSliderView.prototype._select = function() {
      var colname, columns, data_source, i, max, min, numrows, select, selected, val, value, _i, _ref, _ref1;
      data_source = this.mget_obj('data_source');
      columns = {};
      numrows = 0;
      _ref = data_source.range_selections;
      for (colname in _ref) {
        if (!__hasProp.call(_ref, colname)) continue;
        value = _ref[colname];
        columns[colname] = data_source.getcolumn(colname);
        numrows = columns[colname].length;
      }
      selected = [];
      for (i = _i = 0; 0 <= numrows ? _i < numrows : _i > numrows; i = 0 <= numrows ? ++_i : --_i) {
        select = true;
        _ref1 = data_source.range_selections;
        for (colname in _ref1) {
          if (!__hasProp.call(_ref1, colname)) continue;
          value = _ref1[colname];
          min = value[0], max = value[1];
          val = columns[colname][i];
          if (val < min || val > max) {
            select = false;
            break;
          }
        }
        if (select) {
          selected.push(i);
        }
      }
      return data_source.save({
        selected: selected
      }, {
        patch: true
      });
    };

    return DataSliderView;

  })(PlotWidget);

  DataSlider = (function(_super) {

    __extends(DataSlider, _super);

    function DataSlider() {
      return DataSlider.__super__.constructor.apply(this, arguments);
    }

    DataSlider.prototype.type = "DataSlider";

    DataSlider.prototype.default_view = DataSliderView;

    return DataSlider;

  })(HasParent);

  DataSlider.prototype.defaults = _.clone(DataSlider.prototype.defaults);

  _.extend(DataSlider.prototype.defaults, {
    data_source: null,
    field: null
  });

  DataSlider.prototype.display_defaults = _.clone(DataSlider.prototype.display_defaults);

  _.extend(DataSlider.prototype.display_defaults, {
    level: 'tool'
  });

  PlotWidget = require('../common/plot_widget').PlotWidget;

  HasParent = require('../base').HasParent;

  coll = Backbone.Collection.extend({
    model: DataSlider
  });

  exports.datasliders = new coll();

}).call(this);
}, "tools/tool": function(exports, require, module) {(function() {
  var HasParent, PlotWidget, Tool, ToolView,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  PlotWidget = require('../common/plot_widget').PlotWidget;

  HasParent = require('../base').HasParent;

  ToolView = (function(_super) {

    __extends(ToolView, _super);

    function ToolView() {
      return ToolView.__super__.constructor.apply(this, arguments);
    }

    ToolView.prototype.initialize = function(options) {
      return ToolView.__super__.initialize.call(this, options);
    };

    ToolView.prototype.bind_bokeh_events = function() {
      var eventSink, evgen, evgen_options, evgen_options2,
        _this = this;
      eventSink = this.plot_view.eventSink;
      evgen_options = {
        eventBasename: this.cid
      };
      evgen_options2 = _.extend(evgen_options, this.evgen_options);
      evgen = new this.eventGeneratorClass(evgen_options2);
      evgen.bind_bokeh_events(this.plot_view, eventSink);
      _.each(this.tool_events, function(handler_f, event_name) {
        var full_event_name, wrap;
        full_event_name = "" + _this.cid + ":" + event_name;
        wrap = function(e) {
          return _this[handler_f](e);
        };
        return eventSink.on(full_event_name, wrap);
      });
      this.evgen = evgen;
      return {
        render: function() {}
      };
    };

    return ToolView;

  })(PlotWidget);

  Tool = (function(_super) {

    __extends(Tool, _super);

    function Tool() {
      return Tool.__super__.constructor.apply(this, arguments);
    }

    return Tool;

  })(HasParent);

  Tool.prototype.display_defaults = _.clone(Tool.prototype.display_defaults);

  _.extend(Tool.prototype.display_defaults, {
    level: 'tool'
  });

  exports.Tool = Tool;

  exports.ToolView = ToolView;

}).call(this);
}, "tools/zoom_tool": function(exports, require, module) {(function() {
  var LinearMapper, OnePointWheelEventGenerator, ZoomTool, ZoomToolView, ZoomTools, base, eventgenerators, safebind, tool,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  tool = require("./tool");

  eventgenerators = require("./eventgenerators");

  OnePointWheelEventGenerator = eventgenerators.OnePointWheelEventGenerator;

  LinearMapper = require("../mappers/1d/linear_mapper").LinearMapper;

  base = require("../base");

  safebind = base.safebind;

  ZoomToolView = (function(_super) {

    __extends(ZoomToolView, _super);

    function ZoomToolView() {
      return ZoomToolView.__super__.constructor.apply(this, arguments);
    }

    ZoomToolView.prototype.initialize = function(options) {
      return ZoomToolView.__super__.initialize.call(this, options);
    };

    ZoomToolView.prototype.eventGeneratorClass = OnePointWheelEventGenerator;

    ZoomToolView.prototype.evgen_options = {
      buttonText: "Zoom"
    };

    ZoomToolView.prototype.tool_events = {
      zoom: "_zoom"
    };

    ZoomToolView.prototype.mouse_coords = function(e, x, y) {
      var x_, y_, _ref;
      _ref = [this.plot_view.view_state.device_to_sx(x), this.plot_view.view_state.device_to_sy(y)], x_ = _ref[0], y_ = _ref[1];
      return [x_, y_];
    };

    ZoomToolView.prototype._zoom = function(e) {
      var delta, factor, screenX, screenY, speed, sx_high, sx_low, sy_high, sy_low, x, xend, xr, xstart, y, yend, yr, ystart, zoom_info, _ref;
      delta = e.delta;
      screenX = e.bokehX;
      screenY = e.bokehY;
      _ref = this.mouse_coords(e, screenX, screenY), x = _ref[0], y = _ref[1];
      speed = this.mget('speed');
      factor = speed * (delta * 50);
      xr = this.plot_view.view_state.get('inner_range_horizontal');
      sx_low = xr.get('start');
      sx_high = xr.get('end');
      yr = this.plot_view.view_state.get('inner_range_vertical');
      sy_low = yr.get('start');
      sy_high = yr.get('end');
      xstart = this.plot_view.xmapper.map_from_target(sx_low - (sx_low - x) * factor);
      xend = this.plot_view.xmapper.map_from_target(sx_high - (sx_high - x) * factor);
      ystart = this.plot_view.ymapper.map_from_target(sy_low - (sy_low - y) * factor);
      yend = this.plot_view.ymapper.map_from_target(sy_high - (sy_high - y) * factor);
      zoom_info = {
        xr: {
          start: xstart,
          end: xend
        },
        yr: {
          start: ystart,
          end: yend
        },
        factor: factor
      };
      this.plot_view.update_range(zoom_info);
      return null;
    };

    return ZoomToolView;

  })(tool.ToolView);

  ZoomTool = (function(_super) {

    __extends(ZoomTool, _super);

    function ZoomTool() {
      return ZoomTool.__super__.constructor.apply(this, arguments);
    }

    ZoomTool.prototype.type = "ZoomTool";

    ZoomTool.prototype.default_view = ZoomToolView;

    return ZoomTool;

  })(tool.Tool);

  ZoomTool.prototype.defaults = _.clone(ZoomTool.prototype.defaults);

  _.extend(ZoomTool.prototype.defaults, {
    dimensions: [],
    dataranges: [],
    speed: 1 / 600
  });

  ZoomTools = (function(_super) {

    __extends(ZoomTools, _super);

    function ZoomTools() {
      return ZoomTools.__super__.constructor.apply(this, arguments);
    }

    ZoomTools.prototype.model = ZoomTool;

    return ZoomTools;

  })(Backbone.Collection);

  exports.ZoomToolView = ZoomToolView;

  exports.zoomtools = new ZoomTools;

}).call(this);
}
});

