# -*- coding: utf-8 -*-
# hmath
# v.5.0.0
# by caleb7023
#
#                                        ...(+uwXuuZuuZuuZZuZXA&J-..
#                                   ..uuuuuuZuuZuZuuZuuZZZuZZZZZZZZZZZG-.
#                                .(uZuuZuuZuZuZuZuZuZZZZZuZZZuZZZZZZZZZZZZn,
#                               .uuZuZuuZZuZuZuZuuZZuZZuZZZZZZZZZZZZZZZZZZZZk,
#                              (Zuuuuu=`   _7uuZuZZuZZZZZZuZZZZZZZZZZZZZZZZZZy+
#                              uuZuZu:       (uZZZuZZZuZZZZZZZZZZZZZZZZZZyZZyZZ.
#                              uuuZuu.       .ZZuZZZZZZZZZZZZZZZZZZZZZZZZZyZZZy}
#                              uuZZuZn       JZZZZZuZZZZZZZZZZZZZZZZZZyZyZZyZyZ}
#                              uZuZuuuu&...JZZZuZZZZZZZZZZZZZZZZZZZZZZZyZZZyZZy}
#                           ...mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmQQQQQQQQQQo......
#                      ..gMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM%
#                    .MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM#
#                  .MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM]
#                .(MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM#_~~~~~~~~~_..
#            .+ZQMMMMMMMMMMHWUUWWWWWWWMMM#WWWWWWWWWWWWWWWWWWWMMM#WWWWWWWWWWWWWW%~~~~.~.~.~.~~~~~~_.
#          .uuZdMMMMMMUuuZuZuZZZZZZZZdMMM#ZZZZZZZZZZZZZZZZZZdMMM#ZyZyZyyyyyyyyy}   ~.~~.~~.~~.~~~~~_
#        .uZuXMMMMMSZZuuZuZZZZZZZZZZZMMMM#ZZZZZZZZZZZZZZZZZyMMMMWyZyZyZyZyyZyyy}   ~~.~~.~~~.~~~~~~~~.
#       .ZuuXMMMMuZuuZuZZZZZuZZZZZZZXMMMMHZZZZZZZZZZZZyZyyZXMMM#yyZyyZyyyZyyyZy}   .~~.~~.~~~~.~~.~~~~-
#      .uZuZMMMSuuZuuZZZZuZZZZuZZZZZdMMMMWZZZZZZZZZyZZZyZZyMMMMHZyyZyyyZyyyyyyZ}   ~~.~~~~~~~~~.~~~.~~~.
#     .uuZuZuuuZZuZZZuZZuZZZZZZZZZZZMMMMNZZZZZZZyZyZZyZZyZyMMMMyyZyyZyyyyyZyyyy:   ~~~.~~.~.~~~~~~~~~~~_
#     JZuuZZuZuZuuZZuZZZZZZuZZZZZZZdMMMM#ZZZZyZZZyZZyZyZyZXMMM#ZyyZyyZyyZyyyZy0    ~.~~~~~~~.~.~~.~~~~~~.
#    .uuZuuZZuZuZZZZuZZuZZZZZZZZZZZMMMMMHZZyZZyZZZyZZyZyZydMMMHZyyyyyyyyyyyyyX'   _~~~~.~~.~~~~~~~~~~~~~_
#    ,ZuZZuZuZuZZZuZZZZZZZZZZZZZZZXMMMMMZZZyZZZyyZyZyZyZyZMMMMyyZyZyyyZyyZyyf!    ~~~.~~~.~~~~~.~~~~~~~~~
#    JuZuuZuZZZuZZZZZZZZZZZZZZZZZZMMMMM#ZyZZZyZZZyZyZyZyyXMMM#yyyyyyyZyyyyV^     ~~~~~~~~~~~.~~~~~~~~~~~~
#    dZuuZuZZuZZZuZZZZZZZZZZZZZZZdMMMMMWZZyZyZyZyZyZyyZyydMMM#yyyyyZyXVY^`     .~~.~~.~.~~~~~~~~~~~~~~~~~
#    uZuZZZZuZZZZZZZZZZZZZZZZZZZXMMMMMF``                dMMM`               .~~~~~~.~~~~.~~~~~~~~~~~~~~~
#    uuZZuZZZZZuZZZZZZZZZZZZZZZZMMMMMM`                  MMM@           .._~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~
#    wZZZZZZZZZZZZZZZZZZZZZZZZfdMMMMMD.....~.....~..~..~.~~~.~~.~~.~.~~~~~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~~~
#    zZZZuZuZZZZZZZZZZZZZZZZZf.MMM#=....~.~..~.~.~~.~~.~..~.~.~~~.~~~.~~~.~.~~.~~~.~~.~~~~~~~~~~~~~~~~~~~
#    (ZZZZZZZZZZZZZZZZZZZZyZf.MMMt..~.~..~..~.~.~..~.~~~~~.~~.~~.~~~~~.~~~~~.~~~~~~~~~~~~~~~~~~~~~~~~~~:~
#    .ZZZZZZZZZZZZZZZZZZZZZZjMMM3.~..~..~..~.~..~.~..~..~~.~~~.~~~.~~~~~.~~~~~~~.~~~~~~~~~~~~~~~~~~~~:~~_
#     XZZZZZZZZZZZZZZZyZyZyqMMMF.~..~..~..~..~.~.~~~~.~~.~~.~.~~.~~.~.~~~.~~~.~~~~~~~~~~~~~~~~~~~~~~:~~~`
#     -ZZZZZZZZZZZZyZZZyZydMMMM!..~..~..~.~.~.~~.~.~~.~~.~~.~~~~~~~~~~.~~~~.~~~~~~~~~~~~~~~~~~~~~:~~~:~_
#      jZZZZZZZZZyZZZyZZXMMMMMN~..~..~.~.~.~.~.~~.~.~~.~~.~~~~.~~.~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~:~~~_
#       4ZZZZZZZZZZyZZZQMMMMMMM~.~.~..~.~.~.~~.~.~~.~~.~~~~.~~~~~~.~.~~.~~~~~~~~~~~~~~~~~~~~~~:~:~~:~_
#        4ZZZZyZZyZZyXNMMMMMMMM~..~.~.~.~.~~.~~.~~.~~.~~.~~~~.~~.~~~~~~~~~.~~~~~~~~~~~~~~~~~~:~~~:~~_
#         ?XZZZZyZZyqMMMMMMMMM$.~..~.~.~.~.~~.~~.~~.~~~~~.~~~~.~~~~~~.~~~~~~~~~~~~~~~~~~~~:~~~~:~~_`
#           ?UyZZyqMMMMMMMMMM% .~~..~.~.~~.~.~.~~.~~.~~~~~.~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~:~~:~~_`
#              ?qMMMMMMMMMMM^  ~..~~.~~.~~~.~~~.~~~~~~.```u&&&&&&gggggggg++J_````````````````
#                ?WMMMMMMMM'   ~.~.~.~~~..~~.~~~~.~~~~~    TMMMMMMMMMMMMMB=
#                   (TMMMB`    ~~.~~..~~.~~.~~.~~~.~.~~~~.~~._?<<<<<<<<~~~~~~~~_
#                       7      .~.~~~.~~~~.~~.~~~~~~~~.~~~~~~~~~~~~~~~~~~~~~~~~_
#                              ~~.~~.~~.~~~~~~~.~.~~~.~~~~~~~~~~~~~~~~~~~~~~~~~_
#                              ~~.~~.~~.~.~~.~~~~~.~~~~~~~.~~~~~~~_````_~~~:~~:_
#                              ~~.~~~~.~~~.~~~.~~~~~~~.~~~~~~~~~~`       ~~~:~~_
#                              ~.~~.~~~~~~~~~.~~.~~.~~~~~~~~~~~~_        _~~~~~_
#                              _~~~.~.~~.~~.~~~~~~~~~~~~~~~~~~~~_        _:~:~~_
#                               _~~~~~~.~~~~~~~~~.~~~~~~~~~~~~~~~_.    .~~~:~~:
#                                `~~.~~~~.~~.~~.~~~~~~~~~~~~~~~~~~~~~~~:~~~~~_`
#                                     `_~~~~~.~~~~~~~~~~~~~~~~~~~~~~~:~~:~~:~:_`
#                                     ``.~~~~~~~~~~~~~~~~~~~~~~:~~~:~~:__`
#                                           ```___~~~~~~~~~~~~____``
#

"""
# [hmath](https://caleb7023.hmath.pro)

![hmath](https://caleb7023.hmath.pro)

hmath was developed to use advanced math functions in python.
You can use complex numbers for most functions.

# Version
[v.5.0.0](https://caleb7023.hmath.pro/version/v-3-3-6)

hmath is investigating whether the calculation of the function is correct and whether the calculation is efficient. 
Please help us provide information on efficient calculation methods and whether the calculations are correct.
[Click on this to answer.](https://caleb7023.hmath.pro/Feedback)


[Feedback on hmath modules](https://caleb7023.hmath.pro/Feedback)
"""
from pickle import dumps, load
from sys import getsizeof
from os.path import dirname

directory = "%s//" %dirname(__file__)
__vasion__ : str = "5.0.0"
class hmath_setting:
    class memo:
        max_memo_size = None
        save_to_HDD = True
        HDD_save_time = 60
        def HDD_save_reset():
            memo_plk = open("%smemo.plk" %directory, "w", encoding='UTF-8')
            memo_plk.write(str(dumps({"B":{},"ln":{},"rad":{},"exp":{},"sin":{},"cos":{},"tan":{},"csc":{},"sec":{},"cot":{},"log":{},"log2":{},"zeta":{},"asin":{},"acos":{},"atan":{},"acsc":{},"asec":{},"acot":{},"sinh":{},"cosh":{},"tanh":{},"csch":{},"sech":{},"coth":{},"cube":{},"sqrt":{},"log10":{},"asinh":{},"acosh":{},"atanh":{},"acsch":{},"asech":{},"acoth":{},"Gamma":{},"diganma":{},"radical":{},"factorial":{},"reduct_fract":{},"prime_test":{},"prime_fact":{}})))
            memo_plk.close()
    class fract:
        max_about_minute_limit : int = 40

__save_time = 0
def __memo(func) -> object:
    def memo(*args) -> object:
        global __save_time
        global __corresponding_dictionary
        if func.__name__ == "dlist":
            memo = 0
        else:
            if hmath_setting.memo.max_memo_size != None:
                if hmath_setting.memo.max_memo_size < getsizeof(str(__corresponding_dictionary)):
                    memo = 0
                    if args in __corresponding_dictionary[func.__name__]:
                        ans =   __corresponding_dictionary[func.__name__][args]
                else:
                    memo = 1
            else:
                memo = 1
        if memo == 0:
            new_func = func
            if len(args) == 1:
                ans = new_func(args[0])
            if len(args) == 2:
                ans = new_func(args[0], args[1])
            if len(args) == 3:
                ans = new_func(args[0], args[1], args[2])
        else:
            try:
                {args:0}
                args_ = args
            except:
                args_ = str(args)
            if args_ in __corresponding_dictionary[func.__name__]:
                ans =   __corresponding_dictionary[func.__name__][args_]
            else:
                new_func = func
                if len(args) == 1:
                    ans = new_func(args[0])
                if len(args) == 2:
                    ans = new_func(args[0], args[1])
                if len(args) == 3:
                    ans = new_func(args[0], args[1], args[2])
                __corresponding_dictionary[func.__name__][args] = ans
                if hmath_setting.memo.save_to_HDD:
                    __save_time += 1
                    if hmath_setting.memo.HDD_save_time < __save_time:
                        memo_plk = open("%smemo.plk" %directory, "w", encoding='UTF-8')
                        memo_data = dumps(__corresponding_dictionary)
                        memo_plk.write(str(memo_data))
                        memo_plk.close()
        return ans
    return memo

def __list(func) -> object:
    def dlist(*args) -> object:
        if type(args[0]) == list or type(args[0]) == array:
            if len(args) == 1:
                ans = [func(value) for value in args[0]]
            if len(args) == 2:
                args1 = list(args[0])
                args2 =      args[1]
                try:
                    args2 = list(args2)
                    ans = []
                    for process in len(args1):
                        value1 = args1[process]
                        value2 = args2[process]
                        ans += [func(value1, value2)]
                except:
                    ans = []
                    for process in len(args1):
                        value1 = args1[process]
                        ans += [func(value1)]
            if type(args[0]) == array:
                return array(ans)
            return ans
        else:
            if len(args) == 1:
                return func(args[0])
            if len(args) == 2:
                return func(args[0], args[1])
            if len(args) == 3:
                return func(args[0], args[1], args[2])
    return dlist

def __pow(func) -> object:
    def pow(args1, args2 = 0) -> object:
        ans = args1
        if type(args2) == str:
            k = 0.01
            for h in range(len(args2)):
                if args2[h] == "d":
                    ans = (func(ans + k) - func(ans)) / k
                else:
                    raise Exception('The value of the argument must be a string that contains only "d" or a natural number.')
            return ans
        elif args2 < 0 or not args2 % 1 == 0:
            raise Exception('The value of the argument must be a string that contains only "d" or a natural number.')
        else:
            for k in range(args2 + 1):
                ans = func(ans)
        return ans
    return pow

def __del_complex(func) -> object:
    def del_complex(*args) -> object:
        new_func = func
        if len(args) == 1:
            ans = new_func(args[0])
        elif len(args) == 2:
            ans = new_func(args[0], args[1])
        elif len(args) == 3:
            ans = new_func(args[0], args[1], args[2])
        if imag_part(ans) == 0:
            return real_part(ans)
        return ans
    return del_complex

class array:
    pass

class set:
    pass

class dimension:
    pass

class fract:
    pass

class array:
    """
    "array" is used to represent a array.

    example:
    >>> hmath.array([3, 2])
    array[3, 2]
    >>> hmath.array([3.1, -2.5, 9])
    array[ 3.1, -2.5,    9]
    >>> hmath.array([[3 + 5j, 3], [hmath.fract(4, 3), -32]])
    array[[ (3+5j),      3],
          [(4 / 3),    -32]]
    """
    def __init__(self, array_list : list) -> None:
        if array.__size_check(array_list):
            self.array_list = array_list
        else:
            raise Exception("All lists in the list should be the same length.\nThis also applies to lists in lists.")
    def __hash__(self : array) -> int:
        return hash("array%s,虞禱娑媟坂篩墮騨屹禱冗" %self.array_list)
    def __to_array(data : array or list):
        if type(data) == list:
            return array(data)
        return data
    def __size_check(self : list) -> bool:
        if type(self[0]) != list:
            return True
        self_size = len(self[0])
        list_in_self = 0
        for process in self:
            if type(process) == list:
                list_in_self = 1
                if self_size != len(process):
                    return False
                if type(process[0]) == list:
                    if not(array.__size_check(process)):
                        return False
            if (type(process) != list) == list_in_self:
                return False
        return True
    def __max_len(self : list) -> int:
        max_len = 0
        for value in self:
            if type(value) == array:
                value_max_len = array.__max_len(value)
                if  max_len < value_max_len:
                    max_len = value_max_len
            else:
                if  max_len < len(str(value)):
                    max_len = len(str(value))
        return max_len
    def __trim(self : array, deep : int, self_max_len : int) -> str:
        self_trim = ""
        if  deep == 1:
            self_trim = "array["
        roop_time = 0
        for value in self:
            if  type(value) == array:
                if roop_time == 1:
                    self_trim += ",\n     %s" %(deep * " ")
                self_trim += "[%s" %(array.__trim(value, deep + 1, self_max_len))
            else:
                if  roop_time == 1:
                    self_trim += ", "
                self_trim += "%s%s" %((self_max_len - len(str(value))) * " ", value)
            roop_time = 1
        return "%s]" %(self_trim)
    def __repr__(self : array) -> str:
        return array.__trim(self, 1, array.__max_len(self))
    #in
    def __contains__(self : array, other) -> bool:
        return other in self.array_list
    def __getitem__(self : array, other : int or slice or tuple) -> int or float or complex or set or dimension or fract or array:
        return array.__to_array(self.array_list[other])
    def __iter__(self : array) -> int:
        self.roop_time = -1
        return self
    def __next__(self : array) -> array:
        self.roop_time += 1
        if self.roop_time == len(self):
            raise StopIteration
        return array.__to_array(self.array_list[self.roop_time])
    def __list__(self : array) -> list:
        return self.array_list
    def __str__(self : array) -> str:
        return "array(%s)" %(self.array_list)
    def __bool__(self : array) -> array:
        return array([bool(value1) for value1 in self])
    def __not__(self : array) -> array:
        return array([not(value1) for value1 in self])
    def __len__(self : array) -> int:
        return len(self.array_list)
    def __abs__(self : array) -> array:
        return array([abs(value1) for value1 in self])
    def __float__(self : array) -> float:
        return array([float(value1) for value1 in self])
    def __round__(self : array, other : int) -> array:
        return array([round(value1, other) for value1 in self.array_list])
    #+
    def __add__ (self : array, other) -> array:
        if type(self) == type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 + value2 for value1, value2 in zip(self, other)])
        return array([value1 + other for value1 in self])
    def __radd__(self : array, other) -> array:
        return array([value1 + other for value1 in self])
    #-
    def __sub__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 - value2 for value1, value2 in zip(self, other)])
        return array([value1 - other for value1 in self])
    def __rsub__(self : array, other) -> array:
        return array([value1 - other for value1 in self])
    def __neg__(self : array) -> array:
        return 0 - self
    #*
    def __mul__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 * value2 for value1, value2 in zip(self, other)])
        return array([value1 * other for value1 in self])
    def __rmul__(self : array, other) -> array:
        return array([value1 * other for value1 in self])
    #/
    def __truediv__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 / value2 for value1, value2 in zip(self, other)])
        return array([value1 / other for value1 in self])
    def __rtruediv__(self : array, other) -> array:
        return array([value1 / other for value1 in self])
    #//
    def __floordiv__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 // value2 for value1, value2 in zip(self, other)])
        return array([value1 // other for value1 in self])
    def __rflooediv__(self : array, other) -> array:
        return array([value1 // other for value1 in self])
    #**
    def __pow__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 ** value2 for value1, value2 in zip(self, other)])
        return array([value1 ** other for value1 in self])
    def __rpow__(self : array, other) -> array:
        return array([value1 ** other for value1 in self])
    #%
    def __divmod__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 % value2 for value1, value2 in zip(self, other)])
        return array([value1 % other for value1 in self])
    def __rdivmod__(self : array, other) -> array:
        return array([value1 % other for value1 in self])
    #==
    def __eq__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 == value2 for value1, value2 in zip(self, other)])
        return array([value1 == other for value1 in self])
    def __req__(self : array, other) -> array:
        return array([value1 == other for value1 in self])
    #!=
    def __ne__ (self : array, other) -> array:
        return not self == other
    def __rne__(self : array, other) -> array:
        return not self == other
    #<
    def __lt__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 < value2 for value1, value2 in zip(self, other)])
        return array([value1 < other for value1 in self])
    def __rlt__(self : array, other) -> array:
        return array([value1 < other for value1 in self])
    #>
    def __gt__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 > value2 for value1, value2 in zip(self, other)])
        return array([value1 > other for value1 in self])
    def __rgt__(self : array, other) -> array:
        return array([value1 > other for value1 in self])
    #<=
    def __le__ (self : array, other) -> array:
        if type(other) == array:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 <= value2 for value1, value2 in zip(self, other)])
        return array([value1 <= other for value1 in self])
    def __rle__(self : array, other) -> array:
        return array([value1 <= other for value1 in self])
    #>=
    def __ge__ (self : array, other) -> array:
        if type(other) == fract:
            if len(self) != len(other):
                raise Exception("The lengths of the two arrays do not match.")
            return array([value1 >= value2 for value1, value2 in zip(self, other)])
        return array([value1 >= other for value1 in self])
    def __rge__(self : array, other) -> array:
        return array([value1 >= other for value1 in self])

class set:
    global __const
    __const = 0
    def __init__(self, field_of_sets) -> None:
        if __const == 1:
            self.const = field_of_sets
        for test in field_of_sets:
            if type(test) == list:
                raise Exception("You cannot put a list in a list.")
        self.field_of_sets = field_of_sets
        self.const = None
    def __str__ (self) -> str:
        return "set(%s)" %self.field_of_sets
    def __hash__(self) -> int:
        return hash("set%s,壽禱埜媟簑坂篩墮騨屹禱" %self.field_of_sets)
    def __repr__(self) -> str:
        if self.const == None:
            if len(self.field_of_sets) == 0:
                return "Φ"
            elif len(self.field_of_sets) == 1:
                return "{%s}" %self.field_of_sets[0]
            field_of_sets = "{%s" %self.field_of_sets[0]
            for value in self.field_of_sets[1 : -1]:
                field_of_sets += ", %s" %value
            return "%s, %s}" %(field_of_sets, self.field_of_sets[-1])
        return self.const
    def has(self, other) -> bool:
        for x in self.field_of_sets:
            if not x in other.field_of_sets:
                return False
        return True
    def union(self, other) -> set:
        ans = []
        for x in self.field_of_sets:
            if x in other.field_of_sets:
                ans += [x]
        return set(ans)
    def complement(self, other) -> set:
        ans = []
        for x in other.field_of_sets:
            if not (x in self.field_of_sets):
                ans += [x]
        return set(ans)
    def belong(self : set, other) -> bool:
        if self.const == None:
            return other in self.field_of_sets
        elif self.const == "ℚ":
            return True
        elif self.const == "ℕ":
            if type(other) == int or type(other) == float:
                return (0 < other) and (other % 1 == 0)
            return False
        elif self.const == "ℤ":
            if type(other) == int or type(other) == float:
                return other % 1 == 0
            return False
        elif self.const == "ℝ":
            if type(other) == int or type(other) == float:
                return True
            return False
        elif self.const == "ℂ":
            if complex_test(other):
                return True
            return False
    def Q() -> set:
        global __const
        __const = 1
        ans = set("ℚ")
        __const = 0
        return ans
    def N() -> set:
        global __const
        __const = 1
        ans = set("ℕ")
        __const = 0
        return ans
    def Z() -> set:
        global __const
        __const = 1
        ans = set("ℤ")
        __const = 0
        return ans
    def R() -> set:
        global __const
        __const = 1
        ans = set("ℝ")
        __const = 0
        return ans
    def C() -> set:
        global __const
        __const = 1
        ans = set("ℂ")
        __const = 0
        return ans

class __dimension: # coming Soon
    def __init__(self, imag_dict) -> None:
        self.imag_dict = imag_dict
    def __hash__(self) -> int:
        return hash("di%s,壽緩埜媟爾坂篩墮騨屹" %self.imag_dict)
    def __str__(self) -> str:
        return "dimension(%s)" %self.imag_dict
    def __repr__(self) -> str:
        ans = "("
        for imge_number, number in zip(self.imag_dict.keys(), self.imag_dict.values()):
            ans += "(%si%s)" %(number, str(imge_number).replace("0", "₀")\
                                                       .replace("1", "₁")\
                                                       .replace("2", "₂")\
                                                       .replace("3", "₃")\
                                                       .replace("4", "₄")\
                                                       .replace("5", "₅")\
                                                       .replace("6", "₆")\
                                                       .replace("7", "₇")\
                                                       .replace("8", "₈")\
                                                       .replace("9", "₉"))
        return "%s)" %ans
    def __abs__(self) -> int or float:
        ans = 0
        for number in self.imag_dict.values():
            ans += number ** 2
        return sqrt(ans)

class fract:
    """
    "fract" is used to represent a fract.

    example:
    >>> hmath.fract(3, 4)
    (3 / 4)
    >>> hmath.fract(-7, 8)
    (-7 / 8)
    >>> hmath.fract(3 + 5j, 3)
    ((3+5j) / 3)
    """
    def __init__(self, mole, deno, reduct_fract_count = 1):
        if hmath_setting.fract.max_about_minute_limit < reduct_fract_count:
            new_self  = reduct_fract(fract(mole, deno, 1))
            self.mole = new_self.mole
            self.deno = new_self.deno
            self.reduct_fract_count = 0
        else:
            self.mole = mole
            self.deno = deno
            self.reduct_fract_count = reduct_fract_count
    
    def __repr__(self):
        return str(self)
    
    def __bool__(self):
        return self.mole != 0
    
    def __hash__(self):
        return hash("fr%s/%s,壽緩埜媟爾坂篩墮鑑屹" %(self.mole, self.deno))
    
    def __str__(self):
        self = reduct_fract(self)
        if not(type(self.mole) == complex or type(self.deno) == complex):
            if self.mole < 0 or self.deno < 0:
                if self.mole < 0 and self.deno < 0:
                    return "(%s / %s)" %(abs(self.mole), abs(self.deno))
                return "-(%s / %s)" %(abs(self.mole), abs(self.deno))
        return "(%s / %s)" %(self.mole, self.deno)
    
    def __abs__(self):
        return fract(abs(self.mole), abs(self.deno))
    
    def __float__(self):
        return div(self.mole , self.deno)
    
    def __round__(self, other):
        return fract((self.deno * (1 / 10 ** (other - 1)) // self.mole) * self.deno, self.deno)
    #+
    def __add__(self, other):
        if not type(other) == fract:
            return fract(self.mole + other * self.deno, self.deno, self.reduct_fract_count + 2)
        return fract(self.mole * other.deno + other.mole * self.deno, self.deno * other.deno, max(self.reduct_fract_count, other.reduct_fract_count) + 2)
    def __radd__(self, other):
        return fract(self.mole + other * self.deno, self.deno, self.reduct_fract_count + 2)
    #-
    def __sub__(self, other):
        if not type(other) == fract:
            return fract(self.mole - other * self.deno, self.deno, self.reduct_fract_count + 2)
        return fract(self.mole * other.deno - other.mole * self.deno, self.deno * other.deno, max(self.reduct_fract_count, other.reduct_fract_count) + 2)
    def __rsub__(self, other):
        return fract(self.mole - other * self.deno, self.deno, self.reduct_fract_count + 2)
    def __neg__(self):
        return fract(-self.mole, self.deno)
    #*
    def __mul__(self, other):
        if not type(other) == fract:
            return fract(self.mole * other, self.deno, self.reduct_fract_count + 2)
        return fract(self.mole * other.mole, self.deno * other.deno, max(self.reduct_fract_count, other.reduct_fract_count) + 1)
    def __rmul__(self, other):
        return fract(self.mole * other, self.deno, self.reduct_fract_count + 2)
    #/
    def __truediv__ (self, other):
        if not type(other) == fract:
            return fract(self.mole, self.deno * other, self.reduct_fract_count + 2)
        return fract(self.mole * other.deno, self.deno * other.mole, max(self.reduct_fract_count, other.reduct_fract_count) + 1)
    def __rtruediv__(self, other):
        return fract(self.deno * other, self.mole, self.reduct_fract_count + 2)
    
    def __floordiv__ (self, other):
        value_1 = self / other
        return value_1.mole // value_1.deno
    def __rflooediv__(self, other):
        value_1 = self / other
        return value_1.mole // value_1.deno
    #**
    def __pow__ (self, other):
        if not type(other) == fract:
            return fract(self.mole ** other, self.deno ** other, self.reduct_fract_count + 2)
        return fract(self.mole ** (other.mole / other.deno), self.deno ** (other.mole / other.deno), self.reduct_fract_count)
    def __rpow__(self, other):
        return other ** (self.mole / self.deno, self.reduct_fract_count + 2)
    
    def __divmod__ (self, other):
        value_1 = self // other
        return (value_1, self - other * value_1)
    def __rdivmod__(self, other):
        value_1 = self // other
        return (value_1, self - other * value_1)
    #==
    def __eq__ (self, other):
        if type(other) != fract:
            ans = other * self.deno
            return ans == self.mole
        return self.mole == other.mole and self.deno == other.deno
    def __req__(self, other):
        ans = other * self.deno
        return ans == self.mole
    #!=
    def __ne__ (self, other):
        return not self == other
    def __rne__(self, other):
        return not self == other
    #<
    def __lt__ (self, other):
        if type(other) != fract:
            return self.mole < self.deno * other
        return self.mole * other.deno < self.deno * other.mole
    def __rlt__(self, other):
        return self.mole < self.deno * other
    #>
    def __gt__ (self, other):
        if type(other) != fract:
            return self.mole > self.deno * other
        return self.mole * other.deno > self.deno * other.mole
    def __rgt__(self, other):
        return self.mole > self.deno * other
    #<=
    def __le__ (self, other):
        return self < other or self == other
    def __rle__(self, other):
        return self < other or self == other
    #>=
    def __ge__ (self, other):
        return self > other or self == other
    def __rge__(self, other):
        return self > other or self == other

def gcd(*args):
    if len(args) <= 1:
        return args[0]
    n, k, *others = args
    if k > n:
        n, k = k, n
    while k != 0:
        k, n = n % k, k
    return gcd(n, *others)

def lcm(*args) -> int or array:
    args_max = max(args)
    n = 1
    while True:
        for k in args:
            if args_max * n % k != 0:
                n += 1
                break
        else:
            return args_max * n

@__memo
def sign(x):
    return x / -x

@__memo
def theta(x):
    if 0 < x:
        return 1
    else:
        return 0

@__memo
def Sigma(_roop_time, _first_value, _formula) -> int or float or complex or set or dimension or fract or array:
    ans = 0
    for n in range(_first_value, _roop_time):
        ans += eval(_formula)
    return ans

@__memo
def Pi(_roop_time, _first_value, _formula) -> int or float or complex or set or dimension or fract or array:
    ans = 1
    for n in range(_first_value, _roop_time):
        ans *= eval(_formula)
    return ans

@__list
@__memo
def reduct_fract(_fr) -> fract:
    """
    "reduct_fract(x)" reduces the fract x.
    """
    if type(_fr) != fract:
        raise Exception("Enter only fract types.")
    if type(_fr.mole) != complex and type(_fr.deno) != complex and _fr.reduct_fract_count != 0:
        if _fr.mole % 1 == 0 and _fr.deno % 1 == 0:
            ans_gcd = gcd(_fr.mole, _fr.deno)
            return fract(_fr.mole / ans_gcd, _fr.deno / ans_gcd, 0)
    return _fr

@__list
def complex_test(_x) -> bool or array or list:
    """
    "complex_test(x)" returns whether x is a complex number.
    """
    try:
        a = _x.imag
        if a == 0:
            return False
        else:
            return True
    except:
        return True

@__list
@__memo
def prime_test(_n) -> bool or array or list:
    """
    "prime_test(x)" returns whether x is a prime number.
    """
    root_n = _n ** 0.5
    divisible = True
    for test in range(int(root_n) - 1):
        if  int(_n / (test + 2)) == _n / (test + 2):
            divisible = False
            break
    return divisible

@__list
@__memo
def prime_fact(_n : int) -> array or list:
    """
    "prime_fact(x)" returns the result of factoring x into prime factors.
    """
    if prime_test(_n):
        return [_n]
    n = _n
    ans = []
    while n != 1:
        prime_plase = 0
        prime_number = 2
        while n % prime_number != 0:
            prime_number = prime(prime_plase)
            prime_plase += 1
        ans += [prime_number]
        n = n / prime_number
    return ans

prime_list : list = [2, 3, 5, 7]
@__list
def prime(_n : int):
    global prime_list
    try:
        return prime_list[_n + 1]
    except:
        try:
            k = prime_list[_n] + 2
        except:
            k = prime(_n - 1) + 2
        while not prime_test(k):
            k += 2
        prime_list += [k]
        return k

@__list
@__memo
def B(_n : int) -> fract or array or list:
    ans = fract(0, 1)
    if _n == 0:
        return fract(1, 1)
    if _n == 1:
        return fract(-1, 2)
    for k in range(_n):
        if B(k).mole != 0:
            k2 = k
            if _n - k + 1 < k:
                k2 = _n + 1 - k
            r = 1
            for l in range(k2):
                r *= _n + 1 - l
            for l in range(k2):
                r //= l + 1
            c = r
            mul = fract(c, 1) * B(k)
            ans2 = ans
            ans = (ans2.deno * mul.deno)
            ans = fract(ans2.mole * (ans // ans2.deno) + mul.mole * (ans // mul.deno), ans)
    ans = ans * fract(-1, _n + 1)
    if ans.mole != 0:
        ans = fract(ans.mole, ans.deno)
    return ans

@__list
@__memo
def rad(_n : int) -> int:
    factorization = prime_fact(_n)
    if type(factorization) != list:
        return _n
    existing_value = []
    ans = 1
    for k in factorization:
        if k not in existing_value:
            existing_value += [k]
            ans *= k
    return ans

@__list
def div(_x : int or float or complex or dimension or fract or array or list,
        _y : int or float or complex or dimension or fract or array or list)\
          -> int or float or complex or dimension or fract or array or list:
    if _y == 0:
        if   0 < _x:
            return  inf()
        elif _x < 0:
            return -inf()
        else:
            return  0
    elif _y == inf():
        return 0
    else:
        return _x / _y

@__list
def imag_part(_x : int or float or complex or dimension or fract or array or list) -> int or float or array or list:
    try:
        return _x.imag
    except:
        return 0

@__list
def real_part(_x : int or float or complex or dimension or fract or array or list) -> int or float or array or list:
    try:
        return _x.real
    except:
        return 0

@__list
def P(_n : int or float or complex or dimension or fract or array or list, 
      _k : int or float or complex or dimension or fract or array or list)\
        -> int or float or complex or dimension or fract or array or list:
    return factorial(_n) / factorial(_k)

@__list
def C(_n : int or float or complex or dimension or fract or array or list, 
      _k : int or float or complex or dimension or fract or array or list)\
        -> int or float or complex or dimension or fract or array or list:
    return P(_n, _k) / factorial(_k)

def inf() -> float:
    """
    "inf()" returns infinity.
    """
    return float("inf")

def pi() -> float:
    """
    "pi()" returns the constant π.
    The value is approximately 3.1415926535897932384626433832795.
    """
    return 3.1415926535897932384626433832795

def e() -> float:
    """
    "e()" returns the constant e.
    The value is approximately 2.7182818284590452353602874713527.
    """
    return 2.7182818284590452353602874713527

def phi() -> float:
    """
    "phi()" returns the constant φ.
    The value is approximately 1.6180339887498948482045868343656.
    """
    return 1.6180339887498948482045868343656

def gamma() -> float:
    """
    "gamma()" returns the constant γ.
    The value is approximately 0.5772156649015328606065120900824.
    """
    return 0.5772156649015328606065120900824

def tau() -> float:
    """
    "tau()" returns the constant τ.
    The value is approximately 6.283185307179586476925286766559.
    """
    return 6.283185307179586476925286766559

@__list
@__memo
def exp(_x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    """
    "exp(x)" returns the value of e power x.
    """
    return e() ** _x

@__list
@__memo
def zeta(x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    """
    "zeta(x)" returns the value of ζx.
    """
    if x == 1:
        return inf()
    a = [0.5 / (1 - (2 ** (1 - x)))]
    b = [a[0]]
    for n in range(1, 200):
        for k in range(n):
            a[k] = a[k] * n / (n - k) / 2
        a += [-(n / (n + 1)) ** x * a[-1] / n]
        b += [sum(a)]
        if 1.0e+4 < abs(b[-1]) < 1.0e-6:
             break           
    return sum(b)

@__list
@__memo
def ln(x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    ans = x - 1
    ans_Pi = 1
    for n in range(1, 200):
        ans_Pi *= 2 / (1 + radical(2 ** n , x))
    return ans * ans_Pi

@__list
@__memo
def log10(x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    return log(10, x)

@__list
@__memo
def log2(x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    return log(2, x)

@__list
@__memo
def log(x : int or float or complex or dimension or fract or array or list,
        y : int or float or complex or dimension or fract or array or list)\
         -> int or float or complex or dimension or fract or array or list:
    return div(ln(y) , ln(x))

@__list
@__memo
def sqrt(x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    return radical(x, 2)

@__list
@__memo
def cube(x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    return radical(x, 3)

@__list
@__memo
def radical(x : int or float or complex or dimension or fract or array or list, 
            y : int or float or complex or dimension or fract or array or list)\
             -> int or float or complex or dimension or fract or array or list:
    if type(y) == int and type(x) == int:
        if y < 0 and x % 2 == 1:
            return -(abs(y) ** (1 / x))
    return y ** (1 / x)

__Gamma_list : list = [
      676.5203681218851      ,
    -1259.1392167224028      ,
      771.32342877765313     ,
     -176.61502916214059     ,
       12.507343278686905    ,
       -0.13857109526572012  ,
        9.9843695780195716e-6,
        1.5056327351493116e-7,
]
@__list
@__del_complex
@__pow
@__memo
def Gamma(x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    if real_part(x) < 0.5:
        ans = pi() / (sin(pi() * x) * Gamma(1 - x))
    else:
        y = 0.99999999999980993
        for (i, Gamma_v) in enumerate(__Gamma_list):
            y += Gamma_v / (x + i)
        t = x + len(__Gamma_list) - 1.5
        ans = sqrt(tau()) * t ** (x - 0.5) * exp(-t) * y
    return ans

@__list
@__memo
def factorial(_x : int or float or complex or dimension or fract or array or list) -> int or float or complex or dimension or fract or array or list:
    """
    "factorial(x)" returns the value of x!
    """
    if not complex_test(_x):
        if _x % 1 == 0 and 0 < _x:
            ans = 1
            for process in range(1 , _x + 1):
                ans = ans * process
            return ans
        if  _x < 0:
            return -factorial(-_x)
    return Gamma(_x + 1)

@__list
@__del_complex
@__pow
@__memo
def sin(_θ : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    """
    "sin(θ)" returns value of sine θ.
    >>> hmath.sin(6)
    -0.27941549819892586
    >>> hmath.sin(2.11)
    0.8581178296348089
    >>> hmath.sin(53+12j)
    (32219.35761890742-74727.46166398648j)
    >>> hmath.sin([2.14, 25, 33+5j])
    [0.8423304316366457, -0.13235175009777303, (74.20340766788514-0.9851772699807544j)]
    """
    return (exp(_θ * 1j) - exp(_θ * -1j)) / 2j

@__list
@__del_complex
@__pow
@__memo
def cos(_θ : int or float or complex or dimension or fract or array or list, _n = 0) -> int or float or complex or dimension or fract or array or list:
    """
    "cos(θ)" returns value of cosine θ.
    >>> hmath.cos(6)
    0.960170286650366
    >>> hmath.cos(2.11)
    -0.5134528123039594
    >>> hmath.cos(53+12j)
    (-74727.46166962861-32219.35761647477j)
    >>> hmath.cos([2.14, 25, 33+5j])
    [-0.5389614493995115, 0.9912028118634736, (-0.9852667279998637-74.19667031476799j)]
    """
    return (exp(_θ * 1j) + exp(_θ * -1j)) / 2

@__list
@__del_complex
@__pow
@__memo
def tan(_θ : int or float or complex or dimension or fract or array or list, _n = 0) -> int or float or complex or dimension or fract or array or list:
    """
    "tan(θ)" returns value of tangent θ.
    >>> hmath.tan(6)
    -0.29100619138474915
    >>> hmath.tan(2.11)
    -1.671269119715739
    >>> hmath.tan(53+12j)
    (-5.490123633255438e-11+0.9999999999481682j)
    >>> hmath.tan([2.14, 25, 33+5j])
    [-1.5628769600778225, -0.13352640702153587, (-2.411059897354615e-06+1.0000907719652579j)]
    """
    return div(sin(_θ) , cos(_θ))

@__list
@__pow
@__memo
def csc(_θ : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    """
    "csc(θ)" returns value of cosec θ.
    >>> hmath.csc(6)
    -3.5788995472544056
    >>> hmath.csc(2.11)
    1.1653411285319317
    >>> hmath.csc(53+12j)
    (4.865296397916956e-06+1.1284248877945188e-05j)
    >>> hmath.csc([2.14, 25, 33+5j])
    [1.1871825621413237, -7.555623550585948, (0.01347409494265443+0.00017889167746147676j)]
    """
    return div(1 , sin(_θ))

@__list
@__pow
@__memo
def sec(_θ : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return div(1 , cos(_θ))

@__list
@__pow
@__memo
def cot(_θ : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return div(1 , tan(_θ))

@__list
@__del_complex
@__pow
@__memo
def asin(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return -1j * ln(1j * _x + sqrt(1 - (_x ** 2)))

@__list
@__del_complex
@__pow
@__memo
def acos(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return -1j * ln(_x - 1j * sqrt(1 - (_x ** 2)))

@__list
@__del_complex
@__pow
@__memo
def atan(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return 1j * (ln(1 - _x * 1j) - ln(1 + _x * 1j)) / 2

@__list
@__del_complex
@__pow
@__memo
def acsc(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return asin(div(1 , _x))

@__list
@__pow
@__memo
def asec(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return acos(div(1 , _x))

@__list
@__pow
@__memo
def acot(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return atan(div(1 , _x))

@__list
@__pow
@__memo
def sinh(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return (exp(_x) - exp(-_x)) / 2

@__list
@__pow
@__memo
def cosh(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return (exp(_x) + exp(-_x)) / 2

@__list
@__pow
@__memo
def tanh(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return sinh(_x) / cosh(_x)

@__list
@__pow
@__memo
def csch(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return 1 / sinh(_x)

@__list
@__pow
@__memo
def sech(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return 1 / cosh(_x)

@__list
@__pow
@__memo
def coth(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return 1 / tanh(_x)

@__list
@__pow
@__memo
def asinh(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return ln(_x + sqrt((_x ** 2) + 1))

@__list
@__pow
@__memo
def acosh(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return ln(_x + sqrt((_x + 1) * (_x - 1)))

@__list
@__pow
@__memo
def atanh(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return ln((1 + _x) / (1 - _x)) / 2

@__list
@__pow
@__memo
def acsch(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return asinh(1 / _x)

@__list
@__pow
@__memo
def asech(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return acosh(1 / _x)

@__list
@__pow
@__memo
def acoth(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return atanh(1 / _x)

@__list
def radian(_θ) -> int or float or complex or dimension or fract or array or list:
    return _θ / 57.295779513082320876798154814105

@__list
def degrees(_θ) -> int or float or complex or dimension or fract or array or list:
    return _θ * 57.295779513082320876798154814105

@__list
@__pow
@__memo
def diganma(_x : int or float or complex or dimension or fract or array or list, _n : int or str = 0) -> int or float or complex or dimension or fract or array or list:
    return Gamma(_x, "d") / Gamma(_x)

π = pi
τ = tau
φ = phi
γ = gamma
ζ = zeta
Γ = Gamma

try:
    memo_plk = open("%smemo.plk" %directory, "r", encoding='UTF-8')
    __corresponding_dictionary = load(memo_plk)
    memo_plk.close()
except:
    __corresponding_dictionary = {"B":{},"ln":{},"rad":{},"exp":{},"sin":{},"cos":{},"tan":{},"csc":{},"sec":{},"cot":{},"log":{},"log2":{},"zeta":{},"asin":{},"acos":{},"atan":{},"acsc":{},"asec":{},"acot":{},"sinh":{},"cosh":{},"tanh":{},"csch":{},"sech":{},"coth":{},"cube":{},"sqrt":{},"log10":{},"asinh":{},"acosh":{},"atanh":{},"acsch":{},"asech":{},"acoth":{},"Gamma":{},"diganma":{},"radical":{},"factorial":{},"reduct_fract":{},"prime_test":{},"prime_fact":{}}

directory = f"P:\python\hmath\packaging_tutorial\hmath\hmath"