r"""

Networks
########

**Obtain Network Representations**

Contains functions for analysing images as pore networks.

.. currentmodule:: porespy

.. autosummary::
   :template: mybase.rst
   :toctree: generated/

   networks.add_boundary_regions
   networks.generate_voxel_image
   networks.label_phases
   network.label_boundaries
   networks.map_to_regions
   networks.maximal_ball
   networks.regions_to_network
   networks.snow2

"""

from ._funcs import add_boundary_regions
from ._funcs import generate_voxel_image
from ._funcs import label_phases
from ._funcs import label_boundaries
from ._funcs import map_to_regions
from ._maximal_ball import maximal_ball_wrapper
from ._getnet import regions_to_network
from ._snow2 import snow2
from ._utils import _net_dict
from ._snow2 import _parse_pad_width
