import sys
import os.path
from PyQt5.QtWidgets import QMainWindow, QApplication
from PyQt5.QtCore    import QCoreApplication
from PDielec.GUI.NoteBook import NoteBook
import PDielec.Utilities  as Utilities
import PDielec.__init__
version = PDielec.__init__.__version__

class App(QMainWindow):

    def __init__(self, args, progressbar):
        super().__init__()
        program = ''
        filename = ''
        spreadsheet = ''
        exit = False
        self.debug = False
        self.scripting = False
        nosplash = False
        self.scriptname = ''
        # Manage options
        tokens = args[1:]
        ntokens = len(tokens)
        itoken = 0
        ncpus = 0
        threading = False
        # Look at the environment to see if the number of cpus is specified
        token = os.getenv('PDIELEC_NUM_PROCESSORS')
        if token is not None:
            ncpus = int(token)
        else:
            ncpus = 0
        # Look at the environment to see if the number of threading is specified
        token = os.getenv('PDIELEC_THREADING')
        if token is not None:
            if token == 'FALSE' or token == 'false':
                threading = False
            else:
                threading = True
        else:
            threading = False
        parameters = []
        # Process any instructions on the input line
        while itoken < ntokens:
            token = tokens[itoken]
            if token == '-d' or token == '-debug' or token == '--debug':
                self.debug = True
            elif token == '-nosplash' or token == '--nosplash':
                nosplash = True
            elif token == '-exit' or token == '--exit' or token == '-quit' or token == '--quit':
                exit = True
            elif token == '-script' or token == '--script':
                itoken += 1
                self.scripting = True
                self.scriptname = tokens[itoken]
            elif token == '-spreadsheet' or token == '--spreadsheet':
                itoken += 1
                spreadsheet = tokens[itoken]
            elif token == '-threading' or token == '--threading' or token == '-threads' or token == '--threads':
                threading = True
            elif token == '-cpus' or token == '--cpus':
                itoken += 1
                ncpus = int(tokens[itoken])
            elif token[0:0] == '-' or token == '-h' or token == '-help' or token == '--help':
                print('pdgui - graphical user interface to the PDielec package')
                print('pdgui [-help] [-debug] [program] filename [spreadsheet] [-script scriptname] [-nosplash] [-threading] [-cpus 0] [-version] [-exit]')
                exit()
            else:
                parameters.append(token)
            itoken += 1
        #
        # Lets see how many command line parameters there were
        #
        if len(parameters) == 0:
            pass
        elif len(parameters) == 1:
            filename = parameters[0]
            program = Utilities.find_program_from_name(filename)
        elif len(parameters) == 2:
            program = parameters[0]
            filename = parameters[1]
        elif len(parameters) == 3:
            program = parameters[0]
            filename = parameters[1]
            spreadsheet = parameters[2]
        else:
            print('Command line error',parameters)
            print('pdgui [-help] [-debug] [program] filename [spreadsheet] [-script scriptname] [-nosplash] [-threading] [-cpus 0] [-version] [-exit]')
        #
        # Continue
        #
        self.title = 'PDGui - Using PDielec library {} '.format(version)
        self.left = 10
        self.top = 30
        self.width = 500
        self.height = 800
        self.setWindowTitle(self.title)
        self.setGeometry(self.left, self.top, self.width, self.height)
        QCoreApplication.processEvents()
        if self.debug:
            print('About to open the notebook')
            print('Program is', program)
            print('Filename is', filename)
            print('Spreadsheet is', spreadsheet)
            print('Script is', self.scriptname)
            print('No. of cpus is', ncpus)
            print('Threading is', threading)
        self.notebook = NoteBook(self, program, filename, spreadsheet, scripting=self.scripting, progressbar=progressbar, debug=self.debug, ncpus=ncpus, threading=threading)
        self.setCentralWidget(self.notebook)
        if self.scripting:
            if self.debug:
                print('Processing script',self.scriptname)
            self.readScript(self.scriptname)
        if exit:
            if self.notebook.spreadsheet is not None:
                if self.debug:
                    print('Closing spreadsheeet on exit',self.scriptname)
                self.notebook.write_spreadsheet()
                self.notebook.spreadsheet.close()
            sys.exit()
        #self.show()

    def readScript(self,scriptname):
        self.notebook.scripting = True
        with open(scriptname,'r') as fd:
            exec(fd.read())
        self.notebook.scripting = False
        self.notebook.refresh()
        QCoreApplication.processEvents()

    def closeEvent(self, event):
        # Make sure any spread sheet is closed
        self.notebook.write_spreadsheet()
        if self.debug:
            print('Close event has been captured')
        if self.notebook.spreadsheet is not None:
            self.notebook.spreadsheet.close()
        else:
            if self.debug:
                print('Spreadsheet was not set')
        super(App, self).closeEvent(event)

if __name__ == '__main__':
    app = QApplication(sys.argv)
    ex = App(sys.argv)
    ex.show()
    sys.exit(app.exec_())
