# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.model_deployment_spec import ModelDeploymentSpec  # noqa: F401,E501
from odahuflow.sdk.models.model_deployment_status import ModelDeploymentStatus  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelDeployment(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, id: str=None, spec: ModelDeploymentSpec=None, status: ModelDeploymentStatus=None):  # noqa: E501
        """ModelDeployment - a model defined in Swagger

        :param id: The id of this ModelDeployment.  # noqa: E501
        :type id: str
        :param spec: The spec of this ModelDeployment.  # noqa: E501
        :type spec: ModelDeploymentSpec
        :param status: The status of this ModelDeployment.  # noqa: E501
        :type status: ModelDeploymentStatus
        """
        self.swagger_types = {
            'id': str,
            'spec': ModelDeploymentSpec,
            'status': ModelDeploymentStatus
        }

        self.attribute_map = {
            'id': 'id',
            'spec': 'spec',
            'status': 'status'
        }

        self._id = id
        self._spec = spec
        self._status = status

    @classmethod
    def from_dict(cls, dikt) -> 'ModelDeployment':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelDeployment of this ModelDeployment.  # noqa: E501
        :rtype: ModelDeployment
        """
        return util.deserialize_model(dikt, cls)

    @property
    def id(self) -> str:
        """Gets the id of this ModelDeployment.

        Model deployment id  # noqa: E501

        :return: The id of this ModelDeployment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str):
        """Sets the id of this ModelDeployment.

        Model deployment id  # noqa: E501

        :param id: The id of this ModelDeployment.
        :type id: str
        """

        self._id = id

    @property
    def spec(self) -> ModelDeploymentSpec:
        """Gets the spec of this ModelDeployment.

        Model deployment specification  # noqa: E501

        :return: The spec of this ModelDeployment.
        :rtype: ModelDeploymentSpec
        """
        return self._spec

    @spec.setter
    def spec(self, spec: ModelDeploymentSpec):
        """Sets the spec of this ModelDeployment.

        Model deployment specification  # noqa: E501

        :param spec: The spec of this ModelDeployment.
        :type spec: ModelDeploymentSpec
        """

        self._spec = spec

    @property
    def status(self) -> ModelDeploymentStatus:
        """Gets the status of this ModelDeployment.

        Model deployment status  # noqa: E501

        :return: The status of this ModelDeployment.
        :rtype: ModelDeploymentStatus
        """
        return self._status

    @status.setter
    def status(self, status: ModelDeploymentStatus):
        """Sets the status of this ModelDeployment.

        Model deployment status  # noqa: E501

        :param status: The status of this ModelDeployment.
        :type status: ModelDeploymentStatus
        """

        self._status = status
