"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * (experimental) A VPC endpoint service.
 *
 * @experimental
 * @resource AWS::EC2::VPCEndpointService
 */
class VpcEndpointService extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b, _c;
        super(scope, id);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = (_a = props.acceptanceRequired) !== null && _a !== void 0 ? _a : true;
        this.whitelistedPrincipals = (_b = props.whitelistedPrincipals) !== null && _b !== void 0 ? _b : [];
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ?
            ((_c = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _c !== void 0 ? _c : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX) :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.whitelistedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.whitelistedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
//# sourceMappingURL=data:application/json;base64,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