yarabuilder
======

Python module to create Yara rules.

Installation
------------

yarabuilder requires Python 3+

Install with pip locally

    pip install .
	
Usage
-----

    >>> import yarabuilder
    >>> yara_builder = yarabuilder.YaraBuilder()
	>>>
    >>> yara_builder.create_rule("my_rule")
    >>> yara_builder.add_meta("my_rule", "description", "Generated by yarabuilder")
    >>> yara_builder.add_import("my_rule", "pe")
    >>> yara_builder.add_tag("my_rule", "yarabuilder")
	>>> yara_builder.add_text_string("my_rule", "Anonymous string")
	>>> yara_builder.add_text_string("my_rule", "Named string", name="str", modifiers=["ascii", "wide"])
	>>> yara_builder.add_hex_string("my_rule", "DE AD BE EF")
	>>> yara_builder.add_regex_string("my_rule", "regex[0-9]{2}")
	>>> yara_builder.add_condition("my_rule", "any of them")
    >>>
    >>> rule = yara_builder.build_rules()
    >>> print(rule)
    import "pe"

    rule my_rule : yarabuilder {
        meta:
            description = "Generated by yarabuilder"

        strings:
            $ = "Anonymous string"
            $str = "Named string" ascii wide
            $ = {DE AD BE EF}
            $ = /regex[0-9]{2}/

        condition:
            any of them
    }
    >>>

TODO
----
- Add to PyPI
- Improve documentation
- Add the capability to add comments to YARA rules
