# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Any, Dict


class AclEntryConfig(TeaModel):
    def __init__(
        self,
        entry: str = None,
    ):
        # This parameter is required.
        self.entry = entry

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entry is not None:
            result['entry'] = self.entry
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('entry') is not None:
            self.entry = m.get('entry')
        return self


class AclConfig(TeaModel):
    def __init__(
        self,
        acl_entries: List[AclEntryConfig] = None,
    ):
        # This parameter is required.
        self.acl_entries = acl_entries

    def validate(self):
        if self.acl_entries:
            for k in self.acl_entries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['aclEntries'] = []
        if self.acl_entries is not None:
            for k in self.acl_entries:
                result['aclEntries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.acl_entries = []
        if m.get('aclEntries') is not None:
            for k in m.get('aclEntries'):
                temp_model = AclEntryConfig()
                self.acl_entries.append(temp_model.from_map(k))
        return self


class AppStackInstanceEndpoints(TeaModel):
    def __init__(
        self,
        address: str = None,
        name: str = None,
        protocol: str = None,
    ):
        self.address = address
        self.name = name
        self.protocol = protocol

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.address is not None:
            result['Address'] = self.address
        if self.name is not None:
            result['Name'] = self.name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Address') is not None:
            self.address = m.get('Address')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        return self


class AppStackInstanceParameters(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class AppStackInstance(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        endpoints: List[AppStackInstanceEndpoints] = None,
        instance_id: str = None,
        instance_name: str = None,
        parameters: List[AppStackInstanceParameters] = None,
        stack_id: str = None,
        status: str = None,
        update_time: int = None,
    ):
        self.create_time = create_time
        self.endpoints = endpoints
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.parameters = parameters
        self.stack_id = stack_id
        self.status = status
        self.update_time = update_time

    def validate(self):
        if self.endpoints:
            for k in self.endpoints:
                if k:
                    k.validate()
        if self.parameters:
            for k in self.parameters:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        result['Endpoints'] = []
        if self.endpoints is not None:
            for k in self.endpoints:
                result['Endpoints'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        result['Parameters'] = []
        if self.parameters is not None:
            for k in self.parameters:
                result['Parameters'].append(k.to_map() if k else None)
        if self.stack_id is not None:
            result['StackId'] = self.stack_id
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        self.endpoints = []
        if m.get('Endpoints') is not None:
            for k in m.get('Endpoints'):
                temp_model = AppStackInstanceEndpoints()
                self.endpoints.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        self.parameters = []
        if m.get('Parameters') is not None:
            for k in m.get('Parameters'):
                temp_model = AppStackInstanceParameters()
                self.parameters.append(temp_model.from_map(k))
        if m.get('StackId') is not None:
            self.stack_id = m.get('StackId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class AppStackResource(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        instance_id: str = None,
        product_code: str = None,
        resource_id: str = None,
        resource_name: str = None,
        resource_type: str = None,
        stack_id: str = None,
        status: str = None,
    ):
        self.create_time = create_time
        self.instance_id = instance_id
        self.product_code = product_code
        self.resource_id = resource_id
        self.resource_name = resource_name
        self.resource_type = resource_type
        self.stack_id = stack_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.product_code is not None:
            result['ProductCode'] = self.product_code
        if self.resource_id is not None:
            result['ResourceId'] = self.resource_id
        if self.resource_name is not None:
            result['ResourceName'] = self.resource_name
        if self.resource_type is not None:
            result['ResourceType'] = self.resource_type
        if self.stack_id is not None:
            result['StackId'] = self.stack_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProductCode') is not None:
            self.product_code = m.get('ProductCode')
        if m.get('ResourceId') is not None:
            self.resource_id = m.get('ResourceId')
        if m.get('ResourceName') is not None:
            self.resource_name = m.get('ResourceName')
        if m.get('ResourceType') is not None:
            self.resource_type = m.get('ResourceType')
        if m.get('StackId') is not None:
            self.stack_id = m.get('StackId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class AppStackTaskSteps(TeaModel):
    def __init__(
        self,
        code: str = None,
        duration: int = None,
        end_time: int = None,
        id: str = None,
        message: str = None,
        name: str = None,
        start_time: int = None,
        status: str = None,
    ):
        self.code = code
        self.duration = duration
        self.end_time = end_time
        self.id = id
        self.message = message
        self.name = name
        self.start_time = start_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.message is not None:
            result['Message'] = self.message
        if self.name is not None:
            result['Name'] = self.name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class AppStackTask(TeaModel):
    def __init__(
        self,
        create_time: int = None,
        end_time: int = None,
        instance_id: str = None,
        stack_id: str = None,
        start_time: int = None,
        status: str = None,
        steps: List[AppStackTaskSteps] = None,
        task_id: str = None,
    ):
        self.create_time = create_time
        self.end_time = end_time
        self.instance_id = instance_id
        self.stack_id = stack_id
        self.start_time = start_time
        self.status = status
        self.steps = steps
        self.task_id = task_id

    def validate(self):
        if self.steps:
            for k in self.steps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.stack_id is not None:
            result['StackId'] = self.stack_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        result['Steps'] = []
        if self.steps is not None:
            for k in self.steps:
                result['Steps'].append(k.to_map() if k else None)
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('StackId') is not None:
            self.stack_id = m.get('StackId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.steps = []
        if m.get('Steps') is not None:
            for k in m.get('Steps'):
                temp_model = AppStackTaskSteps()
                self.steps.append(temp_model.from_map(k))
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DNSOption(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class CustomDNS(TeaModel):
    def __init__(
        self,
        dns_options: List[DNSOption] = None,
        name_servers: List[str] = None,
        searches: List[str] = None,
    ):
        self.dns_options = dns_options
        self.name_servers = name_servers
        self.searches = searches

    def validate(self):
        if self.dns_options:
            for k in self.dns_options:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['dnsOptions'] = []
        if self.dns_options is not None:
            for k in self.dns_options:
                result['dnsOptions'].append(k.to_map() if k else None)
        if self.name_servers is not None:
            result['nameServers'] = self.name_servers
        if self.searches is not None:
            result['searches'] = self.searches
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.dns_options = []
        if m.get('dnsOptions') is not None:
            for k in m.get('dnsOptions'):
                temp_model = DNSOption()
                self.dns_options.append(temp_model.from_map(k))
        if m.get('nameServers') is not None:
            self.name_servers = m.get('nameServers')
        if m.get('searches') is not None:
            self.searches = m.get('searches')
        return self


class CustomHealthCheckConfig(TeaModel):
    def __init__(
        self,
        failure_threshold: int = None,
        http_get_url: str = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        success_threshold: int = None,
        timeout_seconds: int = None,
    ):
        self.failure_threshold = failure_threshold
        self.http_get_url = http_get_url
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.success_threshold = success_threshold
        self.timeout_seconds = timeout_seconds

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_threshold is not None:
            result['failureThreshold'] = self.failure_threshold
        if self.http_get_url is not None:
            result['httpGetUrl'] = self.http_get_url
        if self.initial_delay_seconds is not None:
            result['initialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['periodSeconds'] = self.period_seconds
        if self.success_threshold is not None:
            result['successThreshold'] = self.success_threshold
        if self.timeout_seconds is not None:
            result['timeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('failureThreshold') is not None:
            self.failure_threshold = m.get('failureThreshold')
        if m.get('httpGetUrl') is not None:
            self.http_get_url = m.get('httpGetUrl')
        if m.get('initialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('initialDelaySeconds')
        if m.get('periodSeconds') is not None:
            self.period_seconds = m.get('periodSeconds')
        if m.get('successThreshold') is not None:
            self.success_threshold = m.get('successThreshold')
        if m.get('timeoutSeconds') is not None:
            self.timeout_seconds = m.get('timeoutSeconds')
        return self


class HostAlias(TeaModel):
    def __init__(
        self,
        hostnames: List[str] = None,
        ip: str = None,
    ):
        self.hostnames = hostnames
        self.ip = ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hostnames is not None:
            result['hostnames'] = self.hostnames
        if self.ip is not None:
            result['ip'] = self.ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('hostnames') is not None:
            self.hostnames = m.get('hostnames')
        if m.get('ip') is not None:
            self.ip = m.get('ip')
        return self


class CustomHostAlias(TeaModel):
    def __init__(
        self,
        host_aliases: List[HostAlias] = None,
    ):
        self.host_aliases = host_aliases

    def validate(self):
        if self.host_aliases:
            for k in self.host_aliases:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['hostAliases'] = []
        if self.host_aliases is not None:
            for k in self.host_aliases:
                result['hostAliases'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.host_aliases = []
        if m.get('hostAliases') is not None:
            for k in m.get('hostAliases'):
                temp_model = HostAlias()
                self.host_aliases.append(temp_model.from_map(k))
        return self


class CustomRuntimeConfig(TeaModel):
    def __init__(
        self,
        args: List[str] = None,
        command: List[str] = None,
    ):
        self.args = args
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.command is not None:
            result['command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('command') is not None:
            self.command = m.get('command')
        return self


class HTTPTriggerConfig(TeaModel):
    def __init__(
        self,
        acl_config: AclConfig = None,
        auth_config: Any = None,
        auth_type: str = None,
        disable_urlinternet: bool = None,
        safe_mode: bool = None,
    ):
        self.acl_config = acl_config
        self.auth_config = auth_config
        self.auth_type = auth_type
        self.disable_urlinternet = disable_urlinternet
        self.safe_mode = safe_mode

    def validate(self):
        if self.acl_config:
            self.acl_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acl_config is not None:
            result['aclConfig'] = self.acl_config.to_map()
        if self.auth_config is not None:
            result['authConfig'] = self.auth_config
        if self.auth_type is not None:
            result['authType'] = self.auth_type
        if self.disable_urlinternet is not None:
            result['disableURLInternet'] = self.disable_urlinternet
        if self.safe_mode is not None:
            result['safeMode'] = self.safe_mode
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('aclConfig') is not None:
            temp_model = AclConfig()
            self.acl_config = temp_model.from_map(m['aclConfig'])
        if m.get('authConfig') is not None:
            self.auth_config = m.get('authConfig')
        if m.get('authType') is not None:
            self.auth_type = m.get('authType')
        if m.get('disableURLInternet') is not None:
            self.disable_urlinternet = m.get('disableURLInternet')
        if m.get('safeMode') is not None:
            self.safe_mode = m.get('safeMode')
        return self


class ImageConfig(TeaModel):
    def __init__(
        self,
        acceleration_type: str = None,
        image: str = None,
        instance_id: str = None,
    ):
        self.acceleration_type = acceleration_type
        self.image = image
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acceleration_type is not None:
            result['accelerationType'] = self.acceleration_type
        if self.image is not None:
            result['image'] = self.image
        if self.instance_id is not None:
            result['instanceID'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accelerationType') is not None:
            self.acceleration_type = m.get('accelerationType')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('instanceID') is not None:
            self.instance_id = m.get('instanceID')
        return self


class LifecycleHook(TeaModel):
    def __init__(
        self,
        handler: str = None,
        timeout: int = None,
    ):
        self.handler = handler
        self.timeout = timeout

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.handler is not None:
            result['handler'] = self.handler
        if self.timeout is not None:
            result['timeout'] = self.timeout
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('handler') is not None:
            self.handler = m.get('handler')
        if m.get('timeout') is not None:
            self.timeout = m.get('timeout')
        return self


class InstanceLifecycleConfig(TeaModel):
    def __init__(
        self,
        pre_freeze: LifecycleHook = None,
        pre_stop: LifecycleHook = None,
    ):
        self.pre_freeze = pre_freeze
        self.pre_stop = pre_stop

    def validate(self):
        if self.pre_freeze:
            self.pre_freeze.validate()
        if self.pre_stop:
            self.pre_stop.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pre_freeze is not None:
            result['preFreeze'] = self.pre_freeze.to_map()
        if self.pre_stop is not None:
            result['preStop'] = self.pre_stop.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('preFreeze') is not None:
            temp_model = LifecycleHook()
            self.pre_freeze = temp_model.from_map(m['preFreeze'])
        if m.get('preStop') is not None:
            temp_model = LifecycleHook()
            self.pre_stop = temp_model.from_map(m['preStop'])
        return self


class ProbeProbeHandlerHttpGetHttpHeaders(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ProbeProbeHandlerHttpGet(TeaModel):
    def __init__(
        self,
        http_headers: List[ProbeProbeHandlerHttpGetHttpHeaders] = None,
        path: str = None,
        port: int = None,
    ):
        self.http_headers = http_headers
        self.path = path
        self.port = port

    def validate(self):
        if self.http_headers:
            for k in self.http_headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['httpHeaders'] = []
        if self.http_headers is not None:
            for k in self.http_headers:
                result['httpHeaders'].append(k.to_map() if k else None)
        if self.path is not None:
            result['path'] = self.path
        if self.port is not None:
            result['port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.http_headers = []
        if m.get('httpHeaders') is not None:
            for k in m.get('httpHeaders'):
                temp_model = ProbeProbeHandlerHttpGetHttpHeaders()
                self.http_headers.append(temp_model.from_map(k))
        if m.get('path') is not None:
            self.path = m.get('path')
        if m.get('port') is not None:
            self.port = m.get('port')
        return self


class ProbeProbeHandlerTcpSocket(TeaModel):
    def __init__(
        self,
        port: int = None,
    ):
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('port') is not None:
            self.port = m.get('port')
        return self


class ProbeProbeHandler(TeaModel):
    def __init__(
        self,
        http_get: ProbeProbeHandlerHttpGet = None,
        tcp_socket: ProbeProbeHandlerTcpSocket = None,
    ):
        self.http_get = http_get
        self.tcp_socket = tcp_socket

    def validate(self):
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_get is not None:
            result['httpGet'] = self.http_get.to_map()
        if self.tcp_socket is not None:
            result['tcpSocket'] = self.tcp_socket.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('httpGet') is not None:
            temp_model = ProbeProbeHandlerHttpGet()
            self.http_get = temp_model.from_map(m['httpGet'])
        if m.get('tcpSocket') is not None:
            temp_model = ProbeProbeHandlerTcpSocket()
            self.tcp_socket = temp_model.from_map(m['tcpSocket'])
        return self


class Probe(TeaModel):
    def __init__(
        self,
        failure_threshold: int = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        probe_handler: ProbeProbeHandler = None,
        timeout_seconds: int = None,
    ):
        self.failure_threshold = failure_threshold
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.probe_handler = probe_handler
        self.timeout_seconds = timeout_seconds

    def validate(self):
        if self.probe_handler:
            self.probe_handler.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_threshold is not None:
            result['failureThreshold'] = self.failure_threshold
        if self.initial_delay_seconds is not None:
            result['initialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['periodSeconds'] = self.period_seconds
        if self.probe_handler is not None:
            result['probeHandler'] = self.probe_handler.to_map()
        if self.timeout_seconds is not None:
            result['timeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('failureThreshold') is not None:
            self.failure_threshold = m.get('failureThreshold')
        if m.get('initialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('initialDelaySeconds')
        if m.get('periodSeconds') is not None:
            self.period_seconds = m.get('periodSeconds')
        if m.get('probeHandler') is not None:
            temp_model = ProbeProbeHandler()
            self.probe_handler = temp_model.from_map(m['probeHandler'])
        if m.get('timeoutSeconds') is not None:
            self.timeout_seconds = m.get('timeoutSeconds')
        return self


class LogConfig(TeaModel):
    def __init__(
        self,
        enable_instance_metrics: bool = None,
        enable_request_metrics: bool = None,
        log_begin_rule: str = None,
        logstore: str = None,
        project: str = None,
        push_to_user_sls: bool = None,
    ):
        self.enable_instance_metrics = enable_instance_metrics
        self.enable_request_metrics = enable_request_metrics
        self.log_begin_rule = log_begin_rule
        self.logstore = logstore
        self.project = project
        self.push_to_user_sls = push_to_user_sls

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_instance_metrics is not None:
            result['enableInstanceMetrics'] = self.enable_instance_metrics
        if self.enable_request_metrics is not None:
            result['enableRequestMetrics'] = self.enable_request_metrics
        if self.log_begin_rule is not None:
            result['logBeginRule'] = self.log_begin_rule
        if self.logstore is not None:
            result['logstore'] = self.logstore
        if self.project is not None:
            result['project'] = self.project
        if self.push_to_user_sls is not None:
            result['pushToUserSLS'] = self.push_to_user_sls
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableInstanceMetrics') is not None:
            self.enable_instance_metrics = m.get('enableInstanceMetrics')
        if m.get('enableRequestMetrics') is not None:
            self.enable_request_metrics = m.get('enableRequestMetrics')
        if m.get('logBeginRule') is not None:
            self.log_begin_rule = m.get('logBeginRule')
        if m.get('logstore') is not None:
            self.logstore = m.get('logstore')
        if m.get('project') is not None:
            self.project = m.get('project')
        if m.get('pushToUserSLS') is not None:
            self.push_to_user_sls = m.get('pushToUserSLS')
        return self


class NASMountConfig(TeaModel):
    def __init__(
        self,
        enable_tls: bool = None,
        mount_dir: str = None,
        server_addr: str = None,
    ):
        self.enable_tls = enable_tls
        self.mount_dir = mount_dir
        self.server_addr = server_addr

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_tls is not None:
            result['enableTLS'] = self.enable_tls
        if self.mount_dir is not None:
            result['mountDir'] = self.mount_dir
        if self.server_addr is not None:
            result['serverAddr'] = self.server_addr
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableTLS') is not None:
            self.enable_tls = m.get('enableTLS')
        if m.get('mountDir') is not None:
            self.mount_dir = m.get('mountDir')
        if m.get('serverAddr') is not None:
            self.server_addr = m.get('serverAddr')
        return self


class NASConfig(TeaModel):
    def __init__(
        self,
        mount_points: List[NASMountConfig] = None,
    ):
        self.mount_points = mount_points

    def validate(self):
        if self.mount_points:
            for k in self.mount_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['mountPoints'] = []
        if self.mount_points is not None:
            for k in self.mount_points:
                result['mountPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mount_points = []
        if m.get('mountPoints') is not None:
            for k in m.get('mountPoints'):
                temp_model = NASMountConfig()
                self.mount_points.append(temp_model.from_map(k))
        return self


class OSSMountPoint(TeaModel):
    def __init__(
        self,
        bucket_name: str = None,
        bucket_path: str = None,
        mount_dir: str = None,
        read_only: bool = None,
    ):
        self.bucket_name = bucket_name
        self.bucket_path = bucket_path
        self.mount_dir = mount_dir
        self.read_only = read_only

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['bucketName'] = self.bucket_name
        if self.bucket_path is not None:
            result['bucketPath'] = self.bucket_path
        if self.mount_dir is not None:
            result['mountDir'] = self.mount_dir
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bucketName') is not None:
            self.bucket_name = m.get('bucketName')
        if m.get('bucketPath') is not None:
            self.bucket_path = m.get('bucketPath')
        if m.get('mountDir') is not None:
            self.mount_dir = m.get('mountDir')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class OSSMountConfig(TeaModel):
    def __init__(
        self,
        mount_points: List[OSSMountPoint] = None,
    ):
        self.mount_points = mount_points

    def validate(self):
        if self.mount_points:
            for k in self.mount_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['mountPoints'] = []
        if self.mount_points is not None:
            for k in self.mount_points:
                result['mountPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mount_points = []
        if m.get('mountPoints') is not None:
            for k in m.get('mountPoints'):
                temp_model = OSSMountPoint()
                self.mount_points.append(temp_model.from_map(k))
        return self


class ScaleConfig(TeaModel):
    def __init__(
        self,
        always_allocate_cpu: bool = None,
        maximum_instance_count: int = None,
        minimum_instance_count: int = None,
        request_id: str = None,
    ):
        self.always_allocate_cpu = always_allocate_cpu
        self.maximum_instance_count = maximum_instance_count
        self.minimum_instance_count = minimum_instance_count
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.always_allocate_cpu is not None:
            result['alwaysAllocateCPU'] = self.always_allocate_cpu
        if self.maximum_instance_count is not None:
            result['maximumInstanceCount'] = self.maximum_instance_count
        if self.minimum_instance_count is not None:
            result['minimumInstanceCount'] = self.minimum_instance_count
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alwaysAllocateCPU') is not None:
            self.always_allocate_cpu = m.get('alwaysAllocateCPU')
        if m.get('maximumInstanceCount') is not None:
            self.maximum_instance_count = m.get('maximumInstanceCount')
        if m.get('minimumInstanceCount') is not None:
            self.minimum_instance_count = m.get('minimumInstanceCount')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class SLSConfigCollectConfigs(TeaModel):
    def __init__(
        self,
        log_path: str = None,
        log_type: str = None,
        logstore_name: str = None,
        logtail_name: str = None,
        project_name: str = None,
    ):
        self.log_path = log_path
        self.log_type = log_type
        self.logstore_name = logstore_name
        self.logtail_name = logtail_name
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_path is not None:
            result['logPath'] = self.log_path
        if self.log_type is not None:
            result['logType'] = self.log_type
        if self.logstore_name is not None:
            result['logstoreName'] = self.logstore_name
        if self.logtail_name is not None:
            result['logtailName'] = self.logtail_name
        if self.project_name is not None:
            result['projectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logPath') is not None:
            self.log_path = m.get('logPath')
        if m.get('logType') is not None:
            self.log_type = m.get('logType')
        if m.get('logstoreName') is not None:
            self.logstore_name = m.get('logstoreName')
        if m.get('logtailName') is not None:
            self.logtail_name = m.get('logtailName')
        if m.get('projectName') is not None:
            self.project_name = m.get('projectName')
        return self


class SLSConfig(TeaModel):
    def __init__(
        self,
        collect_configs: List[SLSConfigCollectConfigs] = None,
    ):
        self.collect_configs = collect_configs

    def validate(self):
        if self.collect_configs:
            for k in self.collect_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['collectConfigs'] = []
        if self.collect_configs is not None:
            for k in self.collect_configs:
                result['collectConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.collect_configs = []
        if m.get('collectConfigs') is not None:
            for k in m.get('collectConfigs'):
                temp_model = SLSConfigCollectConfigs()
                self.collect_configs.append(temp_model.from_map(k))
        return self


class JaegerConfig(TeaModel):
    def __init__(
        self,
        endpoint: str = None,
    ):
        self.endpoint = endpoint

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        return self


class TracingConfig(TeaModel):
    def __init__(
        self,
        jaeger_config: JaegerConfig = None,
        params: Any = None,
        type: str = None,
    ):
        self.jaeger_config = jaeger_config
        self.params = params
        self.type = type

    def validate(self):
        if self.jaeger_config:
            self.jaeger_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.jaeger_config is not None:
            result['jaegerConfig'] = self.jaeger_config.to_map()
        if self.params is not None:
            result['params'] = self.params
        if self.type is not None:
            result['type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('jaegerConfig') is not None:
            temp_model = JaegerConfig()
            self.jaeger_config = temp_model.from_map(m['jaegerConfig'])
        if m.get('params') is not None:
            self.params = m.get('params')
        if m.get('type') is not None:
            self.type = m.get('type')
        return self


class Version(TeaModel):
    def __init__(
        self,
        created_time: str = None,
        description: str = None,
        image: str = None,
        last_modified_time: str = None,
        request_id: str = None,
        version_id: str = None,
        weight: float = None,
    ):
        self.created_time = created_time
        self.description = description
        self.image = image
        self.last_modified_time = last_modified_time
        self.request_id = request_id
        self.version_id = version_id
        self.weight = weight

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_time is not None:
            result['createdTime'] = self.created_time
        if self.description is not None:
            result['description'] = self.description
        if self.image is not None:
            result['image'] = self.image
        if self.last_modified_time is not None:
            result['lastModifiedTime'] = self.last_modified_time
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.version_id is not None:
            result['versionId'] = self.version_id
        if self.weight is not None:
            result['weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createdTime') is not None:
            self.created_time = m.get('createdTime')
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('image') is not None:
            self.image = m.get('image')
        if m.get('lastModifiedTime') is not None:
            self.last_modified_time = m.get('lastModifiedTime')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('versionId') is not None:
            self.version_id = m.get('versionId')
        if m.get('weight') is not None:
            self.weight = m.get('weight')
        return self


class VPCConfig(TeaModel):
    def __init__(
        self,
        anytunnel_via_eni: bool = None,
        role: str = None,
        security_group_id: str = None,
        v_switch_ids: List[str] = None,
        vpc_id: str = None,
    ):
        self.anytunnel_via_eni = anytunnel_via_eni
        self.role = role
        self.security_group_id = security_group_id
        self.v_switch_ids = v_switch_ids
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.anytunnel_via_eni is not None:
            result['anytunnelViaENI'] = self.anytunnel_via_eni
        if self.role is not None:
            result['role'] = self.role
        if self.security_group_id is not None:
            result['securityGroupId'] = self.security_group_id
        if self.v_switch_ids is not None:
            result['vSwitchIds'] = self.v_switch_ids
        if self.vpc_id is not None:
            result['vpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('anytunnelViaENI') is not None:
            self.anytunnel_via_eni = m.get('anytunnelViaENI')
        if m.get('role') is not None:
            self.role = m.get('role')
        if m.get('securityGroupId') is not None:
            self.security_group_id = m.get('securityGroupId')
        if m.get('vSwitchIds') is not None:
            self.v_switch_ids = m.get('vSwitchIds')
        if m.get('vpcId') is not None:
            self.vpc_id = m.get('vpcId')
        return self


class Application(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        application_id: str = None,
        application_name: str = None,
        args: str = None,
        ca_port: int = None,
        code_checksum: str = None,
        code_size: int = None,
        command: str = None,
        cpu: float = None,
        created_time: str = None,
        custom_dns: CustomDNS = None,
        custom_domain_name: str = None,
        custom_health_check_config: CustomHealthCheckConfig = None,
        custom_host_alias: CustomHostAlias = None,
        custom_runtime_config: CustomRuntimeConfig = None,
        description: str = None,
        disk_size: int = None,
        enable_app_metric: bool = None,
        enable_arms_advanced: bool = None,
        environment_variables: Dict[str, str] = None,
        gpu_memory_size: int = None,
        handler: str = None,
        http_trigger_config: HTTPTriggerConfig = None,
        image_config: ImageConfig = None,
        initialization_timeout: int = None,
        initializer: str = None,
        instance_concurrency: int = None,
        instance_lifecycle_config: InstanceLifecycleConfig = None,
        instance_soft_concurrency: int = None,
        instance_type: str = None,
        internet_access: bool = None,
        last_modified_time: str = None,
        layers: List[str] = None,
        layers_arn_v2: List[str] = None,
        liveness_probe: Probe = None,
        log_config: LogConfig = None,
        memory_size: int = None,
        namespace: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
        nas_config: NASConfig = None,
        oss_mount_config: OSSMountConfig = None,
        runtime: str = None,
        scale_config: ScaleConfig = None,
        sls_config: SLSConfig = None,
        startup_probe: Probe = None,
        timeout: int = None,
        tracing_config: TracingConfig = None,
        url_internet: str = None,
        url_intranet: str = None,
        version: Version = None,
        vpc_config: VPCConfig = None,
    ):
        self.request_id = request_id
        self.application_id = application_id
        self.application_name = application_name
        self.args = args
        self.ca_port = ca_port
        self.code_checksum = code_checksum
        self.code_size = code_size
        self.command = command
        self.cpu = cpu
        self.created_time = created_time
        self.custom_dns = custom_dns
        self.custom_domain_name = custom_domain_name
        self.custom_health_check_config = custom_health_check_config
        self.custom_host_alias = custom_host_alias
        self.custom_runtime_config = custom_runtime_config
        self.description = description
        self.disk_size = disk_size
        self.enable_app_metric = enable_app_metric
        self.enable_arms_advanced = enable_arms_advanced
        self.environment_variables = environment_variables
        self.gpu_memory_size = gpu_memory_size
        self.handler = handler
        self.http_trigger_config = http_trigger_config
        self.image_config = image_config
        self.initialization_timeout = initialization_timeout
        self.initializer = initializer
        self.instance_concurrency = instance_concurrency
        self.instance_lifecycle_config = instance_lifecycle_config
        self.instance_soft_concurrency = instance_soft_concurrency
        self.instance_type = instance_type
        self.internet_access = internet_access
        self.last_modified_time = last_modified_time
        self.layers = layers
        self.layers_arn_v2 = layers_arn_v2
        self.liveness_probe = liveness_probe
        self.log_config = log_config
        self.memory_size = memory_size
        self.namespace = namespace
        self.namespace_id = namespace_id
        self.namespace_name = namespace_name
        self.nas_config = nas_config
        self.oss_mount_config = oss_mount_config
        self.runtime = runtime
        self.scale_config = scale_config
        self.sls_config = sls_config
        self.startup_probe = startup_probe
        self.timeout = timeout
        self.tracing_config = tracing_config
        self.url_internet = url_internet
        self.url_intranet = url_intranet
        self.version = version
        self.vpc_config = vpc_config

    def validate(self):
        if self.custom_dns:
            self.custom_dns.validate()
        if self.custom_health_check_config:
            self.custom_health_check_config.validate()
        if self.custom_host_alias:
            self.custom_host_alias.validate()
        if self.custom_runtime_config:
            self.custom_runtime_config.validate()
        if self.http_trigger_config:
            self.http_trigger_config.validate()
        if self.image_config:
            self.image_config.validate()
        if self.instance_lifecycle_config:
            self.instance_lifecycle_config.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        if self.log_config:
            self.log_config.validate()
        if self.nas_config:
            self.nas_config.validate()
        if self.oss_mount_config:
            self.oss_mount_config.validate()
        if self.scale_config:
            self.scale_config.validate()
        if self.sls_config:
            self.sls_config.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.tracing_config:
            self.tracing_config.validate()
        if self.version:
            self.version.validate()
        if self.vpc_config:
            self.vpc_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.application_id is not None:
            result['applicationId'] = self.application_id
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.args is not None:
            result['args'] = self.args
        if self.ca_port is not None:
            result['caPort'] = self.ca_port
        if self.code_checksum is not None:
            result['codeChecksum'] = self.code_checksum
        if self.code_size is not None:
            result['codeSize'] = self.code_size
        if self.command is not None:
            result['command'] = self.command
        if self.cpu is not None:
            result['cpu'] = self.cpu
        if self.created_time is not None:
            result['createdTime'] = self.created_time
        if self.custom_dns is not None:
            result['customDNS'] = self.custom_dns.to_map()
        if self.custom_domain_name is not None:
            result['customDomainName'] = self.custom_domain_name
        if self.custom_health_check_config is not None:
            result['customHealthCheckConfig'] = self.custom_health_check_config.to_map()
        if self.custom_host_alias is not None:
            result['customHostAlias'] = self.custom_host_alias.to_map()
        if self.custom_runtime_config is not None:
            result['customRuntimeConfig'] = self.custom_runtime_config.to_map()
        if self.description is not None:
            result['description'] = self.description
        if self.disk_size is not None:
            result['diskSize'] = self.disk_size
        if self.enable_app_metric is not None:
            result['enableAppMetric'] = self.enable_app_metric
        if self.enable_arms_advanced is not None:
            result['enableArmsAdvanced'] = self.enable_arms_advanced
        if self.environment_variables is not None:
            result['environmentVariables'] = self.environment_variables
        if self.gpu_memory_size is not None:
            result['gpuMemorySize'] = self.gpu_memory_size
        if self.handler is not None:
            result['handler'] = self.handler
        if self.http_trigger_config is not None:
            result['httpTriggerConfig'] = self.http_trigger_config.to_map()
        if self.image_config is not None:
            result['imageConfig'] = self.image_config.to_map()
        if self.initialization_timeout is not None:
            result['initializationTimeout'] = self.initialization_timeout
        if self.initializer is not None:
            result['initializer'] = self.initializer
        if self.instance_concurrency is not None:
            result['instanceConcurrency'] = self.instance_concurrency
        if self.instance_lifecycle_config is not None:
            result['instanceLifecycleConfig'] = self.instance_lifecycle_config.to_map()
        if self.instance_soft_concurrency is not None:
            result['instanceSoftConcurrency'] = self.instance_soft_concurrency
        if self.instance_type is not None:
            result['instanceType'] = self.instance_type
        if self.internet_access is not None:
            result['internetAccess'] = self.internet_access
        if self.last_modified_time is not None:
            result['lastModifiedTime'] = self.last_modified_time
        if self.layers is not None:
            result['layers'] = self.layers
        if self.layers_arn_v2 is not None:
            result['layersArnV2'] = self.layers_arn_v2
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.log_config is not None:
            result['logConfig'] = self.log_config.to_map()
        if self.memory_size is not None:
            result['memorySize'] = self.memory_size
        if self.namespace is not None:
            result['namespace'] = self.namespace
        if self.namespace_id is not None:
            result['namespaceID'] = self.namespace_id
        if self.namespace_name is not None:
            result['namespaceName'] = self.namespace_name
        if self.nas_config is not None:
            result['nasConfig'] = self.nas_config.to_map()
        if self.oss_mount_config is not None:
            result['ossMountConfig'] = self.oss_mount_config.to_map()
        if self.runtime is not None:
            result['runtime'] = self.runtime
        if self.scale_config is not None:
            result['scaleConfig'] = self.scale_config.to_map()
        if self.sls_config is not None:
            result['slsConfig'] = self.sls_config.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.timeout is not None:
            result['timeout'] = self.timeout
        if self.tracing_config is not None:
            result['tracingConfig'] = self.tracing_config.to_map()
        if self.url_internet is not None:
            result['urlInternet'] = self.url_internet
        if self.url_intranet is not None:
            result['urlIntranet'] = self.url_intranet
        if self.version is not None:
            result['version'] = self.version.to_map()
        if self.vpc_config is not None:
            result['vpcConfig'] = self.vpc_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('applicationId') is not None:
            self.application_id = m.get('applicationId')
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('caPort') is not None:
            self.ca_port = m.get('caPort')
        if m.get('codeChecksum') is not None:
            self.code_checksum = m.get('codeChecksum')
        if m.get('codeSize') is not None:
            self.code_size = m.get('codeSize')
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('cpu') is not None:
            self.cpu = m.get('cpu')
        if m.get('createdTime') is not None:
            self.created_time = m.get('createdTime')
        if m.get('customDNS') is not None:
            temp_model = CustomDNS()
            self.custom_dns = temp_model.from_map(m['customDNS'])
        if m.get('customDomainName') is not None:
            self.custom_domain_name = m.get('customDomainName')
        if m.get('customHealthCheckConfig') is not None:
            temp_model = CustomHealthCheckConfig()
            self.custom_health_check_config = temp_model.from_map(m['customHealthCheckConfig'])
        if m.get('customHostAlias') is not None:
            temp_model = CustomHostAlias()
            self.custom_host_alias = temp_model.from_map(m['customHostAlias'])
        if m.get('customRuntimeConfig') is not None:
            temp_model = CustomRuntimeConfig()
            self.custom_runtime_config = temp_model.from_map(m['customRuntimeConfig'])
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('diskSize') is not None:
            self.disk_size = m.get('diskSize')
        if m.get('enableAppMetric') is not None:
            self.enable_app_metric = m.get('enableAppMetric')
        if m.get('enableArmsAdvanced') is not None:
            self.enable_arms_advanced = m.get('enableArmsAdvanced')
        if m.get('environmentVariables') is not None:
            self.environment_variables = m.get('environmentVariables')
        if m.get('gpuMemorySize') is not None:
            self.gpu_memory_size = m.get('gpuMemorySize')
        if m.get('handler') is not None:
            self.handler = m.get('handler')
        if m.get('httpTriggerConfig') is not None:
            temp_model = HTTPTriggerConfig()
            self.http_trigger_config = temp_model.from_map(m['httpTriggerConfig'])
        if m.get('imageConfig') is not None:
            temp_model = ImageConfig()
            self.image_config = temp_model.from_map(m['imageConfig'])
        if m.get('initializationTimeout') is not None:
            self.initialization_timeout = m.get('initializationTimeout')
        if m.get('initializer') is not None:
            self.initializer = m.get('initializer')
        if m.get('instanceConcurrency') is not None:
            self.instance_concurrency = m.get('instanceConcurrency')
        if m.get('instanceLifecycleConfig') is not None:
            temp_model = InstanceLifecycleConfig()
            self.instance_lifecycle_config = temp_model.from_map(m['instanceLifecycleConfig'])
        if m.get('instanceSoftConcurrency') is not None:
            self.instance_soft_concurrency = m.get('instanceSoftConcurrency')
        if m.get('instanceType') is not None:
            self.instance_type = m.get('instanceType')
        if m.get('internetAccess') is not None:
            self.internet_access = m.get('internetAccess')
        if m.get('lastModifiedTime') is not None:
            self.last_modified_time = m.get('lastModifiedTime')
        if m.get('layers') is not None:
            self.layers = m.get('layers')
        if m.get('layersArnV2') is not None:
            self.layers_arn_v2 = m.get('layersArnV2')
        if m.get('livenessProbe') is not None:
            temp_model = Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('logConfig') is not None:
            temp_model = LogConfig()
            self.log_config = temp_model.from_map(m['logConfig'])
        if m.get('memorySize') is not None:
            self.memory_size = m.get('memorySize')
        if m.get('namespace') is not None:
            self.namespace = m.get('namespace')
        if m.get('namespaceID') is not None:
            self.namespace_id = m.get('namespaceID')
        if m.get('namespaceName') is not None:
            self.namespace_name = m.get('namespaceName')
        if m.get('nasConfig') is not None:
            temp_model = NASConfig()
            self.nas_config = temp_model.from_map(m['nasConfig'])
        if m.get('ossMountConfig') is not None:
            temp_model = OSSMountConfig()
            self.oss_mount_config = temp_model.from_map(m['ossMountConfig'])
        if m.get('runtime') is not None:
            self.runtime = m.get('runtime')
        if m.get('scaleConfig') is not None:
            temp_model = ScaleConfig()
            self.scale_config = temp_model.from_map(m['scaleConfig'])
        if m.get('slsConfig') is not None:
            temp_model = SLSConfig()
            self.sls_config = temp_model.from_map(m['slsConfig'])
        if m.get('startupProbe') is not None:
            temp_model = Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('timeout') is not None:
            self.timeout = m.get('timeout')
        if m.get('tracingConfig') is not None:
            temp_model = TracingConfig()
            self.tracing_config = temp_model.from_map(m['tracingConfig'])
        if m.get('urlInternet') is not None:
            self.url_internet = m.get('urlInternet')
        if m.get('urlIntranet') is not None:
            self.url_intranet = m.get('urlIntranet')
        if m.get('version') is not None:
            temp_model = Version()
            self.version = temp_model.from_map(m['version'])
        if m.get('vpcConfig') is not None:
            temp_model = VPCConfig()
            self.vpc_config = temp_model.from_map(m['vpcConfig'])
        return self


class ApplicationStatus(TeaModel):
    def __init__(
        self,
        instance_count: int = None,
        scale_config: ScaleConfig = None,
    ):
        self.instance_count = instance_count
        self.scale_config = scale_config

    def validate(self):
        if self.scale_config:
            self.scale_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_count is not None:
            result['instanceCount'] = self.instance_count
        if self.scale_config is not None:
            result['scaleConfig'] = self.scale_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceCount') is not None:
            self.instance_count = m.get('instanceCount')
        if m.get('scaleConfig') is not None:
            temp_model = ScaleConfig()
            self.scale_config = temp_model.from_map(m['scaleConfig'])
        return self


class ApplicationWithStatus(TeaModel):
    def __init__(
        self,
        application: Application = None,
        status: ApplicationStatus = None,
    ):
        self.application = application
        self.status = status

    def validate(self):
        if self.application:
            self.application.validate()
        if self.status:
            self.status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application is not None:
            result['application'] = self.application.to_map()
        if self.status is not None:
            result['status'] = self.status.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('application') is not None:
            temp_model = Application()
            self.application = temp_model.from_map(m['application'])
        if m.get('status') is not None:
            temp_model = ApplicationStatus()
            self.status = temp_model.from_map(m['status'])
        return self


class ArmsConfig(TeaModel):
    def __init__(
        self,
        agent_version: str = None,
        app_id: str = None,
        license_key: str = None,
    ):
        self.agent_version = agent_version
        self.app_id = app_id
        self.license_key = license_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_version is not None:
            result['agentVersion'] = self.agent_version
        if self.app_id is not None:
            result['appId'] = self.app_id
        if self.license_key is not None:
            result['licenseKey'] = self.license_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('agentVersion') is not None:
            self.agent_version = m.get('agentVersion')
        if m.get('appId') is not None:
            self.app_id = m.get('appId')
        if m.get('licenseKey') is not None:
            self.license_key = m.get('licenseKey')
        return self


class TomcatConfig(TeaModel):
    def __init__(
        self,
        context_path: str = None,
        max_threads: int = None,
        port: int = None,
        uri_encoding: str = None,
        use_body_encoding_for_uri: bool = None,
        version: str = None,
    ):
        self.context_path = context_path
        self.max_threads = max_threads
        self.port = port
        self.uri_encoding = uri_encoding
        self.use_body_encoding_for_uri = use_body_encoding_for_uri
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.context_path is not None:
            result['ContextPath'] = self.context_path
        if self.max_threads is not None:
            result['MaxThreads'] = self.max_threads
        if self.port is not None:
            result['Port'] = self.port
        if self.uri_encoding is not None:
            result['UriEncoding'] = self.uri_encoding
        if self.use_body_encoding_for_uri is not None:
            result['UseBodyEncodingForUri'] = self.use_body_encoding_for_uri
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContextPath') is not None:
            self.context_path = m.get('ContextPath')
        if m.get('MaxThreads') is not None:
            self.max_threads = m.get('MaxThreads')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('UriEncoding') is not None:
            self.uri_encoding = m.get('UriEncoding')
        if m.get('UseBodyEncodingForUri') is not None:
            self.use_body_encoding_for_uri = m.get('UseBodyEncodingForUri')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class BuildPipelineBuildConfig(TeaModel):
    def __init__(
        self,
        before_build_command: str = None,
        build_type: str = None,
        dockerfile_path: str = None,
        run_command: str = None,
        runtime_type: str = None,
        runtime_version: str = None,
        tomcat_config: TomcatConfig = None,
        working_dir: str = None,
    ):
        self.before_build_command = before_build_command
        # This parameter is required.
        self.build_type = build_type
        self.dockerfile_path = dockerfile_path
        self.run_command = run_command
        self.runtime_type = runtime_type
        self.runtime_version = runtime_version
        self.tomcat_config = tomcat_config
        self.working_dir = working_dir

    def validate(self):
        if self.tomcat_config:
            self.tomcat_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.before_build_command is not None:
            result['BeforeBuildCommand'] = self.before_build_command
        if self.build_type is not None:
            result['BuildType'] = self.build_type
        if self.dockerfile_path is not None:
            result['DockerfilePath'] = self.dockerfile_path
        if self.run_command is not None:
            result['RunCommand'] = self.run_command
        if self.runtime_type is not None:
            result['RuntimeType'] = self.runtime_type
        if self.runtime_version is not None:
            result['RuntimeVersion'] = self.runtime_version
        if self.tomcat_config is not None:
            result['TomcatConfig'] = self.tomcat_config.to_map()
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeforeBuildCommand') is not None:
            self.before_build_command = m.get('BeforeBuildCommand')
        if m.get('BuildType') is not None:
            self.build_type = m.get('BuildType')
        if m.get('DockerfilePath') is not None:
            self.dockerfile_path = m.get('DockerfilePath')
        if m.get('RunCommand') is not None:
            self.run_command = m.get('RunCommand')
        if m.get('RuntimeType') is not None:
            self.runtime_type = m.get('RuntimeType')
        if m.get('RuntimeVersion') is not None:
            self.runtime_version = m.get('RuntimeVersion')
        if m.get('TomcatConfig') is not None:
            temp_model = TomcatConfig()
            self.tomcat_config = temp_model.from_map(m['TomcatConfig'])
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class BuildPipelineCodeConfig(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        branch_name: str = None,
        commit_id: str = None,
        commit_url: str = None,
        organization_id: str = None,
        provider: str = None,
        repo_full_name: str = None,
        repo_id: str = None,
    ):
        # This parameter is required.
        self.account_id = account_id
        # This parameter is required.
        self.branch_name = branch_name
        self.commit_id = commit_id
        self.commit_url = commit_url
        self.organization_id = organization_id
        # This parameter is required.
        self.provider = provider
        # This parameter is required.
        self.repo_full_name = repo_full_name
        # This parameter is required.
        self.repo_id = repo_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.branch_name is not None:
            result['BranchName'] = self.branch_name
        if self.commit_id is not None:
            result['CommitId'] = self.commit_id
        if self.commit_url is not None:
            result['CommitUrl'] = self.commit_url
        if self.organization_id is not None:
            result['OrganizationId'] = self.organization_id
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.repo_full_name is not None:
            result['RepoFullName'] = self.repo_full_name
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('BranchName') is not None:
            self.branch_name = m.get('BranchName')
        if m.get('CommitId') is not None:
            self.commit_id = m.get('CommitId')
        if m.get('CommitUrl') is not None:
            self.commit_url = m.get('CommitUrl')
        if m.get('OrganizationId') is not None:
            self.organization_id = m.get('OrganizationId')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('RepoFullName') is not None:
            self.repo_full_name = m.get('RepoFullName')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        return self


class BuildPipelineDeployConfig(TeaModel):
    def __init__(
        self,
        always_allocate_cpu: bool = None,
        maximum_instance_count: int = None,
        minimum_instance_count: int = None,
        update_application_input: str = None,
        update_traffic: bool = None,
    ):
        self.always_allocate_cpu = always_allocate_cpu
        self.maximum_instance_count = maximum_instance_count
        self.minimum_instance_count = minimum_instance_count
        self.update_application_input = update_application_input
        self.update_traffic = update_traffic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.always_allocate_cpu is not None:
            result['AlwaysAllocateCPU'] = self.always_allocate_cpu
        if self.maximum_instance_count is not None:
            result['MaximumInstanceCount'] = self.maximum_instance_count
        if self.minimum_instance_count is not None:
            result['MinimumInstanceCount'] = self.minimum_instance_count
        if self.update_application_input is not None:
            result['UpdateApplicationInput'] = self.update_application_input
        if self.update_traffic is not None:
            result['UpdateTraffic'] = self.update_traffic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlwaysAllocateCPU') is not None:
            self.always_allocate_cpu = m.get('AlwaysAllocateCPU')
        if m.get('MaximumInstanceCount') is not None:
            self.maximum_instance_count = m.get('MaximumInstanceCount')
        if m.get('MinimumInstanceCount') is not None:
            self.minimum_instance_count = m.get('MinimumInstanceCount')
        if m.get('UpdateApplicationInput') is not None:
            self.update_application_input = m.get('UpdateApplicationInput')
        if m.get('UpdateTraffic') is not None:
            self.update_traffic = m.get('UpdateTraffic')
        return self


class BuildPipelineImageConfig(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        namespace: str = None,
        repository: str = None,
    ):
        self.instance_type = instance_type
        self.namespace = namespace
        self.repository = repository

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.repository is not None:
            result['Repository'] = self.repository
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Repository') is not None:
            self.repository = m.get('Repository')
        return self


class BuildPipelinePackageConfig(TeaModel):
    def __init__(
        self,
        package_name: str = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
    ):
        self.package_name = package_name
        self.package_type = package_type
        self.package_url = package_url
        self.package_version = package_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_name is not None:
            result['PackageName'] = self.package_name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageName') is not None:
            self.package_name = m.get('PackageName')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        return self


class BuildPipelineTriggerConfig(TeaModel):
    def __init__(
        self,
        branch_name: str = None,
        tag_name: str = None,
        type: str = None,
    ):
        self.branch_name = branch_name
        self.tag_name = tag_name
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch_name is not None:
            result['BranchName'] = self.branch_name
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BranchName') is not None:
            self.branch_name = m.get('BranchName')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BuildPipeline(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        application_name: str = None,
        build_config: BuildPipelineBuildConfig = None,
        code_config: BuildPipelineCodeConfig = None,
        deploy_config: BuildPipelineDeployConfig = None,
        enabled: bool = None,
        image_config: BuildPipelineImageConfig = None,
        package_config: BuildPipelinePackageConfig = None,
        trigger_config: BuildPipelineTriggerConfig = None,
    ):
        # This parameter is required.
        self.application_id = application_id
        # This parameter is required.
        self.application_name = application_name
        # This parameter is required.
        self.build_config = build_config
        # This parameter is required.
        self.code_config = code_config
        self.deploy_config = deploy_config
        self.enabled = enabled
        self.image_config = image_config
        self.package_config = package_config
        # This parameter is required.
        self.trigger_config = trigger_config

    def validate(self):
        if self.build_config:
            self.build_config.validate()
        if self.code_config:
            self.code_config.validate()
        if self.deploy_config:
            self.deploy_config.validate()
        if self.image_config:
            self.image_config.validate()
        if self.package_config:
            self.package_config.validate()
        if self.trigger_config:
            self.trigger_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.build_config is not None:
            result['BuildConfig'] = self.build_config.to_map()
        if self.code_config is not None:
            result['CodeConfig'] = self.code_config.to_map()
        if self.deploy_config is not None:
            result['DeployConfig'] = self.deploy_config.to_map()
        if self.enabled is not None:
            result['Enabled'] = self.enabled
        if self.image_config is not None:
            result['ImageConfig'] = self.image_config.to_map()
        if self.package_config is not None:
            result['PackageConfig'] = self.package_config.to_map()
        if self.trigger_config is not None:
            result['TriggerConfig'] = self.trigger_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('BuildConfig') is not None:
            temp_model = BuildPipelineBuildConfig()
            self.build_config = temp_model.from_map(m['BuildConfig'])
        if m.get('CodeConfig') is not None:
            temp_model = BuildPipelineCodeConfig()
            self.code_config = temp_model.from_map(m['CodeConfig'])
        if m.get('DeployConfig') is not None:
            temp_model = BuildPipelineDeployConfig()
            self.deploy_config = temp_model.from_map(m['DeployConfig'])
        if m.get('Enabled') is not None:
            self.enabled = m.get('Enabled')
        if m.get('ImageConfig') is not None:
            temp_model = BuildPipelineImageConfig()
            self.image_config = temp_model.from_map(m['ImageConfig'])
        if m.get('PackageConfig') is not None:
            temp_model = BuildPipelinePackageConfig()
            self.package_config = temp_model.from_map(m['PackageConfig'])
        if m.get('TriggerConfig') is not None:
            temp_model = BuildPipelineTriggerConfig()
            self.trigger_config = temp_model.from_map(m['TriggerConfig'])
        return self


class BuildPipelineRunBuildConfigTrigger(TeaModel):
    def __init__(
        self,
        branch_name: str = None,
        tag_name: str = None,
        type: str = None,
    ):
        self.branch_name = branch_name
        self.tag_name = tag_name
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch_name is not None:
            result['BranchName'] = self.branch_name
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BranchName') is not None:
            self.branch_name = m.get('BranchName')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BuildPipelineRunBuildConfig(TeaModel):
    def __init__(
        self,
        before_build_command: str = None,
        build_type: str = None,
        dockerfile_path: str = None,
        run_command: str = None,
        runtime_type: str = None,
        runtime_version: str = None,
        tomcat_config: TomcatConfig = None,
        trigger: BuildPipelineRunBuildConfigTrigger = None,
        working_dir: str = None,
    ):
        self.before_build_command = before_build_command
        # This parameter is required.
        self.build_type = build_type
        self.dockerfile_path = dockerfile_path
        self.run_command = run_command
        self.runtime_type = runtime_type
        self.runtime_version = runtime_version
        self.tomcat_config = tomcat_config
        # This parameter is required.
        self.trigger = trigger
        self.working_dir = working_dir

    def validate(self):
        if self.tomcat_config:
            self.tomcat_config.validate()
        if self.trigger:
            self.trigger.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.before_build_command is not None:
            result['BeforeBuildCommand'] = self.before_build_command
        if self.build_type is not None:
            result['BuildType'] = self.build_type
        if self.dockerfile_path is not None:
            result['DockerfilePath'] = self.dockerfile_path
        if self.run_command is not None:
            result['RunCommand'] = self.run_command
        if self.runtime_type is not None:
            result['RuntimeType'] = self.runtime_type
        if self.runtime_version is not None:
            result['RuntimeVersion'] = self.runtime_version
        if self.tomcat_config is not None:
            result['TomcatConfig'] = self.tomcat_config.to_map()
        if self.trigger is not None:
            result['Trigger'] = self.trigger.to_map()
        if self.working_dir is not None:
            result['WorkingDir'] = self.working_dir
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeforeBuildCommand') is not None:
            self.before_build_command = m.get('BeforeBuildCommand')
        if m.get('BuildType') is not None:
            self.build_type = m.get('BuildType')
        if m.get('DockerfilePath') is not None:
            self.dockerfile_path = m.get('DockerfilePath')
        if m.get('RunCommand') is not None:
            self.run_command = m.get('RunCommand')
        if m.get('RuntimeType') is not None:
            self.runtime_type = m.get('RuntimeType')
        if m.get('RuntimeVersion') is not None:
            self.runtime_version = m.get('RuntimeVersion')
        if m.get('TomcatConfig') is not None:
            temp_model = TomcatConfig()
            self.tomcat_config = temp_model.from_map(m['TomcatConfig'])
        if m.get('Trigger') is not None:
            temp_model = BuildPipelineRunBuildConfigTrigger()
            self.trigger = temp_model.from_map(m['Trigger'])
        if m.get('WorkingDir') is not None:
            self.working_dir = m.get('WorkingDir')
        return self


class BuildPipelineRunCodeConfig(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        branch_name: str = None,
        commit_id: str = None,
        commit_url: str = None,
        organization_id: str = None,
        provider: str = None,
        repo_full_name: str = None,
        repo_id: str = None,
    ):
        # This parameter is required.
        self.account_id = account_id
        # This parameter is required.
        self.branch_name = branch_name
        self.commit_id = commit_id
        self.commit_url = commit_url
        self.organization_id = organization_id
        # This parameter is required.
        self.provider = provider
        # This parameter is required.
        self.repo_full_name = repo_full_name
        # This parameter is required.
        self.repo_id = repo_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.branch_name is not None:
            result['BranchName'] = self.branch_name
        if self.commit_id is not None:
            result['CommitId'] = self.commit_id
        if self.commit_url is not None:
            result['CommitUrl'] = self.commit_url
        if self.organization_id is not None:
            result['OrganizationId'] = self.organization_id
        if self.provider is not None:
            result['Provider'] = self.provider
        if self.repo_full_name is not None:
            result['RepoFullName'] = self.repo_full_name
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('BranchName') is not None:
            self.branch_name = m.get('BranchName')
        if m.get('CommitId') is not None:
            self.commit_id = m.get('CommitId')
        if m.get('CommitUrl') is not None:
            self.commit_url = m.get('CommitUrl')
        if m.get('OrganizationId') is not None:
            self.organization_id = m.get('OrganizationId')
        if m.get('Provider') is not None:
            self.provider = m.get('Provider')
        if m.get('RepoFullName') is not None:
            self.repo_full_name = m.get('RepoFullName')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        return self


class BuildPipelineRunDeployConfig(TeaModel):
    def __init__(
        self,
        always_allocate_cpu: bool = None,
        maximum_instance_count: int = None,
        minimum_instance_count: int = None,
        update_application_input: str = None,
        update_traffic: bool = None,
    ):
        self.always_allocate_cpu = always_allocate_cpu
        self.maximum_instance_count = maximum_instance_count
        self.minimum_instance_count = minimum_instance_count
        self.update_application_input = update_application_input
        self.update_traffic = update_traffic

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.always_allocate_cpu is not None:
            result['AlwaysAllocateCPU'] = self.always_allocate_cpu
        if self.maximum_instance_count is not None:
            result['MaximumInstanceCount'] = self.maximum_instance_count
        if self.minimum_instance_count is not None:
            result['MinimumInstanceCount'] = self.minimum_instance_count
        if self.update_application_input is not None:
            result['UpdateApplicationInput'] = self.update_application_input
        if self.update_traffic is not None:
            result['UpdateTraffic'] = self.update_traffic
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlwaysAllocateCPU') is not None:
            self.always_allocate_cpu = m.get('AlwaysAllocateCPU')
        if m.get('MaximumInstanceCount') is not None:
            self.maximum_instance_count = m.get('MaximumInstanceCount')
        if m.get('MinimumInstanceCount') is not None:
            self.minimum_instance_count = m.get('MinimumInstanceCount')
        if m.get('UpdateApplicationInput') is not None:
            self.update_application_input = m.get('UpdateApplicationInput')
        if m.get('UpdateTraffic') is not None:
            self.update_traffic = m.get('UpdateTraffic')
        return self


class BuildPipelineRunImageConfig(TeaModel):
    def __init__(
        self,
        instance_type: str = None,
        namespace: str = None,
        repository: str = None,
    ):
        self.instance_type = instance_type
        self.namespace = namespace
        self.repository = repository

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_type is not None:
            result['InstanceType'] = self.instance_type
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.repository is not None:
            result['Repository'] = self.repository
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceType') is not None:
            self.instance_type = m.get('InstanceType')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Repository') is not None:
            self.repository = m.get('Repository')
        return self


class BuildPipelineRunPackageConfig(TeaModel):
    def __init__(
        self,
        package_name: str = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
    ):
        self.package_name = package_name
        self.package_type = package_type
        self.package_url = package_url
        self.package_version = package_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.package_name is not None:
            result['PackageName'] = self.package_name
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PackageName') is not None:
            self.package_name = m.get('PackageName')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        return self


class BuildPipelineRunSteps(TeaModel):
    def __init__(
        self,
        description: str = None,
        duration: int = None,
        end_time: int = None,
        id: str = None,
        name: str = None,
        result: str = None,
        start_time: int = None,
        status: str = None,
    ):
        self.description = description
        self.duration = duration
        self.end_time = end_time
        self.id = id
        self.name = name
        self.result = result
        self.start_time = start_time
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.result is not None:
            result['Result'] = self.result
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class BuildPipelineRunTriggerConfig(TeaModel):
    def __init__(
        self,
        branch_name: str = None,
        tag_name: str = None,
        type: str = None,
    ):
        self.branch_name = branch_name
        self.tag_name = tag_name
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.branch_name is not None:
            result['BranchName'] = self.branch_name
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BranchName') is not None:
            self.branch_name = m.get('BranchName')
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class BuildPipelineRun(TeaModel):
    def __init__(
        self,
        build_config: BuildPipelineRunBuildConfig = None,
        build_duration: int = None,
        code_config: BuildPipelineRunCodeConfig = None,
        create_time: int = None,
        deploy_config: BuildPipelineRunDeployConfig = None,
        deploy_duration: int = None,
        end_time: int = None,
        image_config: BuildPipelineRunImageConfig = None,
        package_config: BuildPipelineRunPackageConfig = None,
        pipeline_id: str = None,
        pipeline_run_id: str = None,
        start_time: int = None,
        status: str = None,
        steps: List[BuildPipelineRunSteps] = None,
        trigger_config: BuildPipelineRunTriggerConfig = None,
        version_id: str = None,
        wait_duration: int = None,
    ):
        self.build_config = build_config
        self.build_duration = build_duration
        self.code_config = code_config
        self.create_time = create_time
        self.deploy_config = deploy_config
        self.deploy_duration = deploy_duration
        self.end_time = end_time
        self.image_config = image_config
        self.package_config = package_config
        self.pipeline_id = pipeline_id
        self.pipeline_run_id = pipeline_run_id
        self.start_time = start_time
        self.status = status
        self.steps = steps
        self.trigger_config = trigger_config
        self.version_id = version_id
        self.wait_duration = wait_duration

    def validate(self):
        if self.build_config:
            self.build_config.validate()
        if self.code_config:
            self.code_config.validate()
        if self.deploy_config:
            self.deploy_config.validate()
        if self.image_config:
            self.image_config.validate()
        if self.package_config:
            self.package_config.validate()
        if self.steps:
            for k in self.steps:
                if k:
                    k.validate()
        if self.trigger_config:
            self.trigger_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.build_config is not None:
            result['BuildConfig'] = self.build_config.to_map()
        if self.build_duration is not None:
            result['BuildDuration'] = self.build_duration
        if self.code_config is not None:
            result['CodeConfig'] = self.code_config.to_map()
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.deploy_config is not None:
            result['DeployConfig'] = self.deploy_config.to_map()
        if self.deploy_duration is not None:
            result['DeployDuration'] = self.deploy_duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.image_config is not None:
            result['ImageConfig'] = self.image_config.to_map()
        if self.package_config is not None:
            result['PackageConfig'] = self.package_config.to_map()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.pipeline_run_id is not None:
            result['PipelineRunId'] = self.pipeline_run_id
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        result['Steps'] = []
        if self.steps is not None:
            for k in self.steps:
                result['Steps'].append(k.to_map() if k else None)
        if self.trigger_config is not None:
            result['TriggerConfig'] = self.trigger_config.to_map()
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        if self.wait_duration is not None:
            result['WaitDuration'] = self.wait_duration
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BuildConfig') is not None:
            temp_model = BuildPipelineRunBuildConfig()
            self.build_config = temp_model.from_map(m['BuildConfig'])
        if m.get('BuildDuration') is not None:
            self.build_duration = m.get('BuildDuration')
        if m.get('CodeConfig') is not None:
            temp_model = BuildPipelineRunCodeConfig()
            self.code_config = temp_model.from_map(m['CodeConfig'])
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DeployConfig') is not None:
            temp_model = BuildPipelineRunDeployConfig()
            self.deploy_config = temp_model.from_map(m['DeployConfig'])
        if m.get('DeployDuration') is not None:
            self.deploy_duration = m.get('DeployDuration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ImageConfig') is not None:
            temp_model = BuildPipelineRunImageConfig()
            self.image_config = temp_model.from_map(m['ImageConfig'])
        if m.get('PackageConfig') is not None:
            temp_model = BuildPipelineRunPackageConfig()
            self.package_config = temp_model.from_map(m['PackageConfig'])
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('PipelineRunId') is not None:
            self.pipeline_run_id = m.get('PipelineRunId')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.steps = []
        if m.get('Steps') is not None:
            for k in m.get('Steps'):
                temp_model = BuildPipelineRunSteps()
                self.steps.append(temp_model.from_map(k))
        if m.get('TriggerConfig') is not None:
            temp_model = BuildPipelineRunTriggerConfig()
            self.trigger_config = temp_model.from_map(m['TriggerConfig'])
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        if m.get('WaitDuration') is not None:
            self.wait_duration = m.get('WaitDuration')
        return self


class BuildPipelineRunLogLine(TeaModel):
    def __init__(
        self,
        content: str = None,
        offset: int = None,
    ):
        self.content = content
        self.offset = offset

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.offset is not None:
            result['Offset'] = self.offset
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('Offset') is not None:
            self.offset = m.get('Offset')
        return self


class CertConfig(TeaModel):
    def __init__(
        self,
        cert_name: str = None,
        certificate: str = None,
        private_key: str = None,
    ):
        self.cert_name = cert_name
        self.certificate = certificate
        self.private_key = private_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['certName'] = self.cert_name
        if self.certificate is not None:
            result['certificate'] = self.certificate
        if self.private_key is not None:
            result['privateKey'] = self.private_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('certName') is not None:
            self.cert_name = m.get('certName')
        if m.get('certificate') is not None:
            self.certificate = m.get('certificate')
        if m.get('privateKey') is not None:
            self.private_key = m.get('privateKey')
        return self


class MetricsCollectConfig(TeaModel):
    def __init__(
        self,
        enable_push_to_user_sls: bool = None,
        logstore_name: str = None,
        project_name: str = None,
    ):
        self.enable_push_to_user_sls = enable_push_to_user_sls
        self.logstore_name = logstore_name
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_push_to_user_sls is not None:
            result['EnablePushToUserSLS'] = self.enable_push_to_user_sls
        if self.logstore_name is not None:
            result['LogstoreName'] = self.logstore_name
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnablePushToUserSLS') is not None:
            self.enable_push_to_user_sls = m.get('EnablePushToUserSLS')
        if m.get('LogstoreName') is not None:
            self.logstore_name = m.get('LogstoreName')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class ContainerResources(TeaModel):
    def __init__(
        self,
        cpu: int = None,
        memory: int = None,
    ):
        # This parameter is required.
        self.cpu = cpu
        # This parameter is required.
        self.memory = memory

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.memory is not None:
            result['Memory'] = self.memory
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        return self


class SLSCollectConfig(TeaModel):
    def __init__(
        self,
        log_path: str = None,
        log_type: str = None,
        logstore_name: str = None,
        logtail_name: str = None,
        machine_group: str = None,
        project_name: str = None,
    ):
        self.log_path = log_path
        self.log_type = log_type
        self.logstore_name = logstore_name
        self.logtail_name = logtail_name
        self.machine_group = machine_group
        self.project_name = project_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_path is not None:
            result['LogPath'] = self.log_path
        if self.log_type is not None:
            result['LogType'] = self.log_type
        if self.logstore_name is not None:
            result['LogstoreName'] = self.logstore_name
        if self.logtail_name is not None:
            result['LogtailName'] = self.logtail_name
        if self.machine_group is not None:
            result['MachineGroup'] = self.machine_group
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('LogPath') is not None:
            self.log_path = m.get('LogPath')
        if m.get('LogType') is not None:
            self.log_type = m.get('LogType')
        if m.get('LogstoreName') is not None:
            self.logstore_name = m.get('LogstoreName')
        if m.get('LogtailName') is not None:
            self.logtail_name = m.get('LogtailName')
        if m.get('MachineGroup') is not None:
            self.machine_group = m.get('MachineGroup')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        return self


class SLSCollectConfigs(TeaModel):
    def __init__(
        self,
        collect_configs: List[SLSCollectConfig] = None,
    ):
        self.collect_configs = collect_configs

    def validate(self):
        if self.collect_configs:
            for k in self.collect_configs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CollectConfigs'] = []
        if self.collect_configs is not None:
            for k in self.collect_configs:
                result['CollectConfigs'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.collect_configs = []
        if m.get('CollectConfigs') is not None:
            for k in m.get('CollectConfigs'):
                temp_model = SLSCollectConfig()
                self.collect_configs.append(temp_model.from_map(k))
        return self


class HTTPHeader(TeaModel):
    def __init__(
        self,
        name: str = None,
        value: str = None,
    ):
        self.name = name
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['name'] = self.name
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class HTTPGetAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        http_headers: List[HTTPHeader] = None,
        path: str = None,
        port: int = None,
        scheme: str = None,
    ):
        self.host = host
        self.http_headers = http_headers
        self.path = path
        self.port = port
        self.scheme = scheme

    def validate(self):
        if self.http_headers:
            for k in self.http_headers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        result['HttpHeaders'] = []
        if self.http_headers is not None:
            for k in self.http_headers:
                result['HttpHeaders'].append(k.to_map() if k else None)
        if self.path is not None:
            result['Path'] = self.path
        if self.port is not None:
            result['Port'] = self.port
        if self.scheme is not None:
            result['Scheme'] = self.scheme
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        self.http_headers = []
        if m.get('HttpHeaders') is not None:
            for k in m.get('HttpHeaders'):
                temp_model = HTTPHeader()
                self.http_headers.append(temp_model.from_map(k))
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Scheme') is not None:
            self.scheme = m.get('Scheme')
        return self


class TCPSocketAction(TeaModel):
    def __init__(
        self,
        host: str = None,
        port: int = None,
    ):
        self.host = host
        self.port = port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.host is not None:
            result['Host'] = self.host
        if self.port is not None:
            result['Port'] = self.port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Host') is not None:
            self.host = m.get('Host')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        return self


class ProbeHandler(TeaModel):
    def __init__(
        self,
        http_get: HTTPGetAction = None,
        tcp_socket: TCPSocketAction = None,
    ):
        self.http_get = http_get
        self.tcp_socket = tcp_socket

    def validate(self):
        if self.http_get:
            self.http_get.validate()
        if self.tcp_socket:
            self.tcp_socket.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.http_get is not None:
            result['HttpGet'] = self.http_get.to_map()
        if self.tcp_socket is not None:
            result['TcpSocket'] = self.tcp_socket.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HttpGet') is not None:
            temp_model = HTTPGetAction()
            self.http_get = temp_model.from_map(m['HttpGet'])
        if m.get('TcpSocket') is not None:
            temp_model = TCPSocketAction()
            self.tcp_socket = temp_model.from_map(m['TcpSocket'])
        return self


class StartupProbe(TeaModel):
    def __init__(
        self,
        failure_threshold: int = None,
        initial_delay_seconds: int = None,
        period_seconds: int = None,
        probe_handler: ProbeHandler = None,
        timeout_seconds: int = None,
    ):
        self.failure_threshold = failure_threshold
        self.initial_delay_seconds = initial_delay_seconds
        self.period_seconds = period_seconds
        self.probe_handler = probe_handler
        self.timeout_seconds = timeout_seconds

    def validate(self):
        if self.probe_handler:
            self.probe_handler.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.failure_threshold is not None:
            result['FailureThreshold'] = self.failure_threshold
        if self.initial_delay_seconds is not None:
            result['InitialDelaySeconds'] = self.initial_delay_seconds
        if self.period_seconds is not None:
            result['PeriodSeconds'] = self.period_seconds
        if self.probe_handler is not None:
            result['ProbeHandler'] = self.probe_handler.to_map()
        if self.timeout_seconds is not None:
            result['TimeoutSeconds'] = self.timeout_seconds
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FailureThreshold') is not None:
            self.failure_threshold = m.get('FailureThreshold')
        if m.get('InitialDelaySeconds') is not None:
            self.initial_delay_seconds = m.get('InitialDelaySeconds')
        if m.get('PeriodSeconds') is not None:
            self.period_seconds = m.get('PeriodSeconds')
        if m.get('ProbeHandler') is not None:
            temp_model = ProbeHandler()
            self.probe_handler = temp_model.from_map(m['ProbeHandler'])
        if m.get('TimeoutSeconds') is not None:
            self.timeout_seconds = m.get('TimeoutSeconds')
        return self


class WebNASMountPoint(TeaModel):
    def __init__(
        self,
        mount_dir: str = None,
        nas_addr: str = None,
        nas_path: str = None,
    ):
        self.mount_dir = mount_dir
        self.nas_addr = nas_addr
        self.nas_path = nas_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_dir is not None:
            result['MountDir'] = self.mount_dir
        if self.nas_addr is not None:
            result['NasAddr'] = self.nas_addr
        if self.nas_path is not None:
            result['NasPath'] = self.nas_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountDir') is not None:
            self.mount_dir = m.get('MountDir')
        if m.get('NasAddr') is not None:
            self.nas_addr = m.get('NasAddr')
        if m.get('NasPath') is not None:
            self.nas_path = m.get('NasPath')
        return self


class WebNASConfig(TeaModel):
    def __init__(
        self,
        mount_points: List[WebNASMountPoint] = None,
    ):
        self.mount_points = mount_points

    def validate(self):
        if self.mount_points:
            for k in self.mount_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MountPoints'] = []
        if self.mount_points is not None:
            for k in self.mount_points:
                result['MountPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mount_points = []
        if m.get('MountPoints') is not None:
            for k in m.get('MountPoints'):
                temp_model = WebNASMountPoint()
                self.mount_points.append(temp_model.from_map(k))
        return self


class WebOSSMountPoint(TeaModel):
    def __init__(
        self,
        bucket_name: str = None,
        bucket_path: str = None,
        mount_dir: str = None,
        read_only: bool = None,
    ):
        self.bucket_name = bucket_name
        self.bucket_path = bucket_path
        self.mount_dir = mount_dir
        self.read_only = read_only

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['BucketName'] = self.bucket_name
        if self.bucket_path is not None:
            result['BucketPath'] = self.bucket_path
        if self.mount_dir is not None:
            result['MountDir'] = self.mount_dir
        if self.read_only is not None:
            result['ReadOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BucketName') is not None:
            self.bucket_name = m.get('BucketName')
        if m.get('BucketPath') is not None:
            self.bucket_path = m.get('BucketPath')
        if m.get('MountDir') is not None:
            self.mount_dir = m.get('MountDir')
        if m.get('ReadOnly') is not None:
            self.read_only = m.get('ReadOnly')
        return self


class WebOSSConfig(TeaModel):
    def __init__(
        self,
        mount_points: List[WebOSSMountPoint] = None,
    ):
        self.mount_points = mount_points

    def validate(self):
        if self.mount_points:
            for k in self.mount_points:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MountPoints'] = []
        if self.mount_points is not None:
            for k in self.mount_points:
                result['MountPoints'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mount_points = []
        if m.get('MountPoints') is not None:
            for k in m.get('MountPoints'):
                temp_model = WebOSSMountPoint()
                self.mount_points.append(temp_model.from_map(k))
        return self


class Container(TeaModel):
    def __init__(
        self,
        args: str = None,
        command: str = None,
        environment_variables: Dict[str, str] = None,
        image: str = None,
        metrics_collect_config: MetricsCollectConfig = None,
        port: int = None,
        request_concurrency: int = None,
        request_timeout: int = None,
        resources: ContainerResources = None,
        slscollect_configs: SLSCollectConfigs = None,
        startup_probe: StartupProbe = None,
        web_nasconfig: WebNASConfig = None,
        web_ossconfig: WebOSSConfig = None,
    ):
        self.args = args
        self.command = command
        self.environment_variables = environment_variables
        # This parameter is required.
        self.image = image
        self.metrics_collect_config = metrics_collect_config
        self.port = port
        self.request_concurrency = request_concurrency
        self.request_timeout = request_timeout
        # This parameter is required.
        self.resources = resources
        self.slscollect_configs = slscollect_configs
        self.startup_probe = startup_probe
        self.web_nasconfig = web_nasconfig
        self.web_ossconfig = web_ossconfig

    def validate(self):
        if self.metrics_collect_config:
            self.metrics_collect_config.validate()
        if self.resources:
            self.resources.validate()
        if self.slscollect_configs:
            self.slscollect_configs.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.web_nasconfig:
            self.web_nasconfig.validate()
        if self.web_ossconfig:
            self.web_ossconfig.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['Args'] = self.args
        if self.command is not None:
            result['Command'] = self.command
        if self.environment_variables is not None:
            result['EnvironmentVariables'] = self.environment_variables
        if self.image is not None:
            result['Image'] = self.image
        if self.metrics_collect_config is not None:
            result['MetricsCollectConfig'] = self.metrics_collect_config.to_map()
        if self.port is not None:
            result['Port'] = self.port
        if self.request_concurrency is not None:
            result['RequestConcurrency'] = self.request_concurrency
        if self.request_timeout is not None:
            result['RequestTimeout'] = self.request_timeout
        if self.resources is not None:
            result['Resources'] = self.resources.to_map()
        if self.slscollect_configs is not None:
            result['SLSCollectConfigs'] = self.slscollect_configs.to_map()
        if self.startup_probe is not None:
            result['StartupProbe'] = self.startup_probe.to_map()
        if self.web_nasconfig is not None:
            result['WebNASConfig'] = self.web_nasconfig.to_map()
        if self.web_ossconfig is not None:
            result['WebOSSConfig'] = self.web_ossconfig.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Args') is not None:
            self.args = m.get('Args')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('EnvironmentVariables') is not None:
            self.environment_variables = m.get('EnvironmentVariables')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('MetricsCollectConfig') is not None:
            temp_model = MetricsCollectConfig()
            self.metrics_collect_config = temp_model.from_map(m['MetricsCollectConfig'])
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RequestConcurrency') is not None:
            self.request_concurrency = m.get('RequestConcurrency')
        if m.get('RequestTimeout') is not None:
            self.request_timeout = m.get('RequestTimeout')
        if m.get('Resources') is not None:
            temp_model = ContainerResources()
            self.resources = temp_model.from_map(m['Resources'])
        if m.get('SLSCollectConfigs') is not None:
            temp_model = SLSCollectConfigs()
            self.slscollect_configs = temp_model.from_map(m['SLSCollectConfigs'])
        if m.get('StartupProbe') is not None:
            temp_model = StartupProbe()
            self.startup_probe = temp_model.from_map(m['StartupProbe'])
        if m.get('WebNASConfig') is not None:
            temp_model = WebNASConfig()
            self.web_nasconfig = temp_model.from_map(m['WebNASConfig'])
        if m.get('WebOSSConfig') is not None:
            temp_model = WebOSSConfig()
            self.web_ossconfig = temp_model.from_map(m['WebOSSConfig'])
        return self


class InputCodeLocation(TeaModel):
    def __init__(
        self,
        oss_bucket_name: str = None,
        oss_object_name: str = None,
        zip_file: str = None,
    ):
        self.oss_bucket_name = oss_bucket_name
        self.oss_object_name = oss_object_name
        self.zip_file = zip_file

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.oss_bucket_name is not None:
            result['ossBucketName'] = self.oss_bucket_name
        if self.oss_object_name is not None:
            result['ossObjectName'] = self.oss_object_name
        if self.zip_file is not None:
            result['zipFile'] = self.zip_file
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ossBucketName') is not None:
            self.oss_bucket_name = m.get('ossBucketName')
        if m.get('ossObjectName') is not None:
            self.oss_object_name = m.get('ossObjectName')
        if m.get('zipFile') is not None:
            self.zip_file = m.get('zipFile')
        return self


class CreateApplicationInput(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        args: str = None,
        ca_port: int = None,
        code: InputCodeLocation = None,
        command: str = None,
        cpu: float = None,
        custom_dns: CustomDNS = None,
        custom_health_check_config: CustomHealthCheckConfig = None,
        custom_host_alias: CustomHostAlias = None,
        custom_runtime_config: CustomRuntimeConfig = None,
        description: str = None,
        disk_size: int = None,
        environment_variables: Dict[str, str] = None,
        gpu_memory_size: int = None,
        handler: str = None,
        http_trigger_config: HTTPTriggerConfig = None,
        image_config: ImageConfig = None,
        initialization_timeout: int = None,
        initializer: str = None,
        instance_concurrency: int = None,
        instance_lifecycle_config: InstanceLifecycleConfig = None,
        instance_soft_concurrency: int = None,
        instance_type: str = None,
        internet_access: bool = None,
        layers: List[str] = None,
        liveness_probe: Probe = None,
        log_config: LogConfig = None,
        memory_size: int = None,
        namespace_id: str = None,
        nas_config: NASConfig = None,
        oss_mount_config: OSSMountConfig = None,
        runtime: str = None,
        scale_config: ScaleConfig = None,
        sls_config: SLSConfig = None,
        startup_probe: Probe = None,
        timeout: int = None,
        tracing_config: TracingConfig = None,
        vpc_config: VPCConfig = None,
    ):
        self.application_name = application_name
        self.args = args
        self.ca_port = ca_port
        self.code = code
        self.command = command
        self.cpu = cpu
        self.custom_dns = custom_dns
        self.custom_health_check_config = custom_health_check_config
        self.custom_host_alias = custom_host_alias
        self.custom_runtime_config = custom_runtime_config
        self.description = description
        self.disk_size = disk_size
        self.environment_variables = environment_variables
        self.gpu_memory_size = gpu_memory_size
        self.handler = handler
        self.http_trigger_config = http_trigger_config
        self.image_config = image_config
        self.initialization_timeout = initialization_timeout
        self.initializer = initializer
        self.instance_concurrency = instance_concurrency
        self.instance_lifecycle_config = instance_lifecycle_config
        self.instance_soft_concurrency = instance_soft_concurrency
        self.instance_type = instance_type
        self.internet_access = internet_access
        self.layers = layers
        self.liveness_probe = liveness_probe
        self.log_config = log_config
        self.memory_size = memory_size
        self.namespace_id = namespace_id
        self.nas_config = nas_config
        self.oss_mount_config = oss_mount_config
        self.runtime = runtime
        self.scale_config = scale_config
        self.sls_config = sls_config
        self.startup_probe = startup_probe
        self.timeout = timeout
        self.tracing_config = tracing_config
        self.vpc_config = vpc_config

    def validate(self):
        if self.code:
            self.code.validate()
        if self.custom_dns:
            self.custom_dns.validate()
        if self.custom_health_check_config:
            self.custom_health_check_config.validate()
        if self.custom_host_alias:
            self.custom_host_alias.validate()
        if self.custom_runtime_config:
            self.custom_runtime_config.validate()
        if self.http_trigger_config:
            self.http_trigger_config.validate()
        if self.image_config:
            self.image_config.validate()
        if self.instance_lifecycle_config:
            self.instance_lifecycle_config.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        if self.log_config:
            self.log_config.validate()
        if self.nas_config:
            self.nas_config.validate()
        if self.oss_mount_config:
            self.oss_mount_config.validate()
        if self.scale_config:
            self.scale_config.validate()
        if self.sls_config:
            self.sls_config.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.tracing_config:
            self.tracing_config.validate()
        if self.vpc_config:
            self.vpc_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.args is not None:
            result['args'] = self.args
        if self.ca_port is not None:
            result['caPort'] = self.ca_port
        if self.code is not None:
            result['code'] = self.code.to_map()
        if self.command is not None:
            result['command'] = self.command
        if self.cpu is not None:
            result['cpu'] = self.cpu
        if self.custom_dns is not None:
            result['customDNS'] = self.custom_dns.to_map()
        if self.custom_health_check_config is not None:
            result['customHealthCheckConfig'] = self.custom_health_check_config.to_map()
        if self.custom_host_alias is not None:
            result['customHostAlias'] = self.custom_host_alias.to_map()
        if self.custom_runtime_config is not None:
            result['customRuntimeConfig'] = self.custom_runtime_config.to_map()
        if self.description is not None:
            result['description'] = self.description
        if self.disk_size is not None:
            result['diskSize'] = self.disk_size
        if self.environment_variables is not None:
            result['environmentVariables'] = self.environment_variables
        if self.gpu_memory_size is not None:
            result['gpuMemorySize'] = self.gpu_memory_size
        if self.handler is not None:
            result['handler'] = self.handler
        if self.http_trigger_config is not None:
            result['httpTriggerConfig'] = self.http_trigger_config.to_map()
        if self.image_config is not None:
            result['imageConfig'] = self.image_config.to_map()
        if self.initialization_timeout is not None:
            result['initializationTimeout'] = self.initialization_timeout
        if self.initializer is not None:
            result['initializer'] = self.initializer
        if self.instance_concurrency is not None:
            result['instanceConcurrency'] = self.instance_concurrency
        if self.instance_lifecycle_config is not None:
            result['instanceLifecycleConfig'] = self.instance_lifecycle_config.to_map()
        if self.instance_soft_concurrency is not None:
            result['instanceSoftConcurrency'] = self.instance_soft_concurrency
        if self.instance_type is not None:
            result['instanceType'] = self.instance_type
        if self.internet_access is not None:
            result['internetAccess'] = self.internet_access
        if self.layers is not None:
            result['layers'] = self.layers
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.log_config is not None:
            result['logConfig'] = self.log_config.to_map()
        if self.memory_size is not None:
            result['memorySize'] = self.memory_size
        if self.namespace_id is not None:
            result['namespaceID'] = self.namespace_id
        if self.nas_config is not None:
            result['nasConfig'] = self.nas_config.to_map()
        if self.oss_mount_config is not None:
            result['ossMountConfig'] = self.oss_mount_config.to_map()
        if self.runtime is not None:
            result['runtime'] = self.runtime
        if self.scale_config is not None:
            result['scaleConfig'] = self.scale_config.to_map()
        if self.sls_config is not None:
            result['slsConfig'] = self.sls_config.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.timeout is not None:
            result['timeout'] = self.timeout
        if self.tracing_config is not None:
            result['tracingConfig'] = self.tracing_config.to_map()
        if self.vpc_config is not None:
            result['vpcConfig'] = self.vpc_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('caPort') is not None:
            self.ca_port = m.get('caPort')
        if m.get('code') is not None:
            temp_model = InputCodeLocation()
            self.code = temp_model.from_map(m['code'])
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('cpu') is not None:
            self.cpu = m.get('cpu')
        if m.get('customDNS') is not None:
            temp_model = CustomDNS()
            self.custom_dns = temp_model.from_map(m['customDNS'])
        if m.get('customHealthCheckConfig') is not None:
            temp_model = CustomHealthCheckConfig()
            self.custom_health_check_config = temp_model.from_map(m['customHealthCheckConfig'])
        if m.get('customHostAlias') is not None:
            temp_model = CustomHostAlias()
            self.custom_host_alias = temp_model.from_map(m['customHostAlias'])
        if m.get('customRuntimeConfig') is not None:
            temp_model = CustomRuntimeConfig()
            self.custom_runtime_config = temp_model.from_map(m['customRuntimeConfig'])
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('diskSize') is not None:
            self.disk_size = m.get('diskSize')
        if m.get('environmentVariables') is not None:
            self.environment_variables = m.get('environmentVariables')
        if m.get('gpuMemorySize') is not None:
            self.gpu_memory_size = m.get('gpuMemorySize')
        if m.get('handler') is not None:
            self.handler = m.get('handler')
        if m.get('httpTriggerConfig') is not None:
            temp_model = HTTPTriggerConfig()
            self.http_trigger_config = temp_model.from_map(m['httpTriggerConfig'])
        if m.get('imageConfig') is not None:
            temp_model = ImageConfig()
            self.image_config = temp_model.from_map(m['imageConfig'])
        if m.get('initializationTimeout') is not None:
            self.initialization_timeout = m.get('initializationTimeout')
        if m.get('initializer') is not None:
            self.initializer = m.get('initializer')
        if m.get('instanceConcurrency') is not None:
            self.instance_concurrency = m.get('instanceConcurrency')
        if m.get('instanceLifecycleConfig') is not None:
            temp_model = InstanceLifecycleConfig()
            self.instance_lifecycle_config = temp_model.from_map(m['instanceLifecycleConfig'])
        if m.get('instanceSoftConcurrency') is not None:
            self.instance_soft_concurrency = m.get('instanceSoftConcurrency')
        if m.get('instanceType') is not None:
            self.instance_type = m.get('instanceType')
        if m.get('internetAccess') is not None:
            self.internet_access = m.get('internetAccess')
        if m.get('layers') is not None:
            self.layers = m.get('layers')
        if m.get('livenessProbe') is not None:
            temp_model = Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('logConfig') is not None:
            temp_model = LogConfig()
            self.log_config = temp_model.from_map(m['logConfig'])
        if m.get('memorySize') is not None:
            self.memory_size = m.get('memorySize')
        if m.get('namespaceID') is not None:
            self.namespace_id = m.get('namespaceID')
        if m.get('nasConfig') is not None:
            temp_model = NASConfig()
            self.nas_config = temp_model.from_map(m['nasConfig'])
        if m.get('ossMountConfig') is not None:
            temp_model = OSSMountConfig()
            self.oss_mount_config = temp_model.from_map(m['ossMountConfig'])
        if m.get('runtime') is not None:
            self.runtime = m.get('runtime')
        if m.get('scaleConfig') is not None:
            temp_model = ScaleConfig()
            self.scale_config = temp_model.from_map(m['scaleConfig'])
        if m.get('slsConfig') is not None:
            temp_model = SLSConfig()
            self.sls_config = temp_model.from_map(m['slsConfig'])
        if m.get('startupProbe') is not None:
            temp_model = Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('timeout') is not None:
            self.timeout = m.get('timeout')
        if m.get('tracingConfig') is not None:
            temp_model = TracingConfig()
            self.tracing_config = temp_model.from_map(m['tracingConfig'])
        if m.get('vpcConfig') is not None:
            temp_model = VPCConfig()
            self.vpc_config = temp_model.from_map(m['vpcConfig'])
        return self


class TLSConfig(TeaModel):
    def __init__(
        self,
        cipher_suites: List[str] = None,
        max_version: str = None,
        min_version: str = None,
    ):
        self.cipher_suites = cipher_suites
        self.max_version = max_version
        self.min_version = min_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cipher_suites is not None:
            result['cipherSuites'] = self.cipher_suites
        if self.max_version is not None:
            result['maxVersion'] = self.max_version
        if self.min_version is not None:
            result['minVersion'] = self.min_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cipherSuites') is not None:
            self.cipher_suites = m.get('cipherSuites')
        if m.get('maxVersion') is not None:
            self.max_version = m.get('maxVersion')
        if m.get('minVersion') is not None:
            self.min_version = m.get('minVersion')
        return self


class WAFConfig(TeaModel):
    def __init__(
        self,
        enable_waf: bool = None,
    ):
        self.enable_waf = enable_waf

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_waf is not None:
            result['enableWAF'] = self.enable_waf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('enableWAF') is not None:
            self.enable_waf = m.get('enableWAF')
        return self


class CreateCustomDomainInput(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        cert_config: CertConfig = None,
        domain_name: str = None,
        keep_full_path: bool = None,
        namespace_id: str = None,
        protocol: str = None,
        tls_config: TLSConfig = None,
        waf_config: WAFConfig = None,
    ):
        self.application_name = application_name
        self.cert_config = cert_config
        self.domain_name = domain_name
        self.keep_full_path = keep_full_path
        self.namespace_id = namespace_id
        self.protocol = protocol
        self.tls_config = tls_config
        self.waf_config = waf_config

    def validate(self):
        if self.cert_config:
            self.cert_config.validate()
        if self.tls_config:
            self.tls_config.validate()
        if self.waf_config:
            self.waf_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cert_config is not None:
            result['certConfig'] = self.cert_config.to_map()
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.keep_full_path is not None:
            result['keepFullPath'] = self.keep_full_path
        if self.namespace_id is not None:
            result['namespaceID'] = self.namespace_id
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.tls_config is not None:
            result['tlsConfig'] = self.tls_config.to_map()
        if self.waf_config is not None:
            result['wafConfig'] = self.waf_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('certConfig') is not None:
            temp_model = CertConfig()
            self.cert_config = temp_model.from_map(m['certConfig'])
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('keepFullPath') is not None:
            self.keep_full_path = m.get('keepFullPath')
        if m.get('namespaceID') is not None:
            self.namespace_id = m.get('namespaceID')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('tlsConfig') is not None:
            temp_model = TLSConfig()
            self.tls_config = temp_model.from_map(m['tlsConfig'])
        if m.get('wafConfig') is not None:
            temp_model = WAFConfig()
            self.waf_config = temp_model.from_map(m['wafConfig'])
        return self


class CreateSlsIndexRequest(TeaModel):
    def __init__(
        self,
        logstore: str = None,
        project: str = None,
    ):
        self.logstore = logstore
        self.project = project

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.logstore is not None:
            result['logstore'] = self.logstore
        if self.project is not None:
            result['project'] = self.project
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logstore') is not None:
            self.logstore = m.get('logstore')
        if m.get('project') is not None:
            self.project = m.get('project')
        return self


class CreateSlsIndexResponse(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        log_store: str = None,
        project: str = None,
    ):
        self.request_id = request_id
        self.log_store = log_store
        self.project = project

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.log_store is not None:
            result['logStore'] = self.log_store
        if self.project is not None:
            result['project'] = self.project
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('logStore') is not None:
            self.log_store = m.get('logStore')
        if m.get('project') is not None:
            self.project = m.get('project')
        return self


class CreateSlsResourceResponse(TeaModel):
    def __init__(
        self,
        log_store: str = None,
        project: str = None,
        request_id: str = None,
    ):
        self.log_store = log_store
        self.project = project
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.log_store is not None:
            result['logStore'] = self.log_store
        if self.project is not None:
            result['project'] = self.project
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('logStore') is not None:
            self.log_store = m.get('logStore')
        if m.get('project') is not None:
            self.project = m.get('project')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class WebNetworkConfig(TeaModel):
    def __init__(
        self,
        internet_access: bool = None,
        security_group_id: str = None,
        v_switch_ids: List[str] = None,
    ):
        self.internet_access = internet_access
        self.security_group_id = security_group_id
        self.v_switch_ids = v_switch_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.internet_access is not None:
            result['InternetAccess'] = self.internet_access
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.v_switch_ids is not None:
            result['VSwitchIds'] = self.v_switch_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InternetAccess') is not None:
            self.internet_access = m.get('InternetAccess')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('VSwitchIds') is not None:
            self.v_switch_ids = m.get('VSwitchIds')
        return self


class RevisionConfig(TeaModel):
    def __init__(
        self,
        containers: List[Container] = None,
        enable_arms_metrics: bool = None,
        web_network_config: WebNetworkConfig = None,
    ):
        # This parameter is required.
        self.containers = containers
        self.enable_arms_metrics = enable_arms_metrics
        self.web_network_config = web_network_config

    def validate(self):
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()
        if self.web_network_config:
            self.web_network_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.enable_arms_metrics is not None:
            result['EnableArmsMetrics'] = self.enable_arms_metrics
        if self.web_network_config is not None:
            result['WebNetworkConfig'] = self.web_network_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = Container()
                self.containers.append(temp_model.from_map(k))
        if m.get('EnableArmsMetrics') is not None:
            self.enable_arms_metrics = m.get('EnableArmsMetrics')
        if m.get('WebNetworkConfig') is not None:
            temp_model = WebNetworkConfig()
            self.web_network_config = temp_model.from_map(m['WebNetworkConfig'])
        return self


class WebScalingConfig(TeaModel):
    def __init__(
        self,
        maximum_instance_count: int = None,
        minimum_instance_count: int = None,
    ):
        self.maximum_instance_count = maximum_instance_count
        self.minimum_instance_count = minimum_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.maximum_instance_count is not None:
            result['MaximumInstanceCount'] = self.maximum_instance_count
        if self.minimum_instance_count is not None:
            result['MinimumInstanceCount'] = self.minimum_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaximumInstanceCount') is not None:
            self.maximum_instance_count = m.get('MaximumInstanceCount')
        if m.get('MinimumInstanceCount') is not None:
            self.minimum_instance_count = m.get('MinimumInstanceCount')
        return self


class WebAclEntryConfig(TeaModel):
    def __init__(
        self,
        entry: str = None,
    ):
        # This parameter is required.
        self.entry = entry

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.entry is not None:
            result['Entry'] = self.entry
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Entry') is not None:
            self.entry = m.get('Entry')
        return self


class WebAclConfig(TeaModel):
    def __init__(
        self,
        web_acl_entries: List[WebAclEntryConfig] = None,
    ):
        # This parameter is required.
        self.web_acl_entries = web_acl_entries

    def validate(self):
        if self.web_acl_entries:
            for k in self.web_acl_entries:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WebAclEntries'] = []
        if self.web_acl_entries is not None:
            for k in self.web_acl_entries:
                result['WebAclEntries'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.web_acl_entries = []
        if m.get('WebAclEntries') is not None:
            for k in m.get('WebAclEntries'):
                temp_model = WebAclEntryConfig()
                self.web_acl_entries.append(temp_model.from_map(k))
        return self


class WebTrafficConfig(TeaModel):
    def __init__(
        self,
        auth_type: str = None,
        disable_internet_url: bool = None,
        revisions_traffic_weight: Dict[str, float] = None,
        web_acl_config: WebAclConfig = None,
    ):
        self.auth_type = auth_type
        self.disable_internet_url = disable_internet_url
        self.revisions_traffic_weight = revisions_traffic_weight
        self.web_acl_config = web_acl_config

    def validate(self):
        if self.web_acl_config:
            self.web_acl_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.disable_internet_url is not None:
            result['DisableInternetURL'] = self.disable_internet_url
        if self.revisions_traffic_weight is not None:
            result['RevisionsTrafficWeight'] = self.revisions_traffic_weight
        if self.web_acl_config is not None:
            result['WebAclConfig'] = self.web_acl_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('DisableInternetURL') is not None:
            self.disable_internet_url = m.get('DisableInternetURL')
        if m.get('RevisionsTrafficWeight') is not None:
            self.revisions_traffic_weight = m.get('RevisionsTrafficWeight')
        if m.get('WebAclConfig') is not None:
            temp_model = WebAclConfig()
            self.web_acl_config = temp_model.from_map(m['WebAclConfig'])
        return self


class CreateWebApplicationInput(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        description: str = None,
        revision_config: RevisionConfig = None,
        web_network_config: WebNetworkConfig = None,
        web_scaling_config: WebScalingConfig = None,
        web_traffic_config: WebTrafficConfig = None,
    ):
        # This parameter is required.
        self.application_name = application_name
        self.description = description
        # This parameter is required.
        self.revision_config = revision_config
        self.web_network_config = web_network_config
        self.web_scaling_config = web_scaling_config
        self.web_traffic_config = web_traffic_config

    def validate(self):
        if self.revision_config:
            self.revision_config.validate()
        if self.web_network_config:
            self.web_network_config.validate()
        if self.web_scaling_config:
            self.web_scaling_config.validate()
        if self.web_traffic_config:
            self.web_traffic_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.description is not None:
            result['Description'] = self.description
        if self.revision_config is not None:
            result['RevisionConfig'] = self.revision_config.to_map()
        if self.web_network_config is not None:
            result['WebNetworkConfig'] = self.web_network_config.to_map()
        if self.web_scaling_config is not None:
            result['WebScalingConfig'] = self.web_scaling_config.to_map()
        if self.web_traffic_config is not None:
            result['WebTrafficConfig'] = self.web_traffic_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RevisionConfig') is not None:
            temp_model = RevisionConfig()
            self.revision_config = temp_model.from_map(m['RevisionConfig'])
        if m.get('WebNetworkConfig') is not None:
            temp_model = WebNetworkConfig()
            self.web_network_config = temp_model.from_map(m['WebNetworkConfig'])
        if m.get('WebScalingConfig') is not None:
            temp_model = WebScalingConfig()
            self.web_scaling_config = temp_model.from_map(m['WebScalingConfig'])
        if m.get('WebTrafficConfig') is not None:
            temp_model = WebTrafficConfig()
            self.web_traffic_config = temp_model.from_map(m['WebTrafficConfig'])
        return self


class WebCertConfig(TeaModel):
    def __init__(
        self,
        cert_name: str = None,
        certificate: str = None,
        private_key: str = None,
    ):
        self.cert_name = cert_name
        self.certificate = certificate
        self.private_key = private_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_name is not None:
            result['CertName'] = self.cert_name
        if self.certificate is not None:
            result['Certificate'] = self.certificate
        if self.private_key is not None:
            result['PrivateKey'] = self.private_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertName') is not None:
            self.cert_name = m.get('CertName')
        if m.get('Certificate') is not None:
            self.certificate = m.get('Certificate')
        if m.get('PrivateKey') is not None:
            self.private_key = m.get('PrivateKey')
        return self


class WebTLSConfig(TeaModel):
    def __init__(
        self,
        cipher_suites: List[str] = None,
        max_version: str = None,
        min_version: str = None,
    ):
        self.cipher_suites = cipher_suites
        self.max_version = max_version
        self.min_version = min_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cipher_suites is not None:
            result['CipherSuites'] = self.cipher_suites
        if self.max_version is not None:
            result['MaxVersion'] = self.max_version
        if self.min_version is not None:
            result['MinVersion'] = self.min_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CipherSuites') is not None:
            self.cipher_suites = m.get('CipherSuites')
        if m.get('MaxVersion') is not None:
            self.max_version = m.get('MaxVersion')
        if m.get('MinVersion') is not None:
            self.min_version = m.get('MinVersion')
        return self


class WebWAFConfig(TeaModel):
    def __init__(
        self,
        enable_waf: bool = None,
    ):
        self.enable_waf = enable_waf

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_waf is not None:
            result['EnableWAF'] = self.enable_waf
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableWAF') is not None:
            self.enable_waf = m.get('EnableWAF')
        return self


class CreateWebCustomDomainInput(TeaModel):
    def __init__(
        self,
        default_forwarding_app_name: str = None,
        domain_name: str = None,
        protocol: str = None,
        web_cert_config: WebCertConfig = None,
        web_tlsconfig: WebTLSConfig = None,
        web_wafconfig: WebWAFConfig = None,
    ):
        self.default_forwarding_app_name = default_forwarding_app_name
        # This parameter is required.
        self.domain_name = domain_name
        self.protocol = protocol
        self.web_cert_config = web_cert_config
        self.web_tlsconfig = web_tlsconfig
        self.web_wafconfig = web_wafconfig

    def validate(self):
        if self.web_cert_config:
            self.web_cert_config.validate()
        if self.web_tlsconfig:
            self.web_tlsconfig.validate()
        if self.web_wafconfig:
            self.web_wafconfig.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_forwarding_app_name is not None:
            result['DefaultForwardingAppName'] = self.default_forwarding_app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.web_cert_config is not None:
            result['WebCertConfig'] = self.web_cert_config.to_map()
        if self.web_tlsconfig is not None:
            result['WebTLSConfig'] = self.web_tlsconfig.to_map()
        if self.web_wafconfig is not None:
            result['WebWAFConfig'] = self.web_wafconfig.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultForwardingAppName') is not None:
            self.default_forwarding_app_name = m.get('DefaultForwardingAppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('WebCertConfig') is not None:
            temp_model = WebCertConfig()
            self.web_cert_config = temp_model.from_map(m['WebCertConfig'])
        if m.get('WebTLSConfig') is not None:
            temp_model = WebTLSConfig()
            self.web_tlsconfig = temp_model.from_map(m['WebTLSConfig'])
        if m.get('WebWAFConfig') is not None:
            temp_model = WebWAFConfig()
            self.web_wafconfig = temp_model.from_map(m['WebWAFConfig'])
        return self


class PathConfig(TeaModel):
    def __init__(
        self,
        application_name: str = None,
        path: str = None,
    ):
        self.application_name = application_name
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.path is not None:
            result['path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('path') is not None:
            self.path = m.get('path')
        return self


class RouteConfig(TeaModel):
    def __init__(
        self,
        routes: List[PathConfig] = None,
    ):
        self.routes = routes

    def validate(self):
        if self.routes:
            for k in self.routes:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['routes'] = []
        if self.routes is not None:
            for k in self.routes:
                result['routes'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.routes = []
        if m.get('routes') is not None:
            for k in m.get('routes'):
                temp_model = PathConfig()
                self.routes.append(temp_model.from_map(k))
        return self


class CustomDomain(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        api_version: str = None,
        cert_config: CertConfig = None,
        created_time: str = None,
        domain_name: str = None,
        keep_full_path: bool = None,
        last_modified_time: str = None,
        namespace_id: str = None,
        protocol: str = None,
        request_id: str = None,
        route_config: RouteConfig = None,
        subdomain_count: str = None,
        tls_config: TLSConfig = None,
        waf_config: WAFConfig = None,
    ):
        self.account_id = account_id
        self.api_version = api_version
        self.cert_config = cert_config
        self.created_time = created_time
        self.domain_name = domain_name
        self.keep_full_path = keep_full_path
        self.last_modified_time = last_modified_time
        self.namespace_id = namespace_id
        self.protocol = protocol
        self.request_id = request_id
        self.route_config = route_config
        self.subdomain_count = subdomain_count
        self.tls_config = tls_config
        self.waf_config = waf_config

    def validate(self):
        if self.cert_config:
            self.cert_config.validate()
        if self.route_config:
            self.route_config.validate()
        if self.tls_config:
            self.tls_config.validate()
        if self.waf_config:
            self.waf_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['accountId'] = self.account_id
        if self.api_version is not None:
            result['apiVersion'] = self.api_version
        if self.cert_config is not None:
            result['certConfig'] = self.cert_config.to_map()
        if self.created_time is not None:
            result['createdTime'] = self.created_time
        if self.domain_name is not None:
            result['domainName'] = self.domain_name
        if self.keep_full_path is not None:
            result['keepFullPath'] = self.keep_full_path
        if self.last_modified_time is not None:
            result['lastModifiedTime'] = self.last_modified_time
        if self.namespace_id is not None:
            result['namespaceID'] = self.namespace_id
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.route_config is not None:
            result['routeConfig'] = self.route_config.to_map()
        if self.subdomain_count is not None:
            result['subdomainCount'] = self.subdomain_count
        if self.tls_config is not None:
            result['tlsConfig'] = self.tls_config.to_map()
        if self.waf_config is not None:
            result['wafConfig'] = self.waf_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        if m.get('apiVersion') is not None:
            self.api_version = m.get('apiVersion')
        if m.get('certConfig') is not None:
            temp_model = CertConfig()
            self.cert_config = temp_model.from_map(m['certConfig'])
        if m.get('createdTime') is not None:
            self.created_time = m.get('createdTime')
        if m.get('domainName') is not None:
            self.domain_name = m.get('domainName')
        if m.get('keepFullPath') is not None:
            self.keep_full_path = m.get('keepFullPath')
        if m.get('lastModifiedTime') is not None:
            self.last_modified_time = m.get('lastModifiedTime')
        if m.get('namespaceID') is not None:
            self.namespace_id = m.get('namespaceID')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('routeConfig') is not None:
            temp_model = RouteConfig()
            self.route_config = temp_model.from_map(m['routeConfig'])
        if m.get('subdomainCount') is not None:
            self.subdomain_count = m.get('subdomainCount')
        if m.get('tlsConfig') is not None:
            temp_model = TLSConfig()
            self.tls_config = temp_model.from_map(m['tlsConfig'])
        if m.get('wafConfig') is not None:
            temp_model = WAFConfig()
            self.waf_config = temp_model.from_map(m['wafConfig'])
        return self


class WebLogEntry(TeaModel):
    def __init__(
        self,
        message: str = None,
    ):
        self.message = message

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        return self


class DescribeInstanceLogsOutput(TeaModel):
    def __init__(
        self,
        web_log_entrys: List[WebLogEntry] = None,
    ):
        self.web_log_entrys = web_log_entrys

    def validate(self):
        if self.web_log_entrys:
            for k in self.web_log_entrys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['WebLogEntrys'] = []
        if self.web_log_entrys is not None:
            for k in self.web_log_entrys:
                result['WebLogEntrys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.web_log_entrys = []
        if m.get('WebLogEntrys') is not None:
            for k in m.get('WebLogEntrys'):
                temp_model = WebLogEntry()
                self.web_log_entrys.append(temp_model.from_map(k))
        return self


class WebStaticsInfo(TeaModel):
    def __init__(
        self,
        cpu_usage: int = None,
        internet_traffic_out: int = None,
        invocations: int = None,
        memory_usage: int = None,
    ):
        self.cpu_usage = cpu_usage
        self.internet_traffic_out = internet_traffic_out
        self.invocations = invocations
        self.memory_usage = memory_usage

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu_usage is not None:
            result['CpuUsage'] = self.cpu_usage
        if self.internet_traffic_out is not None:
            result['InternetTrafficOut'] = self.internet_traffic_out
        if self.invocations is not None:
            result['Invocations'] = self.invocations
        if self.memory_usage is not None:
            result['MemoryUsage'] = self.memory_usage
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CpuUsage') is not None:
            self.cpu_usage = m.get('CpuUsage')
        if m.get('InternetTrafficOut') is not None:
            self.internet_traffic_out = m.get('InternetTrafficOut')
        if m.get('Invocations') is not None:
            self.invocations = m.get('Invocations')
        if m.get('MemoryUsage') is not None:
            self.memory_usage = m.get('MemoryUsage')
        return self


class DescribeWebAppStaticsOutput(TeaModel):
    def __init__(
        self,
        length: int = None,
        web_app_statics: List[WebStaticsInfo] = None,
    ):
        self.length = length
        self.web_app_statics = web_app_statics

    def validate(self):
        if self.web_app_statics:
            for k in self.web_app_statics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.length is not None:
            result['Length'] = self.length
        result['WebAppStatics'] = []
        if self.web_app_statics is not None:
            for k in self.web_app_statics:
                result['WebAppStatics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Length') is not None:
            self.length = m.get('Length')
        self.web_app_statics = []
        if m.get('WebAppStatics') is not None:
            for k in m.get('WebAppStatics'):
                temp_model = WebStaticsInfo()
                self.web_app_statics.append(temp_model.from_map(k))
        return self


class DescribeWebStaticsQueryOutput(TeaModel):
    def __init__(
        self,
        length: int = None,
        web_statics: List[WebStaticsInfo] = None,
    ):
        self.length = length
        self.web_statics = web_statics

    def validate(self):
        if self.web_statics:
            for k in self.web_statics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.length is not None:
            result['Length'] = self.length
        result['WebStatics'] = []
        if self.web_statics is not None:
            for k in self.web_statics:
                result['WebStatics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Length') is not None:
            self.length = m.get('Length')
        self.web_statics = []
        if m.get('WebStatics') is not None:
            for k in m.get('WebStatics'):
                temp_model = WebStaticsInfo()
                self.web_statics.append(temp_model.from_map(k))
        return self


class ExecAction(TeaModel):
    def __init__(
        self,
        command: List[str] = None,
    ):
        self.command = command

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['command'] = self.command
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('command') is not None:
            self.command = m.get('command')
        return self


class ExternalErrorSAEWeb(TeaModel):
    def __init__(
        self,
        code: int = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.error_code = error_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['code'] = self.code
        if self.error_code is not None:
            result['errorCode'] = self.error_code
        if self.message is not None:
            result['message'] = self.message
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.success is not None:
            result['success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('code') is not None:
            self.code = m.get('code')
        if m.get('errorCode') is not None:
            self.error_code = m.get('errorCode')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('success') is not None:
            self.success = m.get('success')
        return self


class GRPCAction(TeaModel):
    def __init__(
        self,
        port: int = None,
        service: str = None,
    ):
        self.port = port
        self.service = service

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.port is not None:
            result['port'] = self.port
        if self.service is not None:
            result['service'] = self.service
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('port') is not None:
            self.port = m.get('port')
        if m.get('service') is not None:
            self.service = m.get('service')
        return self


class GetApplicationLogsInput(TeaModel):
    def __init__(
        self,
        backward_line: int = None,
        end_time: int = None,
        forward_line: int = None,
        instance_id: str = None,
        is_tail: bool = None,
        match: str = None,
        message: str = None,
        offset: int = None,
        pack_id: str = None,
        pack_meta: str = None,
        start_time: int = None,
        timestamp: str = None,
        version_id: str = None,
    ):
        self.backward_line = backward_line
        # This parameter is required.
        self.end_time = end_time
        self.forward_line = forward_line
        self.instance_id = instance_id
        self.is_tail = is_tail
        self.match = match
        self.message = message
        self.offset = offset
        self.pack_id = pack_id
        self.pack_meta = pack_meta
        # This parameter is required.
        self.start_time = start_time
        self.timestamp = timestamp
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backward_line is not None:
            result['backwardLine'] = self.backward_line
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.forward_line is not None:
            result['forwardLine'] = self.forward_line
        if self.instance_id is not None:
            result['instanceID'] = self.instance_id
        if self.is_tail is not None:
            result['isTail'] = self.is_tail
        if self.match is not None:
            result['match'] = self.match
        if self.message is not None:
            result['message'] = self.message
        if self.offset is not None:
            result['offset'] = self.offset
        if self.pack_id is not None:
            result['packID'] = self.pack_id
        if self.pack_meta is not None:
            result['packMeta'] = self.pack_meta
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.version_id is not None:
            result['versionID'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('backwardLine') is not None:
            self.backward_line = m.get('backwardLine')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('forwardLine') is not None:
            self.forward_line = m.get('forwardLine')
        if m.get('instanceID') is not None:
            self.instance_id = m.get('instanceID')
        if m.get('isTail') is not None:
            self.is_tail = m.get('isTail')
        if m.get('match') is not None:
            self.match = m.get('match')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('packID') is not None:
            self.pack_id = m.get('packID')
        if m.get('packMeta') is not None:
            self.pack_meta = m.get('packMeta')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('versionID') is not None:
            self.version_id = m.get('versionID')
        return self


class LogEntry(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        message: str = None,
        offset: int = None,
        pack_id: str = None,
        pack_meta: str = None,
        qualifier: str = None,
        timestamp: int = None,
        version_id: str = None,
    ):
        self.instance_id = instance_id
        self.message = message
        self.offset = offset
        self.pack_id = pack_id
        self.pack_meta = pack_meta
        self.qualifier = qualifier
        self.timestamp = timestamp
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['instanceID'] = self.instance_id
        if self.message is not None:
            result['message'] = self.message
        if self.offset is not None:
            result['offset'] = self.offset
        if self.pack_id is not None:
            result['packID'] = self.pack_id
        if self.pack_meta is not None:
            result['packMeta'] = self.pack_meta
        if self.qualifier is not None:
            result['qualifier'] = self.qualifier
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.version_id is not None:
            result['versionID'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('instanceID') is not None:
            self.instance_id = m.get('instanceID')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('packID') is not None:
            self.pack_id = m.get('packID')
        if m.get('packMeta') is not None:
            self.pack_meta = m.get('packMeta')
        if m.get('qualifier') is not None:
            self.qualifier = m.get('qualifier')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('versionID') is not None:
            self.version_id = m.get('versionID')
        return self


class GetApplicationLogsOutput(TeaModel):
    def __init__(
        self,
        log_entrys: List[LogEntry] = None,
        next_offset: int = None,
        request_id: str = None,
    ):
        self.log_entrys = log_entrys
        self.next_offset = next_offset
        self.request_id = request_id

    def validate(self):
        if self.log_entrys:
            for k in self.log_entrys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['logEntrys'] = []
        if self.log_entrys is not None:
            for k in self.log_entrys:
                result['logEntrys'].append(k.to_map() if k else None)
        if self.next_offset is not None:
            result['nextOffset'] = self.next_offset
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.log_entrys = []
        if m.get('logEntrys') is not None:
            for k in m.get('logEntrys'):
                temp_model = LogEntry()
                self.log_entrys.append(temp_model.from_map(k))
        if m.get('nextOffset') is not None:
            self.next_offset = m.get('nextOffset')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetInstanceLogsInput(TeaModel):
    def __init__(
        self,
        backward_line: int = None,
        end_time: int = None,
        forward_line: int = None,
        is_tail: bool = None,
        match: str = None,
        message: str = None,
        offset: int = None,
        pack_id: str = None,
        pack_meta: str = None,
        start_time: int = None,
        timestamp: str = None,
        version_id: str = None,
    ):
        self.backward_line = backward_line
        # This parameter is required.
        self.end_time = end_time
        self.forward_line = forward_line
        self.is_tail = is_tail
        self.match = match
        self.message = message
        self.offset = offset
        self.pack_id = pack_id
        self.pack_meta = pack_meta
        # This parameter is required.
        self.start_time = start_time
        self.timestamp = timestamp
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backward_line is not None:
            result['backwardLine'] = self.backward_line
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.forward_line is not None:
            result['forwardLine'] = self.forward_line
        if self.is_tail is not None:
            result['isTail'] = self.is_tail
        if self.match is not None:
            result['match'] = self.match
        if self.message is not None:
            result['message'] = self.message
        if self.offset is not None:
            result['offset'] = self.offset
        if self.pack_id is not None:
            result['packID'] = self.pack_id
        if self.pack_meta is not None:
            result['packMeta'] = self.pack_meta
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.version_id is not None:
            result['versionID'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('backwardLine') is not None:
            self.backward_line = m.get('backwardLine')
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('forwardLine') is not None:
            self.forward_line = m.get('forwardLine')
        if m.get('isTail') is not None:
            self.is_tail = m.get('isTail')
        if m.get('match') is not None:
            self.match = m.get('match')
        if m.get('message') is not None:
            self.message = m.get('message')
        if m.get('offset') is not None:
            self.offset = m.get('offset')
        if m.get('packID') is not None:
            self.pack_id = m.get('packID')
        if m.get('packMeta') is not None:
            self.pack_meta = m.get('packMeta')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('versionID') is not None:
            self.version_id = m.get('versionID')
        return self


class GetInstanceLogsOutput(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetPerRequestLogsInput(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        error_type: str = None,
        forward_line: int = None,
        instance_id: str = None,
        is_cold_start: bool = None,
        request_id: str = None,
        start_time: int = None,
        timestamp: str = None,
    ):
        # This parameter is required.
        self.end_time = end_time
        self.error_type = error_type
        self.forward_line = forward_line
        self.instance_id = instance_id
        self.is_cold_start = is_cold_start
        # This parameter is required.
        self.request_id = request_id
        # This parameter is required.
        self.start_time = start_time
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['endTime'] = self.end_time
        if self.error_type is not None:
            result['errorType'] = self.error_type
        if self.forward_line is not None:
            result['forwardLine'] = self.forward_line
        if self.instance_id is not None:
            result['instanceID'] = self.instance_id
        if self.is_cold_start is not None:
            result['isColdStart'] = self.is_cold_start
        if self.request_id is not None:
            result['requestID'] = self.request_id
        if self.start_time is not None:
            result['startTime'] = self.start_time
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('endTime') is not None:
            self.end_time = m.get('endTime')
        if m.get('errorType') is not None:
            self.error_type = m.get('errorType')
        if m.get('forwardLine') is not None:
            self.forward_line = m.get('forwardLine')
        if m.get('instanceID') is not None:
            self.instance_id = m.get('instanceID')
        if m.get('isColdStart') is not None:
            self.is_cold_start = m.get('isColdStart')
        if m.get('requestID') is not None:
            self.request_id = m.get('requestID')
        if m.get('startTime') is not None:
            self.start_time = m.get('startTime')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class GetPerRequestLogsOutput(TeaModel):
    def __init__(
        self,
        data: str = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['data'] = self.data
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('data') is not None:
            self.data = m.get('data')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class GetQuotaOutput(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        instance_limit: int = None,
        instance_used: int = None,
    ):
        self.request_id = request_id
        self.instance_limit = instance_limit
        self.instance_used = instance_used

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.instance_limit is not None:
            result['instanceLimit'] = self.instance_limit
        if self.instance_used is not None:
            result['instanceUsed'] = self.instance_used
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('instanceLimit') is not None:
            self.instance_limit = m.get('instanceLimit')
        if m.get('instanceUsed') is not None:
            self.instance_used = m.get('instanceUsed')
        return self


class InstanceExecAuthorizationInputOptions(TeaModel):
    def __init__(
        self,
        command: List[str] = None,
        stderr: bool = None,
        stdin: bool = None,
        stdout: bool = None,
        tty: bool = None,
    ):
        self.command = command
        self.stderr = stderr
        self.stdin = stdin
        self.stdout = stdout
        self.tty = tty

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.command is not None:
            result['command'] = self.command
        if self.stderr is not None:
            result['stderr'] = self.stderr
        if self.stdin is not None:
            result['stdin'] = self.stdin
        if self.stdout is not None:
            result['stdout'] = self.stdout
        if self.tty is not None:
            result['tty'] = self.tty
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('stderr') is not None:
            self.stderr = m.get('stderr')
        if m.get('stdin') is not None:
            self.stdin = m.get('stdin')
        if m.get('stdout') is not None:
            self.stdout = m.get('stdout')
        if m.get('tty') is not None:
            self.tty = m.get('tty')
        return self


class InstanceExecAuthorizationInput(TeaModel):
    def __init__(
        self,
        options: InstanceExecAuthorizationInputOptions = None,
    ):
        self.options = options

    def validate(self):
        if self.options:
            self.options.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.options is not None:
            result['options'] = self.options.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('options') is not None:
            temp_model = InstanceExecAuthorizationInputOptions()
            self.options = temp_model.from_map(m['options'])
        return self


class InstanceExecAuthorizationOutput(TeaModel):
    def __init__(
        self,
        access_key_id: str = None,
        account_id: str = None,
        authorization: str = None,
        date: str = None,
        endpoint: str = None,
        request_id: str = None,
    ):
        self.access_key_id = access_key_id
        self.account_id = account_id
        self.authorization = authorization
        self.date = date
        self.endpoint = endpoint
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key_id is not None:
            result['accessKeyId'] = self.access_key_id
        if self.account_id is not None:
            result['accountId'] = self.account_id
        if self.authorization is not None:
            result['authorization'] = self.authorization
        if self.date is not None:
            result['date'] = self.date
        if self.endpoint is not None:
            result['endpoint'] = self.endpoint
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('accessKeyId') is not None:
            self.access_key_id = m.get('accessKeyId')
        if m.get('accountId') is not None:
            self.account_id = m.get('accountId')
        if m.get('authorization') is not None:
            self.authorization = m.get('authorization')
        if m.get('date') is not None:
            self.date = m.get('date')
        if m.get('endpoint') is not None:
            self.endpoint = m.get('endpoint')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class InstanceInfo(TeaModel):
    def __init__(
        self,
        image_url: str = None,
        instance_id: str = None,
        status: str = None,
        version_id: str = None,
    ):
        self.image_url = image_url
        self.instance_id = instance_id
        self.status = status
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_url is not None:
            result['imageUrl'] = self.image_url
        if self.instance_id is not None:
            result['instanceId'] = self.instance_id
        if self.status is not None:
            result['status'] = self.status
        if self.version_id is not None:
            result['versionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('imageUrl') is not None:
            self.image_url = m.get('imageUrl')
        if m.get('instanceId') is not None:
            self.instance_id = m.get('instanceId')
        if m.get('status') is not None:
            self.status = m.get('status')
        if m.get('versionId') is not None:
            self.version_id = m.get('versionId')
        return self


class InstanceMetricInfo(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        cpu_percent: float = None,
        cpu_quota_percent: float = None,
        instance_id: str = None,
        memory_limit_mb: float = None,
        memory_usage_mb: float = None,
        timestamp: int = None,
    ):
        self.application_id = application_id
        self.cpu_percent = cpu_percent
        self.cpu_quota_percent = cpu_quota_percent
        self.instance_id = instance_id
        self.memory_limit_mb = memory_limit_mb
        self.memory_usage_mb = memory_usage_mb
        self.timestamp = timestamp

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['applicationID'] = self.application_id
        if self.cpu_percent is not None:
            result['cpuPercent'] = self.cpu_percent
        if self.cpu_quota_percent is not None:
            result['cpuQuotaPercent'] = self.cpu_quota_percent
        if self.instance_id is not None:
            result['instanceID'] = self.instance_id
        if self.memory_limit_mb is not None:
            result['memoryLimitMB'] = self.memory_limit_mb
        if self.memory_usage_mb is not None:
            result['memoryUsageMB'] = self.memory_usage_mb
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationID') is not None:
            self.application_id = m.get('applicationID')
        if m.get('cpuPercent') is not None:
            self.cpu_percent = m.get('cpuPercent')
        if m.get('cpuQuotaPercent') is not None:
            self.cpu_quota_percent = m.get('cpuQuotaPercent')
        if m.get('instanceID') is not None:
            self.instance_id = m.get('instanceID')
        if m.get('memoryLimitMB') is not None:
            self.memory_limit_mb = m.get('memoryLimitMB')
        if m.get('memoryUsageMB') is not None:
            self.memory_usage_mb = m.get('memoryUsageMB')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        return self


class ListApplicationVersionsOutput(TeaModel):
    def __init__(
        self,
        direction: str = None,
        next_token: str = None,
        request_id: str = None,
        versions: List[Version] = None,
    ):
        self.direction = direction
        self.next_token = next_token
        self.request_id = request_id
        self.versions = versions

    def validate(self):
        if self.versions:
            for k in self.versions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.direction is not None:
            result['direction'] = self.direction
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['versions'] = []
        if self.versions is not None:
            for k in self.versions:
                result['versions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('direction') is not None:
            self.direction = m.get('direction')
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.versions = []
        if m.get('versions') is not None:
            for k in m.get('versions'):
                temp_model = Version()
                self.versions.append(temp_model.from_map(k))
        return self


class ListApplicationsOutput(TeaModel):
    def __init__(
        self,
        applications: List[Application] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.applications = applications
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['applications'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('applications') is not None:
            for k in m.get('applications'):
                temp_model = Application()
                self.applications.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class ListApplicationsWithStatusOutput(TeaModel):
    def __init__(
        self,
        applications: List[ApplicationWithStatus] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.applications = applications
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.applications:
            for k in self.applications:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['applications'] = []
        if self.applications is not None:
            for k in self.applications:
                result['applications'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.applications = []
        if m.get('applications') is not None:
            for k in m.get('applications'):
                temp_model = ApplicationWithStatus()
                self.applications.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class ListCustomDomainOutput(TeaModel):
    def __init__(
        self,
        custom_domains: List[CustomDomain] = None,
        next_token: str = None,
        request_id: str = None,
    ):
        self.custom_domains = custom_domains
        self.next_token = next_token
        self.request_id = request_id

    def validate(self):
        if self.custom_domains:
            for k in self.custom_domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['customDomains'] = []
        if self.custom_domains is not None:
            for k in self.custom_domains:
                result['customDomains'].append(k.to_map() if k else None)
        if self.next_token is not None:
            result['nextToken'] = self.next_token
        if self.request_id is not None:
            result['requestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.custom_domains = []
        if m.get('customDomains') is not None:
            for k in m.get('customDomains'):
                temp_model = CustomDomain()
                self.custom_domains.append(temp_model.from_map(k))
        if m.get('nextToken') is not None:
            self.next_token = m.get('nextToken')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        return self


class ListInstancesMetricsOutput(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        metrics_list: List[InstanceMetricInfo] = None,
        page_number: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.request_id = request_id
        self.metrics_list = metrics_list
        self.page_number = page_number
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        if self.metrics_list:
            for k in self.metrics_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['metricsList'] = []
        if self.metrics_list is not None:
            for k in self.metrics_list:
                result['metricsList'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['pageNumber'] = self.page_number
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.total_count is not None:
            result['totalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.metrics_list = []
        if m.get('metricsList') is not None:
            for k in m.get('metricsList'):
                temp_model = InstanceMetricInfo()
                self.metrics_list.append(temp_model.from_map(k))
        if m.get('pageNumber') is not None:
            self.page_number = m.get('pageNumber')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('totalCount') is not None:
            self.total_count = m.get('totalCount')
        return self


class VersionStatus(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        status: str = None,
    ):
        self.error_message = error_message
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['errorMessage'] = self.error_message
        if self.status is not None:
            result['status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('errorMessage') is not None:
            self.error_message = m.get('errorMessage')
        if m.get('status') is not None:
            self.status = m.get('status')
        return self


class ListInstancesOutput(TeaModel):
    def __init__(
        self,
        current_error: str = None,
        instances: List[InstanceInfo] = None,
        request_id: str = None,
        version_status: Dict[str, VersionStatus] = None,
    ):
        self.current_error = current_error
        self.instances = instances
        self.request_id = request_id
        self.version_status = version_status

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.version_status:
            for v in self.version_status.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_error is not None:
            result['currentError'] = self.current_error
        result['instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['instances'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['requestId'] = self.request_id
        result['versionStatus'] = {}
        if self.version_status is not None:
            for k, v in self.version_status.items():
                result['versionStatus'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('currentError') is not None:
            self.current_error = m.get('currentError')
        self.instances = []
        if m.get('instances') is not None:
            for k in m.get('instances'):
                temp_model = InstanceInfo()
                self.instances.append(temp_model.from_map(k))
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        self.version_status = {}
        if m.get('versionStatus') is not None:
            for k, v in m.get('versionStatus').items():
                temp_model = VersionStatus()
                self.version_status[k] = temp_model.from_map(v)
        return self


class MetricInfo(TeaModel):
    def __init__(
        self,
        average: float = None,
        count: float = None,
        maximum: float = None,
        minimum: float = None,
        sum: float = None,
        timestamp: int = None,
        value: float = None,
    ):
        self.average = average
        self.count = count
        self.maximum = maximum
        self.minimum = minimum
        self.sum = sum
        self.timestamp = timestamp
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.average is not None:
            result['Average'] = self.average
        if self.count is not None:
            result['Count'] = self.count
        if self.maximum is not None:
            result['Maximum'] = self.maximum
        if self.minimum is not None:
            result['Minimum'] = self.minimum
        if self.sum is not None:
            result['Sum'] = self.sum
        if self.timestamp is not None:
            result['timestamp'] = self.timestamp
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Average') is not None:
            self.average = m.get('Average')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Maximum') is not None:
            self.maximum = m.get('Maximum')
        if m.get('Minimum') is not None:
            self.minimum = m.get('Minimum')
        if m.get('Sum') is not None:
            self.sum = m.get('Sum')
        if m.get('timestamp') is not None:
            self.timestamp = m.get('timestamp')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class ListMetricsOutput(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        metrics: Dict[str, List[MetricInfo]] = None,
    ):
        self.request_id = request_id
        self.metrics = metrics

    def validate(self):
        if self.metrics:
            for v in self.metrics.values():
                for k1 in v:
                    if k1:
                        k1.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['metrics'] = {}
        if self.metrics is not None:
            for k, v in self.metrics.items():
                l1 = []
                for k1 in v:
                    l1.append(k1.to_map() if k1 else None)
                result['metrics'][k] = l1
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.metrics = {}
        if m.get('metrics') is not None:
            for k, v in m.get('metrics').items():
                l1 = []
                for k1 in v:
                    temp_model = MetricInfo()
                    l1.append(temp_model.from_map(k1))
                self.metrics['k'] = l1
        return self


class StaticsInfo(TeaModel):
    def __init__(
        self,
        active_cpuusage: int = None,
        cost: float = None,
        disk_usage: int = None,
        function_name: str = None,
        gpu_usage: int = None,
        idle_cpuusage: int = None,
        instance_traffic_out: int = None,
        invocations: int = None,
        invoke_cdnout: int = None,
        invoke_internet_out: int = None,
        memory_usage: int = None,
        region: str = None,
        service_name: str = None,
    ):
        self.active_cpuusage = active_cpuusage
        self.cost = cost
        self.disk_usage = disk_usage
        self.function_name = function_name
        self.gpu_usage = gpu_usage
        self.idle_cpuusage = idle_cpuusage
        self.instance_traffic_out = instance_traffic_out
        self.invocations = invocations
        self.invoke_cdnout = invoke_cdnout
        self.invoke_internet_out = invoke_internet_out
        self.memory_usage = memory_usage
        self.region = region
        self.service_name = service_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active_cpuusage is not None:
            result['activeCPUUsage'] = self.active_cpuusage
        if self.cost is not None:
            result['cost'] = self.cost
        if self.disk_usage is not None:
            result['diskUsage'] = self.disk_usage
        if self.function_name is not None:
            result['functionName'] = self.function_name
        if self.gpu_usage is not None:
            result['gpuUsage'] = self.gpu_usage
        if self.idle_cpuusage is not None:
            result['idleCPUUsage'] = self.idle_cpuusage
        if self.instance_traffic_out is not None:
            result['instanceTrafficOut'] = self.instance_traffic_out
        if self.invocations is not None:
            result['invocations'] = self.invocations
        if self.invoke_cdnout is not None:
            result['invokeCDNOut'] = self.invoke_cdnout
        if self.invoke_internet_out is not None:
            result['invokeInternetOut'] = self.invoke_internet_out
        if self.memory_usage is not None:
            result['memoryUsage'] = self.memory_usage
        if self.region is not None:
            result['region'] = self.region
        if self.service_name is not None:
            result['serviceName'] = self.service_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('activeCPUUsage') is not None:
            self.active_cpuusage = m.get('activeCPUUsage')
        if m.get('cost') is not None:
            self.cost = m.get('cost')
        if m.get('diskUsage') is not None:
            self.disk_usage = m.get('diskUsage')
        if m.get('functionName') is not None:
            self.function_name = m.get('functionName')
        if m.get('gpuUsage') is not None:
            self.gpu_usage = m.get('gpuUsage')
        if m.get('idleCPUUsage') is not None:
            self.idle_cpuusage = m.get('idleCPUUsage')
        if m.get('instanceTrafficOut') is not None:
            self.instance_traffic_out = m.get('instanceTrafficOut')
        if m.get('invocations') is not None:
            self.invocations = m.get('invocations')
        if m.get('invokeCDNOut') is not None:
            self.invoke_cdnout = m.get('invokeCDNOut')
        if m.get('invokeInternetOut') is not None:
            self.invoke_internet_out = m.get('invokeInternetOut')
        if m.get('memoryUsage') is not None:
            self.memory_usage = m.get('memoryUsage')
        if m.get('region') is not None:
            self.region = m.get('region')
        if m.get('serviceName') is not None:
            self.service_name = m.get('serviceName')
        return self


class ListStaticsQueryResponse(TeaModel):
    def __init__(
        self,
        length: int = None,
        sort: str = None,
        statics: List[StaticsInfo] = None,
    ):
        self.length = length
        self.sort = sort
        self.statics = statics

    def validate(self):
        if self.statics:
            for k in self.statics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.length is not None:
            result['length'] = self.length
        if self.sort is not None:
            result['sort'] = self.sort
        result['statics'] = []
        if self.statics is not None:
            for k in self.statics:
                result['statics'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('length') is not None:
            self.length = m.get('length')
        if m.get('sort') is not None:
            self.sort = m.get('sort')
        self.statics = []
        if m.get('statics') is not None:
            for k in m.get('statics'):
                temp_model = StaticsInfo()
                self.statics.append(temp_model.from_map(k))
        return self


class WebInstanceInfo(TeaModel):
    def __init__(
        self,
        image_url: str = None,
        instance_id: str = None,
        status: str = None,
        version_id: str = None,
    ):
        self.image_url = image_url
        self.instance_id = instance_id
        self.status = status
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.status is not None:
            result['Status'] = self.status
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class WebVersionStatus(TeaModel):
    def __init__(
        self,
        error_message: str = None,
        status: str = None,
    ):
        self.error_message = error_message
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ListWebInstancesOutput(TeaModel):
    def __init__(
        self,
        current_error: str = None,
        web_instances: List[WebInstanceInfo] = None,
        web_version_status: Dict[str, WebVersionStatus] = None,
    ):
        self.current_error = current_error
        self.web_instances = web_instances
        self.web_version_status = web_version_status

    def validate(self):
        if self.web_instances:
            for k in self.web_instances:
                if k:
                    k.validate()
        if self.web_version_status:
            for v in self.web_version_status.values():
                if v:
                    v.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_error is not None:
            result['CurrentError'] = self.current_error
        result['WebInstances'] = []
        if self.web_instances is not None:
            for k in self.web_instances:
                result['WebInstances'].append(k.to_map() if k else None)
        result['WebVersionStatus'] = {}
        if self.web_version_status is not None:
            for k, v in self.web_version_status.items():
                result['WebVersionStatus'][k] = v.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentError') is not None:
            self.current_error = m.get('CurrentError')
        self.web_instances = []
        if m.get('WebInstances') is not None:
            for k in m.get('WebInstances'):
                temp_model = WebInstanceInfo()
                self.web_instances.append(temp_model.from_map(k))
        self.web_version_status = {}
        if m.get('WebVersionStatus') is not None:
            for k, v in m.get('WebVersionStatus').items():
                temp_model = WebVersionStatus()
                self.web_version_status[k] = temp_model.from_map(v)
        return self


class ListWebApplicationInstancesBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListWebInstancesOutput = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListWebInstancesOutput()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class Revision(TeaModel):
    def __init__(
        self,
        created_time: str = None,
        description: str = None,
        revision_config: RevisionConfig = None,
        revision_id: str = None,
        weight: float = None,
    ):
        self.created_time = created_time
        self.description = description
        self.revision_config = revision_config
        self.revision_id = revision_id
        self.weight = weight

    def validate(self):
        if self.revision_config:
            self.revision_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.description is not None:
            result['Description'] = self.description
        if self.revision_config is not None:
            result['RevisionConfig'] = self.revision_config.to_map()
        if self.revision_id is not None:
            result['RevisionId'] = self.revision_id
        if self.weight is not None:
            result['Weight'] = self.weight
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RevisionConfig') is not None:
            temp_model = RevisionConfig()
            self.revision_config = temp_model.from_map(m['RevisionConfig'])
        if m.get('RevisionId') is not None:
            self.revision_id = m.get('RevisionId')
        if m.get('Weight') is not None:
            self.weight = m.get('Weight')
        return self


class ListWebApplicationRevisionsOutput(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        revisions: List[Revision] = None,
    ):
        self.next_token = next_token
        self.revisions = revisions

    def validate(self):
        if self.revisions:
            for k in self.revisions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['Revisions'] = []
        if self.revisions is not None:
            for k in self.revisions:
                result['Revisions'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.revisions = []
        if m.get('Revisions') is not None:
            for k in m.get('Revisions'):
                temp_model = Revision()
                self.revisions.append(temp_model.from_map(k))
        return self


class ListWebApplicationRevisionsBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListWebApplicationRevisionsOutput = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListWebApplicationRevisionsOutput()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebApplication(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        application_name: str = None,
        created_time: str = None,
        description: str = None,
        internet_url: str = None,
        intranet_url: str = None,
        last_modified_time: str = None,
        namespace_id: str = None,
        revision_config: RevisionConfig = None,
        vpc_id: str = None,
        web_scaling_config: WebScalingConfig = None,
        web_traffic_config: WebTrafficConfig = None,
    ):
        # This parameter is required.
        self.application_id = application_id
        # This parameter is required.
        self.application_name = application_name
        self.created_time = created_time
        self.description = description
        self.internet_url = internet_url
        self.intranet_url = intranet_url
        self.last_modified_time = last_modified_time
        self.namespace_id = namespace_id
        self.revision_config = revision_config
        self.vpc_id = vpc_id
        self.web_scaling_config = web_scaling_config
        self.web_traffic_config = web_traffic_config

    def validate(self):
        if self.revision_config:
            self.revision_config.validate()
        if self.web_scaling_config:
            self.web_scaling_config.validate()
        if self.web_traffic_config:
            self.web_traffic_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['ApplicationId'] = self.application_id
        if self.application_name is not None:
            result['ApplicationName'] = self.application_name
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.description is not None:
            result['Description'] = self.description
        if self.internet_url is not None:
            result['InternetURL'] = self.internet_url
        if self.intranet_url is not None:
            result['IntranetURL'] = self.intranet_url
        if self.last_modified_time is not None:
            result['LastModifiedTime'] = self.last_modified_time
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.revision_config is not None:
            result['RevisionConfig'] = self.revision_config.to_map()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.web_scaling_config is not None:
            result['WebScalingConfig'] = self.web_scaling_config.to_map()
        if self.web_traffic_config is not None:
            result['WebTrafficConfig'] = self.web_traffic_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ApplicationId') is not None:
            self.application_id = m.get('ApplicationId')
        if m.get('ApplicationName') is not None:
            self.application_name = m.get('ApplicationName')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('InternetURL') is not None:
            self.internet_url = m.get('InternetURL')
        if m.get('IntranetURL') is not None:
            self.intranet_url = m.get('IntranetURL')
        if m.get('LastModifiedTime') is not None:
            self.last_modified_time = m.get('LastModifiedTime')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('RevisionConfig') is not None:
            temp_model = RevisionConfig()
            self.revision_config = temp_model.from_map(m['RevisionConfig'])
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WebScalingConfig') is not None:
            temp_model = WebScalingConfig()
            self.web_scaling_config = temp_model.from_map(m['WebScalingConfig'])
        if m.get('WebTrafficConfig') is not None:
            temp_model = WebTrafficConfig()
            self.web_traffic_config = temp_model.from_map(m['WebTrafficConfig'])
        return self


class WebApplicationWithInstanceCount(TeaModel):
    def __init__(
        self,
        instance_count: int = None,
        web_application: WebApplication = None,
    ):
        self.instance_count = instance_count
        self.web_application = web_application

    def validate(self):
        if self.web_application:
            self.web_application.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.web_application is not None:
            result['WebApplication'] = self.web_application.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('WebApplication') is not None:
            temp_model = WebApplication()
            self.web_application = temp_model.from_map(m['WebApplication'])
        return self


class ListWebApplicationsOutput(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        web_application_with_instance_count: List[WebApplicationWithInstanceCount] = None,
    ):
        self.next_token = next_token
        self.web_application_with_instance_count = web_application_with_instance_count

    def validate(self):
        if self.web_application_with_instance_count:
            for k in self.web_application_with_instance_count:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['WebApplicationWithInstanceCount'] = []
        if self.web_application_with_instance_count is not None:
            for k in self.web_application_with_instance_count:
                result['WebApplicationWithInstanceCount'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.web_application_with_instance_count = []
        if m.get('WebApplicationWithInstanceCount') is not None:
            for k in m.get('WebApplicationWithInstanceCount'):
                temp_model = WebApplicationWithInstanceCount()
                self.web_application_with_instance_count.append(temp_model.from_map(k))
        return self


class ListWebApplicationsBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListWebApplicationsOutput = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListWebApplicationsOutput()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebCustomDomain(TeaModel):
    def __init__(
        self,
        account_id: str = None,
        created_time: str = None,
        default_forwarding_app_name: str = None,
        domain_name: str = None,
        last_modified_time: str = None,
        namespace_id: str = None,
        protocol: str = None,
        web_cert_config: WebCertConfig = None,
        web_tlsconfig: WebTLSConfig = None,
        web_wafconfig: WebWAFConfig = None,
    ):
        self.account_id = account_id
        self.created_time = created_time
        self.default_forwarding_app_name = default_forwarding_app_name
        self.domain_name = domain_name
        self.last_modified_time = last_modified_time
        self.namespace_id = namespace_id
        self.protocol = protocol
        self.web_cert_config = web_cert_config
        self.web_tlsconfig = web_tlsconfig
        self.web_wafconfig = web_wafconfig

    def validate(self):
        if self.web_cert_config:
            self.web_cert_config.validate()
        if self.web_tlsconfig:
            self.web_tlsconfig.validate()
        if self.web_wafconfig:
            self.web_wafconfig.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.default_forwarding_app_name is not None:
            result['DefaultForwardingAppName'] = self.default_forwarding_app_name
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.last_modified_time is not None:
            result['LastModifiedTime'] = self.last_modified_time
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.web_cert_config is not None:
            result['WebCertConfig'] = self.web_cert_config.to_map()
        if self.web_tlsconfig is not None:
            result['WebTLSConfig'] = self.web_tlsconfig.to_map()
        if self.web_wafconfig is not None:
            result['WebWAFConfig'] = self.web_wafconfig.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('DefaultForwardingAppName') is not None:
            self.default_forwarding_app_name = m.get('DefaultForwardingAppName')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('LastModifiedTime') is not None:
            self.last_modified_time = m.get('LastModifiedTime')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('WebCertConfig') is not None:
            temp_model = WebCertConfig()
            self.web_cert_config = temp_model.from_map(m['WebCertConfig'])
        if m.get('WebTLSConfig') is not None:
            temp_model = WebTLSConfig()
            self.web_tlsconfig = temp_model.from_map(m['WebTLSConfig'])
        if m.get('WebWAFConfig') is not None:
            temp_model = WebWAFConfig()
            self.web_wafconfig = temp_model.from_map(m['WebWAFConfig'])
        return self


class ListWebCustomDomainOutput(TeaModel):
    def __init__(
        self,
        next_token: str = None,
        web_custom_domains: List[WebCustomDomain] = None,
    ):
        self.next_token = next_token
        self.web_custom_domains = web_custom_domains

    def validate(self):
        if self.web_custom_domains:
            for k in self.web_custom_domains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.next_token is not None:
            result['NextToken'] = self.next_token
        result['WebCustomDomains'] = []
        if self.web_custom_domains is not None:
            for k in self.web_custom_domains:
                result['WebCustomDomains'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NextToken') is not None:
            self.next_token = m.get('NextToken')
        self.web_custom_domains = []
        if m.get('WebCustomDomains') is not None:
            for k in m.get('WebCustomDomains'):
                temp_model = WebCustomDomain()
                self.web_custom_domains.append(temp_model.from_map(k))
        return self


class ListWebCustomDomainBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: ListWebCustomDomainOutput = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListWebCustomDomainOutput()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class PermissionAssistantApi(TeaModel):
    def __init__(
        self,
        create_time: str = None,
        id: int = None,
        name: str = None,
        resource_type: str = None,
        update_time: str = None,
    ):
        self.create_time = create_time
        self.id = id
        self.name = name
        self.resource_type = resource_type
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time is not None:
            result['createTime'] = self.create_time
        if self.id is not None:
            result['id'] = self.id
        if self.name is not None:
            result['name'] = self.name
        if self.resource_type is not None:
            result['resourceType'] = self.resource_type
        if self.update_time is not None:
            result['updateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('createTime') is not None:
            self.create_time = m.get('createTime')
        if m.get('id') is not None:
            self.id = m.get('id')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('resourceType') is not None:
            self.resource_type = m.get('resourceType')
        if m.get('updateTime') is not None:
            self.update_time = m.get('updateTime')
        return self


class PolicyItem(TeaModel):
    def __init__(
        self,
        key: str = None,
        operator: str = None,
        type: str = None,
        value: str = None,
    ):
        self.key = key
        self.operator = operator
        self.type = type
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['key'] = self.key
        if self.operator is not None:
            result['operator'] = self.operator
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('key') is not None:
            self.key = m.get('key')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class PriceEstimateFeature(TeaModel):
    def __init__(
        self,
        app_type: str = None,
        cpu_core: float = None,
        cpu_strategy: str = None,
        env_type: str = None,
        high_load_instance_count: int = None,
        high_load_qps: float = None,
        high_load_seconds: int = None,
        instance_qps: float = None,
        internet_outbound_gi_b: float = None,
        low_load_instance_count: int = None,
        low_load_qps: float = None,
        low_load_seconds: int = None,
        max_instance_count: int = None,
        memory_gi_b: float = None,
        min_instance_count: int = None,
        none_load_instance_count: int = None,
        none_load_seconds: int = None,
        region_id: str = None,
    ):
        # This parameter is required.
        self.app_type = app_type
        # This parameter is required.
        self.cpu_core = cpu_core
        # This parameter is required.
        self.cpu_strategy = cpu_strategy
        # This parameter is required.
        self.env_type = env_type
        self.high_load_instance_count = high_load_instance_count
        self.high_load_qps = high_load_qps
        self.high_load_seconds = high_load_seconds
        self.instance_qps = instance_qps
        self.internet_outbound_gi_b = internet_outbound_gi_b
        self.low_load_instance_count = low_load_instance_count
        self.low_load_qps = low_load_qps
        self.low_load_seconds = low_load_seconds
        self.max_instance_count = max_instance_count
        # This parameter is required.
        self.memory_gi_b = memory_gi_b
        self.min_instance_count = min_instance_count
        self.none_load_instance_count = none_load_instance_count
        self.none_load_seconds = none_load_seconds
        # This parameter is required.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_type is not None:
            result['AppType'] = self.app_type
        if self.cpu_core is not None:
            result['CpuCore'] = self.cpu_core
        if self.cpu_strategy is not None:
            result['CpuStrategy'] = self.cpu_strategy
        if self.env_type is not None:
            result['EnvType'] = self.env_type
        if self.high_load_instance_count is not None:
            result['HighLoadInstanceCount'] = self.high_load_instance_count
        if self.high_load_qps is not None:
            result['HighLoadQps'] = self.high_load_qps
        if self.high_load_seconds is not None:
            result['HighLoadSeconds'] = self.high_load_seconds
        if self.instance_qps is not None:
            result['InstanceQps'] = self.instance_qps
        if self.internet_outbound_gi_b is not None:
            result['InternetOutboundGiB'] = self.internet_outbound_gi_b
        if self.low_load_instance_count is not None:
            result['LowLoadInstanceCount'] = self.low_load_instance_count
        if self.low_load_qps is not None:
            result['LowLoadQps'] = self.low_load_qps
        if self.low_load_seconds is not None:
            result['LowLoadSeconds'] = self.low_load_seconds
        if self.max_instance_count is not None:
            result['MaxInstanceCount'] = self.max_instance_count
        if self.memory_gi_b is not None:
            result['MemoryGiB'] = self.memory_gi_b
        if self.min_instance_count is not None:
            result['MinInstanceCount'] = self.min_instance_count
        if self.none_load_instance_count is not None:
            result['NoneLoadInstanceCount'] = self.none_load_instance_count
        if self.none_load_seconds is not None:
            result['NoneLoadSeconds'] = self.none_load_seconds
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppType') is not None:
            self.app_type = m.get('AppType')
        if m.get('CpuCore') is not None:
            self.cpu_core = m.get('CpuCore')
        if m.get('CpuStrategy') is not None:
            self.cpu_strategy = m.get('CpuStrategy')
        if m.get('EnvType') is not None:
            self.env_type = m.get('EnvType')
        if m.get('HighLoadInstanceCount') is not None:
            self.high_load_instance_count = m.get('HighLoadInstanceCount')
        if m.get('HighLoadQps') is not None:
            self.high_load_qps = m.get('HighLoadQps')
        if m.get('HighLoadSeconds') is not None:
            self.high_load_seconds = m.get('HighLoadSeconds')
        if m.get('InstanceQps') is not None:
            self.instance_qps = m.get('InstanceQps')
        if m.get('InternetOutboundGiB') is not None:
            self.internet_outbound_gi_b = m.get('InternetOutboundGiB')
        if m.get('LowLoadInstanceCount') is not None:
            self.low_load_instance_count = m.get('LowLoadInstanceCount')
        if m.get('LowLoadQps') is not None:
            self.low_load_qps = m.get('LowLoadQps')
        if m.get('LowLoadSeconds') is not None:
            self.low_load_seconds = m.get('LowLoadSeconds')
        if m.get('MaxInstanceCount') is not None:
            self.max_instance_count = m.get('MaxInstanceCount')
        if m.get('MemoryGiB') is not None:
            self.memory_gi_b = m.get('MemoryGiB')
        if m.get('MinInstanceCount') is not None:
            self.min_instance_count = m.get('MinInstanceCount')
        if m.get('NoneLoadInstanceCount') is not None:
            self.none_load_instance_count = m.get('NoneLoadInstanceCount')
        if m.get('NoneLoadSeconds') is not None:
            self.none_load_seconds = m.get('NoneLoadSeconds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class PriceEstimateOutputAppsUsages(TeaModel):
    def __init__(
        self,
        amount: float = None,
        id: str = None,
        unit: str = None,
    ):
        self.amount = amount
        self.id = id
        self.unit = unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.id is not None:
            result['Id'] = self.id
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class PriceEstimateOutputApps(TeaModel):
    def __init__(
        self,
        feature: PriceEstimateFeature = None,
        id: int = None,
        usages: List[PriceEstimateOutputAppsUsages] = None,
    ):
        self.feature = feature
        self.id = id
        self.usages = usages

    def validate(self):
        if self.feature:
            self.feature.validate()
        if self.usages:
            for k in self.usages:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.feature is not None:
            result['Feature'] = self.feature.to_map()
        if self.id is not None:
            result['Id'] = self.id
        result['Usages'] = []
        if self.usages is not None:
            for k in self.usages:
                result['Usages'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Feature') is not None:
            temp_model = PriceEstimateFeature()
            self.feature = temp_model.from_map(m['Feature'])
        if m.get('Id') is not None:
            self.id = m.get('Id')
        self.usages = []
        if m.get('Usages') is not None:
            for k in m.get('Usages'):
                temp_model = PriceEstimateOutputAppsUsages()
                self.usages.append(temp_model.from_map(k))
        return self


class PriceEstimateOutputItemsSteps(TeaModel):
    def __init__(
        self,
        begin: int = None,
        end: int = None,
        price: float = None,
        region_ids: List[str] = None,
        unit: str = None,
    ):
        self.begin = begin
        self.end = end
        self.price = price
        self.region_ids = region_ids
        self.unit = unit

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin is not None:
            result['Begin'] = self.begin
        if self.end is not None:
            result['End'] = self.end
        if self.price is not None:
            result['Price'] = self.price
        if self.region_ids is not None:
            result['RegionIds'] = self.region_ids
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Begin') is not None:
            self.begin = m.get('Begin')
        if m.get('End') is not None:
            self.end = m.get('End')
        if m.get('Price') is not None:
            self.price = m.get('Price')
        if m.get('RegionIds') is not None:
            self.region_ids = m.get('RegionIds')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class PriceEstimateOutputItems(TeaModel):
    def __init__(
        self,
        amount: float = None,
        count: int = None,
        id: str = None,
        price: float = None,
        steps: List[PriceEstimateOutputItemsSteps] = None,
        type: str = None,
        unit: str = None,
    ):
        self.amount = amount
        self.count = count
        self.id = id
        self.price = price
        self.steps = steps
        self.type = type
        self.unit = unit

    def validate(self):
        if self.steps:
            for k in self.steps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.amount is not None:
            result['Amount'] = self.amount
        if self.count is not None:
            result['Count'] = self.count
        if self.id is not None:
            result['Id'] = self.id
        if self.price is not None:
            result['Price'] = self.price
        result['Steps'] = []
        if self.steps is not None:
            for k in self.steps:
                result['Steps'].append(k.to_map() if k else None)
        if self.type is not None:
            result['Type'] = self.type
        if self.unit is not None:
            result['Unit'] = self.unit
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Amount') is not None:
            self.amount = m.get('Amount')
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Price') is not None:
            self.price = m.get('Price')
        self.steps = []
        if m.get('Steps') is not None:
            for k in m.get('Steps'):
                temp_model = PriceEstimateOutputItemsSteps()
                self.steps.append(temp_model.from_map(k))
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Unit') is not None:
            self.unit = m.get('Unit')
        return self


class PriceEstimateOutput(TeaModel):
    def __init__(
        self,
        apps: List[PriceEstimateOutputApps] = None,
        items: List[PriceEstimateOutputItems] = None,
        total_price: float = None,
    ):
        self.apps = apps
        self.items = items
        self.total_price = total_price

    def validate(self):
        if self.apps:
            for k in self.apps:
                if k:
                    k.validate()
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Apps'] = []
        if self.apps is not None:
            for k in self.apps:
                result['Apps'].append(k.to_map() if k else None)
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.total_price is not None:
            result['TotalPrice'] = self.total_price
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.apps = []
        if m.get('Apps') is not None:
            for k in m.get('Apps'):
                temp_model = PriceEstimateOutputApps()
                self.apps.append(temp_model.from_map(k))
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = PriceEstimateOutputItems()
                self.items.append(temp_model.from_map(k))
        if m.get('TotalPrice') is not None:
            self.total_price = m.get('TotalPrice')
        return self


class PublishApplicationVersionInput(TeaModel):
    def __init__(
        self,
        description: str = None,
    ):
        self.description = description

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        return self


class PublishWebApplicationRevisionInput(TeaModel):
    def __init__(
        self,
        containers: List[Container] = None,
        description: str = None,
        enable_arms_metrics: bool = None,
        take_effect: bool = None,
    ):
        # This parameter is required.
        self.containers = containers
        self.description = description
        self.enable_arms_metrics = enable_arms_metrics
        self.take_effect = take_effect

    def validate(self):
        if self.containers:
            for k in self.containers:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Containers'] = []
        if self.containers is not None:
            for k in self.containers:
                result['Containers'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_arms_metrics is not None:
            result['EnableArmsMetrics'] = self.enable_arms_metrics
        if self.take_effect is not None:
            result['TakeEffect'] = self.take_effect
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.containers = []
        if m.get('Containers') is not None:
            for k in m.get('Containers'):
                temp_model = Container()
                self.containers.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableArmsMetrics') is not None:
            self.enable_arms_metrics = m.get('EnableArmsMetrics')
        if m.get('TakeEffect') is not None:
            self.take_effect = m.get('TakeEffect')
        return self


class RoutePolicy(TeaModel):
    def __init__(
        self,
        condition: str = None,
        policy_items: List[PolicyItem] = None,
    ):
        self.condition = condition
        self.policy_items = policy_items

    def validate(self):
        if self.policy_items:
            for k in self.policy_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition
        result['policyItems'] = []
        if self.policy_items is not None:
            for k in self.policy_items:
                result['policyItems'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            self.condition = m.get('condition')
        self.policy_items = []
        if m.get('policyItems') is not None:
            for k in m.get('policyItems'):
                temp_model = PolicyItem()
                self.policy_items.append(temp_model.from_map(k))
        return self


class SourceCodeAccountOrganizations(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        id: str = None,
        name: str = None,
    ):
        self.avatar_url = avatar_url
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class SourceCodeAccount(TeaModel):
    def __init__(
        self,
        avatar_url: str = None,
        id: str = None,
        name: str = None,
        organizations: List[SourceCodeAccountOrganizations] = None,
    ):
        self.avatar_url = avatar_url
        self.id = id
        self.name = name
        self.organizations = organizations

    def validate(self):
        if self.organizations:
            for k in self.organizations:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar_url is not None:
            result['AvatarUrl'] = self.avatar_url
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        result['Organizations'] = []
        if self.organizations is not None:
            for k in self.organizations:
                result['Organizations'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AvatarUrl') is not None:
            self.avatar_url = m.get('AvatarUrl')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.organizations = []
        if m.get('Organizations') is not None:
            for k in m.get('Organizations'):
                temp_model = SourceCodeAccountOrganizations()
                self.organizations.append(temp_model.from_map(k))
        return self


class SourceCodeRepo(TeaModel):
    def __init__(
        self,
        full_name: str = None,
        id: str = None,
        name: str = None,
    ):
        self.full_name = full_name
        self.id = id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.full_name is not None:
            result['FullName'] = self.full_name
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FullName') is not None:
            self.full_name = m.get('FullName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class SourceCodeRepoBranch(TeaModel):
    def __init__(
        self,
        commit_id: str = None,
        name: str = None,
    ):
        self.commit_id = commit_id
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.commit_id is not None:
            result['CommitId'] = self.commit_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CommitId') is not None:
            self.commit_id = m.get('CommitId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class SubmenuItems(TeaModel):
    def __init__(
        self,
        default_selected: bool = None,
        item_desc: str = None,
        item_type: str = None,
        relating_items: List[str] = None,
    ):
        self.default_selected = default_selected
        self.item_desc = item_desc
        self.item_type = item_type
        self.relating_items = relating_items

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_selected is not None:
            result['DefaultSelected'] = self.default_selected
        if self.item_desc is not None:
            result['ItemDesc'] = self.item_desc
        if self.item_type is not None:
            result['ItemType'] = self.item_type
        if self.relating_items is not None:
            result['RelatingItems'] = self.relating_items
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultSelected') is not None:
            self.default_selected = m.get('DefaultSelected')
        if m.get('ItemDesc') is not None:
            self.item_desc = m.get('ItemDesc')
        if m.get('ItemType') is not None:
            self.item_type = m.get('ItemType')
        if m.get('RelatingItems') is not None:
            self.relating_items = m.get('RelatingItems')
        return self


class Submenu(TeaModel):
    def __init__(
        self,
        items: List[SubmenuItems] = None,
        submenu_desc: str = None,
        submenu_type: str = None,
        submenus: List['Submenu'] = None,
    ):
        self.items = items
        self.submenu_desc = submenu_desc
        self.submenu_type = submenu_type
        self.submenus = submenus

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()
        if self.submenus:
            for k in self.submenus:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Items'] = []
        if self.items is not None:
            for k in self.items:
                result['Items'].append(k.to_map() if k else None)
        if self.submenu_desc is not None:
            result['SubmenuDesc'] = self.submenu_desc
        if self.submenu_type is not None:
            result['SubmenuType'] = self.submenu_type
        result['Submenus'] = []
        if self.submenus is not None:
            for k in self.submenus:
                result['Submenus'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.items = []
        if m.get('Items') is not None:
            for k in m.get('Items'):
                temp_model = SubmenuItems()
                self.items.append(temp_model.from_map(k))
        if m.get('SubmenuDesc') is not None:
            self.submenu_desc = m.get('SubmenuDesc')
        if m.get('SubmenuType') is not None:
            self.submenu_type = m.get('SubmenuType')
        self.submenus = []
        if m.get('Submenus') is not None:
            for k in m.get('Submenus'):
                temp_model = Submenu()
                self.submenus.append(temp_model.from_map(k))
        return self


class TrafficConfig(TeaModel):
    def __init__(
        self,
        additional_version_weight: Dict[str, float] = None,
        created_time: str = None,
        last_modified_time: str = None,
        request_id: str = None,
        resolve_policy: str = None,
        route_policy: RoutePolicy = None,
        version_id: str = None,
    ):
        self.additional_version_weight = additional_version_weight
        self.created_time = created_time
        self.last_modified_time = last_modified_time
        self.request_id = request_id
        self.resolve_policy = resolve_policy
        self.route_policy = route_policy
        self.version_id = version_id

    def validate(self):
        if self.route_policy:
            self.route_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_version_weight is not None:
            result['additionalVersionWeight'] = self.additional_version_weight
        if self.created_time is not None:
            result['createdTime'] = self.created_time
        if self.last_modified_time is not None:
            result['lastModifiedTime'] = self.last_modified_time
        if self.request_id is not None:
            result['requestId'] = self.request_id
        if self.resolve_policy is not None:
            result['resolvePolicy'] = self.resolve_policy
        if self.route_policy is not None:
            result['routePolicy'] = self.route_policy.to_map()
        if self.version_id is not None:
            result['versionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('additionalVersionWeight') is not None:
            self.additional_version_weight = m.get('additionalVersionWeight')
        if m.get('createdTime') is not None:
            self.created_time = m.get('createdTime')
        if m.get('lastModifiedTime') is not None:
            self.last_modified_time = m.get('lastModifiedTime')
        if m.get('requestId') is not None:
            self.request_id = m.get('requestId')
        if m.get('resolvePolicy') is not None:
            self.resolve_policy = m.get('resolvePolicy')
        if m.get('routePolicy') is not None:
            temp_model = RoutePolicy()
            self.route_policy = temp_model.from_map(m['routePolicy'])
        if m.get('versionId') is not None:
            self.version_id = m.get('versionId')
        return self


class UpdateApplicationInput(TeaModel):
    def __init__(
        self,
        args: str = None,
        ca_port: int = None,
        code: InputCodeLocation = None,
        command: str = None,
        cpu: float = None,
        custom_dns: CustomDNS = None,
        custom_health_check_config: CustomHealthCheckConfig = None,
        custom_host_alias: CustomHostAlias = None,
        custom_runtime_config: CustomRuntimeConfig = None,
        description: str = None,
        disk_size: int = None,
        effective_immediately: bool = None,
        enable_app_metric: bool = None,
        environment_variables: Dict[str, str] = None,
        gpu_memory_size: int = None,
        handler: str = None,
        http_trigger_config: HTTPTriggerConfig = None,
        image_config: ImageConfig = None,
        initialization_timeout: int = None,
        initializer: str = None,
        instance_concurrency: int = None,
        instance_lifecycle_config: InstanceLifecycleConfig = None,
        instance_soft_concurrency: int = None,
        instance_type: str = None,
        internet_access: bool = None,
        layers: List[str] = None,
        liveness_probe: Probe = None,
        log_config: LogConfig = None,
        memory_size: int = None,
        nas_config: NASConfig = None,
        oss_mount_config: OSSMountConfig = None,
        runtime: str = None,
        scale_config: ScaleConfig = None,
        sls_config: SLSConfig = None,
        startup_probe: Probe = None,
        timeout: int = None,
        tracing_config: TracingConfig = None,
        vpc_config: VPCConfig = None,
    ):
        self.args = args
        self.ca_port = ca_port
        self.code = code
        self.command = command
        self.cpu = cpu
        self.custom_dns = custom_dns
        self.custom_health_check_config = custom_health_check_config
        self.custom_host_alias = custom_host_alias
        self.custom_runtime_config = custom_runtime_config
        self.description = description
        self.disk_size = disk_size
        self.effective_immediately = effective_immediately
        self.enable_app_metric = enable_app_metric
        self.environment_variables = environment_variables
        self.gpu_memory_size = gpu_memory_size
        self.handler = handler
        self.http_trigger_config = http_trigger_config
        self.image_config = image_config
        self.initialization_timeout = initialization_timeout
        self.initializer = initializer
        self.instance_concurrency = instance_concurrency
        self.instance_lifecycle_config = instance_lifecycle_config
        self.instance_soft_concurrency = instance_soft_concurrency
        self.instance_type = instance_type
        self.internet_access = internet_access
        self.layers = layers
        self.liveness_probe = liveness_probe
        self.log_config = log_config
        self.memory_size = memory_size
        self.nas_config = nas_config
        self.oss_mount_config = oss_mount_config
        self.runtime = runtime
        self.scale_config = scale_config
        self.sls_config = sls_config
        self.startup_probe = startup_probe
        self.timeout = timeout
        self.tracing_config = tracing_config
        self.vpc_config = vpc_config

    def validate(self):
        if self.code:
            self.code.validate()
        if self.custom_dns:
            self.custom_dns.validate()
        if self.custom_health_check_config:
            self.custom_health_check_config.validate()
        if self.custom_host_alias:
            self.custom_host_alias.validate()
        if self.custom_runtime_config:
            self.custom_runtime_config.validate()
        if self.http_trigger_config:
            self.http_trigger_config.validate()
        if self.image_config:
            self.image_config.validate()
        if self.instance_lifecycle_config:
            self.instance_lifecycle_config.validate()
        if self.liveness_probe:
            self.liveness_probe.validate()
        if self.log_config:
            self.log_config.validate()
        if self.nas_config:
            self.nas_config.validate()
        if self.oss_mount_config:
            self.oss_mount_config.validate()
        if self.scale_config:
            self.scale_config.validate()
        if self.sls_config:
            self.sls_config.validate()
        if self.startup_probe:
            self.startup_probe.validate()
        if self.tracing_config:
            self.tracing_config.validate()
        if self.vpc_config:
            self.vpc_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.args is not None:
            result['args'] = self.args
        if self.ca_port is not None:
            result['caPort'] = self.ca_port
        if self.code is not None:
            result['code'] = self.code.to_map()
        if self.command is not None:
            result['command'] = self.command
        if self.cpu is not None:
            result['cpu'] = self.cpu
        if self.custom_dns is not None:
            result['customDNS'] = self.custom_dns.to_map()
        if self.custom_health_check_config is not None:
            result['customHealthCheckConfig'] = self.custom_health_check_config.to_map()
        if self.custom_host_alias is not None:
            result['customHostAlias'] = self.custom_host_alias.to_map()
        if self.custom_runtime_config is not None:
            result['customRuntimeConfig'] = self.custom_runtime_config.to_map()
        if self.description is not None:
            result['description'] = self.description
        if self.disk_size is not None:
            result['diskSize'] = self.disk_size
        if self.effective_immediately is not None:
            result['effectiveImmediately'] = self.effective_immediately
        if self.enable_app_metric is not None:
            result['enableAppMetric'] = self.enable_app_metric
        if self.environment_variables is not None:
            result['environmentVariables'] = self.environment_variables
        if self.gpu_memory_size is not None:
            result['gpuMemorySize'] = self.gpu_memory_size
        if self.handler is not None:
            result['handler'] = self.handler
        if self.http_trigger_config is not None:
            result['httpTriggerConfig'] = self.http_trigger_config.to_map()
        if self.image_config is not None:
            result['imageConfig'] = self.image_config.to_map()
        if self.initialization_timeout is not None:
            result['initializationTimeout'] = self.initialization_timeout
        if self.initializer is not None:
            result['initializer'] = self.initializer
        if self.instance_concurrency is not None:
            result['instanceConcurrency'] = self.instance_concurrency
        if self.instance_lifecycle_config is not None:
            result['instanceLifecycleConfig'] = self.instance_lifecycle_config.to_map()
        if self.instance_soft_concurrency is not None:
            result['instanceSoftConcurrency'] = self.instance_soft_concurrency
        if self.instance_type is not None:
            result['instanceType'] = self.instance_type
        if self.internet_access is not None:
            result['internetAccess'] = self.internet_access
        if self.layers is not None:
            result['layers'] = self.layers
        if self.liveness_probe is not None:
            result['livenessProbe'] = self.liveness_probe.to_map()
        if self.log_config is not None:
            result['logConfig'] = self.log_config.to_map()
        if self.memory_size is not None:
            result['memorySize'] = self.memory_size
        if self.nas_config is not None:
            result['nasConfig'] = self.nas_config.to_map()
        if self.oss_mount_config is not None:
            result['ossMountConfig'] = self.oss_mount_config.to_map()
        if self.runtime is not None:
            result['runtime'] = self.runtime
        if self.scale_config is not None:
            result['scaleConfig'] = self.scale_config.to_map()
        if self.sls_config is not None:
            result['slsConfig'] = self.sls_config.to_map()
        if self.startup_probe is not None:
            result['startupProbe'] = self.startup_probe.to_map()
        if self.timeout is not None:
            result['timeout'] = self.timeout
        if self.tracing_config is not None:
            result['tracingConfig'] = self.tracing_config.to_map()
        if self.vpc_config is not None:
            result['vpcConfig'] = self.vpc_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('args') is not None:
            self.args = m.get('args')
        if m.get('caPort') is not None:
            self.ca_port = m.get('caPort')
        if m.get('code') is not None:
            temp_model = InputCodeLocation()
            self.code = temp_model.from_map(m['code'])
        if m.get('command') is not None:
            self.command = m.get('command')
        if m.get('cpu') is not None:
            self.cpu = m.get('cpu')
        if m.get('customDNS') is not None:
            temp_model = CustomDNS()
            self.custom_dns = temp_model.from_map(m['customDNS'])
        if m.get('customHealthCheckConfig') is not None:
            temp_model = CustomHealthCheckConfig()
            self.custom_health_check_config = temp_model.from_map(m['customHealthCheckConfig'])
        if m.get('customHostAlias') is not None:
            temp_model = CustomHostAlias()
            self.custom_host_alias = temp_model.from_map(m['customHostAlias'])
        if m.get('customRuntimeConfig') is not None:
            temp_model = CustomRuntimeConfig()
            self.custom_runtime_config = temp_model.from_map(m['customRuntimeConfig'])
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('diskSize') is not None:
            self.disk_size = m.get('diskSize')
        if m.get('effectiveImmediately') is not None:
            self.effective_immediately = m.get('effectiveImmediately')
        if m.get('enableAppMetric') is not None:
            self.enable_app_metric = m.get('enableAppMetric')
        if m.get('environmentVariables') is not None:
            self.environment_variables = m.get('environmentVariables')
        if m.get('gpuMemorySize') is not None:
            self.gpu_memory_size = m.get('gpuMemorySize')
        if m.get('handler') is not None:
            self.handler = m.get('handler')
        if m.get('httpTriggerConfig') is not None:
            temp_model = HTTPTriggerConfig()
            self.http_trigger_config = temp_model.from_map(m['httpTriggerConfig'])
        if m.get('imageConfig') is not None:
            temp_model = ImageConfig()
            self.image_config = temp_model.from_map(m['imageConfig'])
        if m.get('initializationTimeout') is not None:
            self.initialization_timeout = m.get('initializationTimeout')
        if m.get('initializer') is not None:
            self.initializer = m.get('initializer')
        if m.get('instanceConcurrency') is not None:
            self.instance_concurrency = m.get('instanceConcurrency')
        if m.get('instanceLifecycleConfig') is not None:
            temp_model = InstanceLifecycleConfig()
            self.instance_lifecycle_config = temp_model.from_map(m['instanceLifecycleConfig'])
        if m.get('instanceSoftConcurrency') is not None:
            self.instance_soft_concurrency = m.get('instanceSoftConcurrency')
        if m.get('instanceType') is not None:
            self.instance_type = m.get('instanceType')
        if m.get('internetAccess') is not None:
            self.internet_access = m.get('internetAccess')
        if m.get('layers') is not None:
            self.layers = m.get('layers')
        if m.get('livenessProbe') is not None:
            temp_model = Probe()
            self.liveness_probe = temp_model.from_map(m['livenessProbe'])
        if m.get('logConfig') is not None:
            temp_model = LogConfig()
            self.log_config = temp_model.from_map(m['logConfig'])
        if m.get('memorySize') is not None:
            self.memory_size = m.get('memorySize')
        if m.get('nasConfig') is not None:
            temp_model = NASConfig()
            self.nas_config = temp_model.from_map(m['nasConfig'])
        if m.get('ossMountConfig') is not None:
            temp_model = OSSMountConfig()
            self.oss_mount_config = temp_model.from_map(m['ossMountConfig'])
        if m.get('runtime') is not None:
            self.runtime = m.get('runtime')
        if m.get('scaleConfig') is not None:
            temp_model = ScaleConfig()
            self.scale_config = temp_model.from_map(m['scaleConfig'])
        if m.get('slsConfig') is not None:
            temp_model = SLSConfig()
            self.sls_config = temp_model.from_map(m['slsConfig'])
        if m.get('startupProbe') is not None:
            temp_model = Probe()
            self.startup_probe = temp_model.from_map(m['startupProbe'])
        if m.get('timeout') is not None:
            self.timeout = m.get('timeout')
        if m.get('tracingConfig') is not None:
            temp_model = TracingConfig()
            self.tracing_config = temp_model.from_map(m['tracingConfig'])
        if m.get('vpcConfig') is not None:
            temp_model = VPCConfig()
            self.vpc_config = temp_model.from_map(m['vpcConfig'])
        return self


class UpdateApplicationScaleConfigInput(TeaModel):
    def __init__(
        self,
        always_allocate_cpu: bool = None,
        maximum_instance_count: int = None,
        minimum_instance_count: int = None,
    ):
        self.always_allocate_cpu = always_allocate_cpu
        self.maximum_instance_count = maximum_instance_count
        self.minimum_instance_count = minimum_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.always_allocate_cpu is not None:
            result['alwaysAllocateCPU'] = self.always_allocate_cpu
        if self.maximum_instance_count is not None:
            result['maximumInstanceCount'] = self.maximum_instance_count
        if self.minimum_instance_count is not None:
            result['minimumInstanceCount'] = self.minimum_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('alwaysAllocateCPU') is not None:
            self.always_allocate_cpu = m.get('alwaysAllocateCPU')
        if m.get('maximumInstanceCount') is not None:
            self.maximum_instance_count = m.get('maximumInstanceCount')
        if m.get('minimumInstanceCount') is not None:
            self.minimum_instance_count = m.get('minimumInstanceCount')
        return self


class UpdateApplicationTrafficConfigInput(TeaModel):
    def __init__(
        self,
        additional_version_weight: Dict[str, float] = None,
        resolve_policy: str = None,
        route_policy: RoutePolicy = None,
        version_id: str = None,
    ):
        self.additional_version_weight = additional_version_weight
        self.resolve_policy = resolve_policy
        self.route_policy = route_policy
        self.version_id = version_id

    def validate(self):
        if self.route_policy:
            self.route_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.additional_version_weight is not None:
            result['additionalVersionWeight'] = self.additional_version_weight
        if self.resolve_policy is not None:
            result['resolvePolicy'] = self.resolve_policy
        if self.route_policy is not None:
            result['routePolicy'] = self.route_policy.to_map()
        if self.version_id is not None:
            result['versionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('additionalVersionWeight') is not None:
            self.additional_version_weight = m.get('additionalVersionWeight')
        if m.get('resolvePolicy') is not None:
            self.resolve_policy = m.get('resolvePolicy')
        if m.get('routePolicy') is not None:
            temp_model = RoutePolicy()
            self.route_policy = temp_model.from_map(m['routePolicy'])
        if m.get('versionId') is not None:
            self.version_id = m.get('versionId')
        return self


class UpdateAttributesInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        http_trigger_config: HTTPTriggerConfig = None,
        version_id: str = None,
    ):
        self.description = description
        self.http_trigger_config = http_trigger_config
        self.version_id = version_id

    def validate(self):
        if self.http_trigger_config:
            self.http_trigger_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['description'] = self.description
        if self.http_trigger_config is not None:
            result['httpTriggerConfig'] = self.http_trigger_config.to_map()
        if self.version_id is not None:
            result['versionID'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('description') is not None:
            self.description = m.get('description')
        if m.get('httpTriggerConfig') is not None:
            temp_model = HTTPTriggerConfig()
            self.http_trigger_config = temp_model.from_map(m['httpTriggerConfig'])
        if m.get('versionID') is not None:
            self.version_id = m.get('versionID')
        return self


class UpdateCustomDomainInput(TeaModel):
    def __init__(
        self,
        application_id: str = None,
        application_name: str = None,
        cert_config: CertConfig = None,
        keep_full_path: bool = None,
        namespace_id: str = None,
        protocol: str = None,
        tls_config: TLSConfig = None,
        waf_config: WAFConfig = None,
    ):
        self.application_id = application_id
        self.application_name = application_name
        self.cert_config = cert_config
        self.keep_full_path = keep_full_path
        self.namespace_id = namespace_id
        self.protocol = protocol
        self.tls_config = tls_config
        self.waf_config = waf_config

    def validate(self):
        if self.cert_config:
            self.cert_config.validate()
        if self.tls_config:
            self.tls_config.validate()
        if self.waf_config:
            self.waf_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.application_id is not None:
            result['applicationID'] = self.application_id
        if self.application_name is not None:
            result['applicationName'] = self.application_name
        if self.cert_config is not None:
            result['certConfig'] = self.cert_config.to_map()
        if self.keep_full_path is not None:
            result['keepFullPath'] = self.keep_full_path
        if self.namespace_id is not None:
            result['namespaceID'] = self.namespace_id
        if self.protocol is not None:
            result['protocol'] = self.protocol
        if self.tls_config is not None:
            result['tlsConfig'] = self.tls_config.to_map()
        if self.waf_config is not None:
            result['wafConfig'] = self.waf_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('applicationID') is not None:
            self.application_id = m.get('applicationID')
        if m.get('applicationName') is not None:
            self.application_name = m.get('applicationName')
        if m.get('certConfig') is not None:
            temp_model = CertConfig()
            self.cert_config = temp_model.from_map(m['certConfig'])
        if m.get('keepFullPath') is not None:
            self.keep_full_path = m.get('keepFullPath')
        if m.get('namespaceID') is not None:
            self.namespace_id = m.get('namespaceID')
        if m.get('protocol') is not None:
            self.protocol = m.get('protocol')
        if m.get('tlsConfig') is not None:
            temp_model = TLSConfig()
            self.tls_config = temp_model.from_map(m['tlsConfig'])
        if m.get('wafConfig') is not None:
            temp_model = WAFConfig()
            self.waf_config = temp_model.from_map(m['wafConfig'])
        return self


class UpdateWebApplicationInput(TeaModel):
    def __init__(
        self,
        description: str = None,
        web_network_config: WebNetworkConfig = None,
    ):
        self.description = description
        self.web_network_config = web_network_config

    def validate(self):
        if self.web_network_config:
            self.web_network_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.web_network_config is not None:
            result['WebNetworkConfig'] = self.web_network_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('WebNetworkConfig') is not None:
            temp_model = WebNetworkConfig()
            self.web_network_config = temp_model.from_map(m['WebNetworkConfig'])
        return self


class UpdateWebApplicationScalingConfigInput(TeaModel):
    def __init__(
        self,
        maximum_instance_count: int = None,
        minimum_instance_count: int = None,
    ):
        # This parameter is required.
        self.maximum_instance_count = maximum_instance_count
        # This parameter is required.
        self.minimum_instance_count = minimum_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.maximum_instance_count is not None:
            result['MaximumInstanceCount'] = self.maximum_instance_count
        if self.minimum_instance_count is not None:
            result['MinimumInstanceCount'] = self.minimum_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaximumInstanceCount') is not None:
            self.maximum_instance_count = m.get('MaximumInstanceCount')
        if m.get('MinimumInstanceCount') is not None:
            self.minimum_instance_count = m.get('MinimumInstanceCount')
        return self


class UpdateWebApplicationTrafficConfigInput(TeaModel):
    def __init__(
        self,
        auth_type: str = None,
        disable_urlinternet: bool = None,
        revisions_traffic_weight: Dict[str, float] = None,
        web_acl_config: WebAclConfig = None,
    ):
        self.auth_type = auth_type
        self.disable_urlinternet = disable_urlinternet
        self.revisions_traffic_weight = revisions_traffic_weight
        self.web_acl_config = web_acl_config

    def validate(self):
        if self.web_acl_config:
            self.web_acl_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_type is not None:
            result['AuthType'] = self.auth_type
        if self.disable_urlinternet is not None:
            result['DisableURLInternet'] = self.disable_urlinternet
        if self.revisions_traffic_weight is not None:
            result['RevisionsTrafficWeight'] = self.revisions_traffic_weight
        if self.web_acl_config is not None:
            result['WebAclConfig'] = self.web_acl_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthType') is not None:
            self.auth_type = m.get('AuthType')
        if m.get('DisableURLInternet') is not None:
            self.disable_urlinternet = m.get('DisableURLInternet')
        if m.get('RevisionsTrafficWeight') is not None:
            self.revisions_traffic_weight = m.get('RevisionsTrafficWeight')
        if m.get('WebAclConfig') is not None:
            temp_model = WebAclConfig()
            self.web_acl_config = temp_model.from_map(m['WebAclConfig'])
        return self


class UpdateWebCustomDomainInput(TeaModel):
    def __init__(
        self,
        default_forwarding_app_name: str = None,
        protocol: str = None,
        web_cert_config: WebCertConfig = None,
        web_tlsconfig: WebTLSConfig = None,
        web_wafconfig: WebWAFConfig = None,
    ):
        self.default_forwarding_app_name = default_forwarding_app_name
        self.protocol = protocol
        self.web_cert_config = web_cert_config
        self.web_tlsconfig = web_tlsconfig
        self.web_wafconfig = web_wafconfig

    def validate(self):
        if self.web_cert_config:
            self.web_cert_config.validate()
        if self.web_tlsconfig:
            self.web_tlsconfig.validate()
        if self.web_wafconfig:
            self.web_wafconfig.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_forwarding_app_name is not None:
            result['DefaultForwardingAppName'] = self.default_forwarding_app_name
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.web_cert_config is not None:
            result['WebCertConfig'] = self.web_cert_config.to_map()
        if self.web_tlsconfig is not None:
            result['WebTLSConfig'] = self.web_tlsconfig.to_map()
        if self.web_wafconfig is not None:
            result['WebWAFConfig'] = self.web_wafconfig.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultForwardingAppName') is not None:
            self.default_forwarding_app_name = m.get('DefaultForwardingAppName')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('WebCertConfig') is not None:
            temp_model = WebCertConfig()
            self.web_cert_config = temp_model.from_map(m['WebCertConfig'])
        if m.get('WebTLSConfig') is not None:
            temp_model = WebTLSConfig()
            self.web_tlsconfig = temp_model.from_map(m['WebTLSConfig'])
        if m.get('WebWAFConfig') is not None:
            temp_model = WebWAFConfig()
            self.web_wafconfig = temp_model.from_map(m['WebWAFConfig'])
        return self


class WebApplicationBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: WebApplication = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = WebApplication()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebApplicationInstanceLogsBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DescribeInstanceLogsOutput = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeInstanceLogsOutput()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebApplicationResourceStaticsBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: DescribeWebAppStaticsOutput = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeWebAppStaticsOutput()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebApplicationRevisionBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: Revision = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = Revision()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebApplicationScalingConfigBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: WebScalingConfig = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = WebScalingConfig()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebApplicationStatus(TeaModel):
    def __init__(
        self,
        instance_count: int = None,
        web_scaling_config: WebScalingConfig = None,
    ):
        self.instance_count = instance_count
        self.web_scaling_config = web_scaling_config

    def validate(self):
        if self.web_scaling_config:
            self.web_scaling_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.web_scaling_config is not None:
            result['WebScalingConfig'] = self.web_scaling_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('WebScalingConfig') is not None:
            temp_model = WebScalingConfig()
            self.web_scaling_config = temp_model.from_map(m['WebScalingConfig'])
        return self


class WebApplicationTrafficConfigBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: WebTrafficConfig = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = WebTrafficConfig()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class WebApplicationWithStatus(TeaModel):
    def __init__(
        self,
        status: WebApplicationStatus = None,
        web_application: WebApplication = None,
    ):
        self.status = status
        self.web_application = web_application

    def validate(self):
        if self.status:
            self.status.validate()
        if self.web_application:
            self.web_application.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status.to_map()
        if self.web_application is not None:
            result['WebApplication'] = self.web_application.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            temp_model = WebApplicationStatus()
            self.status = temp_model.from_map(m['Status'])
        if m.get('WebApplication') is not None:
            temp_model = WebApplication()
            self.web_application = temp_model.from_map(m['WebApplication'])
        return self


class WebCustomDomainBody(TeaModel):
    def __init__(
        self,
        code: int = None,
        data: WebCustomDomain = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.data = data
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = WebCustomDomain()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AbortAndRollbackChangeOrderRequest(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class AbortAndRollbackChangeOrderResponseBodyData(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class AbortAndRollbackChangeOrderResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AbortAndRollbackChangeOrderResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the change order was terminated or the application was rolled back. Valid values:
        # 
        # *   **true**: The change order was terminated or the application was rolled back.
        # *   **false**: The change order could not be terminated or the application could not be rolled back.
        self.code = code
        # The ID of the change order.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.error_code = error_code
        # The ID of the trace. It is used to query the details of a request.
        self.message = message
        # The returned message.
        self.request_id = request_id
        self.success = success
        # The details of the change order.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AbortAndRollbackChangeOrderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class AbortAndRollbackChangeOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AbortAndRollbackChangeOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AbortAndRollbackChangeOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AbortChangeOrderRequest(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class AbortChangeOrderResponseBodyData(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class AbortChangeOrderResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: AbortChangeOrderResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the change order was terminated. Valid values:
        # 
        # *   **true**: The change order was terminated.
        # *   **false**: The change order could not be terminated.
        self.code = code
        # The ID of the change order.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.error_code = error_code
        # The ID of the trace.
        self.message = message
        # The returned message.
        self.request_id = request_id
        self.success = success
        # The returned data.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = AbortChangeOrderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class AbortChangeOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AbortChangeOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AbortChangeOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchStartApplicationsRequest(TeaModel):
    def __init__(
        self,
        app_ids: str = None,
        namespace_id: str = None,
        version: str = None,
    ):
        # The returned message.
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error code is returned when the request fails.
        self.app_ids = app_ids
        # The ID of the request.
        # 
        # This parameter is required.
        self.namespace_id = namespace_id
        # The application version.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_ids is not None:
            result['AppIds'] = self.app_ids
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppIds') is not None:
            self.app_ids = m.get('AppIds')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class BatchStartApplicationsResponseBodyData(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class BatchStartApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: BatchStartApplicationsResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Take note of the following rules:
        # 
        # - **2xx**: The call was successful.
        # - **3xx**: The call was redirected.
        # - **4xx**: The call failed.
        # - **5xx**: A server error occurred.
        self.code = code
        # The error code.
        # 
        # *   If the request is successful, this parameter is not returned.****\
        # *   This parameter is returned only if the request failed.**** For more information, see **Error codes** in this topic.
        self.data = data
        # The error code returned if the request failed. Take note of the following rules:
        # 
        # - The ErrorCode parameter is not returned if the request succeeds.
        # - If the call fails, the ErrorCode parameter is returned. For more information, see the "Error codes" section of this topic.
        self.error_code = error_code
        # The returned data.
        self.message = message
        # The ID of the trace. It is used to query the details of a request.
        self.request_id = request_id
        # Indicates whether the application deployment is successful. Take note of the following rules:
        # 
        # - **true**\
        # - **false**\
        self.success = success
        # The ID of the change order.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchStartApplicationsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class BatchStartApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchStartApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchStartApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchStopApplicationsRequest(TeaModel):
    def __init__(
        self,
        app_ids: str = None,
        namespace_id: str = None,
        version: str = None,
    ):
        # The ID of the request.
        self.app_ids = app_ids
        # ebf491f0-c1a5-45e2-b2c4-710dbe2a\\*\\*\\*\\*,ebf491f0-c1a5-45e2-b2c4-71025e2a\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.namespace_id = namespace_id
        # The application version.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_ids is not None:
            result['AppIds'] = self.app_ids
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppIds') is not None:
            self.app_ids = m.get('AppIds')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class BatchStopApplicationsResponseBodyData(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The error code.
        # 
        # *   If the request is successful, this parameter is not returned.****\
        # *   This parameter is returned only if the request failed.**** For more information, see the "**Error codes**" section in this topic.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class BatchStopApplicationsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: BatchStopApplicationsResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Take note of the following rules:
        # 
        # - **2xx**: The call was successful.
        # - **3xx**: The call was redirected.
        # - **4xx**: The call failed.
        # - **5xx**: A server error occurred.
        self.code = code
        # The ID of the change order.
        self.data = data
        # The error code returned if the request failed. Take note of the following rules:
        # 
        # - The ErrorCode parameter is not returned if the request succeeds.
        # - If the call fails, the ErrorCode parameter is returned. For more information, see the "Error codes" section of this topic.
        self.error_code = error_code
        # The ID of the trace. It can be used to query the details of a request.
        self.message = message
        # The returned message.
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error code is returned when the request fails.
        self.request_id = request_id
        # Indicates whether the application is created. Valid values
        # 
        # - **true**\
        # - **false**\
        self.success = success
        # The returned data.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BatchStopApplicationsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class BatchStopApplicationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchStopApplicationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchStopApplicationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindSlbRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        internet: str = None,
        internet_slb_charge_type: str = None,
        internet_slb_id: str = None,
        intranet: str = None,
        intranet_slb_charge_type: str = None,
        intranet_slb_id: str = None,
    ):
        # 0099b7be-5f5b-4512-a7fc-56049ef1\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id
        # [{"port":80,"targetPort":8080,"protocol":"TCP"}]
        self.internet = internet
        self.internet_slb_charge_type = internet_slb_charge_type
        # lb-bp1tg0k6d9nqaw7l1\\*\\*\\*\\*\
        self.internet_slb_id = internet_slb_id
        # [{"port":80,"targetPort":8080,"protocol":"TCP"}]
        self.intranet = intranet
        self.intranet_slb_charge_type = intranet_slb_charge_type
        # lb-bp1tg0k6d9nqaw7l1\\*\\*\\*\\*\
        self.intranet_slb_id = intranet_slb_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.internet is not None:
            result['Internet'] = self.internet
        if self.internet_slb_charge_type is not None:
            result['InternetSlbChargeType'] = self.internet_slb_charge_type
        if self.internet_slb_id is not None:
            result['InternetSlbId'] = self.internet_slb_id
        if self.intranet is not None:
            result['Intranet'] = self.intranet
        if self.intranet_slb_charge_type is not None:
            result['IntranetSlbChargeType'] = self.intranet_slb_charge_type
        if self.intranet_slb_id is not None:
            result['IntranetSlbId'] = self.intranet_slb_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Internet') is not None:
            self.internet = m.get('Internet')
        if m.get('InternetSlbChargeType') is not None:
            self.internet_slb_charge_type = m.get('InternetSlbChargeType')
        if m.get('InternetSlbId') is not None:
            self.internet_slb_id = m.get('InternetSlbId')
        if m.get('Intranet') is not None:
            self.intranet = m.get('Intranet')
        if m.get('IntranetSlbChargeType') is not None:
            self.intranet_slb_charge_type = m.get('IntranetSlbChargeType')
        if m.get('IntranetSlbId') is not None:
            self.intranet_slb_id = m.get('IntranetSlbId')
        return self


class BindSlbResponseBodyData(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The ID of the change order. It can be used to query the task status.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class BindSlbResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: BindSlbResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the SLB instance was successfully associated with the application. Valid values:
        # 
        # *   **true**: The SLB instance was successfully associated with the application.
        # *   **false**: The SLB instance could not be associated with the application.
        self.success = success
        # The ID of the trace. It can be used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = BindSlbResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class BindSlbResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BindSlbResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindSlbResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmPipelineBatchRequest(TeaModel):
    def __init__(
        self,
        confirm: bool = None,
        pipeline_id: str = None,
    ):
        # true
        # 
        # This parameter is required.
        self.confirm = confirm
        # e2e-vds-feh-\\*\\*\\*\
        # 
        # This parameter is required.
        self.pipeline_id = pipeline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.confirm is not None:
            result['Confirm'] = self.confirm
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Confirm') is not None:
            self.confirm = m.get('Confirm')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class ConfirmPipelineBatchResponseBodyData(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
    ):
        # The ID of the batch.
        self.pipeline_id = pipeline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class ConfirmPipelineBatchResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: ConfirmPipelineBatchResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The batch information.
        self.data = data
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the processing of the next batch started as required. Valid values:
        # 
        # *   **true**: The processing started.
        # *   **false**: The processing could not start.
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ConfirmPipelineBatchResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class ConfirmPipelineBatchResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfirmPipelineBatchResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmPipelineBatchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateApplicationRequest(TeaModel):
    def __init__(
        self,
        acr_assume_role_arn: str = None,
        acr_instance_id: str = None,
        app_description: str = None,
        app_name: str = None,
        app_source: str = None,
        associate_eip: bool = None,
        auto_config: bool = None,
        base_app_id: str = None,
        command: str = None,
        command_args: str = None,
        config_map_mount_desc: str = None,
        cpu: int = None,
        custom_host_alias: str = None,
        deploy: bool = None,
        edas_container_version: str = None,
        enable_ebpf: str = None,
        envs: str = None,
        image_pull_secrets: str = None,
        image_url: str = None,
        jar_start_args: str = None,
        jar_start_options: str = None,
        jdk: str = None,
        kafka_configs: str = None,
        liveness: str = None,
        memory: int = None,
        micro_registration: str = None,
        micro_registration_config: str = None,
        mount_desc: str = None,
        mount_host: str = None,
        namespace_id: str = None,
        nas_configs: str = None,
        nas_id: str = None,
        oss_ak_id: str = None,
        oss_ak_secret: str = None,
        oss_mount_descs: str = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
        php: str = None,
        php_arms_config_location: str = None,
        php_config: str = None,
        php_config_location: str = None,
        post_start: str = None,
        pre_stop: str = None,
        programming_language: str = None,
        pvtz_discovery_svc: str = None,
        python: str = None,
        python_modules: str = None,
        readiness: str = None,
        replicas: int = None,
        sae_version: str = None,
        security_group_id: str = None,
        service_tags: str = None,
        sls_configs: str = None,
        termination_grace_period_seconds: int = None,
        timezone: str = None,
        tomcat_config: str = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        war_start_options: str = None,
        web_container: str = None,
    ):
        # acs:ram::123456789012\\*\\*\\*\\*:role/adminrole
        self.acr_assume_role_arn = acr_assume_role_arn
        # cri-xxxxxx
        self.acr_instance_id = acr_instance_id
        # This is a test description.
        self.app_description = app_description
        # test
        # 
        # This parameter is required.
        self.app_name = app_name
        self.app_source = app_source
        # true
        self.associate_eip = associate_eip
        # true
        self.auto_config = auto_config
        self.base_app_id = base_app_id
        # sleep
        self.command = command
        # 1d
        self.command_args = command_args
        # [{"configMapId":16,"key":"test","mountPath":"/tmp"}]
        self.config_map_mount_desc = config_map_mount_desc
        # 1000
        self.cpu = cpu
        # [{"hostName":"samplehost","ip":"127.0.0.1"}]
        self.custom_host_alias = custom_host_alias
        # true
        self.deploy = deploy
        # 3.5.3
        self.edas_container_version = edas_container_version
        self.enable_ebpf = enable_ebpf
        # [{"name":"envtmp","value":"0"}]
        self.envs = envs
        self.image_pull_secrets = image_pull_secrets
        # registry.cn-hangzhou.aliyuncs.com/sae_test/ali_sae_test:0.0.1
        self.image_url = image_url
        # custom-args
        self.jar_start_args = jar_start_args
        # \\-Xms4G -Xmx4G
        self.jar_start_options = jar_start_options
        # Open JDK 8
        self.jdk = jdk
        self.kafka_configs = kafka_configs
        # {"exec":{"command":["sh","-c","cat /home/admin/start.sh"]},"initialDelaySeconds":30,"periodSeconds":30,"timeoutSeconds":2}
        self.liveness = liveness
        # 1024
        self.memory = memory
        self.micro_registration = micro_registration
        self.micro_registration_config = micro_registration_config
        # [{mountPath: "/tmp", nasPath: "/"}]
        self.mount_desc = mount_desc
        # example.com
        self.mount_host = mount_host
        # cn-beijing:test
        self.namespace_id = namespace_id
        self.nas_configs = nas_configs
        # KSAK\\*\\*\\*\\*\
        self.nas_id = nas_id
        # xxxxxx
        self.oss_ak_id = oss_ak_id
        # xxxxxx
        self.oss_ak_secret = oss_ak_secret
        # [{"bucketName": "oss-bucket", "bucketPath": "data/user.data", "mountPath": "/usr/data/user.data", "readOnly": true}]
        self.oss_mount_descs = oss_mount_descs
        # FatJar
        # 
        # This parameter is required.
        self.package_type = package_type
        # http://myoss.oss-cn-\\*\\*\\*\\*.aliyuncs.com/my-buc/2019-06-30/\\*\\*\\*\\*.jar
        self.package_url = package_url
        # 1.0.0
        self.package_version = package_version
        self.php = php
        # /usr/local/etc/php/conf.d/arms.ini
        self.php_arms_config_location = php_arms_config_location
        # k1=v1
        self.php_config = php_config
        # /usr/local/etc/php/php.ini
        self.php_config_location = php_config_location
        # {"exec":{"command":["cat","/etc/group"]}}
        self.post_start = post_start
        # {"exec":{"command":["cat","/etc/group"]}}
        self.pre_stop = pre_stop
        self.programming_language = programming_language
        self.pvtz_discovery_svc = pvtz_discovery_svc
        self.python = python
        self.python_modules = python_modules
        # {"exec":{"command":["sh","-c","cat /home/admin/start.sh"]},"initialDelaySeconds":30,"periodSeconds":30,"timeoutSeconds":2}
        self.readiness = readiness
        # 1
        # 
        # This parameter is required.
        self.replicas = replicas
        self.sae_version = sae_version
        # sg-wz969ngg2e49q5i4\\*\\*\\*\\*\
        self.security_group_id = security_group_id
        self.service_tags = service_tags
        # [{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}]
        self.sls_configs = sls_configs
        # 30
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # Asia/Shanghai
        self.timezone = timezone
        # {"port":8080,"contextPath":"/","maxThreads":400,"uriEncoding":"ISO-8859-1","useBodyEncodingForUri":true}
        self.tomcat_config = tomcat_config
        # vsw-bp12mw1f8k3jgygk9\\*\\*\\*\\*\
        self.v_switch_id = v_switch_id
        # vpc-bp1aevy8sofi8mh1q\\*\\*\\*\\*\
        self.vpc_id = vpc_id
        # CATALINA_OPTS=\\\\"$CATALINA_OPTS $Options\\\\" catalina.sh run
        self.war_start_options = war_start_options
        # apache-tomcat-7.0.91
        self.web_container = web_container

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acr_assume_role_arn is not None:
            result['AcrAssumeRoleArn'] = self.acr_assume_role_arn
        if self.acr_instance_id is not None:
            result['AcrInstanceId'] = self.acr_instance_id
        if self.app_description is not None:
            result['AppDescription'] = self.app_description
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.app_source is not None:
            result['AppSource'] = self.app_source
        if self.associate_eip is not None:
            result['AssociateEip'] = self.associate_eip
        if self.auto_config is not None:
            result['AutoConfig'] = self.auto_config
        if self.base_app_id is not None:
            result['BaseAppId'] = self.base_app_id
        if self.command is not None:
            result['Command'] = self.command
        if self.command_args is not None:
            result['CommandArgs'] = self.command_args
        if self.config_map_mount_desc is not None:
            result['ConfigMapMountDesc'] = self.config_map_mount_desc
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.custom_host_alias is not None:
            result['CustomHostAlias'] = self.custom_host_alias
        if self.deploy is not None:
            result['Deploy'] = self.deploy
        if self.edas_container_version is not None:
            result['EdasContainerVersion'] = self.edas_container_version
        if self.enable_ebpf is not None:
            result['EnableEbpf'] = self.enable_ebpf
        if self.envs is not None:
            result['Envs'] = self.envs
        if self.image_pull_secrets is not None:
            result['ImagePullSecrets'] = self.image_pull_secrets
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.jar_start_args is not None:
            result['JarStartArgs'] = self.jar_start_args
        if self.jar_start_options is not None:
            result['JarStartOptions'] = self.jar_start_options
        if self.jdk is not None:
            result['Jdk'] = self.jdk
        if self.kafka_configs is not None:
            result['KafkaConfigs'] = self.kafka_configs
        if self.liveness is not None:
            result['Liveness'] = self.liveness
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.micro_registration is not None:
            result['MicroRegistration'] = self.micro_registration
        if self.micro_registration_config is not None:
            result['MicroRegistrationConfig'] = self.micro_registration_config
        if self.mount_desc is not None:
            result['MountDesc'] = self.mount_desc
        if self.mount_host is not None:
            result['MountHost'] = self.mount_host
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.nas_configs is not None:
            result['NasConfigs'] = self.nas_configs
        if self.nas_id is not None:
            result['NasId'] = self.nas_id
        if self.oss_ak_id is not None:
            result['OssAkId'] = self.oss_ak_id
        if self.oss_ak_secret is not None:
            result['OssAkSecret'] = self.oss_ak_secret
        if self.oss_mount_descs is not None:
            result['OssMountDescs'] = self.oss_mount_descs
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        if self.php is not None:
            result['Php'] = self.php
        if self.php_arms_config_location is not None:
            result['PhpArmsConfigLocation'] = self.php_arms_config_location
        if self.php_config is not None:
            result['PhpConfig'] = self.php_config
        if self.php_config_location is not None:
            result['PhpConfigLocation'] = self.php_config_location
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.programming_language is not None:
            result['ProgrammingLanguage'] = self.programming_language
        if self.pvtz_discovery_svc is not None:
            result['PvtzDiscoverySvc'] = self.pvtz_discovery_svc
        if self.python is not None:
            result['Python'] = self.python
        if self.python_modules is not None:
            result['PythonModules'] = self.python_modules
        if self.readiness is not None:
            result['Readiness'] = self.readiness
        if self.replicas is not None:
            result['Replicas'] = self.replicas
        if self.sae_version is not None:
            result['SaeVersion'] = self.sae_version
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.service_tags is not None:
            result['ServiceTags'] = self.service_tags
        if self.sls_configs is not None:
            result['SlsConfigs'] = self.sls_configs
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        if self.timezone is not None:
            result['Timezone'] = self.timezone
        if self.tomcat_config is not None:
            result['TomcatConfig'] = self.tomcat_config
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.war_start_options is not None:
            result['WarStartOptions'] = self.war_start_options
        if self.web_container is not None:
            result['WebContainer'] = self.web_container
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcrAssumeRoleArn') is not None:
            self.acr_assume_role_arn = m.get('AcrAssumeRoleArn')
        if m.get('AcrInstanceId') is not None:
            self.acr_instance_id = m.get('AcrInstanceId')
        if m.get('AppDescription') is not None:
            self.app_description = m.get('AppDescription')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AppSource') is not None:
            self.app_source = m.get('AppSource')
        if m.get('AssociateEip') is not None:
            self.associate_eip = m.get('AssociateEip')
        if m.get('AutoConfig') is not None:
            self.auto_config = m.get('AutoConfig')
        if m.get('BaseAppId') is not None:
            self.base_app_id = m.get('BaseAppId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CommandArgs') is not None:
            self.command_args = m.get('CommandArgs')
        if m.get('ConfigMapMountDesc') is not None:
            self.config_map_mount_desc = m.get('ConfigMapMountDesc')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CustomHostAlias') is not None:
            self.custom_host_alias = m.get('CustomHostAlias')
        if m.get('Deploy') is not None:
            self.deploy = m.get('Deploy')
        if m.get('EdasContainerVersion') is not None:
            self.edas_container_version = m.get('EdasContainerVersion')
        if m.get('EnableEbpf') is not None:
            self.enable_ebpf = m.get('EnableEbpf')
        if m.get('Envs') is not None:
            self.envs = m.get('Envs')
        if m.get('ImagePullSecrets') is not None:
            self.image_pull_secrets = m.get('ImagePullSecrets')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('JarStartArgs') is not None:
            self.jar_start_args = m.get('JarStartArgs')
        if m.get('JarStartOptions') is not None:
            self.jar_start_options = m.get('JarStartOptions')
        if m.get('Jdk') is not None:
            self.jdk = m.get('Jdk')
        if m.get('KafkaConfigs') is not None:
            self.kafka_configs = m.get('KafkaConfigs')
        if m.get('Liveness') is not None:
            self.liveness = m.get('Liveness')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MicroRegistration') is not None:
            self.micro_registration = m.get('MicroRegistration')
        if m.get('MicroRegistrationConfig') is not None:
            self.micro_registration_config = m.get('MicroRegistrationConfig')
        if m.get('MountDesc') is not None:
            self.mount_desc = m.get('MountDesc')
        if m.get('MountHost') is not None:
            self.mount_host = m.get('MountHost')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NasConfigs') is not None:
            self.nas_configs = m.get('NasConfigs')
        if m.get('NasId') is not None:
            self.nas_id = m.get('NasId')
        if m.get('OssAkId') is not None:
            self.oss_ak_id = m.get('OssAkId')
        if m.get('OssAkSecret') is not None:
            self.oss_ak_secret = m.get('OssAkSecret')
        if m.get('OssMountDescs') is not None:
            self.oss_mount_descs = m.get('OssMountDescs')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        if m.get('Php') is not None:
            self.php = m.get('Php')
        if m.get('PhpArmsConfigLocation') is not None:
            self.php_arms_config_location = m.get('PhpArmsConfigLocation')
        if m.get('PhpConfig') is not None:
            self.php_config = m.get('PhpConfig')
        if m.get('PhpConfigLocation') is not None:
            self.php_config_location = m.get('PhpConfigLocation')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('ProgrammingLanguage') is not None:
            self.programming_language = m.get('ProgrammingLanguage')
        if m.get('PvtzDiscoverySvc') is not None:
            self.pvtz_discovery_svc = m.get('PvtzDiscoverySvc')
        if m.get('Python') is not None:
            self.python = m.get('Python')
        if m.get('PythonModules') is not None:
            self.python_modules = m.get('PythonModules')
        if m.get('Readiness') is not None:
            self.readiness = m.get('Readiness')
        if m.get('Replicas') is not None:
            self.replicas = m.get('Replicas')
        if m.get('SaeVersion') is not None:
            self.sae_version = m.get('SaeVersion')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('ServiceTags') is not None:
            self.service_tags = m.get('ServiceTags')
        if m.get('SlsConfigs') is not None:
            self.sls_configs = m.get('SlsConfigs')
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        if m.get('Timezone') is not None:
            self.timezone = m.get('Timezone')
        if m.get('TomcatConfig') is not None:
            self.tomcat_config = m.get('TomcatConfig')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WarStartOptions') is not None:
            self.war_start_options = m.get('WarStartOptions')
        if m.get('WebContainer') is not None:
            self.web_container = m.get('WebContainer')
        return self


class CreateApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        change_order_id: str = None,
    ):
        # The ID of the application that is created.
        self.app_id = app_id
        # The ID of the change order. It can be used to query the task status.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class CreateApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateApplicationResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The error code. Valid values:
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the application is created. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateApplicationScalingRuleRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        min_ready_instance_ratio: int = None,
        min_ready_instances: int = None,
        scaling_rule_enable: bool = None,
        scaling_rule_metric: str = None,
        scaling_rule_name: str = None,
        scaling_rule_timer: str = None,
        scaling_rule_type: str = None,
    ):
        # This parameter is required.
        self.app_id = app_id
        self.min_ready_instance_ratio = min_ready_instance_ratio
        self.min_ready_instances = min_ready_instances
        self.scaling_rule_enable = scaling_rule_enable
        self.scaling_rule_metric = scaling_rule_metric
        # This parameter is required.
        self.scaling_rule_name = scaling_rule_name
        self.scaling_rule_timer = scaling_rule_timer
        # This parameter is required.
        self.scaling_rule_type = scaling_rule_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.min_ready_instance_ratio is not None:
            result['MinReadyInstanceRatio'] = self.min_ready_instance_ratio
        if self.min_ready_instances is not None:
            result['MinReadyInstances'] = self.min_ready_instances
        if self.scaling_rule_enable is not None:
            result['ScalingRuleEnable'] = self.scaling_rule_enable
        if self.scaling_rule_metric is not None:
            result['ScalingRuleMetric'] = self.scaling_rule_metric
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        if self.scaling_rule_timer is not None:
            result['ScalingRuleTimer'] = self.scaling_rule_timer
        if self.scaling_rule_type is not None:
            result['ScalingRuleType'] = self.scaling_rule_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('MinReadyInstanceRatio') is not None:
            self.min_ready_instance_ratio = m.get('MinReadyInstanceRatio')
        if m.get('MinReadyInstances') is not None:
            self.min_ready_instances = m.get('MinReadyInstances')
        if m.get('ScalingRuleEnable') is not None:
            self.scaling_rule_enable = m.get('ScalingRuleEnable')
        if m.get('ScalingRuleMetric') is not None:
            self.scaling_rule_metric = m.get('ScalingRuleMetric')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        if m.get('ScalingRuleTimer') is not None:
            self.scaling_rule_timer = m.get('ScalingRuleTimer')
        if m.get('ScalingRuleType') is not None:
            self.scaling_rule_type = m.get('ScalingRuleType')
        return self


class CreateApplicationScalingRuleResponseBodyDataMetricMetrics(TeaModel):
    def __init__(
        self,
        metric_target_average_utilization: int = None,
        metric_type: str = None,
        slb_id: str = None,
        slb_logstore: str = None,
        slb_project: str = None,
        vport: str = None,
    ):
        self.metric_target_average_utilization = metric_target_average_utilization
        self.metric_type = metric_type
        self.slb_id = slb_id
        self.slb_logstore = slb_logstore
        self.slb_project = slb_project
        self.vport = vport

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_target_average_utilization is not None:
            result['MetricTargetAverageUtilization'] = self.metric_target_average_utilization
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.slb_logstore is not None:
            result['SlbLogstore'] = self.slb_logstore
        if self.slb_project is not None:
            result['SlbProject'] = self.slb_project
        if self.vport is not None:
            result['Vport'] = self.vport
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricTargetAverageUtilization') is not None:
            self.metric_target_average_utilization = m.get('MetricTargetAverageUtilization')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('SlbLogstore') is not None:
            self.slb_logstore = m.get('SlbLogstore')
        if m.get('SlbProject') is not None:
            self.slb_project = m.get('SlbProject')
        if m.get('Vport') is not None:
            self.vport = m.get('Vport')
        return self


class CreateApplicationScalingRuleResponseBodyDataMetric(TeaModel):
    def __init__(
        self,
        max_replicas: int = None,
        metrics: List[CreateApplicationScalingRuleResponseBodyDataMetricMetrics] = None,
        min_replicas: int = None,
    ):
        self.max_replicas = max_replicas
        self.metrics = metrics
        self.min_replicas = min_replicas

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_replicas is not None:
            result['MaxReplicas'] = self.max_replicas
        result['Metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['Metrics'].append(k.to_map() if k else None)
        if self.min_replicas is not None:
            result['MinReplicas'] = self.min_replicas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxReplicas') is not None:
            self.max_replicas = m.get('MaxReplicas')
        self.metrics = []
        if m.get('Metrics') is not None:
            for k in m.get('Metrics'):
                temp_model = CreateApplicationScalingRuleResponseBodyDataMetricMetrics()
                self.metrics.append(temp_model.from_map(k))
        if m.get('MinReplicas') is not None:
            self.min_replicas = m.get('MinReplicas')
        return self


class CreateApplicationScalingRuleResponseBodyDataTimerSchedules(TeaModel):
    def __init__(
        self,
        at_time: str = None,
        max_replicas: int = None,
        min_replicas: int = None,
        target_replicas: int = None,
    ):
        self.at_time = at_time
        self.max_replicas = max_replicas
        self.min_replicas = min_replicas
        self.target_replicas = target_replicas

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.at_time is not None:
            result['AtTime'] = self.at_time
        if self.max_replicas is not None:
            result['MaxReplicas'] = self.max_replicas
        if self.min_replicas is not None:
            result['MinReplicas'] = self.min_replicas
        if self.target_replicas is not None:
            result['TargetReplicas'] = self.target_replicas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AtTime') is not None:
            self.at_time = m.get('AtTime')
        if m.get('MaxReplicas') is not None:
            self.max_replicas = m.get('MaxReplicas')
        if m.get('MinReplicas') is not None:
            self.min_replicas = m.get('MinReplicas')
        if m.get('TargetReplicas') is not None:
            self.target_replicas = m.get('TargetReplicas')
        return self


class CreateApplicationScalingRuleResponseBodyDataTimer(TeaModel):
    def __init__(
        self,
        begin_date: str = None,
        end_date: str = None,
        period: str = None,
        schedules: List[CreateApplicationScalingRuleResponseBodyDataTimerSchedules] = None,
    ):
        self.begin_date = begin_date
        self.end_date = end_date
        self.period = period
        self.schedules = schedules

    def validate(self):
        if self.schedules:
            for k in self.schedules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.period is not None:
            result['Period'] = self.period
        result['Schedules'] = []
        if self.schedules is not None:
            for k in self.schedules:
                result['Schedules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        self.schedules = []
        if m.get('Schedules') is not None:
            for k in m.get('Schedules'):
                temp_model = CreateApplicationScalingRuleResponseBodyDataTimerSchedules()
                self.schedules.append(temp_model.from_map(k))
        return self


class CreateApplicationScalingRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        create_time: int = None,
        last_disable_time: int = None,
        metric: CreateApplicationScalingRuleResponseBodyDataMetric = None,
        scale_rule_enabled: bool = None,
        scale_rule_name: str = None,
        scale_rule_type: str = None,
        timer: CreateApplicationScalingRuleResponseBodyDataTimer = None,
        update_time: int = None,
    ):
        self.app_id = app_id
        self.create_time = create_time
        self.last_disable_time = last_disable_time
        self.metric = metric
        self.scale_rule_enabled = scale_rule_enabled
        self.scale_rule_name = scale_rule_name
        self.scale_rule_type = scale_rule_type
        self.timer = timer
        self.update_time = update_time

    def validate(self):
        if self.metric:
            self.metric.validate()
        if self.timer:
            self.timer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_disable_time is not None:
            result['LastDisableTime'] = self.last_disable_time
        if self.metric is not None:
            result['Metric'] = self.metric.to_map()
        if self.scale_rule_enabled is not None:
            result['ScaleRuleEnabled'] = self.scale_rule_enabled
        if self.scale_rule_name is not None:
            result['ScaleRuleName'] = self.scale_rule_name
        if self.scale_rule_type is not None:
            result['ScaleRuleType'] = self.scale_rule_type
        if self.timer is not None:
            result['Timer'] = self.timer.to_map()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastDisableTime') is not None:
            self.last_disable_time = m.get('LastDisableTime')
        if m.get('Metric') is not None:
            temp_model = CreateApplicationScalingRuleResponseBodyDataMetric()
            self.metric = temp_model.from_map(m['Metric'])
        if m.get('ScaleRuleEnabled') is not None:
            self.scale_rule_enabled = m.get('ScaleRuleEnabled')
        if m.get('ScaleRuleName') is not None:
            self.scale_rule_name = m.get('ScaleRuleName')
        if m.get('ScaleRuleType') is not None:
            self.scale_rule_type = m.get('ScaleRuleType')
        if m.get('Timer') is not None:
            temp_model = CreateApplicationScalingRuleResponseBodyDataTimer()
            self.timer = temp_model.from_map(m['Timer'])
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class CreateApplicationScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateApplicationScalingRuleResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.error_code = error_code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateApplicationScalingRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateApplicationScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateApplicationScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateApplicationScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateConfigMapRequest(TeaModel):
    def __init__(
        self,
        data: str = None,
        description: str = None,
        name: str = None,
        namespace_id: str = None,
    ):
        # This parameter is required.
        self.data = data
        self.description = description
        # cn-hangzhou
        # 
        # This parameter is required.
        self.name = name
        # The ID of the request.
        # 
        # This parameter is required.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class CreateConfigMapResponseBodyData(TeaModel):
    def __init__(
        self,
        config_map_id: int = None,
    ):
        # The returned error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.config_map_id = config_map_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_id is not None:
            result['ConfigMapId'] = self.config_map_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigMapId') is not None:
            self.config_map_id = m.get('ConfigMapId')
        return self


class CreateConfigMapResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateConfigMapResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the ConfigMap instance was created. Valid values:
        # 
        # *   **true**: The instance was created.
        # *   **false**: The call failed to be created.
        self.code = code
        # The ID of the ConfigMap instance that was created.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the call was successful.
        # *   **3xx**: indicates that the call was redirected.
        # *   **4xx**: indicates that the call failed.
        # *   **5xx**: indicates that a server error occurred.
        self.error_code = error_code
        # The ID of the trace. The ID is used to query the details of a request.
        self.message = message
        # The returned information.
        self.request_id = request_id
        self.success = success
        # The returned result.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateConfigMapResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateConfigMapResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateConfigMapResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateConfigMapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateGreyTagRouteRequest(TeaModel):
    def __init__(
        self,
        alb_rules: str = None,
        app_id: str = None,
        description: str = None,
        dubbo_rules: str = None,
        name: str = None,
        sc_rules: str = None,
    ):
        self.alb_rules = alb_rules
        # dubbo-echo
        # 
        # This parameter is required.
        self.app_id = app_id
        # [{"condition":"OR","items":[{"cond":"==","name":"grey","operator":"rawvalue","type":"param","value":"true"},{"cond":"==","name":"grey","operator":"rawvalue","type":"cookie","value":"true"},{"cond":"==","name":"grey","operator":"rawvalue","type":"header","value":"true"}],"path":"/post-echo/hi"}]
        self.description = description
        # The ID of the request.
        self.dubbo_rules = dubbo_rules
        # Canary Release - Regions
        # 
        # This parameter is required.
        self.name = name
        # [{"condition":"OR","group":"DUBBO","items":[{"cond":"==","expr":".key1","index":0,"operator":"rawvalue","value":"value1"},{"cond":"==","expr":".key2","index":0,"operator":"rawvalue","value":"value2"}],"methodName":"echo","serviceName":"com.alibaba.edas.boot.EchoService","version":"1.0.0"}]
        self.sc_rules = sc_rules

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alb_rules is not None:
            result['AlbRules'] = self.alb_rules
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.description is not None:
            result['Description'] = self.description
        if self.dubbo_rules is not None:
            result['DubboRules'] = self.dubbo_rules
        if self.name is not None:
            result['Name'] = self.name
        if self.sc_rules is not None:
            result['ScRules'] = self.sc_rules
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlbRules') is not None:
            self.alb_rules = m.get('AlbRules')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DubboRules') is not None:
            self.dubbo_rules = m.get('DubboRules')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ScRules') is not None:
            self.sc_rules = m.get('ScRules')
        return self


class CreateGreyTagRouteResponseBodyData(TeaModel):
    def __init__(
        self,
        grey_tag_route_id: int = None,
    ):
        # The returned error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.grey_tag_route_id = grey_tag_route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grey_tag_route_id is not None:
            result['GreyTagRouteId'] = self.grey_tag_route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GreyTagRouteId') is not None:
            self.grey_tag_route_id = m.get('GreyTagRouteId')
        return self


class CreateGreyTagRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateGreyTagRouteResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the information of the change order was queried. Valid values:
        # 
        # *   **true**: The information was queried.
        # *   **false**: The information failed to be queried.
        self.code = code
        # The ID of the canary release rule. The ID is globally unique.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.error_code = error_code
        # The trace ID that is used to query the details of the request.
        self.message = message
        # The returned information.
        self.request_id = request_id
        self.success = success
        # The information about the canary release rule.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateGreyTagRouteResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateGreyTagRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateGreyTagRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateGreyTagRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateIngressRequest(TeaModel):
    def __init__(
        self,
        cert_id: str = None,
        cert_ids: str = None,
        default_rule: str = None,
        description: str = None,
        listener_port: int = None,
        listener_protocol: str = None,
        load_balance_type: str = None,
        namespace_id: str = None,
        rules: str = None,
        slb_id: str = None,
    ):
        self.cert_id = cert_id
        self.cert_ids = cert_ids
        # This parameter is required.
        self.default_rule = default_rule
        self.description = description
        # This parameter is required.
        self.listener_port = listener_port
        self.listener_protocol = listener_protocol
        self.load_balance_type = load_balance_type
        # This parameter is required.
        self.namespace_id = namespace_id
        # This parameter is required.
        self.rules = rules
        # This parameter is required.
        self.slb_id = slb_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_ids is not None:
            result['CertIds'] = self.cert_ids
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.description is not None:
            result['Description'] = self.description
        if self.listener_port is not None:
            result['ListenerPort'] = self.listener_port
        if self.listener_protocol is not None:
            result['ListenerProtocol'] = self.listener_protocol
        if self.load_balance_type is not None:
            result['LoadBalanceType'] = self.load_balance_type
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.rules is not None:
            result['Rules'] = self.rules
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertIds') is not None:
            self.cert_ids = m.get('CertIds')
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ListenerPort') is not None:
            self.listener_port = m.get('ListenerPort')
        if m.get('ListenerProtocol') is not None:
            self.listener_protocol = m.get('ListenerProtocol')
        if m.get('LoadBalanceType') is not None:
            self.load_balance_type = m.get('LoadBalanceType')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('Rules') is not None:
            self.rules = m.get('Rules')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        return self


class CreateIngressResponseBodyData(TeaModel):
    def __init__(
        self,
        ingress_id: int = None,
    ):
        self.ingress_id = ingress_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ingress_id is not None:
            result['IngressId'] = self.ingress_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IngressId') is not None:
            self.ingress_id = m.get('IngressId')
        return self


class CreateIngressResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateIngressResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.error_code = error_code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateIngressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateIngressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateIngressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateIngressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJobRequest(TeaModel):
    def __init__(
        self,
        acr_assume_role_arn: str = None,
        acr_instance_id: str = None,
        app_description: str = None,
        app_name: str = None,
        auto_config: bool = None,
        backoff_limit: int = None,
        command: str = None,
        command_args: str = None,
        concurrency_policy: str = None,
        config_map_mount_desc: str = None,
        cpu: int = None,
        custom_host_alias: str = None,
        edas_container_version: str = None,
        enable_image_accl: bool = None,
        envs: str = None,
        image_pull_secrets: str = None,
        image_url: str = None,
        jar_start_args: str = None,
        jar_start_options: str = None,
        jdk: str = None,
        memory: int = None,
        mount_desc: str = None,
        mount_host: str = None,
        namespace_id: str = None,
        nas_id: str = None,
        oss_ak_id: str = None,
        oss_ak_secret: str = None,
        oss_mount_descs: str = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
        php_config: str = None,
        php_config_location: str = None,
        post_start: str = None,
        pre_stop: str = None,
        programming_language: str = None,
        python: str = None,
        python_modules: str = None,
        ref_app_id: str = None,
        replicas: int = None,
        security_group_id: str = None,
        slice: bool = None,
        slice_envs: str = None,
        sls_configs: str = None,
        termination_grace_period_seconds: int = None,
        timeout: int = None,
        timezone: str = None,
        tomcat_config: str = None,
        trigger_config: str = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        war_start_options: str = None,
        web_container: str = None,
        workload: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) required for a RAM role to obtain images across accounts. For more information, see [Grant permissions across Alibaba Cloud accounts by using a RAM role](https://help.aliyun.com/document_detail/223585.html).
        self.acr_assume_role_arn = acr_assume_role_arn
        # The ID of Container Registry Enterprise Edition instance N. This parameter is required when the **ImageUrl** parameter is set to the URL of an image in an ACR Enterprise Edition instance.
        self.acr_instance_id = acr_instance_id
        # The description of the template. The description cannot exceed 1,024 characters in length.
        self.app_description = app_description
        # The name of the job template. The name can contain digits, letters, and hyphens (-). The name must start with a letter and cannot exceed 36 characters in length.
        # 
        # This parameter is required.
        self.app_name = app_name
        # Specifies whether to automatically configure the network environment. Take note of the following rules:
        # 
        # *   **true**: The network environment is automatically configured by SAE when the application is created. In this case, the values of the **NamespaceId**, **VpcId**, **vSwitchId**, and **SecurityGroupId** parameters are ignored.
        # *   **false**: The network environment is manually configured based on your settings when the application is created.
        self.auto_config = auto_config
        # The number of times the job is retried.
        self.backoff_limit = backoff_limit
        # The command that is used to start the image. The command must be an existing executable object in the container. Sample statements:
        # 
        #     command:
        #           - echo
        #           - abc
        #           - >
        #           - file0
        # 
        # In this example, the Command parameter is set to `Command="echo", CommandArgs=["abc", ">", "file0"]`.
        self.command = command
        # The parameters of the image startup command. The CommandArgs parameter specifies the parameters that are required for the **Command** parameter. You can specify the name in one of the following formats:
        # 
        # `["a","b"]`
        # 
        # In the preceding example, the CommandArgs parameter is set to `CommandArgs=["abc", ">", "file0"]`. The data type of `["abc", ">", "file0"]` must be an array of strings in the JSON format. This parameter is optional.
        self.command_args = command_args
        # The concurrency policy of the job. Take note of the following rules:
        # 
        # *   **Forbid**: Prohibits concurrent running. If the previous job is not completed, no new job is created.
        # *   **Allow**: Allows concurrent running.
        # *   **Replace**: If the previous job is not completed when the time to create a new job is reached, the new job replaces the previous job.
        self.concurrency_policy = concurrency_policy
        # The description of the **ConfigMap** instance mounted to the application. Use configurations created on the Configuration Items page to configure containers. The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **congfigMapId**: the ID of the ConfigMap instance. You can call the [ListNamespacedConfigMaps](https://help.aliyun.com/document_detail/176917.html) operation to obtain the ID.
        # *   **key**: the key.
        # 
        # > You can use the `sae-sys-configmap-all` key to mount all keys.
        # 
        # *   **mountPath**: the mount path in the container.
        self.config_map_mount_desc = config_map_mount_desc
        # The CPU specifications that are required for each instance. Unit: millicores. You cannot set this parameter to 0. Valid values:
        # 
        # *   500
        # *   1000
        # *   2000
        # *   4000
        # *   8000
        # *   16000
        # *   32000
        self.cpu = cpu
        # The custom mappings between hostnames and IP addresses in the container. Take note of the following rules:
        # 
        # *   **hostName**: the domain name or hostname.
        # *   **ip**: the IP address.
        self.custom_host_alias = custom_host_alias
        # The version of the container, such as Ali-Tomcat, in which an application developed based on High-speed Service Framework (HSF) is deployed.
        self.edas_container_version = edas_container_version
        self.enable_image_accl = enable_image_accl
        # The environment variables. You can configure custom environment variables or reference a ConfigMap. If you want to reference a ConfigMap, you must first create a ConfigMap. For more information, see [CreateConfigMap](https://help.aliyun.com/document_detail/176914.html). Take note of the following rules:
        # 
        # *   Customize
        # 
        #     *   **name**: the name of the environment variable.
        #     *   **value**: the value of the environment variable.
        # 
        # *   Reference ConfigMap
        # 
        #     *   **name**: the name of the environment variable. You can reference one or all keys. If you want to reference all keys, specify `sae-sys-configmap-all-<ConfigMap name>`. Example: `sae-sys-configmap-all-test1`.
        #     *   **valueFrom**: the reference of the environment variable. Set the value to `configMapRef`.
        #     *   **configMapId**: the ConfigMap ID.
        #     *   **key**: the key. If you want to reference all keys, do not configure this parameter.
        self.envs = envs
        # The ID of the corresponding Secret.
        self.image_pull_secrets = image_pull_secrets
        # The URL of the image. This parameter is returned only if the **PackageType** parameter is set to **Image**.
        self.image_url = image_url
        # The arguments in the JAR package. The arguments are used to start the application container. The default startup command is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_args = jar_start_args
        # The option settings in the JAR package. The settings are used to start the application container. The default startup command for application deployment is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_options = jar_start_options
        # The version of the Java development kit (JDK) on which the deployment package of the application depends. The following versions are supported:
        # 
        # *   **Open JDK 8**\
        # *   **Open JDK 7**\
        # *   **Dragonwell 11**\
        # *   **Dragonwell 8**\
        # *   **openjdk-8u191-jdk-alpine3.9**\
        # *   **openjdk-7u201-jdk-alpine3.9**\
        # 
        # This parameter is not returned if the **PackageType** parameter is set to **Image**.
        self.jdk = jdk
        # The size of memory required by each instance. Unit: MB. You cannot set this parameter to 0. The values of this parameter correspond to the values of the Cpu parameter:
        # 
        # *   Set the value to 1024 when Cpu is set to 500 or 1000.
        # *   Set the value to 2048 when Cpu is set to 500, 1000 or 2000.
        # *   Set the value to 4096 when Cpu is set to 1000, 2000, or 4000.
        # *   Set the value to 8192 when Cpu is set to 2000, 4000, or 8000.
        # *   Set the value to 12288 when Cpu is set to 12000.
        # *   Set the value to 16384 when Cpu is set to 4000, 8000, or 16000.
        # *   Set the value to 24576 when Cpu is set to 12000.
        # *   Set the value to 32768 when Cpu is set to 16000.
        # *   Set the value to 65536 when Cpu is set to 8000, 16000, or 32000.
        # *   Set the value to 131072 when Cpu is set to 32000.
        self.memory = memory
        # The configurations for mounting the NAS file system. After the application is created, you may want to call other operations to manage the application. If you do not want to change the NAS configurations in these subsequent operations, you can omit the **MountDesc** parameter in the requests. If you want to unmount the NAS file system, you must set the **MountDesc** values in the subsequent requests to an empty string ("").
        self.mount_desc = mount_desc
        # The mount target of the NAS file system in the VPC where the application is deployed. If you do not need to modify this configuration during the deployment, configure the **MountHost** parameter only in the first request. You do not need to include this parameter in subsequent requests. If you need to remove this configuration, leave the **MountHost** parameter empty in the request.
        self.mount_host = mount_host
        # The ID of the Serverless App Engine (SAE) namespace. The ID can contain only lowercase letters and hyphens (-). It must start with a lowercase letter.
        self.namespace_id = namespace_id
        # The ID of the Apsara File Storage NAS file system. After the application is created, you may want to call other operations to manage the application. If you do not want to change the NAS configurations in these subsequent operations, you can omit the **NasId** parameter in the requests. If you want to unmount the NAS file system, you must set the **NasId** values in the subsequent requests to an empty string ("").
        self.nas_id = nas_id
        # The AccessKey ID that is used to read data from and write data to Object Storage Service (OSS) buckets.
        self.oss_ak_id = oss_ak_id
        # The AccessKey secret that is used to read data from and write data to OSS buckets.
        self.oss_ak_secret = oss_ak_secret
        # Information of the Object Storage Service (OSS) bucket mounted to the application. The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **bucketName**: the name of the OSS bucket.
        # 
        # *   **bucketPath**: the directory or object in OSS. If the specified directory or object does not exist, an error is returned.
        # 
        # *   **mountPath**: the directory of the container in SAE. If the path already exists, the newly specified path overwrites the previous one. If the path does not exist, it is created.
        # 
        # *   **readOnly**: specifies whether to only allow the container path to read data from the OSS directory. Valid values:
        # 
        #     *   **true**: The container path only has read permission on the OSS directory.
        #     *   **false**: The application has read and write permissions.
        self.oss_mount_descs = oss_mount_descs
        # The type of the deployment package. Take note of the following rules:
        # 
        # *   If you deploy the application by using a Java Archive (JAR) package, you can set this parameter to **FatJar**, **War**, or **Image**.
        # *   If you deploy the application by using a PHP package, you can set this parameter to one of the following values:
        # 
        # **PhpZip** **IMAGE_PHP_5_4** **IMAGE_PHP_5_4_ALPINE** **IMAGE_PHP_5_5** **IMAGE_PHP_5_5_ALPINE** **IMAGE_PHP_5_6** **IMAGE_PHP_5_6_ALPINE** **IMAGE_PHP_7_0** **IMAGE_PHP_7_0_ALPINE** **IMAGE_PHP_7_1** **IMAGE_PHP_7_1_ALPINE** **IMAGE_PHP_7_2** **IMAGE_PHP_7_2_ALPINE** **IMAGE_PHP_7_3** **IMAGE_PHP_7_3_ALPINE**\
        # 
        # *   If you deploy the application by using a **Python** package, you can set this parameter to **PythonZip** or **Image**:
        # 
        # This parameter is required.
        self.package_type = package_type
        # The address of the deployment package. This parameter is required if you set **PackageType** to **FatJar**, **War**, or **PythonZip**.
        self.package_url = package_url
        # The version of the deployment package. This parameter is required if you set **PackageType** to **FatJar**, **War**, or **PythonZip**.
        self.package_version = package_version
        # The details of the PHP configuration file.
        self.php_config = php_config
        # The path on which the PHP configuration file for application startup is mounted. Make sure that the PHP server uses this configuration file during the startup.
        self.php_config_location = php_config_location
        # The script that is run immediately after the container is started. Example: `{"exec":{"command":["sh","-c","echo hello"\\]}}`
        self.post_start = post_start
        # The script that is run before the container is stopped. Example: `{"exec":{"command":["sh","-c","echo hello"\\]}}`
        self.pre_stop = pre_stop
        # The programming language. Valid values: **java**, **php**, **python**, and **shell**.
        self.programming_language = programming_language
        # The Python environment. Set the value to **PYTHON 3.9.15**.
        self.python = python
        # The configurations for installing custom module dependencies. By default, the dependencies defined by the requirements.txt file in the root directory are installed. If the package does not contain this file and you do not configure custom dependencies in the package, specify the dependencies that you want to install in the text box.
        self.python_modules = python_modules
        # The ID of the job that you reference.
        self.ref_app_id = ref_app_id
        # The number of concurrent instances.
        # 
        # This parameter is required.
        self.replicas = replicas
        # The ID of the security group.
        self.security_group_id = security_group_id
        # Specifies whether to enable job sharding.
        self.slice = slice
        # The parameters of job sharding.
        self.slice_envs = slice_envs
        # The logging configurations of Log Service.
        # 
        # *   To use Log Service resources that are automatically created by SAE, set this parameter to `[{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}]`.
        # *   To use custom Log Service resources, set this parameter to `[{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}]`.
        # 
        # The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **projectName**: the name of the Log Service project.
        # *   **logDir**: the path in which logs are stored.
        # *   **logType**: the log type. **stdout**: the standard output log of the container. You can specify only one stdout value for this parameter. If you leave this parameter empty, file logs are collected.
        # *   **logstoreName**: the name of the Logstore in Log Service.
        # *   **logtailName**: the name of the Logtail configuration in Log Service. If you do not configure this parameter, a new Logtail configuration is created.
        # 
        # If you do not need to modify the logging configurations when you deploy the application, configure the **SlsConfigs** parameter only in the first request. You do not need to include this parameter in subsequent requests. If you no longer need to use Log Service, leave the **SlsConfigs** parameter empty in the request.
        # 
        # > A Log Service project that is automatically created by SAE when you create an application is deleted when the application is deleted. Therefore, when you create an application, you cannot select a Log Service project that is automatically created by SAE for log collection.
        self.sls_configs = sls_configs
        # The timeout period for a graceful shutdown. Default value: 30. Unit: seconds. Valid values: 1 to 300.
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # The timeout period. Unit: seconds.
        self.timeout = timeout
        # The time zone. Default value: **Asia/Shanghai**.
        self.timezone = timezone
        # The Tomcat configuration. If you want to cancel this configuration, set this parameter to "" or "{}". The following variables are included in the configuration: Take note of the following rules:
        # 
        # *   **port**: the port number. The port number ranges from 1024 to 65535. Though the admin permissions are configured for the container, the root permissions are required to perform operations on ports whose number is smaller than 1024. Enter a value that ranges from 1025 to 65535 because the container has only the admin permissions. If you do not specify this parameter, the default port number 8080 is used.
        # *   **contextPath**: the path. Default value: /. This value indicates the root directory.
        # *   **maxThreads**: the maximum number of connections in the connection pool. Default value: 400.
        # *   **uriEncoding**: the URI encoding scheme in the Tomcat container. Valid values: UTF-8, ISO-8859-1, GBK, and GB2312.************ If you do not specify this parameter, the default value **ISO-8859-1** is used.
        # *   **useBodyEncoding**: specifies whether to use the encoding scheme specified in the request body for URI query parameters. Default value: true.
        self.tomcat_config = tomcat_config
        self.trigger_config = trigger_config
        # The vSwitch to which the elastic network interface (ENI) of the application instance is connected. The vSwitch must be located in the VPC specified by the VpcId parameter. The SAE namespace is bound with this vSwitch. The default value is the ID of the vSwitch that is bound to the namespace.
        self.v_switch_id = v_switch_id
        # The ID of the virtual private cloud (VPC) that corresponds to the SAE namespace. In SAE, once correspondence is configured between a namespace and a VPC, the namespace cannot correspond to other VPCs. When the SAE application is created within the namespace, the application is bound with the VPC. Multiple namespaces can correspond to the same VPC. The default value is the ID of the VPC that is bound to the namespace.
        self.vpc_id = vpc_id
        # The startup command of the WAR package. For information about how to configure the startup command, see [Configure startup commands](https://help.aliyun.com/document_detail/96677.html).
        self.war_start_options = war_start_options
        # The version of the Tomcat container on which the deployment package depends. Valid values:
        # 
        # *   **apache-tomcat-7.0.91**\
        # *   **apache-tomcat-8.5.42**\
        # 
        # This parameter is not returned if the **PackageType** parameter is set to **Image**.
        self.web_container = web_container
        # Set the value to `job`.
        # 
        # This parameter is required.
        self.workload = workload

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acr_assume_role_arn is not None:
            result['AcrAssumeRoleArn'] = self.acr_assume_role_arn
        if self.acr_instance_id is not None:
            result['AcrInstanceId'] = self.acr_instance_id
        if self.app_description is not None:
            result['AppDescription'] = self.app_description
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.auto_config is not None:
            result['AutoConfig'] = self.auto_config
        if self.backoff_limit is not None:
            result['BackoffLimit'] = self.backoff_limit
        if self.command is not None:
            result['Command'] = self.command
        if self.command_args is not None:
            result['CommandArgs'] = self.command_args
        if self.concurrency_policy is not None:
            result['ConcurrencyPolicy'] = self.concurrency_policy
        if self.config_map_mount_desc is not None:
            result['ConfigMapMountDesc'] = self.config_map_mount_desc
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.custom_host_alias is not None:
            result['CustomHostAlias'] = self.custom_host_alias
        if self.edas_container_version is not None:
            result['EdasContainerVersion'] = self.edas_container_version
        if self.enable_image_accl is not None:
            result['EnableImageAccl'] = self.enable_image_accl
        if self.envs is not None:
            result['Envs'] = self.envs
        if self.image_pull_secrets is not None:
            result['ImagePullSecrets'] = self.image_pull_secrets
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.jar_start_args is not None:
            result['JarStartArgs'] = self.jar_start_args
        if self.jar_start_options is not None:
            result['JarStartOptions'] = self.jar_start_options
        if self.jdk is not None:
            result['Jdk'] = self.jdk
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.mount_desc is not None:
            result['MountDesc'] = self.mount_desc
        if self.mount_host is not None:
            result['MountHost'] = self.mount_host
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.nas_id is not None:
            result['NasId'] = self.nas_id
        if self.oss_ak_id is not None:
            result['OssAkId'] = self.oss_ak_id
        if self.oss_ak_secret is not None:
            result['OssAkSecret'] = self.oss_ak_secret
        if self.oss_mount_descs is not None:
            result['OssMountDescs'] = self.oss_mount_descs
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        if self.php_config is not None:
            result['PhpConfig'] = self.php_config
        if self.php_config_location is not None:
            result['PhpConfigLocation'] = self.php_config_location
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.programming_language is not None:
            result['ProgrammingLanguage'] = self.programming_language
        if self.python is not None:
            result['Python'] = self.python
        if self.python_modules is not None:
            result['PythonModules'] = self.python_modules
        if self.ref_app_id is not None:
            result['RefAppId'] = self.ref_app_id
        if self.replicas is not None:
            result['Replicas'] = self.replicas
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.slice is not None:
            result['Slice'] = self.slice
        if self.slice_envs is not None:
            result['SliceEnvs'] = self.slice_envs
        if self.sls_configs is not None:
            result['SlsConfigs'] = self.sls_configs
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.timezone is not None:
            result['Timezone'] = self.timezone
        if self.tomcat_config is not None:
            result['TomcatConfig'] = self.tomcat_config
        if self.trigger_config is not None:
            result['TriggerConfig'] = self.trigger_config
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.war_start_options is not None:
            result['WarStartOptions'] = self.war_start_options
        if self.web_container is not None:
            result['WebContainer'] = self.web_container
        if self.workload is not None:
            result['Workload'] = self.workload
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcrAssumeRoleArn') is not None:
            self.acr_assume_role_arn = m.get('AcrAssumeRoleArn')
        if m.get('AcrInstanceId') is not None:
            self.acr_instance_id = m.get('AcrInstanceId')
        if m.get('AppDescription') is not None:
            self.app_description = m.get('AppDescription')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AutoConfig') is not None:
            self.auto_config = m.get('AutoConfig')
        if m.get('BackoffLimit') is not None:
            self.backoff_limit = m.get('BackoffLimit')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CommandArgs') is not None:
            self.command_args = m.get('CommandArgs')
        if m.get('ConcurrencyPolicy') is not None:
            self.concurrency_policy = m.get('ConcurrencyPolicy')
        if m.get('ConfigMapMountDesc') is not None:
            self.config_map_mount_desc = m.get('ConfigMapMountDesc')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CustomHostAlias') is not None:
            self.custom_host_alias = m.get('CustomHostAlias')
        if m.get('EdasContainerVersion') is not None:
            self.edas_container_version = m.get('EdasContainerVersion')
        if m.get('EnableImageAccl') is not None:
            self.enable_image_accl = m.get('EnableImageAccl')
        if m.get('Envs') is not None:
            self.envs = m.get('Envs')
        if m.get('ImagePullSecrets') is not None:
            self.image_pull_secrets = m.get('ImagePullSecrets')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('JarStartArgs') is not None:
            self.jar_start_args = m.get('JarStartArgs')
        if m.get('JarStartOptions') is not None:
            self.jar_start_options = m.get('JarStartOptions')
        if m.get('Jdk') is not None:
            self.jdk = m.get('Jdk')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MountDesc') is not None:
            self.mount_desc = m.get('MountDesc')
        if m.get('MountHost') is not None:
            self.mount_host = m.get('MountHost')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NasId') is not None:
            self.nas_id = m.get('NasId')
        if m.get('OssAkId') is not None:
            self.oss_ak_id = m.get('OssAkId')
        if m.get('OssAkSecret') is not None:
            self.oss_ak_secret = m.get('OssAkSecret')
        if m.get('OssMountDescs') is not None:
            self.oss_mount_descs = m.get('OssMountDescs')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        if m.get('PhpConfig') is not None:
            self.php_config = m.get('PhpConfig')
        if m.get('PhpConfigLocation') is not None:
            self.php_config_location = m.get('PhpConfigLocation')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('ProgrammingLanguage') is not None:
            self.programming_language = m.get('ProgrammingLanguage')
        if m.get('Python') is not None:
            self.python = m.get('Python')
        if m.get('PythonModules') is not None:
            self.python_modules = m.get('PythonModules')
        if m.get('RefAppId') is not None:
            self.ref_app_id = m.get('RefAppId')
        if m.get('Replicas') is not None:
            self.replicas = m.get('Replicas')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('Slice') is not None:
            self.slice = m.get('Slice')
        if m.get('SliceEnvs') is not None:
            self.slice_envs = m.get('SliceEnvs')
        if m.get('SlsConfigs') is not None:
            self.sls_configs = m.get('SlsConfigs')
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Timezone') is not None:
            self.timezone = m.get('Timezone')
        if m.get('TomcatConfig') is not None:
            self.tomcat_config = m.get('TomcatConfig')
        if m.get('TriggerConfig') is not None:
            self.trigger_config = m.get('TriggerConfig')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WarStartOptions') is not None:
            self.war_start_options = m.get('WarStartOptions')
        if m.get('WebContainer') is not None:
            self.web_container = m.get('WebContainer')
        if m.get('Workload') is not None:
            self.workload = m.get('Workload')
        return self


class CreateJobResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        change_order_id: str = None,
    ):
        # The application ID.
        self.app_id = app_id
        # The ID of the change order. It can be used to query the task status.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class CreateJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateJobResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Take note of the following rules:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The response.
        self.data = data
        # The error code returned if the request failed. Take note of the following rules:
        # 
        # *   The **ErrorCode** parameter is not returned if the request succeeds.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.error_code = error_code
        # The additional information that is returned. Take note of the following rules:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the application deployment is successful. Take note of the following rules:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateNamespaceRequest(TeaModel):
    def __init__(
        self,
        enable_micro_registration: bool = None,
        name_space_short_id: str = None,
        namespace_description: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
    ):
        self.enable_micro_registration = enable_micro_registration
        # The trace ID that is used to query the details of the request.
        self.name_space_short_id = name_space_short_id
        # The message returned for the operation.
        self.namespace_description = namespace_description
        # The data returned.
        self.namespace_id = namespace_id
        # The ID of the request.
        # 
        # This parameter is required.
        self.namespace_name = namespace_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_micro_registration is not None:
            result['EnableMicroRegistration'] = self.enable_micro_registration
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_description is not None:
            result['NamespaceDescription'] = self.namespace_description
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.namespace_name is not None:
            result['NamespaceName'] = self.namespace_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableMicroRegistration') is not None:
            self.enable_micro_registration = m.get('EnableMicroRegistration')
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceDescription') is not None:
            self.namespace_description = m.get('NamespaceDescription')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NamespaceName') is not None:
            self.namespace_name = m.get('NamespaceName')
        return self


class CreateNamespaceResponseBodyData(TeaModel):
    def __init__(
        self,
        enable_micro_registration: bool = None,
        name_space_short_id: str = None,
        namespace_description: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
        region_id: str = None,
    ):
        self.enable_micro_registration = enable_micro_registration
        # Indicates whether the namespace was created. Valid values:
        # 
        # *   **true**: The instance was created.
        # *   **false**: The call failed to be created.
        self.name_space_short_id = name_space_short_id
        # The short ID of the namespace.
        self.namespace_description = namespace_description
        # The error code returned. Take note of the following rules:
        # 
        # *   The **ErrorCode** parameter is not returned if the request succeeds.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.namespace_id = namespace_id
        # Null
        self.namespace_name = namespace_name
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_micro_registration is not None:
            result['EnableMicroRegistration'] = self.enable_micro_registration
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_description is not None:
            result['NamespaceDescription'] = self.namespace_description
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.namespace_name is not None:
            result['NamespaceName'] = self.namespace_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableMicroRegistration') is not None:
            self.enable_micro_registration = m.get('EnableMicroRegistration')
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceDescription') is not None:
            self.namespace_description = m.get('NamespaceDescription')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NamespaceName') is not None:
            self.namespace_name = m.get('NamespaceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class CreateNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateNamespaceResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # bucketPath
        self.code = code
        # The region where the namespace resides.
        self.data = data
        # http://sae_pop_pre/#vpc
        self.error_code = error_code
        # The ID of the namespace.
        self.message = message
        # The description of the custom namespace.
        self.request_id = request_id
        # mountDir
        self.success = success
        # The name of the namespace.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateNamespaceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSecretRequestSecretData(TeaModel):
    def __init__(
        self,
        secret_data: str = None,
    ):
        # This parameter is required.
        self.secret_data = secret_data

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.secret_data is not None:
            result['SecretData'] = self.secret_data
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecretData') is not None:
            self.secret_data = m.get('SecretData')
        return self


class CreateSecretRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
        secret_data: CreateSecretRequestSecretData = None,
        secret_name: str = None,
        secret_type: str = None,
    ):
        # This parameter is required.
        self.namespace_id = namespace_id
        # This parameter is required.
        self.secret_data = secret_data
        # This parameter is required.
        self.secret_name = secret_name
        # This parameter is required.
        self.secret_type = secret_type

    def validate(self):
        if self.secret_data:
            self.secret_data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.secret_data is not None:
            result['SecretData'] = self.secret_data.to_map()
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.secret_type is not None:
            result['SecretType'] = self.secret_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('SecretData') is not None:
            temp_model = CreateSecretRequestSecretData()
            self.secret_data = temp_model.from_map(m['SecretData'])
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('SecretType') is not None:
            self.secret_type = m.get('SecretType')
        return self


class CreateSecretShrinkRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
        secret_data_shrink: str = None,
        secret_name: str = None,
        secret_type: str = None,
    ):
        # This parameter is required.
        self.namespace_id = namespace_id
        # This parameter is required.
        self.secret_data_shrink = secret_data_shrink
        # This parameter is required.
        self.secret_name = secret_name
        # This parameter is required.
        self.secret_type = secret_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.secret_data_shrink is not None:
            result['SecretData'] = self.secret_data_shrink
        if self.secret_name is not None:
            result['SecretName'] = self.secret_name
        if self.secret_type is not None:
            result['SecretType'] = self.secret_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('SecretData') is not None:
            self.secret_data_shrink = m.get('SecretData')
        if m.get('SecretName') is not None:
            self.secret_name = m.get('SecretName')
        if m.get('SecretType') is not None:
            self.secret_type = m.get('SecretType')
        return self


class CreateSecretResponseBodyData(TeaModel):
    def __init__(
        self,
        secret_id: int = None,
    ):
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class CreateSecretResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateSecretResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.error_code = error_code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateSecretResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class CreateSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWebApplicationRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
        body: CreateWebApplicationInput = None,
    ):
        # This parameter is required.
        self.namespace_id = namespace_id
        # This parameter is required.
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('body') is not None:
            temp_model = CreateWebApplicationInput()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWebApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: WebApplicationBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = WebApplicationBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWebCustomDomainRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
        body: CreateWebCustomDomainInput = None,
    ):
        # This parameter is required.
        self.namespace_id = namespace_id
        # This parameter is required.
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('body') is not None:
            temp_model = CreateWebCustomDomainInput()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateWebCustomDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: WebCustomDomainBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = WebCustomDomainBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteApplicationRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DeleteApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # The error code that is returned if the request fails.
        # 
        # *   If the request is successful, this parameter is not returned.****\
        # *   This parameter is returned only if the request failed.**** For more information about the values of this parameter, see the "**Error codes**" section of this topic.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class DeleteApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteApplicationResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the application is deleted. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.code = code
        # The ID of the change order that is used to query the task execution status.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The request is successful.
        # *   **3xx**: A redirection message is returned.
        # *   **4xx**: The request is invalid.
        # *   **5xx**: A server error occurred.
        self.error_code = error_code
        # The trace ID that is used to query details of the request.
        self.message = message
        # The returned message.
        # 
        # *   If the request is successful, **success** is returned.
        # *   If an error occurred, the error code is returned.
        self.request_id = request_id
        self.success = success
        # The returned results.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteApplicationScalingRuleRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        scaling_rule_name: str = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the trace. The ID is used to query the details of a request.
        # 
        # This parameter is required.
        self.scaling_rule_name = scaling_rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        return self


class DeleteApplicationScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.error_code = error_code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteApplicationScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteApplicationScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteApplicationScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteConfigMapRequest(TeaModel):
    def __init__(
        self,
        config_map_id: int = None,
    ):
        # 1
        # 
        # This parameter is required.
        self.config_map_id = config_map_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_id is not None:
            result['ConfigMapId'] = self.config_map_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigMapId') is not None:
            self.config_map_id = m.get('ConfigMapId')
        return self


class DeleteConfigMapResponseBodyData(TeaModel):
    def __init__(
        self,
        config_map_id: int = None,
    ):
        # The ID of the deleted ConfigMap instance.
        self.config_map_id = config_map_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_id is not None:
            result['ConfigMapId'] = self.config_map_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigMapId') is not None:
            self.config_map_id = m.get('ConfigMapId')
        return self


class DeleteConfigMapResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteConfigMapResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the call was successful.
        # *   **3xx**: indicates that the call was redirected.
        # *   **4xx**: indicates that the call failed.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The returned result.
        self.data = data
        # The returned error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.error_code = error_code
        # The returned information. Valid values:
        # 
        # *   If the call is successful, **success** is returned.
        # *   If the call fails, an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the ConfigMap instance was deleted. Valid values:
        # 
        # *   **true**: The instance was deleted.
        # *   **false**: The instance failed to be deleted.
        self.success = success
        # The ID of the trace. The ID is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteConfigMapResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteConfigMapResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteConfigMapResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteConfigMapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGreyTagRouteRequest(TeaModel):
    def __init__(
        self,
        grey_tag_route_id: int = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.grey_tag_route_id = grey_tag_route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grey_tag_route_id is not None:
            result['GreyTagRouteId'] = self.grey_tag_route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GreyTagRouteId') is not None:
            self.grey_tag_route_id = m.get('GreyTagRouteId')
        return self


class DeleteGreyTagRouteResponseBodyData(TeaModel):
    def __init__(
        self,
        grey_tag_route_id: int = None,
    ):
        # The returned error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.grey_tag_route_id = grey_tag_route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grey_tag_route_id is not None:
            result['GreyTagRouteId'] = self.grey_tag_route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GreyTagRouteId') is not None:
            self.grey_tag_route_id = m.get('GreyTagRouteId')
        return self


class DeleteGreyTagRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteGreyTagRouteResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the information of the change order was queried. Valid values:
        # 
        # *   **true**: The information was queried.
        # *   **false**: The information failed to be queried.
        self.code = code
        # The ID of the canary release rule. The ID is globally unique.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.error_code = error_code
        # The trace ID that is used to query the details of the request.
        self.message = message
        # The returned information. Valid values:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.request_id = request_id
        self.success = success
        # The information about the canary release rule.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteGreyTagRouteResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteGreyTagRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGreyTagRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGreyTagRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHistoryJobRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        job_id: str = None,
    ):
        # The ID of the job template to which the job that you want to delete belongs.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The ID of the job.
        # 
        # This parameter is required.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DeleteHistoryJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The returned result.
        self.data = data
        # The error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section in this topic.
        self.error_code = error_code
        # The returned information. Valid values:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the job was deleted. Valid values:
        # 
        # *   **true**: The job was deleted.
        # *   **false**: The job failed to be deleted.
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteHistoryJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHistoryJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHistoryJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteIngressRequest(TeaModel):
    def __init__(
        self,
        ingress_id: int = None,
    ):
        # 87
        # 
        # This parameter is required.
        self.ingress_id = ingress_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ingress_id is not None:
            result['IngressId'] = self.ingress_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IngressId') is not None:
            self.ingress_id = m.get('IngressId')
        return self


class DeleteIngressResponseBodyData(TeaModel):
    def __init__(
        self,
        ingress_id: int = None,
    ):
        # The ID of the routing rule that you want to delete.
        self.ingress_id = ingress_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ingress_id is not None:
            result['IngressId'] = self.ingress_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IngressId') is not None:
            self.ingress_id = m.get('IngressId')
        return self


class DeleteIngressResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteIngressResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request failed.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the routing rule was deleted. Valid values:
        # 
        # *   **true**: indicates that the routing rule was deleted.
        # *   **false**: indicates that the routing rule could not be deleted.
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteIngressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteIngressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteIngressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteIngressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteJobRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The ID of the job template that you want to delete.
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DeleteJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The returned result.
        self.data = data
        # The error code that is returned. Take note of the following rules:
        # 
        # *   The **ErrorCode** parameter is not returned if the request is successful.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.error_code = error_code
        # The additional information that is returned. Valid values:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the application is deleted. Valid values:
        # 
        # *   **true**: The namespaces were obtained.
        # *   **false**: no
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteNamespaceRequest(TeaModel):
    def __init__(
        self,
        name_space_short_id: str = None,
        namespace_id: str = None,
    ):
        self.name_space_short_id = name_space_short_id
        # cn-beijing:test
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DeleteNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the namespace was deleted. Valid values:
        # 
        # *   **true**: indicates that the namespace was deleted.
        # *   **false**: indicates that the namespace could not be deleted.
        self.success = success
        # The ID of the trace. It can be used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecretRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
        secret_id: int = None,
    ):
        # The ID of the namespace in which the Secret resides. By default, the namespace ID is the same as the region ID.
        # 
        # This parameter is required.
        self.namespace_id = namespace_id
        # The ID of the Secret to be deleted. You can call the [ListSecrets](https://help.aliyun.com/document_detail/466929.html) operation to view the Secret IDs.
        # 
        # This parameter is required.
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class DeleteSecretResponseBodyData(TeaModel):
    def __init__(
        self,
        secret_id: int = None,
    ):
        # The ID of the deleted Secret.
        self.secret_id = secret_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.secret_id is not None:
            result['SecretId'] = self.secret_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecretId') is not None:
            self.secret_id = m.get('SecretId')
        return self


class DeleteSecretResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeleteSecretResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The response.
        self.data = data
        # The error code returned. Valid values:
        # 
        # *   The **ErrorCode** parameter is not returned if the request succeeds.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.error_code = error_code
        # The additional information that is returned. Valid values:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the Secret is successfully deleted. Valid values:
        # 
        # *   **true**: The instance was deleted.
        # *   **false**: The instance failed to be deleted.
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeleteSecretResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeleteSecretResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecretResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecretResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWebApplicationRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
    ):
        # This parameter is required.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DeleteWebApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: WebApplicationBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = WebApplicationBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWebApplicationRevisionRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
    ):
        # This parameter is required.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DeleteWebApplicationRevisionResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: WebApplicationRevisionBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = WebApplicationRevisionBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteWebCustomDomainRequest(TeaModel):
    def __init__(
        self,
        namespace_id: str = None,
    ):
        # This parameter is required.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DeleteWebCustomDomainResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: WebCustomDomainBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = WebCustomDomainBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeployApplicationRequest(TeaModel):
    def __init__(
        self,
        acr_assume_role_arn: str = None,
        acr_instance_id: str = None,
        app_id: str = None,
        associate_eip: bool = None,
        auto_enable_application_scaling_rule: bool = None,
        batch_wait_time: int = None,
        change_order_desc: str = None,
        command: str = None,
        command_args: str = None,
        config_map_mount_desc: str = None,
        cpu: int = None,
        custom_host_alias: str = None,
        deploy: str = None,
        edas_container_version: str = None,
        enable_ahas: str = None,
        enable_grey_tag_route: bool = None,
        envs: str = None,
        image_pull_secrets: str = None,
        image_url: str = None,
        jar_start_args: str = None,
        jar_start_options: str = None,
        jdk: str = None,
        kafka_configs: str = None,
        liveness: str = None,
        memory: int = None,
        micro_registration: str = None,
        micro_registration_config: str = None,
        min_ready_instance_ratio: int = None,
        min_ready_instances: int = None,
        mount_desc: str = None,
        mount_host: str = None,
        nas_configs: str = None,
        nas_id: str = None,
        oss_ak_id: str = None,
        oss_ak_secret: str = None,
        oss_mount_descs: str = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
        php: str = None,
        php_arms_config_location: str = None,
        php_config: str = None,
        php_config_location: str = None,
        post_start: str = None,
        pre_stop: str = None,
        pvtz_discovery_svc: str = None,
        python: str = None,
        python_modules: str = None,
        readiness: str = None,
        replicas: int = None,
        security_group_id: str = None,
        service_tags: str = None,
        sls_configs: str = None,
        termination_grace_period_seconds: int = None,
        timezone: str = None,
        tomcat_config: str = None,
        update_strategy: str = None,
        v_switch_id: str = None,
        war_start_options: str = None,
        web_container: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) required for a RAM role to obtain images across accounts. For more information, see [Grant permissions across Alibaba Cloud accounts by using a RAM role](https://help.aliyun.com/document_detail/223585.html).
        self.acr_assume_role_arn = acr_assume_role_arn
        # The ID of Container Registry Enterprise Edition instance N. This parameter is required when the **ImageUrl** parameter is set to the URL of an image in an ACR Enterprise Edition instance.
        self.acr_instance_id = acr_instance_id
        # The ID of the application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # Specifies whether to associate an EIP with the node pool. Take note of the following rules:
        # 
        # *   **true**: The EIP is associated with the application instance.
        # *   **false**: The EIP is not associated with the application instance.
        self.associate_eip = associate_eip
        # Specifies whether to automatically enable an auto scaling policy for the application. Take note of the following rules:
        # 
        # *   **true**: turns on Logon-free Sharing
        # *   **false**: turns off Logon-free Sharing
        self.auto_enable_application_scaling_rule = auto_enable_application_scaling_rule
        # The interval between batches during a batch release. Unit: minutes.
        self.batch_wait_time = batch_wait_time
        # The description of the change order.
        self.change_order_desc = change_order_desc
        # The command that is used to start the image. The command must be an existing executable object in the container. Sample statements:
        # 
        #     command:
        #           - echo
        #           - abc
        #           - >
        #           - file0
        # 
        # In this example, the Command parameter is set to `Command="echo", CommandArgs=["abc", ">", "file0"]`.
        self.command = command
        # The parameters of the image startup command. The CommandArgs parameter specifies the parameters that are required for the **Command** parameter. You can specify the name in one of the following formats:
        # 
        # `["a","b"]`
        # 
        # In the preceding example, the CommandArgs parameter is set to `CommandArgs=["abc", ">", "file0"]`. The data type of `["abc", ">", "file0"]` must be an array of strings in the JSON format. This parameter is optional.
        self.command_args = command_args
        # The description of the **ConfigMap** instance mounted to the application. Use configurations created on the Configuration Items page to configure containers. The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **congfigMapId**: the ID of the ConfigMap instance. You can call the [ListNamespacedConfigMaps](https://help.aliyun.com/document_detail/176917.html) operation to obtain the ID.
        # *   **key**: the key.
        # 
        # > You can use `sae-sys-configmap-all` to mount all keys.
        # 
        # *   **mountPath**: the mount path in the container.
        self.config_map_mount_desc = config_map_mount_desc
        self.cpu = cpu
        # The custom mappings between hostnames and IP addresses in the container. Take note of the following rules:
        # 
        # *   **hostName**: the domain name or hostname.
        # *   **ip**: the IP address.
        self.custom_host_alias = custom_host_alias
        # This parameter takes effect only for applications that are in the Stopped state. If you call the **DeployApplication** operation to manage a running application, the application is immediately redeployed.
        # 
        # *   **true** (default): specifies that the system immediately deploys the application, enables new configurations, and pulls application instances.
        # *   **false**: specifies that the system only enables the new configurations.
        self.deploy = deploy
        # The version of the container, such as Ali-Tomcat, in which an application developed based on High-speed Service Framework (HSF) is deployed.
        self.edas_container_version = edas_container_version
        # Indicates whether access to Application High Availability Service (AHAS) is enabled. Take note of the following rules:
        # 
        # *   **true**: Access to AHAS is enabled.
        # *   **false**: Access to AHAS is disabled.
        self.enable_ahas = enable_ahas
        # Indicates whether canary release rules are enabled. Canary release rules apply only to applications in Spring Cloud and Dubbo frameworks. Take note of the following rules:
        # 
        # *   **true**: The canary release rules are enabled.
        # *   **false**: The canary release rules are disabled.
        self.enable_grey_tag_route = enable_grey_tag_route
        # The environment variables. You can configure custom environment variables or reference a ConfigMap. If you want to reference a ConfigMap, you must first create a ConfigMap. For more information, see [CreateConfigMap](https://help.aliyun.com/document_detail/176914.html). Take note of the following rules:
        # 
        # *   Customize
        # 
        #     *   **name**: the name of the environment variable.
        #     *   **value**: the value of the environment variable.
        # 
        # *   Reference ConfigMap
        # 
        #     *   **name**: the name of the environment variable. You can reference one or all keys. If you want to reference all keys, specify `sae-sys-configmap-all-<ConfigMap name>`. Example: `sae-sys-configmap-all-test1`.
        #     *   **valueFrom**: the reference of the environment variable. Set the value to `configMapRef`.
        #     *   **configMapId**: the ConfigMap ID.
        #     *   **key**: the key. If you want to reference all keys, do not configure this parameter.
        self.envs = envs
        # The ID of the corresponding Secret.
        self.image_pull_secrets = image_pull_secrets
        # The URL of the image. This parameter is returned only if the **PackageType** parameter is set to **Image**.
        self.image_url = image_url
        # The arguments in the JAR package. The arguments are used to start the application container. The default startup command is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_args = jar_start_args
        # The option settings in the JAR package. The settings are used to start the application container. The default startup command for application deployment is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_options = jar_start_options
        # The version of the Java development kit (JDK) on which the deployment package of the application depends. The following versions are supported:
        # 
        # *   **Open JDK 8**\
        # *   **Open JDK 7**\
        # *   **Dragonwell 11**\
        # *   **Dragonwell 8**\
        # *   **openjdk-8u191-jdk-alpine3.9**\
        # *   **openjdk-7u201-jdk-alpine3.9**\
        # 
        # This parameter is not returned if the **PackageType** parameter is set to **Image**.
        self.jdk = jdk
        # The logging configurations of Message Queue for Apache Kafka. Take note of the following rules:
        # 
        # *   **kafkaEndpoint**: the endpoint of the Message Queue for Apache Kafka API.
        # *   **kafkaInstanceId**: the ID of the Message Queue for Apache Kafka instance.
        # *   **kafkaConfigs**: One or more logging configurations of Message Queue for Apache Kafka. For information about sample values and parameters, see the request parameter **KafkaLogfileConfig** in this topic.
        self.kafka_configs = kafka_configs
        # The details of the availability check that was performed on the container. If the container fails this health check multiple times, the system disables and restarts the container. You can use one of the following methods to perform the health check:
        # 
        # *   Example of **exec**: `{"exec":{"command":["sh","-c","cat/home/admin/start.sh"]},"initialDelaySeconds":30,"periodSeconds":30,"timeoutSeconds":2}`
        # *   Sample code of the **httpGet** method: `{"httpGet":{"path":"/","port":18091,"scheme":"HTTP","isContainKeyWord":true,"keyWord":"SAE"},"initialDelaySeconds":11,"periodSeconds":10,"timeoutSeconds":1}`
        # *   Sample code of the **tcpSocket** method: `{"tcpSocket":{"port":18091},"initialDelaySeconds":11,"periodSeconds":10,"timeoutSeconds":1}`
        # 
        # > You can use only one method to perform the health check.
        # 
        # The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **exec.command**: the health check command.
        # *   **httpGet.path**: the request path.
        # *   **httpGet.scheme**: the protocol that is used to perform the health check. Valid values: **HTTP** and **HTTPS**.
        # *   **httpGet.isContainKeyWord**: indicates whether the response contains keywords. Valid values: **true** and **false**. If this field is not returned, the advanced settings are not used.
        # *   **httpGet.keyWord**: the custom keyword. This parameter is available only if the **isContainKeyWord** field is returned.
        # *   **tcpSocket.port**: the port that is used to check the status of TCP connections.
        # *   **initialDelaySeconds**: the delay of the health check. Default value: 10. Unit: seconds.
        # *   **periodSeconds**: the interval at which health checks are performed. Default value: 30. Unit: seconds.
        # *   **timeoutSeconds**: the timeout period of the health check. Default value: 1. Unit: seconds. If you set this parameter to 0 or leave this parameter empty, the timeout period is automatically set to 1 second.
        self.liveness = liveness
        self.memory = memory
        # The Nacos registry. Valid values:
        # 
        # *   **0**: SAE built-in Nacos registry
        # *   **1**: self-managed Nacos registry
        # *   **2** : MSE Nacos registry
        self.micro_registration = micro_registration
        self.micro_registration_config = micro_registration_config
        # The percentage of the minimum number of available instances. Take note of the following rules:
        # 
        # *   If you set the value to **-1**, the minimum number of available instances is not determined based on this parameter. Default value: -1.
        # *   If you set the value to a number **from 0 to 100**, the minimum number of available instances is calculated by using the following formula: Current number of instances × (Value of MinReadyInstanceRatio × 100%). The value is the nearest integer rounded up from the calculated result. For example, if the percentage is set to **50**% and five instances are available, the minimum number of available instances is 3.
        # 
        # > When both **MinReadyInstance** and **MinReadyInstanceRatio** are specified and **MinReadyInstanceRatio** is set to a number from 0 to 100, the value of **MinReadyInstanceRatio**** takes precedence. For example, if **MinReadyInstances** is set to **5, and **MinReadyInstanceRatio** is set to **50**, the minimum number of available instances is set to the nearest integer rounded up from the calculated result of the following formula: Current number of instances × **50%**.
        self.min_ready_instance_ratio = min_ready_instance_ratio
        # The minimum number of available instances. Special values:
        # 
        # *   If you set the value to **0**, business interruptions occur when the application is updated.
        # *   If you set the value to \\*\\*-1\\*\\*, the minimum number of available instances is automatically set to a system-recommended value. The value is the nearest integer to which the calculated result of the following formula is rounded up: Current number of instances × 25%. For example, if five instances are available, the minimum number of available instances is calculated by using the following formula: 5 × 25% = 1.25. In this case, the minimum number of available instances is 2.
        # 
        # > Make sure that at least one instance is available during application deployment and rollback to prevent business interruptions.
        self.min_ready_instances = min_ready_instances
        # The configurations for mounting the NAS file system. After the application is created, you may want to call other operations to manage the application. If you do not want to change the NAS configurations in these subsequent operations, you can omit the **MountDesc** parameter in the requests. If you want to unmount the NAS file system, you must set the **MountDesc** values in the subsequent requests to an empty string ("").
        self.mount_desc = mount_desc
        # The mount target of the NAS file system in the VPC where the application is deployed. If you do not need to modify this configuration during the deployment, configure the **MountHost** parameter only in the first request. You do not need to include this parameter in subsequent requests. If you need to remove this configuration, leave the **MountHost** parameter empty in the request.
        self.mount_host = mount_host
        # The configurations of mounting the NAS file system. Take note of the following rules:
        # 
        # *   **mountPath**: the mount path of the container.
        # *   **readOnly**: If you set the value to **false**, the application has the read and write permissions.
        # *   **nasId**: the ID of the NAS file system.
        # *   **mountDomain**: the domain name of the mount target. For more information, see [DescribeMountTargets](https://help.aliyun.com/document_detail/62626.html).
        # *   **nasPath**: the directory in the NAS file system.
        self.nas_configs = nas_configs
        # The ID of the Apsara File Storage NAS file system. After the application is created, you may want to call other operations to manage the application. If you do not want to change the NAS configurations in these subsequent operations, you can omit the **NasId** parameter in the requests. If you want to unmount the NAS file system, you must set the **NasId** values in the subsequent requests to an empty string ("").
        self.nas_id = nas_id
        # The AccessKey ID that is used to read data from and write data to Object Storage Service (OSS) buckets.
        self.oss_ak_id = oss_ak_id
        # The AccessKey secret that is used to read data from and write data to OSS buckets.
        self.oss_ak_secret = oss_ak_secret
        # Information of the Object Storage Service (OSS) bucket mounted to the application. The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **bucketName**: the name of the OSS bucket.
        # 
        # *   **bucketPath**: the directory or object in OSS. If the specified directory or object does not exist, an error is returned.
        # 
        # *   **mountPath**: the directory of the container in SAE. If the path already exists, the newly specified path overwrites the previous one. If the path does not exist, it is created.
        # 
        # *   **readOnly**: specifies whether to only allow the container path to read data from the OSS directory. Valid values:
        # 
        #     *   **true**: The container path only has read permission on the OSS directory.
        #     *   **false**: The application has read and write permissions.
        self.oss_mount_descs = oss_mount_descs
        self.package_type = package_type
        # The address of the deployment package. This parameter is required when the **PackageType** parameter is set to **FatJar**, **War**, or **PythonZip**.
        self.package_url = package_url
        # The version of the deployment package. This parameter is required when the **PackageType** parameter is set to **FatJar**, **War**, or **PythonZip**.
        self.package_version = package_version
        self.php = php
        # The path on which the PHP configuration file for application monitoring is mounted. Make sure that the PHP server loads the configuration file. SAE automatically generates the corresponding configuration file. No manual operations are required.
        self.php_arms_config_location = php_arms_config_location
        # The details of the PHP configuration file.
        self.php_config = php_config
        # The path on which the PHP configuration file for application startup is mounted. Make sure that the PHP server uses this configuration file during the startup.
        self.php_config_location = php_config_location
        # The script that is run immediately after the container is started. Example: `{"exec":{"command":["sh","-c","echo hello"\\]}}`
        self.post_start = post_start
        # The script that is run before the container is stopped. Example: `{"exec":{"command":["sh","-c","echo hello"\\]}}`
        self.pre_stop = pre_stop
        # The configurations of Kubernetes Service-based service registration and discovery. Take note of the following rules:
        # 
        # *   **serviceName**: the name of the Alibaba Cloud service. Format: `<Custom content>-<Namespace ID>`. `-<Namespace ID>` is automatically specified based on the namespace in which an application resides and cannot be changed. For example, if you select the default namespace in the China (Beijing) region, `-cn-beijing-default` is automatically specified.
        # *   **namespaceId**: the namespace ID.
        # *   **portAndProtocol**: the port number and protocol. Valid values of the port number: 1 to 65535. Valid values of the protocol: **TCP** and **UDP**.
        # *   **enable**: enables the Kubernetes Service-based registration and discovery feature.
        self.pvtz_discovery_svc = pvtz_discovery_svc
        # The Python environment. Set the value to **PYTHON 3.9.15**.
        self.python = python
        # The configurations for installing custom module dependencies. By default, the dependencies defined by the requirements.txt file in the root directory are installed. If the package does not contain this file and you do not configure custom dependencies in the package, specify the dependencies that you want to install in the text box.
        self.python_modules = python_modules
        # The details of the health check that was performed on the container. If the container fails this health check multiple times, the system disables and restarts the container. Containers that fail health checks cannot receive traffic from Server Load Balancer (SLB) instances. You can use the **exec**, **httpGet**, or **tcpSocket** method to perform health checks. For more information, see the description of the **Liveness** parameter.
        # 
        # > You can use only one method to perform the health check.
        self.readiness = readiness
        self.replicas = replicas
        self.security_group_id = security_group_id
        self.service_tags = service_tags
        # The logging configurations of Log Service.
        # 
        # *   To use Log Service resources that are automatically created by SAE, set this parameter to `[{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}]`.
        # *   To use custom Log Service resources, set this parameter to `[{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}]`.
        # 
        # The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **projectName**: the name of the Log Service project.
        # *   **logDir**: the path in which logs are stored.
        # *   **logType**: the log type. **stdout**: the standard output log of the container. You can specify only one stdout value for this parameter. If you leave this parameter empty, file logs are collected.
        # *   **logstoreName**: the name of the Logstore in Log Service.
        # *   **logtailName**: the name of the Logtail configuration in Log Service. If you do not configure this parameter, a new Logtail configuration is created.
        # 
        # If you do not need to modify the logging configurations when you deploy the application, configure the **SlsConfigs** parameter only in the first request. You do not need to include this parameter in subsequent requests. If you no longer need to use Log Service, leave the **SlsConfigs** parameter empty in the request.
        # 
        # > A Log Service project that is automatically created by SAE when you create an application is deleted when the application is deleted. Therefore, when you create an application, you cannot select a Log Service project that is automatically created by SAE for log collection.
        self.sls_configs = sls_configs
        # The timeout period for a graceful shutdown. Default value: 30. Unit: seconds. Valid values: 1 to 300.
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # The time zone. Default value: **Asia/Shanghai**.
        self.timezone = timezone
        # The Tomcat configuration. If you want to cancel this configuration, set this parameter to "" or "{}". The following variables are included in the configuration: Take note of the following rules:
        # 
        # *   **port**: the port number. The port number ranges from 1024 to 65535. Though the admin permissions are configured for the container, the root permissions are required to perform operations on ports whose number is smaller than 1024. Enter a value that ranges from 1025 to 65535 because the container has only the admin permissions. If you do not specify this parameter, the default port number 8080 is used.
        # *   **contextPath**: the path. Default value: /. This value indicates the root directory.
        # *   **maxThreads**: the maximum number of connections in the connection pool. Default value: 400.
        # *   **uriEncoding**: the URI encoding scheme in the Tomcat container. Valid values: UTF-8, ISO-8859-1, GBK, and GB2312.************ If you do not specify this parameter, the default value **ISO-8859-1** is used.
        # *   **useBodyEncoding**: specifies whether to use the encoding scheme specified in the request body for URI query parameters. Default value: true.
        self.tomcat_config = tomcat_config
        # The deployment policy. If the minimum number of available instances is 1, the value of the **UpdateStrategy** parameter is an empty string (""). If the minimum number of available instances is greater than 1, the following strategies can be configured:
        # 
        # *   The application is deployed on an instance. The remaining instances are automatically classified into two release batches whose interval is set to 1. In this case, the parameter is set to `{"type":"GrayBatchUpdate","batchUpdate":{"batch":2,"releaseType":"auto","batchWaitTime":1},"grayUpdate":{"gray":1}}`.
        # *   The application is deployed on an instance. The remaining instances are manually classified into two release batches. In this case, the parameter is set to `{"type":"GrayBatchUpdate","batchUpdate":{"batch":2,"releaseType":"manual"},"grayUpdate":{"gray":1}}`.
        # *   All instances are automatically classified into two release batches. The application is deployed on the instances of the two batches in parallel. In this case, the parameter is set to `{"type":"BatchUpdate","batchUpdate":{"batch":2,"releaseType":"auto","batchWaitTime":0}}`
        # 
        # The following table describes the parameters that are used in the preceding statements.
        # 
        # *   **type**: the type of the release policy. Valid values: **GrayBatchUpdate** and **BatchUpdate**.
        # 
        # *   **batchUpdate**: the phased release policy.
        # 
        #     *   **batch**: the number of release batches.
        #     *   **releaseType**: the processing method for the batches. Valid values: **auto** and **manual**.
        #     *   **batchWaitTime**: the interval between release batches. Unit: seconds.
        # 
        # *   **grayUpdate**: the number of release batches in the phased release after a canary release. This parameter is returned only if the **type** parameter is set to **GrayBatchUpdate**.
        self.update_strategy = update_strategy
        self.v_switch_id = v_switch_id
        # The startup command of the WAR package. For information about how to configure the startup command, see [Configure startup commands](https://help.aliyun.com/document_detail/96677.html).
        self.war_start_options = war_start_options
        # The version of the Tomcat container on which the deployment package depends. Valid values:
        # 
        # *   **apache-tomcat-7.0.91**\
        # *   **apache-tomcat-8.5.42**\
        # 
        # This parameter is not returned if the **PackageType** parameter is set to **Image**.
        self.web_container = web_container

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acr_assume_role_arn is not None:
            result['AcrAssumeRoleArn'] = self.acr_assume_role_arn
        if self.acr_instance_id is not None:
            result['AcrInstanceId'] = self.acr_instance_id
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.associate_eip is not None:
            result['AssociateEip'] = self.associate_eip
        if self.auto_enable_application_scaling_rule is not None:
            result['AutoEnableApplicationScalingRule'] = self.auto_enable_application_scaling_rule
        if self.batch_wait_time is not None:
            result['BatchWaitTime'] = self.batch_wait_time
        if self.change_order_desc is not None:
            result['ChangeOrderDesc'] = self.change_order_desc
        if self.command is not None:
            result['Command'] = self.command
        if self.command_args is not None:
            result['CommandArgs'] = self.command_args
        if self.config_map_mount_desc is not None:
            result['ConfigMapMountDesc'] = self.config_map_mount_desc
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.custom_host_alias is not None:
            result['CustomHostAlias'] = self.custom_host_alias
        if self.deploy is not None:
            result['Deploy'] = self.deploy
        if self.edas_container_version is not None:
            result['EdasContainerVersion'] = self.edas_container_version
        if self.enable_ahas is not None:
            result['EnableAhas'] = self.enable_ahas
        if self.enable_grey_tag_route is not None:
            result['EnableGreyTagRoute'] = self.enable_grey_tag_route
        if self.envs is not None:
            result['Envs'] = self.envs
        if self.image_pull_secrets is not None:
            result['ImagePullSecrets'] = self.image_pull_secrets
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.jar_start_args is not None:
            result['JarStartArgs'] = self.jar_start_args
        if self.jar_start_options is not None:
            result['JarStartOptions'] = self.jar_start_options
        if self.jdk is not None:
            result['Jdk'] = self.jdk
        if self.kafka_configs is not None:
            result['KafkaConfigs'] = self.kafka_configs
        if self.liveness is not None:
            result['Liveness'] = self.liveness
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.micro_registration is not None:
            result['MicroRegistration'] = self.micro_registration
        if self.micro_registration_config is not None:
            result['MicroRegistrationConfig'] = self.micro_registration_config
        if self.min_ready_instance_ratio is not None:
            result['MinReadyInstanceRatio'] = self.min_ready_instance_ratio
        if self.min_ready_instances is not None:
            result['MinReadyInstances'] = self.min_ready_instances
        if self.mount_desc is not None:
            result['MountDesc'] = self.mount_desc
        if self.mount_host is not None:
            result['MountHost'] = self.mount_host
        if self.nas_configs is not None:
            result['NasConfigs'] = self.nas_configs
        if self.nas_id is not None:
            result['NasId'] = self.nas_id
        if self.oss_ak_id is not None:
            result['OssAkId'] = self.oss_ak_id
        if self.oss_ak_secret is not None:
            result['OssAkSecret'] = self.oss_ak_secret
        if self.oss_mount_descs is not None:
            result['OssMountDescs'] = self.oss_mount_descs
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        if self.php is not None:
            result['Php'] = self.php
        if self.php_arms_config_location is not None:
            result['PhpArmsConfigLocation'] = self.php_arms_config_location
        if self.php_config is not None:
            result['PhpConfig'] = self.php_config
        if self.php_config_location is not None:
            result['PhpConfigLocation'] = self.php_config_location
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.pvtz_discovery_svc is not None:
            result['PvtzDiscoverySvc'] = self.pvtz_discovery_svc
        if self.python is not None:
            result['Python'] = self.python
        if self.python_modules is not None:
            result['PythonModules'] = self.python_modules
        if self.readiness is not None:
            result['Readiness'] = self.readiness
        if self.replicas is not None:
            result['Replicas'] = self.replicas
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.service_tags is not None:
            result['ServiceTags'] = self.service_tags
        if self.sls_configs is not None:
            result['SlsConfigs'] = self.sls_configs
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        if self.timezone is not None:
            result['Timezone'] = self.timezone
        if self.tomcat_config is not None:
            result['TomcatConfig'] = self.tomcat_config
        if self.update_strategy is not None:
            result['UpdateStrategy'] = self.update_strategy
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.war_start_options is not None:
            result['WarStartOptions'] = self.war_start_options
        if self.web_container is not None:
            result['WebContainer'] = self.web_container
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcrAssumeRoleArn') is not None:
            self.acr_assume_role_arn = m.get('AcrAssumeRoleArn')
        if m.get('AcrInstanceId') is not None:
            self.acr_instance_id = m.get('AcrInstanceId')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AssociateEip') is not None:
            self.associate_eip = m.get('AssociateEip')
        if m.get('AutoEnableApplicationScalingRule') is not None:
            self.auto_enable_application_scaling_rule = m.get('AutoEnableApplicationScalingRule')
        if m.get('BatchWaitTime') is not None:
            self.batch_wait_time = m.get('BatchWaitTime')
        if m.get('ChangeOrderDesc') is not None:
            self.change_order_desc = m.get('ChangeOrderDesc')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CommandArgs') is not None:
            self.command_args = m.get('CommandArgs')
        if m.get('ConfigMapMountDesc') is not None:
            self.config_map_mount_desc = m.get('ConfigMapMountDesc')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CustomHostAlias') is not None:
            self.custom_host_alias = m.get('CustomHostAlias')
        if m.get('Deploy') is not None:
            self.deploy = m.get('Deploy')
        if m.get('EdasContainerVersion') is not None:
            self.edas_container_version = m.get('EdasContainerVersion')
        if m.get('EnableAhas') is not None:
            self.enable_ahas = m.get('EnableAhas')
        if m.get('EnableGreyTagRoute') is not None:
            self.enable_grey_tag_route = m.get('EnableGreyTagRoute')
        if m.get('Envs') is not None:
            self.envs = m.get('Envs')
        if m.get('ImagePullSecrets') is not None:
            self.image_pull_secrets = m.get('ImagePullSecrets')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('JarStartArgs') is not None:
            self.jar_start_args = m.get('JarStartArgs')
        if m.get('JarStartOptions') is not None:
            self.jar_start_options = m.get('JarStartOptions')
        if m.get('Jdk') is not None:
            self.jdk = m.get('Jdk')
        if m.get('KafkaConfigs') is not None:
            self.kafka_configs = m.get('KafkaConfigs')
        if m.get('Liveness') is not None:
            self.liveness = m.get('Liveness')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MicroRegistration') is not None:
            self.micro_registration = m.get('MicroRegistration')
        if m.get('MicroRegistrationConfig') is not None:
            self.micro_registration_config = m.get('MicroRegistrationConfig')
        if m.get('MinReadyInstanceRatio') is not None:
            self.min_ready_instance_ratio = m.get('MinReadyInstanceRatio')
        if m.get('MinReadyInstances') is not None:
            self.min_ready_instances = m.get('MinReadyInstances')
        if m.get('MountDesc') is not None:
            self.mount_desc = m.get('MountDesc')
        if m.get('MountHost') is not None:
            self.mount_host = m.get('MountHost')
        if m.get('NasConfigs') is not None:
            self.nas_configs = m.get('NasConfigs')
        if m.get('NasId') is not None:
            self.nas_id = m.get('NasId')
        if m.get('OssAkId') is not None:
            self.oss_ak_id = m.get('OssAkId')
        if m.get('OssAkSecret') is not None:
            self.oss_ak_secret = m.get('OssAkSecret')
        if m.get('OssMountDescs') is not None:
            self.oss_mount_descs = m.get('OssMountDescs')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        if m.get('Php') is not None:
            self.php = m.get('Php')
        if m.get('PhpArmsConfigLocation') is not None:
            self.php_arms_config_location = m.get('PhpArmsConfigLocation')
        if m.get('PhpConfig') is not None:
            self.php_config = m.get('PhpConfig')
        if m.get('PhpConfigLocation') is not None:
            self.php_config_location = m.get('PhpConfigLocation')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('PvtzDiscoverySvc') is not None:
            self.pvtz_discovery_svc = m.get('PvtzDiscoverySvc')
        if m.get('Python') is not None:
            self.python = m.get('Python')
        if m.get('PythonModules') is not None:
            self.python_modules = m.get('PythonModules')
        if m.get('Readiness') is not None:
            self.readiness = m.get('Readiness')
        if m.get('Replicas') is not None:
            self.replicas = m.get('Replicas')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('ServiceTags') is not None:
            self.service_tags = m.get('ServiceTags')
        if m.get('SlsConfigs') is not None:
            self.sls_configs = m.get('SlsConfigs')
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        if m.get('Timezone') is not None:
            self.timezone = m.get('Timezone')
        if m.get('TomcatConfig') is not None:
            self.tomcat_config = m.get('TomcatConfig')
        if m.get('UpdateStrategy') is not None:
            self.update_strategy = m.get('UpdateStrategy')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('WarStartOptions') is not None:
            self.war_start_options = m.get('WarStartOptions')
        if m.get('WebContainer') is not None:
            self.web_container = m.get('WebContainer')
        return self


class DeployApplicationResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        change_order_id: str = None,
        is_need_approval: bool = None,
    ):
        # The application ID.
        self.app_id = app_id
        # The ID of the change order. It can be used to query the task status.
        self.change_order_id = change_order_id
        # Specifies whether approval is required when a RAM user performs release. Take note of the following rules:
        # 
        # *   **true**\
        # *   **false**\
        self.is_need_approval = is_need_approval

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        if self.is_need_approval is not None:
            result['IsNeedApproval'] = self.is_need_approval
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        if m.get('IsNeedApproval') is not None:
            self.is_need_approval = m.get('IsNeedApproval')
        return self


class DeployApplicationResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DeployApplicationResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Take note of the following rules:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The response.
        self.data = data
        # The error code returned if the request failed. Take note of the following rules:
        # 
        # *   The **ErrorCode** parameter is not returned if the request succeeds.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.error_code = error_code
        # The additional information that is returned. Take note of the following rules:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the application deployment is successful. Take note of the following rules:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DeployApplicationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DeployApplicationResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeployApplicationResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeployApplicationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAppServiceDetailRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        nacos_instance_id: str = None,
        nacos_namespace_id: str = None,
        service_group: str = None,
        service_name: str = None,
        service_type: str = None,
        service_version: str = None,
    ):
        # 6dcc8c9e-d3da-478a-a066-86dcf820\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id
        self.nacos_instance_id = nacos_instance_id
        self.nacos_namespace_id = nacos_namespace_id
        # springCloud
        self.service_group = service_group
        # edas.service.provider
        self.service_name = service_name
        # springCloud
        self.service_type = service_type
        # 1.0.0
        self.service_version = service_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.nacos_instance_id is not None:
            result['NacosInstanceId'] = self.nacos_instance_id
        if self.nacos_namespace_id is not None:
            result['NacosNamespaceId'] = self.nacos_namespace_id
        if self.service_group is not None:
            result['ServiceGroup'] = self.service_group
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        if self.service_version is not None:
            result['ServiceVersion'] = self.service_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('NacosInstanceId') is not None:
            self.nacos_instance_id = m.get('NacosInstanceId')
        if m.get('NacosNamespaceId') is not None:
            self.nacos_namespace_id = m.get('NacosNamespaceId')
        if m.get('ServiceGroup') is not None:
            self.service_group = m.get('ServiceGroup')
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        if m.get('ServiceVersion') is not None:
            self.service_version = m.get('ServiceVersion')
        return self


class DescribeAppServiceDetailResponseBodyDataMethodsParameterDefinitions(TeaModel):
    def __init__(
        self,
        description: str = None,
        name: str = None,
        type: str = None,
    ):
        # The description of the parameter.
        self.description = description
        # The name of the parameter.
        self.name = name
        # The type of the parameter.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAppServiceDetailResponseBodyDataMethods(TeaModel):
    def __init__(
        self,
        method_controller: str = None,
        name: str = None,
        name_detail: str = None,
        parameter_definitions: List[DescribeAppServiceDetailResponseBodyDataMethodsParameterDefinitions] = None,
        parameter_details: List[str] = None,
        parameter_types: List[str] = None,
        paths: List[str] = None,
        request_methods: List[str] = None,
        return_details: str = None,
        return_type: str = None,
    ):
        # The class to which the method belongs.
        self.method_controller = method_controller
        # The name of the method.
        self.name = name
        # The details of the method.
        self.name_detail = name_detail
        # The definition of the parameter.
        self.parameter_definitions = parameter_definitions
        # The details of the parameters.
        self.parameter_details = parameter_details
        # The types of the parameters.
        self.parameter_types = parameter_types
        # The request paths. Format:
        # 
        # `/path`
        self.paths = paths
        # The request methods. Valid values:
        # 
        # *   **GET**\
        # *   **ALL**\
        self.request_methods = request_methods
        # The details of the response.
        self.return_details = return_details
        # The data format of the response.
        self.return_type = return_type

    def validate(self):
        if self.parameter_definitions:
            for k in self.parameter_definitions:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.method_controller is not None:
            result['MethodController'] = self.method_controller
        if self.name is not None:
            result['Name'] = self.name
        if self.name_detail is not None:
            result['NameDetail'] = self.name_detail
        result['ParameterDefinitions'] = []
        if self.parameter_definitions is not None:
            for k in self.parameter_definitions:
                result['ParameterDefinitions'].append(k.to_map() if k else None)
        if self.parameter_details is not None:
            result['ParameterDetails'] = self.parameter_details
        if self.parameter_types is not None:
            result['ParameterTypes'] = self.parameter_types
        if self.paths is not None:
            result['Paths'] = self.paths
        if self.request_methods is not None:
            result['RequestMethods'] = self.request_methods
        if self.return_details is not None:
            result['ReturnDetails'] = self.return_details
        if self.return_type is not None:
            result['ReturnType'] = self.return_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MethodController') is not None:
            self.method_controller = m.get('MethodController')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NameDetail') is not None:
            self.name_detail = m.get('NameDetail')
        self.parameter_definitions = []
        if m.get('ParameterDefinitions') is not None:
            for k in m.get('ParameterDefinitions'):
                temp_model = DescribeAppServiceDetailResponseBodyDataMethodsParameterDefinitions()
                self.parameter_definitions.append(temp_model.from_map(k))
        if m.get('ParameterDetails') is not None:
            self.parameter_details = m.get('ParameterDetails')
        if m.get('ParameterTypes') is not None:
            self.parameter_types = m.get('ParameterTypes')
        if m.get('Paths') is not None:
            self.paths = m.get('Paths')
        if m.get('RequestMethods') is not None:
            self.request_methods = m.get('RequestMethods')
        if m.get('ReturnDetails') is not None:
            self.return_details = m.get('ReturnDetails')
        if m.get('ReturnType') is not None:
            self.return_type = m.get('ReturnType')
        return self


class DescribeAppServiceDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        dubbo_application_name: str = None,
        edas_app_name: str = None,
        group: str = None,
        metadata: Dict[str, Any] = None,
        methods: List[DescribeAppServiceDetailResponseBodyDataMethods] = None,
        service_name: str = None,
        service_ports: List[int] = None,
        service_protocol: str = None,
        service_tags: List[str] = None,
        service_type: str = None,
        spring_application_name: str = None,
        version: str = None,
    ):
        # The name of the Dubbo application.
        self.dubbo_application_name = dubbo_application_name
        # The name of the application.
        self.edas_app_name = edas_app_name
        # The group to which the service belongs. You can create a custom group.
        self.group = group
        # The metadata. Example: `{side: "provider", port: "18081", preserved: {register: {source: "SPRING_CLOUD"}},…}`.
        self.metadata = metadata
        # The methods.
        self.methods = methods
        # The name of the service.
        self.service_name = service_name
        self.service_ports = service_ports
        self.service_protocol = service_protocol
        self.service_tags = service_tags
        # The type of the service. Valid values:
        # 
        # *   **dubbo**\
        # *   **springCloud**\
        self.service_type = service_type
        # The name of the Spring Cloud application.
        self.spring_application_name = spring_application_name
        # The version of the service. You can create a custom version.
        self.version = version

    def validate(self):
        if self.methods:
            for k in self.methods:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dubbo_application_name is not None:
            result['DubboApplicationName'] = self.dubbo_application_name
        if self.edas_app_name is not None:
            result['EdasAppName'] = self.edas_app_name
        if self.group is not None:
            result['Group'] = self.group
        if self.metadata is not None:
            result['Metadata'] = self.metadata
        result['Methods'] = []
        if self.methods is not None:
            for k in self.methods:
                result['Methods'].append(k.to_map() if k else None)
        if self.service_name is not None:
            result['ServiceName'] = self.service_name
        if self.service_ports is not None:
            result['ServicePorts'] = self.service_ports
        if self.service_protocol is not None:
            result['ServiceProtocol'] = self.service_protocol
        if self.service_tags is not None:
            result['ServiceTags'] = self.service_tags
        if self.service_type is not None:
            result['ServiceType'] = self.service_type
        if self.spring_application_name is not None:
            result['SpringApplicationName'] = self.spring_application_name
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DubboApplicationName') is not None:
            self.dubbo_application_name = m.get('DubboApplicationName')
        if m.get('EdasAppName') is not None:
            self.edas_app_name = m.get('EdasAppName')
        if m.get('Group') is not None:
            self.group = m.get('Group')
        if m.get('Metadata') is not None:
            self.metadata = m.get('Metadata')
        self.methods = []
        if m.get('Methods') is not None:
            for k in m.get('Methods'):
                temp_model = DescribeAppServiceDetailResponseBodyDataMethods()
                self.methods.append(temp_model.from_map(k))
        if m.get('ServiceName') is not None:
            self.service_name = m.get('ServiceName')
        if m.get('ServicePorts') is not None:
            self.service_ports = m.get('ServicePorts')
        if m.get('ServiceProtocol') is not None:
            self.service_protocol = m.get('ServiceProtocol')
        if m.get('ServiceTags') is not None:
            self.service_tags = m.get('ServiceTags')
        if m.get('ServiceType') is not None:
            self.service_type = m.get('ServiceType')
        if m.get('SpringApplicationName') is not None:
            self.spring_application_name = m.get('SpringApplicationName')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeAppServiceDetailResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeAppServiceDetailResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # - **2xx**: indicates that the call was successful.
        # - **3xx**: indicates that the call was redirected.
        # - **4xx**: indicates that the call failed.
        # - **5xx**: indicates that a server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The returned error code. Valid values:
        # 
        # - If the call is successful, the **ErrorCode** parameter is not returned.
        # - If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.error_code = error_code
        # The returned information.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the meta data was obtained. Valid values:
        # 
        # *   **true**: The metadata was obtained.
        # *   **false**: The metadata failed to be obtained.
        self.success = success
        # The ID of the trace. The ID is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeAppServiceDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeAppServiceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAppServiceDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAppServiceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationConfigRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        version_id: str = None,
    ):
        # 7171a6ca-d1cd-4928-8642-7d5cfe69\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id
        # 0026ff7f-2b57-4127-bdd0-9bf202bb\\*\\*\\*\\*\
        self.version_id = version_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.version_id is not None:
            result['VersionId'] = self.version_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('VersionId') is not None:
            self.version_id = m.get('VersionId')
        return self


class DescribeApplicationConfigResponseBodyDataConfigMapMountDesc(TeaModel):
    def __init__(
        self,
        config_map_id: int = None,
        config_map_name: str = None,
        key: str = None,
        mount_path: str = None,
    ):
        # The ID of the ConfigMap.
        self.config_map_id = config_map_id
        # The name of the ConfigMap.
        self.config_map_name = config_map_name
        # The key-value pair that is stored in the ConfigMap.
        self.key = key
        # The path on which the ConfigMap is mounted.
        self.mount_path = mount_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_id is not None:
            result['ConfigMapId'] = self.config_map_id
        if self.config_map_name is not None:
            result['ConfigMapName'] = self.config_map_name
        if self.key is not None:
            result['Key'] = self.key
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigMapId') is not None:
            self.config_map_id = m.get('ConfigMapId')
        if m.get('ConfigMapName') is not None:
            self.config_map_name = m.get('ConfigMapName')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        return self


class DescribeApplicationConfigResponseBodyDataMountDesc(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        nas_path: str = None,
    ):
        # The path on which the NAS file system is mounted.
        self.mount_path = mount_path
        # The directory in the NAS file system.
        self.nas_path = nas_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.nas_path is not None:
            result['NasPath'] = self.nas_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('NasPath') is not None:
            self.nas_path = m.get('NasPath')
        return self


class DescribeApplicationConfigResponseBodyDataOssMountDescs(TeaModel):
    def __init__(
        self,
        bucket_name: str = None,
        bucket_path: str = None,
        mount_path: str = None,
        read_only: bool = None,
    ):
        # The name of the OSS bucket.
        self.bucket_name = bucket_name
        # The directory or object in OSS. If the specified directory or object does not exist, an error is returned.
        self.bucket_path = bucket_path
        # The path of the container in SAE. The parameter value that you specified overwrites the original value. If the specified path does not exist, SAE automatically creates the path.
        self.mount_path = mount_path
        # Indicates whether the application can use the container path to read data from or write data to resources in the directory of the OSS bucket. Valid values:
        # 
        # *   **true**: The application has the read-only permissions.
        # *   **false**: The application has the read and write permissions.
        self.read_only = read_only

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['bucketName'] = self.bucket_name
        if self.bucket_path is not None:
            result['bucketPath'] = self.bucket_path
        if self.mount_path is not None:
            result['mountPath'] = self.mount_path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bucketName') is not None:
            self.bucket_name = m.get('bucketName')
        if m.get('bucketPath') is not None:
            self.bucket_path = m.get('bucketPath')
        if m.get('mountPath') is not None:
            self.mount_path = m.get('mountPath')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class DescribeApplicationConfigResponseBodyDataTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The key of the tag.
        self.key = key
        # The value of the tag.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeApplicationConfigResponseBodyData(TeaModel):
    def __init__(
        self,
        acr_assume_role_arn: str = None,
        acr_instance_id: str = None,
        app_description: str = None,
        app_id: str = None,
        app_name: str = None,
        app_source: str = None,
        associate_eip: bool = None,
        batch_wait_time: int = None,
        command: str = None,
        command_args: str = None,
        config_map_mount_desc: List[DescribeApplicationConfigResponseBodyDataConfigMapMountDesc] = None,
        cpu: int = None,
        custom_host_alias: str = None,
        edas_container_version: str = None,
        enable_ahas: str = None,
        enable_grey_tag_route: bool = None,
        envs: str = None,
        image_pull_secrets: str = None,
        image_url: str = None,
        jar_start_args: str = None,
        jar_start_options: str = None,
        jdk: str = None,
        kafka_configs: str = None,
        liveness: str = None,
        memory: int = None,
        micro_registration: str = None,
        min_ready_instance_ratio: int = None,
        min_ready_instances: int = None,
        mount_desc: List[DescribeApplicationConfigResponseBodyDataMountDesc] = None,
        mount_host: str = None,
        mse_application_id: str = None,
        mse_application_name: str = None,
        namespace_id: str = None,
        nas_configs: str = None,
        nas_id: str = None,
        oss_ak_id: str = None,
        oss_ak_secret: str = None,
        oss_mount_descs: List[DescribeApplicationConfigResponseBodyDataOssMountDescs] = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
        php: str = None,
        php_arms_config_location: str = None,
        php_config: str = None,
        php_config_location: str = None,
        post_start: str = None,
        pre_stop: str = None,
        programming_language: str = None,
        pvtz_discovery: str = None,
        python: str = None,
        python_modules: str = None,
        readiness: str = None,
        region_id: str = None,
        replicas: int = None,
        security_group_id: str = None,
        service_tags: Dict[str, str] = None,
        sls_configs: str = None,
        tags: List[DescribeApplicationConfigResponseBodyDataTags] = None,
        termination_grace_period_seconds: int = None,
        timezone: str = None,
        tomcat_config: str = None,
        update_strategy: str = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        war_start_options: str = None,
        web_container: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the RAM role that is used to pull images across accounts. For more information, see [Pull images across Alibaba Cloud accounts](https://help.aliyun.com/document_detail/190675.html) and [Grant permissions across Alibaba Cloud accounts by using a RAM role](https://help.aliyun.com/document_detail/223585.html).
        self.acr_assume_role_arn = acr_assume_role_arn
        # The ID of the Container Registry Enterprise Edition instance.
        self.acr_instance_id = acr_instance_id
        # The description of the application.
        self.app_description = app_description
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The SAE application type.
        self.app_source = app_source
        # Indicates whether an elastic IP address (EIP) is associated with the application instance. Valid values:
        # 
        # *   **true**: The EIP is associated with the application instance.
        # *   **false**: The EIP is not associated with the application instance.
        self.associate_eip = associate_eip
        # The interval between batches in a phased release. Unit: seconds.
        self.batch_wait_time = batch_wait_time
        # The command that is used to start the image. The command must be an existing executable object in the container. Example:
        # 
        # ```
        # 
        # command:
        #       - echo
        #       - abc
        #       - >
        #       - file0
        # ```
        # 
        # In this example, the Command parameter is set to `Command="echo", CommandArgs=["abc", ">", "file0"]`.
        self.command = command
        # The parameters of the image startup command. The CommandArgs parameter contains the parameters that are required for the **Command** parameter. Format:
        # 
        # `["a","b"]`
        # 
        # In the preceding **Command** example, the CommandArgs parameter is set to `CommandArgs=["abc", ">", "file0"]`. The data type of `["abc", ">", "file0"]` must be an array of strings in the JSON format. You do not need to configure this parameter if it does not exist in the Command parameter.
        self.command_args = command_args
        # The details of the ConfigMap.
        self.config_map_mount_desc = config_map_mount_desc
        # The CPU specifications that are required for each instance. Unit: millicores. You cannot set this parameter to 0. Valid values:
        # 
        # *   **500**\
        # *   **1000**\
        # *   **2000**\
        # *   **4000**\
        # *   **8000**\
        # *   **16000**\
        # *   **32000**\
        self.cpu = cpu
        # The custom mappings between hostnames and IP addresses in the container. Valid values:
        # 
        # *   **hostName**: the domain name or hostname.
        # *   **ip**: the IP address.
        self.custom_host_alias = custom_host_alias
        # The version of the container, such as Ali-Tomcat, in which an application developed based on High-speed Service Framework (HSF) is deployed.
        self.edas_container_version = edas_container_version
        # Indicates whether access to Application High Availability Service (AHAS) is enabled. Valid values:
        # 
        # *   **true**: Access to AHAS is enabled.
        # *   **false**: Access to AHAS is disabled.
        self.enable_ahas = enable_ahas
        # Indicates whether canary release rules are enabled. Canary release rules apply only to applications in Spring Cloud and Dubbo frameworks. Valid values:
        # 
        # *   **true**: The canary release rules are enabled.
        # *   **false**: The canary release rules are disabled.
        self.enable_grey_tag_route = enable_grey_tag_route
        # The environment variables. Variable description:
        # 
        # *   **name**: the name of the environment variable.
        # *   **value**: the value or reference of the environment variable.
        self.envs = envs
        self.image_pull_secrets = image_pull_secrets
        # The URL of the image. This parameter is returned only if the **PackageType** parameter is set to **Image**.
        self.image_url = image_url
        # The arguments in the JAR package. The arguments are used to start the application container. The default startup command is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_args = jar_start_args
        # The option settings in the JAR package. The settings are used to start the application container. The default startup command is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_options = jar_start_options
        # The version of the Java development kit (JDK) on which the deployment package of the application depends. The following versions are supported:
        # 
        # *   **Open JDK 8**\
        # *   **Open JDK 7**\
        # *   **Dragonwell 11**\
        # *   **Dragonwell 8**\
        # *   **openjdk-8u191-jdk-alpine3.9**\
        # *   **openjdk-7u201-jdk-alpine3.9**\
        # 
        # This parameter is not returned if the **PackageType** parameter is set to **Image**.
        self.jdk = jdk
        # The logging configurations of Message Queue for Apache Kafka. The following parameters are involved:
        # 
        # *   **KafkaConfigs**: the configurations of Message Queue for Apache Kafka.
        # 
        # *   **createTime**: the time when the Message Queue for Apache Kafka instance was created.
        # 
        # *   **kafkaTopic**: the message topic that is used to classify messages.
        # 
        # *   **logDir**: the path in which logs are stored.
        # 
        # *   **logType**: the type of collected logs. Valid values:
        # 
        #     *   **file_log**: the file log that is stored in the container. The path of the file logs in the container is returned.
        #     *   **stdout**: the standard output log of the container. You can specify only one stdout value.
        # 
        # *   **kafkaEndpoint**: the endpoint of the Message Queue for Apache Kafka service.
        # 
        # *   **kafkaInstanceId**: the ID of the Message Queue for Apache Kafka instance.
        # 
        # *   **region**: the region where the Message Queue for Apache Kafka instance resides.
        self.kafka_configs = kafka_configs
        # The details of the availability check that was performed on the container. If the container fails this health check multiple times, the system disables and restarts the container. You can use one of the following methods to perform the health check:
        # 
        # *   Sample code of the **exec** method: `{"exec":{"command":["sh","-c","cat/home/admin/start.sh"]},"initialDelaySeconds":30,"periodSeconds":30,"timeoutSeconds":2}`
        # *   Sample code of the **httpGet** method: `{"httpGet":{"path":"/","port":18091,"scheme":"HTTP","isContainKeyWord":true,"keyWord":"SAE"},"initialDelaySeconds":11,"periodSeconds":10,"timeoutSeconds":1}`
        # *   Sample code of the **tcpSocket** method: `{"tcpSocket":{"port":18091},"initialDelaySeconds":11,"periodSeconds":10,"timeoutSeconds":1}`
        # 
        # >  You can use only one method to perform the health check.
        # 
        # The following parameters are involved:
        # 
        # *   **exec.command**: the health check command.
        # *   **httpGet.path**: the request path.
        # *   **httpGet.scheme**: the protocol that is used to perform the health check. Valid values: **HTTP** and **HTTPS**.
        # *   **httpGet.isContainKeyWord**: indicates whether the response contains keywords. Valid values: **true** and **false**. If this field is not returned, the advanced settings are not used.
        # *   **httpGet.keyWord**: the custom keyword. This parameter is available only if the **isContainKeyWord** field is returned.
        # *   **tcpSocket.port**: the port that is used to check the status of TCP connections.
        # *   **initialDelaySeconds**: the delay of the health check. Default value: 10. Unit: seconds.
        # *   **periodSeconds**: the interval at which health checks are performed. Default value: 30. Unit: seconds.
        # *   **timeoutSeconds**: the timeout period of the health check. Default value: 1. Unit: seconds. If you set this parameter to 0 or leave this parameter empty, the timeout period is automatically set to 1 second.
        self.liveness = liveness
        # The size of memory required by each instance. Unit: MB. You cannot set this parameter to 0. The values of this parameter correspond to the values of the Cpu parameter:
        # 
        # *   This parameter is set to **1024** if the Cpu parameter is set to 500 or 1000.
        # *   This parameter is set to **2048** if the Cpu parameter is set to 500, 1000, or 1000.
        # *   This parameter is set to **4096** if the Cpu parameter is set to 1000, 2000, or 4000.
        # *   This parameter is set to **8192** if the Cpu parameter is set to 2000, 4000, or 8000.
        # *   This parameter is set to **12288** if the Cpu parameter is set to 12000.
        # *   This parameter is set to **16384** if the Cpu parameter is set to 4000, 8000, or 16000.
        # *   This parameter is set to **24567** if the Cpu parameter is set to 12000.
        # *   This parameter is set to **32768** if the Cpu parameter is set to 16000.
        # *   This parameter is set to **65536** if the Cpu parameter is set to 8000, 16000, or 32000.
        # *   This parameter is set to **131072** if the Cpu parameter is set to 32000.
        self.memory = memory
        self.micro_registration = micro_registration
        # The percentage of the minimum number of available instances. Valid values:
        # 
        # *   **-1**: the default value. This value indicates that the minimum number of available instances is not measured by percentage. If you do not configure this parameter, the default value **-1** is used.
        # *   **0 to 100**: indicates that the minimum number of available instances is calculated by using the following formula: Current number of instances × (Value of MinReadyInstanceRatio × 100%). If the calculated result is not an integer, the result is rounded up to the nearest integer. For example, if the percentage is set to **50**% and five instances are available, the minimum number of available instances is 3.
        # 
        # >  If the **MinReadyInstance** and **MinReadyInstanceRatio** parameters are returned and the value of the **MinReadyInstanceRatio** parameter is not **-1**, the value of the **MinReadyInstanceRatio** parameter takes effect. If the **MinReadyInstances** parameter is set to **5** and the **MinReadyInstanceRatio** parameter is set to **50**, the value of the **MinReadyInstanceRatio** parameter determines the minimum number of available instances.
        self.min_ready_instance_ratio = min_ready_instance_ratio
        # The minimum number of available instances. Valid values:
        # 
        # *   If you set the value to **0**, business interruptions occur when the application is updated.
        # *   If you set the value to **-1**, the minimum number of available instances is automatically set to a system-recommended value. The value is the nearest integer to which the calculated result of the following formula is rounded up: Current number of instances × 25%. For example, if five instances are available, the minimum number of available instances is calculated by using the following formula: 5 × 25% = 1.25. In this case, the minimum number of available instances is 2.
        # 
        # >  Make sure that at least one instance is available during application deployment and rollback to prevent business interruptions.
        self.min_ready_instances = min_ready_instances
        # The details of the mounted NAS file system.
        self.mount_desc = mount_desc
        # The mount target of the NAS file system in the VPC where the application is deployed. If you do not need to modify this configuration during the deployment, configure the **MountHost** parameter only in the first request. You do not need to include this parameter in subsequent requests. If you need to remove this configuration, leave the **MountHost** parameter empty in the request.
        self.mount_host = mount_host
        # The ID of the microservice application.
        self.mse_application_id = mse_application_id
        self.mse_application_name = mse_application_name
        # The ID of the namespace.
        self.namespace_id = namespace_id
        self.nas_configs = nas_configs
        # The ID of the NAS file system.
        self.nas_id = nas_id
        # The AccessKey ID that is used to read data from and write data to Object Storage Service (OSS) buckets.
        self.oss_ak_id = oss_ak_id
        # The AccessKey secret that is used to read data from and write data to OSS buckets.
        self.oss_ak_secret = oss_ak_secret
        # The description of the mounted OSS bucket.
        self.oss_mount_descs = oss_mount_descs
        # The type of the deployment package. Valid values:
        # 
        # *   If you deploy the application by using a Java Archive (JAR) package, you can set this parameter to **FatJar**, **War**, or **Image**.
        # 
        # *   If you deploy the application by using a PHP package, you can set this parameter to one of the following values:
        # 
        #     *   **PhpZip**\
        #     *   **IMAGE_PHP_5_4**\
        #     *   **IMAGE_PHP_5_4_ALPINE**\
        #     *   **IMAGE_PHP_5_5**\
        #     *   **IMAGE_PHP_5_5_ALPINE**\
        #     *   **IMAGE_PHP_5_6**\
        #     *   **IMAGE_PHP_5_6_ALPINE**\
        #     *   **IMAGE_PHP_7_0**\
        #     *   **IMAGE_PHP_7_0_ALPINE**\
        #     *   **IMAGE_PHP_7_1**\
        #     *   **IMAGE_PHP_7_1_ALPINE**\
        #     *   **IMAGE_PHP_7_2**\
        #     *   **IMAGE_PHP_7_2_ALPINE**\
        #     *   **IMAGE_PHP_7_3**\
        #     *   **IMAGE_PHP_7_3_ALPINE**\
        self.package_type = package_type
        # The URL of the deployment package. This parameter is returned only if the **PackageType** parameter is set to **FatJar** or **War**.
        self.package_url = package_url
        # The version of the deployment package. This parameter is returned only if the **PackageType** parameter is set to **FatJar** or **War**.
        self.package_version = package_version
        self.php = php
        # The path on which the PHP configuration file for application monitoring is mounted. Make sure that the PHP server loads the configuration file.
        # 
        # SAE automatically generates the corresponding configuration file. No manual operations are required.
        self.php_arms_config_location = php_arms_config_location
        # The details of the PHP configuration file.
        self.php_config = php_config
        # The path on which the PHP configuration file for application startup is mounted. Make sure that the PHP server uses this configuration file during the startup.
        self.php_config_location = php_config_location
        # The script that is run immediately after the container is started. Example: `{"exec":{"command":["cat","/etc/group"]}}`
        self.post_start = post_start
        # The script that is run before the container is stopped. Example: `{"exec":{"command":["cat","/etc/group"]}}`
        self.pre_stop = pre_stop
        # The programming language that is used to create the application. Valid values:
        # 
        # *   **java**: Java
        # *   **php**: PHP
        # *   **other**: Other programming languages, such as Python, C++, Go, .NET, and Node.js.
        self.programming_language = programming_language
        self.pvtz_discovery = pvtz_discovery
        self.python = python
        self.python_modules = python_modules
        # The details of the health check that was performed on the container. If the container fails this health check multiple times, the system disables and restarts the container. Containers that fail health checks cannot receive traffic from Server Load Balancer (SLB) instances. You can use the **exec**, **httpGet**, or **tcpSocket** method to perform health checks. For more information, see the description of the **Liveness** parameter.
        # 
        # >  You can use only one method to perform the health check.
        self.readiness = readiness
        # The ID of the region.
        self.region_id = region_id
        # The number of application instances.
        self.replicas = replicas
        # The ID of the security group.
        self.security_group_id = security_group_id
        self.service_tags = service_tags
        # The logging configurations of Log Service.
        # 
        # *   To use Log Service resources that are automatically created by SAE, set this parameter to `[{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}]`.
        # *   To use custom Log Service resources, set this parameter to `[{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}]`.
        # 
        # The following parameters are involved:
        # 
        # *   **projectName**: the name of the Log Service project.
        # *   **logDir**: the path in which logs are stored.
        # *   **logType**: the log type. **stdout**: the standard output log of the container. You can specify only one stdout value for this parameter. If you leave this parameter empty, file logs are collected.
        # *   **logstoreName**: the name of the Logstore in Log Service.
        # *   **logtailName**: the name of the Logtail configuration in Log Service. If you do not configure this parameter, a new Logtail configuration is created.
        # 
        # If you do not need to modify the logging configurations when you deploy the application, configure the **SlsConfigs** parameter only in the first request. You do not need to include this parameter in subsequent requests. If you no longer need to use Log Service, leave the **SlsConfigs** parameter empty in the request.
        self.sls_configs = sls_configs
        # The details of the tags.
        self.tags = tags
        # The timeout period for a graceful shutdown. Default value: 30. Unit: seconds. Valid values: 1 to 300.
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # The time zone. Default value: **Asia/Shanghai**.
        self.timezone = timezone
        # The Tomcat configuration. If you want to delete the configuration, set this parameter to {} or leave this parameter empty. The following parameters are involved:
        # 
        # *   **port**: the port number. Valid values: 1024 to 65535. The root permissions are required to perform operations on ports whose number is smaller than 1024. Enter a value that ranges from 1025 to 65535 because the container has only the admin permissions. If you do not configure this parameter, the default port number 8080 is used.
        # *   **contextPath**: the path. Default value: /. This value indicates the root directory.
        # *   **maxThreads**: the maximum number of connections in the connection pool. Default value: 400.
        # *   **uriEncoding**: the URI encoding scheme in the Tomcat container. Valid values: **UTF-8**, **ISO-8859-1**, **GBK**, and **GB2312**. If you do not configure this parameter, the default value **ISO-8859-1** is used.
        # *   **useBodyEncoding**: indicates whether to use the encoding scheme that is specified by **BodyEncoding for URL**. Default value: **true**.
        self.tomcat_config = tomcat_config
        # The deployment policy. If the minimum number of available instances is 1, the value of the **UpdateStrategy** parameter is an empty string (""). If the minimum number of available instances is greater than 1, the following strategies can be configured:
        # 
        # *   The application is deployed on an instance. The remaining instances are automatically classified into two release batches whose interval is set to 1. In this case, the parameter is set to `{"type":"GrayBatchUpdate","batchUpdate":{"batch":2,"releaseType":"auto","batchWaitTime":1},"grayUpdate":{"gray":1}}`.
        # *   The application is deployed on an instance. The remaining instances are manually classified into two release batches. In this case, the parameter is set to `{"type":"GrayBatchUpdate","batchUpdate":{"batch":2,"releaseType":"manual"},"grayUpdate":{"gray":1}}`.
        # *   All instances are automatically classified into two release batches. The application is deployed on the instances of the two batches in parallel. In this case, the parameter is set to `{"type":"BatchUpdate","batchUpdate":{"batch":2,"releaseType":"auto","batchWaitTime":0}}`
        # 
        # The following parameters are involved:
        # 
        # *   **type**: the type of the release policy. Valid values: **GrayBatchUpdate** and **BatchUpdate**.
        # 
        # *   **batchUpdate**: the phased release policy.
        # 
        #     *   **batch**: the number of release batches.
        #     *   **releaseType**: the processing method for the batches. Valid values: **auto** and **manual**.
        #     *   **batchWaitTime**: the interval between release batches. Unit: seconds.
        # 
        # *   **grayUpdate**: the number of release batches in the phased release after a canary release. This parameter is returned only if the **type** parameter is set to **GrayBatchUpdate**.
        self.update_strategy = update_strategy
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id
        # The ID of the virtual private cloud (VPC).
        self.vpc_id = vpc_id
        # The option settings in the WAR package. The settings are used to start the application container. The default startup command is `java $JAVA_OPTS $CATALINA_OPTS -Options org.apache.catalina.startup.Bootstrap "$@" start`.
        self.war_start_options = war_start_options
        # The version of the Tomcat container on which the deployment package depends. Valid values:
        # 
        # *   **apache-tomcat-7.0.91**\
        # *   **apache-tomcat-8.5.42**\
        # 
        # This parameter is not returned if the **PackageType** parameter is set to **Image**.
        self.web_container = web_container

    def validate(self):
        if self.config_map_mount_desc:
            for k in self.config_map_mount_desc:
                if k:
                    k.validate()
        if self.mount_desc:
            for k in self.mount_desc:
                if k:
                    k.validate()
        if self.oss_mount_descs:
            for k in self.oss_mount_descs:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acr_assume_role_arn is not None:
            result['AcrAssumeRoleArn'] = self.acr_assume_role_arn
        if self.acr_instance_id is not None:
            result['AcrInstanceId'] = self.acr_instance_id
        if self.app_description is not None:
            result['AppDescription'] = self.app_description
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.app_source is not None:
            result['AppSource'] = self.app_source
        if self.associate_eip is not None:
            result['AssociateEip'] = self.associate_eip
        if self.batch_wait_time is not None:
            result['BatchWaitTime'] = self.batch_wait_time
        if self.command is not None:
            result['Command'] = self.command
        if self.command_args is not None:
            result['CommandArgs'] = self.command_args
        result['ConfigMapMountDesc'] = []
        if self.config_map_mount_desc is not None:
            for k in self.config_map_mount_desc:
                result['ConfigMapMountDesc'].append(k.to_map() if k else None)
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.custom_host_alias is not None:
            result['CustomHostAlias'] = self.custom_host_alias
        if self.edas_container_version is not None:
            result['EdasContainerVersion'] = self.edas_container_version
        if self.enable_ahas is not None:
            result['EnableAhas'] = self.enable_ahas
        if self.enable_grey_tag_route is not None:
            result['EnableGreyTagRoute'] = self.enable_grey_tag_route
        if self.envs is not None:
            result['Envs'] = self.envs
        if self.image_pull_secrets is not None:
            result['ImagePullSecrets'] = self.image_pull_secrets
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.jar_start_args is not None:
            result['JarStartArgs'] = self.jar_start_args
        if self.jar_start_options is not None:
            result['JarStartOptions'] = self.jar_start_options
        if self.jdk is not None:
            result['Jdk'] = self.jdk
        if self.kafka_configs is not None:
            result['KafkaConfigs'] = self.kafka_configs
        if self.liveness is not None:
            result['Liveness'] = self.liveness
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.micro_registration is not None:
            result['MicroRegistration'] = self.micro_registration
        if self.min_ready_instance_ratio is not None:
            result['MinReadyInstanceRatio'] = self.min_ready_instance_ratio
        if self.min_ready_instances is not None:
            result['MinReadyInstances'] = self.min_ready_instances
        result['MountDesc'] = []
        if self.mount_desc is not None:
            for k in self.mount_desc:
                result['MountDesc'].append(k.to_map() if k else None)
        if self.mount_host is not None:
            result['MountHost'] = self.mount_host
        if self.mse_application_id is not None:
            result['MseApplicationId'] = self.mse_application_id
        if self.mse_application_name is not None:
            result['MseApplicationName'] = self.mse_application_name
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.nas_configs is not None:
            result['NasConfigs'] = self.nas_configs
        if self.nas_id is not None:
            result['NasId'] = self.nas_id
        if self.oss_ak_id is not None:
            result['OssAkId'] = self.oss_ak_id
        if self.oss_ak_secret is not None:
            result['OssAkSecret'] = self.oss_ak_secret
        result['OssMountDescs'] = []
        if self.oss_mount_descs is not None:
            for k in self.oss_mount_descs:
                result['OssMountDescs'].append(k.to_map() if k else None)
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        if self.php is not None:
            result['Php'] = self.php
        if self.php_arms_config_location is not None:
            result['PhpArmsConfigLocation'] = self.php_arms_config_location
        if self.php_config is not None:
            result['PhpConfig'] = self.php_config
        if self.php_config_location is not None:
            result['PhpConfigLocation'] = self.php_config_location
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.programming_language is not None:
            result['ProgrammingLanguage'] = self.programming_language
        if self.pvtz_discovery is not None:
            result['PvtzDiscovery'] = self.pvtz_discovery
        if self.python is not None:
            result['Python'] = self.python
        if self.python_modules is not None:
            result['PythonModules'] = self.python_modules
        if self.readiness is not None:
            result['Readiness'] = self.readiness
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.replicas is not None:
            result['Replicas'] = self.replicas
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.service_tags is not None:
            result['ServiceTags'] = self.service_tags
        if self.sls_configs is not None:
            result['SlsConfigs'] = self.sls_configs
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        if self.timezone is not None:
            result['Timezone'] = self.timezone
        if self.tomcat_config is not None:
            result['TomcatConfig'] = self.tomcat_config
        if self.update_strategy is not None:
            result['UpdateStrategy'] = self.update_strategy
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.war_start_options is not None:
            result['WarStartOptions'] = self.war_start_options
        if self.web_container is not None:
            result['WebContainer'] = self.web_container
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcrAssumeRoleArn') is not None:
            self.acr_assume_role_arn = m.get('AcrAssumeRoleArn')
        if m.get('AcrInstanceId') is not None:
            self.acr_instance_id = m.get('AcrInstanceId')
        if m.get('AppDescription') is not None:
            self.app_description = m.get('AppDescription')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('AppSource') is not None:
            self.app_source = m.get('AppSource')
        if m.get('AssociateEip') is not None:
            self.associate_eip = m.get('AssociateEip')
        if m.get('BatchWaitTime') is not None:
            self.batch_wait_time = m.get('BatchWaitTime')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CommandArgs') is not None:
            self.command_args = m.get('CommandArgs')
        self.config_map_mount_desc = []
        if m.get('ConfigMapMountDesc') is not None:
            for k in m.get('ConfigMapMountDesc'):
                temp_model = DescribeApplicationConfigResponseBodyDataConfigMapMountDesc()
                self.config_map_mount_desc.append(temp_model.from_map(k))
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CustomHostAlias') is not None:
            self.custom_host_alias = m.get('CustomHostAlias')
        if m.get('EdasContainerVersion') is not None:
            self.edas_container_version = m.get('EdasContainerVersion')
        if m.get('EnableAhas') is not None:
            self.enable_ahas = m.get('EnableAhas')
        if m.get('EnableGreyTagRoute') is not None:
            self.enable_grey_tag_route = m.get('EnableGreyTagRoute')
        if m.get('Envs') is not None:
            self.envs = m.get('Envs')
        if m.get('ImagePullSecrets') is not None:
            self.image_pull_secrets = m.get('ImagePullSecrets')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('JarStartArgs') is not None:
            self.jar_start_args = m.get('JarStartArgs')
        if m.get('JarStartOptions') is not None:
            self.jar_start_options = m.get('JarStartOptions')
        if m.get('Jdk') is not None:
            self.jdk = m.get('Jdk')
        if m.get('KafkaConfigs') is not None:
            self.kafka_configs = m.get('KafkaConfigs')
        if m.get('Liveness') is not None:
            self.liveness = m.get('Liveness')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('MicroRegistration') is not None:
            self.micro_registration = m.get('MicroRegistration')
        if m.get('MinReadyInstanceRatio') is not None:
            self.min_ready_instance_ratio = m.get('MinReadyInstanceRatio')
        if m.get('MinReadyInstances') is not None:
            self.min_ready_instances = m.get('MinReadyInstances')
        self.mount_desc = []
        if m.get('MountDesc') is not None:
            for k in m.get('MountDesc'):
                temp_model = DescribeApplicationConfigResponseBodyDataMountDesc()
                self.mount_desc.append(temp_model.from_map(k))
        if m.get('MountHost') is not None:
            self.mount_host = m.get('MountHost')
        if m.get('MseApplicationId') is not None:
            self.mse_application_id = m.get('MseApplicationId')
        if m.get('MseApplicationName') is not None:
            self.mse_application_name = m.get('MseApplicationName')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NasConfigs') is not None:
            self.nas_configs = m.get('NasConfigs')
        if m.get('NasId') is not None:
            self.nas_id = m.get('NasId')
        if m.get('OssAkId') is not None:
            self.oss_ak_id = m.get('OssAkId')
        if m.get('OssAkSecret') is not None:
            self.oss_ak_secret = m.get('OssAkSecret')
        self.oss_mount_descs = []
        if m.get('OssMountDescs') is not None:
            for k in m.get('OssMountDescs'):
                temp_model = DescribeApplicationConfigResponseBodyDataOssMountDescs()
                self.oss_mount_descs.append(temp_model.from_map(k))
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        if m.get('Php') is not None:
            self.php = m.get('Php')
        if m.get('PhpArmsConfigLocation') is not None:
            self.php_arms_config_location = m.get('PhpArmsConfigLocation')
        if m.get('PhpConfig') is not None:
            self.php_config = m.get('PhpConfig')
        if m.get('PhpConfigLocation') is not None:
            self.php_config_location = m.get('PhpConfigLocation')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('ProgrammingLanguage') is not None:
            self.programming_language = m.get('ProgrammingLanguage')
        if m.get('PvtzDiscovery') is not None:
            self.pvtz_discovery = m.get('PvtzDiscovery')
        if m.get('Python') is not None:
            self.python = m.get('Python')
        if m.get('PythonModules') is not None:
            self.python_modules = m.get('PythonModules')
        if m.get('Readiness') is not None:
            self.readiness = m.get('Readiness')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Replicas') is not None:
            self.replicas = m.get('Replicas')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('ServiceTags') is not None:
            self.service_tags = m.get('ServiceTags')
        if m.get('SlsConfigs') is not None:
            self.sls_configs = m.get('SlsConfigs')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeApplicationConfigResponseBodyDataTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        if m.get('Timezone') is not None:
            self.timezone = m.get('Timezone')
        if m.get('TomcatConfig') is not None:
            self.tomcat_config = m.get('TomcatConfig')
        if m.get('UpdateStrategy') is not None:
            self.update_strategy = m.get('UpdateStrategy')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WarStartOptions') is not None:
            self.war_start_options = m.get('WarStartOptions')
        if m.get('WebContainer') is not None:
            self.web_container = m.get('WebContainer')
        return self


class DescribeApplicationConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeApplicationConfigResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The information about the application.
        self.data = data
        # The returned error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.error_code = error_code
        # The returned information.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the configurations of an application were obtained. Valid values:
        # 
        # *   **true**: The configurations were obtained.
        # *   **false**: The configurations failed to be obtained.
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeApplicationConfigResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationGroupsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        current_page: int = None,
        page_size: int = None,
    ):
        # d700e680-aa4d-4ec1-afc2-6566b5ff\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id
        # 1
        self.current_page = current_page
        # 10
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeApplicationGroupsResponseBodyData(TeaModel):
    def __init__(
        self,
        edas_container_version: str = None,
        group_id: str = None,
        group_name: str = None,
        group_type: int = None,
        image_url: str = None,
        jdk: str = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
        replicas: int = None,
        running_instances: int = None,
        web_container: str = None,
    ):
        # The version of the container, such as Ali-Tomcat, in which a High-speed Service Framework (HSF) application runs.
        self.edas_container_version = edas_container_version
        # The ID of the group.
        self.group_id = group_id
        # The name of the group.
        self.group_name = group_name
        # The type of the group.
        self.group_type = group_type
        # The address of the image. This parameter is required when the **PackageType** parameter is set to **Image**.
        self.image_url = image_url
        # The version of the Java development kit (JDK) on which the deployment package of the application depends. This parameter is invalid when the **PackageType** parameter is set to **Image**.
        self.jdk = jdk
        # The type of the application deployment package. Valid values:
        # 
        # *   When you use a Java package, set this value to **FatJar**, **War**, or **Image**.
        # 
        # *   When you use a PHP package, the following values are valid:
        # 
        #     *   **PhpZip**\
        #     *   **IMAGE_PHP_5_4**\
        #     *   **IMAGE_PHP_5_4_ALPINE**\
        #     *   **IMAGE_PHP_5_5**\
        #     *   **IMAGE_PHP_5_5_ALPINE**\
        #     *   **IMAGE_PHP_5_6**\
        #     *   **IMAGE_PHP_5_6_ALPINE**\
        #     *   **IMAGE_PHP_7_0**\
        #     *   **IMAGE_PHP_7_0_ALPINE**\
        #     *   **IMAGE_PHP_7_1**\
        #     *   **IMAGE_PHP_7_1_ALPINE**\
        #     *   **IMAGE_PHP_7_2**\
        #     *   **IMAGE_PHP_7_2_ALPINE**\
        #     *   **IMAGE_PHP_7_3**\
        #     *   **IMAGE_PHP_7_3_ALPINE**\
        self.package_type = package_type
        # The address of the deployment package. This parameter is required when the **PackageType** parameter is set to **FatJar**, **War**, or **PhpZip**.
        self.package_url = package_url
        # The version of the deployment package. This parameter is required when the **PackageType** parameter is set to **FatJar**, **War**, or **PhpZip**. The parameter value will be automatically generated when you use an image to deploy the application and specify the **ImageUrl** parameter.
        self.package_version = package_version
        # The total number of instances.
        self.replicas = replicas
        # The number of running instances.
        self.running_instances = running_instances
        # The version of the Apache Tomcat container on which the deployment package of the application depends. This parameter is invalid when the **PackageType** parameter is set to **Image**.
        self.web_container = web_container

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.edas_container_version is not None:
            result['EdasContainerVersion'] = self.edas_container_version
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.group_type is not None:
            result['GroupType'] = self.group_type
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.jdk is not None:
            result['Jdk'] = self.jdk
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        if self.replicas is not None:
            result['Replicas'] = self.replicas
        if self.running_instances is not None:
            result['RunningInstances'] = self.running_instances
        if self.web_container is not None:
            result['WebContainer'] = self.web_container
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EdasContainerVersion') is not None:
            self.edas_container_version = m.get('EdasContainerVersion')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('GroupType') is not None:
            self.group_type = m.get('GroupType')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('Jdk') is not None:
            self.jdk = m.get('Jdk')
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        if m.get('Replicas') is not None:
            self.replicas = m.get('Replicas')
        if m.get('RunningInstances') is not None:
            self.running_instances = m.get('RunningInstances')
        if m.get('WebContainer') is not None:
            self.web_container = m.get('WebContainer')
        return self


class DescribeApplicationGroupsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[DescribeApplicationGroupsResponseBodyData] = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The information about the instance groups of the application.
        self.data = data
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the information about instance groups of an application was obtained. Valid values:
        # 
        # *   **true**: indicates that the information was obtained.
        # *   **false**: indicates that the information could not be obtained.
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeApplicationGroupsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationImageRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        image_url: str = None,
    ):
        # The ID of the application.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The URL of the image.
        # 
        # This parameter is required.
        self.image_url = image_url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        return self


class DescribeApplicationImageResponseBodyData(TeaModel):
    def __init__(
        self,
        cr_url: str = None,
        logo: str = None,
        region_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_origin_type: str = None,
        repo_tag: str = None,
        repo_type: str = None,
    ):
        # This parameter is reserved.
        self.cr_url = cr_url
        # This parameter is reserved.
        self.logo = logo
        # The region ID.
        self.region_id = region_id
        # The name of the repository.
        self.repo_name = repo_name
        # The name of the namespace to which the image repository belongs.
        self.repo_namespace = repo_namespace
        # The type of the repository. Only Container Registry is supported.
        self.repo_origin_type = repo_origin_type
        # The tag of the image.
        self.repo_tag = repo_tag
        # This parameter is reserved.
        self.repo_type = repo_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cr_url is not None:
            result['CrUrl'] = self.cr_url
        if self.logo is not None:
            result['Logo'] = self.logo
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_origin_type is not None:
            result['RepoOriginType'] = self.repo_origin_type
        if self.repo_tag is not None:
            result['RepoTag'] = self.repo_tag
        if self.repo_type is not None:
            result['RepoType'] = self.repo_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CrUrl') is not None:
            self.cr_url = m.get('CrUrl')
        if m.get('Logo') is not None:
            self.logo = m.get('Logo')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoOriginType') is not None:
            self.repo_origin_type = m.get('RepoOriginType')
        if m.get('RepoTag') is not None:
            self.repo_tag = m.get('RepoTag')
        if m.get('RepoType') is not None:
            self.repo_type = m.get('RepoType')
        return self


class DescribeApplicationImageResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeApplicationImageResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The information about the image of the application.
        self.data = data
        # The error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the **Error codes** section in this topic.
        self.error_code = error_code
        # The returned message. Valid values:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the information about the image was obtained. Valid values:
        # 
        # *   **true**: The information was obtained.
        # *   **false**: The information failed to be obtained.
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeApplicationImageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationInstancesRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        current_page: int = None,
        group_id: str = None,
        page_size: int = None,
        reverse: bool = None,
    ):
        # d700e680-aa4d-4ec1-afc2-6566b5ff\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id
        # 1
        self.current_page = current_page
        # b2a8a925-477a-4ed7-b825-d5e22500\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.group_id = group_id
        # 10
        self.page_size = page_size
        # true
        self.reverse = reverse

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.reverse is not None:
            result['Reverse'] = self.reverse
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Reverse') is not None:
            self.reverse = m.get('Reverse')
        return self


class DescribeApplicationInstancesResponseBodyDataInstances(TeaModel):
    def __init__(
        self,
        create_time_stamp: int = None,
        debug_status: bool = None,
        eip: str = None,
        finish_time_stamp: int = None,
        group_id: str = None,
        image_url: str = None,
        instance_container_ip: str = None,
        instance_container_restarts: int = None,
        instance_container_status: str = None,
        instance_health_status: str = None,
        instance_id: str = None,
        package_version: str = None,
        v_switch_id: str = None,
    ):
        # The start time of the instance creation process. Unit: milliseconds.
        self.create_time_stamp = create_time_stamp
        self.debug_status = debug_status
        # The elastic IP address (EIP).
        self.eip = eip
        # The end time of the instance creation process. Unit: milliseconds.
        self.finish_time_stamp = finish_time_stamp
        # The ID of the group to which the instance belongs.
        self.group_id = group_id
        # The address of the repository.
        # 
        # >  If you deploy the application by using a JAR or WAR package, the image generated by SAE is not available for download.
        self.image_url = image_url
        # The internal IP address of the instance.
        self.instance_container_ip = instance_container_ip
        # The number of times that the instance restarted.
        self.instance_container_restarts = instance_container_restarts
        # The state of the instance. Valid values:
        # 
        # *   **Error**: An error occurred during the instance startup.
        # *   **CrashLoopBackOff**: The container failed to start. An error occurred during the startup process and persisted after the restart.
        # *   **ErrImagePull**: An error occurred while the container image was being pulled from the instance.
        # *   **ImagePullBackOff**: The container image could not be obtained.
        # *   **Pending**: The instance is waiting to be scheduled.
        # *   **Unknown**: An unknown exception occurred.
        # *   **Terminating**: The instance creation process is being terminated.
        # *   **NotFound**: The instance cannot be found.
        # *   **PodInitializing**: The instance is being initialized.
        # *   **Init:0/1**: The instance is initialized.
        # *   **Running**: The instance is running.
        self.instance_container_status = instance_container_status
        # The configurations of health checks. Valid values:
        # 
        # *   **WithoutHealthCheckConfig**: Liveness and readiness checks are not configured.
        # *   **WithoutLivenessConfig**: The liveness check is not configured.
        # *   **WithoutReadinessConfig**: The readiness check is not configured.
        # *   **NotCheckedYet**: The health checks are not performed or are in progress.
        # *   **LivenessUnhealthy**: The instance failed the liveness check.
        # *   **ReadinessUnhealthy**: The instance failed the readiness check.
        # *   **Unhealthy**: The instance failed both liveness and readiness checks.
        # *   **Healthy**: The instance passed both liveness and readiness checks.
        self.instance_health_status = instance_health_status
        # The ID of the instance.
        self.instance_id = instance_id
        # The version of the package.
        self.package_version = package_version
        # The ID of the zone where the instance is deployed.
        self.v_switch_id = v_switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_stamp is not None:
            result['CreateTimeStamp'] = self.create_time_stamp
        if self.debug_status is not None:
            result['DebugStatus'] = self.debug_status
        if self.eip is not None:
            result['Eip'] = self.eip
        if self.finish_time_stamp is not None:
            result['FinishTimeStamp'] = self.finish_time_stamp
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.instance_container_ip is not None:
            result['InstanceContainerIp'] = self.instance_container_ip
        if self.instance_container_restarts is not None:
            result['InstanceContainerRestarts'] = self.instance_container_restarts
        if self.instance_container_status is not None:
            result['InstanceContainerStatus'] = self.instance_container_status
        if self.instance_health_status is not None:
            result['InstanceHealthStatus'] = self.instance_health_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateTimeStamp') is not None:
            self.create_time_stamp = m.get('CreateTimeStamp')
        if m.get('DebugStatus') is not None:
            self.debug_status = m.get('DebugStatus')
        if m.get('Eip') is not None:
            self.eip = m.get('Eip')
        if m.get('FinishTimeStamp') is not None:
            self.finish_time_stamp = m.get('FinishTimeStamp')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('InstanceContainerIp') is not None:
            self.instance_container_ip = m.get('InstanceContainerIp')
        if m.get('InstanceContainerRestarts') is not None:
            self.instance_container_restarts = m.get('InstanceContainerRestarts')
        if m.get('InstanceContainerStatus') is not None:
            self.instance_container_status = m.get('InstanceContainerStatus')
        if m.get('InstanceHealthStatus') is not None:
            self.instance_health_status = m.get('InstanceHealthStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        return self


class DescribeApplicationInstancesResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        instances: List[DescribeApplicationInstancesResponseBodyDataInstances] = None,
        page_size: int = None,
        total_size: int = None,
    ):
        # The number of the returned page.
        self.current_page = current_page
        # The list of application instances.
        self.instances = instances
        # The number of entries returned on each page.
        self.page_size = page_size
        # The total number of returned instances.
        self.total_size = total_size

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeApplicationInstancesResponseBodyDataInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class DescribeApplicationInstancesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeApplicationInstancesResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The details of the application instances.
        self.data = data
        # The error code. 
        # 
        # - The **ErrorCode** parameter is not returned when the request succeeds.
        # - The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the list of application instances was obtained. Valid values:
        # 
        # *   **true**: indicates that the list was obtained.
        # *   **false**: indicates that the list could not be obtained.
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeApplicationInstancesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationScalingRuleRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        scaling_rule_name: str = None,
    ):
        # a0d2e04c-159d-40a8-b240-d2f2c263\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id
        # test
        # 
        # This parameter is required.
        self.scaling_rule_name = scaling_rule_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.scaling_rule_name is not None:
            result['ScalingRuleName'] = self.scaling_rule_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ScalingRuleName') is not None:
            self.scaling_rule_name = m.get('ScalingRuleName')
        return self


class DescribeApplicationScalingRuleResponseBodyDataMetricMetrics(TeaModel):
    def __init__(
        self,
        metric_target_average_utilization: int = None,
        metric_type: str = None,
        slb_id: str = None,
        slb_logstore: str = None,
        slb_project: str = None,
        vport: str = None,
    ):
        # The limit on the metric.
        # 
        # *   The limit on the CPU utilization. Unit: percentage.
        # *   The limit on the memory usage. Unit: percentage.
        # *   The limit on the average number of active TCP connections per second.
        # *   The limit on the QPS of the Internet-facing SLB instance.
        # *   The limit on the response time of the Internet-facing SLB instance. Unit: milliseconds.
        self.metric_target_average_utilization = metric_target_average_utilization
        # The metric that is used to trigger the auto scaling policy. Valid values:
        # 
        # *   **CPU**: the CPU utilization.
        # *   **MEMORY**: the memory usage.
        # *   **tcpActiveConn**: the average number of active TCP connections for an instance in 30 seconds.
        # *   **SLB_QPS**: the average QPS of the Internet-facing SLB instance associated with an application instance in 15 seconds.
        # *   **SLB_RT**: the average response time of the Internet-facing SLB instance in 15 seconds.
        self.metric_type = metric_type
        self.slb_id = slb_id
        self.slb_logstore = slb_logstore
        self.slb_project = slb_project
        self.vport = vport

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_target_average_utilization is not None:
            result['MetricTargetAverageUtilization'] = self.metric_target_average_utilization
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.slb_logstore is not None:
            result['SlbLogstore'] = self.slb_logstore
        if self.slb_project is not None:
            result['SlbProject'] = self.slb_project
        if self.vport is not None:
            result['Vport'] = self.vport
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricTargetAverageUtilization') is not None:
            self.metric_target_average_utilization = m.get('MetricTargetAverageUtilization')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('SlbLogstore') is not None:
            self.slb_logstore = m.get('SlbLogstore')
        if m.get('SlbProject') is not None:
            self.slb_project = m.get('SlbProject')
        if m.get('Vport') is not None:
            self.vport = m.get('Vport')
        return self


class DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatusCurrentMetrics(TeaModel):
    def __init__(
        self,
        current_value: int = None,
        name: str = None,
        type: str = None,
    ):
        # The current value of the metric.
        self.current_value = current_value
        # The name of the metric.
        # 
        # *   **cpu**: the CPU utilization.
        # *   **memory**: the memory usage.
        # *   **tcpActiveConn**: the number of active TCP connections.
        # *   **slb_incall_qps**: the QPS of the Internet-facing SLB instance.
        # *   **slb_incall_rt**: the response time of the Internet-facing SLB instance.
        self.name = name
        # The type of the data. This parameter corresponds to the metric.
        # 
        # *   **Resource**: used when the metric is the **CPU utilization** or **memory usage**.
        # *   **Pods**: used when the metric is the **number of active TCP connections**.
        # *   **External**: used when the metric is about the **SLB** instance or from **Application Real-Time Monitoring Service (ARMS)**.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_value is not None:
            result['CurrentValue'] = self.current_value
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentValue') is not None:
            self.current_value = m.get('CurrentValue')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatusNextScaleMetrics(TeaModel):
    def __init__(
        self,
        name: str = None,
        next_scale_in_average_utilization: int = None,
        next_scale_out_average_utilization: int = None,
    ):
        # The name of the metric.
        # 
        # *   **cpu**: the CPU utilization.
        # *   **memory**: the memory usage.
        # *   **tcpActiveConn**: the number of active TCP connections.
        # *   **slb_incall_qps**: the QPS of the Internet-facing SLB instance.
        # *   **slb_incall_rt**: the response time of the Internet-facing SLB instance.
        self.name = name
        # The metric value as a percentage that triggers the application scale-in next time.
        self.next_scale_in_average_utilization = next_scale_in_average_utilization
        # The metric value as a percentage that triggers the application scale-out next time.
        self.next_scale_out_average_utilization = next_scale_out_average_utilization

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.next_scale_in_average_utilization is not None:
            result['NextScaleInAverageUtilization'] = self.next_scale_in_average_utilization
        if self.next_scale_out_average_utilization is not None:
            result['NextScaleOutAverageUtilization'] = self.next_scale_out_average_utilization
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextScaleInAverageUtilization') is not None:
            self.next_scale_in_average_utilization = m.get('NextScaleInAverageUtilization')
        if m.get('NextScaleOutAverageUtilization') is not None:
            self.next_scale_out_average_utilization = m.get('NextScaleOutAverageUtilization')
        return self


class DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatus(TeaModel):
    def __init__(
        self,
        current_metrics: List[DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatusCurrentMetrics] = None,
        current_replicas: int = None,
        desired_replicas: int = None,
        last_scale_time: str = None,
        next_scale_metrics: List[DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatusNextScaleMetrics] = None,
        next_scale_time_period: int = None,
    ):
        # The metrics that is used to trigger the current auto scaling policy.
        self.current_metrics = current_metrics
        # The current number of instances.
        self.current_replicas = current_replicas
        # The expected number of instances.
        self.desired_replicas = desired_replicas
        # The time when the auto scaling policy was last triggered.
        self.last_scale_time = last_scale_time
        # The metrics that are used to trigger the auto scaling policy next time.
        self.next_scale_metrics = next_scale_metrics
        # The duration for which the metric-based auto scaling policy takes effect next time.
        self.next_scale_time_period = next_scale_time_period

    def validate(self):
        if self.current_metrics:
            for k in self.current_metrics:
                if k:
                    k.validate()
        if self.next_scale_metrics:
            for k in self.next_scale_metrics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CurrentMetrics'] = []
        if self.current_metrics is not None:
            for k in self.current_metrics:
                result['CurrentMetrics'].append(k.to_map() if k else None)
        if self.current_replicas is not None:
            result['CurrentReplicas'] = self.current_replicas
        if self.desired_replicas is not None:
            result['DesiredReplicas'] = self.desired_replicas
        if self.last_scale_time is not None:
            result['LastScaleTime'] = self.last_scale_time
        result['NextScaleMetrics'] = []
        if self.next_scale_metrics is not None:
            for k in self.next_scale_metrics:
                result['NextScaleMetrics'].append(k.to_map() if k else None)
        if self.next_scale_time_period is not None:
            result['NextScaleTimePeriod'] = self.next_scale_time_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.current_metrics = []
        if m.get('CurrentMetrics') is not None:
            for k in m.get('CurrentMetrics'):
                temp_model = DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatusCurrentMetrics()
                self.current_metrics.append(temp_model.from_map(k))
        if m.get('CurrentReplicas') is not None:
            self.current_replicas = m.get('CurrentReplicas')
        if m.get('DesiredReplicas') is not None:
            self.desired_replicas = m.get('DesiredReplicas')
        if m.get('LastScaleTime') is not None:
            self.last_scale_time = m.get('LastScaleTime')
        self.next_scale_metrics = []
        if m.get('NextScaleMetrics') is not None:
            for k in m.get('NextScaleMetrics'):
                temp_model = DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatusNextScaleMetrics()
                self.next_scale_metrics.append(temp_model.from_map(k))
        if m.get('NextScaleTimePeriod') is not None:
            self.next_scale_time_period = m.get('NextScaleTimePeriod')
        return self


class DescribeApplicationScalingRuleResponseBodyDataMetricScaleDownRules(TeaModel):
    def __init__(
        self,
        disabled: bool = None,
        stabilization_window_seconds: int = None,
        step: int = None,
    ):
        # Indicates whether the application scale-in is disabled. Valid values:
        # 
        # *   **true**: disabled.
        # *   **false**: enabled.
        # 
        # >  When this parameter is set to true, the application instances are never reduced. This prevents risks to your business in peak hours. By default, this parameter is set to false.
        self.disabled = disabled
        # The cooldown time of the scale-in. Valid values: 0 to 3600. Unit: seconds. Default value: 0.
        self.stabilization_window_seconds = stabilization_window_seconds
        # The step size for the scale-in. The maximum number of instances that can be reduced within a specific period of time.
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.stabilization_window_seconds is not None:
            result['StabilizationWindowSeconds'] = self.stabilization_window_seconds
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('StabilizationWindowSeconds') is not None:
            self.stabilization_window_seconds = m.get('StabilizationWindowSeconds')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeApplicationScalingRuleResponseBodyDataMetricScaleUpRules(TeaModel):
    def __init__(
        self,
        disabled: bool = None,
        stabilization_window_seconds: int = None,
        step: int = None,
    ):
        # Indicates whether the application scale-in is disabled. Valid values:
        # 
        # *   **true**: The application scale-in is disabled.
        # *   **false**: The application scale-in is enabled.
        # 
        # >  When this parameter is set to true, the application instances are never reduced. This prevents risks to your business in peak hours. By default, this parameter is set to false.
        self.disabled = disabled
        # The cooldown time of the scale-out. Valid values: 0 to 3600. Unit: seconds. Default value: 0.
        self.stabilization_window_seconds = stabilization_window_seconds
        # The step size for the scale-out. The maximum number of instances that can be added within a specific period of time.
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.stabilization_window_seconds is not None:
            result['StabilizationWindowSeconds'] = self.stabilization_window_seconds
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('StabilizationWindowSeconds') is not None:
            self.stabilization_window_seconds = m.get('StabilizationWindowSeconds')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeApplicationScalingRuleResponseBodyDataMetric(TeaModel):
    def __init__(
        self,
        max_replicas: int = None,
        metrics: List[DescribeApplicationScalingRuleResponseBodyDataMetricMetrics] = None,
        metrics_status: DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatus = None,
        min_replicas: int = None,
        scale_down_rules: DescribeApplicationScalingRuleResponseBodyDataMetricScaleDownRules = None,
        scale_up_rules: DescribeApplicationScalingRuleResponseBodyDataMetricScaleUpRules = None,
    ):
        # The maximum number of instances.
        self.max_replicas = max_replicas
        # The list of metrics that are used to trigger the auto scaling policy.
        self.metrics = metrics
        # The execution status of the metric-based auto scaling policy.
        self.metrics_status = metrics_status
        # The minimum number of instances.
        self.min_replicas = min_replicas
        # Rules that determine the application scale-in.
        self.scale_down_rules = scale_down_rules
        # Rules that determine the application scale-out.
        self.scale_up_rules = scale_up_rules

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()
        if self.metrics_status:
            self.metrics_status.validate()
        if self.scale_down_rules:
            self.scale_down_rules.validate()
        if self.scale_up_rules:
            self.scale_up_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_replicas is not None:
            result['MaxReplicas'] = self.max_replicas
        result['Metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['Metrics'].append(k.to_map() if k else None)
        if self.metrics_status is not None:
            result['MetricsStatus'] = self.metrics_status.to_map()
        if self.min_replicas is not None:
            result['MinReplicas'] = self.min_replicas
        if self.scale_down_rules is not None:
            result['ScaleDownRules'] = self.scale_down_rules.to_map()
        if self.scale_up_rules is not None:
            result['ScaleUpRules'] = self.scale_up_rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxReplicas') is not None:
            self.max_replicas = m.get('MaxReplicas')
        self.metrics = []
        if m.get('Metrics') is not None:
            for k in m.get('Metrics'):
                temp_model = DescribeApplicationScalingRuleResponseBodyDataMetricMetrics()
                self.metrics.append(temp_model.from_map(k))
        if m.get('MetricsStatus') is not None:
            temp_model = DescribeApplicationScalingRuleResponseBodyDataMetricMetricsStatus()
            self.metrics_status = temp_model.from_map(m['MetricsStatus'])
        if m.get('MinReplicas') is not None:
            self.min_replicas = m.get('MinReplicas')
        if m.get('ScaleDownRules') is not None:
            temp_model = DescribeApplicationScalingRuleResponseBodyDataMetricScaleDownRules()
            self.scale_down_rules = temp_model.from_map(m['ScaleDownRules'])
        if m.get('ScaleUpRules') is not None:
            temp_model = DescribeApplicationScalingRuleResponseBodyDataMetricScaleUpRules()
            self.scale_up_rules = temp_model.from_map(m['ScaleUpRules'])
        return self


class DescribeApplicationScalingRuleResponseBodyDataTimerSchedules(TeaModel):
    def __init__(
        self,
        at_time: str = None,
        max_replicas: int = None,
        min_replicas: int = None,
        target_replicas: int = None,
    ):
        # The point in time. Format: **Hour:Minute**.
        self.at_time = at_time
        self.max_replicas = max_replicas
        self.min_replicas = min_replicas
        # The expected number of instances.
        self.target_replicas = target_replicas

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.at_time is not None:
            result['AtTime'] = self.at_time
        if self.max_replicas is not None:
            result['MaxReplicas'] = self.max_replicas
        if self.min_replicas is not None:
            result['MinReplicas'] = self.min_replicas
        if self.target_replicas is not None:
            result['TargetReplicas'] = self.target_replicas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AtTime') is not None:
            self.at_time = m.get('AtTime')
        if m.get('MaxReplicas') is not None:
            self.max_replicas = m.get('MaxReplicas')
        if m.get('MinReplicas') is not None:
            self.min_replicas = m.get('MinReplicas')
        if m.get('TargetReplicas') is not None:
            self.target_replicas = m.get('TargetReplicas')
        return self


class DescribeApplicationScalingRuleResponseBodyDataTimer(TeaModel):
    def __init__(
        self,
        begin_date: str = None,
        end_date: str = None,
        period: str = None,
        schedules: List[DescribeApplicationScalingRuleResponseBodyDataTimerSchedules] = None,
    ):
        # The start date of the validity period of the scheduled auto scaling policy. Valid values:
        # 
        # *   If both the **BeginDate** and **EndDate** parameters are set to **null**, the auto scaling policy can always be triggered. The default value for these parameters is null.
        # *   If the two parameters are set to specific dates, the scheduled auto scaling policy can be triggered during the period between the two dates. For example, if **BeginDate** is **2021-03-25** and **EndDate** is **2021-04-25**, the auto scaling policy is valid for one month.
        self.begin_date = begin_date
        # The end date of the validity period of the scheduled auto scaling policy. Valid values:
        # 
        # *   If both the **BeginDate** and **EndDate** parameters are set to **null**, the auto scaling policy can always be triggered. The default value for these parameters is null.
        # *   If the two parameters are set to specific dates, the scheduled auto scaling policy can be triggered during the period between the two dates. For example, if **BeginDate** is **2021-03-25** and **EndDate** is **2021-04-25**, the auto scaling policy is valid for one month.
        self.end_date = end_date
        # The days on which the scheduled auto scaling policy takes effect. Valid values:
        # 
        # *   **\\* \\* \\***: The scheduled auto scaling policy takes effect at a specified time every day.
        # 
        # *   **\\* \\* Fri,Mon**: The scheduled auto scaling policy takes effect at a specified time on one or multiple days of a week. The specified time is in the GMT+8 time zone. Valid values:
        # 
        #     *   **Sun**: Sunday
        #     *   **Mon**: Monday
        #     *   **Tue**: Tuesday
        #     *   **Wed**: Wednesday
        #     *   **Thu**: Thursday
        #     *   **Fri**: Friday
        #     *   **Sat**: Saturday
        # 
        # *   **1,2,3,28,31 \\* \\***: The scheduled auto scaling policy takes effect at a specified time on one or multiple days of a month. Valid values: 1 to 31. If the month does not have a 31st day, the auto scaling policy takes effect on the specified days other than the 31st day.
        self.period = period
        # The points in time when the auto scaling policy is triggered within one day.
        self.schedules = schedules

    def validate(self):
        if self.schedules:
            for k in self.schedules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.period is not None:
            result['Period'] = self.period
        result['Schedules'] = []
        if self.schedules is not None:
            for k in self.schedules:
                result['Schedules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        self.schedules = []
        if m.get('Schedules') is not None:
            for k in m.get('Schedules'):
                temp_model = DescribeApplicationScalingRuleResponseBodyDataTimerSchedules()
                self.schedules.append(temp_model.from_map(k))
        return self


class DescribeApplicationScalingRuleResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        create_time: int = None,
        last_disable_time: int = None,
        metric: DescribeApplicationScalingRuleResponseBodyDataMetric = None,
        min_ready_instance_ratio: int = None,
        min_ready_instances: int = None,
        scale_rule_enabled: bool = None,
        scale_rule_name: str = None,
        scale_rule_type: str = None,
        timer: DescribeApplicationScalingRuleResponseBodyDataTimer = None,
        update_time: int = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The time when the auto scaling policy was created. Unit: milliseconds.
        self.create_time = create_time
        # The time when the auto scaling policy was last disabled.
        self.last_disable_time = last_disable_time
        # The details of the metric-based auto scaling policy.
        self.metric = metric
        self.min_ready_instance_ratio = min_ready_instance_ratio
        self.min_ready_instances = min_ready_instances
        # Indicates whether the auto scaling policy is enabled. Valid values:
        # 
        # *   **true**: enabled
        # *   **false**: disabled
        self.scale_rule_enabled = scale_rule_enabled
        # The name of the auto scaling policy.
        self.scale_rule_name = scale_rule_name
        # The type of the auto scaling policy. Valid values:
        # 
        # *   **timing**: the scheduled auto scaling policy.
        # *   **metric**: the metric-based auto scaling policy.
        # *   **mix**: the hybrid auto scaling policy.
        self.scale_rule_type = scale_rule_type
        # The details of the scheduled auto scaling policy.
        self.timer = timer
        # The time when the auto scaling policy was updated. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        if self.metric:
            self.metric.validate()
        if self.timer:
            self.timer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_disable_time is not None:
            result['LastDisableTime'] = self.last_disable_time
        if self.metric is not None:
            result['Metric'] = self.metric.to_map()
        if self.min_ready_instance_ratio is not None:
            result['MinReadyInstanceRatio'] = self.min_ready_instance_ratio
        if self.min_ready_instances is not None:
            result['MinReadyInstances'] = self.min_ready_instances
        if self.scale_rule_enabled is not None:
            result['ScaleRuleEnabled'] = self.scale_rule_enabled
        if self.scale_rule_name is not None:
            result['ScaleRuleName'] = self.scale_rule_name
        if self.scale_rule_type is not None:
            result['ScaleRuleType'] = self.scale_rule_type
        if self.timer is not None:
            result['Timer'] = self.timer.to_map()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastDisableTime') is not None:
            self.last_disable_time = m.get('LastDisableTime')
        if m.get('Metric') is not None:
            temp_model = DescribeApplicationScalingRuleResponseBodyDataMetric()
            self.metric = temp_model.from_map(m['Metric'])
        if m.get('MinReadyInstanceRatio') is not None:
            self.min_ready_instance_ratio = m.get('MinReadyInstanceRatio')
        if m.get('MinReadyInstances') is not None:
            self.min_ready_instances = m.get('MinReadyInstances')
        if m.get('ScaleRuleEnabled') is not None:
            self.scale_rule_enabled = m.get('ScaleRuleEnabled')
        if m.get('ScaleRuleName') is not None:
            self.scale_rule_name = m.get('ScaleRuleName')
        if m.get('ScaleRuleType') is not None:
            self.scale_rule_type = m.get('ScaleRuleType')
        if m.get('Timer') is not None:
            temp_model = DescribeApplicationScalingRuleResponseBodyDataTimer()
            self.timer = temp_model.from_map(m['Timer'])
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeApplicationScalingRuleResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeApplicationScalingRuleResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        # The returned data.
        self.data = data
        self.error_code = error_code
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        self.success = success
        # The ID of the trace. The ID is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeApplicationScalingRuleResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationScalingRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationScalingRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationScalingRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationScalingRulesRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # 7171a6ca-d1cd-4928-8642-7d5cfe69\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetrics(TeaModel):
    def __init__(
        self,
        metric_target_average_utilization: int = None,
        metric_type: str = None,
        slb_id: str = None,
        slb_logstore: str = None,
        slb_project: str = None,
        vport: str = None,
    ):
        # The limit on the metric.
        # 
        # *   The limit on the CPU utilization. Unit: percentage.
        # *   The limit on the memory usage. Unit: percentage.
        # *   The limit on the average number of active TCP connections per second.
        # *   The limit on the queries per second (QPS) of the Internet-facing Server Load Balancer (SLB) instance.
        # *   The limit on the response time of the Internet-facing SLB instance. Unit: milliseconds.
        self.metric_target_average_utilization = metric_target_average_utilization
        # The metric that is used to trigger the auto scaling policy. Valid values:
        # 
        # *   **CPU**: the CPU utilization.
        # *   **MEMORY**: the memory usage.
        # *   **tcpActiveConn**: the average number of active TCP connections per second of an application instance in 30 seconds.
        # *   **SLB_QPS**: the average QPS of the Internet-facing SLB instance associated with an application instance in 15 seconds.
        # *   **SLB_RT**: the average response time of the Internet-facing SLB instance in 15 seconds.
        self.metric_type = metric_type
        self.slb_id = slb_id
        self.slb_logstore = slb_logstore
        self.slb_project = slb_project
        self.vport = vport

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.metric_target_average_utilization is not None:
            result['MetricTargetAverageUtilization'] = self.metric_target_average_utilization
        if self.metric_type is not None:
            result['MetricType'] = self.metric_type
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.slb_logstore is not None:
            result['SlbLogstore'] = self.slb_logstore
        if self.slb_project is not None:
            result['SlbProject'] = self.slb_project
        if self.vport is not None:
            result['Vport'] = self.vport
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MetricTargetAverageUtilization') is not None:
            self.metric_target_average_utilization = m.get('MetricTargetAverageUtilization')
        if m.get('MetricType') is not None:
            self.metric_type = m.get('MetricType')
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('SlbLogstore') is not None:
            self.slb_logstore = m.get('SlbLogstore')
        if m.get('SlbProject') is not None:
            self.slb_project = m.get('SlbProject')
        if m.get('Vport') is not None:
            self.vport = m.get('Vport')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatusCurrentMetrics(TeaModel):
    def __init__(
        self,
        current_value: int = None,
        name: str = None,
        type: str = None,
    ):
        # The current value of the metric.
        self.current_value = current_value
        # The name of the metric.
        # 
        # *   **cpu**: the CPU utilization.
        # *   **memory**: the memory usage.
        # *   **tcpActiveConn**: the number of active TCP connections.
        # *   **slb_incall_qps**: the QPS of the Internet-facing SLB instance.
        # *   **slb_incall_rt**: the response time of the Internet-facing SLB instance.
        self.name = name
        # The type of the data. This parameter corresponds to the metric.
        # 
        # *   **Resource**: used when the metric is the **CPU utilization** or **memory usage**.
        # *   **Pods**: used when the metric is the **number of active TCP connections**.
        # *   **External**: used when the metric is about the **SLB** instance or from **Application Real-Time Monitoring Service (ARMS)**.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_value is not None:
            result['CurrentValue'] = self.current_value
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentValue') is not None:
            self.current_value = m.get('CurrentValue')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatusNextScaleMetrics(TeaModel):
    def __init__(
        self,
        name: str = None,
        next_scale_in_average_utilization: int = None,
        next_scale_out_average_utilization: int = None,
    ):
        # The name of the metric.
        # 
        # *   **cpu**: the CPU utilization.
        # *   **memory**: the memory usage.
        # *   **tcpActiveConn**: the number of active TCP connections.
        # *   **slb_incall_qps**: the QPS of the Internet-facing SLB instance.
        # *   **slb_incall_rt**: the response time of the Internet-facing SLB instance.
        self.name = name
        # The metric value as a percentage that triggers the application scale-in next time.
        self.next_scale_in_average_utilization = next_scale_in_average_utilization
        # The metric value as a percentage that triggers the application scale-out next time.
        self.next_scale_out_average_utilization = next_scale_out_average_utilization

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.next_scale_in_average_utilization is not None:
            result['NextScaleInAverageUtilization'] = self.next_scale_in_average_utilization
        if self.next_scale_out_average_utilization is not None:
            result['NextScaleOutAverageUtilization'] = self.next_scale_out_average_utilization
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NextScaleInAverageUtilization') is not None:
            self.next_scale_in_average_utilization = m.get('NextScaleInAverageUtilization')
        if m.get('NextScaleOutAverageUtilization') is not None:
            self.next_scale_out_average_utilization = m.get('NextScaleOutAverageUtilization')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatus(TeaModel):
    def __init__(
        self,
        current_metrics: List[DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatusCurrentMetrics] = None,
        current_replicas: int = None,
        desired_replicas: int = None,
        last_scale_time: str = None,
        max_replicas: int = None,
        min_replicas: int = None,
        next_scale_metrics: List[DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatusNextScaleMetrics] = None,
        next_scale_time_period: int = None,
    ):
        # The metrics that are used to trigger the auto scaling policy this time.
        self.current_metrics = current_metrics
        # The current number of instances.
        self.current_replicas = current_replicas
        # The expected number of instances.
        self.desired_replicas = desired_replicas
        # The time when the auto scaling policy was last triggered.
        self.last_scale_time = last_scale_time
        # The maximum number of instances.
        self.max_replicas = max_replicas
        # The minimum number of instances.
        self.min_replicas = min_replicas
        # The metrics that are used to trigger the auto scaling policy next time.
        self.next_scale_metrics = next_scale_metrics
        # The duration for which the metric-based auto scaling policy takes effect next time.
        self.next_scale_time_period = next_scale_time_period

    def validate(self):
        if self.current_metrics:
            for k in self.current_metrics:
                if k:
                    k.validate()
        if self.next_scale_metrics:
            for k in self.next_scale_metrics:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CurrentMetrics'] = []
        if self.current_metrics is not None:
            for k in self.current_metrics:
                result['CurrentMetrics'].append(k.to_map() if k else None)
        if self.current_replicas is not None:
            result['CurrentReplicas'] = self.current_replicas
        if self.desired_replicas is not None:
            result['DesiredReplicas'] = self.desired_replicas
        if self.last_scale_time is not None:
            result['LastScaleTime'] = self.last_scale_time
        if self.max_replicas is not None:
            result['MaxReplicas'] = self.max_replicas
        if self.min_replicas is not None:
            result['MinReplicas'] = self.min_replicas
        result['NextScaleMetrics'] = []
        if self.next_scale_metrics is not None:
            for k in self.next_scale_metrics:
                result['NextScaleMetrics'].append(k.to_map() if k else None)
        if self.next_scale_time_period is not None:
            result['NextScaleTimePeriod'] = self.next_scale_time_period
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.current_metrics = []
        if m.get('CurrentMetrics') is not None:
            for k in m.get('CurrentMetrics'):
                temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatusCurrentMetrics()
                self.current_metrics.append(temp_model.from_map(k))
        if m.get('CurrentReplicas') is not None:
            self.current_replicas = m.get('CurrentReplicas')
        if m.get('DesiredReplicas') is not None:
            self.desired_replicas = m.get('DesiredReplicas')
        if m.get('LastScaleTime') is not None:
            self.last_scale_time = m.get('LastScaleTime')
        if m.get('MaxReplicas') is not None:
            self.max_replicas = m.get('MaxReplicas')
        if m.get('MinReplicas') is not None:
            self.min_replicas = m.get('MinReplicas')
        self.next_scale_metrics = []
        if m.get('NextScaleMetrics') is not None:
            for k in m.get('NextScaleMetrics'):
                temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatusNextScaleMetrics()
                self.next_scale_metrics.append(temp_model.from_map(k))
        if m.get('NextScaleTimePeriod') is not None:
            self.next_scale_time_period = m.get('NextScaleTimePeriod')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricScaleDownRules(TeaModel):
    def __init__(
        self,
        disabled: bool = None,
        stabilization_window_seconds: int = None,
        step: int = None,
    ):
        # Indicates whether the application scale-in was disabled. Valid values:
        # 
        # *   **true**: The application scale-in was disabled.
        # *   **false**: The application scale-in was enabled.
        # 
        # >  When this parameter is set to true, the application instances will never be reduced. This prevents risks to your business in peak hours. By default, this parameter is set to false.
        self.disabled = disabled
        # The cooldown time of the scale-in. Valid values: 0 to 3600. Unit: seconds. The default value is 0.
        self.stabilization_window_seconds = stabilization_window_seconds
        # The step size for the scale-in. The maximum number of instances that can be reduced in a unit of time.
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.stabilization_window_seconds is not None:
            result['StabilizationWindowSeconds'] = self.stabilization_window_seconds
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('StabilizationWindowSeconds') is not None:
            self.stabilization_window_seconds = m.get('StabilizationWindowSeconds')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricScaleUpRules(TeaModel):
    def __init__(
        self,
        disabled: bool = None,
        stabilization_window_seconds: int = None,
        step: int = None,
    ):
        # Indicates whether the application scale-in was disabled. Valid values:
        # 
        # *   **true**: The application scale-in was disabled.
        # *   **false**: The application scale-in was enabled.
        # 
        # >  When this parameter is set to true, the application instances will never be reduced. This prevents risks to your business in peak hours. By default, this parameter is set to false.
        self.disabled = disabled
        # The cooldown time of the scale-out. Valid values: 0 to 3600. Unit: seconds. The default value is 0.
        self.stabilization_window_seconds = stabilization_window_seconds
        # The step size for the scale-out. The maximum number of instances that can be added in a unit of time.
        self.step = step

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.stabilization_window_seconds is not None:
            result['StabilizationWindowSeconds'] = self.stabilization_window_seconds
        if self.step is not None:
            result['Step'] = self.step
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('StabilizationWindowSeconds') is not None:
            self.stabilization_window_seconds = m.get('StabilizationWindowSeconds')
        if m.get('Step') is not None:
            self.step = m.get('Step')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetric(TeaModel):
    def __init__(
        self,
        max_replicas: int = None,
        metrics: List[DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetrics] = None,
        metrics_status: DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatus = None,
        min_replicas: int = None,
        scale_down_rules: DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricScaleDownRules = None,
        scale_up_rules: DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricScaleUpRules = None,
    ):
        # The maximum number of instances.
        self.max_replicas = max_replicas
        # The list of metrics that are used to trigger the auto scaling policy.
        self.metrics = metrics
        # The execution status of the metric-based auto scaling policy.
        self.metrics_status = metrics_status
        # The minimum number of instances.
        self.min_replicas = min_replicas
        # Rules that determine the application scale-in.
        self.scale_down_rules = scale_down_rules
        # Rules that determine the application scale-out.
        self.scale_up_rules = scale_up_rules

    def validate(self):
        if self.metrics:
            for k in self.metrics:
                if k:
                    k.validate()
        if self.metrics_status:
            self.metrics_status.validate()
        if self.scale_down_rules:
            self.scale_down_rules.validate()
        if self.scale_up_rules:
            self.scale_up_rules.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.max_replicas is not None:
            result['MaxReplicas'] = self.max_replicas
        result['Metrics'] = []
        if self.metrics is not None:
            for k in self.metrics:
                result['Metrics'].append(k.to_map() if k else None)
        if self.metrics_status is not None:
            result['MetricsStatus'] = self.metrics_status.to_map()
        if self.min_replicas is not None:
            result['MinReplicas'] = self.min_replicas
        if self.scale_down_rules is not None:
            result['ScaleDownRules'] = self.scale_down_rules.to_map()
        if self.scale_up_rules is not None:
            result['ScaleUpRules'] = self.scale_up_rules.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MaxReplicas') is not None:
            self.max_replicas = m.get('MaxReplicas')
        self.metrics = []
        if m.get('Metrics') is not None:
            for k in m.get('Metrics'):
                temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetrics()
                self.metrics.append(temp_model.from_map(k))
        if m.get('MetricsStatus') is not None:
            temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricMetricsStatus()
            self.metrics_status = temp_model.from_map(m['MetricsStatus'])
        if m.get('MinReplicas') is not None:
            self.min_replicas = m.get('MinReplicas')
        if m.get('ScaleDownRules') is not None:
            temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricScaleDownRules()
            self.scale_down_rules = temp_model.from_map(m['ScaleDownRules'])
        if m.get('ScaleUpRules') is not None:
            temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetricScaleUpRules()
            self.scale_up_rules = temp_model.from_map(m['ScaleUpRules'])
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesTimerSchedules(TeaModel):
    def __init__(
        self,
        at_time: str = None,
        max_replicas: int = None,
        min_replicas: int = None,
        target_replicas: int = None,
    ):
        # The point in time. Format: **Hour:Minute**.
        self.at_time = at_time
        # The maximum number of instances.
        self.max_replicas = max_replicas
        # The minimum number of instances.
        self.min_replicas = min_replicas
        # The expected number of instances.
        self.target_replicas = target_replicas

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.at_time is not None:
            result['AtTime'] = self.at_time
        if self.max_replicas is not None:
            result['MaxReplicas'] = self.max_replicas
        if self.min_replicas is not None:
            result['MinReplicas'] = self.min_replicas
        if self.target_replicas is not None:
            result['TargetReplicas'] = self.target_replicas
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AtTime') is not None:
            self.at_time = m.get('AtTime')
        if m.get('MaxReplicas') is not None:
            self.max_replicas = m.get('MaxReplicas')
        if m.get('MinReplicas') is not None:
            self.min_replicas = m.get('MinReplicas')
        if m.get('TargetReplicas') is not None:
            self.target_replicas = m.get('TargetReplicas')
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesTimer(TeaModel):
    def __init__(
        self,
        begin_date: str = None,
        end_date: str = None,
        period: str = None,
        schedules: List[DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesTimerSchedules] = None,
    ):
        # The start date of the validity period of the scheduled auto scaling policy. Valid values:
        # 
        # *   If both the **BeginDate** and **EndDate** parameters are set to **null**, the auto scaling policy can always be triggered. The default value for these parameters is null.
        # *   If the two parameters are set to specific dates, the scheduled auto scaling policy can be triggered during the period between the two dates. For example, if **BeginDate** is 2021-03-25 and **EndDate** is 2021-04-25, the auto scaling policy is valid for one month.
        self.begin_date = begin_date
        # The end date of the validity period of the scheduled auto scaling policy. Valid values:
        # 
        # *   If both the **BeginDate** and **EndDate** parameters are set to **null**, the auto scaling policy can always be triggered. The default value for these parameters is null.
        # *   If the two parameters are set to specific dates, the scheduled auto scaling policy can be triggered during the period between the two dates. For example, if **BeginDate** is 2021-03-25 and **EndDate** is 2021-04-25, the auto scaling policy is valid for one month.
        self.end_date = end_date
        # The days on which the scheduled auto scaling policy takes effect. Valid values:
        # 
        # *   **\\* \\* \\***: The scheduled auto scaling policy takes effect at a specified time every day.
        # 
        # *   **\\* \\* Fri,Mon**: The scheduled auto scaling policy takes effect at a specified time on one or multiple days of a week. The specified time is in the GMT+8 time zone. Valid values:
        # 
        #     *   **Sun**: Sunday
        #     *   **Mon**: Monday
        #     *   **Tue**: Tuesday
        #     *   **Wed**: Wednesday
        #     *   **Thu**: Thursday
        #     *   **Fri**: Friday
        #     *   **Sat**: Saturday
        # 
        # *   **1,2,3,28,31 \\* \\***: The scheduled auto scaling policy takes effect at a specified time on one or multiple days of a month. Valid values: 1 to 31. If the month does not have a 31st day, the auto scaling policy takes effect on the specified days other than the 31st day.
        self.period = period
        # The points in time when the auto scaling policy is triggered within one day.
        self.schedules = schedules

    def validate(self):
        if self.schedules:
            for k in self.schedules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.begin_date is not None:
            result['BeginDate'] = self.begin_date
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.period is not None:
            result['Period'] = self.period
        result['Schedules'] = []
        if self.schedules is not None:
            for k in self.schedules:
                result['Schedules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BeginDate') is not None:
            self.begin_date = m.get('BeginDate')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('Period') is not None:
            self.period = m.get('Period')
        self.schedules = []
        if m.get('Schedules') is not None:
            for k in m.get('Schedules'):
                temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesTimerSchedules()
                self.schedules.append(temp_model.from_map(k))
        return self


class DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRules(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        create_time: int = None,
        last_disable_time: int = None,
        metric: DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetric = None,
        min_ready_instance_ratio: int = None,
        min_ready_instances: int = None,
        scale_rule_enabled: bool = None,
        scale_rule_name: str = None,
        scale_rule_type: str = None,
        timer: DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesTimer = None,
        update_time: int = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The time when the auto scaling policy was created. Unit: milliseconds.
        self.create_time = create_time
        # The time when the auto scaling policy was last disabled.
        self.last_disable_time = last_disable_time
        # The details of the metric-based auto scaling policy.
        self.metric = metric
        self.min_ready_instance_ratio = min_ready_instance_ratio
        self.min_ready_instances = min_ready_instances
        # Indicates whether the auto scaling policy is enabled. Valid values:
        # 
        # *   **true**: enabled
        # *   **false**: disabled
        self.scale_rule_enabled = scale_rule_enabled
        # The name of the auto scaling policy.
        self.scale_rule_name = scale_rule_name
        # The type of the auto scaling policy. Valid values:
        # 
        # *   **timing**: the scheduled auto scaling policy.
        # *   **metric**: the metric-based auto scaling policy.
        # *   **mix**: the hybrid auto scaling policy.
        self.scale_rule_type = scale_rule_type
        # The details of the scheduled auto scaling policy.
        self.timer = timer
        # The time when the auto scaling policy was updated. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        if self.metric:
            self.metric.validate()
        if self.timer:
            self.timer.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_disable_time is not None:
            result['LastDisableTime'] = self.last_disable_time
        if self.metric is not None:
            result['Metric'] = self.metric.to_map()
        if self.min_ready_instance_ratio is not None:
            result['MinReadyInstanceRatio'] = self.min_ready_instance_ratio
        if self.min_ready_instances is not None:
            result['MinReadyInstances'] = self.min_ready_instances
        if self.scale_rule_enabled is not None:
            result['ScaleRuleEnabled'] = self.scale_rule_enabled
        if self.scale_rule_name is not None:
            result['ScaleRuleName'] = self.scale_rule_name
        if self.scale_rule_type is not None:
            result['ScaleRuleType'] = self.scale_rule_type
        if self.timer is not None:
            result['Timer'] = self.timer.to_map()
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastDisableTime') is not None:
            self.last_disable_time = m.get('LastDisableTime')
        if m.get('Metric') is not None:
            temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesMetric()
            self.metric = temp_model.from_map(m['Metric'])
        if m.get('MinReadyInstanceRatio') is not None:
            self.min_ready_instance_ratio = m.get('MinReadyInstanceRatio')
        if m.get('MinReadyInstances') is not None:
            self.min_ready_instances = m.get('MinReadyInstances')
        if m.get('ScaleRuleEnabled') is not None:
            self.scale_rule_enabled = m.get('ScaleRuleEnabled')
        if m.get('ScaleRuleName') is not None:
            self.scale_rule_name = m.get('ScaleRuleName')
        if m.get('ScaleRuleType') is not None:
            self.scale_rule_type = m.get('ScaleRuleType')
        if m.get('Timer') is not None:
            temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRulesTimer()
            self.timer = temp_model.from_map(m['Timer'])
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeApplicationScalingRulesResponseBodyData(TeaModel):
    def __init__(
        self,
        application_scaling_rules: List[DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRules] = None,
        current_page: int = None,
        page_size: int = None,
        total_size: int = None,
    ):
        # The auto scaling policies of the application.
        self.application_scaling_rules = application_scaling_rules
        # The number of the returned page.
        self.current_page = current_page
        # The number of entries returned on each page.
        self.page_size = page_size
        # The total number of auto scaling policies.
        self.total_size = total_size

    def validate(self):
        if self.application_scaling_rules:
            for k in self.application_scaling_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ApplicationScalingRules'] = []
        if self.application_scaling_rules is not None:
            for k in self.application_scaling_rules:
                result['ApplicationScalingRules'].append(k.to_map() if k else None)
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.application_scaling_rules = []
        if m.get('ApplicationScalingRules') is not None:
            for k in m.get('ApplicationScalingRules'):
                temp_model = DescribeApplicationScalingRulesResponseBodyDataApplicationScalingRules()
                self.application_scaling_rules.append(temp_model.from_map(k))
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class DescribeApplicationScalingRulesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeApplicationScalingRulesResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        # The returned data.
        self.data = data
        self.error_code = error_code
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        self.success = success
        # The ID of the trace. The ID is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeApplicationScalingRulesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationScalingRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationScalingRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationScalingRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationSlbsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DescribeApplicationSlbsResponseBodyDataInternet(TeaModel):
    def __init__(
        self,
        cookie: str = None,
        cookie_timeout: int = None,
        https_ca_cert_id: str = None,
        https_cert_id: str = None,
        port: int = None,
        protocol: str = None,
        sticky_session: bool = None,
        sticky_session_type: str = None,
        target_port: int = None,
    ):
        self.cookie = cookie
        self.cookie_timeout = cookie_timeout
        self.https_ca_cert_id = https_ca_cert_id
        # The supported protocol.
        self.https_cert_id = https_cert_id
        # The ID of the internal-facing SLB instance.
        self.port = port
        # The container port.
        self.protocol = protocol
        self.sticky_session = sticky_session
        self.sticky_session_type = sticky_session_type
        # The port specified for the SLB listener.
        self.target_port = target_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookie is not None:
            result['Cookie'] = self.cookie
        if self.cookie_timeout is not None:
            result['CookieTimeout'] = self.cookie_timeout
        if self.https_ca_cert_id is not None:
            result['HttpsCaCertId'] = self.https_ca_cert_id
        if self.https_cert_id is not None:
            result['HttpsCertId'] = self.https_cert_id
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.sticky_session is not None:
            result['StickySession'] = self.sticky_session
        if self.sticky_session_type is not None:
            result['StickySessionType'] = self.sticky_session_type
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cookie') is not None:
            self.cookie = m.get('Cookie')
        if m.get('CookieTimeout') is not None:
            self.cookie_timeout = m.get('CookieTimeout')
        if m.get('HttpsCaCertId') is not None:
            self.https_ca_cert_id = m.get('HttpsCaCertId')
        if m.get('HttpsCertId') is not None:
            self.https_cert_id = m.get('HttpsCertId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('StickySession') is not None:
            self.sticky_session = m.get('StickySession')
        if m.get('StickySessionType') is not None:
            self.sticky_session_type = m.get('StickySessionType')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class DescribeApplicationSlbsResponseBodyDataIntranet(TeaModel):
    def __init__(
        self,
        cookie: str = None,
        cookie_timeout: int = None,
        https_ca_cert_id: str = None,
        https_cert_id: str = None,
        port: int = None,
        protocol: str = None,
        sticky_session: bool = None,
        sticky_session_type: str = None,
        target_port: int = None,
    ):
        self.cookie = cookie
        self.cookie_timeout = cookie_timeout
        self.https_ca_cert_id = https_ca_cert_id
        # The supported protocol.
        self.https_cert_id = https_cert_id
        # The IP address of the Internet-facing SLB instance.
        self.port = port
        # The container port.
        self.protocol = protocol
        self.sticky_session = sticky_session
        self.sticky_session_type = sticky_session_type
        # The port specified for the SLB listener.
        self.target_port = target_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cookie is not None:
            result['Cookie'] = self.cookie
        if self.cookie_timeout is not None:
            result['CookieTimeout'] = self.cookie_timeout
        if self.https_ca_cert_id is not None:
            result['HttpsCaCertId'] = self.https_ca_cert_id
        if self.https_cert_id is not None:
            result['HttpsCertId'] = self.https_cert_id
        if self.port is not None:
            result['Port'] = self.port
        if self.protocol is not None:
            result['Protocol'] = self.protocol
        if self.sticky_session is not None:
            result['StickySession'] = self.sticky_session
        if self.sticky_session_type is not None:
            result['StickySessionType'] = self.sticky_session_type
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cookie') is not None:
            self.cookie = m.get('Cookie')
        if m.get('CookieTimeout') is not None:
            self.cookie_timeout = m.get('CookieTimeout')
        if m.get('HttpsCaCertId') is not None:
            self.https_ca_cert_id = m.get('HttpsCaCertId')
        if m.get('HttpsCertId') is not None:
            self.https_cert_id = m.get('HttpsCertId')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('Protocol') is not None:
            self.protocol = m.get('Protocol')
        if m.get('StickySession') is not None:
            self.sticky_session = m.get('StickySession')
        if m.get('StickySessionType') is not None:
            self.sticky_session_type = m.get('StickySessionType')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class DescribeApplicationSlbsResponseBodyData(TeaModel):
    def __init__(
        self,
        internet: List[DescribeApplicationSlbsResponseBodyDataInternet] = None,
        internet_ip: str = None,
        internet_slb_charge_type: str = None,
        internet_slb_expired: bool = None,
        internet_slb_id: str = None,
        intranet: List[DescribeApplicationSlbsResponseBodyDataIntranet] = None,
        intranet_ip: str = None,
        intranet_slb_charge_type: str = None,
        intranet_slb_expired: bool = None,
        intranet_slb_id: str = None,
    ):
        # The ID of the SSL certificate issued by Alibaba Cloud.
        self.internet = internet
        # The ID of the Internet-facing SLB instance.
        self.internet_ip = internet_ip
        self.internet_slb_charge_type = internet_slb_charge_type
        self.internet_slb_expired = internet_slb_expired
        # Configurations of Internet-facing SLB instances.
        self.internet_slb_id = internet_slb_id
        # The ID of the SSL certificate issued by Alibaba Cloud.
        self.intranet = intranet
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.intranet_ip = intranet_ip
        self.intranet_slb_charge_type = intranet_slb_charge_type
        self.intranet_slb_expired = intranet_slb_expired
        # The IP address of the internal-facing SLB instance.
        self.intranet_slb_id = intranet_slb_id

    def validate(self):
        if self.internet:
            for k in self.internet:
                if k:
                    k.validate()
        if self.intranet:
            for k in self.intranet:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Internet'] = []
        if self.internet is not None:
            for k in self.internet:
                result['Internet'].append(k.to_map() if k else None)
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.internet_slb_charge_type is not None:
            result['InternetSlbChargeType'] = self.internet_slb_charge_type
        if self.internet_slb_expired is not None:
            result['InternetSlbExpired'] = self.internet_slb_expired
        if self.internet_slb_id is not None:
            result['InternetSlbId'] = self.internet_slb_id
        result['Intranet'] = []
        if self.intranet is not None:
            for k in self.intranet:
                result['Intranet'].append(k.to_map() if k else None)
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.intranet_slb_charge_type is not None:
            result['IntranetSlbChargeType'] = self.intranet_slb_charge_type
        if self.intranet_slb_expired is not None:
            result['IntranetSlbExpired'] = self.intranet_slb_expired
        if self.intranet_slb_id is not None:
            result['IntranetSlbId'] = self.intranet_slb_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.internet = []
        if m.get('Internet') is not None:
            for k in m.get('Internet'):
                temp_model = DescribeApplicationSlbsResponseBodyDataInternet()
                self.internet.append(temp_model.from_map(k))
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('InternetSlbChargeType') is not None:
            self.internet_slb_charge_type = m.get('InternetSlbChargeType')
        if m.get('InternetSlbExpired') is not None:
            self.internet_slb_expired = m.get('InternetSlbExpired')
        if m.get('InternetSlbId') is not None:
            self.internet_slb_id = m.get('InternetSlbId')
        self.intranet = []
        if m.get('Intranet') is not None:
            for k in m.get('Intranet'):
                temp_model = DescribeApplicationSlbsResponseBodyDataIntranet()
                self.intranet.append(temp_model.from_map(k))
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('IntranetSlbChargeType') is not None:
            self.intranet_slb_charge_type = m.get('IntranetSlbChargeType')
        if m.get('IntranetSlbExpired') is not None:
            self.intranet_slb_expired = m.get('IntranetSlbExpired')
        if m.get('IntranetSlbId') is not None:
            self.intranet_slb_id = m.get('IntranetSlbId')
        return self


class DescribeApplicationSlbsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeApplicationSlbsResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the information about the SLB instances that are associated with an application was obtained successfully. Valid values:
        # 
        # *   **true**: indicates that the information was obtained successfully.
        # *   **false**: indicates that the information failed to be obtained.
        self.code = code
        # Configurations of internal-facing SLB instances.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.error_code = error_code
        # The ID of the trace. It can be used to query the details of a request.
        self.message = message
        # The returned message.
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error code is returned when the request fails.
        self.request_id = request_id
        self.success = success
        # The returned data.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeApplicationSlbsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationSlbsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationSlbsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationSlbsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeApplicationStatusRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
    ):
        # 0099b7be-5f5b-4512-a7fc-56049ef1\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.app_id = app_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        return self


class DescribeApplicationStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        arms_advanced_enabled: str = None,
        arms_apm_info: str = None,
        create_time: str = None,
        current_status: str = None,
        enable_agent: bool = None,
        file_size_limit: int = None,
        last_change_order_id: str = None,
        last_change_order_running: bool = None,
        last_change_order_status: str = None,
        running_instances: int = None,
        sub_status: str = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # Indicates whether Application Real-Time Monitoring Service (ARMS) advanced monitoring is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.arms_advanced_enabled = arms_advanced_enabled
        # The metadata of the application in ARMS.
        self.arms_apm_info = arms_apm_info
        # The time when the application was created.
        self.create_time = create_time
        # The current state of the application. Valid values:
        # 
        # *   **RUNNING**\
        # *   **STOPPED**\
        # *   **UNKNOWN**\
        self.current_status = current_status
        # Indicates whether SAE agent is enabled.
        # 
        # *   **true**\
        # *   **false**\
        self.enable_agent = enable_agent
        # The file size limit. Unit: KB. Valid values: 0 to 10240.
        self.file_size_limit = file_size_limit
        # The ID of the latest change order that is executed. If no change orders have been executed or if change orders have expired, an empty parameter is returned.
        self.last_change_order_id = last_change_order_id
        # Indicates whether the latest change order is being executed. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.last_change_order_running = last_change_order_running
        # The state of the latest change order. Valid values:
        # 
        # *   **READY**: The change order is ready.
        # *   **RUNNING**: The change order is being executed.
        # *   **SUCCESS**: The change order was executed successfully.
        # *   **FAIL**: The change order failed to be executed.
        # *   **ABORT**: The change order is stopped.
        # *   **WAIT_BATCH_CONFIRM**: The change order is pending execution. You must manually confirm the release batch.
        # *   **AUTO_BATCH_WAIT**: The change order is pending execution. SAE will automatically confirm the release batch.
        # *   **SYSTEM_FAIL**: A system exception occurred.
        # *   **WAIT_APPROVAL**: The change order is pending approval.
        # *   **APPROVED**: The change order is approved and is pending execution.
        self.last_change_order_status = last_change_order_status
        # The number of running instances of the application.
        self.running_instances = running_instances
        # Indicates whether an error occurred while the change order was being executed. Valid values:
        # 
        # *   **NORMAL**\
        # *   **RUNNING_BUT_HAS_ERROR** If an error occurs during a batch release, you must manually perform a rollback. In this case, the change order is still running because the task is not completed, but the state of the change order is RUNNING_BUT_HAS_ERROR.
        self.sub_status = sub_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.arms_advanced_enabled is not None:
            result['ArmsAdvancedEnabled'] = self.arms_advanced_enabled
        if self.arms_apm_info is not None:
            result['ArmsApmInfo'] = self.arms_apm_info
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.current_status is not None:
            result['CurrentStatus'] = self.current_status
        if self.enable_agent is not None:
            result['EnableAgent'] = self.enable_agent
        if self.file_size_limit is not None:
            result['FileSizeLimit'] = self.file_size_limit
        if self.last_change_order_id is not None:
            result['LastChangeOrderId'] = self.last_change_order_id
        if self.last_change_order_running is not None:
            result['LastChangeOrderRunning'] = self.last_change_order_running
        if self.last_change_order_status is not None:
            result['LastChangeOrderStatus'] = self.last_change_order_status
        if self.running_instances is not None:
            result['RunningInstances'] = self.running_instances
        if self.sub_status is not None:
            result['SubStatus'] = self.sub_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('ArmsAdvancedEnabled') is not None:
            self.arms_advanced_enabled = m.get('ArmsAdvancedEnabled')
        if m.get('ArmsApmInfo') is not None:
            self.arms_apm_info = m.get('ArmsApmInfo')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CurrentStatus') is not None:
            self.current_status = m.get('CurrentStatus')
        if m.get('EnableAgent') is not None:
            self.enable_agent = m.get('EnableAgent')
        if m.get('FileSizeLimit') is not None:
            self.file_size_limit = m.get('FileSizeLimit')
        if m.get('LastChangeOrderId') is not None:
            self.last_change_order_id = m.get('LastChangeOrderId')
        if m.get('LastChangeOrderRunning') is not None:
            self.last_change_order_running = m.get('LastChangeOrderRunning')
        if m.get('LastChangeOrderStatus') is not None:
            self.last_change_order_status = m.get('LastChangeOrderStatus')
        if m.get('RunningInstances') is not None:
            self.running_instances = m.get('RunningInstances')
        if m.get('SubStatus') is not None:
            self.sub_status = m.get('SubStatus')
        return self


class DescribeApplicationStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeApplicationStatusResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The error code.
        # 
        # *   If the request is successful, this parameter is not returned.****\
        # *   This parameter is returned only if the request failed.**** For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message. Valid values:
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error code is returned when the request fails.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether information of the application is successfully obtained. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeApplicationStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeApplicationStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeApplicationStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeApplicationStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeChangeOrderRequest(TeaModel):
    def __init__(
        self,
        change_order_id: str = None,
    ):
        # 76fa5c0-9ebb-4bb4-b383-1f885447\\*\\*\\*\\*\
        # 
        # This parameter is required.
        self.change_order_id = change_order_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        return self


class DescribeChangeOrderResponseBodyDataPipelines(TeaModel):
    def __init__(
        self,
        batch_type: int = None,
        parallel_count: int = None,
        pipeline_id: str = None,
        pipeline_name: str = None,
        start_time: int = None,
        status: int = None,
        update_time: int = None,
    ):
        # The batch type.
        self.batch_type = batch_type
        # The number of parallel tasks in a batch.
        self.parallel_count = parallel_count
        # The ID of the batch.
        self.pipeline_id = pipeline_id
        # The name of the batch.
        self.pipeline_name = pipeline_name
        # The time when the batch processing starts.
        self.start_time = start_time
        # The status of the batch. Valid values:
        # 
        # *   **0**: The batch is being prepared.
        # *   **1**: The batch is being processed.
        # *   **2**: The batch was processed.
        # *   **3**: The batch could not be processed.
        # *   **6**: The batch processing was terminated.
        # *   **8**: The execution process is pending. You must manually determine the release batch.
        # *   **9**: The execution process is pending. SAE will automatically determine the release batch.
        # *   **10**: The batch could not be processed due to a system exception.
        # *   **11**: The change order is pending approval.
        # *   **12**: The change order is approved and is pending execution.
        self.status = status
        # The time when the batch information is last modified.
        self.update_time = update_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_type is not None:
            result['BatchType'] = self.batch_type
        if self.parallel_count is not None:
            result['ParallelCount'] = self.parallel_count
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        if self.pipeline_name is not None:
            result['PipelineName'] = self.pipeline_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BatchType') is not None:
            self.batch_type = m.get('BatchType')
        if m.get('ParallelCount') is not None:
            self.parallel_count = m.get('ParallelCount')
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        if m.get('PipelineName') is not None:
            self.pipeline_name = m.get('PipelineName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeChangeOrderResponseBodyData(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        approval_id: str = None,
        auto: bool = None,
        batch_count: int = None,
        batch_type: str = None,
        batch_wait_time: int = None,
        change_order_id: str = None,
        co_type: str = None,
        co_type_code: str = None,
        create_time: str = None,
        current_pipeline_id: str = None,
        description: str = None,
        error_message: str = None,
        pipelines: List[DescribeChangeOrderResponseBodyDataPipelines] = None,
        status: int = None,
        sub_status: int = None,
        support_rollback: bool = None,
    ):
        # The ID of the application.
        self.app_id = app_id
        # The name of the application.
        self.app_name = app_name
        # The approval ID of the change order.
        self.approval_id = approval_id
        # Indicates whether SAE automatically determines the release batches. Valid values:
        # 
        # *   **true**: SAE automatically determines the release batches.
        # *   **false**: SAE does not automatically determine the release batches.
        self.auto = auto
        # The number of release batches.
        self.batch_count = batch_count
        # The mode in which the release batches are determined. Valid values:
        # 
        # *   **auto**: SAE automatically determines the release batches.
        # *   **Manual**: You must manually determine the release batches.
        self.batch_type = batch_type
        # The interval between batches when SAE automatically determines the release batches in a phased release. Unit: minutes.
        self.batch_wait_time = batch_wait_time
        # The ID of the change order.
        self.change_order_id = change_order_id
        # The description about the change type, which corresponds to the **CoTypeCode** parameter.
        self.co_type = co_type
        # The code of the change type. Valid values:
        # 
        # *   **CoBindSlb**: associates the Server Load Balancer (SLB) instance with the application.
        # *   **CoUnbindSlb**: disassociates the SLB instance from the application.
        # *   **CoCreateApp**: creates the application.
        # *   **CoDeleteApp**: deletes the application.
        # *   **CoDeploy**: deploys the application.
        # *   **CoRestartApplication**: restarts the application.
        # *   **CoRollback**: rolls back the application.
        # *   **CoScaleIn**: scales in the application.
        # *   **CoScaleOut**: scales out the application.
        # *   **CoStart**: starts the application.
        # *   **CoStop**: stops the application.
        # *   **CoRescaleApplicationVertically**: modifies the instance specifications.
        # *   **CoDeployHistroy**: rolls back the application to a historical version.
        # *   **CoBindNas**: associates a network-attached storage (NAS) file system with the application.
        # *   **CoUnbindNas**: disassociates the NAS file system from the application.
        # *   **CoBatchStartApplication**: starts multiple applications concurrently.
        # *   **CoBatchStopApplication**: stops multiple applications concurrently.
        # *   **CoRestartInstances**: restarts the instances.
        # *   **CoDeleteInstances**: deletes the instances.
        # *   **CoScaleInAppWithInstances**: reduces the number of specified application instances.
        self.co_type_code = co_type_code
        # The time when the change order was created.
        self.create_time = create_time
        # The ID of the current batch.
        self.current_pipeline_id = current_pipeline_id
        # The description of the change order.
        self.description = description
        # The error message.
        self.error_message = error_message
        # The batch information.
        self.pipelines = pipelines
        # The status of the change order. Valid values:
        # 
        # *   **0**: The change order is being prepared.
        # *   **1**: The change order is being executed.
        # *   **2**: The change order was executed.
        # *   **3**: The change order could not be executed.
        # *   **6**: The change order was terminated.
        # *   **8**: The execution process is pending. You must manually determine the release batch.
        # *   **9**: The execution process is pending. SAE will automatically determine the release batches.
        # *   **10**: The execution failed due to a system exception.
        # *   **11**: The change order is pending approval.
        # *   **12**: The change order is approved and is pending execution.
        self.status = status
        # The substatus of the change order. This parameter indicates whether an exception occurred while the change order was being executed. Valid values:
        # 
        # *   **0**: No exception occurred.
        # *   **1**: An exception occurred. For example, when an error occurred during a phased release, you must manually roll back the application. In this case, the change order cannot be completed, so the Status parameter is still displayed as "1", which indicates that the change order is being executed. You can check the value of this parameter to determine whether an exception occurs.
        self.sub_status = sub_status
        # Indicates whether the application can be rolled back. Valid values:
        # 
        # *   **true**: The application can be rolled back.
        # *   **false**: The application cannot be rolled back.
        self.support_rollback = support_rollback

    def validate(self):
        if self.pipelines:
            for k in self.pipelines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.approval_id is not None:
            result['ApprovalId'] = self.approval_id
        if self.auto is not None:
            result['Auto'] = self.auto
        if self.batch_count is not None:
            result['BatchCount'] = self.batch_count
        if self.batch_type is not None:
            result['BatchType'] = self.batch_type
        if self.batch_wait_time is not None:
            result['BatchWaitTime'] = self.batch_wait_time
        if self.change_order_id is not None:
            result['ChangeOrderId'] = self.change_order_id
        if self.co_type is not None:
            result['CoType'] = self.co_type
        if self.co_type_code is not None:
            result['CoTypeCode'] = self.co_type_code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.current_pipeline_id is not None:
            result['CurrentPipelineId'] = self.current_pipeline_id
        if self.description is not None:
            result['Description'] = self.description
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        result['Pipelines'] = []
        if self.pipelines is not None:
            for k in self.pipelines:
                result['Pipelines'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.sub_status is not None:
            result['SubStatus'] = self.sub_status
        if self.support_rollback is not None:
            result['SupportRollback'] = self.support_rollback
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ApprovalId') is not None:
            self.approval_id = m.get('ApprovalId')
        if m.get('Auto') is not None:
            self.auto = m.get('Auto')
        if m.get('BatchCount') is not None:
            self.batch_count = m.get('BatchCount')
        if m.get('BatchType') is not None:
            self.batch_type = m.get('BatchType')
        if m.get('BatchWaitTime') is not None:
            self.batch_wait_time = m.get('BatchWaitTime')
        if m.get('ChangeOrderId') is not None:
            self.change_order_id = m.get('ChangeOrderId')
        if m.get('CoType') is not None:
            self.co_type = m.get('CoType')
        if m.get('CoTypeCode') is not None:
            self.co_type_code = m.get('CoTypeCode')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CurrentPipelineId') is not None:
            self.current_pipeline_id = m.get('CurrentPipelineId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        self.pipelines = []
        if m.get('Pipelines') is not None:
            for k in m.get('Pipelines'):
                temp_model = DescribeChangeOrderResponseBodyDataPipelines()
                self.pipelines.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SubStatus') is not None:
            self.sub_status = m.get('SubStatus')
        if m.get('SupportRollback') is not None:
            self.support_rollback = m.get('SupportRollback')
        return self


class DescribeChangeOrderResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeChangeOrderResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The details of the change order.
        self.data = data
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the information of a change order was obtained. Valid values:
        # 
        # *   **true**: The information was obtained.
        # *   **false**: The information could not be obtained.
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeChangeOrderResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeChangeOrderResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeChangeOrderResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeChangeOrderResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeComponentsRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        type: str = None,
    ):
        # TOMCAT
        self.app_id = app_id
        # The ID of the request.
        # 
        # This parameter is required.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeComponentsResponseBodyData(TeaModel):
    def __init__(
        self,
        component_description: str = None,
        component_key: str = None,
        expired: bool = None,
        type: str = None,
    ):
        # Indicates whether the component is expired. Valid values:
        # 
        # *   **true**: The component is expired.
        # *   **false**: The component is not expired.
        self.component_description = component_description
        # The description of the component.
        self.component_key = component_key
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.expired = expired
        # The ID of the component.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.component_description is not None:
            result['ComponentDescription'] = self.component_description
        if self.component_key is not None:
            result['ComponentKey'] = self.component_key
        if self.expired is not None:
            result['Expired'] = self.expired
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ComponentDescription') is not None:
            self.component_description = m.get('ComponentDescription')
        if m.get('ComponentKey') is not None:
            self.component_key = m.get('ComponentKey')
        if m.get('Expired') is not None:
            self.expired = m.get('Expired')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeComponentsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[DescribeComponentsResponseBodyData] = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the component version was obtained. Valid values:
        # 
        # *   **true**: indicates that the component version was obtained.
        # *   **false**: indicates that the component version could not be obtained.
        self.code = code
        # The component type.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.error_code = error_code
        # The ID of the trace. It is used to query the details of a request.
        self.message = message
        # The returned message.
        self.request_id = request_id
        self.success = success
        # The details of the component.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeComponentsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeComponentsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeComponentsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeComponentsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConfigMapRequest(TeaModel):
    def __init__(
        self,
        config_map_id: int = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.config_map_id = config_map_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_id is not None:
            result['ConfigMapId'] = self.config_map_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigMapId') is not None:
            self.config_map_id = m.get('ConfigMapId')
        return self


class DescribeConfigMapResponseBodyDataRelateApps(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
    ):
        # The ID of the ConfigMap instance.
        self.app_id = app_id
        # The ID of the application.
        self.app_name = app_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        return self


class DescribeConfigMapResponseBodyData(TeaModel):
    def __init__(
        self,
        config_map_id: int = None,
        create_time: int = None,
        data: Dict[str, Any] = None,
        description: str = None,
        name: str = None,
        namespace_id: str = None,
        relate_apps: List[DescribeConfigMapResponseBodyDataRelateApps] = None,
        update_time: int = None,
    ):
        # The name of the ConfigMap instance.
        self.config_map_id = config_map_id
        # The application that is associated with the instance.
        self.create_time = create_time
        # The ID of the namespace to which the instance belongs.
        self.data = data
        # The time when the instance was created.
        self.description = description
        # The returned error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section of this topic.
        self.name = name
        # The description of the instance.
        self.namespace_id = namespace_id
        # The name of the application.
        self.relate_apps = relate_apps
        # The data of ConfigMap key-value pairs. Format:
        # 
        # {"k1":"v1", "k2":"v2"}
        # 
        # k specifies a key and v specifies a value. For more information, see [Manage and use configurations](https://help.aliyun.com/document_detail/171326.html).
        self.update_time = update_time

    def validate(self):
        if self.relate_apps:
            for k in self.relate_apps:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_id is not None:
            result['ConfigMapId'] = self.config_map_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.data is not None:
            result['Data'] = self.data
        if self.description is not None:
            result['Description'] = self.description
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        result['RelateApps'] = []
        if self.relate_apps is not None:
            for k in self.relate_apps:
                result['RelateApps'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigMapId') is not None:
            self.config_map_id = m.get('ConfigMapId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        self.relate_apps = []
        if m.get('RelateApps') is not None:
            for k in m.get('RelateApps'):
                temp_model = DescribeConfigMapResponseBodyDataRelateApps()
                self.relate_apps.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeConfigMapResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeConfigMapResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the details of the ConfigMap instance were obtained. Valid values:
        # 
        # *   **true**: The details were obtained.
        # *   **false**: The details failed to be obtained.
        self.code = code
        # The time when the instance was last modified.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the call was successful.
        # *   **3xx**: indicates that the call was redirected.
        # *   **4xx**: indicates that the call failed.
        # *   **5xx**: indicates that a server error occurred.
        self.error_code = error_code
        # The ID of the trace. The ID is used to query the details of a request.
        self.message = message
        # The returned information. Valid values:
        # 
        # *   If the call is successful, **success** is returned.
        # *   If the call fails, an error code is returned.
        self.request_id = request_id
        self.success = success
        # The returned result.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeConfigMapResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeConfigMapResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeConfigMapResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeConfigMapResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConfigurationPriceRequest(TeaModel):
    def __init__(
        self,
        cpu: int = None,
        memory: int = None,
        workload: str = None,
    ):
        # This parameter is required.
        self.cpu = cpu
        # This parameter is required.
        self.memory = memory
        self.workload = workload

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.workload is not None:
            result['Workload'] = self.workload
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Workload') is not None:
            self.workload = m.get('Workload')
        return self


class DescribeConfigurationPriceResponseBodyDataBagUsage(TeaModel):
    def __init__(
        self,
        cpu: float = None,
        mem: float = None,
    ):
        self.cpu = cpu
        self.mem = mem

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.mem is not None:
            result['Mem'] = self.mem
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        return self


class DescribeConfigurationPriceResponseBodyDataCpuMemPriceOrder(TeaModel):
    def __init__(
        self,
        discount_amount: float = None,
        original_amount: float = None,
        rule_ids: List[str] = None,
        trade_amount: float = None,
    ):
        self.discount_amount = discount_amount
        self.original_amount = original_amount
        self.rule_ids = rule_ids
        self.trade_amount = trade_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_amount is not None:
            result['DiscountAmount'] = self.discount_amount
        if self.original_amount is not None:
            result['OriginalAmount'] = self.original_amount
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.trade_amount is not None:
            result['TradeAmount'] = self.trade_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiscountAmount') is not None:
            self.discount_amount = m.get('DiscountAmount')
        if m.get('OriginalAmount') is not None:
            self.original_amount = m.get('OriginalAmount')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('TradeAmount') is not None:
            self.trade_amount = m.get('TradeAmount')
        return self


class DescribeConfigurationPriceResponseBodyDataCpuMemPriceRules(TeaModel):
    def __init__(
        self,
        name: str = None,
        rule_desc_id: float = None,
    ):
        self.name = name
        self.rule_desc_id = rule_desc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc_id is not None:
            result['RuleDescId'] = self.rule_desc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDescId') is not None:
            self.rule_desc_id = m.get('RuleDescId')
        return self


class DescribeConfigurationPriceResponseBodyDataCpuMemPrice(TeaModel):
    def __init__(
        self,
        order: DescribeConfigurationPriceResponseBodyDataCpuMemPriceOrder = None,
        rules: List[DescribeConfigurationPriceResponseBodyDataCpuMemPriceRules] = None,
    ):
        self.order = order
        self.rules = rules

    def validate(self):
        if self.order:
            self.order.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataCpuMemPriceOrder()
            self.order = temp_model.from_map(m['Order'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeConfigurationPriceResponseBodyDataCpuMemPriceRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeConfigurationPriceResponseBodyDataOrder(TeaModel):
    def __init__(
        self,
        discount_amount: float = None,
        original_amount: float = None,
        rule_ids: List[str] = None,
        trade_amount: float = None,
    ):
        self.discount_amount = discount_amount
        self.original_amount = original_amount
        self.rule_ids = rule_ids
        self.trade_amount = trade_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_amount is not None:
            result['DiscountAmount'] = self.discount_amount
        if self.original_amount is not None:
            result['OriginalAmount'] = self.original_amount
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.trade_amount is not None:
            result['TradeAmount'] = self.trade_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiscountAmount') is not None:
            self.discount_amount = m.get('DiscountAmount')
        if m.get('OriginalAmount') is not None:
            self.original_amount = m.get('OriginalAmount')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('TradeAmount') is not None:
            self.trade_amount = m.get('TradeAmount')
        return self


class DescribeConfigurationPriceResponseBodyDataRequestPriceOrder(TeaModel):
    def __init__(
        self,
        discount_amount: float = None,
        original_amount: float = None,
        rule_ids: List[str] = None,
        trade_amount: float = None,
    ):
        self.discount_amount = discount_amount
        self.original_amount = original_amount
        self.rule_ids = rule_ids
        self.trade_amount = trade_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_amount is not None:
            result['DiscountAmount'] = self.discount_amount
        if self.original_amount is not None:
            result['OriginalAmount'] = self.original_amount
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.trade_amount is not None:
            result['TradeAmount'] = self.trade_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiscountAmount') is not None:
            self.discount_amount = m.get('DiscountAmount')
        if m.get('OriginalAmount') is not None:
            self.original_amount = m.get('OriginalAmount')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('TradeAmount') is not None:
            self.trade_amount = m.get('TradeAmount')
        return self


class DescribeConfigurationPriceResponseBodyDataRequestPriceRules(TeaModel):
    def __init__(
        self,
        name: str = None,
        rule_desc_id: int = None,
    ):
        self.name = name
        self.rule_desc_id = rule_desc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc_id is not None:
            result['RuleDescId'] = self.rule_desc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDescId') is not None:
            self.rule_desc_id = m.get('RuleDescId')
        return self


class DescribeConfigurationPriceResponseBodyDataRequestPrice(TeaModel):
    def __init__(
        self,
        order: DescribeConfigurationPriceResponseBodyDataRequestPriceOrder = None,
        rules: List[DescribeConfigurationPriceResponseBodyDataRequestPriceRules] = None,
    ):
        self.order = order
        self.rules = rules

    def validate(self):
        if self.order:
            self.order.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataRequestPriceOrder()
            self.order = temp_model.from_map(m['Order'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeConfigurationPriceResponseBodyDataRequestPriceRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeConfigurationPriceResponseBodyDataRules(TeaModel):
    def __init__(
        self,
        name: str = None,
        rule_desc_id: int = None,
    ):
        self.name = name
        self.rule_desc_id = rule_desc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc_id is not None:
            result['RuleDescId'] = self.rule_desc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDescId') is not None:
            self.rule_desc_id = m.get('RuleDescId')
        return self


class DescribeConfigurationPriceResponseBodyDataTrafficPriceOrder(TeaModel):
    def __init__(
        self,
        discount_amount: float = None,
        original_amount: float = None,
        rule_ids: List[str] = None,
        trade_amount: float = None,
    ):
        self.discount_amount = discount_amount
        self.original_amount = original_amount
        self.rule_ids = rule_ids
        self.trade_amount = trade_amount

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.discount_amount is not None:
            result['DiscountAmount'] = self.discount_amount
        if self.original_amount is not None:
            result['OriginalAmount'] = self.original_amount
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        if self.trade_amount is not None:
            result['TradeAmount'] = self.trade_amount
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DiscountAmount') is not None:
            self.discount_amount = m.get('DiscountAmount')
        if m.get('OriginalAmount') is not None:
            self.original_amount = m.get('OriginalAmount')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        if m.get('TradeAmount') is not None:
            self.trade_amount = m.get('TradeAmount')
        return self


class DescribeConfigurationPriceResponseBodyDataTrafficPriceRules(TeaModel):
    def __init__(
        self,
        name: str = None,
        rule_desc_id: float = None,
    ):
        self.name = name
        self.rule_desc_id = rule_desc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_desc_id is not None:
            result['RuleDescId'] = self.rule_desc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleDescId') is not None:
            self.rule_desc_id = m.get('RuleDescId')
        return self


class DescribeConfigurationPriceResponseBodyDataTrafficPrice(TeaModel):
    def __init__(
        self,
        order: DescribeConfigurationPriceResponseBodyDataTrafficPriceOrder = None,
        rules: List[DescribeConfigurationPriceResponseBodyDataTrafficPriceRules] = None,
    ):
        self.order = order
        self.rules = rules

    def validate(self):
        if self.order:
            self.order.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.order is not None:
            result['Order'] = self.order.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Order') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataTrafficPriceOrder()
            self.order = temp_model.from_map(m['Order'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeConfigurationPriceResponseBodyDataTrafficPriceRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeConfigurationPriceResponseBodyData(TeaModel):
    def __init__(
        self,
        bag_usage: DescribeConfigurationPriceResponseBodyDataBagUsage = None,
        cpu_mem_price: DescribeConfigurationPriceResponseBodyDataCpuMemPrice = None,
        order: DescribeConfigurationPriceResponseBodyDataOrder = None,
        request_price: DescribeConfigurationPriceResponseBodyDataRequestPrice = None,
        rules: List[DescribeConfigurationPriceResponseBodyDataRules] = None,
        traffic_price: DescribeConfigurationPriceResponseBodyDataTrafficPrice = None,
    ):
        self.bag_usage = bag_usage
        self.cpu_mem_price = cpu_mem_price
        self.order = order
        self.request_price = request_price
        self.rules = rules
        self.traffic_price = traffic_price

    def validate(self):
        if self.bag_usage:
            self.bag_usage.validate()
        if self.cpu_mem_price:
            self.cpu_mem_price.validate()
        if self.order:
            self.order.validate()
        if self.request_price:
            self.request_price.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()
        if self.traffic_price:
            self.traffic_price.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bag_usage is not None:
            result['BagUsage'] = self.bag_usage.to_map()
        if self.cpu_mem_price is not None:
            result['CpuMemPrice'] = self.cpu_mem_price.to_map()
        if self.order is not None:
            result['Order'] = self.order.to_map()
        if self.request_price is not None:
            result['RequestPrice'] = self.request_price.to_map()
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        if self.traffic_price is not None:
            result['TrafficPrice'] = self.traffic_price.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BagUsage') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataBagUsage()
            self.bag_usage = temp_model.from_map(m['BagUsage'])
        if m.get('CpuMemPrice') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataCpuMemPrice()
            self.cpu_mem_price = temp_model.from_map(m['CpuMemPrice'])
        if m.get('Order') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataOrder()
            self.order = temp_model.from_map(m['Order'])
        if m.get('RequestPrice') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataRequestPrice()
            self.request_price = temp_model.from_map(m['RequestPrice'])
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeConfigurationPriceResponseBodyDataRules()
                self.rules.append(temp_model.from_map(k))
        if m.get('TrafficPrice') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyDataTrafficPrice()
            self.traffic_price = temp_model.from_map(m['TrafficPrice'])
        return self


class DescribeConfigurationPriceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeConfigurationPriceResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        self.data = data
        self.error_code = error_code
        self.message = message
        self.request_id = request_id
        self.success = success
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeConfigurationPriceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeConfigurationPriceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeConfigurationPriceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeConfigurationPriceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEdasContainersResponseBodyData(TeaModel):
    def __init__(
        self,
        disabled: bool = None,
        edas_container_version: str = None,
    ):
        # Indicates whether the component is disabled. Valid values:
        # 
        # *   **true**: indicates that the component is disabled.
        # *   **false**: indicates that the component is not disabled.
        self.disabled = disabled
        # The version of the container, such as Ali-Tomcat, in which a High-speed Service Framework (HSF) application runs.
        self.edas_container_version = edas_container_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.disabled is not None:
            result['Disabled'] = self.disabled
        if self.edas_container_version is not None:
            result['EdasContainerVersion'] = self.edas_container_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Disabled') is not None:
            self.disabled = m.get('Disabled')
        if m.get('EdasContainerVersion') is not None:
            self.edas_container_version = m.get('EdasContainerVersion')
        return self


class DescribeEdasContainersResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[DescribeEdasContainersResponseBodyData] = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The list of components.
        self.data = data
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the list of container components of a microservice application was obtained. Valid values:
        # 
        # *   **true**: indicates that the list was obtained.
        # *   **false**: indicates that the list could not be obtained.
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeEdasContainersResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeEdasContainersResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEdasContainersResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEdasContainersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGreyTagRouteRequest(TeaModel):
    def __init__(
        self,
        grey_tag_route_id: int = None,
    ):
        # The ID of the canary release rule.
        # 
        # This parameter is required.
        self.grey_tag_route_id = grey_tag_route_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grey_tag_route_id is not None:
            result['GreyTagRouteId'] = self.grey_tag_route_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GreyTagRouteId') is not None:
            self.grey_tag_route_id = m.get('GreyTagRouteId')
        return self


class DescribeGreyTagRouteResponseBodyDataAlbRulesItems(TeaModel):
    def __init__(
        self,
        cond: str = None,
        expr: str = None,
        index: int = None,
        name: str = None,
        operator: str = None,
        type: str = None,
        value: str = None,
    ):
        # Valid value: ==.
        self.cond = cond
        # This parameter is not returned for applications that are associated with ALB instances.
        self.expr = expr
        # This parameter is not returned for applications that are associated with Application Load Balancer (ALB) instances.
        self.index = index
        # The name of the parameter.
        self.name = name
        # The operator. Valid value: **rawvalue**. This value indicates direct comparison.
        self.operator = operator
        # The type of the comparison. Valid values:
        # 
        # *   **sourceIp**: SourceIp
        # *   **cookie**: cookie
        # *   **header**: header
        self.type = type
        # The value of the parameter. This value is compared with the value that is obtained based on the type and name parameters.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cond is not None:
            result['cond'] = self.cond
        if self.expr is not None:
            result['expr'] = self.expr
        if self.index is not None:
            result['index'] = self.index
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cond') is not None:
            self.cond = m.get('cond')
        if m.get('expr') is not None:
            self.expr = m.get('expr')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class DescribeGreyTagRouteResponseBodyDataAlbRules(TeaModel):
    def __init__(
        self,
        condition: str = None,
        ingress_id: str = None,
        items: List[DescribeGreyTagRouteResponseBodyDataAlbRulesItems] = None,
        service_id: str = None,
    ):
        # The condition mode of the canary release rule. Valid value: AND. This value indicates that that all conditions must be met.
        self.condition = condition
        # The ID of the gateway routing rule.
        self.ingress_id = ingress_id
        self.items = items
        # The service ID.
        self.service_id = service_id

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition
        if self.ingress_id is not None:
            result['ingressId'] = self.ingress_id
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.service_id is not None:
            result['serviceId'] = self.service_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            self.condition = m.get('condition')
        if m.get('ingressId') is not None:
            self.ingress_id = m.get('ingressId')
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = DescribeGreyTagRouteResponseBodyDataAlbRulesItems()
                self.items.append(temp_model.from_map(k))
        if m.get('serviceId') is not None:
            self.service_id = m.get('serviceId')
        return self


class DescribeGreyTagRouteResponseBodyDataDubboRulesItems(TeaModel):
    def __init__(
        self,
        cond: str = None,
        expr: str = None,
        index: int = None,
        name: str = None,
        operator: str = None,
        type: str = None,
        value: str = None,
    ):
        # The comparison operator. Valid values: **>**, **<**, **>=**, **<=**, **==**, and **! =**.
        self.cond = cond
        # The expression that is used to obtain the value of the parameter. Valid values:
        # 
        # *   **Empty**: obtains the value of the parameter.
        # *   **.name**: obtains the name property of the parameter. This expression works the same way as args0.getName().
        # *   **.isEnabled()**: obtains the enabled property of the parameter. This expression works the same way as args0.isEnabled().
        # *   **[0]**: indicates that the value of the parameter is an array and obtains the first value of the array. This expression works the same way as args0[0]. This expression does not start with a period (.).
        # *   **.get(0)**: indicates that the value of the parameter is a list and obtains the first value of the list. This expression works the same way as args0.get(0).
        # *   **.get("key")**: indicates that the value of the parameter is a map and obtains the value of the key in the map. This expression works the same way as args0.get("key").
        self.expr = expr
        # The index of the parameter. The value 0 indicates the first parameter.
        self.index = index
        # This parameter is not returned for Dubbo services.
        self.name = name
        # The operator. Valid values:
        # 
        # *   **rawvalue**: direct comparison.
        # *   **list**: whitelist.
        # *   **mod**: mods 100.
        # *   **deterministic_proportional_steaming_division**: percentage.
        self.operator = operator
        # This parameter is not returned for Dubbo services.
        self.type = type
        # The value of the parameter. This value is compared with the value that is obtained based on the **expr** and **index** parameters.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cond is not None:
            result['cond'] = self.cond
        if self.expr is not None:
            result['expr'] = self.expr
        if self.index is not None:
            result['index'] = self.index
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cond') is not None:
            self.cond = m.get('cond')
        if m.get('expr') is not None:
            self.expr = m.get('expr')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class DescribeGreyTagRouteResponseBodyDataDubboRules(TeaModel):
    def __init__(
        self,
        condition: str = None,
        group: str = None,
        items: List[DescribeGreyTagRouteResponseBodyDataDubboRulesItems] = None,
        method_name: str = None,
        service_name: str = None,
        version: str = None,
    ):
        # The relationship between the conditions in the canary release rule. Valid values:
        # 
        # *   **AND**: The conditions are in the logical AND relation. All conditions must be met at the same time.
        # *   **OR**: The conditions are in the logical OR relation. At least one of the conditions must be met.
        self.condition = condition
        # The group of the Dubbo service that corresponds to the canary release rule.
        self.group = group
        # The conditions.
        self.items = items
        # The method name of the Dubbo service.
        self.method_name = method_name
        # The name of the Dubbo service.
        self.service_name = service_name
        # The version of the Dubbo service.
        self.version = version

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition
        if self.group is not None:
            result['group'] = self.group
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.method_name is not None:
            result['methodName'] = self.method_name
        if self.service_name is not None:
            result['serviceName'] = self.service_name
        if self.version is not None:
            result['version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            self.condition = m.get('condition')
        if m.get('group') is not None:
            self.group = m.get('group')
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = DescribeGreyTagRouteResponseBodyDataDubboRulesItems()
                self.items.append(temp_model.from_map(k))
        if m.get('methodName') is not None:
            self.method_name = m.get('methodName')
        if m.get('serviceName') is not None:
            self.service_name = m.get('serviceName')
        if m.get('version') is not None:
            self.version = m.get('version')
        return self


class DescribeGreyTagRouteResponseBodyDataScRulesItems(TeaModel):
    def __init__(
        self,
        cond: str = None,
        expr: str = None,
        index: int = None,
        name: str = None,
        operator: str = None,
        type: str = None,
        value: str = None,
    ):
        # The comparison operator. Valid values: **>**, **<**, **>=**, **<=**, **==**, and **! =**.
        self.cond = cond
        # This parameter is not returned for Spring Cloud applications.
        self.expr = expr
        # This parameter is not returned for Spring Cloud applications.
        self.index = index
        # The name of the parameter.
        self.name = name
        # The operator. Valid values:
        # 
        # *   **rawvalue**: direct comparison.
        # *   **list**: whitelist.
        # *   **mod**: mods 100.
        # *   **deterministic_proportional_steaming_division**: percentage.
        self.operator = operator
        # The type of the comparison. Valid values:
        # 
        # *   **param**: parameter
        # *   **cookie**: cookie
        # *   **header**: header
        self.type = type
        # The value of the parameter. This value is compared with the value that is obtained based on the **type** and **name** parameters.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cond is not None:
            result['cond'] = self.cond
        if self.expr is not None:
            result['expr'] = self.expr
        if self.index is not None:
            result['index'] = self.index
        if self.name is not None:
            result['name'] = self.name
        if self.operator is not None:
            result['operator'] = self.operator
        if self.type is not None:
            result['type'] = self.type
        if self.value is not None:
            result['value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('cond') is not None:
            self.cond = m.get('cond')
        if m.get('expr') is not None:
            self.expr = m.get('expr')
        if m.get('index') is not None:
            self.index = m.get('index')
        if m.get('name') is not None:
            self.name = m.get('name')
        if m.get('operator') is not None:
            self.operator = m.get('operator')
        if m.get('type') is not None:
            self.type = m.get('type')
        if m.get('value') is not None:
            self.value = m.get('value')
        return self


class DescribeGreyTagRouteResponseBodyDataScRules(TeaModel):
    def __init__(
        self,
        condition: str = None,
        items: List[DescribeGreyTagRouteResponseBodyDataScRulesItems] = None,
        path: str = None,
    ):
        # The relationship between the conditions in the canary release rule. Valid values:
        # 
        # *   **AND**: The conditions are in the logical AND relation. All conditions must be met at the same time.
        # *   **OR**: The conditions are in the logical OR relation. At least one of the conditions must be met.
        self.condition = condition
        # The conditions.
        self.items = items
        # The path of the canary release rule of the Spring Cloud application.
        self.path = path

    def validate(self):
        if self.items:
            for k in self.items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.condition is not None:
            result['condition'] = self.condition
        result['items'] = []
        if self.items is not None:
            for k in self.items:
                result['items'].append(k.to_map() if k else None)
        if self.path is not None:
            result['path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('condition') is not None:
            self.condition = m.get('condition')
        self.items = []
        if m.get('items') is not None:
            for k in m.get('items'):
                temp_model = DescribeGreyTagRouteResponseBodyDataScRulesItems()
                self.items.append(temp_model.from_map(k))
        if m.get('path') is not None:
            self.path = m.get('path')
        return self


class DescribeGreyTagRouteResponseBodyData(TeaModel):
    def __init__(
        self,
        alb_rules: List[DescribeGreyTagRouteResponseBodyDataAlbRules] = None,
        app_id: str = None,
        create_time: int = None,
        description: str = None,
        dubbo_rules: List[DescribeGreyTagRouteResponseBodyDataDubboRules] = None,
        grey_tag_route_id: int = None,
        name: str = None,
        sc_rules: List[DescribeGreyTagRouteResponseBodyDataScRules] = None,
        update_time: int = None,
    ):
        self.alb_rules = alb_rules
        # The ID of the application.
        self.app_id = app_id
        # The timestamp when the canary release rule was created. Unit: milliseconds.
        self.create_time = create_time
        # The description of the canary release rule.
        self.description = description
        # The canary release rule of the Dubbo service.
        self.dubbo_rules = dubbo_rules
        # The ID of the canary release rule. The ID is globally unique.
        self.grey_tag_route_id = grey_tag_route_id
        # The name of the canary release rule.
        self.name = name
        # The canary release rule of the Spring Cloud application.
        self.sc_rules = sc_rules
        # The timestamp when the canary release rule was updated. Unit: milliseconds.
        self.update_time = update_time

    def validate(self):
        if self.alb_rules:
            for k in self.alb_rules:
                if k:
                    k.validate()
        if self.dubbo_rules:
            for k in self.dubbo_rules:
                if k:
                    k.validate()
        if self.sc_rules:
            for k in self.sc_rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AlbRules'] = []
        if self.alb_rules is not None:
            for k in self.alb_rules:
                result['AlbRules'].append(k.to_map() if k else None)
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        result['DubboRules'] = []
        if self.dubbo_rules is not None:
            for k in self.dubbo_rules:
                result['DubboRules'].append(k.to_map() if k else None)
        if self.grey_tag_route_id is not None:
            result['GreyTagRouteId'] = self.grey_tag_route_id
        if self.name is not None:
            result['Name'] = self.name
        result['ScRules'] = []
        if self.sc_rules is not None:
            for k in self.sc_rules:
                result['ScRules'].append(k.to_map() if k else None)
        if self.update_time is not None:
            result['UpdateTime'] = self.update_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.alb_rules = []
        if m.get('AlbRules') is not None:
            for k in m.get('AlbRules'):
                temp_model = DescribeGreyTagRouteResponseBodyDataAlbRules()
                self.alb_rules.append(temp_model.from_map(k))
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        self.dubbo_rules = []
        if m.get('DubboRules') is not None:
            for k in m.get('DubboRules'):
                temp_model = DescribeGreyTagRouteResponseBodyDataDubboRules()
                self.dubbo_rules.append(temp_model.from_map(k))
        if m.get('GreyTagRouteId') is not None:
            self.grey_tag_route_id = m.get('GreyTagRouteId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        self.sc_rules = []
        if m.get('ScRules') is not None:
            for k in m.get('ScRules'):
                temp_model = DescribeGreyTagRouteResponseBodyDataScRules()
                self.sc_rules.append(temp_model.from_map(k))
        if m.get('UpdateTime') is not None:
            self.update_time = m.get('UpdateTime')
        return self


class DescribeGreyTagRouteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeGreyTagRouteResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The information about the canary release rule.
        self.data = data
        # The error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the **Error codes** section in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the information of the change order was queried. Valid values:
        # 
        # *   **true**: The information was queried.
        # *   **false**: The information failed to be queried.
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeGreyTagRouteResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeGreyTagRouteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGreyTagRouteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGreyTagRouteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeIngressRequest(TeaModel):
    def __init__(
        self,
        ingress_id: int = None,
    ):
        # The returned data.
        # 
        # This parameter is required.
        self.ingress_id = ingress_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ingress_id is not None:
            result['IngressId'] = self.ingress_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IngressId') is not None:
            self.ingress_id = m.get('IngressId')
        return self


class DescribeIngressResponseBodyDataDefaultRule(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        backend_protocol: str = None,
        container_port: int = None,
    ):
        # The domain name of the application.
        self.app_id = app_id
        # The container port of the application specified in the forwarding rule.
        self.app_name = app_name
        self.backend_protocol = backend_protocol
        # The name of the application specified in the forwarding rule.
        self.container_port = container_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.backend_protocol is not None:
            result['BackendProtocol'] = self.backend_protocol
        if self.container_port is not None:
            result['ContainerPort'] = self.container_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BackendProtocol') is not None:
            self.backend_protocol = m.get('BackendProtocol')
        if m.get('ContainerPort') is not None:
            self.container_port = m.get('ContainerPort')
        return self


class DescribeIngressResponseBodyDataRules(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        app_name: str = None,
        backend_protocol: str = None,
        container_port: int = None,
        domain: str = None,
        path: str = None,
        rewrite_path: str = None,
    ):
        # The protocol used to forward requests. Valid values:
        # 
        # *   **HTTP**: used when the application needs to identify the transmitted data.
        # *   **HTTPS**: used when the application requires encrypted data transmission.
        self.app_id = app_id
        # The path of the URL.
        self.app_name = app_name
        self.backend_protocol = backend_protocol
        # The ID of the routing rule.
        self.container_port = container_port
        # The type of the SLB instance based on the processing capabilities. Valid values:
        # 
        # *   **clb**: the Classic Load Balancer (CLB) instance.
        # *   **alb**: the Application Load Balancer (ALB) instance.
        self.domain = domain
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.path = path
        self.rewrite_path = rewrite_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.backend_protocol is not None:
            result['BackendProtocol'] = self.backend_protocol
        if self.container_port is not None:
            result['ContainerPort'] = self.container_port
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.path is not None:
            result['Path'] = self.path
        if self.rewrite_path is not None:
            result['RewritePath'] = self.rewrite_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BackendProtocol') is not None:
            self.backend_protocol = m.get('BackendProtocol')
        if m.get('ContainerPort') is not None:
            self.container_port = m.get('ContainerPort')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('RewritePath') is not None:
            self.rewrite_path = m.get('RewritePath')
        return self


class DescribeIngressResponseBodyData(TeaModel):
    def __init__(
        self,
        cert_id: str = None,
        cert_ids: str = None,
        default_rule: DescribeIngressResponseBodyDataDefaultRule = None,
        description: str = None,
        id: int = None,
        listener_port: int = None,
        listener_protocol: str = None,
        load_balance_type: str = None,
        name: str = None,
        namespace_id: str = None,
        rules: List[DescribeIngressResponseBodyDataRules] = None,
        slb_id: str = None,
        slb_type: str = None,
    ):
        # The name of the application specified in the default rule.
        self.cert_id = cert_id
        self.cert_ids = cert_ids
        # The forwarding rules.
        self.default_rule = default_rule
        # The name of the routing rule.
        self.description = description
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.id = id
        # The default rule.
        self.listener_port = listener_port
        self.listener_protocol = listener_protocol
        # Indicates whether the configurations of the routing rule were queried successfully. Valid values:
        # 
        # *   **true**: indicates that the query was successful.
        # *   **false**: indicates that the query failed.
        self.load_balance_type = load_balance_type
        # The ID of the application specified in the default rule.
        self.name = name
        # The ID of the certificate.
        self.namespace_id = namespace_id
        # The ID of the application specified in the forwarding rule.
        self.rules = rules
        # The type of the SLB instance based on the IP address. Valid values:
        # 
        # *   **internet**: the Internet-facing SLB instance.
        # *   **intranet**: the internal-facing SLB instance.
        self.slb_id = slb_id
        # The container port of the application specified in the default rule.
        self.slb_type = slb_type

    def validate(self):
        if self.default_rule:
            self.default_rule.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cert_id is not None:
            result['CertId'] = self.cert_id
        if self.cert_ids is not None:
            result['CertIds'] = self.cert_ids
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule.to_map()
        if self.description is not None:
            result['Description'] = self.description
        if self.id is not None:
            result['Id'] = self.id
        if self.listener_port is not None:
            result['ListenerPort'] = self.listener_port
        if self.listener_protocol is not None:
            result['ListenerProtocol'] = self.listener_protocol
        if self.load_balance_type is not None:
            result['LoadBalanceType'] = self.load_balance_type
        if self.name is not None:
            result['Name'] = self.name
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        if self.slb_id is not None:
            result['SlbId'] = self.slb_id
        if self.slb_type is not None:
            result['SlbType'] = self.slb_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CertId') is not None:
            self.cert_id = m.get('CertId')
        if m.get('CertIds') is not None:
            self.cert_ids = m.get('CertIds')
        if m.get('DefaultRule') is not None:
            temp_model = DescribeIngressResponseBodyDataDefaultRule()
            self.default_rule = temp_model.from_map(m['DefaultRule'])
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ListenerPort') is not None:
            self.listener_port = m.get('ListenerPort')
        if m.get('ListenerProtocol') is not None:
            self.listener_protocol = m.get('ListenerProtocol')
        if m.get('LoadBalanceType') is not None:
            self.load_balance_type = m.get('LoadBalanceType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeIngressResponseBodyDataRules()
                self.rules.append(temp_model.from_map(k))
        if m.get('SlbId') is not None:
            self.slb_id = m.get('SlbId')
        if m.get('SlbType') is not None:
            self.slb_type = m.get('SlbType')
        return self


class DescribeIngressResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeIngressResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        self.code = code
        # The port specified for the SLB listener.
        self.data = data
        self.error_code = error_code
        # The ID of the namespace.
        self.message = message
        # The ID of the SLB instance.
        self.request_id = request_id
        self.success = success
        # The name of the routing rule.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeIngressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeIngressResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeIngressResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeIngressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceLogRequest(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
    ):
        # The ID of the request.
        # 
        # This parameter is required.
        self.instance_id = instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DescribeInstanceLogResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: str = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # Indicates whether the log of the instance was obtained. Valid values:
        # 
        # *   **true**: indicates that the log was obtained.
        # *   **false**: indicates that the log could not be obtained.
        self.code = code
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.data = data
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.error_code = error_code
        # The ID of the trace.
        self.message = message
        # The returned message.
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error code is returned when the request fails.
        self.request_id = request_id
        self.success = success
        # The log of the instance.
        self.trace_id = trace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeInstanceLogResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceLogResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeInstanceSpecificationsResponseBodyData(TeaModel):
    def __init__(
        self,
        cpu: int = None,
        enable: bool = None,
        id: int = None,
        memory: int = None,
        spec_info: str = None,
        version: int = None,
    ):
        # The CPU specification of the instance type. Unit: millicore.
        self.cpu = cpu
        # Indicates whether the instance type is available. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.enable = enable
        # The ID of the instance type.
        self.id = id
        # The memory size of the instance type. Unit: MB.
        self.memory = memory
        # The name of the instance type.
        self.spec_info = spec_info
        # The version number of the instance type.
        self.version = version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.id is not None:
            result['Id'] = self.id
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.spec_info is not None:
            result['SpecInfo'] = self.spec_info
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('SpecInfo') is not None:
            self.spec_info = m.get('SpecInfo')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class DescribeInstanceSpecificationsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[DescribeInstanceSpecificationsResponseBodyData] = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request was invalid.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # Information of instance types.
        self.data = data
        # The error code.
        # 
        # *   If the request is successful, this parameter is not returned.****\
        # *   This parameter is returned only if the request failed.**** For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message. Valid values:
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error code is returned when the request fails.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether information of the instance types is successfully obtained. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The ID of the trace. It is used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeInstanceSpecificationsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeInstanceSpecificationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeInstanceSpecificationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeInstanceSpecificationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeJobRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        job_id: str = None,
    ):
        # The application ID.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The job ID.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DescribeJobResponseBodyDataConfigMapMountDesc(TeaModel):
    def __init__(
        self,
        config_map_id: int = None,
        config_map_name: str = None,
        key: str = None,
        mount_path: str = None,
    ):
        # The ConfigMap ID.
        self.config_map_id = config_map_id
        # The ConfigMap name.
        self.config_map_name = config_map_name
        # The key-value pair that is stored in the ConfigMap.
        self.key = key
        # The path on which the NAS file system is mounted.
        self.mount_path = mount_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_map_id is not None:
            result['ConfigMapId'] = self.config_map_id
        if self.config_map_name is not None:
            result['ConfigMapName'] = self.config_map_name
        if self.key is not None:
            result['Key'] = self.key
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigMapId') is not None:
            self.config_map_id = m.get('ConfigMapId')
        if m.get('ConfigMapName') is not None:
            self.config_map_name = m.get('ConfigMapName')
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        return self


class DescribeJobResponseBodyDataMountDesc(TeaModel):
    def __init__(
        self,
        mount_path: str = None,
        nas_path: str = None,
    ):
        # The path on which the NAS file system is mounted.
        self.mount_path = mount_path
        # The directory in the NAS file system.
        self.nas_path = nas_path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.mount_path is not None:
            result['MountPath'] = self.mount_path
        if self.nas_path is not None:
            result['NasPath'] = self.nas_path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MountPath') is not None:
            self.mount_path = m.get('MountPath')
        if m.get('NasPath') is not None:
            self.nas_path = m.get('NasPath')
        return self


class DescribeJobResponseBodyDataOssMountDescs(TeaModel):
    def __init__(
        self,
        bucket_name: str = None,
        bucket_path: str = None,
        mount_path: str = None,
        read_only: bool = None,
    ):
        # The bucket name.
        self.bucket_name = bucket_name
        # The directory or object in OSS. If the specified directory or object does not exist, an error is returned.
        self.bucket_path = bucket_path
        # The path of the container in SAE. The parameter value that you specified overwrites the original value. If the specified path does not exist, SAE automatically creates the path.
        self.mount_path = mount_path
        # Indicates whether the application can use the container path to read data from or write data to resources in the directory of the OSS bucket. Valid values:
        # 
        # *   **true**: The application has the read-only permission.
        # *   **false**: The application has read and write permissions.
        self.read_only = read_only

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bucket_name is not None:
            result['bucketName'] = self.bucket_name
        if self.bucket_path is not None:
            result['bucketPath'] = self.bucket_path
        if self.mount_path is not None:
            result['mountPath'] = self.mount_path
        if self.read_only is not None:
            result['readOnly'] = self.read_only
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('bucketName') is not None:
            self.bucket_name = m.get('bucketName')
        if m.get('bucketPath') is not None:
            self.bucket_path = m.get('bucketPath')
        if m.get('mountPath') is not None:
            self.mount_path = m.get('mountPath')
        if m.get('readOnly') is not None:
            self.read_only = m.get('readOnly')
        return self


class DescribeJobResponseBodyDataTags(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: str = None,
    ):
        # The tag key.
        self.key = key
        # The tag value.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeJobResponseBodyData(TeaModel):
    def __init__(
        self,
        acr_assume_role_arn: str = None,
        acr_instance_id: str = None,
        app_description: str = None,
        app_id: str = None,
        app_name: str = None,
        backoff_limit: int = None,
        command: str = None,
        command_args: str = None,
        concurrency_policy: str = None,
        config_map_mount_desc: List[DescribeJobResponseBodyDataConfigMapMountDesc] = None,
        cpu: int = None,
        custom_host_alias: str = None,
        edas_container_version: str = None,
        envs: str = None,
        image_pull_secrets: str = None,
        image_url: str = None,
        jar_start_args: str = None,
        jar_start_options: str = None,
        jdk: str = None,
        memory: int = None,
        mount_desc: List[DescribeJobResponseBodyDataMountDesc] = None,
        mount_host: str = None,
        namespace_id: str = None,
        nas_configs: str = None,
        nas_id: str = None,
        oss_ak_id: str = None,
        oss_ak_secret: str = None,
        oss_mount_descs: List[DescribeJobResponseBodyDataOssMountDescs] = None,
        package_type: str = None,
        package_url: str = None,
        package_version: str = None,
        php_config: str = None,
        php_config_location: str = None,
        post_start: str = None,
        pre_stop: str = None,
        programming_language: str = None,
        public_web_hook_urls: List[str] = None,
        python: str = None,
        python_modules: str = None,
        ref_app_id: str = None,
        refed_app_ids: List[str] = None,
        region_id: str = None,
        replicas: int = None,
        security_group_id: str = None,
        slice: bool = None,
        slice_envs: str = None,
        sls_configs: str = None,
        suspend: bool = None,
        tags: List[DescribeJobResponseBodyDataTags] = None,
        termination_grace_period_seconds: int = None,
        timeout: int = None,
        timezone: str = None,
        tomcat_config: str = None,
        trigger_config: str = None,
        v_switch_id: str = None,
        vpc_id: str = None,
        vpc_web_hook_urls: List[str] = None,
        war_start_options: str = None,
        web_container: str = None,
    ):
        # The Alibaba Cloud Resource Name (ARN) of the RAM role that is used to pull images across accounts. For more information, see [Pull images across Alibaba Cloud accounts](https://help.aliyun.com/document_detail/190675.html) and [Grant permissions across Alibaba Cloud accounts by using a RAM role](https://help.aliyun.com/document_detail/223585.html).
        self.acr_assume_role_arn = acr_assume_role_arn
        # The ID of the Container Registry Enterprise Edition instance.
        self.acr_instance_id = acr_instance_id
        # The description of the application.
        self.app_description = app_description
        # The application ID.
        self.app_id = app_id
        # The application name.
        self.app_name = app_name
        # The number of times that the job was retried.
        self.backoff_limit = backoff_limit
        # The command that is used to start the image. The command must be an existing executable object in the container. Example:
        # 
        #     command:
        #           - echo
        #           - abc
        #           - >
        #           - file0
        # 
        # In this example, the Command parameter is set to `Command="echo", CommandArgs=["abc", ">", "file0"]`.
        self.command = command
        # The arguments of the image startup command. This parameter contains the arguments that are required for **Command**. Format:
        # 
        # `["a","b"]`
        # 
        # In the preceding **Command** example, the CommandArgs parameter is set to `CommandArgs=["abc", ">", "file0"]`. The data type of `["abc", ">", "file0"]` must be an array of strings in the JSON format. If this parameter does not exist in the Command parameter, you do not need to configure it.
        self.command_args = command_args
        # The concurrency policy of the job. Valid values:
        # 
        # *   **Forbid**: Concurrent running is prohibited. If the previous job is not completed, no new job is created.
        # *   **Allow**: Concurrent running is allowed.
        # *   **Replace**: If the previous job is not completed when the time to create a new job is reached, the new job replaces the previous job.
        self.concurrency_policy = concurrency_policy
        # The details of the ConfigMap.
        self.config_map_mount_desc = config_map_mount_desc
        # The CPU specifications required for each instance. Unit: millicore. This parameter cannot be set to 0. Valid values:
        # 
        # *   **500**\
        # *   **1000**\
        # *   **2000**\
        # *   **4000**\
        # *   **8000**\
        # *   **16000**\
        # *   **32000**\
        self.cpu = cpu
        # The custom mapping between the hostname and IP address in the container. Valid values:
        # 
        # *   **hostName**: the domain name or hostname.
        # *   **ip**: the IP address.
        self.custom_host_alias = custom_host_alias
        # The version of the container, such as Ali-Tomcat, in which an application developed based on High-speed Service Framework (HSF) is deployed.
        self.edas_container_version = edas_container_version
        # The environment variables. You can configure custom environment variables or reference a ConfigMap. If you want to reference a ConfigMap, you must first create a ConfigMap. For more information, see [CreateConfigMap](https://help.aliyun.com/document_detail/176914.html). Valid values:
        # 
        # *   Custom configuration
        # 
        #     *   **name**: the name of the environment variable.
        #     *   **value**: the value of the environment variable.
        # 
        # *   Reference a ConfigMap
        # 
        #     *   **name**: the name of the environment variable. You can reference one or all keys. To reference all keys, specify `sae-sys-configmap-all-<ConfigMap name>`. Example: `sae-sys-configmap-all-test1`.
        #     *   **valueFrom**: the reference of the environment variable. Set the value to `configMapRef`.
        #     *   **configMapId**: the ID of the ConfigMap.
        #     *   **key**: the key. If you want to reference all keys, you do not need to configure this parameter.
        self.envs = envs
        # The ID of the corresponding secret.
        self.image_pull_secrets = image_pull_secrets
        # The URL of the image. This parameter is returned only if **PackageType** is set to **Image**.
        self.image_url = image_url
        # The arguments in the JAR package. The arguments are used to start the application container. The default startup command is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_args = jar_start_args
        # The option settings in the JAR package. The settings are used to start the application container. The default startup command is `$JAVA_HOME/bin/java $JarStartOptions -jar $CATALINA_OPTS "$package_path" $JarStartArgs`.
        self.jar_start_options = jar_start_options
        # The version of the Java Development Kit (JDK) on which the deployment package of the application depends. The following versions are supported:
        # 
        # *   **Open JDK 8**\
        # *   **Open JDK 7**\
        # *   **Dragonwell 11**\
        # *   **Dragonwell 8**\
        # *   **openjdk-8u191-jdk-alpine3.9**\
        # *   **openjdk-7u201-jdk-alpine3.9**\
        # 
        # This parameter is not returned if **PackageType** is set to **Image**.
        self.jdk = jdk
        # The size of memory that is required by each instance. Unit: MB. This parameter cannot be set to 0. The values of this parameter correspond to the values of the Cpu parameter:
        # 
        # *   This parameter is set to **1024** if the Cpu parameter is set to 500 or 1000.
        # *   This parameter is set to **2048** if the Cpu parameter is set to 500, 1000, or 2000.
        # *   This parameter is set to **4096** if the Cpu parameter is set to 1000, 2000, or 4000.
        # *   This parameter is set to **8192** if the Cpu parameter is set to 2000, 4000, or 8000.
        # *   This parameter is set to **12288** if the Cpu parameter is set to 12000.
        # *   This parameter is set to **16384** if the Cpu parameter is set to 4000, 8000, or 16000.
        # *   This parameter is set to **24567** if the Cpu parameter is set to 12000.
        # *   This parameter is set to **32768** if the Cpu parameter is set to 16000.
        # *   This parameter is set to **65536** if the Cpu parameter is set to 8000, 16000, or 32000.
        # *   This parameter is set to **131072** if the Cpu parameter is set to 32000.
        self.memory = memory
        # The details of the mounted NAS file system.
        self.mount_desc = mount_desc
        # The mount target of the NAS file system in the VPC in which the application is deployed. If you do not need to modify this configuration during the deployment, configure **MountHost** only in the first request. If you need to remove this configuration, leave **MountHost** empty in the request.
        self.mount_host = mount_host
        # The namespace ID.
        self.namespace_id = namespace_id
        # The configurations for mounting the NAS file system.
        self.nas_configs = nas_configs
        # The ID of the NAS file system.
        self.nas_id = nas_id
        # The AccessKey ID that is used to read data from and write data to Object Storage Service (OSS).
        self.oss_ak_id = oss_ak_id
        # The AccessKey secret that is used to read data from and write data to OSS.
        self.oss_ak_secret = oss_ak_secret
        # The description of mounted OSS buckets.
        self.oss_mount_descs = oss_mount_descs
        # The type of the deployment package. Valid values:
        # 
        # *   If you deploy the application by using a Java Archive (JAR) package, this parameter is set to **FatJar**, **War**, or **Image**.
        # 
        # *   If you deploy the application by using a PHP package, this parameter is set to one of the following values:
        # 
        #     *   **PhpZip**\
        #     *   **IMAGE_PHP_5_4**\
        #     *   **IMAGE_PHP_5_4_ALPINE**\
        #     *   **IMAGE_PHP_5_5**\
        #     *   **IMAGE_PHP_5_5_ALPINE**\
        #     *   **IMAGE_PHP_5_6**\
        #     *   **IMAGE_PHP_5_6_ALPINE**\
        #     *   **IMAGE_PHP_7_0**\
        #     *   **IMAGE_PHP_7_0_ALPINE**\
        #     *   **IMAGE_PHP_7_1**\
        #     *   **IMAGE_PHP_7_1_ALPINE**\
        #     *   **IMAGE_PHP_7_2**\
        #     *   **IMAGE_PHP_7_2_ALPINE**\
        #     *   **IMAGE_PHP_7_3**\
        #     *   **IMAGE_PHP_7_3_ALPINE**\
        # 
        # *   If you deploy the application by using a Pythhon package, this parameter is set to **PythonZip** or **Image**.
        self.package_type = package_type
        # The URL of the deployment package. This parameter is returned only if **PackageType** is set to **FatJar** or **War**.
        self.package_url = package_url
        # The version of the deployment package. This parameter is required only if **PackageType** is set to **FatJar** or **War**.
        self.package_version = package_version
        # The details of the PHP configuration file.
        self.php_config = php_config
        # The path on which the PHP configuration file for application startup is mounted. Make sure that the PHP server uses this configuration file during the startup.
        self.php_config_location = php_config_location
        # The script that is run immediately after the container is started. Example: `{"exec":{"command":["cat","/etc/group"\\]}}`
        self.post_start = post_start
        # The script that is run before the container is stopped. Example: `{"exec":{"command":["cat","/etc/group"\\]}}`
        self.pre_stop = pre_stop
        # The programming language that is used to create the application. Valid values:
        # 
        # *   **java**: Java
        # *   **php**: PHP
        # *   **python**: Python
        # *   **other**: other programming languages, such as C++, Go, .NET, and Node.js.
        self.programming_language = programming_language
        # The Internet request URLs of one-time jobs.
        self.public_web_hook_urls = public_web_hook_urls
        # The Python environment. PYTHON 3.9.15 is supported.
        self.python = python
        # The configurations for installing custom module dependencies. By default, the dependencies defined by the requirements.txt file in the root directory are installed. If no software package is configured, you can specify dependencies based on your business requirements.
        self.python_modules = python_modules
        # The ID of the job template that you reference.
        self.ref_app_id = ref_app_id
        # The IDs of the referenced job templates.
        self.refed_app_ids = refed_app_ids
        # The region ID.
        self.region_id = region_id
        # The number of application instances.
        self.replicas = replicas
        # The ID of the security group.
        self.security_group_id = security_group_id
        # Indicates whether job sharding is enabled.
        self.slice = slice
        # The parameters of job sharding.
        self.slice_envs = slice_envs
        # The logging configurations of Log Service.
        # 
        # *   To use Log Service resources that are automatically created by SAE, set this parameter to `[{"logDir":"","logType":"stdout"},{"logDir":"/tmp/a.log"}]`.
        # *   To use custom Log Service resources, set this parameter to `[{"projectName":"test-sls","logType":"stdout","logDir":"","logstoreName":"sae","logtailName":""},{"projectName":"test","logDir":"/tmp/a.log","logstoreName":"sae","logtailName":""}]`.
        # 
        # Parameter description:
        # 
        # *   **projectName**: the name of the Log Service project.
        # *   **logDir**: the path in which logs are stored.
        # *   **logType**: the log type. **stdout**: the standard output (stdout) log of the container. Only one stdout value for this parameter can be specified. If this parameter is not configured, file logs are collected.
        # *   **logstoreName**: the name of the Logstore in Log Service.
        # *   **logtailName**: the name of the Logtail in Log Service. If this parameter is not configured, a new Logtail is created.
        # 
        # If you do not need to modify the logging configurations when you deploy the application, configure **SlsConfigs** only in the first request. If you no longer need to use Log Service, leave **SlsConfigs** empty in the request.
        self.sls_configs = sls_configs
        # Indicates whether the job template is suspended.
        self.suspend = suspend
        # The tags.
        self.tags = tags
        # The timeout period for a graceful shutdown. Default value: 30. Unit: seconds. Valid values: 1 to 300.
        self.termination_grace_period_seconds = termination_grace_period_seconds
        # The timeout period for the job. Unit: seconds.
        self.timeout = timeout
        # The time zone. Default value: **Asia/Shanghai**.
        self.timezone = timezone
        # The Tomcat configuration. If you want to delete the configuration, set this parameter to {} or leave this parameter empty. Parameter description:
        # 
        # *   **port**: the port number. Valid values: 1024 to 65535. The root permissions are required to perform operations on ports whose number is smaller than 1024. Enter a value that ranges from 1025 to 65535 because the container has only the admin permissions. If this parameter is not configured, the default value 8080 is used.
        # *   **contextPath**: the path. Default value: /. The value indicates the root directory.
        # *   **maxThreads**: the maximum number of connections in the connection pool. Default value: 400.
        # *   **uriEncoding**: the URI encoding scheme in the Tomcat container. Valid values: **UTF-8**, **ISO-8859-1**, **GBK**, and **GB2312**. If this parameter is not configured, the default value **ISO-8859-1** is used.
        # *   **useBodyEncoding**: indicates whether to use the encoding scheme that is specified by **BodyEncoding for URL**. Default value: **true**.
        self.tomcat_config = tomcat_config
        self.trigger_config = trigger_config
        # The vSwitch ID.
        self.v_switch_id = v_switch_id
        # The ID of the virtual private cloud (VPC).
        self.vpc_id = vpc_id
        # The internal request URLs for one-time jobs.
        self.vpc_web_hook_urls = vpc_web_hook_urls
        # The option settings in the WAR package. The settings are used to start the application container. The default startup command is `java $JAVA_OPTS $CATALINA_OPTS -Options org.apache.catalina.startup.Bootstrap "$@" start`.
        self.war_start_options = war_start_options
        # The version of the Tomcat container on which the deployment package depends. The following versions are supported:
        # 
        # *   **apache-tomcat-7.0.91**\
        # *   **apache-tomcat-8.5.42**\
        # 
        # This parameter is not returned if **PackageType** is set to **Image**.
        self.web_container = web_container

    def validate(self):
        if self.config_map_mount_desc:
            for k in self.config_map_mount_desc:
                if k:
                    k.validate()
        if self.mount_desc:
            for k in self.mount_desc:
                if k:
                    k.validate()
        if self.oss_mount_descs:
            for k in self.oss_mount_descs:
                if k:
                    k.validate()
        if self.tags:
            for k in self.tags:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acr_assume_role_arn is not None:
            result['AcrAssumeRoleArn'] = self.acr_assume_role_arn
        if self.acr_instance_id is not None:
            result['AcrInstanceId'] = self.acr_instance_id
        if self.app_description is not None:
            result['AppDescription'] = self.app_description
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.backoff_limit is not None:
            result['BackoffLimit'] = self.backoff_limit
        if self.command is not None:
            result['Command'] = self.command
        if self.command_args is not None:
            result['CommandArgs'] = self.command_args
        if self.concurrency_policy is not None:
            result['ConcurrencyPolicy'] = self.concurrency_policy
        result['ConfigMapMountDesc'] = []
        if self.config_map_mount_desc is not None:
            for k in self.config_map_mount_desc:
                result['ConfigMapMountDesc'].append(k.to_map() if k else None)
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.custom_host_alias is not None:
            result['CustomHostAlias'] = self.custom_host_alias
        if self.edas_container_version is not None:
            result['EdasContainerVersion'] = self.edas_container_version
        if self.envs is not None:
            result['Envs'] = self.envs
        if self.image_pull_secrets is not None:
            result['ImagePullSecrets'] = self.image_pull_secrets
        if self.image_url is not None:
            result['ImageUrl'] = self.image_url
        if self.jar_start_args is not None:
            result['JarStartArgs'] = self.jar_start_args
        if self.jar_start_options is not None:
            result['JarStartOptions'] = self.jar_start_options
        if self.jdk is not None:
            result['Jdk'] = self.jdk
        if self.memory is not None:
            result['Memory'] = self.memory
        result['MountDesc'] = []
        if self.mount_desc is not None:
            for k in self.mount_desc:
                result['MountDesc'].append(k.to_map() if k else None)
        if self.mount_host is not None:
            result['MountHost'] = self.mount_host
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.nas_configs is not None:
            result['NasConfigs'] = self.nas_configs
        if self.nas_id is not None:
            result['NasId'] = self.nas_id
        if self.oss_ak_id is not None:
            result['OssAkId'] = self.oss_ak_id
        if self.oss_ak_secret is not None:
            result['OssAkSecret'] = self.oss_ak_secret
        result['OssMountDescs'] = []
        if self.oss_mount_descs is not None:
            for k in self.oss_mount_descs:
                result['OssMountDescs'].append(k.to_map() if k else None)
        if self.package_type is not None:
            result['PackageType'] = self.package_type
        if self.package_url is not None:
            result['PackageUrl'] = self.package_url
        if self.package_version is not None:
            result['PackageVersion'] = self.package_version
        if self.php_config is not None:
            result['PhpConfig'] = self.php_config
        if self.php_config_location is not None:
            result['PhpConfigLocation'] = self.php_config_location
        if self.post_start is not None:
            result['PostStart'] = self.post_start
        if self.pre_stop is not None:
            result['PreStop'] = self.pre_stop
        if self.programming_language is not None:
            result['ProgrammingLanguage'] = self.programming_language
        if self.public_web_hook_urls is not None:
            result['PublicWebHookUrls'] = self.public_web_hook_urls
        if self.python is not None:
            result['Python'] = self.python
        if self.python_modules is not None:
            result['PythonModules'] = self.python_modules
        if self.ref_app_id is not None:
            result['RefAppId'] = self.ref_app_id
        if self.refed_app_ids is not None:
            result['RefedAppIds'] = self.refed_app_ids
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.replicas is not None:
            result['Replicas'] = self.replicas
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.slice is not None:
            result['Slice'] = self.slice
        if self.slice_envs is not None:
            result['SliceEnvs'] = self.slice_envs
        if self.sls_configs is not None:
            result['SlsConfigs'] = self.sls_configs
        if self.suspend is not None:
            result['Suspend'] = self.suspend
        result['Tags'] = []
        if self.tags is not None:
            for k in self.tags:
                result['Tags'].append(k.to_map() if k else None)
        if self.termination_grace_period_seconds is not None:
            result['TerminationGracePeriodSeconds'] = self.termination_grace_period_seconds
        if self.timeout is not None:
            result['Timeout'] = self.timeout
        if self.timezone is not None:
            result['Timezone'] = self.timezone
        if self.tomcat_config is not None:
            result['TomcatConfig'] = self.tomcat_config
        if self.trigger_config is not None:
            result['TriggerConfig'] = self.trigger_config
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_web_hook_urls is not None:
            result['VpcWebHookUrls'] = self.vpc_web_hook_urls
        if self.war_start_options is not None:
            result['WarStartOptions'] = self.war_start_options
        if self.web_container is not None:
            result['WebContainer'] = self.web_container
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AcrAssumeRoleArn') is not None:
            self.acr_assume_role_arn = m.get('AcrAssumeRoleArn')
        if m.get('AcrInstanceId') is not None:
            self.acr_instance_id = m.get('AcrInstanceId')
        if m.get('AppDescription') is not None:
            self.app_description = m.get('AppDescription')
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('BackoffLimit') is not None:
            self.backoff_limit = m.get('BackoffLimit')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('CommandArgs') is not None:
            self.command_args = m.get('CommandArgs')
        if m.get('ConcurrencyPolicy') is not None:
            self.concurrency_policy = m.get('ConcurrencyPolicy')
        self.config_map_mount_desc = []
        if m.get('ConfigMapMountDesc') is not None:
            for k in m.get('ConfigMapMountDesc'):
                temp_model = DescribeJobResponseBodyDataConfigMapMountDesc()
                self.config_map_mount_desc.append(temp_model.from_map(k))
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CustomHostAlias') is not None:
            self.custom_host_alias = m.get('CustomHostAlias')
        if m.get('EdasContainerVersion') is not None:
            self.edas_container_version = m.get('EdasContainerVersion')
        if m.get('Envs') is not None:
            self.envs = m.get('Envs')
        if m.get('ImagePullSecrets') is not None:
            self.image_pull_secrets = m.get('ImagePullSecrets')
        if m.get('ImageUrl') is not None:
            self.image_url = m.get('ImageUrl')
        if m.get('JarStartArgs') is not None:
            self.jar_start_args = m.get('JarStartArgs')
        if m.get('JarStartOptions') is not None:
            self.jar_start_options = m.get('JarStartOptions')
        if m.get('Jdk') is not None:
            self.jdk = m.get('Jdk')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        self.mount_desc = []
        if m.get('MountDesc') is not None:
            for k in m.get('MountDesc'):
                temp_model = DescribeJobResponseBodyDataMountDesc()
                self.mount_desc.append(temp_model.from_map(k))
        if m.get('MountHost') is not None:
            self.mount_host = m.get('MountHost')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NasConfigs') is not None:
            self.nas_configs = m.get('NasConfigs')
        if m.get('NasId') is not None:
            self.nas_id = m.get('NasId')
        if m.get('OssAkId') is not None:
            self.oss_ak_id = m.get('OssAkId')
        if m.get('OssAkSecret') is not None:
            self.oss_ak_secret = m.get('OssAkSecret')
        self.oss_mount_descs = []
        if m.get('OssMountDescs') is not None:
            for k in m.get('OssMountDescs'):
                temp_model = DescribeJobResponseBodyDataOssMountDescs()
                self.oss_mount_descs.append(temp_model.from_map(k))
        if m.get('PackageType') is not None:
            self.package_type = m.get('PackageType')
        if m.get('PackageUrl') is not None:
            self.package_url = m.get('PackageUrl')
        if m.get('PackageVersion') is not None:
            self.package_version = m.get('PackageVersion')
        if m.get('PhpConfig') is not None:
            self.php_config = m.get('PhpConfig')
        if m.get('PhpConfigLocation') is not None:
            self.php_config_location = m.get('PhpConfigLocation')
        if m.get('PostStart') is not None:
            self.post_start = m.get('PostStart')
        if m.get('PreStop') is not None:
            self.pre_stop = m.get('PreStop')
        if m.get('ProgrammingLanguage') is not None:
            self.programming_language = m.get('ProgrammingLanguage')
        if m.get('PublicWebHookUrls') is not None:
            self.public_web_hook_urls = m.get('PublicWebHookUrls')
        if m.get('Python') is not None:
            self.python = m.get('Python')
        if m.get('PythonModules') is not None:
            self.python_modules = m.get('PythonModules')
        if m.get('RefAppId') is not None:
            self.ref_app_id = m.get('RefAppId')
        if m.get('RefedAppIds') is not None:
            self.refed_app_ids = m.get('RefedAppIds')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Replicas') is not None:
            self.replicas = m.get('Replicas')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('Slice') is not None:
            self.slice = m.get('Slice')
        if m.get('SliceEnvs') is not None:
            self.slice_envs = m.get('SliceEnvs')
        if m.get('SlsConfigs') is not None:
            self.sls_configs = m.get('SlsConfigs')
        if m.get('Suspend') is not None:
            self.suspend = m.get('Suspend')
        self.tags = []
        if m.get('Tags') is not None:
            for k in m.get('Tags'):
                temp_model = DescribeJobResponseBodyDataTags()
                self.tags.append(temp_model.from_map(k))
        if m.get('TerminationGracePeriodSeconds') is not None:
            self.termination_grace_period_seconds = m.get('TerminationGracePeriodSeconds')
        if m.get('Timeout') is not None:
            self.timeout = m.get('Timeout')
        if m.get('Timezone') is not None:
            self.timezone = m.get('Timezone')
        if m.get('TomcatConfig') is not None:
            self.tomcat_config = m.get('TomcatConfig')
        if m.get('TriggerConfig') is not None:
            self.trigger_config = m.get('TriggerConfig')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcWebHookUrls') is not None:
            self.vpc_web_hook_urls = m.get('VpcWebHookUrls')
        if m.get('WarStartOptions') is not None:
            self.war_start_options = m.get('WarStartOptions')
        if m.get('WebContainer') is not None:
            self.web_container = m.get('WebContainer')
        return self


class DescribeJobResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeJobResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The information about the application.
        self.data = data
        # The error code returned. Take note of the following rules:
        # 
        # *   If the call is successful, **ErrorCode** is not returned.
        # *   If the call fails, **ErrorCode** is returned. For more information, see the "**Error codes**" section in this topic.
        self.error_code = error_code
        # The returned message.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the configurations of an application were obtained. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeJobResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeJobHistoryRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        current_page: int = None,
        page_size: int = None,
        state: str = None,
    ):
        # The ID of the job template.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The number of the page to return.
        self.current_page = current_page
        # The number of entries to return on each page. Valid values: 0 to 10000.
        self.page_size = page_size
        # The status of the job. Valid values:
        # 
        # *   **0**: The job is not executed.
        # *   **1**: The job is executed.
        # *   **2**: The job fails to be executed.
        # *   **3**: The job is being executed.
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class DescribeJobHistoryResponseBodyDataJobs(TeaModel):
    def __init__(
        self,
        active: int = None,
        completion_time: int = None,
        failed: int = None,
        job_id: str = None,
        message: str = None,
        start_time: int = None,
        state: str = None,
        succeeded: int = None,
    ):
        # The number of running instances.
        self.active = active
        # The time when the job was executed.
        self.completion_time = completion_time
        # The number of instances that failed to run.
        self.failed = failed
        # The job ID.
        self.job_id = job_id
        # The message returned if exceptions occur during job running.
        self.message = message
        # The time when the job was created.
        self.start_time = start_time
        # The status of the job. Valid values:
        # 
        # *   **0**: The job was not executed.
        # *   **1**: The job was executed.
        # *   **2**: The job failed to be executed.
        # *   **3**: The job is being executed.
        self.state = state
        # The number of instances that are successfully run.
        self.succeeded = succeeded

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.completion_time is not None:
            result['CompletionTime'] = self.completion_time
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.succeeded is not None:
            result['Succeeded'] = self.succeeded
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('CompletionTime') is not None:
            self.completion_time = m.get('CompletionTime')
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Succeeded') is not None:
            self.succeeded = m.get('Succeeded')
        return self


class DescribeJobHistoryResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        jobs: List[DescribeJobHistoryResponseBodyDataJobs] = None,
        page_size: int = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.current_page = current_page
        # The jobs.
        self.jobs = jobs
        # The number of entries to return on each page. Valid values: 0 to 10000.
        self.page_size = page_size
        # The total number of jobs.
        self.total_size = total_size

    def validate(self):
        if self.jobs:
            for k in self.jobs:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Jobs'] = []
        if self.jobs is not None:
            for k in self.jobs:
                result['Jobs'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.jobs = []
        if m.get('Jobs') is not None:
            for k in m.get('Jobs'):
                temp_model = DescribeJobHistoryResponseBodyDataJobs()
                self.jobs.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class DescribeJobHistoryResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeJobHistoryResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code returned. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The error code returned. Take note of the following rules:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the "**Error codes**" section in this topic.
        self.error_code = error_code
        # The message returned. Take note of the following rules:
        # 
        # *   If the call is successful, **success** is returned.
        # *   If the call fails, an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the call was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeJobHistoryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeJobHistoryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeJobHistoryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeJobHistoryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeJobStatusRequest(TeaModel):
    def __init__(
        self,
        app_id: str = None,
        job_id: str = None,
    ):
        # The ID of the job template.
        # 
        # This parameter is required.
        self.app_id = app_id
        # The job ID.
        self.job_id = job_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_id is not None:
            result['AppId'] = self.app_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppId') is not None:
            self.app_id = m.get('AppId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class DescribeJobStatusResponseBodyData(TeaModel):
    def __init__(
        self,
        active: int = None,
        completion_time: int = None,
        failed: int = None,
        job_id: str = None,
        message: str = None,
        start_time: int = None,
        state: str = None,
        succeeded: int = None,
    ):
        # The number of running instances.
        self.active = active
        # The time when the job was executed.
        self.completion_time = completion_time
        # The number of instances that failed to run.
        self.failed = failed
        # The job ID.
        self.job_id = job_id
        # The returned message. Take note of the following rules:
        # 
        # *   If the call is successful, **success** is returned.
        # *   If the call fails, an error code is returned.
        self.message = message
        # The time when the job was created.
        self.start_time = start_time
        # The status of the job. Valid values:
        # 
        # *   **0**: The job is not executed.
        # *   **1**: The job was executed.
        # *   **2**: The job failed to be executed.
        # *   **3**: The job is being executed.
        self.state = state
        # The number of instances that are successfully run.
        self.succeeded = succeeded

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.active is not None:
            result['Active'] = self.active
        if self.completion_time is not None:
            result['CompletionTime'] = self.completion_time
        if self.failed is not None:
            result['Failed'] = self.failed
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.message is not None:
            result['Message'] = self.message
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.state is not None:
            result['State'] = self.state
        if self.succeeded is not None:
            result['Succeeded'] = self.succeeded
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Active') is not None:
            self.active = m.get('Active')
        if m.get('CompletionTime') is not None:
            self.completion_time = m.get('CompletionTime')
        if m.get('Failed') is not None:
            self.failed = m.get('Failed')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('Succeeded') is not None:
            self.succeeded = m.get('Succeeded')
        return self


class DescribeJobStatusResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeJobStatusResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The error code returned. Take note of the following rules:
        # 
        # *   **ErrorCode** is not returned if the request succeeds.
        # *   **ErrorCode** is returned if the request fails. For more information, see the "**Error codes**" section in this topic.
        self.error_code = error_code
        # The returned message. Take note of the following rules:
        # 
        # *   If the call is successful, **success** is returned.
        # *   If the call fails, an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the call was successful. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeJobStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeJobStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeJobStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeJobStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNamespaceRequest(TeaModel):
    def __init__(
        self,
        name_space_short_id: str = None,
        namespace_id: str = None,
    ):
        # The short ID of the namespace. You do not need to specify a region ID. The value of this parameter can be up to 20 characters in length and can contain only lowercase letters and digits.
        self.name_space_short_id = name_space_short_id
        # The ID of the namespace. The information about the default namespace cannot be queried or modified. The default namespace cannot be deleted.
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DescribeNamespaceResponseBodyData(TeaModel):
    def __init__(
        self,
        enable_micro_registration: bool = None,
        name_space_short_id: str = None,
        namespace_description: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
        region_id: str = None,
    ):
        # Indicates whether the SAE built-in registry is enabled. Valid values:
        # 
        # *   **true**\
        # *   **false**\
        self.enable_micro_registration = enable_micro_registration
        # The short ID of the namespace.
        self.name_space_short_id = name_space_short_id
        # The description of the namespace.
        self.namespace_description = namespace_description
        # The ID of the namespace. The information about the default namespace cannot be queried or modified. The default namespace cannot be deleted.
        self.namespace_id = namespace_id
        # The name of the namespace.
        self.namespace_name = namespace_name
        # The region ID.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable_micro_registration is not None:
            result['EnableMicroRegistration'] = self.enable_micro_registration
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_description is not None:
            result['NamespaceDescription'] = self.namespace_description
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.namespace_name is not None:
            result['NamespaceName'] = self.namespace_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnableMicroRegistration') is not None:
            self.enable_micro_registration = m.get('EnableMicroRegistration')
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceDescription') is not None:
            self.namespace_description = m.get('NamespaceDescription')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NamespaceName') is not None:
            self.namespace_name = m.get('NamespaceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeNamespaceResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeNamespaceResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The information about the namespace.
        self.data = data
        # The error code returned. Take note of the following rules:
        # 
        # *   The **ErrorCode** parameter is not returned if the request succeeds.
        # *   The **ErrorCode** parameter is returned if the request fails. For more information, see the **Error codes** section in this topic.
        self.error_code = error_code
        # The additional information that is returned. Valid values:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the information about the namespace was queried successfully. Valid values:
        # 
        # *   **true**: The information was queried.
        # *   **false**: The image failed to be found.
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeNamespaceResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeNamespaceResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNamespaceResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNamespaceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNamespaceListRequest(TeaModel):
    def __init__(
        self,
        contain_custom: bool = None,
        hybrid_cloud_exclude: bool = None,
    ):
        # Specifies whether to return custom namespaces. Valid values:
        # 
        # *   **true**: The system returns custom namespaces.
        # *   **false**: The system does not return custom namespaces.
        self.contain_custom = contain_custom
        # Specifies whether to exclude hybrid cloud namespaces from the result. Valid values:
        # 
        # - **true**: The system excludes hybrid cloud namespaces from the result.
        # - **false**: The system does not exclude hybrid cloud namespaces from the result.
        self.hybrid_cloud_exclude = hybrid_cloud_exclude

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.contain_custom is not None:
            result['ContainCustom'] = self.contain_custom
        if self.hybrid_cloud_exclude is not None:
            result['HybridCloudExclude'] = self.hybrid_cloud_exclude
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ContainCustom') is not None:
            self.contain_custom = m.get('ContainCustom')
        if m.get('HybridCloudExclude') is not None:
            self.hybrid_cloud_exclude = m.get('HybridCloudExclude')
        return self


class DescribeNamespaceListResponseBodyData(TeaModel):
    def __init__(
        self,
        agent_install: str = None,
        current: bool = None,
        custom: bool = None,
        hybrid_cloud_enable: bool = None,
        name_space_short_id: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
        region_id: str = None,
        security_group_id: str = None,
        v_switch_id: str = None,
        vpc_id: str = None,
    ):
        # The command that was run to install the agent.
        self.agent_install = agent_install
        # This parameter is no longer valid.
        self.current = current
        # Indicates whether custom namespaces are returned. Valid values:
        # 
        # *   **true**: Custom namespaces are returned.
        # *   **false**: Custom namespaces are not returned.
        self.custom = custom
        # Indicates whether hybrid cloud namespaces are excluded. Valid values:
        # 
        # *   **true**: Hybrid cloud namespaces are excluded.
        # *   **false**: Hybrid cloud namespaces are included.
        self.hybrid_cloud_enable = hybrid_cloud_enable
        # The short ID of the namespace.
        self.name_space_short_id = name_space_short_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The name of the namespace.
        self.namespace_name = namespace_name
        # The region to which the namespace belongs.
        self.region_id = region_id
        # The ID of the security group.
        self.security_group_id = security_group_id
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id
        # The ID of the virtual private cloud (VPC).
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_install is not None:
            result['AgentInstall'] = self.agent_install
        if self.current is not None:
            result['Current'] = self.current
        if self.custom is not None:
            result['Custom'] = self.custom
        if self.hybrid_cloud_enable is not None:
            result['HybridCloudEnable'] = self.hybrid_cloud_enable
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.namespace_name is not None:
            result['NamespaceName'] = self.namespace_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AgentInstall') is not None:
            self.agent_install = m.get('AgentInstall')
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('Custom') is not None:
            self.custom = m.get('Custom')
        if m.get('HybridCloudEnable') is not None:
            self.hybrid_cloud_enable = m.get('HybridCloudEnable')
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NamespaceName') is not None:
            self.namespace_name = m.get('NamespaceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DescribeNamespaceListResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: List[DescribeNamespaceListResponseBodyData] = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: The call was successful.
        # *   **3xx**: The call was redirected.
        # *   **4xx**: The call failed.
        # *   **5xx**: A server error occurred.
        self.code = code
        # The namespaces.
        self.data = data
        # The error code. Valid values:
        # 
        # *   If the call is successful, the **ErrorCode** parameter is not returned.
        # *   If the call fails, the **ErrorCode** parameter is returned. For more information, see the **Error codes** section in this topic.
        self.error_code = error_code
        # The returned message. Valid values:
        # 
        # *   success: If the call is successful, **success** is returned.
        # *   An error code: If the call fails, an error code is returned.
        self.message = message
        # The request ID.
        self.request_id = request_id
        # Indicates whether the list of namespaces was queried. Valid values:
        # 
        # *   **true**: The list was queried.
        # *   **false**: The list failed to be queried.
        self.success = success
        # The trace ID that is used to query the details of the request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeNamespaceListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeNamespaceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNamespaceListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNamespaceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNamespaceResourcesRequest(TeaModel):
    def __init__(
        self,
        name_space_short_id: str = None,
        namespace_id: str = None,
    ):
        self.name_space_short_id = name_space_short_id
        # cn-shanghai:test
        self.namespace_id = namespace_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        return self


class DescribeNamespaceResourcesResponseBodyData(TeaModel):
    def __init__(
        self,
        app_count: int = None,
        belong_region: str = None,
        description: str = None,
        jump_server_app_id: str = None,
        jump_server_ip: str = None,
        last_change_order_id: str = None,
        last_change_order_running: bool = None,
        last_change_order_status: str = None,
        name_space_short_id: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
        notification_expired: bool = None,
        security_group_id: str = None,
        tenant_id: str = None,
        user_id: str = None,
        v_switch_id: str = None,
        v_switch_name: str = None,
        vpc_id: str = None,
        vpc_name: str = None,
    ):
        # The number of applications.
        self.app_count = app_count
        # The region to which the namespace belongs.
        self.belong_region = belong_region
        # The description of the namespace.
        self.description = description
        # The ID of the jump server application.
        self.jump_server_app_id = jump_server_app_id
        # The IP address of the jump server.
        self.jump_server_ip = jump_server_ip
        # The ID of the change order.
        self.last_change_order_id = last_change_order_id
        # Indicates whether a change order is being executed in the namespace. Valid values:
        # 
        # *   **true**: indicates that a change order is being executed in the namespace.
        # *   **false**: indicates that no change orders are being executed in the namespace.
        self.last_change_order_running = last_change_order_running
        # The status of the latest change order. Valid values:
        # 
        # *   **READY**: The change order is ready.
        # *   **RUNNING**: The change order is being executed.
        # *   **SUCCESS**: The change order was executed.
        # *   **FAIL**: The change order could not be executed.
        # *   **ABORT**: The change order was terminated.
        # *   **WAIT_BATCH_CONFIRM**: The change order is pending execution. You must manually confirm the release batch.
        # *   **AUTO_BATCH_WAIT**: The change order is pending execution. SAE will automatically confirm the release batch.
        # *   **SYSTEM_FAIL**: A system exception occurred.
        # *   **WAIT_APPROVAL**: The change order is pending approval.
        # *   **APPROVED**: The change order is approved and is pending execution.
        self.last_change_order_status = last_change_order_status
        self.name_space_short_id = name_space_short_id
        # The ID of the namespace.
        self.namespace_id = namespace_id
        # The name of the namespace.
        self.namespace_name = namespace_name
        # Indicates whether the notification of a change order is expired. Valid values:
        # 
        # *   **true**: indicates that the notification is expired.
        # *   **false**: indicates that the notification is not expired.
        self.notification_expired = notification_expired
        # The ID of the security group.
        self.security_group_id = security_group_id
        # The ID of the tenant in the SAE namespace.
        self.tenant_id = tenant_id
        # The ID of the user.
        self.user_id = user_id
        # The ID of the vSwitch.
        self.v_switch_id = v_switch_id
        # The name of the vSwitch.
        self.v_switch_name = v_switch_name
        # The ID of the virtual private cloud (VPC).
        self.vpc_id = vpc_id
        # The name of the VPC.
        self.vpc_name = vpc_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.app_count is not None:
            result['AppCount'] = self.app_count
        if self.belong_region is not None:
            result['BelongRegion'] = self.belong_region
        if self.description is not None:
            result['Description'] = self.description
        if self.jump_server_app_id is not None:
            result['JumpServerAppId'] = self.jump_server_app_id
        if self.jump_server_ip is not None:
            result['JumpServerIp'] = self.jump_server_ip
        if self.last_change_order_id is not None:
            result['LastChangeOrderId'] = self.last_change_order_id
        if self.last_change_order_running is not None:
            result['LastChangeOrderRunning'] = self.last_change_order_running
        if self.last_change_order_status is not None:
            result['LastChangeOrderStatus'] = self.last_change_order_status
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.namespace_name is not None:
            result['NamespaceName'] = self.namespace_name
        if self.notification_expired is not None:
            result['NotificationExpired'] = self.notification_expired
        if self.security_group_id is not None:
            result['SecurityGroupId'] = self.security_group_id
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.user_id is not None:
            result['UserId'] = self.user_id
        if self.v_switch_id is not None:
            result['VSwitchId'] = self.v_switch_id
        if self.v_switch_name is not None:
            result['VSwitchName'] = self.v_switch_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AppCount') is not None:
            self.app_count = m.get('AppCount')
        if m.get('BelongRegion') is not None:
            self.belong_region = m.get('BelongRegion')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('JumpServerAppId') is not None:
            self.jump_server_app_id = m.get('JumpServerAppId')
        if m.get('JumpServerIp') is not None:
            self.jump_server_ip = m.get('JumpServerIp')
        if m.get('LastChangeOrderId') is not None:
            self.last_change_order_id = m.get('LastChangeOrderId')
        if m.get('LastChangeOrderRunning') is not None:
            self.last_change_order_running = m.get('LastChangeOrderRunning')
        if m.get('LastChangeOrderStatus') is not None:
            self.last_change_order_status = m.get('LastChangeOrderStatus')
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NamespaceName') is not None:
            self.namespace_name = m.get('NamespaceName')
        if m.get('NotificationExpired') is not None:
            self.notification_expired = m.get('NotificationExpired')
        if m.get('SecurityGroupId') is not None:
            self.security_group_id = m.get('SecurityGroupId')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        if m.get('VSwitchId') is not None:
            self.v_switch_id = m.get('VSwitchId')
        if m.get('VSwitchName') is not None:
            self.v_switch_name = m.get('VSwitchName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeNamespaceResourcesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeNamespaceResourcesResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request failed.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The returned data.
        self.data = data
        # The error code.
        # 
        # *   The **ErrorCode** parameter is not returned when the request succeeds.
        # *   The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error code is returned when the request fails.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the information about resources in the namespace was queried successfully. Valid values:
        # 
        # *   **true**: indicates that the query was successful.
        # *   **false**: indicates that the query failed.
        self.success = success
        # The ID of the trace. It can be used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeNamespaceResourcesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeNamespaceResourcesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNamespaceResourcesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNamespaceResourcesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeNamespacesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
    ):
        # 1
        # 
        # This parameter is required.
        self.current_page = current_page
        # 10
        # 
        # This parameter is required.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeNamespacesResponseBodyDataNamespaces(TeaModel):
    def __init__(
        self,
        access_key: str = None,
        address_server_host: str = None,
        name_space_short_id: str = None,
        namespace_description: str = None,
        namespace_id: str = None,
        namespace_name: str = None,
        region_id: str = None,
        secret_key: str = None,
        tenant_id: str = None,
    ):
        # The ACM-specific AccessKey ID. It can be used to manage data in an Application Configuration Management (ACM) namespace. For more information, see [Differences between Alibaba Cloud AccessKey and ACM-specific AccessKey](~~~~).
        self.access_key = access_key
        self.address_server_host = address_server_host
        self.name_space_short_id = name_space_short_id
        # The description of the namespace.
        self.namespace_description = namespace_description
        # The ID of the namespace. The information of the default namespace cannot be queried or modified. The default namespace cannot be deleted.
        self.namespace_id = namespace_id
        # The name of the namespace.
        self.namespace_name = namespace_name
        # The ID of the region.
        self.region_id = region_id
        # The ACM-specific AccessKey secret. It can be used to manage data in an ACM namespace. For more information, see [Differences between Alibaba Cloud AccessKey and ACM-specific AccessKey](~~~~).
        self.secret_key = secret_key
        # The ID of the tenant.
        self.tenant_id = tenant_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_key is not None:
            result['AccessKey'] = self.access_key
        if self.address_server_host is not None:
            result['AddressServerHost'] = self.address_server_host
        if self.name_space_short_id is not None:
            result['NameSpaceShortId'] = self.name_space_short_id
        if self.namespace_description is not None:
            result['NamespaceDescription'] = self.namespace_description
        if self.namespace_id is not None:
            result['NamespaceId'] = self.namespace_id
        if self.namespace_name is not None:
            result['NamespaceName'] = self.namespace_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.secret_key is not None:
            result['SecretKey'] = self.secret_key
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessKey') is not None:
            self.access_key = m.get('AccessKey')
        if m.get('AddressServerHost') is not None:
            self.address_server_host = m.get('AddressServerHost')
        if m.get('NameSpaceShortId') is not None:
            self.name_space_short_id = m.get('NameSpaceShortId')
        if m.get('NamespaceDescription') is not None:
            self.namespace_description = m.get('NamespaceDescription')
        if m.get('NamespaceId') is not None:
            self.namespace_id = m.get('NamespaceId')
        if m.get('NamespaceName') is not None:
            self.namespace_name = m.get('NamespaceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SecretKey') is not None:
            self.secret_key = m.get('SecretKey')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class DescribeNamespacesResponseBodyData(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        namespaces: List[DescribeNamespacesResponseBodyDataNamespaces] = None,
        page_size: int = None,
        total_size: int = None,
    ):
        # The page number of the returned page.
        self.current_page = current_page
        # The list of namespaces.
        self.namespaces = namespaces
        # The number of entries returned on each page.
        self.page_size = page_size
        # The total number of namespaces.
        self.total_size = total_size

    def validate(self):
        if self.namespaces:
            for k in self.namespaces:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Namespaces'] = []
        if self.namespaces is not None:
            for k in self.namespaces:
                result['Namespaces'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_size is not None:
            result['TotalSize'] = self.total_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.namespaces = []
        if m.get('Namespaces') is not None:
            for k in m.get('Namespaces'):
                temp_model = DescribeNamespacesResponseBodyDataNamespaces()
                self.namespaces.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalSize') is not None:
            self.total_size = m.get('TotalSize')
        return self


class DescribeNamespacesResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: DescribeNamespacesResponseBodyData = None,
        error_code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
        trace_id: str = None,
    ):
        # The HTTP status code. Valid values:
        # 
        # *   **2xx**: indicates that the request was successful.
        # *   **3xx**: indicates that the request was redirected.
        # *   **4xx**: indicates that the request failed.
        # *   **5xx**: indicates that a server error occurred.
        self.code = code
        # The information of namespaces.
        self.data = data
        # The error code. 
        # 
        # - The **ErrorCode** parameter is not returned when the request succeeds.
        # - The **ErrorCode** parameter is returned when the request fails. For more information, see **Error codes** in this topic.
        self.error_code = error_code
        # The returned message.
        # 
        # *   **success** is returned when the request succeeds.
        # *   An error message is returned when the request fails.
        self.message = message
        # The ID of the request.
        self.request_id = request_id
        # Indicates whether the details of namespaces were queried successfully. Valid values:
        # 
        # *   **true**: indicates that the query was successful.
        # *   **false**: indicates that the query failed.
        self.success = success
        # The ID of the trace. It can be used to query the details of a request.
        self.trace_id = trace_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.trace_id is not None:
            result['TraceId'] = self.trace_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = DescribeNamespacesResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TraceId') is not None:
            self.trace_id = m.get('TraceId')
        return self


class DescribeNamespacesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeNamespacesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeNamespacesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribePipelineRequest(TeaModel):
    def __init__(
        self,
        pipeline_id: str = None,
    ):
        # The ID of the batch. You can call the [DescribeChangeOrder](https://help.aliyun.com/document_detail/126617.html) operation to obtain the ID.
        # 
        # This parameter is required.
        self.pipeline_id = pipeline_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.pipeline_id is not None:
            result['PipelineId'] = self.pipeline_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PipelineId') is not None:
            self.pipeline_id = m.get('PipelineId')
        return self


class DescribePipelineResponseBodyDataStageListTaskList(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_ignore: int = None,
        error_message: str = None,
        message: str = None,
        show_manual_ignore: bool = None,
        stage_id: str = None,
        status: int = None,
        task_id: str = None,
        task_name: str = None,
    ):
        # The error code returned when the task could not be executed. If the task is successfully executed, this parameter is not returned.
        self.error_code = error_code
        # Indicates whether to execute the subsequent tasks when the task failed. Valid values:
        # 
        # *   **0**: The subsequent tasks cannot be executed.
        # *   **1**: The subsequent tasks can be executed.
        self.error_ignore = error_ignore
        # The error message returned when the task could not be executed. If the task is successfully executed, this parameter is not returned.
        self.error_message = error_message
        # The returned message indicating the task execution result.
        self.message = message
        # Indicates whether a running task can be manually skipped. Valid values:
        # 
        # *   **true**: The running task can be skipped.
        # *   **false**: The zone does not allow you to change the network type of an ApsaraDB for Redis instance from classic network to VPC.
        self.show_manual_ignore = show_manual_ignore
        # The ID of the stage.
        self.stage_id = stage_id
        # The task status. Valid values:
        # 
        # *   **0**: The task is prepared for execution.
        # *   **1**: The task is being executed.
        # *   **2**: successful
        # *   **3**: The task could not be executed.
        # *   **5**: The task is pending retry.
        # *   **6**: The task was terminated.
        self.status = status
        # The ID of the task.
        self.task_id = task_id
        # The name of the task.
        self.task_name = task_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_ignore is not None:
            result['ErrorIgnore'] = self.error_ignore
        if self.error_message is not None:
            result['ErrorMessage'] = self.error_message
        if self.message is not None:
            result['Message'] = self.message
        if self.show_manual_ignore is not None:
            result['ShowManualIgnore'] = self.show_manual_ignore
        if self.stage_id is not None:
            result['StageId'] = self.stage_id
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorIgnore') is not None:
            self.error_ignore = m.get('ErrorIgnore')
        if m.get('ErrorMessage') is not None:
            self.error_message = m.get('ErrorMessage')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ShowManualIgnore') is not None:
            self.show_manual_ignore = m.get('ShowManualIgnore')
        if m.get('StageId') is not None:
            self.stage_id = m.get('StageId')
        if m.get('Status') is not None:
           