# WARNING: Please don't edit this file. It was generated by Python/WinRT v1.0.0-beta.4

import enum
import sys
import types
import typing
import uuid

import winsdk._winrt as _winrt

try:
    import winsdk.windows.applicationmodel.background
except Exception:
    pass

try:
    import winsdk.windows.foundation
except Exception:
    pass

try:
    import winsdk.windows.foundation.collections
except Exception:
    pass

try:
    import winsdk.windows.security.credentials
except Exception:
    pass

try:
    import winsdk.windows.storage.streams
except Exception:
    pass

try:
    import winsdk.windows.ui
except Exception:
    pass

try:
    import winsdk.windows.ui.popups
except Exception:
    pass

class DeviceAccessStatus(enum.IntEnum):
    UNSPECIFIED = 0
    ALLOWED = 1
    DENIED_BY_USER = 2
    DENIED_BY_SYSTEM = 3

class DeviceClass(enum.IntEnum):
    ALL = 0
    AUDIO_CAPTURE = 1
    AUDIO_RENDER = 2
    PORTABLE_STORAGE_DEVICE = 3
    VIDEO_CAPTURE = 4
    IMAGE_SCANNER = 5
    LOCATION = 6

class DeviceInformationKind(enum.IntEnum):
    UNKNOWN = 0
    DEVICE_INTERFACE = 1
    DEVICE_CONTAINER = 2
    DEVICE = 3
    DEVICE_INTERFACE_CLASS = 4
    ASSOCIATION_ENDPOINT = 5
    ASSOCIATION_ENDPOINT_CONTAINER = 6
    ASSOCIATION_ENDPOINT_SERVICE = 7
    DEVICE_PANEL = 8

class DevicePairingKinds(enum.IntFlag):
    NONE = 0
    CONFIRM_ONLY = 0x1
    DISPLAY_PIN = 0x2
    PROVIDE_PIN = 0x4
    CONFIRM_PIN_MATCH = 0x8
    PROVIDE_PASSWORD_CREDENTIAL = 0x10

class DevicePairingProtectionLevel(enum.IntEnum):
    DEFAULT = 0
    NONE = 1
    ENCRYPTION = 2
    ENCRYPTION_AND_AUTHENTICATION = 3

class DevicePairingResultStatus(enum.IntEnum):
    PAIRED = 0
    NOT_READY_TO_PAIR = 1
    NOT_PAIRED = 2
    ALREADY_PAIRED = 3
    CONNECTION_REJECTED = 4
    TOO_MANY_CONNECTIONS = 5
    HARDWARE_FAILURE = 6
    AUTHENTICATION_TIMEOUT = 7
    AUTHENTICATION_NOT_ALLOWED = 8
    AUTHENTICATION_FAILURE = 9
    NO_SUPPORTED_PROFILES = 10
    PROTECTION_LEVEL_COULD_NOT_BE_MET = 11
    ACCESS_DENIED = 12
    INVALID_CEREMONY_DATA = 13
    PAIRING_CANCELED = 14
    OPERATION_ALREADY_IN_PROGRESS = 15
    REQUIRED_HANDLER_NOT_REGISTERED = 16
    REJECTED_BY_HANDLER = 17
    REMOTE_DEVICE_HAS_ASSOCIATION = 18
    FAILED = 19

class DevicePickerDisplayStatusOptions(enum.IntFlag):
    NONE = 0
    SHOW_PROGRESS = 0x1
    SHOW_DISCONNECT_BUTTON = 0x2
    SHOW_RETRY_BUTTON = 0x4

class DeviceUnpairingResultStatus(enum.IntEnum):
    UNPAIRED = 0
    ALREADY_UNPAIRED = 1
    OPERATION_ALREADY_IN_PROGRESS = 2
    ACCESS_DENIED = 3
    FAILED = 4

class DeviceWatcherEventKind(enum.IntEnum):
    ADD = 0
    UPDATE = 1
    REMOVE = 2

class DeviceWatcherStatus(enum.IntEnum):
    CREATED = 0
    STARTED = 1
    ENUMERATION_COMPLETED = 2
    STOPPING = 3
    STOPPED = 4
    ABORTED = 5

class Panel(enum.IntEnum):
    UNKNOWN = 0
    FRONT = 1
    BACK = 2
    TOP = 3
    BOTTOM = 4
    LEFT = 5
    RIGHT = 6

class DeviceAccessChangedEventArgs(_winrt.Object, interfaces=[]):
    status: DeviceAccessStatus
    id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceAccessChangedEventArgs: ...

class DeviceAccessInformation(_winrt.Object, interfaces=[]):
    current_status: DeviceAccessStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceAccessInformation: ...
    @staticmethod
    def create_from_device_class(device_class: DeviceClass) -> typing.Optional[DeviceAccessInformation]: ...
    @staticmethod
    def create_from_device_class_id(device_class_id: uuid.UUID) -> typing.Optional[DeviceAccessInformation]: ...
    @staticmethod
    def create_from_id(device_id: str) -> typing.Optional[DeviceAccessInformation]: ...
    def add_access_changed(self, handler: winsdk.windows.foundation.TypedEventHandler[DeviceAccessInformation, DeviceAccessChangedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_access_changed(self, cookie: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class DeviceConnectionChangeTriggerDetails(_winrt.Object, interfaces=[]):
    device_id: str
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceConnectionChangeTriggerDetails: ...

class DeviceDisconnectButtonClickedEventArgs(_winrt.Object, interfaces=[]):
    device: typing.Optional[DeviceInformation]
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceDisconnectButtonClickedEventArgs: ...

class DeviceInformation(_winrt.Object, interfaces=[]):
    enclosure_location: typing.Optional[EnclosureLocation]
    id: str
    is_default: _winrt.Boolean
    is_enabled: _winrt.Boolean
    name: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]]
    kind: DeviceInformationKind
    pairing: typing.Optional[DeviceInformationPairing]
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceInformation: ...
    @typing.overload
    @staticmethod
    def create_from_id_async(device_id: str) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformation]: ...
    @typing.overload
    @staticmethod
    def create_from_id_async(device_id: str, additional_properties: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformation]: ...
    @typing.overload
    @staticmethod
    def create_from_id_async(device_id: str, additional_properties: typing.Iterable[str], kind: DeviceInformationKind) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformation]: ...
    @typing.overload
    @staticmethod
    def create_watcher() -> typing.Optional[DeviceWatcher]: ...
    @typing.overload
    @staticmethod
    def create_watcher(device_class: DeviceClass) -> typing.Optional[DeviceWatcher]: ...
    @typing.overload
    @staticmethod
    def create_watcher(aqs_filter: str, additional_properties: typing.Iterable[str]) -> typing.Optional[DeviceWatcher]: ...
    @typing.overload
    @staticmethod
    def create_watcher(aqs_filter: str, additional_properties: typing.Iterable[str], kind: DeviceInformationKind) -> typing.Optional[DeviceWatcher]: ...
    @typing.overload
    @staticmethod
    def find_all_async() -> winsdk.windows.foundation.IAsyncOperation[DeviceInformationCollection]: ...
    @typing.overload
    @staticmethod
    def find_all_async(device_class: DeviceClass) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformationCollection]: ...
    @typing.overload
    @staticmethod
    def find_all_async(aqs_filter: str, additional_properties: typing.Iterable[str]) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformationCollection]: ...
    @typing.overload
    @staticmethod
    def find_all_async(aqs_filter: str, additional_properties: typing.Iterable[str], kind: DeviceInformationKind) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformationCollection]: ...
    @staticmethod
    def get_aqs_filter_from_device_class(device_class: DeviceClass) -> str: ...
    def get_glyph_thumbnail_async(self) -> winsdk.windows.foundation.IAsyncOperation[DeviceThumbnail]: ...
    def get_thumbnail_async(self) -> winsdk.windows.foundation.IAsyncOperation[DeviceThumbnail]: ...
    def update(self, update_info: typing.Optional[DeviceInformationUpdate]) -> None: ...

class DeviceInformationCollection(_winrt.Object, interfaces=[winsdk.windows.foundation.collections.IVectorView[DeviceInformation], winsdk.windows.foundation.collections.IIterable[DeviceInformation]]):
    size: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceInformationCollection: ...
    def first(self) -> typing.Optional[winsdk.windows.foundation.collections.IIterator[DeviceInformation]]: ...
    def get_at(self, index: _winrt.UInt32) -> typing.Optional[DeviceInformation]: ...
    def get_many(self, start_index: _winrt.UInt32, items_size: _winrt.UInt32) -> typing.Tuple[_winrt.UInt32, typing.List[typing.Optional[DeviceInformation]]]: ...
    def index_of(self, value: typing.Optional[DeviceInformation]) -> typing.Tuple[_winrt.Boolean, _winrt.UInt32]: ...

class DeviceInformationCustomPairing(_winrt.Object, interfaces=[]):
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceInformationCustomPairing: ...
    @typing.overload
    def pair_async(self, pairing_kinds_supported: DevicePairingKinds) -> winsdk.windows.foundation.IAsyncOperation[DevicePairingResult]: ...
    @typing.overload
    def pair_async(self, pairing_kinds_supported: DevicePairingKinds, min_protection_level: DevicePairingProtectionLevel) -> winsdk.windows.foundation.IAsyncOperation[DevicePairingResult]: ...
    @typing.overload
    def pair_async(self, pairing_kinds_supported: DevicePairingKinds, min_protection_level: DevicePairingProtectionLevel, device_pairing_settings: typing.Optional[IDevicePairingSettings]) -> winsdk.windows.foundation.IAsyncOperation[DevicePairingResult]: ...
    def add_pairing_requested(self, handler: winsdk.windows.foundation.TypedEventHandler[DeviceInformationCustomPairing, DevicePairingRequestedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_pairing_requested(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class DeviceInformationPairing(_winrt.Object, interfaces=[]):
    can_pair: _winrt.Boolean
    is_paired: _winrt.Boolean
    custom: typing.Optional[DeviceInformationCustomPairing]
    protection_level: DevicePairingProtectionLevel
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceInformationPairing: ...
    @typing.overload
    def pair_async(self) -> winsdk.windows.foundation.IAsyncOperation[DevicePairingResult]: ...
    @typing.overload
    def pair_async(self, min_protection_level: DevicePairingProtectionLevel) -> winsdk.windows.foundation.IAsyncOperation[DevicePairingResult]: ...
    @typing.overload
    def pair_async(self, min_protection_level: DevicePairingProtectionLevel, device_pairing_settings: typing.Optional[IDevicePairingSettings]) -> winsdk.windows.foundation.IAsyncOperation[DevicePairingResult]: ...
    @staticmethod
    def try_register_for_all_inbound_pairing_requests(pairing_kinds_supported: DevicePairingKinds) -> _winrt.Boolean: ...
    @staticmethod
    def try_register_for_all_inbound_pairing_requests_with_protection_level(pairing_kinds_supported: DevicePairingKinds, min_protection_level: DevicePairingProtectionLevel) -> _winrt.Boolean: ...
    def unpair_async(self) -> winsdk.windows.foundation.IAsyncOperation[DeviceUnpairingResult]: ...

class DeviceInformationUpdate(_winrt.Object, interfaces=[]):
    id: str
    properties: typing.Optional[winsdk.windows.foundation.collections.IMapView[str, _winrt.Object]]
    kind: DeviceInformationKind
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceInformationUpdate: ...

class DevicePairingRequestedEventArgs(_winrt.Object, interfaces=[]):
    device_information: typing.Optional[DeviceInformation]
    pairing_kind: DevicePairingKinds
    pin: str
    @staticmethod
    def _from(obj: _winrt.Object) -> DevicePairingRequestedEventArgs: ...
    @typing.overload
    def accept(self) -> None: ...
    @typing.overload
    def accept(self, pin: str) -> None: ...
    def accept_with_password_credential(self, password_credential: typing.Optional[winsdk.windows.security.credentials.PasswordCredential]) -> None: ...
    def get_deferral(self) -> typing.Optional[winsdk.windows.foundation.Deferral]: ...

class DevicePairingResult(_winrt.Object, interfaces=[]):
    protection_level_used: DevicePairingProtectionLevel
    status: DevicePairingResultStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> DevicePairingResult: ...

class DevicePicker(_winrt.Object, interfaces=[]):
    appearance: typing.Optional[DevicePickerAppearance]
    filter: typing.Optional[DevicePickerFilter]
    requested_properties: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: _winrt.Object) -> DevicePicker: ...
    def __init__(self) -> None: ...
    def hide(self) -> None: ...
    @typing.overload
    def pick_single_device_async(self, selection: winsdk.windows.foundation.Rect) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformation]: ...
    @typing.overload
    def pick_single_device_async(self, selection: winsdk.windows.foundation.Rect, placement: winsdk.windows.ui.popups.Placement) -> winsdk.windows.foundation.IAsyncOperation[DeviceInformation]: ...
    def set_display_status(self, device: typing.Optional[DeviceInformation], status: str, options: DevicePickerDisplayStatusOptions) -> None: ...
    @typing.overload
    def show(self, selection: winsdk.windows.foundation.Rect) -> None: ...
    @typing.overload
    def show(self, selection: winsdk.windows.foundation.Rect, placement: winsdk.windows.ui.popups.Placement) -> None: ...
    def add_device_picker_dismissed(self, handler: winsdk.windows.foundation.TypedEventHandler[DevicePicker, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_device_picker_dismissed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_device_selected(self, handler: winsdk.windows.foundation.TypedEventHandler[DevicePicker, DeviceSelectedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_device_selected(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_disconnect_button_clicked(self, handler: winsdk.windows.foundation.TypedEventHandler[DevicePicker, DeviceDisconnectButtonClickedEventArgs]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_disconnect_button_clicked(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class DevicePickerAppearance(_winrt.Object, interfaces=[]):
    title: str
    selected_foreground_color: winsdk.windows.ui.Color
    selected_background_color: winsdk.windows.ui.Color
    selected_accent_color: winsdk.windows.ui.Color
    foreground_color: winsdk.windows.ui.Color
    background_color: winsdk.windows.ui.Color
    accent_color: winsdk.windows.ui.Color
    @staticmethod
    def _from(obj: _winrt.Object) -> DevicePickerAppearance: ...

class DevicePickerFilter(_winrt.Object, interfaces=[]):
    supported_device_classes: typing.Optional[winsdk.windows.foundation.collections.IVector[DeviceClass]]
    supported_device_selectors: typing.Optional[winsdk.windows.foundation.collections.IVector[str]]
    @staticmethod
    def _from(obj: _winrt.Object) -> DevicePickerFilter: ...

class DeviceSelectedEventArgs(_winrt.Object, interfaces=[]):
    selected_device: typing.Optional[DeviceInformation]
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceSelectedEventArgs: ...

class DeviceThumbnail(_winrt.Object, interfaces=[winsdk.windows.storage.streams.IRandomAccessStreamWithContentType, winsdk.windows.storage.streams.IContentTypeProvider, winsdk.windows.storage.streams.IRandomAccessStream, winsdk.windows.storage.streams.IOutputStream, winsdk.windows.foundation.IClosable, winsdk.windows.storage.streams.IInputStream]):
    content_type: str
    size: _winrt.UInt64
    can_read: _winrt.Boolean
    can_write: _winrt.Boolean
    position: _winrt.UInt64
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceThumbnail: ...
    def clone_stream(self) -> typing.Optional[winsdk.windows.storage.streams.IRandomAccessStream]: ...
    def close(self) -> None: ...
    def flush_async(self) -> winsdk.windows.foundation.IAsyncOperation[_winrt.Boolean]: ...
    def get_input_stream_at(self, position: _winrt.UInt64) -> typing.Optional[winsdk.windows.storage.streams.IInputStream]: ...
    def get_output_stream_at(self, position: _winrt.UInt64) -> typing.Optional[winsdk.windows.storage.streams.IOutputStream]: ...
    def read_async(self, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer], count: _winrt.UInt32, options: winsdk.windows.storage.streams.InputStreamOptions) -> winsdk.windows.foundation.IAsyncOperationWithProgress[winsdk.windows.storage.streams.IBuffer, _winrt.UInt32]: ...
    def seek(self, position: _winrt.UInt64) -> None: ...
    def write_async(self, buffer: typing.Optional[winsdk.windows.storage.streams.IBuffer]) -> winsdk.windows.foundation.IAsyncOperationWithProgress[_winrt.UInt32, _winrt.UInt32]: ...

class DeviceUnpairingResult(_winrt.Object, interfaces=[]):
    status: DeviceUnpairingResultStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceUnpairingResult: ...

class DeviceWatcher(_winrt.Object, interfaces=[]):
    status: DeviceWatcherStatus
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceWatcher: ...
    def get_background_trigger(self, requested_event_kinds: typing.Iterable[DeviceWatcherEventKind]) -> typing.Optional[winsdk.windows.applicationmodel.background.DeviceWatcherTrigger]: ...
    def start(self) -> None: ...
    def stop(self) -> None: ...
    def add_added(self, handler: winsdk.windows.foundation.TypedEventHandler[DeviceWatcher, DeviceInformation]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_added(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_enumeration_completed(self, handler: winsdk.windows.foundation.TypedEventHandler[DeviceWatcher, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_enumeration_completed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_removed(self, handler: winsdk.windows.foundation.TypedEventHandler[DeviceWatcher, DeviceInformationUpdate]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_removed(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_stopped(self, handler: winsdk.windows.foundation.TypedEventHandler[DeviceWatcher, _winrt.Object]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_stopped(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...
    def add_updated(self, handler: winsdk.windows.foundation.TypedEventHandler[DeviceWatcher, DeviceInformationUpdate]) -> winsdk.windows.foundation.EventRegistrationToken: ...
    def remove_updated(self, token: winsdk.windows.foundation.EventRegistrationToken) -> None: ...

class DeviceWatcherEvent(_winrt.Object, interfaces=[]):
    device_information: typing.Optional[DeviceInformation]
    device_information_update: typing.Optional[DeviceInformationUpdate]
    kind: DeviceWatcherEventKind
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceWatcherEvent: ...

class DeviceWatcherTriggerDetails(_winrt.Object, interfaces=[]):
    device_watcher_events: typing.Optional[winsdk.windows.foundation.collections.IVectorView[DeviceWatcherEvent]]
    @staticmethod
    def _from(obj: _winrt.Object) -> DeviceWatcherTriggerDetails: ...

class EnclosureLocation(_winrt.Object, interfaces=[]):
    in_dock: _winrt.Boolean
    in_lid: _winrt.Boolean
    panel: Panel
    rotation_angle_in_degrees_clockwise: _winrt.UInt32
    @staticmethod
    def _from(obj: _winrt.Object) -> EnclosureLocation: ...

class IDevicePairingSettings(typing.Protocol):
    @staticmethod
    def _from(obj: _winrt.Object) -> IDevicePairingSettings: ...

