#!/usr/bin/python
"""
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.
   
    This file is part of Catapult.
   
    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.
   
    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.
   
    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
"""

from __future__ import annotations

from enum import Enum


class ReceiptTypeDto(Enum):
    """Enumeration of receipt types."""

    """Reserved receipt type."""
    RESERVED = 0
    """Mosaic rental fee receipt type."""
    MOSAIC_RENTAL_FEE = 4685
    """Namespace rental fee receipt type."""
    NAMESPACE_RENTAL_FEE = 4942
    """Harvest fee receipt type."""
    HARVEST_FEE = 8515
    """Lock hash completed receipt type."""
    LOCK_HASH_COMPLETED = 8776
    """Lock hash expired receipt type."""
    LOCK_HASH_EXPIRED = 9032
    """Lock secret completed receipt type."""
    LOCK_SECRET_COMPLETED = 8786
    """Lock secret expired receipt type."""
    LOCK_SECRET_EXPIRED = 9042
    """Lock hash created receipt type."""
    LOCK_HASH_CREATED = 12616
    """Lock secret created receipt type."""
    LOCK_SECRET_CREATED = 12626
    """Mosaic expired receipt type."""
    MOSAIC_EXPIRED = 16717
    """Namespace expired receipt type."""
    NAMESPACE_EXPIRED = 16718
    """Namespace deleted receipt type."""
    NAMESPACE_DELETED = 16974
    """Inflation receipt type."""
    INFLATION = 20803
    """Transaction group receipt type."""
    TRANSACTION_GROUP = 57667
    """Address alias resolution receipt type."""
    ADDRESS_ALIAS_RESOLUTION = 61763
    """Mosaic alias resolution receipt type."""
    MOSAIC_ALIAS_RESOLUTION = 62019
