# Generated by Django 4.2.2 on 2023-09-04 13:46

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import odevlib.fields.rbac_model
import timescale.db.models.fields


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("odevlib", "0001_initial_models"),
    ]

    operations = [
        migrations.AlterField(
            model_name="historicalinstanceroleassignment",
            name="model",
            field=odevlib.fields.rbac_model.RBACModelField(
                max_length=255, verbose_name="Full model name"
            ),
        ),
        migrations.AlterField(
            model_name="instanceroleassignment",
            name="model",
            field=odevlib.fields.rbac_model.RBACModelField(
                max_length=255, verbose_name="Full model name"
            ),
        ),
        migrations.CreateModel(
            name="RequestLogEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "time",
                    timescale.db.models.fields.TimescaleDateTimeField(interval="1 day"),
                ),
                (
                    "application",
                    models.CharField(max_length=32, verbose_name="Application name"),
                ),
                ("method", models.CharField(max_length=7, verbose_name="HTTP method")),
                ("path", models.CharField(max_length=511, verbose_name="HTTP path")),
                ("code", models.IntegerField(verbose_name="HTTP status code")),
                (
                    "processing_time",
                    models.IntegerField(verbose_name="Request execution time (ms)"),
                ),
                (
                    "request",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Request body (in case of non-2xx status code)",
                    ),
                ),
                (
                    "response",
                    models.TextField(
                        blank=True,
                        null=True,
                        verbose_name="Response body (in case of non-2xx status code)",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="requestlogentries",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Пользователь",
                    ),
                ),
            ],
            options={
                "verbose_name": "Запись лога запросов",
                "verbose_name_plural": "Записи лога запросов",
            },
        ),
    ]
