# Generated by Django 4.1.7 on 2023-04-03 07:31

from django.conf import settings
import django.contrib.postgres.fields.hstore
from django.contrib.postgres.operations import HStoreExtension
from django.db import migrations, models, connection
import django.db.models.deletion
import django.utils.timezone
import simple_history.models


def configure_odevlib(apps, schema):
    """
    Populates database with ODevLib built-in stuff.
    """

    # Create the system user that is used by ODevLib to create objects.
    # It is deactivated and should not be used by anybody.
    # This user is assigned as creator/editor of all objects touched by ODevLib itself, like core permissions.
    User = apps.get_model(settings.AUTH_USER_MODEL)

    user = User(
        username="system",
        email="system@o.dev",
        is_active=False,
        is_staff=False,
        is_superuser=False,
    )
    if hasattr(user, "first_name"):
        user.first_name = "System"
    if hasattr(user, "last_name"):
        user.last_name = ""
    if hasattr(user, "name"):
        user.name = "System"
    user.save()

    # Create the most flexible SPS permissions for SPS and RBAC configuration.
    # Every aspect of CRUD may be controlled with these.
    SimplePermissionSystemPermission = apps.get_model("odevlib.simplepermissionsystempermission")

    permissions = [
        SimplePermissionSystemPermission(
            name="Can view SPS",
            subsystem="sps",
            can_create=False,
            can_read=True,
            can_update=False,
            can_delete=False,
            created_by=user,
            updated_by=user,
        ),
        SimplePermissionSystemPermission(
            name="Can create SPS",
            subsystem="sps",
            can_create=True,
            can_read=False,
            can_update=False,
            can_delete=False,
            created_by=user,
            updated_by=user,
        ),
        SimplePermissionSystemPermission(
            name="Can update SPS",
            subsystem="sps",
            can_create=False,
            can_read=False,
            can_update=True,
            can_delete=False,
            created_by=user,
            updated_by=user,
        ),
        SimplePermissionSystemPermission(
            name="Can delete SPS",
            subsystem="sps",
            can_create=False,
            can_read=False,
            can_update=False,
            can_delete=True,
            created_by=user,
            updated_by=user,
        ),
        SimplePermissionSystemPermission(
            name="Can view RBAC",
            subsystem="rbac",
            can_create=False,
            can_read=True,
            can_update=False,
            can_delete=False,
            created_by=user,
            updated_by=user,
        ),
        SimplePermissionSystemPermission(
            name="Can create RBAC",
            subsystem="rbac",
            can_create=True,
            can_read=False,
            can_update=False,
            can_delete=False,
            created_by=user,
            updated_by=user,
        ),
        SimplePermissionSystemPermission(
            name="Can update RBAC",
            subsystem="rbac",
            can_create=False,
            can_read=False,
            can_update=True,
            can_delete=False,
            created_by=user,
            updated_by=user,
        ),
        SimplePermissionSystemPermission(
            name="Can delete RBAC",
            subsystem="rbac",
            can_create=False,
            can_read=False,
            can_update=False,
            can_delete=True,
            created_by=user,
            updated_by=user,
        ),
    ]

    SimplePermissionSystemPermission.objects.bulk_create(permissions)


def create_rbac_role_immutability_trigger(apps, schema):
    with connection.cursor() as c:
        c.execute(
            """
            create or replace function table_update_guard() returns trigger
            language plpgsql immutable parallel safe cost 1 as $body$
            begin
              raise exception
                'trigger %: updating is prohibited for %',
                tg_name, tg_argv[0]
                using errcode = 'restrict_violation';
              return null;
            end;
            $body$;
        """
        )
        c.execute(
            """
            create trigger odevlib_rbacrole_name_guard
            before update of name on odevlib_rbacrole 
            for each row when (old.name is distinct from new.name)
            execute function table_update_guard('name');
        """
        )


def delete_rbac_role_immutability_trigger(apps, schema):
    with connection.cursor() as c:
        c.execute("drop trigger if exists odevlib_rbacrole_name_guard on odevlib_rbacrole;")


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        HStoreExtension(),
        migrations.CreateModel(
            name="Error",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("error_code", models.IntegerField(verbose_name="Код ошибки")),
                (
                    "eng_description",
                    models.TextField(verbose_name="Техническое описание ошибки для разработчиков"),
                ),
                (
                    "ui_description",
                    models.TextField(
                        default="",
                        help_text="Можно показывать пользователю в диалоговом окне для ошибок",
                        verbose_name="Описание для UI",
                    ),
                ),
                ("stacktrace", models.TextField(default="", verbose_name="Stacktrace")),
                (
                    "created_date",
                    models.DateTimeField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="Время ошибки",
                    ),
                ),
                (
                    "handled_gracefully",
                    models.BooleanField(
                        default=True,
                        verbose_name="Была ли ошибка обработана кодом (или поймана exception handler middleware'ом)",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RBACRole",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Дата редактирования"),
                ),
                ("name", models.TextField(verbose_name="Название роли")),
                ("ui_name", models.TextField(verbose_name="Название роли для UI")),
                (
                    "permissions",
                    django.contrib.postgres.fields.hstore.HStoreField(verbose_name="Permissions assigned to this role"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="created_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="updated_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
            ],
            options={
                "verbose_name": "RBAC Role",
                "verbose_name_plural": "RBAC Roles",
            },
        ),
        migrations.CreateModel(
            name="SimplePermissionSystemPermission",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Дата редактирования"),
                ),
                (
                    "subsystem",
                    models.CharField(
                        help_text="Subsystem that this permission is responsible for. Permission checker only looks for this field.",
                        max_length=255,
                        verbose_name="Subsystem",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="Name of the permission. Used in UI. Must be unique.",
                        max_length=255,
                        unique=True,
                        verbose_name="Name",
                    ),
                ),
                ("can_create", models.BooleanField()),
                ("can_read", models.BooleanField()),
                ("can_update", models.BooleanField()),
                ("can_delete", models.BooleanField()),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="created_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="updated_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
            ],
            options={
                "verbose_name": "Simple permission",
                "verbose_name_plural": "Simple permissions",
            },
        ),
        migrations.CreateModel(
            name="RoleHierarchyEntry",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Дата редактирования"),
                ),
                (
                    "child_role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="hierarchy_parents",
                        to="odevlib.rbacrole",
                        verbose_name="Child role",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="created_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "parent_role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="hierarchy_children",
                        to="odevlib.rbacrole",
                        verbose_name="Parent role",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="updated_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
            ],
            options={
                "verbose_name": "Role Hierarchy Entry",
                "verbose_name_plural": "Role Hierarchy Entries",
            },
        ),
        migrations.CreateModel(
            name="RoleAssignment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Дата редактирования"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="created_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rbac_assignments",
                        to="odevlib.rbacrole",
                        verbose_name="Роль",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="updated_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="rbac_assignments",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Пользователь",
                    ),
                ),
            ],
            options={
                "verbose_name": "Присвоение роли",
                "verbose_name_plural": "Присвоения ролей",
            },
        ),
        migrations.CreateModel(
            name="InstanceRoleAssignment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Дата редактирования"),
                ),
                (
                    "model",
                    models.CharField(
                        help_text="Format is app_model",
                        max_length=255,
                        verbose_name="Full model name",
                    ),
                ),
                (
                    "instance_id",
                    models.IntegerField(verbose_name="ID of a particular model instance"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="created_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="odevlib.rbacrole",
                        verbose_name="Role",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="updated_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Role assignment for instance",
                "verbose_name_plural": "Role assignments for instances",
            },
        ),
        migrations.CreateModel(
            name="HistoricalSimplePermissionSystemPermission",
            fields=[
                (
                    "id",
                    models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID"),
                ),
                (
                    "created_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата редактирования"),
                ),
                (
                    "subsystem",
                    models.CharField(
                        help_text="Subsystem that this permission is responsible for. Permission checker only looks for this field.",
                        max_length=255,
                        verbose_name="Subsystem",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        db_index=True,
                        help_text="Name of the permission. Used in UI. Must be unique.",
                        max_length=255,
                        verbose_name="Name",
                    ),
                ),
                ("can_create", models.BooleanField()),
                ("can_read", models.BooleanField()),
                ("can_update", models.BooleanField()),
                ("can_delete", models.BooleanField()),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Simple permission",
                "verbose_name_plural": "historical Simple permissions",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalSimplePermissionAssignment",
            fields=[
                (
                    "id",
                    models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID"),
                ),
                (
                    "created_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата редактирования"),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "permission",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="odevlib.simplepermissionsystempermission",
                        verbose_name="Permission",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Simple permission assignment",
                "verbose_name_plural": "historical Simple permission assignments",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalRoleHierarchyEntry",
            fields=[
                (
                    "id",
                    models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID"),
                ),
                (
                    "created_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата редактирования"),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "child_role",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="odevlib.rbacrole",
                        verbose_name="Child role",
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_role",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="odevlib.rbacrole",
                        verbose_name="Parent role",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Role Hierarchy Entry",
                "verbose_name_plural": "historical Role Hierarchy Entries",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalRoleAssignment",
            fields=[
                (
                    "id",
                    models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID"),
                ),
                (
                    "created_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата редактирования"),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="odevlib.rbacrole",
                        verbose_name="Роль",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Пользователь",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Присвоение роли",
                "verbose_name_plural": "historical Присвоения ролей",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalRBACRole",
            fields=[
                (
                    "id",
                    models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID"),
                ),
                (
                    "created_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата редактирования"),
                ),
                ("name", models.TextField(verbose_name="Название роли")),
                ("ui_name", models.TextField(verbose_name="Название роли для UI")),
                (
                    "permissions",
                    django.contrib.postgres.fields.hstore.HStoreField(verbose_name="Permissions assigned to this role"),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical RBAC Role",
                "verbose_name_plural": "historical RBAC Roles",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="HistoricalInstanceRoleAssignment",
            fields=[
                (
                    "id",
                    models.BigIntegerField(auto_created=True, blank=True, db_index=True, verbose_name="ID"),
                ),
                (
                    "created_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(blank=True, editable=False, verbose_name="Дата редактирования"),
                ),
                (
                    "model",
                    models.CharField(
                        help_text="Format is app_model",
                        max_length=255,
                        verbose_name="Full model name",
                    ),
                ),
                (
                    "instance_id",
                    models.IntegerField(verbose_name="ID of a particular model instance"),
                ),
                ("history_id", models.AutoField(primary_key=True, serialize=False)),
                ("history_date", models.DateTimeField(db_index=True)),
                ("history_change_reason", models.CharField(max_length=100, null=True)),
                (
                    "history_type",
                    models.CharField(
                        choices=[("+", "Created"), ("~", "Changed"), ("-", "Deleted")],
                        max_length=1,
                    ),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "history_user",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to="odevlib.rbacrole",
                        verbose_name="Role",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name="+",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "historical Role assignment for instance",
                "verbose_name_plural": "historical Role assignments for instances",
                "ordering": ("-history_date", "-history_id"),
                "get_latest_by": ("history_date", "history_id"),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name="SimplePermissionAssignment",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created_at",
                    models.DateTimeField(auto_now_add=True, verbose_name="Дата создания"),
                ),
                (
                    "updated_at",
                    models.DateTimeField(auto_now=True, verbose_name="Дата редактирования"),
                ),
                (
                    "created_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="created_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Создатель",
                    ),
                ),
                (
                    "permission",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="odevlib.simplepermissionsystempermission",
                        verbose_name="Permission",
                    ),
                ),
                (
                    "updated_by",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="updated_%(model_name)ss",
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="Последний редактор",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                        verbose_name="User",
                    ),
                ),
            ],
            options={
                "verbose_name": "Simple permission assignment",
                "verbose_name_plural": "Simple permission assignments",
                "unique_together": {("user", "permission")},
            },
        ),
        migrations.RunPython(
            code=create_rbac_role_immutability_trigger,
            reverse_code=delete_rbac_role_immutability_trigger,
        ),
        migrations.RunPython(
            configure_odevlib,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
