import pytest

from aiopytesseract.constants import (
    AIOPYTESSERACT_DEFAULT_DPI,
    AIOPYTESSERACT_DEFAULT_ENCODING,
    AIOPYTESSERACT_DEFAULT_LANGUAGE,
    AIOPYTESSERACT_DEFAULT_OEM,
    AIOPYTESSERACT_DEFAULT_PSM,
    AIOPYTESSERACT_DEFAULT_TIMEOUT,
    OCR_ENGINE_MODES,
    OUTPUT_FILE_EXTENSIONS,
    PAGE_SEGMENTATION_MODES,
    TESSERACT_CMD,
    TESSERACT_LANGUAGES,
)


@pytest.mark.parametrize(
    "var, expected",
    [
        (TESSERACT_CMD, "tesseract"),
        (AIOPYTESSERACT_DEFAULT_ENCODING, "utf-8"),
        (AIOPYTESSERACT_DEFAULT_TIMEOUT, 30),
        (AIOPYTESSERACT_DEFAULT_LANGUAGE, "eng"),
        (AIOPYTESSERACT_DEFAULT_DPI, 300),
        (AIOPYTESSERACT_DEFAULT_PSM, 3),
        (AIOPYTESSERACT_DEFAULT_OEM, 3),
    ],
)
def test_default_constanst_values(var, expected):
    assert var == expected


def test_tesseract_languages_supported():
    assert TESSERACT_LANGUAGES == {
        "afr",
        "amh",
        "ara",
        "asm",
        "aze",
        "aze_cyrl",
        "bel",
        "ben",
        "bod",
        "bos",
        "bre",
        "bul",
        "cat",
        "ceb",
        "ces",
        "chi_sim",
        "chi_tra",
        "chr",
        "cos",
        "cym",
        "dan",
        "dan_frak",
        "deu",
        "deu_frak",
        "dzo",
        "ell",
        "eng",
        "enm",
        "epo",
        "equ",
        "est",
        "eus",
        "fao",
        "fas",
        "fil",
        "fin",
        "fra",
        "frk",
        "frm",
        "fry",
        "gla",
        "gle",
        "glg",
        "grc",
        "guj",
        "hat",
        "heb",
        "hin",
        "hrv",
        "hun",
        "hye",
        "iku",
        "ind",
        "isl",
        "ita",
        "ita_old",
        "jav",
        "jpn",
        "kan",
        "kat",
        "kat_old",
        "kaz",
        "khm",
        "kir",
        "kmr",
        "kor",
        "kor_vert",
        "kur",
        "lao",
        "lat",
        "lav",
        "lit",
        "ltz",
        "mal",
        "mar",
        "mkd",
        "mlt",
        "mon",
        "mri",
        "msa",
        "mya",
        "nep",
        "nld",
        "nor",
        "oci",
        "osd",
        "pan",
        "pol",
        "por",
        "pus",
        "que",
        "ron",
        "rus",
        "san",
        "sin",
        "slk",
        "slk_frak",
        "slv",
        "snd",
        "spa",
        "spa_old",
        "sqi",
        "srp_latn",
        "sun",
        "swa",
        "swe",
        "syr",
        "tam",
        "tat",
        "tel",
        "tgk",
        "tgl",
        "tha",
        "tir",
        "ton",
        "tur",
        "uig",
        "ukr",
        "urd",
        "uzb",
        "uzb_cyrl",
        "vie",
        "yid",
        "yor",
    }


def test_psm_valid_values():
    for value in range(14):
        assert value in PAGE_SEGMENTATION_MODES


def test_oem_valid_values():
    for value in range(4):
        assert value in OCR_ENGINE_MODES


@pytest.mark.parametrize("ext", [".xml", ".hocr", ".pdf", ".tsv", ".txt"])
def test_output_file_extensions_supported(ext):
    assert ext in OUTPUT_FILE_EXTENSIONS.values()
