from pydantic import Field

from moysklad_api.methods.base import MSMethod
from moysklad_api.types import ProductUpdate


class UpdateProducts(MSMethod[ProductUpdate]):
    """
    Use this method to mass update products.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/dictionaries/#suschnosti-towar-massowoe-sozdanie-i-obnowlenie-towarow
    """

    __return__ = list[ProductUpdate]
    __api_method__ = "entity/product"

    data: list[ProductUpdate] = Field(..., alias="products")
    """List of products"""
