from pydantic import Field

from moysklad_api.methods.base import MSMethod
from moysklad_api.types import ProductUpdate


class UpdateProduct(MSMethod[ProductUpdate]):
    """
    Use this method to update product by id.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/dictionaries/#suschnosti-towar
    """

    __return__ = ProductUpdate
    __api_method__ = "entity/product"

    id: str = Field(..., alias="product_id")
    """Id of the product"""

    name: str | None = None
    """Name of the product"""

    description: str | None = None
    """Description of the product"""

    code: str | None = None
    """Internal code of the product"""

    external_code: str | None = None
    """External code of the product"""

    archived: bool | None = None
    """Whether the product is archived"""

    article: str | None = None
    """Article number of the product"""

    group: str | None = None
    """Group ID of the product"""

    product_folder: str | None = Field(None, alias="productFolder")
    """ID of the product folder"""

    sale_prices: list[dict] | None = Field(None, alias="salePrices")
    """List of sale prices"""

    attributes: list[dict] | None = None
    """Custom attributes of the product"""

    barcodes: list[dict] | None = None
    """List of barcodes"""

    min_price: dict | None = Field(None, alias="minPrice")
    """Minimum price"""

    uom: str | None = None
    """Unit of measurement ID"""

    tracking_type: str | None = Field(None, alias="trackingType")
    """Tracking type (serial/batch)"""

    is_serial_trackable: bool | None = Field(None, alias="isSerialTrackable")
    """Whether the product is serial trackable"""

    files: list[dict] | None = None
    """Attached files"""

    images: list[dict] | None = None
    """Attached images"""

    packs: list[dict] | None = None
    """Packaging information"""

    owner: str | None = None
    """Owner ID"""

    supplier: str | None = None
    """Supplier ID"""

    shared: bool | None = None
    """Whether the product is shared"""

    effective_vat: int | None = Field(None, alias="effectiveVat")
    """Effective VAT percentage"""

    discount_prohibited: bool | None = Field(None, alias="discountProhibited")
    """Whether discount is prohibited"""

    use_parent_vat: bool | None = Field(None, alias="useParentVat")
    """Whether to use parent VAT"""
