from pydantic import Field

from moysklad_api.methods.base import MSMethod
from moysklad_api.types.token import Token


class GetToken(MSMethod[Token]):
    """
    Use this method to get token.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/#mojsklad-json-api-obschie-swedeniq-autentifikaciq
    """

    __return__ = Token
    __api_method__ = "security/token"

    username: str = Field(..., alias="username")
    password: str = Field(..., alias="password")
