from pydantic import Field

from moysklad_api.methods import MSMethod
from moysklad_api.types import Product


class GetProduct(MSMethod):
    """
    Use this method to get product by id.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/dictionaries/#suschnosti-towar
    """

    __return__ = Product
    __api_method__ = "entity/product"

    id: str = Field(..., alias="product_id")
