from pydantic import Field

from moysklad_api.methods import GetAudit
from moysklad_api.types import Event, MetaArray


class GetEvents(GetAudit):
    """
    Use this method to get audit events.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/#/audit/audit#3-sobytiya
    """

    __return__ = MetaArray[Event]
    __api_method__ = "audit/{id}/events"

    id: str = Field(..., alias="audit_id")
