from pydantic import Field

from moysklad_api.methods import MSMethod
from moysklad_api.types import Demand


class GetDemand(MSMethod):
    """
    Use this method to get demand by id.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/#/documents/demand#3-poluchit-otgruzku
    """

    __return__ = Demand
    __api_method__ = "entity/demand"

    id: str = Field(..., alias="demand_id")
