from pydantic import Field

from moysklad_api.methods import MSMethod
from moysklad_api.types import Counterparty


class GetCounterparty(MSMethod):
    """
    Use this method to get counterparty by id.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/#/dictionaries/counterparty#3-poluchit-kontragenta
    """

    __return__ = Counterparty
    __api_method__ = "entity/counterparty"

    id: str = Field(..., alias="counterparty_id")
