from pydantic import Field

from moysklad_api.methods import MSMethod
from moysklad_api.types import Audit


class GetAudit(MSMethod):
    """
    Use this method to get audit by id.

    Source: https://dev.moysklad.ru/doc/api/remap/1.2/#/audit/audit#1-audit
    """

    __return__ = Audit
    __api_method__ = "audit"

    id: str = Field(..., alias="audit_id")
