def build_filters(
    filters: dict[str, str | list[str]] | None = None,
) -> str:
    if not filters:
        return ""

    filter_conditions = []
    supported_ops = ["~=", ">=", "<=", "!=", ">", "<", "="]

    for field, value in filters.items():
        operator = "="
        for op in supported_ops:
            if field.endswith(op):
                operator = op
                field = field[: -len(op)]
                break

        if isinstance(value, list):
            for v in value:
                filter_conditions.append(f"{field}{operator}{str(v)}")
        else:
            filter_conditions.append(f"{field}{operator}{str(value)}")

    result = ";".join(filter_conditions)
    return result
