from typing import Any, TypedDict


class DefaultParams(TypedDict, total=False):
    expand: str | None
    """Получить объект вместо ссылки
        https://dev.moysklad.ru/doc/api/remap/1.2/#mojsklad-json-api-obschie-swedeniq-zamena-ssylok-ob-ektami-s-pomosch-u-expand"""

    filters: dict[str, Any]
    """ Словарь с поисковыми условиями.
            Каждое поисковое условие - это сочетание названия поля,
            оператора и константы (оператор по умолчанию - '=')

            Примеры:

            - Точное совпадение: :code:`{"state": "https://api.moysklad.ru/api/remap/1.2/entity/demand/metadata/states/c4224-5399-398253"}`
            - Поиск по подстроке: :code:`{"description~=": "новая поставка"}`

            Source: https://dev.moysklad.ru/doc/api/remap/1.2/#mojsklad-json-api-obschie-swedeniq-fil-traciq-wyborki-s-pomosch-u-parametra-filter"""
    limit: int | None
    """Максимальное количество элементов в списке равно 1000.
        Чтобы получить больше 100 элементов, используйте параметр paginate :"""
    offset: int

    search: str
    """ Контекстный поиск
        https://dev.moysklad.ru/doc/api/remap/1.2/#mojsklad-json-api-obschie-swedeniq-kontextnyj-poisk"""

    order: str
    """Строка с условиями сортировки, перечисленными через ';'.
        Каждое условие сортировки - это сочетание названия поля,
        запятой (опционально, если указывается направление сортировки),
        направления сортировки (опционально: может принимать значения asc и desc.
        Значение по умолчанию - asc).
    Source: https://dev.moysklad.ru/doc/api/remap/1.2/#mojsklad-json-api-obschie-swedeniq-sortirowka-ob-ektow"""

    paginate: bool
    """Используйте этот параметр для получения всех элементов в списке"""
