#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['text2array']

package_data = \
{'': ['*'],
 'text2array': ['.mypy_cache/*',
                '.mypy_cache/3.6/*',
                '.mypy_cache/3.6/collections/*',
                '.mypy_cache/3.6/importlib/*',
                '.mypy_cache/3.6/os/*',
                '.mypy_cache/3.6/text2array/*']}

install_requires = \
['numpy', 'tqdm', 'ordered-set ~=3.1.1']

extras_require = \
{'dev': ['flake8', 'mypy ~=0.770', 'black ~=19.10b0'],
 'doc': ['Sphinx ~=1.8.3',
         'sphinx_rtd_theme',
         'sphinx-autodoc-typehints ~=1.6.0'],
 'test': ['pytest ~=5.2.1', 'pytest-cov']}

setup(name='text2array',
      version='0.2.1',
      description='Convert your NLP text data to arrays!',
      author='Kemal Kurniawan',
      author_email='kemal@kkurniawan.com',
      url='https://github.com/kmkurn/text2array',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.6,<4',
     )
