# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import Any, AsyncIterable, Callable, Dict, Generic, List, Optional, TypeVar
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse, HttpRequest

from ... import models

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class DigitalTwinsOperations:
    """DigitalTwinsOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :ivar models: Alias to model classes used in this operation group.
    :type models: ~azure.digitaltwins.core.models
    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    models = models

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    async def get_by_id(
        self,
        id: str,
        digital_twins_get_by_id_options: Optional["models.DigitalTwinsGetByIdOptions"] = None,
        **kwargs
    ) -> object:
        """Retrieves a digital twin.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The digital twin id is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param digital_twins_get_by_id_options: Parameter group.
        :type digital_twins_get_by_id_options: ~azure.digitaltwins.core.models.DigitalTwinsGetByIdOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object, or the result of cls(response)
        :rtype: object
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[object]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_get_by_id_options is not None:
            _traceparent = digital_twins_get_by_id_options.traceparent
            _tracestate = digital_twins_get_by_id_options.tracestate
        api_version = "2020-10-31"

        # Construct URL
        url = self.get_by_id.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('object', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_by_id.metadata = {'url': '/digitaltwins/{id}'}  # type: ignore

    async def add(
        self,
        id: str,
        twin: object,
        if_none_match: Optional[str] = "*",
        digital_twins_add_options: Optional["models.DigitalTwinsAddOptions"] = None,
        **kwargs
    ) -> Optional[object]:
        """Adds or replaces a digital twin.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The digital twin id or payload is invalid.
          * ModelDecommissioned - The model for the digital twin is decommissioned.
          * TwinLimitReached - The maximum number of digital twins allowed has been reached.
          * ValidationFailed - The digital twin payload is not valid.

        * 412 Precondition Failed

          * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param twin: The digital twin instance being added. If provided, the $dtId property is ignored.
        :type twin: object
        :param if_none_match: Only perform the operation if the entity does not already exist.
        :type if_none_match: str
        :param digital_twins_add_options: Parameter group.
        :type digital_twins_add_options: ~azure.digitaltwins.core.models.DigitalTwinsAddOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object, or the result of cls(response)
        :rtype: object or None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Optional[object]]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_add_options is not None:
            _traceparent = digital_twins_add_options.traceparent
            _tracestate = digital_twins_add_options.tracestate
        api_version = "2020-10-31"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.add.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(twin, 'object')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        deserialized = None
        if response.status_code == 200:
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
            deserialized = self._deserialize('object', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    add.metadata = {'url': '/digitaltwins/{id}'}  # type: ignore

    async def delete(
        self,
        id: str,
        digital_twins_delete_options: Optional["models.DigitalTwinsDeleteOptions"] = None,
        **kwargs
    ) -> None:
        """Deletes a digital twin. All relationships referencing the digital twin must already be deleted.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The digital twin id is invalid.
          * RelationshipsNotDeleted - The digital twin contains relationships.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.

        * 412 Precondition Failed

          * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param digital_twins_delete_options: Parameter group.
        :type digital_twins_delete_options: ~azure.digitaltwins.core.models.DigitalTwinsDeleteOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        _if_match = None
        if digital_twins_delete_options is not None:
            _traceparent = digital_twins_delete_options.traceparent
            _tracestate = digital_twins_delete_options.tracestate
            _if_match = digital_twins_delete_options.if_match
        api_version = "2020-10-31"

        # Construct URL
        url = self.delete.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete.metadata = {'url': '/digitaltwins/{id}'}  # type: ignore

    async def update(
        self,
        id: str,
        patch_document: List[object],
        digital_twins_update_options: Optional["models.DigitalTwinsUpdateOptions"] = None,
        **kwargs
    ) -> None:
        """Updates a digital twin.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The digital twin id or payload is invalid.
          * JsonPatchInvalid - The JSON Patch provided is invalid.
          * ValidationFailed - Applying the patch results in an invalid digital twin.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.

        * 412 Precondition Failed

          * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param patch_document: An update specification described by JSON Patch. Updates to property
         values and $model elements may happen in the same request. Operations are limited to add,
         replace and remove.
        :type patch_document: list[object]
        :param digital_twins_update_options: Parameter group.
        :type digital_twins_update_options: ~azure.digitaltwins.core.models.DigitalTwinsUpdateOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        _if_match = None
        if digital_twins_update_options is not None:
            _traceparent = digital_twins_update_options.traceparent
            _tracestate = digital_twins_update_options.tracestate
            _if_match = digital_twins_update_options.if_match
        api_version = "2020-10-31"
        content_type = kwargs.pop("content_type", "application/json-patch+json")

        # Construct URL
        url = self.update.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(patch_document, '[object]')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 204:
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    update.metadata = {'url': '/digitaltwins/{id}'}  # type: ignore

    async def get_relationship_by_id(
        self,
        id: str,
        relationship_id: str,
        digital_twins_get_relationship_by_id_options: Optional["models.DigitalTwinsGetRelationshipByIdOptions"] = None,
        **kwargs
    ) -> object:
        """Retrieves a relationship between two digital twins.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The digital twin id or relationship id is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.
          * RelationshipNotFound - The relationship was not found.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param relationship_id: The id of the relationship. The id is unique within the digital twin
         and case sensitive.
        :type relationship_id: str
        :param digital_twins_get_relationship_by_id_options: Parameter group.
        :type digital_twins_get_relationship_by_id_options: ~azure.digitaltwins.core.models.DigitalTwinsGetRelationshipByIdOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object, or the result of cls(response)
        :rtype: object
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[object]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_get_relationship_by_id_options is not None:
            _traceparent = digital_twins_get_relationship_by_id_options.traceparent
            _tracestate = digital_twins_get_relationship_by_id_options.tracestate
        api_version = "2020-10-31"

        # Construct URL
        url = self.get_relationship_by_id.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'relationshipId': self._serialize.url("relationship_id", relationship_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('object', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_relationship_by_id.metadata = {'url': '/digitaltwins/{id}/relationships/{relationshipId}'}  # type: ignore

    async def add_relationship(
        self,
        id: str,
        relationship_id: str,
        relationship: object,
        if_none_match: Optional[str] = "*",
        digital_twins_add_relationship_options: Optional["models.DigitalTwinsAddRelationshipOptions"] = None,
        **kwargs
    ) -> object:
        """Adds a relationship between two digital twins.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The digital twin id, relationship id, or payload is invalid.
          * InvalidRelationship - The relationship is invalid.
          * OperationNotAllowed - The relationship cannot connect to the same digital twin.
          * ValidationFailed - The relationship content is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.
          * TargetTwinNotFound - The digital twin target of the relationship was not found.

        * 412 Precondition Failed

          * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param relationship_id: The id of the relationship. The id is unique within the digital twin
         and case sensitive.
        :type relationship_id: str
        :param relationship: The data for the relationship.
        :type relationship: object
        :param if_none_match: Only perform the operation if the entity does not already exist.
        :type if_none_match: str
        :param digital_twins_add_relationship_options: Parameter group.
        :type digital_twins_add_relationship_options: ~azure.digitaltwins.core.models.DigitalTwinsAddRelationshipOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object, or the result of cls(response)
        :rtype: object
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[object]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_add_relationship_options is not None:
            _traceparent = digital_twins_add_relationship_options.traceparent
            _tracestate = digital_twins_add_relationship_options.tracestate
        api_version = "2020-10-31"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.add_relationship.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'relationshipId': self._serialize.url("relationship_id", relationship_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        if if_none_match is not None:
            header_parameters['If-None-Match'] = self._serialize.header("if_none_match", if_none_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(relationship, 'object')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('object', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    add_relationship.metadata = {'url': '/digitaltwins/{id}/relationships/{relationshipId}'}  # type: ignore

    async def delete_relationship(
        self,
        id: str,
        relationship_id: str,
        digital_twins_delete_relationship_options: Optional["models.DigitalTwinsDeleteRelationshipOptions"] = None,
        **kwargs
    ) -> None:
        """Deletes a relationship between two digital twins.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The digital twin id or relationship id is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.
          * RelationshipNotFound - The relationship was not found.

        * 412 Precondition Failed

          * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param relationship_id: The id of the relationship. The id is unique within the digital twin
         and case sensitive.
        :type relationship_id: str
        :param digital_twins_delete_relationship_options: Parameter group.
        :type digital_twins_delete_relationship_options: ~azure.digitaltwins.core.models.DigitalTwinsDeleteRelationshipOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        _if_match = None
        if digital_twins_delete_relationship_options is not None:
            _traceparent = digital_twins_delete_relationship_options.traceparent
            _tracestate = digital_twins_delete_relationship_options.tracestate
            _if_match = digital_twins_delete_relationship_options.if_match
        api_version = "2020-10-31"

        # Construct URL
        url = self.delete_relationship.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'relationshipId': self._serialize.url("relationship_id", relationship_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    delete_relationship.metadata = {'url': '/digitaltwins/{id}/relationships/{relationshipId}'}  # type: ignore

    async def update_relationship(
        self,
        id: str,
        relationship_id: str,
        patch_document: List[object],
        digital_twins_update_relationship_options: Optional["models.DigitalTwinsUpdateRelationshipOptions"] = None,
        **kwargs
    ) -> None:
        """Updates the properties on a relationship between two digital twins.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The digital twin id or relationship id is invalid.
          * InvalidRelationship - The relationship is invalid.
          * JsonPatchInvalid - The JSON Patch provided is invalid.
          * ValidationFailed - The relationship content is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.
          * RelationshipNotFound - The relationship was not found.

        * 409 Conflict

          * RelationshipAlreadyExists - The relationship already exists.

        * 412 Precondition Failed

          * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param relationship_id: The id of the relationship. The id is unique within the digital twin
         and case sensitive.
        :type relationship_id: str
        :param patch_document: JSON Patch description of the update to the relationship properties.
        :type patch_document: list[object]
        :param digital_twins_update_relationship_options: Parameter group.
        :type digital_twins_update_relationship_options: ~azure.digitaltwins.core.models.DigitalTwinsUpdateRelationshipOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        _if_match = None
        if digital_twins_update_relationship_options is not None:
            _traceparent = digital_twins_update_relationship_options.traceparent
            _tracestate = digital_twins_update_relationship_options.tracestate
            _if_match = digital_twins_update_relationship_options.if_match
        api_version = "2020-10-31"
        content_type = kwargs.pop("content_type", "application/json-patch+json")

        # Construct URL
        url = self.update_relationship.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'relationshipId': self._serialize.url("relationship_id", relationship_id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(patch_document, '[object]')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    update_relationship.metadata = {'url': '/digitaltwins/{id}/relationships/{relationshipId}'}  # type: ignore

    def list_relationships(
        self,
        id: str,
        relationship_name: Optional[str] = None,
        digital_twins_list_relationships_options: Optional["models.DigitalTwinsListRelationshipsOptions"] = None,
        **kwargs
    ) -> AsyncIterable["models.RelationshipCollection"]:
        """Retrieves the relationships from a digital twin.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The digital twin id is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param relationship_name: The name of the relationship.
        :type relationship_name: str
        :param digital_twins_list_relationships_options: Parameter group.
        :type digital_twins_list_relationships_options: ~azure.digitaltwins.core.models.DigitalTwinsListRelationshipsOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either RelationshipCollection or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.digitaltwins.core.models.RelationshipCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.RelationshipCollection"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_list_relationships_options is not None:
            _traceparent = digital_twins_list_relationships_options.traceparent
            _tracestate = digital_twins_list_relationships_options.tracestate
        api_version = "2020-10-31"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            if _traceparent is not None:
                header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
            if _tracestate is not None:
                header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.list_relationships.metadata['url']  # type: ignore
                path_format_arguments = {
                    'id': self._serialize.url("id", id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if relationship_name is not None:
                    query_parameters['relationshipName'] = self._serialize.query("relationship_name", relationship_name, 'str')
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('RelationshipCollection', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    list_relationships.metadata = {'url': '/digitaltwins/{id}/relationships'}  # type: ignore

    def list_incoming_relationships(
        self,
        id: str,
        digital_twins_list_incoming_relationships_options: Optional["models.DigitalTwinsListIncomingRelationshipsOptions"] = None,
        **kwargs
    ) -> AsyncIterable["models.IncomingRelationshipCollection"]:
        """Retrieves all incoming relationship for a digital twin.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The digital twin id is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param digital_twins_list_incoming_relationships_options: Parameter group.
        :type digital_twins_list_incoming_relationships_options: ~azure.digitaltwins.core.models.DigitalTwinsListIncomingRelationshipsOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either IncomingRelationshipCollection or the result of cls(response)
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.digitaltwins.core.models.IncomingRelationshipCollection]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.IncomingRelationshipCollection"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_list_incoming_relationships_options is not None:
            _traceparent = digital_twins_list_incoming_relationships_options.traceparent
            _tracestate = digital_twins_list_incoming_relationships_options.tracestate
        api_version = "2020-10-31"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            if _traceparent is not None:
                header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
            if _tracestate is not None:
                header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.list_incoming_relationships.metadata['url']  # type: ignore
                path_format_arguments = {
                    'id': self._serialize.url("id", id, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize('IncomingRelationshipCollection', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.ErrorResponse, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return AsyncItemPaged(
            get_next, extract_data
        )
    list_incoming_relationships.metadata = {'url': '/digitaltwins/{id}/incomingrelationships'}  # type: ignore

    async def send_telemetry(
        self,
        id: str,
        message_id: str,
        telemetry: object,
        telemetry_source_time: Optional[str] = None,
        digital_twins_send_telemetry_options: Optional["models.DigitalTwinsSendTelemetryOptions"] = None,
        **kwargs
    ) -> None:
        """Sends telemetry on behalf of a digital twin.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The digital twin id or message id is invalid.
          * ValidationFailed - The telemetry content is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param message_id: A unique message identifier (in the scope of the digital twin id) that is
         commonly used for de-duplicating messages.
        :type message_id: str
        :param telemetry: The telemetry measurements to send from the digital twin.
        :type telemetry: object
        :param telemetry_source_time: An RFC 3339 timestamp that identifies the time the telemetry was
         measured.
        :type telemetry_source_time: str
        :param digital_twins_send_telemetry_options: Parameter group.
        :type digital_twins_send_telemetry_options: ~azure.digitaltwins.core.models.DigitalTwinsSendTelemetryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_send_telemetry_options is not None:
            _traceparent = digital_twins_send_telemetry_options.traceparent
            _tracestate = digital_twins_send_telemetry_options.tracestate
        api_version = "2020-10-31"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.send_telemetry.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        header_parameters['Message-Id'] = self._serialize.header("message_id", message_id, 'str')
        if telemetry_source_time is not None:
            header_parameters['Telemetry-Source-Time'] = self._serialize.header("telemetry_source_time", telemetry_source_time, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(telemetry, 'object')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    send_telemetry.metadata = {'url': '/digitaltwins/{id}/telemetry'}  # type: ignore

    async def send_component_telemetry(
        self,
        id: str,
        component_path: str,
        message_id: str,
        telemetry: object,
        telemetry_source_time: Optional[str] = None,
        digital_twins_send_component_telemetry_options: Optional["models.DigitalTwinsSendComponentTelemetryOptions"] = None,
        **kwargs
    ) -> None:
        """Sends telemetry on behalf of a component in a digital twin.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The digital twin id, message id, or component path is invalid.
          * ValidationFailed - The telemetry content is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.
          * ComponentNotFound - The component path was not found.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param component_path: The name of the DTDL component.
        :type component_path: str
        :param message_id: A unique message identifier (in the scope of the digital twin id) that is
         commonly used for de-duplicating messages.
        :type message_id: str
        :param telemetry: The telemetry measurements to send from the digital twin's component.
        :type telemetry: object
        :param telemetry_source_time: An RFC 3339 timestamp that identifies the time the telemetry was
         measured.
        :type telemetry_source_time: str
        :param digital_twins_send_component_telemetry_options: Parameter group.
        :type digital_twins_send_component_telemetry_options: ~azure.digitaltwins.core.models.DigitalTwinsSendComponentTelemetryOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_send_component_telemetry_options is not None:
            _traceparent = digital_twins_send_component_telemetry_options.traceparent
            _tracestate = digital_twins_send_component_telemetry_options.tracestate
        api_version = "2020-10-31"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.send_component_telemetry.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'componentPath': self._serialize.url("component_path", component_path, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        header_parameters['Message-Id'] = self._serialize.header("message_id", message_id, 'str')
        if telemetry_source_time is not None:
            header_parameters['Telemetry-Source-Time'] = self._serialize.header("telemetry_source_time", telemetry_source_time, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(telemetry, 'object')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    send_component_telemetry.metadata = {'url': '/digitaltwins/{id}/components/{componentPath}/telemetry'}  # type: ignore

    async def get_component(
        self,
        id: str,
        component_path: str,
        digital_twins_get_component_options: Optional["models.DigitalTwinsGetComponentOptions"] = None,
        **kwargs
    ) -> object:
        """Retrieves a component from a digital twin.
        Status codes:


        * 200 OK
        * 400 Bad Request

          * InvalidArgument - The digital twin id or component path is invalid.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.
          * ComponentNotFound - The component path was not found.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param component_path: The name of the DTDL component.
        :type component_path: str
        :param digital_twins_get_component_options: Parameter group.
        :type digital_twins_get_component_options: ~azure.digitaltwins.core.models.DigitalTwinsGetComponentOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: object, or the result of cls(response)
        :rtype: object
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[object]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        if digital_twins_get_component_options is not None:
            _traceparent = digital_twins_get_component_options.traceparent
            _tracestate = digital_twins_get_component_options.tracestate
        api_version = "2020-10-31"

        # Construct URL
        url = self.get_component.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'componentPath': self._serialize.url("component_path", component_path, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))
        deserialized = self._deserialize('object', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized
    get_component.metadata = {'url': '/digitaltwins/{id}/components/{componentPath}'}  # type: ignore

    async def update_component(
        self,
        id: str,
        component_path: str,
        patch_document: List[object],
        digital_twins_update_component_options: Optional["models.DigitalTwinsUpdateComponentOptions"] = None,
        **kwargs
    ) -> None:
        """Updates a component on a digital twin.
        Status codes:


        * 204 No Content
        * 400 Bad Request

          * InvalidArgument - The digital twin id, component path, or payload is invalid.
          * JsonPatchInvalid - The JSON Patch provided is invalid.
          * ValidationFailed - Applying the patch results in an invalid digital twin.

        * 404 Not Found

          * DigitalTwinNotFound - The digital twin was not found.

        * 412 Precondition Failed

          * PreconditionFailed - The precondition check (If-Match or If-None-Match) failed.

        :param id: The id of the digital twin. The id is unique within the service and case sensitive.
        :type id: str
        :param component_path: The name of the DTDL component.
        :type component_path: str
        :param patch_document: An update specification described by JSON Patch. Updates to property
         values and $model elements may happen in the same request. Operations are limited to add,
         replace and remove.
        :type patch_document: list[object]
        :param digital_twins_update_component_options: Parameter group.
        :type digital_twins_update_component_options: ~azure.digitaltwins.core.models.DigitalTwinsUpdateComponentOptions
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        
        _traceparent = None
        _tracestate = None
        _if_match = None
        if digital_twins_update_component_options is not None:
            _traceparent = digital_twins_update_component_options.traceparent
            _tracestate = digital_twins_update_component_options.tracestate
            _if_match = digital_twins_update_component_options.if_match
        api_version = "2020-10-31"
        content_type = kwargs.pop("content_type", "application/json-patch+json")

        # Construct URL
        url = self.update_component.metadata['url']  # type: ignore
        path_format_arguments = {
            'id': self._serialize.url("id", id, 'str'),
            'componentPath': self._serialize.url("component_path", component_path, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        if _traceparent is not None:
            header_parameters['traceparent'] = self._serialize.header("traceparent", _traceparent, 'str')
        if _tracestate is not None:
            header_parameters['tracestate'] = self._serialize.header("tracestate", _tracestate, 'str')
        if _if_match is not None:
            header_parameters['If-Match'] = self._serialize.header("if_match", _if_match, 'str')
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(patch_document, '[object]')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.ErrorResponse, response)
            raise HttpResponseError(response=response, model=error)

        response_headers = {}
        if response.status_code == 204:
            response_headers['ETag']=self._deserialize('str', response.headers.get('ETag'))

        if cls:
            return cls(pipeline_response, None, response_headers)

    update_component.metadata = {'url': '/digitaltwins/{id}/components/{componentPath}'}  # type: ignore
