# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['single_version']

package_data = \
{'': ['*']}

install_requires = \
['first>=2.0,<3.0']

extras_require = \
{':python_version < "3.8"': ['importlib_metadata>=1.6,<2.0']}

setup_kwargs = {
    'name': 'single-version',
    'version': '1.3.0',
    'description': 'Small utility to define version string for Poetry-style Python project.',
    'long_description': '==============\nsingle-version\n==============\n\n.. image:: https://madewithlove.now.sh/vn?heart=true&colorA=%23ffcd00&colorB=%23da251d\n.. image:: https://badgen.net/pypi/v/single-version\n\nUtility to let you have a single source of version in your code base.\n\nThis utility targets modern Python projects which have layout generated by `Poetry`_, with a *pyproject.toml* file in place of *setup.py*. With this layout, the project initially has two places to maintain version string: one in *pyproject.toml* file and one in some *\\*.py* file (normally *__init__.py*):\n\n.. code-block:: toml\n\n    # pyproject.toml\n    [tool.poetry]\n    name = "your-package"\n    version = "0.1.0"\n\n.. code-block:: python\n\n    # your_package/__init__.py\n    __version__ = "0.1.0"\n\nThis duplicity often leads to inconsistency when you, the author, forget to update both.\n\n*single-version* is born to solve that headache circumstance. By convention, it chooses the *pyproject.toml* file as original source of version string. Your project\'s ``__version__`` variable then is computed from it. When your package is already deployed and installed to some system, the version string will be retrieved from that Python environment (the *pyproject.toml* is not included in distribution file).\n\nYears ago, to retrieve version for an installed package, ones often used `pkg_resources`_, which has well-known issue of causing slow import. Learning from that mistake, *single-version* use |importlib.metadata|_, which becomes standard from Python 3.8, instead.\n\n\nUsage\n-----\n\nAdd ``single_version`` as your project dependency:\n\n.. code-block:: sh\n\n    poetry add single-version\n\n\nAssume that your package source tree is like this::\n\n    .\n    ├── awesome_name\n    │  └── __init__.py\n    ├── pyproject.toml\n    ├── README.rst\n    └── tests/\n\nwhere the ``__version__`` variable is defined in `awesome_name/__init__.py` file. The file content can be like this:\n\n.. code-block:: python\n\n    from pathlib import Path\n\n    from single_version import get_version\n\n\n    __version__ = get_version(\'awesome_name\', Path(__file__).parent.parent)\n\n\nAPI Reference\n-------------\n\n\n*def* **get_version** (package_name: *str*, looked_path: *Path*) -> *str*\n\n- ``package_name``:  Your package\'s name (same as in *pyproject.toml* file).\n\n- ``looked_path`` (of ``pathlib.Path`` type): Folder where your project\'s *pyproject.toml* resides.\n\n\n.. _Poetry: https://python-poetry.org/\n.. _pkg_resources: https://setuptools.readthedocs.io/en/latest/pkg_resources.html\n.. |importlib.metadata| replace:: ``importlib.metadata``\n.. _importlib.metadata: https://docs.python.org/3.8/library/importlib.metadata.html\n',
    'author': 'Nguyễn Hồng Quân',
    'author_email': 'ng.hong.quan@gmail.com',
    'maintainer': 'Nguyễn Hồng Quân',
    'maintainer_email': 'ng.hong.quan@gmail.com',
    'url': 'https://github.com/hongquan/single-version',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
