import setuptools
import versioneer

with open("README.rst", "r") as fh:
    long_description = fh.read()
with open("requirements.txt", "r") as fh:
    requirements = [line.strip() for line in fh]

setuptools.setup(
    name="is_number_rn",
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    author="Quastrado",
    author_email="quastrado@gmail.com",
    description="A Python library to determine if something is a number.",
    long_description=long_description,
    long_description_content_type="text/x-rst",
    package_dir = {'': 'is_number'},
    packages = setuptools.find_packages(where='is_number'),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.6',
    install_requires=requirements,
)
