# -*- coding: utf-8 -*-
# Copyright (c) 2016 - 2020 Sqreen. All rights reserved.
# Please refer to our terms for more information:
#
#     https://www.sqreen.io/terms.html
#
""" Count http status codes
"""
from ..rules import RuleCallback


class CountHTTPCodesCB(RuleCallback):

    INTERRUPTIBLE = False

    def post(self, instance, args, kwargs, **options):
        response = self.storage.get_current_response()
        if response is not None:
            self.record_observation("http_code", str(response.status_code), 1)
